
  > * 原文地址：[Is your site as mobile friendly as you think?](https://boagworld.com/mobile-web/mobile-friendly/)
  > * 原文作者：[Paul Boag](https://boagworld.com/boagworks/)
  > * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
  > * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/mobile-friendly.md](https://github.com/xitu/gold-miner/blob/master/TODO/mobile-friendly.md)
  > * 译者：[Lai](https://github.com/laiyun90)
  > * 校对者：[Tobias Lee](https://github.com/TobiasLee) [starlee](https://github.com/summerstarlee)

 # 你的站点如你所想的移动友好吗？

  我们通常认为响应式的网站会让我们的站点移动友好，但是情况并非如此。仍然有很多方式会搞砸用户体验，并降低我们在搜索结果中的排名。

[![你想得到更多的工作机会吗？更多重复的业务？更多来自客户的尊重？更多的收入？加入我们即将到来的研讨会吧。](https://boagworld-cdn.sirv.com/Images/Blog-Images/UX-Workshop.jpg)](https://boagworld.com/usability/offer-kick-ass-user-experience-services/)

[https://audio.simplecast.com/77569.mp3](https://audio.simplecast.com/77569.mp3)

**收听这篇文章**，并在 [iTunes](https://itunes.apple.com/gb/podcast/digital-insights/id997054983)、[谷歌音乐 App](https://play.google.com/music/m/I5vunhwsonxo2ifhjuxkmh73rse?t=Digital_Insights)、[RSS](http://simplecast.fm/podcasts/1178/rss) 上订阅关注我们 | [下载音频](https://audio.simplecast.com/77569.mp3)

这篇文章由 [交互设计基础](https://www.interaction-design.org/courses?ep=boagworld) 赞助。

我们都知道一个网站 [移动](https://boagworld.com/category/mobile-web/) 友好的重要性，我们中的大多数人采用 [响应式设计](https://www.interaction-design.org/literature/topics/responsive-design?ep=boagworld) 作为解决方案。毫无疑问，响应式 [设计](https://boagworld.com/category/design/) 已经改变了移动网络。一般来说，它提高了 [用户体验](https://boagworld.com/category/usability/)、使网站更易管理、并避免维护多个版本的需要。

最近当我浏览 [交互设计基础](https://www.interaction-design.org/?ep=boagworld) 的课程时，我思考了一些东西。我看到一个 [关于移动用户体验设计的课程](https://www.interaction-design.org/courses/mobile-user-experience-design/?ep=boagworld)，我意识到，尽管响应式网站很好，但它绝不是一颗银弹。

参见：[你从未听说过的最重要的 UX 教育来源](https://boagworld.com/reviews/important-source-ux-education-youve-never-heard/)

通常，响应式设计可能被实现地很糟糕。不幸的是，这也会让我们陷入一种虚假的安全感中。仅仅因为我们采用了响应式设计，我们就认为我们已经「解决了移动性问题」。但事实并非如此。

让我给你举一些例子，说明哪里可能出问题。从最大的问题开始，那就是半吊子的响应式网站。

### 你的全部站点具有响应性吗？

当你从零开始重新设计网站时，以一种响应式的方式来构建是完全有意义的。但是用这种方式对现有网站（特别是大型网站）进行响应式改造时，可能会是一场噩梦。

> 响应式网站设计会让我们陷入一种虚假的安全感。我们认为我们已经解决了移动问题。

[戳这里推特一下](https://twitter.com/intent/tweet?source=webclient&amp;text=Responsive+web+design+lulls+us+into+a+false+sense+of+security.+We+think+we+have+solved+the+mobile+problem.+via+http://boagworld.com/mobile-web/mobile-friendly/)

这是我很多客户所面临的问题。大多数他们的网站都至少有上万页，用几年时间构建而成。使其移动友好是极具挑战性的。

为了减少所涉及的工作，他们做了一个决定。他们决定专注于使核心页面移动友好且具有响应性，而忽略其他页面。

尽管我能够理解他们的决定，但从用户体验的角度而言这是很糟糕的。没什么比错误地以为自己正在浏览一个移动友好的网站，但发现自己只是陷于一个不能阅读和浏览的桌面优化网页更令人沮丧的了。

这些组织应该仔细考虑他们是否需要这样大型的网站。就我个人经验而言，他们很少这样做，只是盲目地将内容从一个版本迁移到下一个版本。
另请参见：[为什么对疯狂地内容迁移说不](https://boagworld.com/content-strategy/content-migration/)
### 你是否砍掉了功能？

当遇到一些棘手的功能时，设计师面临着类似的问题。为了做到移动友好，有些东西太复杂了。我们没有加倍努力、找到一个创造性的解决方案，而是选择了一条阻力最小的道路。我们说服自己，移动用户不需要这些功能，只需从网站上去掉这些即可。

当然，这无疑是天真的。移动用户并没有什么神奇的差异。他们也是那些在桌面上使用你站点的用户，只是刚刚换了设备。见鬼，我甚至看见他们坐在离笔记本电脑触手可及的地方使用手机！我们不能仅仅基于设备就对他们的需求做出假设。

### 你是否支持触摸手势？

但是移动友好的错误并不全在于去掉功能。无法添加一些功能可能同样危险。比如，对触摸手势的支持。用户在移动网站无法滑动和缩放时，难怪他们往往会更喜欢移动应用。 

![](https://boagworld-cdn.sirv.com/Images/Blog-Images/mobile-friendly-01.jpg?profile=Medium&amp;quality=60&amp;scale.width=1560)

这么多的手势，我们都不支持。
作为网站设计师，我们真的应该允许用户滑动轮播图和缩放图片。这种功能需求通常会被忽视，因为我们是如此专注于为不同的断点调整设计。

### 你的内容适用于你的设计吗？

要做到移动友好并不仅仅是改变设计，也需要改变内容本身。以表单为例，我们在拥有更大屏幕的设备（桌面）上用表单来呈现数据，并不意味着我们也要在移动设备上这样做。我们可能会得出这样的结论：显示一个交互式图表或某种形式的计算器更具有移动友好性。

![](https://boagworld-cdn.sirv.com/Images/Blog-Images/mobile-friendly-02.gif?profile=Small&amp;quality=60&amp;scale.width=1148)

我们需要调整内容而不仅仅是设计，将表单和图表变成更具移动友好的形式。
下面说说信息图表。他们在大屏幕看起来很棒，但是在移动设备上变得难以辨认。当然我们也可以让用户自己去缩放查看，并号称我们该做的都做完了，或者我们可以重新进行设计。也许我们应该将信息图表分解成一个情节串联板（storyboard）或者用视频来代替。

### 你的移动站点是否具有可读性？

可读性的问题并不仅仅局限于图像和表格，文本内容也有同样的问题。仅仅增加一个断点来重新定位元素并不能创造移动友好性并提高可读性体验。它经常大大缩短本文行的长度导致阅读变得痛苦。

设计师们在这方面做了一些努力，包括使字体大小相较于断点自动进行缩小。但是我在移动设备上访问过的很多站点的字体仍然会变的很小，以致难以辨识。

最后，还有颜色的问题。设计师通常未能考虑到移动用户总是与屏幕眩光作斗争，所以会设计微妙的颜色色调。毫不夸张地说，这会导致很差的移动阅读体验。

![](https://boagworld-cdn.sirv.com/Images/Blog-Images/mobile-friendly-03.jpg?profile=Medium&amp;quality=60&amp;scale.width=1560)

Doctors Without Borders 只是许多难以做到可读性的移动站点之一。时常存在单行长度过短、颜色对比糟糕和文本过小的问题。

### 你是否过于关注最新最好的智能手机？

当然，即使我们在移动设备上，这些可读性问题还是看不出来。这是因为我们拥有最新最强大的智能手机。它有一个 retina 屏幕，亮度的耀眼程度连太阳也无法与之匹敌！但是不是每个人都有这样的设备。即使你忽略功能型手机，体验也会有巨大的差异。 

> 我们需要停止使用脑海中的具体设备进行设计。

[推特一下这个](https://twitter.com/intent/tweet?source=webclient&amp;text=We+need+to+stop+designing+with+specific+devices+in+mind.+via+http://boagworld.com/mobile-web/mobile-friendly/)

当然，肯定会有断点的存在。我仍然看到设计师们根据设备设置断点，而不是根据内容的适当位置。他们设计了适配 iPad 的尺寸、适配 iPhone 的尺寸等等。但是实际上，设备尺寸是非常多的，我们应该停止考虑特定的设备。 

### 你的性能移动友好吗？

我们应该考虑性能问题。事实上，这可能是响应式设计让我们失望的唯一的、最大的领域。可千万别误会，我并不是说响应式设计让我们的站点变慢了。只是因为我们并没有做些什么来改善它，而这正是移动设备所需要的。

图像大小无疑是罪魁祸首。使用媒体查询可能会在视觉上缩小图片的比例，但是对减少图片大小和加载时间是没有帮助的。在使用蜂窝网络时，这是很不好的。添加字体、库、框架以及所有的其他元素，都会使今天的网站膨胀，导致加载时间过长。

![](https://boagworld-cdn.sirv.com/Images/Blog-Images/mobile-friendly-04.jpg?profile=Small&amp;quality=60&amp;scale.width=1148)

在移动设备上测试站点的性能会令人沮丧！
但是这不仅仅是下载大小和蜂窝网络速度的问题。性能也是影响设备的一个问题。很多移动设备缺乏像笔记本电脑、台式电脑或平板电脑一样的处理能力。结果是，它们很难处理一些建立在许多现代网站的更密集的 Javascript。

### 填写数据会移动友好吗？

接下来，我们来看看在移动设备上输入数据时，我遇到的一个特殊的 bug。也许是因为我老了，不能以每小时一百万英里的速度在这些小型虚拟键盘上打字，但是在移动设备上输入数据体验确实很糟糕。

作为网页设计师，我们似乎让网站的问题恶化了一百倍。当输入数值数据时，无法显示数值键盘。当输入密码时，我们会隐藏用户正在输入的内容，尽管事实上在移动设备上输入错误是常有的事儿。其实，我们就根本不应该指望移动用户填写密码。还有其他方法，比如文本通知、电子邮件链接或者 Touch ID。

![](https://boagworld-cdn.sirv.com/Images/Blog-Images/mobile-friendly-05.jpg?profile=Medium&amp;quality=60&amp;scale.width=1560)

Slack 在避免用户输入密码方面做得很好。

有很多种情况下可以避免或简化数据输入。在会话之间记住用户的登录用户名是一个好的开始。但是我们应该改进表单的设计，避免繁琐的表单元素，比如日期选择或冗长的下拉菜单。

### 链接之间是否太过紧密？

谈到复杂的交互，我惊讶地发现设计师似乎很少考虑使用触摸屏所带来的挑战。我发现很多网站声称移动友好，但是与之交互时却发现并非如此。为最大化屏幕使用率，链接和按钮往往排列的非常紧密，以至于变得不能被点击。

再者，仅仅重新定位内容是不够的。我们需要确保元素周围的空间扩大，以避免由于使用手指而导致的精确度不足。诚然，空间是非常宝贵的，但是如果我们明智地利用空间，链接就没有理由不易被选择。只要看看大多数的移动应用程序就懂了。
另见：[移动 UX 设计](https://www.interaction-design.org/literature/topics/mobile-ux-design?ep=boagworld)
### 用户必须忍受位置固定的内容吗？

谈到空间的缺乏的问题，为什么尽管所有的设计师都希望创建一个移动友好的站点，但是我们认为在页面上添加固定位置的内容是可接受的。这显著减少了其他内容元素的可用空间。

将位置固定的导航转移到你站点的移动视图之前，请仔细考虑。同样，消除那些覆盖页面和对话窗口，以及那些固定位置的社交媒体图标时也需仔细考虑。它们在移动站点上没有位置。

![](https://boagworld-cdn.sirv.com/Images/Blog-Images/mobile-friendly-06.jpg?profile=Small&amp;quality=60&amp;scale.width=1148)

由于固定位置的元素数量，Mashable 上的内容几乎不能在移动设备上阅读。

### 我是一个可怕的伪君子

如果你在移动设备上浏览这个网站，你可能会想我现在是多么虚伪。我使用位置固定的导航、在某些地方链接过于紧密并且陷入我之前概述的其他错误中。

我的理由与你一样，缺乏时间和金钱。对我来说让网站响应并认为它移动友好是更容易的。但是自从我设计了这个站点，随着手机变得越来越重要，世界发生了变化。

Google 和其他搜索引擎都开始惩罚在搜索结果中未能提供良好移动友好体验的网站。在移动设备上浏览站点的用户数量正在猛涨。一个简单的响应式网站将不再够用。如果我们想要提供一个良好的体验或者在搜索引擎中有一个较好的排名，就更加远远不够了。

我们将不得不调整我们的优先级，以便创造一个移动友好的体验。这与一个伟大的桌面体验同样重要（甚至更加重要）。

### [注册移动用户体验设计课程](https://www.interaction-design.org/courses/mobile-user-experience-design/?ep=boagworld)

**移动使用量早在 2014 年就超过了台式机。从那时起，设备间的差距就只增不减，随着手机使用量的增加，台式机的用户流失增加了一倍。移动流量的这种增长，使移动用户体验成为一个产品或者网站成功的最重要的原因之一。这意味着，如果想跟上时代，设计师、营销人员和开发人员所涉及的技能绝对是非常重要的。这个课程将教会你如何做 — [设计优秀的移动用户界面，着眼于移动可用性最佳实践](https://www.interaction-design.org/courses/mobile-user-experience-design/?ep=boagworld)。**

  ---

  > [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
  
