> * 原文地址：[Mobile Design Best Practices](http://babich.biz/mobile-design-best-practices/)
* 原文作者：[Nick Babich](http://babich.biz/about/)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[Gocy](https://github.com/Gocy015)
* 校对者：[phxnirvana](https://github.com/phxnirvana), [XHShirley](https://github.com/XHShirley)
 
# 移动端设计最佳实践

App 已经成为了能够可靠地展现内容并提供服务的主流平台。但在琳琅满目的  App 市场中，一个移动应用要怎么做才能称得上实用、贴近用户并且具有价值，又能满足并留住用户呢？

本文将介绍 7 个能够提供绝佳移动应用用户体验的 UX 设计准则。


 
# 1\. 一个界面，一个任务

**让用户以更少的步骤完成他们想要的操作**

你的 App 中的每一个界面都应该支持使用者**仅需操作一次，便可达到目的**。每个界面都应该设计成为某一独立功能而服务的，并且不需要做超过一次的交互操作。这样的设计使得用户上手更简单、操作更便利，在必要时添加功能也手到擒来。 

拿 Uber 来举个例子吧。 Uber 明确地知道自己的用户打开应用就是为了乘车的，应用并没有展示什么冗余的信息：它只是自动定位到用户当前的位置，而用户所需要做的仅仅是选择一个上车地点。

![](http://babich.biz//content/images/2016/11/1.png) 



# 2\. 看不见的用户界面
 
**内容即界面**

将一切无关用户需求的元素移除而专注于展示内容。由于减少了分散注意力的元素，用户应该能够快速被引导至他们所需要的内容。**内容就是界面**。 Google Map 就是一个很好地例子 - Google 在重新设计它的时候，移除了所有非必要的面板和按钮，并说到：**地图，就是用户界面**。

![](http://babich.biz//content/images/2016/11/2.png)


 
# 3\. 空间留白

**利用负领域来让用户注意到重要内容**

空白空间或『负领域』，即设计上在元素的周围、元素和元素之间或界面布局中的空白区域，常常被低估甚至是忽视。尽管很多设计师认为这是对珍贵的屏幕区域的浪费，但空白空间其实是移动设计中一个重要的元素。

> 『空白空间应该被誉为一个动态元素，而不是一个没用的背景』 - Jan Tschichold

空白空间不仅仅能提高界面可读性、区分内容的重要程度，它对于布局布局效果的作用同样重要，也就是说，它能够简化 UI 并提升 UX 。

![](http://babich.biz//content/images/2016/11/3.png)

设计的时候谨遵『化繁为简』的原则。 图片来源： Material Design




# 4\. 将导航简化

**让导航栏一目了然** 

帮助用户在应用间穿梭自如应该是头等大事。移动应用的导航栏应该易于发现、易于操作而且不能占据过多空间。但是，因为和 Chrome 这样桌面浏览器相比，移动端的屏幕更小并更需要突出内容，所以要做出易用的导航栏将颇具挑战性。

[标签栏以及导航栏](https://www.smashingmagazine.com/2016/11/the-golden-rules-of-mobile-navigation-design/) 因其相对较少的导航选项而非常适合移动端应用。它们的出彩之处在于它们可以展示所有重要的导航选项，并且用户只需简单地点击即可实现界面的跳转。

![](http://babich.biz//content/images/2016/11/4.png)

苹果 AppStore 中的导航标签栏。



 
# 5\. 单手操控 

**你的设计需要适配更大的屏幕** 

随着 iPhone 6 和 iPhone 6 Plus 的发布，大屏和更大屏的时代已经来临。

![](http://babich.biz//content/images/2016/11/5.png) 

下图是手机用户最常用的三种操作方式：

![](http://babich.biz//content/images/2016/11/6.png)

大众使用手机的基本方式。数据来源： Steven Hoober


[85% 的受访者](http://www.uxmatters.com/mt/archives/2013/02/how-do-users-really-hold-mobile-devices.php) 习惯单手使用手机，下面的热区图展示了自 2007 年以来，用户的拇指在不同大小的 iPhone 屏幕上的活动区域。**你会发现，屏幕越大，拇指能够舒适触及的区域越小**。

 ![](http://babich.biz//content/images/2016/11/7.png)
 
拇指活动区域。数据来源 Scott Hurff

适配你的设计从而提升用户体验非常必要，试着让你的应用能够让用户简单（并且完全）地在大屏幕上（譬如 iPhone 6 或是 iPhone 7 ）完成单手操作。将导航元素放在拇指能够触及的地方。

![](http://babich.biz//content/images/2016/11/8.png)

Pocket iOS 版。所有导航栏元素都在界面底部，让用户正常使用手机时可以轻松地操作。图片来源： Dmitry Kovalenko




# 6\. 让应用快速展示 

**别让用户等待内容加载**  

尽可能地开发 [流畅并能及时响应操作的应用](http://babich.biz/how-to-make-users-think-your-app-loads-faster/) 。在后台处理事件可以让用户操作的响应看起来更快。将事件分派到后台任务中有两大优点 - 它们无法被用户感知，并且在用户进行实际操作之前，它们已经开始执行了。 Instagram 中的图片上传功能就是个很好的例子，一旦用户选择分享一张图片，它就立刻开始上传了。

![](http://babich.biz//content/images/2016/11/9.png)

Instagram 在后台上传图片的同时建议用户为其添加标签，而这之后当用户真正要点击分享按钮的时候，上传很可能已经完成，此时便可以立刻分享他们的图片了。


 

# 7\. 慎用推送通知

**发推送之前请三思**  

日复一日，用户被毫无用处的推送信息狂轰滥炸，极大地影响了他们的日常活动并且带来了许多烦恼。**烦人的推送通知是用户卸载移动应用的首要原因（71% 的受访者）。**

![](http://babich.biz//content/images/2016/11/10.png)

移动终端的宗旨应该是让每条消息物有所值。不要发那些以『让他们打开应用』为目的的通知，当且仅当你认为这条消息 [对用户有价值](http://babich.biz/how-to-create-mobile-notifications-that-users-actually-want/) 的时候才进行推送。

**小贴士：**建立一个有效的移动应用通知体系的最优策略应该是使用多元的消息类型 - 推送通知、邮件提醒、应用内通知以及新消息通知。让消息多样化 - 多种消息应该能完美的协同工作来为用户创造上佳的体验。

![](http://babich.biz//content/images/2016/11/11.jpeg)
 

根据紧急程度和内容来选择合适的推送手段。 来源： Appboy




# 总结

移动应用设计中最重要的就是要让应用既实用又直观。如果一个应用缺乏实用性，那么它对用户而言没有任何实际价值，用户也就没有理由使用它了。如果一个应用非常实用但却需要花费许多时间和精力才能学会使用，用户是不会花那么多时间来学习使用的。而一个好的 UI 以及 UX 设计最终就是要解决上述的两个问题。

感谢阅读！
	