> * 原文地址：[Making Sense of Ethereum’s Layer 2 Scaling Solutions: State Channels, Plasma, and Truebit](https://medium.com/l4-media/making-sense-of-ethereums-layer-2-scaling-solutions-state-channels-plasma-and-truebit-22cb40dcc2f4)
> * 原文作者：[Josh Stark](https://medium.com/@jjmstark?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/making-sense-of-ethereums-layer-2-scaling-solutions-state-channels-plasma-and-truebit.md](https://github.com/xitu/gold-miner/blob/master/TODO/making-sense-of-ethereums-layer-2-scaling-solutions-state-channels-plasma-and-truebit.md)
> * 译者：[JohnJiangLA](https://github.com/JohnJiangLA)
> * 校对者：[foxxnuaa](https://github.com/foxxnuaa) [Zheaoli](https://github.com/zheaoli)

# 带你了解以太坊第2层扩容方案：状态通道（State Channels）、Plasma 和 Truebit

![](https://user-gold-cdn.xitu.io/2018/3/9/16208aa54b6f99b5?w=800&h=588&f=jpeg&s=162592)

宾夕法尼亚州 Tunkhannock 地区铁路高架桥（[cc](https://www.flickr.com/photos/library_of_congress/5715531287)）。古罗马的建筑理念在新时代的使用。

对于以太坊来说 [2018 年是着力基础建设的一年](https://twitter.com/L4ventures/status/953041925241757697)。今年是初期用户来测试网络极限的一年，并将重新关注一些扩展以太坊的技术。

**以太坊至今仍处于成长初期**。 现今，它还[不是安全的或者可扩展的](https://twitter.com/VladZamfir/status/838006311598030848)。技术人员能够很清楚的认识到这一点。但是在去年，大量 ICO 所导致的炒作已经开始夸大目前的网络能力。构建一个安全，易于使用的去中心化互联网，受约于一套通用经济规范并被无数人使用，以太坊和 web3 提出的这一美好承诺就在眼前，但[只有在建立关键基础设施的前提下才能够实现](https://twitter.com/granthummer/status/957353619736559616)。

致力于构建这种基础架构和扩展以太坊性能的项目通常被称为 **扩展方案（scaling solutions）** 。这些项目有着不同的形式，并且通常相互兼容或互补。

在这篇长帖中，我想要深入讲解**一**种扩展方案：**“off-chain” 或 “第二层（layer 2）” 方案。**

*   **首先**，我们会全面的讨论下以太坊（以及所有公有的区块链）的扩展难题。
*   **其次**，我们将介绍解决扩展难题的不同方法，区分 “layer 1” 和 “layer 2” 解决方案。
*   **最后**，我们会深入了解第二层（layer 2）解决方案并详细解释它是怎样运作的，我们会谈及 [**状态通道（state channels）**](https://medium.com/l4-media/generalized-state-channels-on-ethereum-de0357f5fb44)**，**[**Plasma**](http://plasma.io/) **和**  [**Truebit**](http://truebit.io)。

**本文的重点在于给读者全面而详细的讲解第二层（layer 2）解决方案的概念与工作原理**。但我们不会深入研究代码或特定实现。相反，我们专注理解用于构建这些系统的经济机制以及所有第二层技术之间共同的思维模式。

* * *

### 1. 公有区块链的扩展难题

首先，你要知道“扩展”不是一个单一的、特定的问题，**它涉及了一系列难题，必须解决这些难题才能使以太坊对全球无数用户可用。**

最常讨论的扩展难题是交易通量。目前，以太坊每秒可以处理大约 15 笔交易，而 Visa 的处理能力则大约在 45,000/tps。在去年，一些应用程序（比如 [Cryptokitties](http://cryptokitties.co) 或偶尔的 ICO）已经足够流行以至于“放缓了”网络速度并提升了[挖矿费用（gas）](https://myetherwallet.github.io/knowledge-base/gas/what-is-gas-ethereum.html) 的价格。

**公有区块链（比如以太坊）最核心的缺陷是要求每一笔交易要被网络中的每一个节点处理。**一笔支付，Cryptokitty 的诞生，部署新的 ERC20 合约，每一个以太坊区块链上发生的操作都必须由网络中的每个节点并行执行。这是设计理念所决定的，也正是由于这种设计理念才使得公有区块链具有权威性。节点不需要依赖**其他**节点来告诉他们当前区块链的当前状态，它们会自己计算出来。

**这给以太坊的交易通量带来了根本性的限制**：它不能超过我们对于单个节点的设计要求。。

我们**可以**要求每个节点做更多的工作，如果我们将块大小加倍(例如，区块 gas 限制)，这意味着每个节点处理每个区块的工作量大致是之前的两倍。但是这样就减弱了系统的分散化理念：节点要做更多的工作意味着性能较差的计算机（比如用户设备）可能会从网络中退出，并且挖矿也会更向性能强大的节点运营者集中。

相反，我们需要一种方式使区块链**做更多有用的事**，但并不是增加单个节点的工作量。

从概念上来说，[有两种可能解决这个问题的方法](https://blog.ethereum.org/2018/01/02/ethereum-scalability-research-development-subsidy-programs/)：

#### **一. 如果每个节点不必并行处理每个操作，会怎样？**

第一种方法是抛弃我们的前提，如果我们可以构建一个每个节点不必处理每个操作的区块链，会怎样？如果网络分为两个部分代替原有网络，每一个部分都可以独立运行，会怎样？

A 部分可以处理一批交易，而同时 B 部分可以处理另一批。这实际上会使区块链的交易通量翻倍。因为我们的限制现在能够被**两**个节点同时处理。如果我们可以将区块链分为许多不同的部分，那么我们可以将区块链的通量提高很多倍。

这是**分片**（**sharding**）的思维模式，也是 Vitalik 的[以太坊研究小组（Ethereum Research group）](http://ethereumresearch.org/) 和其他社群正在研究的一种扩展方案。一个区块链被分割成叫做 **shards** 的不同部分，每一个部分都可以独立处理交易。因为分片是在以太坊的基础级协议中实现的，所以通常被也称为**第一层**（**layer 1**）扩展解决方案，如果你想了解更多有关分片的内容，请查看 [extensive FAQ](https://github.com/ethereum/wiki/wiki/Sharding-FAQ) 和[这篇博文](https://medium.com/@icebearhww/ethereum-sharding-and-finality-65248951f649)。

![](https://user-gold-cdn.xitu.io/2018/3/9/16208aa54f79c0f5?w=800&h=214&f=png&s=38948)

#### **二. 如果我们能够从以太坊现有能力中压榨出更多有用的业务操作**

第二种选择的方向则相反：不是增加以太坊区块链本身的容量，**如果我们可以通过我们已经拥有的能力来做更多的事情，会怎样**？在基础级别以太坊区块链的生产力都是相同的，但是实际上，我们可以做更多对人和应用程序有用的操作，比如交易，游戏中的状态更新，或者简单的计算。

这是 “链下（off-chain）” 技术背后的思维逻辑，比如 [**状态通道（state channels）**](https://medium.com/l4-media/generalized-state-channels-on-ethereum-de0357f5fb44)**，**[**Plasma**](http://plasma.io/) **和** [**Truebit**](http://truebit.io)。虽然其中每个解决方案都在解决一个不同的问题，它们都通过执行“链下”操作而且能够不在以太坊区块链上运行的同时，仍然保证足够的安全性和权威性。

这些也被称为 **第二层（layer 2）** 解决方案，因为它们建立在以太坊主链“之上”。他们不需要更改基本级别的协议，相反，它们只是作为作为以太坊上的智能合约，用于与链下软件进行交互。

![](https://user-gold-cdn.xitu.io/2018/3/9/16208aa54623aeb3?w=800&h=210&f=png&s=49288)

### **2. 第二层（layer 2）解决方案是加密经济解决方案**

在深入了解第二层解决方案的细节之前，了解下使其可行的潜在细节是非常重要的。

公有区块链的动力源泉在于[加密经济合约](https://hackernoon.com/making-sense-of-cryptoeconomics-5edea77e4e8d)。通过调整激励措施并用软件和加密措施保护激励，我们可以创建一个就内部状态达成一致的稳定计算机网络。这是[中本聪的白皮书](https://bitcoin.org/bitcoin.pdf)的关键内容，现已应用于许多不同的公有区块链（包括比特币和以太坊）的设计中。

除了一些极端的情况下（比如 51% 攻击），**加密经济合约给了我们一个稳固的核心** 。我们知道链上（on-chain）操作（比如支付，智能合约）可以被看做是写入去执行。

**第二层（layer 2）解决方案背后的关键是我们可以将这个稳固的内核用作锚点，一个可以附加其他经济机制的固定点**。这种 **第二层** 经济机制可以扩展公有区块链的可用性。让我们**脱离**区块链进行交互操作，并且在需要的情况下仍能可靠地重归到核心链上。

这些构建在以太坊“之上”的层并不总是与链上操作具有相同的保障。但是，它们仍然具备**足够的权威性，安全性以及可用性**，特别是在终端略微减少时，我们能够更快的执行操作或维持更低的日常成本。

**加密经济并不是随着中本聪的白皮书而开始或结束**，它是最适合我们去学习与应用的技术主体。不仅存在于核心协议的设计中，也存在于第二层系统的设计中，它们扩展了底层区块链的功能性。

#### **一. 状态通道（State channels）**

状态通道（State Channel）是一种用于执行交易和其他状态更新的“off-chain”技术。可是，一个状态通道“中”发生的事务仍保持了很高的安全性和权威性。如果出现任何问题，我们仍然可以选择重归到“稳固内核”上，它的权威性是建立在链上交易基础上。

大部分读者会熟悉存在多年的概念——**支付通道（payment channel）**，它最近通过在比特币上借助[闪电网络（lightning network）](http://lightning.network/)实现了。状态通道是支付通道泛化出来的形式，它不仅可用于支付，还可用于区块链上任意的“状态更新”，比如智能合约中的更改。在 2015 年，Jeff Coleman [第一次详细介绍](http://www.jeffcoleman.ca/state-channels/)了状态通道。

解释状态通道的运作方式的最佳方法就是来看一个样例。请记住这是一个概念性的解释，也就是说我们不会牵涉到具体实现的技术细节。

现在试想一下，爱丽丝和鲍勃想玩一场井字游戏，赢家可以获得一个以太币。实现这一目的的最简单方法就是在以太坊上创建一个智能合约，实现井字游戏规则并跟踪每个玩家的动作。每次玩家想要移动时，他们都会向合约发送一个交易。当一名玩家获胜时，根据规则,合约会付给赢家一个以太币。

这样是可行的，但是效率低下且速度慢。爱丽丝和鲍勃正在使用**整个以太网络**处理他们的游戏过程，这对于他们的需求来说有点不合时宜。他们每一步都需要支付挖矿费用（gas），并且还要在进行游戏的下一步之前都要**等待**挖矿完成。

**不过，我们可以设计一个新的系统，它能使爱丽丝和鲍勃在井字游戏的过程中产生尽可能少的链上操作。** 爱丽丝和鲍勃能够以链下的方式更新游戏状态，同时在需要时仍能将其重归到以太坊主链上。我们将这样一个系统称之为“状态通道”。

首先，我们在以太坊主链上创建一个能够理解井字游戏规则的智能合约 “Judge”，同时它也能够认定爱丽丝和鲍勃是我们游戏中的两位玩家。该合约持有一个以太的奖励。

然后，爱丽丝和鲍勃开始玩游戏。爱丽丝创建并签署一个交易，它描述了她游戏的第一步，然后将其发送给鲍勃，鲍勃也签署了它，再将签名后的版本发回并保留一份副本。然后鲍勃也创建并签署一个描述他游戏中第一步的交易，并发送给爱丽丝，她也会签署它，再将其返回，并保留一份副本，他们每一次都会这样互相更新游戏的当前状态。每一笔交易都包含一个“随机数”，这样我们就可以直接知道游戏中走棋的顺序。

**到目前为止，还没有发生任何链上的操作。**爱丽丝和鲍勃只是通过互联网**向彼此**发送交易，但没有任何事情涉及到区块链。但是，所有交易都可以发送给 Judge 合约，也就是说，它们是有效的以太坊交易。你可以把这看做两人在彼此来回填写了一系列经过区块链认证的支票。**实际上，并没有钱从银行中存入或取出，但是他俩都有一堆可以随时存入的支票。**

当爱丽丝和鲍勃结束游戏时（可能是因为爱丽丝赢了），他们可以通过向 Judge 合约提交最终状态（比如，交易列表）来**关闭**该通道，这样就只用付一次交易费用。Judge 会确定双方都签署了这个“最终状态”，并等待一段时间来确保没人会对结果提出合理质疑，然后向爱丽丝支付一个以太币的奖励。

**为什么我们需要设置一个让 Judge 合约等待一下的"质疑时间"**

假设，鲍勃并没有给 Judge 发送一份**真实**的最终状态，而是发送一份**之前**他赢了爱丽丝的状态。这时如果 Judge 是一个非智能合约，它自己根本无法得知这个状态是否是最近的状态。

而质疑时间给了爱丽丝一个机会能够证明鲍勃提交了虚假的游戏最终状态。如果有更近期的状态，她就会有一份已签名交易的副本，并可以将其提供给 Judge。Judge 可以通过检查随机数来判断爱丽丝的版本是否更新，然后鲍勃盗取胜利的企图就能被驳回了。

#### **特性和限制**

状态通道在许多应用中都很有用，它们对于在链上执行操作是一种严密的改进。但在决定应用程序是否适合被通道化时，请特别注意需要做出的一些特定折中：

*   **状态通道依赖于可靠性**。如果爱丽丝在质疑时间内掉线了（也许是鲍勃不顾一切地想要赢下奖品，而破坏了她家的互联网连接），她可能无法在质疑时间内做出回应。但是，爱丽丝可以付款给其他人，让其保存一份她的状态副本，并作为她的权益代表，以保持系统的可靠性。
*   **状态通道在需要长期交换大量状态更新的情况下非常有用**。这是因为**部署** Judge 合约时**创建**一个通道会产生初始成本。但是一旦部署完成，该通道内每一个状态更新的成本都会很低
*   **状态通道最适于有一组明确参与者的应用程序**。这是因为 Judge 合约必须始终知晓所有参与到给定通道的实体（比如，地址）。我们可以增加或删除用户，但是每次都需要更改合约。
*   **状态通道有很强的隐私属性**。因为一切都发生在参与者之间的通道“内”，而不是公共广播并记录在链上。只有开启和关闭交易必须公开。
*   **状态通道的权威性是即时生效的**。这意味着只要双方签署了一个状态更新，它可以被认为是最终状态。双方都有明确保证，在必要的情况下，他们可以将状态“执行”到链上。

我们 L4 团队正致力于创建 [**Counterfactual**](https://counterfactual.com/)，它是一个能在以太坊上推行使用状态通道的框架。我们的目标是使开发者可以在他们的项目中模块化地使用状态通道，而不需要成为状态通道专家。你可以通过[这里](https://medium.com/l4-media/generalized-state-channels-on-ethereum-de0357f5fb44)了解更多该项目的信息。我们将在 2018 年的第一季度发布技术细节文件。

另一个值得注意的针对以太坊的状态通道项目是 [Raiden](https://raiden.network/)，目前正主要致力于构建**支付**通道网络，它使用了和 [闪电网络](http://lightning.network)类似的范式。这意味着你不必与想要交易的特定人员搭建通道。你可以与一个连接到更大型通道网络的实体架设一个单独的通道，这样你就能够向连接到同一网络的任何人付款而无需额外费用。

除了 Counterfactual 和 Raiden，在以太坊上还有几个应用程序特定的通道实现。例如，Funfair 就为他们的去中心化赌博平台搭建了一套他们称之为 “[Fate channels](https://funfair.io/state-channels-in-disguise/)” 的状态通道，SpainChain 为成人项目演员构建了一套 [one-way payment channels](https://twitter.com/SpankChain/status/932801441793585152)（他们还在他们的 ICO 中[使用了状态通道](https://github.com/SpankChain/old-sc_auction)），还有 [Horizon Games](https://horizongames.co/) 也在他们的第一款基于以太坊的游戏中使用了状态通道。

#### 二. Plasma

2017 年 8 月 11 日，Vitalik Buterin 和 Joseph Poon 发表了一篇题为 [_Plasma: Autonomous Smart Contracts_](http://plasma.io/plasma.pdf)的文档。这份文档介绍了一种新技术，它能使以太坊每秒可以处理的远比现在更多的事务。


和状态通道一样，Plasma 是一种用于管理链下交易的技术，同时依靠底层的以太坊区块链来实现其安全性。**但是 Plasma 采用了一种新思路，它是通过创建依附于“主”以太坊区块链的“子”区块链**。这些子链又可以循序产生它们自己的子链，并能依次循环往复。

其结果是我们可以在子链层级中执行许多复杂的操作，在与以太坊主链保持最低限度交互的情况下，运行拥有数千名用户的完整应用程序。**Plasma 子链可以更快迁移，并承担更低的交易费用，因为其上的操作无需在整个以太坊区块链上进行重复。**

![](https://user-gold-cdn.xitu.io/2018/3/9/16208aa5b49128bd?w=453&h=173&f=png&s=16416)

plasma.io/plasma.pdf

为了弄清楚 Plasma 的运行原理，我们来看一个其如何被运用的样例。

试想你正在创建一个基于以太坊的卡牌交换游戏。这些卡牌是一些 ERC 721 不可替代的令牌（比如 Cryptokitties），但是拥有一些可以让玩家相互对战的特征和属性，这有点像炉石传说或者万智牌。这些类型的复杂操作在链上执行代价非常大，所以你决定在你的应用程序中使用 Plasma 作为替代方案。

**首先，我们在以太坊主链上创建一系列的智能合约，它们可作为 Plasma 子链的“根节点”**。Plasma 根节点包含了子链的一些基本“状态交易规则”（诸如“交易无法消费已消费过的资产”），也记录了子链状态的哈希值，并建立一种允许用户在以太坊主链和子链间转移资产的“桥接”服务。

然后，创建我们的子链。子链可以拥有自己的共识算法，在这个例子中，我们假设它使用了 [Proof of Authority (PoA)](https://en.wikipedia.org/wiki/Proof-of-authority)，这是一种依赖可信区块生产者（比如，验证者）的简单共识机制。在“工作量证明”系统中，区块生产者和**矿工**的功能类似，它们接收交易，形成区块并收取交易费用的节点。为了让样例简单点，我们假设你（也就是创建游戏的公司）是创建区块的**唯一**实体，即你的公司运营几个节点，这些节点就是子链的区块生产者。

一旦子链创建好并生效后，区块生产者会周期性的向根节点合约发出提交。也就是他们实际上在说“我提交的 X 是子链中当前最新的区块”。这些提交被当做子链中事务的证明，记录在链上的 Plasma 根节点里。

现在子链也准备好了，我们可以创建卡牌交换游戏的基本组件。这些卡片遵循 [ERC721](https://github.com/ethereum/eips/issues/721)，在以太坊主链上初始化，然后由 Plasma 根节点转移到子链上。**这里引入了一个关键点：Plasma 可以扩展我们与基于区块链的数字资产之间的交互，但是这些资产应当是首先由以太坊主链创建的**。然后，我们将实际的游戏应用程序以智能合约的方式部署到子链上，这样子链就包含了游戏所有的逻辑和规则。

**当用户想要玩游戏时，他们只需要和子链进行交互**。他们可以持有财产（ERC721 卡牌），为了以太币购买并交换它们，与其他用户对战，以及其他游戏中允许的行为，而这些过程都不需要与主链进行交互。因为只有很少的节点（比如，区块生产者）才需要处理交易，这样费用就会降低很多，操作也能更快。

#### **但是这种模式安全吗？**

通过将操作从主链迁移到子链上的方式，我们明显可以执行更多的操作了。但是这样安全吗？发生在子链上的交易是否具备权威性？毕竟，我们方才描述的系统只有**一个中心实体**控制着子链的区块生产。这样不是中心化吗？**这样公司不是随时都能窃取你的资产或者拿走你的收藏卡牌吗？**

简单来说，即使是在子链中完全由一个实体完全控制区块生产的**情景**下，Plasma 也能做出**你可以随时将你的资产收回到主链上**的基本承诺。如果一个区块生产者开始表现出敌意，最坏的情况也只是强迫你离开这个子链。

让我们来看下区块生产者表现恶劣的几种方式，同时看下 Plasma 会怎样处理这些情景。

**首先，假设一个区块生产者试图通过说谎欺骗你，他们可以通过创建一个伪造的新区块，声称你的资产被他们接管了。**由于他们是**唯一**的区块生产者，所以他们可以自由引入一个并不遵循区块链规则的新区块。和其他区块一样，他们也得将这个区块存在的证据作为提交推送给 Plasma 根节点合约。

如上所述，用户有能将他们的资产随时收回到主链上的基本保障。在这个情景下，用户（或者代表他们权益的应用程序）会侦测到这种盗窃的企图，并在区块生产者尝试和使用他们的“被盗”资产之前撤回到主链上。

Plasma 还创建了一种防止利用欺诈的机制。Plasma 包含了一种任何人（包括你）都可以向根节点合约发布**欺诈证明**（**fraud proof**）的机制，这样就可以证明区块生产者作弊了。这个欺诈证明会包含之前区块的信息，并且允许我们根据子链中的状态交易规则，错误的区块并不能正确接上之前的状态。如果欺诈被证实，则子链回滚到前一个区块。更妙的是，我们还构建了一种签出错误区块的区块生产者会被处罚的体系，这些区块生产者会因此丢失一个链上押金。

![](https://user-gold-cdn.xitu.io/2018/3/9/16208aa552350e3e?w=538&h=220&f=png&s=18547)

plasma.io/plasma.pdf

**但是提交欺诈证明需要访问底层数据，即需要用之前的实际历史区块来证明欺诈**。如果区块生产者为了防止爱丽丝能够向根节点合约提交欺诈证明，**并**不分享之前区块的信息怎么办？

在这种情况下，这个方案就是为了让爱丽丝收回资产并脱离子链而准备的。根本上来说，爱丽丝向根节点合约提交了一份“欺诈证明”。在一段任何人都可以质疑证明（比如，显示一些后面的合法区块证明实际上她消费了这些资产）的延迟时段后，爱丽丝的资产将会被移回到以太坊主链上。

![](https://user-gold-cdn.xitu.io/2018/3/9/16208aa56b21465f?w=605&h=262&f=png&s=29263)

plasma.io/plasma.pdf

**最后，区块生产者可以监察子链中的用户**。如果区块生成者愿意，他们可以直接不在其区块中不包含实际事务，从而有效阻止用户在子链上执行任何操作。如上所述，这个解决方案再一次的直接将我们所有的资产收回到以太坊主链上。

**但是，取出资产本身也会带来风险**。其中一个忧虑就是如果所有使用这一子链的用户在同一时刻都要取出资产会怎样。在这样一个大量取出的情况下，以太坊主链主链上可能没有足够的能力处理每个人在质疑期内的交易，[也就意味着用户可能会失去资金](https://www.reddit.com/r/ethereum/comments/6sqca5/plasma_scalable_autonomous_smart_contracts/dlex5pa/?utm_content=permalink&utm_medium=front&utm_source=reddit&utm_name=ethereum)。虽然有许多可行的技术能够防止这种情况发生，例如，通过延长质疑时间来适应取出资产的需求。

**值得注意的是，所有区块生产者都是由一个实体控制这种情况并不是必定的，这只是我们案例中的极端个例**。我们可以创建创建区块生产者分布在不同实体间的子链，即像公有区块一样真正地去中心化。在这些情况下，区块链生产者按照上述方式交互的风险更小，而且用户必须将资产转移回以太坊主链的风险也更小。

现在我们已经介绍了状态通道和 Plasma，有几点值得比较下。

它们之间一个不同之处在于，当状态通道中所有利益方都一致同意提现，它可以**立即提现**。如果爱丽丝和鲍勃同意关闭通道并撤回它们的资金。只要他们都认同最终状态，他们就可以立即取得他们的资产。这在 Plasma 上并不可能实现，如上所述，用户在取出资产的过程中必须包含一个质疑时间。

与 Plasma 相比，状态通道在每笔交易上更便宜，而且速度更快。**这意味着我们可以[在 Plasma 子链上建立状态通道](https://www.reddit.com/r/ethereum/comments/7jzx51/scaling_ethereum_hundreds_to_thousands_of/drb930m/?context=1)。**例如，一个应用程序中两个用户在进行一系列的小型交易。在子链上建立一个状态通道**应该**会比直接在子链上执行每个交易更加便宜和迅速。

最后，需要注意的是这部分讲解缺失了大量细节。Plasma 本身还处于非常起始的阶段。如果你有兴趣了解 Plasma 现在的情况，请查看 Vitalik 最近的一个关于 “[Minimal Viable plasma](https://ethresear.ch/t/minimal-viable-plasma/426)” 的提议（即抽离出 plasma 的实现过程）。一个台湾的团队正在进行这项工作，可以在[这个分支](https://github.com/ethereum-plasma)中查看。OmiseGo 正在研究他们的分布式交易的实现，他们在[这里](https://blog.omisego.network/construction-of-a-plasma-chain-0x1-614f6ebd1612)发布了最近更新进展信息。

#### **III. Truebit**

[Truebit](http://truebit.io) 是一种帮助以太坊在链下进行**繁重**或者**复杂** 运算的技术。它对于提高以太坊区块链的总交易通量更有效，这使得它与状态通道和 Plasma 不一样。正如我们在开篇部分讨论的那样，扩展是一个多方面的难题，需要的不仅仅是更高的交易通量。**Truebit 不会让我们做更多的交易，但是它可以让基于以太坊的应用程序处理更复杂的事务并仍能被主链验证。**

这就让我们能够对以太坊应用程序做一些有用的操作，这些操作的计算成本太高，无法在链上执行。例如，验证来自其他区块链的简单支付验证（SPV）证明，以太坊智能合约可以通过这个验证“检查”交易是否发生在另一个链上（比如比特币或者[狗币](https://twitter.com/Truebitprotocol/status/960662648193888256)）。

我们来看一个例子。试想你有一些高代价计算（比如 SPV 证明）需要作为一个以太坊应用程序的一部分执行。因为 SPV 证明的计算成本太高了，你不能简单地将其作为以太坊主链上的智能合约的一部分。请牢记，因为每个节点必须并行执行该操作，所以在以太坊上执行任何计算的成本都非常高。以太坊中的区块都有**最大费用(gas)限制**，它用于限制该区块中所有事务组合在一起能够完成的计算总量。但是，SPV 证明的计算量实在太大，即使它只是其中**仅有**的交易，仍需要许多倍单个区块的**全部费用限制**。

**相反，链下你只需要支付很少的费用就可以完成计算。**让你为此付费完成计算的这个人被称作**解算机**。

首先，解算机支付给智能合约一份押金。然后，你给解算机一份计算的详细描述，它们运行计算，并返回结果。如果结果是正确的（大部分情况下发生在一秒钟之内），它们的押金将被退回。如果解算机被证实没有正确执行运算（比如，它们欺诈或者犯错了），它们会失去押金。

但是，我们如何判断结果是否正确呢？Truebit 使用了一种叫做“验证游戏（verification game）”的经济机制。本质上我们创建了一种激励机制，它叫做**挑战者**（**challengers**）来检查解算机的结果。如果挑战者能够通过验证游戏证明解算计提交了错误结果，那么他们就可以收取奖励，而解算计则丢失他们的押金。

由于验证游戏是在链上执行的，因此它不能简单地计算结果（这会推翻整个系统的设计初衷，如果**可以**在链上执行计算，我们也就不需要 Truebit 了）。相反，我们要求解算机和挑战者确定他们意见不一致的**特定操作**。**实际上，我们支持双方到一个角落，找出导致它们对结果不一致的具体代码行。**

![](https://user-gold-cdn.xitu.io/2018/3/9/16208aa61bebb172?w=800&h=678&f=png&s=84463)

Truebit 的简化概念图。

一旦确定了具体的操作，它就小到可以由以太坊主链来执行了。然后，我们通过以太坊智能合约来执行这一行动，该合约一劳永逸地解决了哪一方说了真话，哪些又是谎言或错误。

如果你想了解更多关于 Truebit 的信息，你可以查看[这份文档](https://people.cs.uchicago.edu/~teutsch/papers/truebit.pdf)，或者 Simon de la Rouviere 写的[这篇博文](https://medium.com/@simondlr/an-intro-to-truebit-a-scalable-decentralized-computational-court-1475531400c3)。

### **结论**

**第二层解决方案有着共同的远见**。一旦我们得到由公有区块链提供的稳定内核，就可以将其作为加密经济的锚点，扩展出无限的区块链应用。

现在我们已经对一些样例进行了调查，这样就可以更具体地了解第二层解决方案怎么实现这种远见。第二层解决方案中运用的经济机制通常是**交互游戏**：它们通过为各方创造激励以使其相互竞争或彼此“检查”工作。**由于我们激发了另一方出示证实错误信息的强烈动机，因此区块链应用程序可以假定某个给定的声明是正确的。**

在状态通道方案中，就是通过给各方一个“反驳”对方的机会，来确定通道的最终状态。在 Plasma 方案中，就是如何管理欺诈证明和提现。在 Truebit 方案中，就是通过激励挑战者证明解算机是错误的，从而保证解算机给出正确结果。

这些系统将有助于解决将以太坊扩展到全球用户群过程中所涉及的一系列挑战。一些系统，像状态通道和 Plasma ，将会增加平台的交易通量。其他系统，像 Truebit，将能够作为智能合约的一部分进行更多的复杂计算，创建出新的使用案例。

这三个例子只能代表加密经济扩展方案可能性设计的一小部分。我们甚至还没有谈到像 [Cosmos](https://cosmos.network/) 或 [Polkadot](https://blog.stephantual.com/web-three-revisited-part-two-introduction-to-polkadot-what-it-is-what-it-aint-657782051d34) 这样的“区块链间协议”（尽管这是“第二层”解决方案或另一篇博文的内容）。**我们还是应该期待能够发明出意想不到的新型第二层系统，来改进现有模型或在速度，终端和开销做出新的权衡。**

比任何**独特的**第二层解决方案更重要的是进一步发展潜在的技术和机制，使这些加密经济设计成为可能。

**这些第二层扩展方案有力证明了像以太坊这样的可编程区块链的长期价值**。只有在程序化区块链上才有可能建立基于第二层解决方案的经济机制：你需要用脚本语言实现执行交互式游戏的程序。因为比特币等区块链只提供了有限的脚本功能，这对于它们来说很困难（或者有些情况下，比如 Plasma，这是完全不可能实现的）。

**以太坊第二层方案的出现让我们能在速度、终端和开销间做出新的权衡。**这是底层区块链能够适用于更多种类的应用程序。因此面对不同威胁模型的不同类型应用程序会自然的选择不同的权衡模式。对于需要保障区域性（乃至国家性的）范围内的大规模交易时，我们使用主链。对于更偏重速度的数字资产交易，我们可以使用 Plasma。第二层方案让我们能够在**不**损害底层区块链的前提下做出这些折中措施，并保持去中心化和权威性。

而且，很难事先预测给定的扩展方案需要哪些脚本功能。**当以太坊被设计出来时， Plasma 和 Truebit 还尚未发明**。但是由于以太坊是完全可编程的，它能够实现我们能发明的任何经济机制。

区块链技术的价值是建立在加密经济合约的稳定内核上，而诸如以太坊这样可编程区块链才是能够充分利用这种价值的唯一途径。

**感谢 Vitalik Buterin，Jon Choi，Matt Condon，Chris Dixon，Hudson Jameson，Denis Nazarov 和 Jesse Walden 对于本文初稿的意见。**

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
