>* 原文链接 : [What is Product Design?](https://medium.com/intro-to-digital-product-design/lecture-1-what-is-product-design-c290bfe799a9#.ctnank1m1)
* 原文作者 : [Andrew Aquino](https://medium.com/@andrewaquino)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : [Zhangjd](https://github.com/zhangjd)
* 校对者: [hikerpig](https://github.com/hikerpig), [joyking7](https://github.com/joyking7)

![](https://cdn-images-1.medium.com/max/2000/1*kOx2oUFQrrXhbUF9CMQHog.jpeg) 

# 什么是产品设计?

_这篇文章是对 CUAppDev 在康奈尔大学主办的 Intro to Digital Product Design 课程的总结记录。这门课程是1学分的，时间每周一 5:30PM 到 6:30PM，地点 Phillips 203。_

### 什么是好的设计?

Craigslist 以其美学标准而闻名，和今天的扁平风格 UI 与巨大的首图相比，Craigslist 的审美看起来似乎有点老了。但是，问题来了：

> Craigslist 是不是好的设计?

许多人很快会说，Craigslist 的设计既过时又杂乱，因此是坏的设计。可是，有什么指标可以证明这个观点呢？Craigslist 每个月可是有 500 亿 PV 呢。

尽管直觉上感觉是那样，但 Craigslist 确实成功了 - 事实上它是挺好用的。大部分用户在寻找特定分类和进行买卖等操作时，都不会有太大的困难。

好的用户界面和好的用户体验是有区别的。尽管 Cragslist 用户界面过时，但更重要的是它有很棒的用户体验。这就是为什么我们可以认为 Craigslist 拥有良好的设计。

![](https://cdn-images-1.medium.com/max/800/1*flGQAGbkERLU7wOQKiImnw.jpeg) 

### 所以，到底什么是产品设计?

产品设计离不开解决问题，而产品设计师追求的是提高产品的体验。并且，他们还要懂得通过运用许多技能来完成这一目标：动画、原型、编程、调查、视觉设计、交互设计、心理学以及经营策略 ([Eric Eriksson](https://medium.com/@ericeriksson)).

> “如果你只把产品设计师视作一种把方案设计得可以见人的职业，请重新思考。产品设计师是帮你识别、调查和验证问题的，并最终精巧地制作、设计、测试和完成整个解决方案的。” — Eric Eriksson

以下四个例子，可以让你浅尝到当一个产品设计师的体验：

**产品设计师探索解决方案。**

你所看见的 Slack 用户界面会是完全不同的。设计师在解决问题的时候，不应该只考虑单个用户或是经理的需求，而是应该探索不同的可能性。

![](https://cdn-images-1.medium.com/max/600/1*B4GBOSHIt1Ws6W_T3R6eag.jpeg) 

![](https://cdn-images-1.medium.com/max/600/1*eTkC_l2vUaYuStgBQoRoNA.jpeg) 

**产品设计师验证解决方案。**

古怪的服装品牌，[Betabrand](http://betabrand.com)，想要测试一个问题：胡须的长度是否会影响广告的点击率。

于是他们就着手测试了不同的广告，这些广告都用了同一个模特，只是胡子的长度从短到长分为多个等级。_他们发现了什么呢？_ 经过他们的分析，胡子长度最长的广告，点击率几乎提升了两倍。

![](https://cdn-images-1.medium.com/max/600/1*-_h5Losqn2mtA4emTxDqdw.jpeg) 

![](https://cdn-images-1.medium.com/max/600/1*bLP2bqxfZv4RNyO-OwAgeQ.jpeg) 

**产品设计师发现真正问题。**

每个人都想要一个“不喜欢”的按钮，不管是为了反感讨厌的政治文章，还是在 WorldStar 视频中提出反对意见，抑或是在灾害时表达悲伤。可是，你是否可以想象到因为某人可能不喜欢而害怕发表内容的情形？不喜欢按钮引起的新问题可能比解决的问题还多；它会使 Facebook 变成一个更容易受到消极影响的地方。

设计师发现，真实问题并不是缺少一个不喜欢按钮，而是 [生活中的每样东西并非都是可以点赞的](https://medium.com/facebook-design/reactions-not-everything-in-life-is-likable-5c403de72a3f#.lu650bnu7), 因此: 有了 Facebook reactions（反应按钮）。

![](https://cdn-images-1.medium.com/max/600/1*0NvkunCJ6HWa3JfzDgflbQ.jpeg) 

![](https://cdn-images-1.medium.com/max/600/1*eQK9fd_TEayTt8Wvox6m8w.jpeg) 

**产品设计师做必要的事情。**

设计并不总是要最简化的，Google 就在登录过程里添加了一个额外步骤。Google 这样做是为了消除那些使用多重账号的人的疑虑，并为他们准备了新的验证解决方案。虽然这样的解决方案让一个简单的任务变得更加复杂，但却是符合他们的业务约束与用户目标的。这个解决方案虽然不是最简化的，但却是相当有必要的。

 ![](https://cdn-images-1.medium.com/max/600/1*kJW8OR5BfoPnTN0-Qdhj0Q.jpeg) 

![](https://cdn-images-1.medium.com/max/600/1*6yyZLQFU98Yygt9CpIm3JQ.jpeg) 

### 好的产品设计，关键是什么?

 ![](https://cdn-images-1.medium.com/max/800/1*uTDWovhGf6miGk_MSRYmTg.png) 

<figcaption>这是转述自 Elements of User Experience 作者 Jesse James Garrett 的一个图表。图片创作者未知（如果有人知道，请联系我）。</figcaption>

设计不仅要处理视觉设计，还要处理用户体验的几个层面。这些层面上的设计可以通过一个 **设计流程** 来实现。

在这个流程中，会考虑以下这些方面：制定处理用户需求的策略，限定需要呈现的内容，并描绘出用户需要哪些步骤去实现一个目标。

> “但我只想要把样子变得更好看呀。”

这是一个常见的观点。可是，这些目光短浅的目标，甚至会伤害最好的、最创新的 idea, 因为...

>![](https://cdn-images-1.medium.com/max/800/1*m4-53lKUMg6R_Ek8rXaB9Q.jpeg) 

一个好的美术设计不能弥补一个坏的产品。如果你让一个设计师只管把产品变得好看，那就错了。你怎么知道你的产品是否确实在解决问题？

无论是设计师、开发者还是产品经理做的设计决策，都需要有一个评价标准。他必须从人类第一的角度来看，思考整个产品的方方面面。

> _过程来自于同理心_

同理心即你对用户的关怀。作为一个设计师，你必须想要提供最佳的用户体验可能。**设计流程**让你不遗余力地考虑方方面面，从而来完成这个目标。(Jared Erondu)

![](https://cdn-images-1.medium.com/max/2000/1*ZoU6Z_tuuKSIYtjZnHHydg.jpeg) 

### 课程总览

#### 你将学到什么？

1.  如何确定问题。
2.  如何探索问题。
3.  并如何验证问题。
4.  如何做视觉设计。
5.  如何呈现设计。

没有官方的教学大纲。本课程随着班级的进度灵活教学。

#### 你将如何学习?

**课程结构**

这门课会更加传统，但班级通常由小讨论、工具示范、项目走查等组成。

**等级评定**

1.  来上课：你可以有两次无故缺席的机会。
2.  按时交作业。

**课程项目**

你可以挑选一个问题，然后发现解决方案，作为一个学习案例提交上来。例如：[http://www.teehanlax.com/story/medium/](http://www.teehanlax.com/story/medium/)

*   每次发布作业都算进这个课程项目。

**任务**

你必须把这两者都提交到 Facebook Group.

1.  发布作业：这些作业可能不尽相同，但都要在下次课的前一个星期天之前提交。
2.  Weekly UI (选做) : _这些是 DailyUI 的一个拆分_. Weekly UI 的目的是可以不受约束地练习视觉设计.

![](https://cdn-images-1.medium.com/max/800/1*zFimCaH0gGaeYjJ1WVFoSA.png) 

<figcaption>[Ranjith Alingal](https://dribbble.com/ranjithalingal) 设计的 Nike 卡片</figcaption>

是的，WeeklyUI 是可选做的作业。可是，想要提高视觉设计的水平，唯一途径还是要练习。

> **“只有通过进行大量的工作，你才能缩小差距，你的作品才能配得上你所追求的目标。” — Ira Glass**

<iframe src="https://player.vimeo.com/video/85040589?color=1fc9a2&portrait=0" width="500" height="281" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>

**课程工具**

**Piazza** 用于组织工作和提问。演讲的幻灯片也会被传到 Piazza。

**Facebook Group** 用在你的上传作业，同伴、推动人反馈意见，以及其它资源。_我们决定使用 Facebook Group ，是因为公开分享你的作品是很重要的。_

**Medium** 讲座记录会放在 Medium 收藏中。

**扩展资源**

**办公时间** 在周三 11:00–12:00PM, 周三 1:30PM-2:30PM, 周五 10:00PM-11:00PM

**一对一辅导** 将被安排用于讨论进度

**午餐** 安排在周一 12:00 到 1:00PM. 这些时间可以用来反馈、提意见等。

**你需要的软件 (选择以下一项或多项)**

*   Photoshop (20$/月, Adobe CC 版本)
*   Illustrator (20$/月, Adobe CC 版本)
*   Sketch ($40 学生优惠价)
*   _你可以使用的其他设计程序。_

#### 这对你有什么好处?

**经验** 当你结课时，你将获得一个完整的产品学习经验，更加熟悉设计工具。除此之外，你将可以更容易地和产品经理、设计师、客户以及其他利益相关者进行沟通。

**产品设计思想** 可以转换到数字产品之外的任何地方。比如，产品设计可以用在键盘的物理布局，或者作为决策相关的，比如组织一个课室。总之，这个框架可以帮助你验证任何你所需要做的决定。

#### 这对我们有什么好处?

![](https://cdn-images-1.medium.com/max/400/1*YVdmW91Yui8R8kQcEqLoPA.jpeg) 

![](https://cdn-images-1.medium.com/max/400/1*3kR4zl51bZuq27w1Yp4cJQ.jpeg) 

![](https://cdn-images-1.medium.com/max/400/1*CnkBQkmVFik5V-PajgRJug.jpeg) 

我确定你曾经听过人们这样讲过：“_我在工作的地方学习了我所知道的所有东西。_” 和 “_我不会使用我在学校里学到的任何东西_”。这里的争论是，教育的目的是为了最大化接触，而不是应用技能，因此我们在设计上的要求是有所不同的。

Cornell 的目的不是在迎合设计工作的具体需求。这是因为教育是滞后于产业的。你可能要等一段时间才能看到类似于 iOS 开发，内容运营，前端框架之类的新课程。

这有时会让我们流失一些学生，因为他们的求知欲在有限学时里不能得到满足。有些设计师因为从未耳闻“产品设计师”而转学其他专业，对我们来说，是个很大的问题。

因此，我们的解决方案是，在我们都满怀热情的地方填补一个重大空白：设计。

#### 这对每个人有什么好处?

_下面是改编自 Stephanie Engle 的一篇[关于产品设计的介绍](https://medium.com/p/c2dbbc7809d3)，他提出了一个关于理解产品设计的优秀的论据。_

那些缺乏以用户为中心的设计，影响着人们每一天的生活，并或多或少导致失意与挫败的情绪。

![](https://cdn-images-1.medium.com/max/600/1*R4p2RGfzyDRGg-2WyhJ4CA.jpeg) 

![](https://cdn-images-1.medium.com/max/600/1*sNkNpmrVuz2tXxcyzPCoLg.jpeg) 

然而，更糟糕的设计甚至会夺走人的生命。 ([Stephanie Engle](https://medium.com/hh-design/intro-to-product-design-c2dbbc7809d3)).

> **“Jenny 死于中毒和脱水。全因为照顾她那位老练的护士一直在花时间操作这个界面。” — **[Jonathan Shariat](https://medium.com/u/62abc616e750)

![](https://cdn-images-1.medium.com/max/800/1*o_OGbnZnX2aNDaNuLod6uQ.jpeg) 

<figcaption>**Jonathan Shariat**，Tragic Design 的作者。</figcaption>

除开不好的地方，设计还有机会激发创新。像一个设计师那样思考，你可以去分享这个故事，这不仅关于我们如何存在，而且我们应该如何存在。

![](https://cdn-images-1.medium.com/max/800/1*KthtYqzfjoVkKp-WlfoVtA.jpeg) 

<figcaption>梅赛德斯奔驰把潜在的社会经验用在自动驾驶汽车设计上。</figcaption>

![](https://cdn-images-1.medium.com/max/2000/1*ANw9c6PDOtB4-b35Qb85zg.jpeg) 

**但是 Nicole 和 Andrew — 你们不是老师。”**

你说得对，我们不是老师。 **我们也不知道我们在干嘛。** 可是，这个课程是一个机会，让所有人学到一些新的东西。请注意了：任何人都有权利分享知识和经验。[SkillShare](http://skillshare.com/) 和 [Berkeley’s DeCal](http://www.decal.org/) 项目都是现实生活中服务大我的鲜活例子。请试着不要把我们当作老师，而是促进者或者内容管理者。

所以，我们设计我们的课堂，你将在课堂上学习相同的框架。我们确定了几种方法，测试了它们的反馈，并巩固了我们最好的解决方案，让你学习产品设计。

事实上，有几种专业的设计课程，包括 a16z Gen.D Mentorship program, BuzzFeed Product Design, 和 Facebook Product Design 都帮助我们设计这个课堂的形状与形式，并传授了他们所希望的，在产品设计的早期能学习到的东西。

以下是帮助我们设计出第一课的人们：
 [Jared Erondu](https://medium.com/u/2bf050c6e495), [Stephanie Engle](https://medium.com/u/625007cfe848), [Cap Watkins](https://medium.com/u/2757f3636a9f), [Allison Chefec](https://medium.com/u/eedf78d45a92), [Tom Harman](https://medium.com/u/98b2642f8375), [Lindsey Maratta](https://medium.com/u/2f53109682dd), and [Sabrina Majeed](https://medium.com/u/ebec6c3f778e).

为了进一步促进学习体验，我们设置设计了 [匿名反馈表单](http://goo.gl/forms/IdkNCsbUwc)

![](https://cdn-images-1.medium.com/max/800/1*rmf09RfocAk2TW9Y76-ihA.jpeg) 

![](https://cdn-images-1.medium.com/max/800/1*wXzzkatTR0neLfwG_ix5Vg.jpeg) 

### 逻辑

#### _如何注册_

在 Facebook Group 和 the Piazza 上面可以看到关于如何注册的指引。

#### 作业

所有的作业都要上传到 Facebook group 下特定的分类里。

**分配作业 1: 分类问题**

> 当 _____ 的时候, 我想要 _____ , 以便 _____ .

参考 Clay Christensen’s Jobs framework (Inspired by design team at Intercom)，问题可以通过上面这个结构来思考。这将激励你在每天的经历中分辨出你平常没有注意到的缺点。

> 例) 当拍合照的时候，我想要在一台手机上拍，以便避免在多台手机上拍同一张照片。


**WeeklyUI: 移动端登录页面 (选做)**

![](https://cdn-images-1.medium.com/max/800/1*WYT7dZ59cv1AKEypH4-dJA.jpeg) 

<figcaption>左边: [Michał Ptaszyński](https://dribbble.com/michal_ptaszynski),</figcaption>

### 扩展资源

*   [https://startupsthisishowdesignworks.com/](https://startupsthisishowdesignworks.com/)
*   [Intro To Product Design — HH Design — Medium](https://medium.com/hh-design/intro-to-product-design-c2dbbc7809d3#.iup6b4d9z)
*   [What is Product Design? — Medium](https://medium.com/@ericeriksson/what-is-product-design-9709572cb3ff#.xsp0td71g)

### 我们学到了什么

#### 兴趣

我们调查了来自不同大学的超过 100 名注册者。

![](https://cdn-images-1.medium.com/max/800/1*9fCD64REOU_OfMlNI9jHyg.png) 

<figcaption>80 人完成了首次调查。</figcaption>

我们发现 **Facebook groups** 独立提供了一个课程外的交互体验。在这个没人想到的地方，虚拟化一个产品设计为中心的社区，不仅对我们有益，对于个体成员也会有所帮助。

我们使用这个来提供工具，使他们可以投入在设计课程中，还可以分享在设计流程中新发现的扩展资源。

![](https://cdn-images-1.medium.com/max/600/1*Qr8OXBY58xjGr9faAmvtLw.png) 

![](https://cdn-images-1.medium.com/max/600/1*RqARvkGP7D2E_hsfEBAckg.png)

<figcaption>左边：在 Facebook reactions 分享阅读，右边：分享一个工具，可以用来发现一些好的设计</figcaption>

#### Weekly UI 作为选做作业

WeeklyUI 比我们想象的还要流行的多。大家都非常乐意接受批评和反馈。我们还发现用它可以更容易和我们的学生辨认通常的视觉设计。

![](https://cdn-images-1.medium.com/max/800/1*cL9G0hLCkfzvKMo1z0p5bA.gif)

#### 我们还在成长

如果你有任何的建议、想法或者批评，请联系我或者 Nicole，或者填写这份 [匿名反馈表单](http://goo.gl/forms/qz7rflmf5N).

### 最终的想法

![](https://cdn-images-1.medium.com/max/2000/1*tgU7bw1Befb6co1O5MkUqQ.jpeg)
