
> * 原文地址：[Learning JavaScript: 9 Common Mistakes That Are Holding You Back](https://www.sitepoint.com/learning-javascript-9-common-mistakes/)
> * 原文作者：[Yaphi Berhanu](https://www.sitepoint.com/author/yberhanu/)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/learning-javascript-9-common-mistakes.md](https://github.com/xitu/gold-miner/blob/master/TODO/learning-javascript-9-common-mistakes.md)
> * 译者：[lekenny](https://github.com/lekenny)
> * 校对者：[lampui](https://github.com/lampui)，[Yuuoniy](https://github.com/Yuuoniy)

# 学习 JavaScript：9 个常见错误阻碍你进步

很多人尝试学习 JavaScript ，但是不久就放弃了。然后他们就告诉自己，“JavaScript 太复杂了”，更有甚者说，“我不是前端开发的料”。

这种情况挺让人悲伤的。其实根本不必放弃，所要做的仅仅是换一种不同的学习方法。

在这篇文章中，我们将介绍一些最常见的错误学习方法，并了解如何避免这些错误。许多技巧不仅适用于 JavaScript，甚至可以用到 web 开发上，所以也算是一种福利。

我们来吧！

## 错误 #1：开始学习之前过度分析

开始学习 JavaScript 之前，你可以找到很多相关的信息。如果你去看，就会发现一些 JavaScript 是最好的或者是最坏的、你是需要这个框架还那个框架的相关信息。你也可能会听到你需要以某种方式编写 JavaScript，否则你永远不会成为“真正”的开发人员等。

不管这些说的正确与否，没有什么比浪费六个月到一年还没有开始更糟糕。

开始敲代码吧，它不一定完美，可能很糟糕。但如果你开始了，就通过了阻碍很多人的障碍之一了。

## 错误 #2：学习原生 JavaScript 之前学习框架

JavaScript 框架建立在原生 JavaScript 之上，因此如果你理解了 JavaScript，你也就自然而然的知道如何使用任何 JavaScript 框架的基本原理。

然而，如果你直接学习一个框架，最后也只是记住了它的语法却不理解它的原理。这就像在不知道词语意思的情况下造句，最终你只是随便地记住了一些词语，却不知道这些词语的意思并且不会组织这些词语来学以致用。

如果你直接进入一个框架，那将会更难学习，当你需要另一个框架你会更难适应。如果你首先学习基础的 JavaScript，那么你将有一个坚实的基础来了解所有的框架。

## 错误 #3：好高骛远

最常见的错误之一就是在理解概念之后立即采取行动。

我一直在努力解决这个问题，因为一旦了解某些东西，你就想更进一步。

像对待新玩具一样对待每个概念是很有帮助的；这意味着你需要花一些时间来享受你刚学到的东西。玩耍、实验，看看你能不能做一些新的事情。你会学到很多，你会记得更好。

当你感觉自己闭着眼睛都能运用自如的时候再继续向下学习。可能在达到这一步之前，你需要更多的时间，但是这将是你接下来的学习变得更快。

另一方面，如果你过于急躁，你就不会太注意细节。但令人沮丧的是，这会使你之后的学习成本大幅提升。其实这也是人们常说要放弃学习 JavaScript 的常见原因之一。

## 错误 #4：没有将概念理解透彻

学习就像爬楼梯：如果你能走一步，你可以继续采取更多的步骤，直到你达到目标。当有些东西难以理解时，往往是因为你想要进行一次飞跃，而不是一次走一步。当然这是痴心妄想！

在实际场景中，我看到人们对某段代码不理解的时候，我会请他们解释一下，他们会试图一下解释清整个问题。那我会请他们再一行一行的解释一遍，这样是有道理的。

如果有些部分很让人费解，那经常是因为跳过了某些东西，那么这也将有助于你去关注细节，直到找出症结所在。如果一个概念在分解之后仍然没有意义，那你也会有更容易找到相关解决方法，因为查找特定的主题比胡乱搜索更容易。

## 错误 #5：太早尝试复杂的项目

刚开始学习 JavaScript 的人经常会说“我就随便定个小目标，写一个 Facebook 那样的网站算了”，没有意识到项目所涉及的深度。当项目逐渐深入时，他们就放弃学习 JavaScript 了。

我更详细地介绍了[关于项目](https://www.sitepoint.com/projects-can-sometimes-be-the-worst-way-to-learn-javascript/)，但是在学习的时候，从一些基本概念开始会更容易。当你开始做项目时，你可以在工具包中添加一些构建工具。

更明确地说，我不是要那种越旷日持久的项目。我刚刚发现，如果我先做了一些简单的部分，比如在浏览器中显示一些文本或响应一个按钮，那么就可以更轻松地启动项目。

## 错误 #6：不在真实环境下练习

当你学习 JavaScript 时，你可能会在不符合真实环境下进行练习。例如，你可能在网站的内置代码编辑器中输入内容，或者你可能依赖于教程中的粘贴文件。

这些方法对于学习来说可能是非常好的，但是你也可以尝试自己搭建环境。这意味着使用你自己的文本编辑器，并从头开始编写项目。

如果你不自己独立练习每一个概念，那你会依赖于训练环境。你最终会遇到这样的情况：你已经花了很多时间来学习，但你一个都无法掌握。

## 错误 #7：将自己与大神进行比较

让自己更沮丧的最简单的方法之一就是和大神进行比较。因为你总是看他们在那里，而不是看他们如何到达那里。

举个例子，人们看到我的教程，并问我如何写这么干净的代码。他们说他们无法编写像这样的干净的代码，所以也许他们根本就不是 JavaScript 的那块料。

事实是我的过程是一团糟。我不断试验、犯错、查阅资料，写下丑陋的代码，最后把所有的内容都细化成一个可呈现的教程。人们看了优秀的版本，并且假设整个过程就是这样的。我也做过关于教程作者的这些假设，直到我开始写我自己的教程。

关键点是，认真学习你正在学习的东西，你会得到进步。继续重复这个过程，很快别人就会好奇你是如何达到那种高度的。

## 错误 #8：只看教程不写代码

你会自然而然的花费大量的时间来观看视频和教程，但是除非你自己动手编写代码，否则你不能真的学会。

光看而不采取实际行动是很危险的，你会有一种你正在学习的错觉。六个月后，你会发现自己什么都没学会。

写 15 分钟的代码比上你光看一小时的教程有用多了。

## 错误 #9：没有事先理解或自行尝试就盲目跟从教程

阅读教程时，很容易陷入照葫芦画瓢的情况。这种教程并不会教你如何解决一个问题，例如需要进行怎样的测试，如何一步一步的探索可能出问题的方向。因此，只会跟着教程走的人往往学不到真正的知识。

那么解决方案是什么？

不要只知道跟着教程一步步走，而是要花点儿时间去自己实现。例如，如果您正在学习幻灯片教程，请尝试显示和隐藏 div，然后尝试计时，然后尝试另一个小部分。相对于跟着教程一步步地走，通过亲身尝试并拓展你将学到更多知识，并且有可能将它应用得更好。

## 小贴士

在你读完这篇文章后，如果你问我最想让你记住什么，那就是通过采取最小的步骤来取得最大的进步。

无论你在学习什么，都要好好学习它本质上的东西。尝试你学到的东西，并乐在其中。

有时可能很困难，但这没关系。挑战意味着你正在提升个人能力，这将使你进步。如果一切总是太容易，这可能意味你需要进行些改变了。

我希望这篇文章对你有所帮助，如果有什么其他的帮助过你学习 JavaScript 的方法，欢迎你随时在评论中分享！

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
