* 原文链接 : [A Beginner’s Guide to Kerning Like a Designer](https://designschool.canva.com/blog/kerning/)
* 原文作者 : [Janie Kliever](https://designschool.canva.com/blog/author/janiekliever/)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : [cdpath](https://github.com/cdpath)
* 校对者 : [L9m](https://github.com/L9m), [shenxn](https://github.com/shenxn)

# 写给设计师的字偶距调整指南

_你可曾盯着刚排版的单词或词组却觉得看上去间距有点远？_

这就涉及到字偶距的问题了。字偶距是指两个字母（或其他字符，比如数字，标点符号等）之间的空白，而调整该空白可以避免看起来笨拙的单词间隙，同时提升可读性。

![](http://ww1.sinaimg.cn/large/9b5c8bd8jw1f0n4he76qij20ie0dtwhp.jpg)

有时字体默认的字偶距对特定的字母组合并不理想，需要手动调整让所有字母间的空白看起来和谐一致。这里有必要提一句，字偶距事关视觉感受，关心字母之间视觉距离而不是实际距离。字偶距要求调整版面设计来实现视觉上的恰当，并非为了数学上的等距。

印刷字体正是因为有了几分视觉错觉而相当有趣。如果按字母间距相同的原则排版，那么眼睛看到的空白却不会是均匀的。这是因为字体各自有独特的形状，如同拼图碎片，每一对字母要彼此配合才能达到最佳效果。


![](http://ww3.sinaimg.cn/large/9b5c8bd8jw1f0n4i8c0dzj20ie0lbq5x.jpg)


继续阅读，了解为什么设计中字偶距如此重要，另外还有九条专家建议供您参考，像专家一样开始调整字偶距吧。


## 为什么要将字偶距纳入设计流程


字偶距或许看起来是无关紧要的细节，但是将其纳入设计流程的收尾阶段，当作一个可以迅速搞定的额外小步骤，可以让以排版为核心的设计项目看上去更加优雅。而对大型，极其显眼的排印标识或大标题而言，字偶距是最重要的。

要进一步了解为何调整字偶距是个明智的决定，不妨想象每个字母都限制在框内。你也许看过下面这种旧旧的木质或金属活字的照片：


![](http://ww3.sinaimg.cn/large/9b5c8bd8jw1f0n4ijh5k0j20ie0cbmzi.jpg)


尽管基本不再使用物理活字了，现行的数字字体的实现方法仍然与之类似。每个字母仍束缚在不可见的框内，有时这些框给字母对儿引入了过多的空白，要想有看上去均匀的空白就需要框与框有重叠。在过去的打印流程中，排字工人可以在木活字上刻 V 形切口让字母与字母靠得更近，看上去更舒服。而如今，工序不再繁琐，点几下鼠标就可以搞定。


![](http://ww1.sinaimg.cn/large/9b5c8bd8jw1f0n4iytwoxj20ie0dt40m.jpg)


## 学习字偶距：九条专业建议


字偶距没那么难，只需理解其工作原理。 尽管调整字偶距的主要方法仍是用眼睛盯着字间空白并手动调整来决定怎样看上去最好，你依然可以通过一些技巧简化这一过程。


## 01. 当心特定的字母组合


一些字母（尤其是那些有明显的斜线或突出部分的字母）因其形状难以调节字偶距。全大写字母的单词排版也需要格外留意。如果想象字母周围有无形的框，这些难缠的字母就没法紧挨框的边，只能留着难看的间隙。下面这些难搞的东西需要额外留意：

- 倾斜的字母：A, K, V, W, Y
- 有横划和字臂的字母：F, L, T
- 字母组合：W 或 V + A（顺序随意）；T 或 F 跟着小写的元音字母

如果单词中间一个难处理的字母，仔细看看该字母和其两侧字母如何相互影响。比如，PANCAKE 中第一个 A 和后面的 N 看上去不错，但是和前面的 P 的间隙过大。


![](http://ww1.sinaimg.cn/large/9b5c8bd8jw1f0n4j61thwj20ie0dt3zk.jpg)


## 02. 理解空白和字形的关系


上一个建议主要关注成对的大写字母带来的问题，但是调整小写字母字距时也有难题。这是因为直形字母和圆形字母的相互组合与其自身组合看起来不同。


排版设计者 Ilene Strizver [推荐](http://creativepro.com/typetalk-kerning-principles/) 用下述方法来排字：两个直形字母用最多的间距，直形字母和圆形字母则需要相对较少的间距从而在视觉上达到对等，而两个圆形字母搭配所需间距比前者更少。下面的例子形象化的表述可以帮助理解。希望你能看出来从左到右字母的间距（用彩条表示）在缩小。然而单独看来这些字母间距像是均匀的。

![](http://ww3.sinaimg.cn/large/9b5c8bd8jw1f0n4jbmxp9j20ie0dtdgp.jpg)


在一个真正的词上实践一下这个方法吧。观察每个字母的两边，间距排布应该和上述三种间距组合的任意一种相吻合。

单词 ”headline“ 中，直形字母相邻共用相等的间距（蓝色标注），而直形与圆形字母相邻（青绿色标注）还有圆形与圆形相邻（橘色标注）。排版的结果看上去相当的一致。虽然也许根本没必要这样精确地调整字偶距，牢记这一方法有助于在排版时实现单词或词组字偶距的视觉一致，尤其是被一个看上去不对劲的字母组合难倒时。


![](http://ww1.sinaimg.cn/large/9b5c8bd8jw1f0n4yxk1qjj20ie0e8gmn.jpg)</div>

## 03\. 留意字号


设置的字号会影响字偶距。或者说，字号不同，字母间相互作用也不同。比如大标题设为 48 pt.，接着调整字偶距，如果把字号改到 24 pt.，之前调整字偶距的功夫就都白费了。

鉴于此最好先定字号，再调整字偶距。若是处理的是 logo 之类印在名片上一个字号，印在 T 恤又是另一个字号的东西，最好分别调整字偶距。要记住，在处理大且显眼的字母时，任何字偶距错误（或者对其的无视）都会异常惹眼。


![](http://ww3.sinaimg.cn/large/9b5c8bd8jw1f0n4jpbpymj20ie0elgn3.jpg)


这儿有一条经验法则，尺寸较大时字偶距紧凑些也许侥幸看起来不错，但是尺寸小时字母就挤在一起了，所以宽松些的字偶距是必须的。（下一条建议会进一步解释。）


## 04\. 宁愿过度调整字偶距也不要冒风险


![](http://ww3.sinaimg.cn/large/9b5c8bd8jw1f0n4jvc2fzj20ie0fsgne.jpg)

过于紧凑的文本会难以阅读，字号较小时尤甚。字偶距不足的另一个坏处是字母离得太近会挨在一起，有时候看起来就是一个完全不同的字母（甚至单词！）。下面这个绝妙的例子可以充分说明问题：如果 r 和 n 的字偶距太近了会发生什么呢？它们看起来就是个 m（顺便给排印术语表加了条目）。

![](http://ww1.sinaimg.cn/large/9b5c8bd8jw1f0n4qdog63j20ie0prgms.jpg)

由于可读性和易读性是任何设计中涉及排版时的首要考量，所以不知如何操作时，最好把字母的字偶距拉得稍微大一些，以免让读者眼睛疲劳或造成任何可能的误解。


## 05\. 颠倒一下

有时很难看出应该在哪里调整字偶距，因为大脑首先想要知道字母的含义是什么。一个扭转注意力的方法是把字体上下颠倒过来，这样就可以专注于字母的字形以及字偶距，而不被单词本身分心。

![](http://ww4.sinaimg.cn/large/9b5c8bd8jw1f0n4rlmj4ij20ie0dt75v.jpg)


## 06\. 最后再调整字偶距


就设计流程而言，字偶距调整应该是排版和涉及空白调整的工作流程的最后一步。一定要选定字体之后再开始调整字偶距，因为同一字偶距对不同字体看起来效果是不同的。正是这最后一步的字偶距调整让设计看起来更优雅，更专业。

但是在开始调整字偶距之前，应该酌情花工夫看看其他几种空白调整：字距和行距。

- 字距：亦称字元间距，这个「空白」决定了文本整体的紧凑或稀疏。字偶距调整的是一对儿字母的间距，而字距让选中文本使用同一间距，可以一次选中一个单词，一个句子，一段或者一页。如果有必要进行字距调整，就在调整字偶距之前做。
- 行距：就是文本行与行之间的垂直距离。在使用文字处理软件的时候，应该设置过行距吧，这是个常见的功能。尽管没什么必要调整多行文本的字偶距，了解一下改进设计时可以调整哪些间距还是不错的。

另外说明一下，不少程序可以选择许多不同的字偶距设置。除了手动调整字偶距（这个效果总是最佳的）外，还能看到字偶距的「度量标准」或「视觉」[注](参考: https://helpx.adobe.com/cn/illustrator/using/line-character-spacing.html) 选项。度量标准使用字体设计师提供的内置于字体文件中的字偶距。视觉则忽略上述设定，根据某种算法对字体重新进行空白调整和字偶距调整。[这篇文章](http://www.fonts.com/content/learning/fontology/level-2/text-typography/kerning-text-type)介绍了这些选项的工作原理以及该如何选用。


## 07\. 何时调整字偶距


我们反复指出过，调整大且明显的版面的字偶距时的效果最佳，比如，大标题、标题、横幅或带文字、标识及链接的主角照片。但是大块的内文没必要调整字偶距（尤其是手动调整），因为：

1) 字偶距不会对典型的内文字号，比如 10，11 或 12 点，带来可见的影响。

2) 许多字体，尤其是高质量字体，有成百上千的内置字偶距配置。大多数场景下，这些调整过字偶距都会考虑字体的独有的字母形状和结构，没有必要手动调整字偶距，对成段的文本尤其如此。

此外，把一整页文本过一遍，调整字偶距会耗费数小时，没有这么多时间可用。不要花这么多时间在字偶距上，应该全局考虑对哪一块进行调整可以获得最佳效果。


## 08\. 付诸实践


字偶距需要身体力行的设计概念——既要理解其工作原理又要擅长使用它。除开始着手字偶距型项目外，还可以通过[Kerntype](http://type.method.ac/)这个网页游戏磨砺字偶距技巧（还能得到反馈）。


![](http://ww4.sinaimg.cn/large/9b5c8bd8jw1f0n4uxns6ej20ie0cngn4.jpg)


这个游戏并没有教程，工作原理如下：给你一个需要处理字偶距的单词，首尾字母是固定的，然后移动剩下的字母实现视觉上的均匀分布。


![](http://ww2.sinaimg.cn/large/9b5c8bd8jw1f0n4x0ubz4j20ie09u3z8.jpg)


完成后，选择 Both 并点击 Compare ，就可以看到你调整的字偶距（白色字母）与推荐方案（蓝色字母）的对比结果。和推荐方案越接近比分越高。这种练习可以帮助你适应依据视觉调整字偶距的过程。


![](http://ww2.sinaimg.cn/large/9b5c8bd8jw1f0n4w9up6wj20ie0cs0tr.jpg)


## 09\. 给网页设计师的话：你也能调整字偶距！

通常认为，调整字偶距是图像和排版设计师处理静态排版设计时才会用到的东西。但自从网络兴起，对字体有了解的网页设计师和程序员也想调整字偶距。现在也有一些工具可以帮助调整字偶距。[Kerning.js](http://kerningjs.com/)，就是一个用 CSS 处理网页排版中字偶距的脚本。[这里](http://webdesign.tutsplus.com/articles/the-anatomy-of-web-typography--webdesign-10533)可以学习更多与网页相关的字偶距处理及其他排版技术。


![](http://ww3.sinaimg.cn/large/9b5c8bd8jw1f0n4xtq3lcj20ie0bj0uj.jpg)


## 该你了……


知道为什么字偶距很重要了？但愿如此！错误的字偶距会让设计看起来不专业（有时甚至看起来特别愚蠢），不过现在了解了在设计作品中该做什么了吧。不过要当心…… 一旦开始留意糟糕的字偶距，就会发现它无处不在，招牌和广告牌上，商品包装上，所有你能想到的地方上都有。（我已经警告你了哦！）

看过我们的「排版」和「字体」分类下的其他文章了吗？我们这儿有一些特别棒的资料，对提升排版水平好处多多，比如「[如何避免初学者常犯的 20 个排版错误](https://designschool.canva.com/blog/typography-mistakes/)」和「[不得不了解的排印术语表，配有精美插图哦](https://designschool.canva.com/blog/typography-terms/)」。
