
  > * 原文地址：[Is Vanilla JavaScript worth learning? Absolutely.](https://medium.freecodecamp.org/is-vanilla-javascript-worth-learning-absolutely-c2c67140ac34)
  > * 原文作者：[David Kopal](https://medium.freecodecamp.org/@codinglawyer)
  > * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
  > * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/is-vanilla-javascript-worth-learning-absolutely.md](https://github.com/xitu/gold-miner/blob/master/TODO/is-vanilla-javascript-worth-learning-absolutely.md)
  > * 译者：[lampui](https://github.com/lampui)
  > * 校对者：[kyrieliu](https://github.com/KKKyrie)、[Calpa Liu](https://github.com/calpa)

  # 原生 JavaScript 值得学习吗？答案是肯定的

  ![](https://cdn-images-1.medium.com/max/2000/1*E-94pGEukt8lDI2aDY3XcQ.jpeg)

这篇文章的意图是要给每位前端开发者强调 JavaScript 的基本原理。原生（[Vanilla](https://en.wikipedia.org/wiki/Vanilla_software)）是指没有额外框架或库的 JavaScript。本文将会告诉你为什么应该对原生 JavaScript 有一个较好的认识。

我也会提及一些帮助过我学习这些基本原理的资源。

写这篇文章背后的另一个原因是许多有抱负的 web 开发者倾向于跳过 JavaScript 核心概念的学习，诸如提升、闭包或原型。他（她）们直接学习最热门的框架，例如 React 或 Angular 2。我会向你说明为什么这种方法不能称之为一条捷径。

### 每个人都想要有 ${请填写热门的框架名字} 知识的开发者…

那么，还有什么理由让你再费事去学习原生 JavaScript 吗？

![](https://cdn-images-1.medium.com/max/1600/1*eTO0IHM6_MyCNIvBOLp7ag.jpeg)

不了解一门语言本身的核心知识那是很难成为一名大神的，就像在你去一个有特定法律的领域之前，你需要先清楚法律的一些基本原则。[这个比喻](https://ideas.ataccama.com/i-stopped-being-a-lawyer-became-a-developer-and-its-awesome-5311e8d74882)真的很巧。😉

我能理解大多数热血十足的 web 开发者想尽快地找到工作的心情。因为我也想。

看起来去上一门 JavaScript 基础速成班、钻研一些框架、开发个 ToDo 列表（[let a puppy die](https://medium.freecodecamp.com/every-time-you-build-a-to-do-list-app-a-puppy-dies-505b54637a5d)）和上传到 GitHub，然后再开始找工作会简单些。

### …但从长远来看，把时间投入到原生 JavaScript 的学习会更有收获

别误会我，无论如何我都不是对 JavaScript 的各种框架有偏见。恰好相反，许多框架反而能让你书写出可读性和维护性更高的代码，这些框架还能让你写出比平时更容易调试的抽象代码。

但 JavaScript 生态进化得非常快，新框架层出不穷，新功能不断地被添加到已有的功能上，最重要的是，眼下许多热门的框架迟早都会被替代，例如 Angular 1。

在这样的环境下，你还认为具备某个 JavaScript 框架的知识对一名 web 开发者来说就足够了吗？

还是去理解这门语言是如何在这些框架和库的背后运作好点？

![](https://cdn-images-1.medium.com/max/1600/1*wQgXQXDwZe_3f1br1HcHcA.jpeg)

Yes, 你对了！当然是第二个选择。
如果你有一个很扎实的 JavaScript 基础，当开始工作的时候唯一需要让自己熟悉的就是新框架的**语法**，在所有层次的抽象下，基本的规则还是一样的，它还是纯粹的 JavaScript。

如果你的知识仅限于某个 JavaScript 框架，那你学习另一个新框架的时候会很艰难。不同的框架通常是基于不同的 JavaScript 原则。从长远来看，你会花跟多时间去理解不同的框架和调试你写的代码。

所有的 JavaScript 框架和库都不可避免地基于原生 JavaScript。

从长远来看，这应该能说服任何人掌握原生 JavaScript 是必须的。这是对任何一名成功开发者的必要条件，特别是对于一个主要工作在 JavaScript 生态下的开发者。

![](https://cdn-images-1.medium.com/max/1600/1*UkL0I2o1GDdXGUMPecxY7g.jpeg)

### 个人经验

不久前，我回顾了自己是怎样从一名律师转变为一名 web 开发者的[过程](https://ideas.ataccama.com/i-stopped-being-a-lawyer-became-a-developer-and-its-awesome-5311e8d74882#.v3xurb9v5)，从我开始写第一个 JavaScript 函数算起，都有 18 个月了，并且现在是我成为专业前端开发者的第 10 个月了。

我依然记得摸索正确的 JavaScript 学习之路对我来说是多么地有挑战性，因为我之前没有任何的编程经验。我尝试过（至今还在尝试）许多不同的方法成为一名高效的学习者，有些方法会让我收获很多，有些却较少。

最重要的是，开始的时候我把重点放在了学习原生 JavaScript 上面，这对我的帮助太不可思议了。**接下来是框架。**

![](https://cdn-images-1.medium.com/max/1600/1*ixM8cuSIabPQ5Wlj0rgsVQ.jpeg)

[picture credit](https://www.keepcalm-o-matic.co.uk/p/keep-calm-and-learn-javascript/)
现在，我在工作中用的是 [React](https://facebook.github.io/react/)-[Redux](http://redux.js.org/) 技术栈。即便如此，我经常能用原生 JavaScript 的知识解决眼下的一些问题。如果只具备某个框架的知识，这些 bugs 解决起来将会更具挑战性。

学习 React 或 Angular 2 不会教你对象是通过引用传递或闭包是怎样工作的。在更加抽象的框架下，尝试去理解这些概念那就更加困难了。这就使简单的 JavaScript 概念变得更难以理解。

此外，如果你工作中用的是 [JSX](https://facebook.github.io/react/docs/jsx-in-depth.html) (React, Vue, Inferno) 或 [TypeScript](https://www.typescriptlang.org/) (Angular 2)，那你还有另一层的抽象层。

如果你想明白这些框架背后是怎样工作的，你需要先明白 JavaScript 本身是怎样工作的。

你可以通过阅读自己喜欢的框架的源代码**考考自己**对原生 JavaScript 的认识。这样不仅能够呈现一副这些框架背后工作的画面给你，同时也能教会你许多逻辑，顺便还可以用到工作中。你会看到框架里的函数貌似在你的应用中施了很多魔法，但其实这只是一些 JavaScript 基本概念的组合。

### 给我一些可以去学习的东西

你现在可能会问“哪些是能够帮助我学习原生 JavaScript 知识的好资源？”。

现在已经有太多关于 JavaScript 及其框架的课程和书籍。但只有少数是全面地教你理解原生 JavaScript 的，大多数还是专注于某个具体的 JavaScript 技术。

但依然还是存在好资源的…

![](https://cdn-images-1.medium.com/max/1600/1*xPqexrgvo6HsgWM28Bw1-Q.jpeg)

《[JavaScript 编程精解](http://eloquentjavascript.net/)》不仅会教你基本的 JavaScript，同时也会教你广泛适用的编程技巧。如果你已经是一名高级开发者，这本书会向你提供一个关于 JavaScript 和它的核心原则的新视角。

另外一个非常不错的资源是 Kyle Simpson 写的《[你不知道的 JavaScript](https://github.com/getify/You-Dont-Know-JS)》。Kyle 真的知道如何去施教，关于高级的 JavaScript 概念对初学者解释得很友好，并且他将它们涵盖的很深。仅仅是这几本书的标题就已经告诉你要去学习什么，“Up & Going”、“Scope & Closures”、“this & Object Prototypes”、“Types & Grammar”、“Async & Performance”、“ES6 & Beyond”。现在已经有第七册书，名字叫 [JavaScript 中的函数式编程](https://github.com/getify/Functional-Light-JS)。

《JavaScript 编程精解》和《你不知道的 JavaScript》这两套书共同的好处就是**你都可以免费获得**（查看给出的链接）。但如果你发现它们对你很有帮助，别忘记通过购买它们以对作者表示支持。

如果你更倾向于看视频学习，你可以观看[ Kyle 的在线课](https://frontendmasters.com/kyle-simpson/)，我觉得最好把看视频作为是看书的辅助学习，因为这些主题都是一样的。当然啦，这些课程都是免费的。

另一个我觉得有帮助的视频教程是 Anthony Alicea 的 [Javascript: Understanding the Weird Parts](https://www.udemy.com/understand-javascript/)。这个教程以循序渐进的方式解释了 JavaScript 背后发生的事，同时这门教程涵盖了诸如原型继承、函数式编程和作用域链的高级概念。

### 马上学习原生 JavaScript 吧

如果你之前投入过时间学习原生 JavaScript，那你肯定不会后悔。不仅仅是因为**原生**，同时也是因为这会对你日后的编程技巧有好的影响。

对我来说，最好的权衡是相对于花时间学习一门指定的框架，学习原生 JavaScript 会在未来带给你更多好处。框架只是捷径，背后其实都是 JavaScript。

当你用上某个框架，并在某个地方出现异常时你就会明白了，在这种情况下，你会被迫通过浏览源代码去调查这个 bug。我是不是提到过，虽然许多框架欠缺得体的文档，但它们却有复杂的代码？但是，小菜一碟，对吗？你肯定已经花了很多时间学习原生 JavaScript 了？还是没有？

从这篇文章中你应该记住一件事：

牢牢记住原生 JavaScript 会帮助你成为一名更好的开发者。完

![](https://cdn-images-1.medium.com/max/1600/1*-0-CNkI704V7s879GpF86w.jpeg)

如果你喜欢这篇文章，鼓个掌吧，我会很感激你的。

Twitter 见 😊

[![](https://ws4.sinaimg.cn/large/006tKfTcgy1fiv00i5jlnj314i0a60uk.jpg)](https://twitter.com/coding_lawyer)


  ---

  > [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
