> * 原文地址：[iOS: Custom Modality](https://medium.com/@_kolodziejczyk/ios-custom-modality-a193c293d4d6#.b2d4uj1bt)
* 原文作者：[Kamil Kołodziejczyk](https://twitter.com/_kolodziejczyk)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[zhouzihanntu](https://github.com/zhouzihanntu)
* 校对者：[Gocy](https://github.com/Gocy015)、[Mark](https://github.com/marcmoore)

---

# iOS: 自定义 Modal 视图

## Modal 视图越来越多样化，连 Apple 官方人机交互指南都没法三言两语解释清楚。我们又该如何从海量的选择中作出决定呢？

![](https://cdn-images-1.medium.com/max/2000/1*LPXhF6DNBVu8qz4P-sHZTA.png)

当开发者们询问我如何选择视图类型时，我是震惊的。我不得不反复地思考这个问题以及我会选择的解决方案。有趣的是，当发现对视图的选择往往与美学无关时，他们常常会感到惊讶。

我推荐大家去看**iOS 人机交互设计指南**里关于 [Modal 视图](https://developer.apple.com/ios/human-interface-guidelines/interaction/modality/) 的介绍，这是关于 modal 话题的很棒的参考资料。但最近有个朋友和我说，这篇文章的内容还不能满足他的要求。

出于好奇，我查询了各种现有的样式，来看看究竟有多少不同的种类。他是对的，这篇文章的内容确实不够完整。

那么哪种 modal 才是最好的选择呢？我列了一个清单，也许对你做决定有帮助。下面就来看看吧。

### 类型

Modal 是一种使用户从当前工作流中转换到另一个界面，去做一些选择或完成某些任务的视图。当我们需要用户保持注意时它们是最好的工具。

> 与导航控制器这种注重内容和视图层级的视图不同，modal 总是为了某项特定任务而存在。

现在有很多类型的 modal ，它们可能覆盖整个屏幕或屏幕的一部分，也可能显示在屏幕中央或固定在屏幕顶部或底部。有时它们以弹出框的方式出现，有时又从一侧滑出。 **这的确令人困惑。**

在做决定之前你需要考虑一些事。我的经验是先确定视图是让人们**选择**一项任务还是**完成**一项任务。

### **选择器类**

这类 modal 要求你做出一个选择后才能继续操作。它可以是一个警告，或者一个让你指定你下一步操作或选择模式的对话框。

![](https://cdn-images-1.medium.com/max/800/1*llj4coNsU1kwsUIdBgeNAA.png)

- **操作列表** 是显示多个操作选项的最好方式。如果你除了列表没有太多额外需要展示的东西的话，这是个安全的选择。
- **弹出框** 可以应用在之前视图的上下文比较重要的场景，弹出框的箭头在解释视图之间的关系上发挥了很好的作用。
- 如果你要提问或者从用户处获取权限， 最好使用**警告框**。

你可能注意到了以上介绍的视图都没有覆盖到整个屏幕，因为他们应该被**快速使用**，用户选择完就立刻回到之前的界面。

### **操作类**

这类 modal 是为了完成功能任务的，它们适用于添加、编辑等所有复杂的任务场景。

**全屏视图**

![](https://cdn-images-1.medium.com/max/800/1*xu_NhNyGVRNfMl2a0ztL_Q.png)

全屏视图是最常见的 modal 。通过覆盖整个屏幕来引起用户的充分注意，为可能包含多个步骤的复杂任务而设计。

一般情况下，使用全屏视图需要遵守以下两点:

- 完成性操作 (**完成**/**保存**/**关闭**) 总在视图右上角
- 取消性操作 (**取消**) 应该在视图左上角

**非全屏视图**

有的时候你可能会有一些功能影响到部分主视图，在这种情况下最好让主视图作为背景显示。 这样人们就会立刻明白这个 modal 的作用。

![](https://cdn-images-1.medium.com/max/800/1*i4OTZP-ESmIxde2sELE1SA.png)

如果你选择使用非全屏视图的话， 你还要额外考虑两件事:

- **选择合适的过渡方式** 如果一个视图和屏幕上方的内容相关，那就让 modal 从那里滑出。让 modal 以用户可预见的方式出现会令应用的使用体验加分。

- **添加手势关闭操作** 当 modal 以动画形式出现时，人们通常会用与动画过程相反的手势去关闭它(**例如: 把放大的视图缩小**)。对这一操作的支持会让这个应用使用起来更加和谐。

还有一种比较特殊的情况。有时候有些功能可能涉及之前视图的某个部分，这时候也同样可以使用弹窗方式实现。

---

Modal 是个非常有用的工具。刚开始接触可能会比较难理解，但是只要你在你的 app 上实践过，再用起来就会快速和简单很多。

如果你还是决定不了选择哪种 modal ，我准备了一个流程图，你可以把它当做快速参考。

![](https://cdn-images-1.medium.com/max/1000/1*xmvX16jk_E5mxxYDPnAt9Q.png)

希望对你有帮助!
