* 原文地址：[Intuitive Design vs. Shareable Design](https://news.greylock.com/intuitive-design-vs-shareable-design-88ff6bb184bb#.pvcpqeddr)
* 原文作者：[Josh Elman ]( https://news.greylock.com/@joshelman)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[特伦](https://www.behance.net/Funtrip)
* 校对者：[marcmoore](http://ucashin.com)、[L9m](http://liudm.me)

# **直观设计 VS. 共享式设计**

Snapchat 的界面使很多人困惑。这并不是欺负老年人，而是稍微有些年纪的人都会遇到，他们想在Snapchat里处理一些基础操作都很困难。比如说找到它的换脸功能。我无法告诉你有多少人曾向我抱怨 Snapchat。「噢，我想不明白，」他们很苦恼，「为什么它那么复杂？」

我在这里就是想要告诉你，Snapchat 里那些隐晦的设计不是一个 bug，而是一个 feature。就像 Tinder，它的设计非常吸引用户并鼓励他们与其他用户分享使用的经验。实际上，这是一个能[让 Snapchat 如此成功](http://www.wsj.com/articles/snap-begins-the-ipo-process-1479244471)的关键点。

Snapchat 是被我所称为的「共享式设计」中的一个最好的例子。对于那些在成长过程中一直把「直观设计」作为终极理想的人来说，这种新方向有点突兀。但一旦你弄懂它是如何运作的，你将会认为它是非常有道理的。

#### **直观设计的革命** 

我不是想要贬低直观设计。实际上，当上个世纪 80 年代直观设计出现的时候，这对于过去的计算机界面来说是一个巨大的飞跃，从上个世纪 60 年代到 70年代，计算机界面复杂，不直观，需要大量的学习才能去使用它们。那些界面需要你记住大量的命令行并且在正确的时间回想起正确的那一个条目。人们很骄傲于自己能记住许多的命令和参数，而无需去查找手册。

图形用户界面（GUI）是一个巨大的进步。不像那些为团队工作，在指定的计算机机房使用大型机或微型计算机的用户，个人电脑用户通常是在家或者在他们的办公室里试图弄明白自己的电脑和软件。他们没有时间去阅读手册或者去上一门课程只为了学习如何使用一个新的软件。有的人只是需要坐在他们的桌子前，打开一个软件，比如说电子表格，他们希望能够轻松使用它们。软件公司为了打开这部分市场必须让软件变得直观，好让你可以自己去探索如何使用它们。

![](https://cdn-images-1.medium.com/freeze/max/30/1*4QMlSI-DHb0k7His7Hx84g.png?q=20)<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*4QMlSI-DHb0k7His7Hx84g.png">

以前微软 Excel 的工具栏

比如，微软用了大量的时间去弄明白如何把软件设计地更加直观。我们可以针对他们在审美上是否成功保留见解，但是像 Excel 这样的软件来说它在市场上是非常成功的，因为用户有很多种方法去探索它里面的功能，只需要随处点击。这就是为什么工具栏和菜单栏看上去会像这样。它们很丑，但它们是有用的，因为它们足够**直观**。当然了，如果还不够简单，人们会去买书并跟着上面的步骤一步一步学习。我曾经花费了一个夏天的时间来实习，在一家叫做 Catapult Press 的公司作为[Microsoft Step by Step books](https://www.microsoftpressstore.com/series/series_detail.aspx?st=99028) 的「校验员」，当我在书中寻找错误的时候，我以最无聊的方式学习了这本书。

在那个同样的时代，苹果花费了很多时间去弄明白如何让它们的操作系统变得尽可能地直观。苹果在 1987 年出版了一本书来介绍它们的人机交互指南，这本书从 Macintosh 时代甚至到互联网时代都[影响非凡](http://tantek.pbworks.com/w/page/34457520/Web%20Human%20Interface%20Guidelines) 。

所有的这些作品都是基于出色的软件和产品设计师们在 80 年代和 90 年代的研究。Don Norman 的 [*Design of Everyday Things*（日常设计）](http://www.jnd.org/books/design-of-everyday-things-revised.html)在软件设计师中非常有影响力，尽管它是专注于工业设计（实物设计）。Brenda Laurel 的书 [*The Art of Human-Computer Interface Design*（人机交互设计的艺术）](https://www.amazon.com/exec/obidos/ASIN/0201517973/o/qid=981345710/sr=2-1/103-8893962-0315059)于 1990 年出版，它现在还在我的书架上。这些书都是具有开创性的作品，它们的影响力一直持续到了今天。
#### **移动设备让一切变得触手可及**

当 2008 年科技界开始聚焦于移动设备的时候，一切事都改变了。突然间，软件设计师不再只把坐在办公桌前为自己工作的人作为目标用户。世界各地的用户在自己的手机上使用他们所制作的 app，周围常常有其他人：他们的朋友们、家人们、同学和同事。

![](https://cdn-images-1.medium.com/max/800/1*DTTjwC4XI41I6NTMzxUJlg.gif)

物理世界的手势，就像滑动，放大，和点击这样的手势是自然和人性化的。

当界面设计转变到移动设备之后，创造了两个互补的新趋势。一个是用到了更多的物理世界的手势。因为你会直接用你的手指去触摸软件，而不是用鼠标或键盘去操作它，这让人感觉更加人性化。甚至小孩子们也能明白这个：看看这个视频吧[小宝宝试着点击和放大一本杂志](https://www.youtube.com/watch?v=aXV-yaFmQNk)，因为他想要让它能像 iPad 一样运作。滑动，捏起，放大，点击：所有这些操作都在直观地模拟自然的人类身体手势。几年前我写了一篇文章，讲述了「[触摸的革命](https://techcrunch.com/2013/09/29/generation-touch-will-redraw-consumer-tech/) 」是怎样把不同的产品连接起来的，因为它们直接相互作用。

第二个转变，这是许多界面设计师都还没有明白的，那就是人们在现实世界中通过观察他人来学习新的事物。大多数 18 岁的孩子们通过观察他们的朋友们来学习如何使用一个新应用。教程就在那里，在他们朋友的手机上，所以他们只需要把手机拿出来并向他们展示怎么做。

这实际上是回归到一种我们原本去学习事物的方式。你通过观察其他人学习了扔一个球，捡起一顶帽子，系好你的鞋带还有打开一扇门。当你再长大一些，你可能通过别人的教导学会了如何骑自行车或者驾驶汽车。所以，如果现在应用变得更加物理化（在应用的层面），为什么我们不可以通过观察他人来学习它呢？

你想知道如何使用 Snapchat 吗？套用 [Groucho Marx](https://www.brainyquote.com/quotes/quotes/g/grouchomar141793.html) 的话，这很容易：只需要[找到一个十几岁的孩子来告诉你](https://www.youtube.com/watch?v=T-VVv6D9ot0)。有些很会玩应用的人可以告诉你任何事，从怎样拍照片并在上面涂鸦到如何使用滤镜，如何得到隐藏颜色的画笔，比如黑色或白色，如何使用换脸功能，如何用二维码添加好友，甚至更多更多。

#### **进入共享式设计**

共享式设计深刻理解了人类的学习本能这一社会属性，并利用人们的欲望去学习和教学。

在这方面做得很聪明，因为这些看似不起眼的特点是一个机会，让它的使用者们可以向他们的朋友去展示一些很酷的新玩意儿。给朋友看一些很酷的东西可以增加你的社交地位，或者是给你一种很棒的感觉。这绝对是你愿意去做的事！对于 Snapchat 来说，这是很棒的，因为它将你变成了一个它们产品的「传教士」，你甚至不觉得你在「传教」：你只是在教你的朋友如何灵活地做一件事。

![](https://cdn-images-1.medium.com/max/800/1*RQYCS0leu9YR8TrLQUruaQ.gif) 

Musical.ly 的影片在 Instagram，Facebook 和 Twitter 上传播得非常广泛。

像这样的分享也并不一定只发生在人之间。Musical.ly 在 2015 年开始成长为一个很酷的应用的时候，它是用来制作有趣的音乐视频的。当人们在 Instagram 或者 Facebook 上分享他们的 Musical.ly 视频的时候，你常常会看到他们的朋友询问这些东西是如何制作的。这给了人们一个机会说，「噢，我在用 Musical.ly。」它通过受众，一个人传播给另一个人的，因此 Musical.ly 成长地非常迅速。

除了鼓励分享，这种设计还有两个好处。一，它使功能点变得非常难忘。如果有人告诉你在你的 iPhone 上长按一个人的名字，这样会有一个弹出菜单允许你把他们的信息保存到你的通讯录中，那你的印象会很深刻。这是一个与社交记忆相结合的物理记忆，所以它很容易在你脑海中留存。

另一个好处是，这些功能不占用任何屏幕空间。手机的屏幕真的很小，所以屏幕上你可以安排给按钮和图标的地盘也非常非常小。很显然，上个世纪 90 年代 Windows 应用里那被占满的工具栏在这里是不好用的。但那些 「看不见」 的功能，比如一个长按，一个 3D touch 「重」 按，或从屏幕顶划到顶部，这些操作都没有在占用屏幕上的地盘。

虽然我们还没有一本很好的书来介绍共享式设计，但是有些设计师，像 [Luke Wroblewski](http://www.lukew.com/)，写了很多关于移动设备设计的有意思的文章，里面已经有这样一些概念。当然，也有一些应用程序和操作系统的设计者们理解了这个理念：比如 Snapchat，PRISMA，最新版本的 iOS，甚至在一定程度上 Twitter 也是这样。

我乐于看到更多的人研究和写关于共享式设计的文章。这是一个重要的领域，随着我们进入充满可穿戴设备，增强现实的更加多样化的移动设备世界，它会越发重要。如果你有什么好例子，也请多多沟通。
