
  > * 原文地址：[How VR Is Changing UX: From Prototyping To Device Design](https://uxplanet.org/how-vr-is-changing-ux-from-prototyping-to-device-design-a75e6b45e5f8)
  > * 原文作者：[Justinmind](https://uxplanet.org/@justinmind)
  > * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
  > * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/how-vr-is-changing-ux-from-prototyping-to-device-design.md](https://github.com/xitu/gold-miner/blob/master/TODO/how-vr-is-changing-ux-from-prototyping-to-device-design.md)
  > * 译者：[Lai](https://github.com/laiyun90)
  > * 校对者：[halloween](https://github.com/shawnchenxmu) [Larry](https://github.com/lampui) 

  # 虚拟现实是如何改变用户体验的：从原型到设备的设计

  ![](https://user-gold-cdn.xitu.io/2017/8/14/5e5931ff4c92ab5fccd061f240632e7b)

## 虚拟现实（VR）正在不断改变着我们定义用户体验（UX）的方式，但是一条经久不变的原则仍然是体验必须以人为中心。

你有没有曾经畅想遨游太空？或者看一场甲壳虫乐队的现场演出？随着虚拟现实技术的最新发展，你甚至不必离开舒服的沙发，就能让你的梦想在现实中模拟实现。

但是这些新技术对用户体验来说意味着什么呢？随着新兴平台的涌现和技术的快速发展，用户体验是这些技术成功的关键。因为如果人们要在日常生活中采用这些新技术，那么这些技术就必须是可信赖的。

正如 [Daniel Terdiman](https://www.fastcompany.com/3058259/for-oculus-to-succeed-vr-needs-to-succeed) 指出的：

> 「 **虚拟现实（VR）公司**深知任何平台或设备上的糟糕的 VR 体验，都会将人们永久地隔离于整个科技之外。」

让人们正确了解并使用 VR 是至关重要的，这也正是用户体验的意义所在。

### 虚拟现实（VR）是什么?

在了解虚拟现实是如何改变用户体验之前，让我们先来看看最近几年虚拟现实出现了哪些技术，并给出相关定义。由于不同的术语会让人感到困惑，所以这里我们给出一些明确清晰的表述。

首先，三个改变现实的重要技术：

#### 虚拟现实 (VR)

虚拟现实技术创造了一个全新的世界。只要你想，你就能模拟现实。虚拟现实（VR）所做的是将用户传送到一个完全由技术生成的不同的地方。如果你需要一个脑海中的形象，那么想象一下类似 Oculus Rift 的 VR 头盔，它将会为你创造一个属于你自己的世界。

#### 增强现实 (AR)

接下来介绍增强现实（AR）。增强现实是将生成的图片或视频覆盖在现实世界之上。想想 Pokémon Go 或者宜家 [应用目录](https://www.youtube.com/watch?v=vDNzTasuYEw)，它能够让你在买之前，看到家具在你家里是什么样子。

#### 混合现实 (MR)

混合现实就是将生成的图像和真实世界的事物结合起来。 Keith Curtin 曾说过这是 [2017 年最重要的技术](https://thenextweb.com/insider/2017/01/07/mixed-reality-will-be-most-important-tech-of-2017/#.tnw_1frSRiaM)。混合现实所做的是在智能虚拟对象上呈现出真实的世界。

### 原型设计在虚拟现实中是否发挥作用？

用户体验在虚拟现实中是不可或缺的，所以原型设计对于创造一个可信赖的虚拟现实体验至关重要。正确的虚拟现实体验是必不可少的，可以进行快速迭代的交互原型让你离成功更近。

即使是在设计虚拟现实体验的阶段，定义交互并创建逻辑工作流程也是很有必要的。虽然是一个虚拟的现实，UI 设计仍然占据中心地位。

虚拟现实中的大部分设计都是 3D 的，但是在 3D 设计开始前，为了节省时间并在用户测试阶段进行增量调整，2D 的原型界面仍然有用  —— 你一定会惊讶于 [原型可以适应设计的过程](https://www.justinmind.com/blog/how-to-improve-your-web-and-app-design-process-with-prototypes/)。

### 虚拟现实中良好的用户体验（UX）

糟糕的用户体验会影响虚拟现实，那么在虚拟现实用户体验中，有哪些必要的、可以未雨绸缪的原则呢？

- 可信的：虚拟现实中的体验必须是可信的，也就是说你感受到你真的在那儿。
- 可交互的：虚拟现实必须有良好的交互性，所以当你伸出手臂时，虚拟现实世界也必须复制该动作。
- 可探索的：你必须能够在虚拟环境中行走（甚至飞翔）。
- 沉浸式的：将探索和可信结合起来，你会真正的沉浸在其中，全方位地享受虚拟现实带来的体验。

### 虚拟现实用户体验的成功案例

虚拟现实有各式各样的用途。其中之一是帮助老年人安享晚年。Rendever 是一家总部位于马萨诸塞州的虚拟现实公司，他们运用虚拟现实技术，帮助老年人重新享受生活。 

据 [Rendever](http://rendever.com/) 宣称，50% 的依靠生活辅助设施生活的居民感到抑郁和孤立。该公司力图以创新的方式运用虚拟现实技术，来减少这一数字。

### 为老年人设计的 VR 

想象一下：你是一个没有能力去旅行的老人，而你的孙女正在这个国家的另一边举行婚礼。结果往往是，错过这个重大日子的祖父母会感到失望和沮丧。但是随着虚拟现实技术的发展，这个老人将有可能坐在婚礼现场的前排，让我们感谢虚拟现实。

>**「老年人可以体验 2D 图片不能提供的强大时刻。」**

### 在手术期间用虚拟现实去旅行

虚拟现实技术也应用在医学上。外科医生利用虚拟现实技术，帮助那些经受了重大甚至于改变生命手术的病人保持镇静。

麻醉剂是用于镇定病人的，但是在一些情况下却不能使用。为了减少手术过程中的焦虑和压力，墨西哥城的一家私人诊所用虚拟现实头戴设备将病人传送到秘鲁的马丘比丘等目的地，在接受治疗的过程中让他们分心，而这种做法 [很有效果](https://mosaicscience.com/story/virtual-reality-VR-surgery-pain-mexico)。

### 虚拟现实有助于减轻患者的疼痛

在加利福尼亚州，心理学家亨特霍夫曼（ Hunter Hoffman ）开发了一种虚拟现实游戏来帮助病人减轻疼痛。SnowWorld 试图直接将病人的注意力从疼痛转移到一个充满冰雪的世界里，在那里他们可以在企鹅中扔雪球。没错，是真的。 

值得注意的是，报告显示 SnowWorld 的用户比那些尝试其他方法减缓疼痛的用户 [减少了 50% 以上的痛苦](https://thenextweb.com/insider/2017/05/09/study-vr-twice-as-effective-as-morphine-at-treating-pain/#.tnw_c6Wwxja2) —— 对于一个好的用户体验来说这意味着什么？

### 构建虚拟现实体验时的 UX 挑战 

如果用户曾经有过不好的虚拟现实体验，他们可能会害怕尝试 VR 。所以 UX 设计，或者说 **好的 UX 设计**，必须是任何虚拟现实体验的核心要素。这意味着，从适当的灯光和流畅的动作到实际的设计，每个细节都必须认真考虑。

### 增强虚拟现实中的用户体验

但是 UX 超越了虚拟现实。设备的设计也扮演着重要的角色。没有人想要佩戴笨重的耳机，沉沉地压着自己。为了提高虚拟现实的体验，制造一个轻量级和多功能的耳机是至关重要的，否则用户满脑子都是一个会让他们颈部疼痛的耳机，这样是无法完全沉浸在虚拟现实中的。

### 让你的 VR 体验可信

虚拟现实提出的最重要的挑战之一是，VR 体验可能看起来或感觉上不是真实的。你能想象潜入凉爽的加勒比海水域，却只能发现设计拙劣的鱼和设计不当的地形吗？

虚拟现实体验的 UX 设计应该尽可能令人信服。这意味着让用户处于控制地位，完全把控体验。要让用户忘记他们身处模拟现实，一定要做到可交互。为了解决这个 UX 问题，许多虚拟现实体验都提供了 360 全角度的、完全身临其境的体验。 

#### 虚拟现实在真实生活中的影响

VR 模拟现实的同时，也不要忘记使用 VR 会给真实生活造成影响。这意味着在虚拟现实体验中会让你感到恶心晕眩。不要惊讶，这是真的。和晕动病是一样的。

让人们拒绝 VR 的一点是使用过程中感到头痛和恶心。在**UI 设计**中，只需要避免任何快速移动或者速度变化，就能防止用户感到晕眩想吐。

### 但是 UX 设计师可以在 VR 领域做些什么来验证实践呢？

首先，虚拟现实相关的 UX 设计师，要了解技术是如何实现的。可以看看 [AR 的本质](https://www.wareable.com/vr/how-does-vr-work-explained)。这意味着需要温习一些新词汇，比如能够区分头部跟踪（head tracking）和运动跟踪（motion tracking），能够了解 HMD 的含义等。

#### 了解 3D 相关工具的最新信息

作为 UX 的从业者，我们需要持续关注最新的技术发展，包括用户测试方法。 我们习惯于做 [用户测试](https://www.loop11.com/user-testing-a-mobile-app-prototype-essential-checklist/) 来帮助测试移动应用程序原型。

当我们开始一个新的设计时，持续和严格的用户测试可以帮助我们评估某些东西是否有效。

虚拟现实中的用户测试也有其明显的缺点：为大量用户提供多个 VR 耳机设备是昂贵且困难的，而且，测试附着在脸上的东西也是很复杂的。

了解 [虚拟现实用户测试](https://omobono.com/insights/blog/designing-vr-how-conquer-challenges-user-testing-vr) 背后的方法是非常重要的，不过想要征服它们也并非不可能。 站在用户肩膀上窥视的日子已经一去不复返了。

最后，虚拟现实为 UX 打开了许多扇门。但是虚拟现实的 UX 有些曲折。鼠标的指向和点击在设计有关面部和语音识别、动作追踪和潜在的脑电波的体验中会显得有些平庸。这些只是少许的 UX 设计师必须让自己了解的一些新的输入方式。 


  ---

  > [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
  
