> * 原文地址：[How to use colors in UI Design](https://blog.prototypr.io/how-to-use-colors-in-ui-design-16406ec06753#.tq2uvi1tw)
* 原文作者：[Wojciech Zieliński](https://blog.prototypr.io/@acreno)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：
* 校对者：

# How to use colors in UI Design

Practical tips and tools.

![](https://cdn-images-1.medium.com/max/2000/1*9oD9bg_2Lzk96ZQ1zWNofA.png)

Color is like everything else, it’s best used in moderation. You will tend to get better results if you stick to max three primary colors in your color scheme. Applying color to a design project has a lot to do with balance and the more colors you use, the more complicated it is to achieve balance.

> Color does not add a pleasant quality to design — it reinforces it.
> Pierre Bonnard

If you need additional colors beyond those you’ve defined in your palette, make use of shades and tints. They will provide a different tone to work with.

#### 60–30–10 Rule

This interior design rule is a timeless decorating technique that can help you put a color scheme together easily. The 60% + 30% + 10% proportion is meant to give balance to the colors. This formula works because it creates a sense of balance and allows the eye to move comfortably from one focal point to the next. It’s also incredibly simple to use.

> 60% is your dominant hue, 30% is secondary color and 10% is for accent color.

![](https://cdn-images-1.medium.com/max/1600/1*0xxsagnyMnsMwHu8unMXrQ.png)

Wall paints, furnitures, accesories.
#### Color meaning

Scientists have studied the physiological effects of certain colors for centuries. Besides aesthetics, colors are the creators of emotions and associations. The meaning of colors can vary depending on culture and circumstances. That’s why you see black&white fashion stores. They want to appear elegant and sublimely.

[![](https://cdn-images-1.medium.com/max/1600/1*ujJjQupQ8K4V0jLx-9DyTw.png)](http://www.asos.com/majorelle/majorelle-havana-romper/prd/7313528?iid=7313528&amp;clr=Mint&amp;cid=2623&amp;pgesize=36&amp;pge=0&amp;totalstyles=751&amp;gridsize=3&amp;gridrow=7&amp;gridcolumn=1)

Asos is pure black&white with green CTA. It’s made for a reason.
- **Red:** Passion, Love, Danger
- **Blue:** Calm, Responsible, Safe
- **Black:** Mystery, Elegance, Evil
- **White:** Purity, Silence, Cleanliness
- **Green:** New, Fresh, Nature

If you want more check this list — [color culture](http://seopressor.com/wp-content/uploads/2015/06/colour-culture1.png).

#### Grayscale first

We like to play with colors and tones early in our designs but this behavior can betray you very quickly when you will realize that you’ve spent 3 hours adjusting primary color … It’s really tempting but you should learn to avoid this attitude.

Instead force yourself to focus on spacing and laying out elements. It will save you a lot of time. That sort of constraint is very productive. On the flips side, it doesn’t need to look boring. Try different tones if you want to make it good looking.

[![](https://cdn-images-1.medium.com/max/2000/1*PHn3cUFzAXIGPgkYHcU_PA.png)](https://dribbble.com/shots/2856867-avsc-wireframes)

One of my work that you can find on dribbble. Simple monochromatic colors and focus on elements.

#### Stay away from pure grayscale and black

One of the most important color tricks I’ve ever learned was to avoid using gray colors without saturation. In real life, pure gray colors almost never exist. The same goes for blacks.

![](https://cdn-images-1.medium.com/max/1600/1*EDsUvHerEgqAO_uGX-EHfg.png)

Darkest color on this image is not #000, it’s #0A0A10

Remember to always add a bit of saturation to your color. Subconsciously it will look more natural and familiar to users.

![](https://cdn-images-1.medium.com/max/1600/1*TNerL_olPuxnUN04c-WiNQ.png)

---

![](https://cdn-images-1.medium.com/max/1200/1*Yf1h7jZ-x4L8u6SB1UpDBg.png)

#### Believe in nature

The best color combinations come from nature. They will always look natural. The best thing about looking to the environment for design solutions is that the palette is always changing.

> To get inspired we only need to look around

#### Keep the contrast

Some colors go well with each other, while others will clash. There are definitive rules for how they will interact that can be best observed on a color wheel. You should be aware of this methods but it’s not necessary to do it manually.

![](https://cdn-images-1.medium.com/max/2000/1*wBgIJcrKQ58KSmLTYMSxOA.jpeg)

If you want to learn more about color theory check this article — [Color Theory For Designers: Creating Your Own Color Palettes](https://www.smashingmagazine.com/2010/02/color-theory-for-designer-part-3-creating-your-own-color-palettes/)

#### Get inspired

When we are talking about UI references then dribbble is the best place for it. It also has tool for searching by colors so when you want to do visual research on how particular color was used by other designers then go here [dribbble.com/colors](https://dribbble.com/colors/)

![](https://cdn-images-1.medium.com/max/1600/1*lQECsRNQv1Amrb4s_CT35g.png)

Videos, print design, interior design, fashion… there are so many inspiring places to gather from. Simply don’t be inert to those palettes and save everything that looks interesting.

[![](https://cdn-images-1.medium.com/max/800/1*qFM-0R3jWkZCeTDqr_yTKg.png)](https://www.youtube.com/watch?v=fF8l_ePlOH4)

[![](https://cdn-images-1.medium.com/max/800/1*tAIY6eDVhqGvdcqhYYMVSw.png)](https://www.youtube.com/watch?v=dISNgvVpWlo)

[![](https://cdn-images-1.medium.com/max/800/1*KmdQC4HgNqybXuVTnU4v_A.png)](https://www.youtube.com/watch?v=WkdtmT8A2iY)

Often time I like to steal colors from KPOP videoclips. They are *gorgeous*.

### Tools

To make things easier, I rounded up some of the best tools for choosing color palettes available in 2017. They will save you a lot of time.

#### Coolors.co

Definitely my favorite tool for picking colors. You can simply lock selected color and press space to generate palette. Coolors also gives you the ability to upload an image and make a color palette from it. The cool thing about it is that you are not limited to only one outcome but instead you have a picker that allows you to modify reference point.

![](https://cdn-images-1.medium.com/max/1600/1*h0rwE1e1-6HGVMXFIJTeyQ.png)

[![](https://i.vimeocdn.com/video/613814638.webp?mw=1400&mh=814&q=70)](https://cdn.embedly.com/widgets/media.html?src=https%3A%2F%2Fplayer.vimeo.com%2Fvideo%2F200337992&url=https%3A%2F%2Fvimeo.com%2F200337992&image=https%3A%2F%2Fi.vimeocdn.com%2Fvideo%2F613814638_960.jpg&key=d04bfffea46d4aeda930ec88cc64b87c&type=text%2Fhtml&schema=vimeo)

#### Kuler

This tool from *Adobe* has been with us for a long time. It is available in the browser, and in desktop versions. If you’re using the desktop version you can export a color scheme into Photoshop.

![](https://cdn-images-1.medium.com/max/1600/1*NhUjE0XmvzY2fXLDhImNIQ.png)

#### Paletton

It’s similar to Kuler but the difference is that you are not limited only to 5 tones. Great tool when you have primary colors and want to play with additional tones.

![](https://cdn-images-1.medium.com/max/1600/1*gk_RnbERuLFXkm-qdqad5Q.png)

#### Designspiration.net

Imagine that you have an idea for your color palette but you want to see examples of this mix. [Designispiration](http://designspiration.net) is a great tool for this. You can pick up to 5 colors and search images that are matching your query. Really good not only for finding images with the specific palette but also for real implementation of them in design.

[![](https://i.vimeocdn.com/video/613792304.webp?mw=1400&mh=968&q=70)](https://cdn.embedly.com/widgets/media.html?src=https%3A%2F%2Fplayer.vimeo.com%2Fvideo%2F200319959&url=https%3A%2F%2Fvimeo.com%2F200319959&image=https%3A%2F%2Fi.vimeocdn.com%2Fvideo%2F613792304_960.jpg&key=d04bfffea46d4aeda930ec88cc64b87c&type=text%2Fhtml&schema=vimeo)

#### Shutterstock Lab Spectrum

You may ask — what if I want to search for photos with my chosen color? Well, Shutterstock has a tool called Spectrum where you can search photos by specific tone. You don’t even need subscription because small preview image with watermark will be enough to generate palette.

![](https://cdn-images-1.medium.com/max/1600/1*Y9YXp4qUmbhWNlyCNsul3g.png)

#### Tineye Multicolr

But if you want to search mix of colors in the photo and even specify the amount of each one, then Tineye will help you. This website uses a database of 10 million Creative Commons images from Flickr.

[![](https://i.vimeocdn.com/video/613819877.webp?mw=1400&mh=932&q=70)](https://cdn.embedly.com/widgets/media.html?src=https%3A%2F%2Fplayer.vimeo.com%2Fvideo%2F200342210&url=https%3A%2F%2Fvimeo.com%2F200342210&image=https%3A%2F%2Fi.vimeocdn.com%2Fvideo%2F613819877_640.jpg&key=d04bfffea46d4aeda930ec88cc64b87c&type=text%2Fhtml&schema=vimeo)

### Final thoughts

Color is a tricky concept to master, especially in the digital era. Tips mentioned above will ease the job of finding the right colors. The best way to learn to create stunning color schemes is to practice so do yourself a favor and play with colors.
