# GitHub是如何阻止网络暴力的

* 原文地址：[ What GitHub did to kill its trolls ](http://fusion.net/story/369325/how-to-stop-online-harassment/ )
* 原文作者：[  Kristen V. Brown ](http://fusion.net/author/kristen-v-brown/)
* 译文出自：[掘金翻译计划](https://GitHub.com/xitu/gold-miner)
* 译者： [wild-flame](https://GitHub.com/wild-flame)
* 校对者：[marcmoore](https://GitHub.com/marcmoore), [Romoe0906](https://GitHub.com/Romeo0906)

几年前，创业者熟知的 GitHub 就面临了一个尴尬的现实：GitHub 在变成一个让人厌恶的地方。

GitHub 作为一个为程序员提供分享项目代码并在线合作的网站，2014 年是它发展最快的时候。但是，随着用户数的增多，相应的麻烦也变得越来越多。Julie Ann Horvath，一位在 GitHub 工作的程序员，就因为饱受 [性别歧视](http://money.cnn.com/2014/03/17/technology/GitHub-sexual-harassment/) 的折磨而离开了公司，这个新闻事件也让 GitHub 站在了舆论的风口浪尖上。

更糟糕的是，不多久 GitHub 就发现这不仅仅是他们公司内部的问题。辱骂和歧视在它们的整个网站上都呈现一种蔓延的趋势。整个在线社区都充斥着一种 [歧视女性](https://www.theguardian.com/technology/2016/feb/12/women-considered-better-coders-hide-gender-GitHub) 的氛围，女性并不如男性受重视。小小的不合就会演变成一场评论大战。比方说一个分手的男人，就在他前任女友的每一个项目里都说了一些不堪入目的话语。而那些性别主义、种族主义的喷子们，则利用那些原本为合作提供便利的特性来攻击别人。比方说，利用标签特性，把这个人的主页和用种族主义词汇命名的项目标记起来，就可以将这个人的项目集变成一系列的含糊不清的种族主义词汇。

Nicole Sanchez，公司公关部的副总裁，发言说「这些都是网络自带的危险和隐患」，虽然这是一种普遍现象，但 GitHub 仍在很积极地消除它们。

很让你惊讶对吧？一个给程序员分享代码的网站竟会成为滋生不当言论的乐土。但 GitHub，这个估值两亿的网站，本质上仍然是一个社交网站，它是一个面向程序员的 Facebook + Linkedin 的混合体，所以必然包含了大量的人与人的互动。在互联网上，有人的地方就有谩骂。

为了力挽狂澜，GitHub 雇佣了 Sanchez —— 关于多元化的咨询公司 [started Vaya](http://www.sfchronicle.com/business/article/For-some-startups-tech-s-lack-of-diversity-is-6052546.php) 的创始人。

"为了把全世界所有的程序员连结起来，我们首先需要营造个安全舒适的社区环境。" CEO Chris Wanstrath 说。

开始工作以后，Schaez 从雇佣、绩效考核到公司的装修，重新安排了公司的诸多事务。GitHub 刚成立的时候，是一个不分等级的公司，公司里没有职称，也没有经理。但 Sanchez 废除了这个制度，因为她发现，如果没有管事的，那么人们也不会为他们的错误承担责任。她首先调整公司的内部环境，使其对多元文化更友好，比方说建立一个通畅的官方建议渠道。她还招进了 February Keeney，一个有一半波多黎各血统的变性人，带领新成立的「社区安全组」去消除网站上的不当言论。

鉴于硅谷当时的文化，这是一个很采取的立场。GitHub 和许多技术公司一样，都曾害怕限制用户言论。许多做技术的人都觉得网络应该是一个开放且自由的地方，他们认为，即便是处理那些最恶毒的言论，其实也是损害了用户言论自由的权利。比如 Twitter，它一直拒绝对自己的不当言论问题公开致辞，并自诩是「言论自由的领袖」。

「人们对于『开源』太教条了。」Sanchez 说，「人们总觉得『开源』意味着随时随地并且无条件开放给任何人。」

一些不期望改变的 GitHub 雇员，曾匿名在媒体上抗议说：Sanchez 试图 [控制](http://www.businessinsider.com/GitHub-the-full-inside-story-2016-2) GitHub 的文化。不过最终，她还是取得了大部分人的支持。

「那些污蔑其实不仅仅是让人不舒服。」Sanchez 说，「它实实在在的在削减我们的用户量。」

2014年，一份 [报告](http://fortune.com/2014/10/02/women-leave-tech-culture/) 调查了女性离开技术圈的原因，其中，极客文化 —— 当然包括了污蔑、诽谤和骚扰 —— 是她们离开的一个重要原因。用户的多样性曾是 GitHub 成功的重要原因，也正因为此 GitHub 决定要根除网上的各种不当言论。

GitHub 不仅仅是需要在内部执行一份新的行为准则，他需要考虑产品的各个方面，排除其中可能被用户做恶意行为的细节。该死的喷子们！

GitHub 并不是唯一的一个意识到互联网上的丑陋行为不会自行消失的公司。两年前，这些技术公司在面临网络暴力的问题时，还常常以言论自由来为自己辩护，或者不予理会。但 [丑闻](http://www.newsweek.com/ellen-pao-kleiner-perkins-john-doerr-buddy-fletcher-314293)、[批评](http://fusion.net/story/327103/leslie-jones-twitter-racism/)、[网络暴力](http://fusion.net/story/270090/sxsw-gamergate-science-and-the-internets-harassment-problem/)，使得大家开始重新考虑这个做法。

去年二月，Twitter 的 CEO Dick Costolo [公开承认](http://www.theverge.com/2015/2/4/7982099/twitter-ceo-sent-memo-taking-personal-responsibility-for-the)「我们在处理网络暴力这件事情上做的很差」，这是一次号召。从那时开始，Twitter 以及其他公司开始积极地尝试各种解决办法。九月时，Instagram 发布了一个新功能，允许用户 [屏蔽恶意词汇](http://fusion.net/story/347364/instagram-comment-moderation-policy/) 。今年秋，Google 暗示说它在开始 [构建 A.I. 来对抗网络暴力](https://www.wired.com/2016/09/inside-googles-internet-justice-league-ai-powered-war-trolls/)。甚至连最让人不爽的 Reddit，也 [封了他最不好的方面](http://fusion.net/story/168376/reddit-will-still-allow-hate-speech-but-itll-be-slightly-harder-to-find/)。

「现在有这么一种时代浪潮，」GitHub 的首席商务官 Julio Avalos 对我说，「雇主对雇员的期望发生了改变，客户对公司的期望发生了改变。人们会以脚来投票的。」

![Julio Avalos, GitHub's Chief Business Officer.](https://i0.wp.com/fusion.net/wp-content/uploads/2016/11/screen-shot-2016-11-14-at-12-28-03.png?resize=670%2C617&amp;quality=80&amp;strip=all)

Julio Avalos, GitHub 的首席商务官

Twitter 便是忽略这股浪潮的反面教材。作为一个有十多年历史的老公司，Twitter 基本上对网络暴力视而不见，使他成为 [喷子](http://womenactionmedia.org/cms/assets/uploads/2015/05/wam-twitter-abuse-report.pdf) 和 [憎恶](http://fusion.net/story/359668/twitter-anti-semitism-adl-report/) 们 [最爱去的地方](https://www.buzzfeed.com/charliewarzel/a-honeypot-for-assholes-inside-twitters-10-year-failure-to-s?utm_term=.ohBx6EKra#.dm0pE9yw6) 。因为网络暴力，一些 [大V用户](http://fusion.net/story/327103/leslie-jones-twitter-racism/) 也离开了 Twitter。这家问题缠身的公司最近几个月疲于寻找买家，有人猜测 [Twitter的网络暴力](https://www.theguardian.com/technology/2016/oct/18/did-trolls-cost-twitter-35bn) 是一个重要原因。

喷子们已经成了网络时代的祸害。可悲的是，互联网上已经充满了混蛋，真的是应该需要做点什么的时候了。

但是，在现实生活中你都无法避免所有的暴力和辱骂，你要怎么在网络上避免他们呢？拿  Twitter 来举例子吧，他们推行 [禁止色情报复](http://fusion.net/story/102264/twitter-bans-revenge-porn/)，发布 [反骚扰条款](https://blog.twitter.com/2015/fighting-abuse-to-protect-freedom-of-expression-0)，成立 [信任安全委员会](http://thenextweb.com/twitter/2016/02/09/twitter-now-has-a-trust-and-safety-council-to-help-its-users-feel-safe/#gref)，暂停 [有辱骂嫌疑的大V用户的使用权](http://fusion.net/story/327536/milo-yiannopoulos-nero-permanently-banned-from-twitter/)，但仍然没能阻止网络上的暴力。

BuzzFeed 的 Charlie Warzel 今年初在他的一篇文章中 [写道](https://www.buzzfeed.com/charliewarzel/a-honeypot-for-assholes-inside-twitters-10-year-failure-to-s?utm_term=.awWPe3z94#.eeW97xOwg)：「在Twitter上，辱骂并不仅仅是一个错误（Bug），用硅谷的专业术语来说，它是一个基础特性（Feature）。」

## 治疗网络暴力并没有什么万能药的。

「网络暴力无休无止。」Nathan Matias，MIT 专门研究减少网络歧视和辱骂的研究员说，「可能的结果非常多，而通过目前掌握的线索来找到我们期望的解决方案就如同大海捞针一般。」

当 GitHub 下决心跟网络暴力一战到底的时候，它也招进了 Ada Ehmke —— 一个变性人，从那时开始，她就成了 GitHub 最重要的批评家。

Ehmke 曾经是 GitHub 设计的受害者之一，她是 [Contributor Covenant](http://contributor-covenant.org/) 的作者，一个许多 GitHub 项目都志愿遵守的准则。但并不是所有在这个基于自由意志而存在的开源社区里的人都欣赏她，甚至有一些人开始攻击她。当时 GitHub 没有任何功能允许用户选择不被标签，所以攻击者们开始将 Ehmke 与种族主义名字相关的项目标记在一起，以污染她的 GitHub 个人主页 —— 那是一份记录了她所有开源项目的页面。这就好像某人在她的简历上画了个纳粹标记，然后再把它交给她未来的雇主。

![GitHub engineer Coraline Ada Ehmke.](https://i0.wp.com/fusion.net/wp-content/uploads/2016/11/coraline_speaking.jpeg?resize=640%2C427&amp;quality=80&amp;strip=all)

GitHub 工程师 Coraline Ada Ehmke.

「这些喷子是很聪明的。他们从各种工具中寻找便利，然后将其作为武器攻击别人。」Ehnke 说，「如果你从来没考虑过你的产品会如何被用来人身攻击，那你的工作是不到位的。」

当去年二月 Ehmke 被雇佣为资深工程师的时候，有一些人就因此对 GitHub 的招聘方向感到很气愤。

> [@CoralineAda](https://twitter.com/CoralineAda)[@GitHub](https://twitter.com/GitHub) So you are going to ruin GitHub just like the SJWs are ruining Twitter?
>
> — Jon (@42zarf) [February 25, 2016](https://twitter.com/42zarf/status/702704096499912705)

> 「所以你也希望像那些圣母毁掉 Twitter 的一样毁掉 GitHub 么？」（译注：SJW 就是 social justice worker）

「我刚开始工作的时候，作为男性，我有很多优势。」Ehmke说，「尽管我一直都知道存在这样的事情，但是直到我变性之后，才开始真正理解那些人。开源社区对于非男性或者非白人一直都很不友好。」

每个同我在 GitHub 谈过话的人都强调说，要解决 GitHub 上的网络暴力，首先是应该要解决公司自己内部的问题。

「如果我们自身一开始就不是多元化的，我们又如何能将这种多元化传递给用户？」Avalos（一个危地马拉人，在 GitHub 还没有老板责任制的时候就加入了公司）对我说，「我们不希望对那些会使用户远离我们产品的事实视而不见。」

社区和安全小组由六个人组成，包括两个变性的人、四个女性，三个为有色人种和两个「有象征意义的男性白人」，换句话说，比起一般的硅谷团队更「多元化」。

他们的工作不仅仅是构建新的「反网络暴力的工具」，也包括诊断各种 GitHub 的功能，预测他们会如何被用来诽谤。

「在 GitHub 里，我们不仅仅是一个工程师团队。」Ehmke 对我说：「我们被认为是关键的基础设施，在 GitHub，这些事情被认为和保持灯光一样重要。」

团队迫使 GitHub 做出的最大的改变就是要求 GitHub 的工程师们在平台中建立「同意和意向」。比如，用户有权利同意被一个用户标注。这可以阻止类似于 Ehmke 的种族主义标签的事件再次发生。所以 GitHub 调整了用户标记功能，需要用户批准。

## 「我们不打算对产品中疏远人的部分视而不见。」

但主观意图是一个很微妙的事情。在 GitHub 上说一些听起来很冒犯的话并不一定说明那个人是想骂你。「You suck」既可以被当中一个中性的鼓励短语，也可能是朋友之间的一句玩笑而已。

「我们意识到，不当言论其实分为两类。」Keeney 说，「一类就是故意的，而另一类，就像那些开地图炮的玩笑的人一样，根本没有意思到自己的地域歧视。」

GitHub 需要找到更灵活的方法来处理这些行为的细微的差别。

上个月，公司发布了一条 [社区指导](https://GitHub.com/blog/2267-introducing-GitHub-community-guidelines) 的草案。它包括 [禁止行为](https://help.GitHub.com/articles/GitHub-community-guidelines/#what-is-not-allowed) —— 辱骂，歧视和欺凌 —— 并清楚地阐明了什么构成那些行为。 还有 [破坏规则的后果](https://help.GitHub.com/articles/GitHub-community-guidelines/#what-happens-if-someone-breaks-the-rules) ，从删除内容到帐户终止不等。

而作为 GitHub，它已要求其社区提供一些反馈。一个用户看了看拟议准则，并建议其将色情也拒之门外，包括一些可能与性教育或生殖健康相关的项目。 最终，GitHub决定，满足社区需求的最佳方式就是请求社区的帮助。

例如，审核评论这个特性，如果被用户和开源项目的管理者所共同管理可能会更好，这样更容易发现一个看上去无礼的笑话是否真的冒犯了别人。

「现在，管理者唯一能做的就是删除评论，举报或者在一个项目中禁止某人。」Keeney 说，「但我们希望确保我们为管理者提供一系列工具来应对问题。不同的问题需要不同的反应。」

最后，Keeney 告诉我，GitHub 计划推出一系列工具，可以让项目管理者做更多的事情，比如禁言一个问题成员仅仅几天的时间。

![February Keeney, the manager of GitHub's Community and Safety Team.](https://i0.wp.com/fusion.net/wp-content/uploads/2016/11/bio-photo-e28093-february-keeney.jpg?resize=670%2C670&amp;quality=80&amp;strip=all)

February Keeney, GitHub 社区与安全组的经理

GitHub的做法有三个核心原则：在功能上让用户不易被骚扰、为用户提供新的保护工具、通过社区来运筹帷幄。

据 GitHub 表示，到目前为止，整个策略已经相当成功了。阻拦和报告的恶意事件数增加了，表明用户实际上正在使用网站的新工具。另一方面，当恶意事件真正发生时，响应用户所需的时间减少了。

## 「我们赋予用户管理自己体验的权利越多，结果越好。」

其他在线社区也在采取类似的策略。Reddit 上的 r/science 就建立明确的社区规则，并征集了约 1300 人的来维护这些规则，成功的将充满火药味的帖子变成了民主讨论。

「任何合理的治理在线行为的方法都至少要求用户做一些工作来管理社区，」Matias告诉我。 「当社区开展这项工作时，我们通常会获得更多的责任感。」

Instagram 和 Twitter，最近也开始想用户提供更多的处理不当言论的能力。11月，Twitter 发布一一份[新特性](http://fusion.net/story/370271/twitters-new-harassment-tools/)，允许用户从通知里屏蔽某些单词和短语。

「网络暴力的形式有许多种。」Del Harvey，Twitter 的信任与安全部门的副总裁对我说。「预测哪些言论是让用户感到厌恶是不现实的，我们赋予用户管理自己体验的权利越多，结果越好。」

## 网络上的不是每一个地方都需要非常干净

「网络上的不同地方，需要不同的社交模式。」乔治亚理工学院的一个研究在线社区的研究员 Amy Bruckman 说，「网络上也应该有一些不那么光鲜的地方，只要他们不跨越那条边界」

换句话说，这都取决于规定是什么。就像真实的世界一样，不同的人会去不同的地方。Reddit 是你家旁边的潜水吧，而 Facebook 是街角的咖啡厅。我们都知道，在4点的酒吧发生的事情，不可能发生在咖啡厅里的。

最后，这些公司做的最大的改变就是，他们愿意失去一些棘手的用户。

发表不同的见解是不同意识之间互相交流的一部分。而对人骂 "bitch" 却不是。 但是，找到他们之间的平衡却很难。在 GitHub 上，新雇佣的雇员和新发布的规定都给社区造成了严重的冲击。并不是每个人都会因此开心，但 GitHub 现在只需要操心在更少的用户上面了。最后，这些公司做的最大的改变就是，他们愿意失去一些有问题的用户。

「如果用户不喜欢我们创造的新文化，可以选择其他的。」Nicole Sanchez 对我说，「对我们来说，我们不介意和你划清界限。」
