>* 原文链接 : [How To Make Your Not-So-Great Visual Design Better](https://medium.com/facebook-design/how-to-make-your-not-so-great-visual-design-better-67972eee3825#.4e6hpsbkz)
* 原文作者 : [Jasmine Friedl](https://medium.com/@jazzy33ca?source=post_header_lockup)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : [Liz](https://github.com/lizwangying)
* 校对者: [Gran](https://github.com/Graning)，[Jiegao Zhu](https://github.com/JolsonZhu)

# 产品设计怎样做才最优雅 

![](https://cdn-images-1.medium.com/max/2000/1*nN4SgP1q4iEmRfoW9NTMyg.png)
Photo by William Iven
图片来自 William Iven


如何才能改进你的产品视觉设计呢？

这个问题困扰了很多人。我在产品设计方向辅导、指导了很多学生，比如在圣弗朗西斯科艺术学院担任导师，在 AIGA Portfolio Day 作为产品复审，在 Facebook 辅导实习生等。

学生的观念与专业产品设计师之间有这样一座桥梁，它由敬畏、激情、好奇心和满腹的疑问组成。
 
*“我毕业后会何去何从？”*
 
*“设计相关的工作都有什么？”*
 
*“我适合做什么样的工作？”*
 
*“如果我找不到工作怎么办？”*
  
*“如果根本没有职位招聘怎么办？”*
 
*“我能为找工作准备些什么？”*

最近，我们在[ Facebook 举办了一场自我评论](https://medium.com/facebook-design/peek-inside-a-facebook-design-critique-c4833efda26e#.4qt02buac)，其中有一位来自康奈尔大学的学生 [Jon Lee](https://medium.com/@jonleenj)。在我们为数不多的互动中，他身上有一些东西我很欣赏。那就是他的自我认知。他了解自己在视觉设计上有哪些地方需要提高。他有如此清晰地自我认知，归功于他从潜在的雇主身上得到的反馈，就像很多即将步入职场的同学一样，好奇作为一个设计师需要什么样的技能。他想知道怎样才能做得更好一点。

成为一个产品设计老司机需要广泛的技能，具备 visual chops 是很重要的，尤其是在 Facebook。令我兴奋的是，Jon 在这方面很好奇，如果他现在在我身边，我会问 Jon 一个曾问过很多同学的问题，并给他提供一个方案，希望能够在 这个项目之外对他有所帮助。
  
这里有一个 Jon 分享的设计作品概览。从这里开始他才真正地在视觉设计的道路上踏上正轨。

![](http://ac-Myg6wSTV.clouddn.com/d6cd82b49c70fc153a0f.png)  
Jon Lee 为应用 Nearspace 设计的概念图。
   
在 Facebook，我们经常将视觉设计的评判标准分为工艺和执行力。为了能够评估 Jon 这个作品的水平，并且激励他设计出更好的作品，我需要在评价他的作品之前向他提问和调查，因为这样更好地了解了别人的设计意图。
 
### 你的层次结构是什么?

- 你修改过你的设计风格么？我看到了两个风格（标题的大小写问题），至少三种大小类型、两种颜色、还有居中和左对齐两种类型。
- header（头部）风格是哪一种？按钮的风格是什么？ body copy（广告正文）的风格呢？ metadata（元数据）呢？

### 你使用的是什么样式？ 

- 按钮的字体有两种大小，两种按钮高度，两个外壳，三种颜色，我还看到了带有 icon（图标）的按钮。

![](http://ac-Myg6wSTV.clouddn.com/1565099b887dd65adc38.jpeg)

- 有两个不同的列表样式。一个显然是关于实时的发现模式（照片和业务名称、类别和星级），另一个看起来像一个线框（最近的发布的）。

- 列表和按钮的设计风格有什么区别？在概要文件页面，卡片、按钮和列表是使用相同的白色背景，灰色轮廓样式。他们应该设计成不同的风格么？
 
### 这种设计样式和现有的或已经发布的样式哪家强？

- 如果选项能够切换，那么他们会自动切换么？取消和应用有必要么？ 
- 点击返回和点击取消是一样的么？把右上角换成X可以么？  
- 我看到有一个重置按钮但是它没有起到任何过滤的作用。有必要在这种情况下添加这个按钮么？应用按钮能够取代重置按钮么？
- 从用户体验角度，需要这个底部的导航条么？
- 在同一垂直方向上的这些控件是否平行？他们都是必要的么？

![](http://ac-Myg6wSTV.clouddn.com/01f5de79ae872536f138.jpeg)

### 你的 margin（外边距）和 padding（内边距）的规范是什么？

- 我从附近页面和资料页面看到很多细微的外边距；过滤页面更具有明显的外边距。
- 在附近页面的竖直方向的地步导航几乎贴近了屏幕的边缘。
- 为什么不用网格布局？

### 你的 icon（图标）表达出想要呈现的意思么？

- 我看到一个表示“座位”的图标有单个座位、三个座位和六个座位的图片聚集在一起。这是一个座位的计数还是一些座位数的大约值？又或者是一系列的座位么？有没有一个更好的方式来设计表达这个含义？这是“团购”有优惠的意思么？有没有另一种方式设计它？
- 为什么没有明显的标志表示两个相反的意思？如果不是重要的元素，为什么你要显示出来这种无足轻重的元素？初步结果难道不应该包含所有可用的选项么？
- Pie (派，一种食物)在这里是想表达 pie (派)？还是指代甜点？又或是代指所有食物？杯饮料意味着什么？你是假定认为每个餐厅都能够提供饮料吗?有更好的分组吗?

### 你的选择设计风格的一致么？

- 我看到在使用下拉过滤功能时，有一些过滤按钮选项的样式略有不同。
- 一些只有 icon (图标) 的按钮，而某些按钮只有文字。
- 一个按钮有角度，然而其他没有。 wifi 图标的线很粗；但是插座的线很细。有些像素化，有的则不是。一些是黑色的，又有一些是灰色的。

![](http://ac-Myg6wSTV.clouddn.com/2b08ea063e6a0dee2170.jpeg)

- 大多数的卡片和按钮拥有同样的样式：角弧度半径，轮廓，填充颜色等风格。他们是不是*过于*一致？

### 屏幕上所有的元素都是必要的么？

- 在搜索区域上方有一个分割线，还有每一个可选选项下方也有一个分割线。
- 有一处使用了绿色
- 导航使用了 icon (图标) 和文字，它们有同时存在的必要吗？
  
### 你怎样选择你的配色方案的？
  
- 你的配色方案是比较简约的暖色调，除了一个亮绿色的按钮。你有怎样的设计原则，在哪些地方应用了？


![](http://ac-Myg6wSTV.clouddn.com/eabacd8b944dffa24c68.jpeg)
  
### 你的拼写、语法和标点符号正确吗?你的内容有逻辑吗?

- “Nearby（附近）” 页面和 “Profile（概况）” 页面底部的导航条经常出现，但是这个 “add（添加）”是什么鬼?添加什么?
- “Availability” 这个单词拼错了。
- 这个 “Availability（可用）” 有存在的必要么？
- 页面的“阅读量”是怎样计算的？（是读完所有文字还是只是匆匆一瞥算是一次阅读量的累积）你的页面标题是“过滤器”，但是你的头部显示为“距离”，另外这个页面可以过滤剩余可得座位，有无 Wifi ,插座和食物/饮料。但是你能向你的朋友解释清楚这个页面能做什么？这些页面结构合理么？它们的命名正确么？

![](http://ac-Myg6wSTV.clouddn.com/26652ca0f75030a68f5e.jpeg)

### 这个设计可移植性高么？

- 如果你是为安卓平台设计的这款桌面，在其他平台你也会做出同样的设计决策么？在不同平台下，你的设计决策会不同么？
 
如何改进你的产品视觉设计？
  
*解答*以上这些问题只是一个设计作品成功的开始。成为一枚优秀的设计师——成为一枚牛掰的“视觉”设计师——需独具匠心。这意味着你在以一个设计师的角度来考虑和解答每一个问题，而不是别人发现这些问题时木已成舟，那就为时已晚了。

接下来的工作就是“针对性”的回答这些问题，确保你的设计意图是基于坚实的设计原则、研究和对细节的关注，当然啦，比如类似于风格和偏好这种问题，就会非常棘手。因为不是每个设计师的都有这些意识或者是理由充足的主意。这很正常，因为在提高你的设计的道路上，你首要做到的就是接受你的作品现在还并不完美。  

Ira Glass 对此有很棒的[观点](https://vimeo.com/85040589):
   
> 没人会向别人吐槽菜鸟——就算有人看出我菜，我也希望他不要嘲讽我——因为我们都是搞创作的...我们从事这行是因为我们有品位。这就像是一个瓶颈期，最初的几年你创作的东西，现在看来你是不是认为他们很一般？对吧？它们并不咋地。它们真的就是一般。但是你在*努力*地做到好，你有信心自己能够做好，但虽然你的作品真的没那么优秀。但是你的*品位*——用来搞创作的装备——还是你作品的修正符，它就是当你在看到你所创作的成果时心中略过的那丝丝缕缕的失望，你懂伐？
   
如果你有品位，它就能自己告诉你还有多少需要提高的地方，和应该怎样提高你的视觉设计。

**多观察世界上设计作品然后形成自己的见解**什么是好的,什么是不好的。在你的见解中加强基础的设计原则。
   
**多浏览设计系统的搭建**比如材料设计（material design）和人机界面指南（Human Interface Guidelines）。
   
**多练手**

**多浏览网站、多下载 app **，在 Dribbble （一个有名的设计网站）上浏览优秀的设计作品，切记**不能**复制别人的作品，而是问**为什么**这样设计就好呢？然后去揣摩答案。

**依然是勤动手练习**
   
**向那些有设计见解的人展示你的作品**——就是那些技术不错的老司机设计师们，听取他们对于你的作品的意见，然后思考他们对于你的作品背后的设计意向。然后去找答案。
 
**不断地自我反思**比如我们刚刚提到的。
    
现在我可以给 Jon 一些反馈，比如你的“设计风格种类遍地都是”、“你的绿色按钮格外突兀”。我还给他指明了一些解决办法比如“左对齐所有过滤器的类别中的按钮”、“缩小按钮的圆角半径”、“为你的品牌颜色选择一个亮色调”，如果“你”想使你的作品更好，就要不断打磨，细细雕琢。

别人对你作品反馈和指导能够起到同样的作用;进步最快的方法通常是实践出真知，而不是只懂得规范
。
练习才能进步。一次又一次的努力尝试这种执行能力是初学者们第一次进入设计师这个角色,一旦设计师这个角色在你心中落定，它会一步一步引导你进步。
