> * 原文地址：[How to Go From Hobbyist to Professional Developer](https://medium.freecodecamp.com/how-to-go-from-hobbyist-to-professional-developer-11a8b8a52b5f)
> * 原文作者：[Ken Rogers](https://medium.freecodecamp.com/@kenrogers)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 译者：[zaraguo](https://github.com/zaraguo)
> * 校对者：[SareaYu](https://github.com/sareayu) [DeadLion](https://github.com/deadlion)

# 如何从一个业余爱好者成长成为专业开发者 #

![](https://cdn-images-1.medium.com/max/2000/1*LZZ9Sr4XL7j2-LjSJ5uq9Q.jpeg)

几年前，我正处于园林设计工作和餐馆工作两头跑的状态中。那时我刚离开大学校园，不知道未来我将靠什么为生。

我有许多想法，却毫无方向。在那段时间里，我开始自学编程。起初这只是一个爱好。我觉得仅靠自己的大脑和代码去创造东西是一件很酷的事。

逐渐地我开始思考生活前进的方向，并视以编程为生为一个有可能的生活方式。

一开始，我也只是随便想想而已。我负担不起现代教育的费用。我早就因为钱的原因而辍学了，如果要修计算机科学专业，我必须重新开始。

我已经离开大学校园整整六年之久。如果我选择重返校园学习计算机科学还将给我带来超过五万美元的负债。所以这条路行不通。

然后我想到我可以通过自学 Web 开发来获得一份实习工作。

我最初的计划是向镇上的几家公司推荐我自己，问他们是否愿意和我见面。我想和他们谈论我一边读书一边帮他们打工的可能性。通过这种方式我可以支付我的学费，同时获得一些工作经验。

因此我开始认真对待 Web 开发。

不是东学一点西学一点而是开始构建一个真实的作品集并记录自己的技能。

我开始活跃在类似 Stack Overflow 的网站。

我写了一些实用的程序并将其放在了 GitHub 上。它们没什么特别的，但是它们展现了我的编程能力。

有家公司拒绝提供我临时工的岗位。也不用我获得学位。他们直接提供了我一个试用期六个月的全职初级工程师的岗位。

我开心极了。事实证明，认真并带有目的地开始学习编程，让我收获了相当多的知识。

我有能力回答他们的提问，向他们展示我那微不足道的应用，并解释其工作原理。

我在那家公司工作了两年半，之后在我生活的城市获得了一个 Web 开发的职位。

## 把自己视为一个终生学习者 ##

我将我在上一家公司工作的经历视为一个学习过程，尽我所能地去学习，这在我成长为一个专业工程师的道路上起到了相当大的作用。

在公司里工作所获得的实践真知是无价的。知道如何与客户、同事相处以及遵守公司制度是十分重要的。而这些你只能从实践中获得。

虽然我比刚开始的时候知道的更多，我一直视自己为一个学徒。渴望不断学习是成为一个伟大的开发人员的重要条件。一旦我们觉得我们已经掌握了某个技能，那么我们就会停止成长。

海明威曾说过：

> 我们在工艺上都是学徒，而且从没有人成为大师。

他这句话说的是写作，但是在程序开发方面也同样适用。

在工作的同时不断自学令我收获颇丰（[我甚至写了本书](http://meteorandreact.com/)）。我了解了关于网站开发的一些实用技术，同时从一个业余爱好者成长为一个专业开发人员。你们也可以做到，无论你们有多少时间和能力。

再和你说件事儿，我曾经同时做两份工作，其中一个需要我早上四点就爬起来开着叉车到处跑。

作为一个生活忙碌的成年人，想要学习编程需要有决心、动力以及倔强的坚持。

### 从入门到精通

下面是一个你可以遵循的流程。每个人的学习过程的确会有所不同，但是有一些好的建议有助于你走上正轨。

#### 1. 相信自己可以做到 ####

任何人都可以通过自学成为一个开发者。有一种观点是自学只有特定类型的人能做到，这在某种程度上是正确的。你需要自我驱动，而不是被能立即得到回报的动机驱动。但是任何人都可以成为这种类型的人。

现代社会存有“天赋不是人人都有”的这种观点。这种观点不利于我们的成长，也是许多人在生活中感到不满的原因之一。

如果你执着于自己是否有天赋这一点，那么你将很容易沮丧。

我要立马把这种错误观念抛诸脑后。任何人可以自我驱动并且自学编程。或者开始一个成功的业务，或者实现一个长期目标。

这无关你是否抓住了一个大机会，或是天赋异禀。持之以恒才是关键。

如果你能够埋头苦干，即使困难的时候也不放弃，坚持不懈，那么没有什么事情是你办不到的。

最后一点相当重要，但是我想先给你们提个醒儿再继续。

人们总是更倾向于关注自己和他人的成功。这就是著名的[幸存者偏差](https://youarenotsosmart.com/2013/05/23/survivorship-bias/)。

运气的确客观存在。有时候有了它事情会变得相当的顺利。例如，我之前联系过一个 Web 开发的机构，幸运的是他们当时正好在招人并且我恰巧符合他们的要求。

但什么是运气呢？

当然，我获得那份工作有运气的成分在，但是如果我没有下定决心去自学开发，那么有运气也是没用的。之后我果断地决定去申请这份工作。

运气的确有一定的作用，但是凡事全靠运气却是不对的。要想自己更加好运，你就应该更加投入于你所做的事情。

但是好运并不会眷顾胸无大志之人。

#### 2. 持之以恒在促成你的作品方面有着难以置信的魔力 ####

我最大的缺点之一就是容易感到厌倦和分心。我会不断想要跳过目前的工作进入下一个项目。这种趋势会断送你的成功。

根据心情选择项目固然很自由，但是……

![](https://cdn-images-1.medium.com/max/800/1*ZXYdFihJqlj0-mIlO1-t6g.jpeg)

这是一个陷阱！你可以忽视本文的其他观点，但请记住一点：

**成为一个专业的程序员最重要的一点就是坚持。持之以恒决不放弃直到作品完成。**

这句话到处适用。

人们非常在意选择什么框架去使用。但是关键的是选择一个并坚持使用。你可以之后再转去学新的语言和框架。

重要的是在开发时学会解决问题的技能，并像开发人员一样思考问题。

我自学的时候使用的是 Laravel，但是雇佣我的公司使用 CakePHP 来进行开发。没事，他们知道我有切换框架的能力。

选择一个方向并深挖下去，无论你选择的是什么。同时你需要清除其它的干扰项。

这种精益求精的过程中有着一种无与伦比的美妙感受。

它的确不易。但是一旦你学会不分心，你将发觉到工作中持续增长的乐趣。

Mike Rowe 常说：人们不应该在发现自己的激情后才开始行动。

人们郁郁寡欢。执着于寻求一个完美的事业，一个充满激情的事业。

但是激情来自于对作品持续不断完善的渴望。一旦你养成这个观念，那么你的开发能力将有一个质的飞跃。

#### 3. 立即开始搭建你的项目 ####

有抱负的程序员有时候会陷入只看不行动的境地。

教程和书籍对于基础学习的确很有帮助。但问题是它们会给程序员灌输虚假的自信。

如果你曾经看完一本编程书然后动手编程时却发现自己毫无思路，那么你就知道我在说什么了。

解决方案很简单，但是并不容易。

开始编程。

做点什么东西。开发一个应用解决你自己生活中的问题，或者针对于你身边人的某个问题。

做些好玩的东西。

做点东西，并且对外展示。把它开源并放在 GitHub 上。你做这些不是为了别人而是为了自己，所以你不需要担心别人对此的看法。

你的代码一开始会很丑陋。即使我现在看自己一个月前写的代码我都觉得惨不忍睹。但是如果不做点东西你是学不会开发的。书本很棒，我沉迷于看很多很多的书。但是在那之后你必须不断去应用你看到的知识。

你会遇到很多问题，举步维艰。这很好，这时候我们学到的东西最多。

开始做点小东西来解决问题，这个我会在下面的第六点详细讨论。

#### 4. 创建一个线上身份 ####

一旦你开始做点小项目，你会需要创建一个线上的身份。拥有自己的 GitHub 账户是一个不错的开始。

你可以在这里放置你正在着手的项目，并与全世界的人分享。

如果你想要的不止如此。那么我推荐你创建一个个人网站。

这个网站有以下的几个作用：

1. 它是一个公开向潜在雇主展示你自己的地方
2. 它是一个可以展示你作品的地方
3. 它将成为你的舞台

最后一点十分重要。一旦你开始做项目，你就应该立即开始记录他们。开始用一个简单的博客去分享你正在做的事情并且传授你所知道的一切。

这是向潜在雇主展示你身份和能力的最好方法之一。它可以让大家看到你，并且过程中你也将构建出属于你自己的平台。

这可以带来工作机会和在写书或者自由职业方面获得额外收入的可能。

你的网站应该有明确的目的。

很多人制作在线简历，但是你要做的不止如此。你的目标是什么？你的网站需要围绕这个目标设计和创建。

如果你想要一个基于某个特定项目或者框架的工作，你可以将其放在你的网站上。

我建议你的网站要有以下四个主要构成部分：

1. 主页

你的主页是你网站的入口点。它应该提供一个非常简要的介绍，关于你是谁，你是做什么的。并指引大家找到他们最感兴趣的内容。

比如，你可以有两个主要的按钮。一个引导人们前往你的博客列表去学习一些关于网站开发的知识，另外一个用来引导有意聘用你的人前往你的招聘页面。

2. 博文

这里是放置你的博文以及教程的地方。尽可能多地写一些博文，并且不要害怕去分享他们。

3. 关于我

简单的关于我板块可以展现更多你是谁做什么的细节。不要把它当做你的个人史。再次声明，这一板块核心内容是你想做的事情。

不要谈论你的私人生活，而是谈论什么使你成为一个网站开发者，你做过什么，以及未来的规划。谈论一些你喜欢的项目并给出展示链接。

4. 聘请我

这是你个人网站非常重要的一个部分。这是展现给有意向聘请你的人的板块。

找好“包装”和诚实的平衡点。这个页面的内容可能和关于我页面有部分的重叠，但是这个页面将更加明确你的技能以及你可以给公司带来的好处。

这个页面还需要有你的联系方式以便他人可以联系到你。

除了维护自己的个人网站，你还可以给一些知名出版社写文章。然后在你网站的个人简历板块附上文章链接。

#### 5. 开始传授你会的一切知识 ####

Nathan Barry 是一个酷爱传授知识的家伙。他讲过 CSS Tricks 的创始人 Chris Coyier 的故事。

这个网站一开始是 Chris 用来公开记录一些他在学习的东西以便他人借鉴。现在它已经是最大的 Web 开发站点之一。

这个故事告诉我们你不必在成为世界最厉害的专家之后才去写东西和传授东西。

在网络商业的世界中，有一个相对专家的概念。这个概念是说每个人相对于别人在某一个特定方面都是专家。

我对此存有疑虑，特别是被用来推销某些不应该被卖出的商品的时候。这只是一个有用的类比。

困扰我的是使用专家一词。我不认为传授你知道的东西有什么问题，你甚至可以向需要的人们贩卖这些知识。

但是自称专家好像又言重了。所以当你写东西的时候，请尽量保持内容真实性。

我更喜欢在公开场合定期学习。

有很多人是从成为一个公开的学习者开始他们的学习的。他们学习手艺同时并记录下来他们学到的东西。

这是传授你所知道的一切的一个很好的方法。随着你学到的东西越来越多，你构建出自己的内容，并在这个期间成为一个更好的书写者。久而久之，你将在你的圈子被其他人视为权威人物。

无论在找工作或是自己单干方面，这都十分的有价值。

#### 6. 为解决问题而开发 ####

做事有明确的意图是成为一个专业的程序员最重要的方面之一。

为了乐趣随意开发应用是一回事，为了解决问题去开发应用和网站又是另外一回事。

电商本质其实不是程序开发，其本质是关于解决问题。代码只是他们首选的工具而已。

任何一本市场营销的书或文案都会告诉你去推销商品的优点而不是特点。

Web 开发人员应该通过展示他们如何有效地解决了用户的问题来推销他们的应用。然后用具体的指标来支撑他们的言论。客户通常对这种方式的介绍更感兴趣，而不是听开发者谈论他们使用的尖端技术。

如果你能证明你的编程技能, 并能用代码解决问题和创造有意义的应用, 那么你将非常受雇主欢迎。

当你与潜在雇主或是客户沟通时，以及在为你的网站编写内容时，请进行优势与功能这两方面的思考。

当然，你也应该提及你的编程熟练程度，但是大部分人在这个方面花了所有时间。简要地介绍一下好让潜在雇员知道你在做什么就可以了。如果你开发了一系列很有用的程序，那么它们将会为你的编程技能说话。

#### 7. 采取学徒心态 ####

你认为你掌握技能的那一天便是你停止学习的一天。

养成终生学习的观念。总是有更多的东西去学习，有更大的空间去进步。

这在你早期的职业生涯相当重要。如果你兼职或实习或担任初级开发人员，你需要尽可能快速进入学习和成长状态。

你真的应该马上这么做，即使你还没有一个真实的“导师”。

在[工作的艺术](https://www.amazon.com/Art-Work-Proven-Discovering-Meant/dp/0718022076)这本书中，Jeff Goins 谈论了二十一世纪的师徒关系。

回到中世纪，这种关系非常正式。大师会带一个徒弟多年，直到徒弟慢慢地掌握手艺达到大师的头衔，那时他们就可以收自己的徒弟了。

虽然这种关系已经发生了改变，但是将自己视为一个学徒仍然十分重要。有所不同是的是现在你需要自己关注潜在的导师和学习机遇，他们遍布你的征途。

在 Web 开发的世界里，我们经常上网，所以学习形式多种多样。

书本，教程，课程，专题讨论会以及其他形式的学习都是十分有价值的。但是我觉得最有价值的学习形式是从你想成为的人身上学习。

这就是为什么乐意并热切地去学习是这么的重要。得到了你的第一份开发工作不是征途的结束，而只是开始。

当采取了学徒心态你将真正开始学习并且你的知识将呈几何级数地增长。

#### 8. 学会合作 ####

将编程作为兴趣和以编程为生之间的最大差别就是你需要学会与他人合作。

你需要与同辈、老板、同事、客户、合作公司沟通和合作，并且在你的职业生涯中你会遇到形形色色的人。

学会如何与他人有效地合作是十分重要的。

在 Web 开发领域，沟通是关键。当一个公司向你们表达自己所需时，如果你对他们所表述的东西不清楚，那么会给未来的工作带来很多头疼的问题。

同样的，如果你不能与同你一起工作的人们良好地沟通，你的工作也将遭遇很多问题并无法完成。

如果你还在学习的话，我这里倒是有几个不错的建议可以给你。

当你开始传授你所知道的知识时可能就会遇到这些问题。人们将与你进行交互，有时候这些交互是负面的，你需要学会如何去处理这种情况。

我还十分推荐大家去给开源项目做贡献。你将收获在一个项目中与带有不同观点的人们合作的体验。

参与开源项目的确是一件令人胆怯的事情，但是它会给你的开发生涯创造奇迹。

[看看这个网站然后开始](http://www.firsttimersonly.com/)

### 动身去以此谋生 ###

成为一个 Web 开发者是困难的。意味着你的一生需要永不止步地学习和不断接受新的事物。它是一个不仅需要精通技术还需要了解业务和沟通的职业。

成为一个 Web 开发者还是一条非常有利的道路。你将制造产品来解决人们的问题，使他们的生活更加便利，同时你将拥有非常棒的生计。

帮助你去学习编程的资源有很多，[他们大多数还是完全免费的](http://freecodecamp.com/)，但是帮助人们转变成为专业的开发人员的资料却很少。

我希望这个简短的指导可以为你指明一条好的道路以帮助你成为一个专业的开发者。

记住，如果你不采取行动什么都不会发生。搭建一个简单的个人站点，给一些潜在的雇主发邮件，在 Medium 上发表一些文章。反正就是要开始有所行动。

你越展示自己，做得越多，那么你将越快从业余爱好者成长成为一位专业人士。

我正在考虑开设一个在线研讨班教开发者如何从业余爱好者成长成为专业人士。如果你对此有兴趣，可以在下方留下你的邮箱地址让我知道并且我将为你们提供第一手资料。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)。
