> * 原文地址：[How to design words](https://medium.com/@jsaito/how-to-design-words-63d6965051e9?ref=uxdesignweekly#.97vnoptue)
* 原文作者：[John Saito](https://medium.com/@jsaito)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[jiaowoyongqi](https://github.com/jiaowoyongqi)
* 校对者：[cbangchen](https://github.com/cbangchen), [funtrip](https://github.com/funtrip)

# 如何给你的产品写文案？

严格来说，我是一名文字工作者，我靠文字赚钱。但我有一件事大部分人都不知道：**我讨厌阅读。**

别理解错了我的意思，我现在依旧保持着阅读的习惯。我会定期浏览书籍、博客、新闻以及杂志。但当作者们把文章写得越来越拖拉，我就不知道我的眼睛到底在看哪里，脑子也越来越迟钝。





![](http://ac-Myg6wSTV.clouddn.com/06ace735d89bb435285d.png)



这样的文章就像一面文字堆砌成的墙。





当我还小的时候，我总认为对于阅读的反感是我自身的一个缺点。但直到近几年我才意识到，这个弱点帮助我成为了一个更好的文字工作者。

正如你们所知，我常常为应用和网站中的界面写文案。这是需要字字斟酌的。为界面写文案也是一种设计——为那些讨厌阅读的人群而设计。

### 用户根本不会仔细阅读界面上的文字

大量的研究表明[用户不会仔细阅读网页上的文字](https://www.nngroup.com/articles/how-users-read-on-the-web/)。这道理同样适用于手机应用、游戏以及其他交互界面上。大部分用户习惯于粗略地浏览并且摘取只言片语的信息。





![](http://ac-Myg6wSTV.clouddn.com/deedc22b6dceb7ef80e7.png)



你一定会感到惊讶，因为相当多的用户都会选择直接点击“下一步”的按钮。





是因为人们的懒惰？心不在焉？还是他们真的讨厌阅读？无论你同意哪一个观点，结果都是一样的。那就是用户不会阅读界面上大部分的文字，无论文字多么的优美。

因为这个原因，你不能在界面上简单地堆砌文字。在编写文案的时候，你可能会发现原有的设计方案需要进行调整。如果你无法用简单的语言概况一个行为，那么这就表明你的设计过于复杂。

换句话说：设计的时候不应该使用无意义的占位符，而是换用真实的文案。

### 7个文案设计的小贴士

作为界面文案编写者，我学到了一些能让你的文案变得更易于阅读的方法。希望这些心得能帮助你更好地设计界面的文案。

#### 1\. 精简用语

要帮助用户阅读，最重要的事就是要精简你的用词。当你写完你的草稿后，你应该一遍遍地精简它。删去不必要的细节，使用更简洁的词语，直击要点。记住要狠点儿。





![](http://ac-Myg6wSTV.clouddn.com/2adb4fe22ae668ce6851.png)



你的文字越精悍，那它就越可能被用户阅读。



作为一个文字工作者，我深知发散的想法和丰富的辞藻对作家的诱惑力，但是在为界面设计文案的时候这并不是个正确的方向。这也是 Medium 兴起的重要原因。😀

#### 2\. 加上标题

有时候，你可能无法再精简你的文字了。这时候，你可以试着增加一个具有概括性的简短标题，并使用一些用户可能会关心的关键词。当他们需要进一步了解的时候就会深入阅读了。





![](http://ac-Myg6wSTV.clouddn.com/75704742caabeb14b259.png)



标题会让你的内容更有可读性。



#### 3\. 分点论述


当我读完这篇文章[我们的视线趋向于从上至下地浏览](http://www.eyegaze.com/eye-tracking-study-reveals-how-users-scan-google-search-results/)之后得出了一个结论，那就是以分点论述为形式的段落更易于阅读。

当你在一个段落中大量地使用“和”、“或者”的时候，可以试试分点论述的方法。





![](http://ac-Myg6wSTV.clouddn.com/a00f1f6bee031fee0dbf.png)



我爱分点论述。



#### 4\. 让读者歇会儿

许多产品，比如 Medium，本身就很注重内容的呈现，这是没有问题的。但是有时候文字一大段接着一大段连续的出现，会对阅读造成较大的困难。

当我需要写下大段文字的时候，我会试着使用许多**缓解阅读疲劳的元素**比如破折号、图片、标题、例子等，以及其他可以打破文字墙的元素。这可以为读者提供一个休息的间隙。而且这也为读者提供了思考的时间，同样如果他们愿意也可以选择跳过并继续阅读。

例如，在我的 Medium 博文中，我会让段落之间以分割线来进行区分，尽可能多地撒上缓解阅读疲劳的调味品。





![](http://ac-Myg6wSTV.clouddn.com/b3e63b2ca666741b7361.png)



撒上一些缓解阅读疲劳的调味品吧。



#### 5\. 优化你的文字

很多作家都会把关注点放在挑选合适的词语。使用合适的词语固然重要，但是我认为词语正确的**展示**也是同样重要。

当你在设计文案的时候，应该考虑如何强调界面上最为重要的文字，然后如何弱化那些非重点的文字或其他元素。在设计当中，这也被称为**视觉层次**。

时刻考虑字重、字号、字体颜色、对比度、字体类型、是否大小写、间距、空间感，对齐方式以及韵律等，所有的这些都会对读者的阅读造成或多或少的影响。仔细调整每一个特性直到找到最平衡的状态。





![](http://ac-Myg6wSTV.clouddn.com/df8b234689949f4c6081.png)



哪一个更易于阅读？



#### 6\. 慢慢地展示

当你试着教会用户如何使用某个功能时，你很可能会把所有信息都一股脑地堆在界面上，并且祈祷用户能够读懂并理解。但事实上，如果你的文字超过了两三行，很多用户可能不会去读它。那么你该怎么办？

有时候你可以每次只给用户展现一小部分的信息。这个方法的学名叫做**渐进式揭露**，但是我却偏向称之为**慢慢展示**。（这听起来更有意思不是吗？）试着把你的信息拆分成许多小块儿，并且一点点地进行展示。





![](http://ac-Myg6wSTV.clouddn.com/e9411a7afc982098d6ce.png)



字数太多了？试着拆分开来一点点展示。



另一件事就是你可以删去界面上大部分细节信息的文字，并且加上一个跳转至帮助中心的链接。许多产品都会使用“查看更多”的链接，点击后跳转到帮助中心页，那里包含产品的所有细节信息。

#### 7\. 写在原型界面上，而不是文档中

你是否有遇到过这种情况，有些文案写在文档上看起来很好，但当放在界面上却发现字数太长而得重新再写？当你在使用谷歌文档、Dropbox Pape 或者其他写作软件来编写文案的时候这种情况会经常发生。

当你为界面编写文案的时候，了解界面实际的情况是至关重要的。你需要知道你写出的文案与界面上其他的元素是否和谐。

这就是为什么我更偏向于在 Sketch 的原型上写文案而不是在文档上。我发现在原型上也可以帮助我更好地写出合适的文案，因为我可以实时地看到我的文案在实际界面上是如何呈现的。





![](http://ac-Myg6wSTV.clouddn.com/2e76414369925ab034ab.png)





### 最后的话

世上的文字承载着信息。它们帮助我们了解周围的世界。但是可惜的是，大部分的人都不喜欢阅读。如果你跟我一样是一位文字工作者，我们的共同目标应该是让阅读变得尽可能的简单。帮助人们更好地了解并感受这个世界。

以上的观点只是我在设计文案时总结的一点心得。你是否有自己的观点？如果有请把你的想法和故事写在下面的评论栏里吧。

感谢文字的力量，以此献给那些讨厌阅读的你。







* * *







**大爱❤** [_Brandon Land_](https://medium.com/u/496222766919) **所提供的撒调味料的插画**




