
> * 原文地址：[How To Design Notifications For Better UX](https://uxplanet.org/how-to-design-notifications-for-better-ux-6fb0711be54d)
> * 原文作者：[CanvasFlip](https://uxplanet.org/@CanvasFlip?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/how-to-design-notifications-for-better-ux.md](https://github.com/xitu/gold-miner/blob/master/TODO/how-to-design-notifications-for-better-ux.md)
> * 译者：
> * 校对者：

# How To Design Notifications For Better UX: Notifications are double-edged swords. Getting it right is the key to success.

Notifications evoke mixed reactions from users. Many a times they find it useful. Many a times they are annoyed by it. But notifications serve a purpose. They are powerful tools to inform users of app crashes, introduce them to new features & updates, and inform them about new messages and mails from friends. From marketing perspective, they help connect with users who have abandoned apps and promote engagement.

Notifications are anti UX. They are a distraction. So how to design your notification so that it becomes purposeful and useful?

But before that let’s understand notifications in detail.

![Typical interface for notifications](https://cdn-images-1.medium.com/max/800/0*xnVVI5oOkzjKLud_.)

**What are notifications?**

We go by the simple definition. Notification is an act of bringing something to the notice of the user. Notification is a way for an app to notify you or send you a message that you can read without having to open the app.

A very simple example of a notification is an email alert. You get a flash message on your smartphone screen when you receive an email. You wish to open the app directly from the main screen itself. You can also dismiss the notification by sliding it across. However, the main purpose of the notification is to announce the arrival of the email. Under normal circumstances, you have to open the email to check out your mails. The notification enables you to get a gist of the matter without having to open the mailing application.

## Types of notifications:

* **User generated notifications:**

![](https://cdn-images-1.medium.com/max/800/0*6YIy8q9IC5qmJqMp.)

This is the most common and engaging types of notification. Mobile messaging is the simplest example of this type of notification. It is directed specifically at a particular user. Other simple examples of these notifications are the posts, likes, and comments you pass on social media.

* **Context generated notifications:**

This is also a fast growing type of notification where the application generated a notification based on permission of its users. The location based notifications are the best examples. Sports and meeting updates are also very common in this category.

![](https://cdn-images-1.medium.com/max/800/0*gXIdt622EuYhyyhO.)

Source: Macrumors

* **System generated notifications:**

![](https://cdn-images-1.medium.com/max/800/0*7s568YpSLSUbzWo0.)

Source: aboveandroid.com

These are notifications generated by the app based on the needs of the app. An example of such a notification is a security alert requesting for resetting of password.

* **Push notifications:**

In fact, all kinds of notifications can come under the classification of push notifications for the simple reason that they are pushed through by the system.Push notifications are of two types. One that requires you to take immediate action and the second one is passive notification.

* **Notifications requiring action from the user**

The very purpose of the notification is to induce the user to take immediate action. It can be an email alert, a notification to change the password, a notification offering a sale discount asking you to use a discount code, etc.

![](https://cdn-images-1.medium.com/max/800/0*R9VMjbIYQk_Q65fH.)

Source: material.io

* **Passive notification:**

These notifications provide information to the user. There is no need for the user to take any immediate action on it. A weather update could be one simple example of this type of notification.

![](https://cdn-images-1.medium.com/max/800/0*XKN4mrMsm5TGC6mF.)

Source:Androidcentral

* **Smart notifications:**

![](https://cdn-images-1.medium.com/max/800/0*wcAiMtTJR5HkHM85.)

Source:Beebom

The smart notifications have the unique ability to be delivered to each app. You can set up triggers to sensitize the app when to release the notification. We have already stated earlier in the article that the timing of the notification is very important. The objective of pushing a notification is to ensure the user to take immediate action. This makes the timing very important. The system can sense when the interaction level can be at the maximum. This will deliver a positive experience to the user.

Secondly, you can track the smart notifications and analyze the results. This enables the system to improvise on the quality of the notifications. This can determine the success rate of the notification campaign.

**What makes a good notification?**

* **Non-interfering:** A notification is a timely alert. However, it can distract the user. Hence, the main characteristic of a notification is that it should be non-interfering. It should achieve the purpose of letting the user know that something important is on the way.
* **Small in size**: A good notification should be as small as possible but effective at the same time. An example of a simple unobtrusive notification is the calendar notification that usually slides at the top of your mobile screen. They are small in size but they serve the purpose well.
* **Contextual**: A location based push notification is contextual. They can alert you in case you are in the vicinity of the particular retail store. This feature works depending on the shopping and wish lists you create on the online shopping websites.
* **Serve warnings**: A good notification should act as a confirmation message, especially when you delete apps or important messages. It can serve a timely warning to the user that you are about to delete something permanently from your mobile phone.

**When not to use a notification?**

![](https://cdn-images-1.medium.com/max/800/0*A6wknVNblmK4X7pC.)

**Source: kissmetrics**

Notifications should not be used at every instance, as frequent interruptions may cause annoyance. Its best not to use notification when:

* A user has never opened your app
* There is no value to bring to a user, such as “Haven’t seen you in a while”
* Requests to review or rate an app
* Operations that don’t require user involvement, like syncing information
* Error states from which the app may recover without user interaction

**How to design a notification?**

The good news is that you can design meaningful notifications without compromising the user experience. Here are a few tips on designing notifications-

* **Design considering the importance of your message:** Choose different designs for different types of massive. For passive notifications, choose a lighter design while an action-required notification, design to attract user’s notification. Pick right colors, say a red for immediate action. Use relevant icons.

![](https://cdn-images-1.medium.com/max/800/0*mYoibne9sgQ-AFHX.)

Source: Designdeck

* **Provide enough information:** The purpose behind a notification is to inform about an event and encourage him to take action. But, for that, he need enough information. So make sure that your notification has enough information to help him understand the purpose of notification and what needs to be done.

![](https://cdn-images-1.medium.com/max/800/0*SesUf_hDZ37fiaY1.)

Source: easycodeway.com

* **Give user the control:** UX accentuates when users feel that they are in control. They has the choice of switching off notifications. Go beyond that and give them choices in- types of notification they want to receive, when they want to receive and the frequency of notification.

![](https://cdn-images-1.medium.com/max/800/0*R755XUbOHY0AVRGp.)

Source: Gadgetguideonline.com

* **Handle multiple notifications smartly:** To handle multiple notifications of the same type, create one notification that summarizes them all. For example, a messaging app might have a summary notification that says “3 new messages.” Upon expansion, it could show a snippet for each message. This lets the user know about the time it would take to deal with the notification.

![](https://cdn-images-1.medium.com/freeze/max/30/0*6SLxnj4cU4nS6GMe.?q=20)

![](https://cdn-images-1.medium.com/max/800/0*6SLxnj4cU4nS6GMe.)

Source:material.io

* **Embrace A/B testing:** The best way to get your design right is to put it to rigorous testing. Try out different designs and test them. See which design is making the user take the desired action. And what’s not working.

![](https://cdn-images-1.medium.com/max/800/0*favEgcGEH9ylDLrP.)

**Final Thoughts:**

Notifications are double-edged swords. They can promote engagement but can also result in user annoyance. So getting it right is important for your overall experience?

How do you manage your notifications? What are your rules for designing good notifications? Share your thoughts in the comments section. Also, if you find my article interesting, please share it with your friends.

![](https://cdn-images-1.medium.com/max/800/1*VdnKzKfQQINWkLUUxE6IMw.png)

Validate your designs FREE with real users at [http://canvasflip.com](http://canvasflip.com)


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
