>* 原文链接 : [Mobile UX Design: What Makes a Good Notification?](https://uxplanet.org/how-to-craft-mobile-notifications-that-users-actually-want-7b585e0e1fa1#.z4z05lc5u)
* 原文作者 : [Nick Babich](https://medium.com/@101)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : 
* 校对者:


Have you ever paid attention to the number of notifications and alert messages you receive on a daily basis from various apps? How many of those notifications _do you actually care about_?

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*zq6d8Sl7qnBAh8B8YPpZng.jpeg)

<figcaption>Meaningless notification on smart watch screen.</figcaption>

Everyday, users are bombarded with useless notifications that distract them from their day-to-day activities and it gets downright annoying. **Annoying notifications is the #1 reason people uninstall mobile apps (71% of respondents).**

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*tRV8bhwepMNc7lsEyleZAg.png)

Designing notifications to be useful and relevant for your users is extremely important. Because they can be powerful tools for businesses to communicate directly with users and deliver the right message at the right time and place in order to _promote engagement_.

Let’s see how to turn this anti-UX pattern into something meaningful and valuable both for your product and for your user.

### Key Elements of User-Friendly Notifications

Notifications are a _privilege_ because users place trust in you by allowing you to send messages directly to them, and you mustn’t abuse that privilege. And user-centric notifications are the building blocks of any great mobile marketing strategy, but creating the perfect notification isn’t as simple as it may seem.

Here are _five moments_ _to remember_ when crafting a user-centric notifications.

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*jOuOujLnxkx30IBo3q_Ejw.jpeg)

The most common mistake, and the most damaging from a long-term point of view, that you can make while sending push notifications is _sending your users more notifications than they can handle_. Too many direct conversations with users may lead to “notification overkill” and may result in users either tuning out mentally or opting-out altogether.

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*YIsFJcFM7pQZDGgD_2X0rg.png)

<figcaption>All push notification arrived at the same moment.</figcaption>

**Takeaway:** You need to understand your audience, their lifestyles and their needs and _figure out the frequency_ of notifications that you will send out.

### 2\. Push the Value

When user start using your app she don’t mind getting notifications as long as they carry enough “_value-for-interruption_,” meaning they are _useful_ and _interesting_ enough to her. _Personalized content_ that inspires and delights is a critical component.

**Bad Example:** Some notifications shouldn’t ever make it to a user’s screen. AppStore software update notification most probably was designed to follow the usability heuristic “[Visibility of system status](https://uxplanet.org/golden-rules-of-user-interface-design-19282aeb06b),” but does the user really need to see it? If the notification doesn’t require any action for the user, then maybe it’s not that important.

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*GO0mnyRoW-3ZEVvFnuf0Aw.jpeg)

<figcaption>Apple AppStore notifcation. Should I really be notified about that?</figcaption>

**Bad Example:** Facebook app routinely sends users notifications to connect to randomly suggested people or to “Find more of your friends of Facebook.” This is a poor attempt to direct users back into the app. Also it interrupts users with irrelevant alerts.

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*fKWoWYBuhoQ0EhqWiom3AQ.png)

<figcaption>Facebook app for Android.</figcaption>

**Good Example:** Netflix does a great job of personalizing their push notifications. Netflix uses push notifications to let users know when their favorite shows are available.

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*OjWmPLfdatdwh7dpMlwiVw.png)

<figcaption>Netflix app for iOS</figcaption>

Rather than sending every user a notification every time any new show or season is released, Netflix understands the specific shows that each user has been watching, and only sends a notification to a user when one of their favorite shows has a new season available. The result: app alerting users to _personalized_ and _relevant information._

**Takeaway:**

*   Don’t send out notifications just because you can. Don’t include notifications just to lure users into using your app.
*   Keep the message clear and understandable. No matter what the content of the notification is, make sure it speaks the same language as your users, literally and figuratively.
*   Users, regardless of frequency, appreciate content that is directly related to their personal interests.

### 3\. Time Your Notification

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*ZvGqAroMPDx5kxh3713C5g.png)

Tailoring your notifications to your users isn’t just about what you say, it’s about _when you say it_. Do you like to be woken up in the middle of the night by a vibrating cell phone, flashy screen and a push message saying you have a $15 discount on your next purchase if you invite a friend?

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*_Aeiw7oss9IHK8dkhpajsA.png)

<figcaption>“Push gone wrong” tweet.</figcaption>

Now of course, users can always turn on the settings on their device to DND, but that’s not a solution. A real solution would be sending a notification out at a reasonable time that would be most effective to your users, _unless it’s critical to inform them of something happening right now_. In general, _mobile usage peaks betweek 6pm — 10pm_.

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*ZrX3QYmAnnqB6A1iEwa-BQ.png)

<figcaption>Research source: [comScore](http://www.comscore.com)</figcaption>

**Takeaways:**

*   Don’t send push notifications at weird hours (an ill-timed notification sent between 12 and 6 am risks waking up or disrupting user).
*   Always send push notifications to users in _their local timezone_.
*   Tailor message time to each user. Pay attention to where your users arein their day, and schedule appropriately. Automate message delivery to the user’s preferred time to engage with your app.

### 4\. Test Rigorously

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*IY-EtpLW1icld5MeCQznQA.png)

How do you make a great push notification even better? Test it! A/B testing can be valid in push notifications. But unlike an A/B test of a change in the design of your site, testing messaging notification requires _speed_ and _determination_.

Interesting practical example from [Adam Marchick](https://twitter.com/adammStanford?ref_src=twsrc%5Egoogle%7Ctwcamp%5Eserp%7Ctwgr%5Eauthor): Approaching Valentine’s Day, 1–800-Flowers [prepared](https://segment.com/blog/push-notifications-users-want-kahuna/) to A/B test two very different messages. They tested up two versions of one message to a small sample of users who had added an item to their shopping carts but had not completed their purchases. First message was a simple reminder:

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*lD7A2etv0pG_bvxSx72rsg.png)

<figcaption>iOS Push Notification: Forget Something? Come back and send a truly original gift.</figcaption>

But second one variant included a 15% off promotion code.

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*QhqKA7mkLumHLPgK4rA0uQ.jpeg)

<figcaption>iOS Push Notification: Forget Something? Come back and SAVE 15% with Promo Code.</figcaption>

Contrary to what was expected, _the message that performed best was a first variant_ — the variant that did not include a promotion code. In fact, the message without the promotion code generated 50 percent more revenue and resulted in fewer app uninstalls than the variant with the promotion code. That’s why you need to test everything.

But a tendency to track only positive metrics (e.g. sign-ins) is a big mistake. You should have _a big picture_ and track all major metrics:

*   _Goal achievement:_“Does the notification drive users to take the desired action?” Examples of goal achievement: social shares, purchases, sign-ins, and more.
*   _User engagement_: “Did the notification enhance and enrich the user’s app experience?” An important metric for answering this question is the number of users who re-engaged with your app after receiving the push notification. Tracking this metric is a good way to validate that the notification was _user-centric, not company-centric_.
*   _App uninstalls & push opt-outs:_ The number of app uninstalls or push opt-outs that have been generated as a result of the notification. When you are measuring this number in _real time_, it’s easy to adjust or cancel any detrimental notification campaigns before it’s too late.

<h3 name="3187" id="3187" class="graf--h3 graf-after--li">5. Establish a Messaging Strategy</h3>

The best way to establish an effective mobile app messaging strategy is to use different message types — push notifications, email, in-app notifications, and news feed messaging.

![](https://d262ilb51hltx0.cloudfront.net/max/800/1*BEdI6YjX0sgqXT6deQrrrw.jpeg)

<figcaption>Select proper notification type based on urgency and content. Source: [Appboy](https://www.appboy.com)</figcaption>

Diversify your messaging — your messages should work together in perfect harmony to create a great user experience.

<h3 name="3f58" id="3f58" class="graf--h3 graf-after--p">Conclusion</h3>

Mobile is all about making every message count.

Notifications can add real value to your users’ lives are critical to improving your brand, and in turn your revenue. Just remember these key takeaways as you embark on the journey to send great notifications:

*   _Personalizing the message_ content ensures that users receive information that is relevant and valuable to them.
*   A successful notification strategy approaches _message timing_ from the perspective of the user.
*   Before you send any notifications, you should _choose a goal_ and _track the necessary metrics_ to determine if the communication worked.
*   _Diversify_ your messaging. Push notifications alone won’t cut it.

I hope this article was interesting and you got a good understanding of how to optimize your notification campaigns.

Thank you!
