> * 原文地址：[How to become an iOS developer, Bob](https://medium.com/ios-geek-community/how-to-become-an-ios-developer-bob-82944188ea7d#.dpn3k2gk1)
* 原文作者：[Bob Lee](https://medium.com/@bobleesj?source=post_header_lockup)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[thanksdanny](https://github.com/thanksdanny)
* 校对者：[zhouzihanntu](https://github.com/zhouzihanntu), [xuxiaokang](https://github.com/xuxiaokang)

# Bob，我要怎样才能成为一名 iOS 开发者 #


## iOS 开发虽不易，但别怕尽管上就是了。 ##

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/2000/1*65b3tcODklio-5koqOe0dA.png">

然而这并不是我的桌面

### 自我驱动 ###

我经常收到类似的邮件跟私信，

**“Bob，我怎样才能成为一个超酷的开发者？”**

**“Bob，我想转行了。我好喜欢你的文章跟视频。我要怎样才能成为一个 iOS 开发者呢？”**

**“Bob，我不知道应该如何开始学。而且我之前也从来没写过代码，你能帮帮我吗？”**


好啦我知道啦。但我会实话实说。我尽量去回答这些一般问题。我叫这种问题叫做 **“今天天气如何?”** 。这（些问题）毫无意义。这只说明缺少准备。我发现我自己在不断重复啦。

如果我是我身边的朋友问这些，我大概会怼他们了，

> “哥们，你有自己去 oogle 搜吗？已经查过的话，那就继续 google 啊。” - 我

虽说如此，我意识到我还是可以通过这篇文章分享我一些小小的见解的。这样当再有人问我类似的问题的时候，我就可以直接说，“先去看看我的这篇文章，还有问题再来问我 :)”。

***免责声明：*** **这文章只是表达我个人的想法，可能还会存在错误的地方，因为我有时也会带有一些偏见。我只能分享一些 Swift 相关的经验，毕竟这是我的第一门编程语言。信不信由你啦**


### 1. 放松，慢慢去了解基础原理 ###

我也是过来人，当我最开始学 iOS 的时候，我只能想象它就像是一个庞然大物。我买了一些线上课程还有一些书 -“**让你做出 18 个应用与成为付费 iOS 开发者的唯一课程**！” - 当时我就迷上了！太牛逼了！

在我完全不知道 `super`, `!`, `?` , `as`, `if let` 这些关键词代表什么意思的时候，我就成为了一只程序猿，像丧尸一般不停地写代码。如果你正处在这个阶段，**那就先学 Swift 吧**，虽然这跟 iOS 没有太大关系。但这是在为以后的学习打好基础。同样道理，在你学会写文章出书之前，你必须先学会语法跟字母表。相信我，只要坚持你也能将这本“书”出版的！

如果你还不清楚 Swift 下的这些概念，去看 Xcode 左侧的那些红色标记。确保你理解，

`delegate``extension``Protocol``optionals``super``generics``type casting``error handling``enum``closures``completion handlers``property observer``override``class vs struct`

别担心啦，我已经将成为一名 iOS 开发者的所有要点总结在这里了。

#### 资源 ####

所有的教程都在([Personal Journey Note](https://bobleesj.gitbooks.io/bob-s-learning-journey/content/WORK.html))

**如果你还没完全掌握面向对象编程，就不要尝试去学习函数式编程，面向协议编程了。**

### 2. 不要苦于去理解全部，相反地，要找到适合你的学习模式。 ###

这实际上视你对 Swift 的核心概念的熟悉程度而定，何况你正在学习 iOS 的生态系统。

你根本不需要清楚 iOS 中的全部知识。实际上知识量太庞大了。要学这么多的类跟框架已经够呛了，何况这些类和框架并不是开源的，我们开发者并不能详细地了解其中的实现细节。

所以，我把 iOS 开发比作**微波炉操作**。你要做的只是阅读操作手册，但阅读手册的前提是，你能理解这些单词的含义和发现独特的操作模式。

举个例子，当你去加热，你按下几个按钮后转盘开始旋转了，黄色的灯光开始照射在炉壁上。就是这么个道理，**他之所以这样去运行，是因为苹果的工程师已经将他的运行方式设计好了。** 但作为 iOS 开发者，你的工作就是知道为啥他们会这么做。再举个例子，我问，“这旋转的盘子是怎么让食物加热的？”。就像是这样，你其实并不需要知道电磁学的细节原理，虽然知道的话确实会有帮助。

最后再举多个例子，我会问，为什么苹果的工程师要实现 `delegate` 模式与 `MVC`？学会去发掘他们的动机。如果你通过 google 得到了结果，那就坚持这么做吧！

### 3. 多与 API 和文档打交道 ###

当你熟悉 `delegate`,`protocol` 这些概念后，API 文档读起来就会变得更容易了。大部分指南，例如 [Bundle Programming Guide](http://bundle%20iOS%20guide)  还是用 Objective-C 写的。

**不要担心**，你可以轻松地从 Objective-C 转到 Swift，点击 [这里](https://objectivec2swift.com/#/home/main) 查看。

我常说学习 API 就像学习如何驾驶各种交通工具一样。例如，`UITableView` 和 `UICollectionView` 对比起来，就像驾驶单车跟摩托。使用 `NSURLSession` 去上传下载数据的感觉，就像在开宝马一般。而创建一个开源项目，就像在驾驶着一架大型的飞机。

其实所有类型的交通工具都遵循通用的基础功能/模式。就比如我们的操作用到手把跟刹车，带来动力的引擎以及汽油。


找到那些相似的模式都是不易的，但很值得投入时间去折腾。任务越有难度，完成时获得的成就感越强。打个比方，就算面临死亡的威胁，人们还是不顾一切地去攀登珠穆朗玛峰。当球赛比分为 5-0 ，人们都会失望离场，就你逆袭的时候。这已经有太多熟悉的模式以及你所了解的答案 - google，学习，应用，不断循环。

### 4. 关于开源 ###

**不要使用开源项目，除非你有能力自己去实现出相同的功能**

iOS 开发者依赖开源项目去实现网络，动画，还有 UI。然而，初学者通常都是直接下载这些库去使用。这让一切都变得十分简单，以至于他们学不到任何东西。

这就是问题所在，想象一下你只需要做一个十分简单的任务，你却需要导入一个庞大的库。这好比你开一瓶小小的苏打水，却要用锋利的瑞士军刀。根本没必要大材小用。但当你必须添加这个库时，你的项目会变得十分臃肿。

如果你不知道如何做出这些功能和特效，就去研究吧。这才是所谓的“开源”精神，下载他们的代码并开始仔细地分析，如果必要的话，你还可以“光明正大”地抄写这些代码。

**为了成功地去做到这一点，你必须理解** `Access Control` **，还要对面向对象编程有深刻理解。**

不要误会，这些开源库我也会经常使用，但我使用这些开源库，是因为就算没有这些库的情况下，我也知道应该如何去实现那些功能。更重要的是，利用这些开源库可以为我省下不少的时间，然后去做我想做的事。

**我喜欢在骑单车的时候放开双手，这感觉让我十分的享受。一旦到关键时时刻，我也能快速抓紧把手控制好方向。假如我不懂骑单车的话，那一切都太荒谬了。**

### 5. 面向协议思维 ###

假设你已经熟悉了 OOP（面向对象编程），我更首先推荐你去考虑用 POP（面向协议编程）去设计一个功能。我这里写了几个指南来告诉大家 POP（面向协议编程）是有多棒。你可以在 [Part 1](https://medium.com/ios-geek-community/introduction-to-protocol-oriented-programming-in-swift-b358fe4974f#.nj16kndks)和 [Part 2](https://medium.com/ios-geek-community/protocol-oriented-programming-view-in-swift-3-8bcb3305c427#.33aau3khn) 去开始学习。


### 6. 理解 App 的生命周期。 ###

我们要知道 `ViewDidLoad`, `ViewWillAppear`, `ViewDidDisappear` 之间的区别。还要明白为啥要用 `ViewWillAppear` 来代替 `ViewDidLoad` 来实现网络逻辑。

学习 `UIApplicataion` 的作用，还有为啥 `AppDelegate` 会存在。我已经上传了相关视频在 YouTube 。

关于 App 的生命周期 ([YouTube](https://www.youtube.com/watch?v=mD8hsQjR1zk))


### 7. 别担心服务器。 ###

如果你还在 Swift 与 iOS 中挣扎，那就不用考虑去设计一个服务器和数据库了。直接使用 **Firebase** 好了，他就是一个服务器后台，可以使你使用十行不到的代码就可以存储数据。

假如你的 app 人气很旺，已经发展到一亿用户了，你可以请个开发来做后台了。一个前辈曾经说过，如果你尝试同事去抓两只兔子，最终你只会一只都抓不到。当然，如果你觉得你对 iOS 的生态系统学习的差不多了，你也是时候去学习其他领域了。

### 8. 笔记！笔记！笔记！ ###

我经常说学习 API 就像是在背单词一样。在大学时候我得去学习几千个单词去应付考试。当然了，就算我现在已经忘得七七八八，但对于当时我的学习程度还是很自信的。

有些人不知道应该在哪做笔记。你不需要什么特别的网站，先看看再说。你可以在 Medium 上分享，或者在 GitHub 上传你的笔记。还可以做个 Youtube 视频，就算是不公开的也 ok，然后多在电脑上做练习。

上述方式这并不仅仅是你存储信息的地方，别人还能搜索到你的文章，帮助遇到同样问题的人。我相信善有善报的，更何况还能构建起你的个人品牌，也能拓展开自己的市场。

我想你应该想知道在我是怎么开始写博客的，我把这篇文章写在

**在我写博客的这10周里学到了什么 (** [*LinkedIn*](https://www.linkedin.com/in/bobleesj?trk=hp-identity-photo)  **)**

### 9. 如何请求帮助 ###

在 Facebook 有个博主他经营着一个叫 [iOS Developers](https://www.facebook.com/apple.ios.developers/?ref=bookmarks) 的主页，已经将近有 30,000 粉丝了。我发现那里有许多相关的软技能的提升，相信对提问者会有很大帮助。

作为一个经常提问与发问的人，在这里我分享一些我提问的方式以及行之有效的方法给大家。

首先我不会立刻说出我的问题，我会写几句来先介绍我是谁还有我是如何找到他。然后开始列出我所能搜索到的答案或者解决方案。因此我不会问一些无关紧要的问题。给个提示，如果我真的想要我的问题被彻底地解答，我会给其他人带来一些激励，我会表示当有解决方案的时候，我会乐意去分享给大家。

**不过在你提问之前，先请搜索最少10页的 google。你从中会很惊讶地发现，通过搜索这问题你会发现不少意外的收获。**

### 10. 不要依赖教程 ###

通常，我们都希望得到大神们的指导与帮助。然而遇到问题时，尝试去鸡蛋碰石头是 ok 的，因为这样你会发现这并不是最好的解决方法。

学习是靠你自己的。如果你一直依赖教程，你就会丧失“捕鱼”的能力。我的意思是，虽然你继续看我的教程也是很可以的，但如果你希望成为一个可持续发展的 iOS 开发者，你应该学会自己去将自己学到的东西总结成**文档**。尝试去阅读苹果提供的 API 指南，并尝试着去挑战自己。有时你就是需要不断地阅读文档来折腾自己才能获得提升。

实际上，我已经能从头到尾读了 Swift 的官方文档超过3遍了，还熟记他里面的各种示例。通过阅读文档去学习也是种学习技能。

教程通常都被包装成一种让学生容易理解的方式，但毫无疑问他并不包含很多基础内容。举个例子，如果只通过教程的学习，我是没办法完整地学习 Swift 的 Foundation 库的。

**阅读教程是可以的。我以前也经常这么做。然而如果你发现有更好的学习方式，就要立刻睁大你的眼睛了。我身为这篇博客的导师，我敢说我的方法不一定是最好的，毕竟人无完人。**

### 最后的话 ###

对于那些想放弃的 iOS 开发者，你可以随时放弃都没问题，毕竟现在开发者太多了，而且我们也并不希望在 2017 年有更多平庸的开发者的出现。

如果能给我们提供充足的饮料、流畅的网络以及提供一日三餐，**我们就没啥好抱怨的了**。假如我20岁的时候能仅仅通过 google，而且在没有获得计算机学位的前提下，六个月无师自通地学会 Swift 与 iOS，那么我相信你们也一定可以！

**如果给篇文章读起来让你感觉到很傲慢，我感到十分抱歉。我感到很沮丧，为啥会有这种消极与抱怨的声音，去打击我们所在的现实中充满幸运与祝福的 2017 年，现在已经不是 1523 年了。作为文章最后的声明，我想分享一则来自一位失明者的格言，也是我最喜欢的格言之一。**

> “唯一比看不见更糟糕的事情就是能看见但是没有愿景”。 - Helen Keller

我希望这是我第一篇也是最后一篇没有使用 emoji 表情的文章。下次再见。


