
> * 原文地址：[ How Color Affects UX And Behavior](https://blog.prototypr.io/how-color-affects-ux-and-behavior-c242c895a8a4#.1p7zujou5)
* 原文作者：[Proto.io](https://blog.prototypr.io/@protoio?source=post_header_lockup)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[Jiang Haichao](https://github.com/AceLeeWinnie)
* 校对者：[王子建](https://github.com/Romeo0906), [Tina92](https://github.com/Tina92)

# 色彩如何影响 UX 和用户行为

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*u_ZVr6pxj9EBOKU5vACz6w.jpeg">

色彩：设计得当时你可能从未关注过它 - 但是设计不得当时呢？无论是过亮且灼眼的背景，或者暗灰色背景下的黑色文字，还是以次充好的色彩选择都足以毁掉一款功能强大的 app。如同设计的其他方面，色彩不仅仅是为 app 锦上添花。色彩与用户体验的其他方面一样，也可以是一种工具。

用于设计 app 的图形 [设计哲学](http://blog.proto.io/10-of-the-best-design-philosophies-of-all-time/) - 从元素尺寸，滑动方式，当然也包括色彩 - 都在影响着用户的行为。因此，设计师通常在项目前期用几个月的时间搭配色彩而不是设计布局。

选择颜色搭配的区别就在于，完美的色彩搭配能设计出一个能让用户感到放松并沉浸于此的 app，糟糕的色彩搭配会让用户有拿手机砸墙的冲动。以银行业务的 app 来看，糟糕的颜色搭配会让你每次查余额时都非常紧张，而完美的色彩搭配能够缓解你的焦虑，比如马上要清付下一次账单了。

那怎么才能设计得当 - 即如何在你的设计里掌握色彩呢？

### 图形设计哲学：色彩理论

在深入图形设计哲学（和心理学！）之前，需要了解一些色彩和设计的基本原则。虽然色彩看起来不是一门非常复杂的学问，但我们仍然有理由让每堂艺术课不光教授如何使用色彩，还要教授如何 **创造** 色彩。

基本原则 - 拿色盘来说 -很简单：原色（红，黄，蓝）可以结合调出二级颜色（绿，紫，橙）。同样地，不同分量的白色加到颜色里，能调出浅色，不同分量的黑色能调出深色。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/0*TnakpAz6-VKGNWF5.jpg">

实现图形设计哲学的时候，色盘将会是一个不可或缺的重要工具。

对角线上的两个颜色（如红色和绿色，蓝色和橘色）是互补色。这些颜色反差强烈，放在其互补色颜色旁边（或之上）时十分突出。相邻的两个颜色是类似色。这些颜色对比度低，放在一起并不突出。

颜色对比度的高低没有绝对的 ”正确“ 和 ”错误“。有时一个应用需要强对比的亮色组合。有时，又需要温和一些。一般来说，越想要突出的东西，越需要强对比度。

感受色彩组合是否搭配的最好方法就是亲身体验。即便你手头没有项目，快速旋转 [Adobe 色盘](https://color.adobe.com/) 也许会让你对色彩有新的认识。

### 情感色板：色彩心理学

巩固 app 的图形设计哲学史，你不应只考虑外观 - 你必须要思考它们给你的感受。我们说的不是触觉反馈。自从 Johann Wolfgang Goethe 研究 [色彩对生理学影响](http://www.arttherapyblog.com/online/color-therapy-healing-an-introduction/) 以来，我们着迷于用颜色产生生理和情感效果。

甚至今天，色彩在许多品牌的设计哲学中都占有主导地位。医疗，商业，和政府都倾向于使用蓝色，因为蓝色给人一种值得信任和专业的感觉。绿色看起来更年轻富有活力 - 当然，还反映了环境主义和亲近自然的感觉。红色是精力充沛和冲动的象征，给人速度，效率和力量的印象。我们看到的每个颜色（当然每个颜色本身都会与特定品牌相联系）都暗示了一些东西，直接或间接地，影响着我们对于独立品牌的看法。

你能认出的品牌和标识都是以颜色为中心的。Apple、Wikipedia、 New York Times，在这些品牌里灰色是主色，灰色象征着沉着可靠。这些品牌被视为和谐可靠的。全部食品品牌，John Deere，和 Starbucks 的标识均以暗绿色为主色，把自然、有益身心健康和他们的品牌产品联系起来。

许多颜色甚至超越了品牌自身，定义了整个行业。例如，想一下有多少快餐或连锁餐厅品牌色是红色或黄色的。这些颜色触发精神开关，让我们从心理上自愿购买一些商品。

当经销商很久以前就摸透个中道理时，科学也证明了我们关于颜色的一些共同感受。比如，红色能够让人 [反应更快速]((http://theweek.com/articles/484145/4-surprising-facts-about-color-red)) 或者对特定的刺激产生强烈的反应。红色也可能会变得危险：研究者发现考试者看到红色的时候，[正确率会降低](https://www.sciencedaily.com/releases/2007/02/070228170240.htm)。

更不可思议的是，药片的颜色对药效也有轻微的影响。蓝色药片最合适做镇静剂，黄色最适合做抗抑郁的药，在所有案例中，[亮色的药片药效最好](http://www.theatlantic.com/health/archive/2014/10/the-power-of-drug-color/381156/)。虽然这更像是安慰剂，影响我们增大了对药力的反应，但这影响已足以使制药厂在生产新药时把颜色作为考虑条件之一。

现在，并不是说在记录心情的 app 中使用黄色基调就能有效地消除抑郁，而是你选择的色彩搭配有理由认为能够影响用户心情 - 所以请谨慎选择。

### 色彩与用法

设计不仅是为了好看 - 还有功能和实用性，这两条原则对任何 UX 设计师来说都可以说是最重要的。如果 UX 不流畅，你选择的色彩搭配再怎么完美，UI 再怎么酷炫都没用。如果用户不能高效地使用，当然也不会想留下来。

那么色彩在其中又能起到什么作用呢？

简单来说：色彩是能帮助引导视线的工具。如果颜色使用得当，能够引导新用户快速学会使用你的 app，不需要长时间的新手教程，一系列复杂的视频，甚至不需要一个字。一个使用简便的 UI 不只能引导用户注意 - 还能引导用户全身心互动。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/0*Fa2CXw1Dv8iqJfHH.jpg">

一幅彩铅围成圈的黑白照片，只有笔尖部分有颜色。

试想一下，你正在为一家餐饮公司开发一款 app，提供方便大型机构订餐的服务。一个潜在客户第一次下载了你的应用并打开它。他们会看到什么？

在这个 app 里，大多数菜单项 - 包括背景和其他信息栏 - 都用柔和暗淡的灰色调配色填色。唯一例外的是一个橘红色的写着 “点单” 的方框。作为设计师，你知道大多数使用这款 app 的用户都希望轻松地设置食物订单。你要把这个标志放到显眼的位置，而不是把这个特点隐藏到 app 深处，或者需要用户滚动到页面底部才能看到。不只是这样，你还需要让用户立即注意到这个按钮。颜色能帮助实现这些目的，还能给新用户准确的引导，知道需要到哪里去。

同样地，我们每天都在生活的方方面面中都在和颜色打交道，在心里构建社会联系。例如，红绿灯：绿灯行，红灯停，黄灯慢行（或者提醒我们前面有情况）。黄色代表重要警告，红色代表强调，你能够有力地传达信息并提醒用户为他们的输入做好准备。

另外，该逻辑不光可以用于警告界面。 改变 app 内购买按钮的颜色显然会显著影响 [转化率](http://blog.hubspot.com/blog/tabid/6307/bid/20566/The-Button-Color-A-B-Test-Red-Beats-Green.aspx)。HubSpot 发现把绿色按钮变成红色按钮后，转化率轻松上升了 21%。此时，虽然不意味着要把每个 app 内购买按钮调成亮色，但却表明了颜色不仅是设计哲学的一部分：应该是整个 app 开发哲学的核心。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/0*4ILP-Npp6mB8hIQf.jpg">

我们甚至在强调色的选择上尝试挖掘软色调。色彩和阴影是优化图形设计哲学的最好的方式。

### 聪明地使用颜色：设计与可访问性哲学

在 Proto.io，[可访问性](http://blog.proto.io/the-beginners-guide-to-accessible-mobile-ui-design/) 一直在我们设计哲学的重点。可访问性是好设计必过的一关。如果可访问性不通过，那么就不是一个好设计。

大约 8% 的男人和 0.5% 的女人有不同形式的 [色盲](http://www.colourblindawareness.org/)。与常见观点不同的是，没有单色色盲，红绿色盲是最常见的。红绿色盲患者通常分辨不清红色和绿色。红绿色盲程度不同，甚至轻微的红绿色盲在使用一些 app 的时候都有明显的障碍。

除了色盲，近视眼用户有时无法阅读低对比度的文字，除非把屏幕靠近一些 - 这潜在地破坏了一些 app 的可用性。

所有这些问题的解法相当简单：展示文字时避免使用低对比度的背景颜色。当你不能保证每个人都能按照你设计的方式浏览 app 时，如果你使用对比色，至少应用是可用的。类似的，强对比色的文字对任何人来说都便于阅读 - 甚至在有视觉障碍时。

另一个提高可访问性的可选项是在 app 中提供可改变的主题色。虽然不是每个人都会用的，但是这能很好的提升 app 的可用性。你也可以允许用户改变特定功能的颜色。例如，你可以有个开关改变 app 的部分颜色，或者整个 app 的文字颜色。把这些颜色的控制权交给用户，你的 app 会对更多用户来说都具有良好的可用性。

如果你仍然不清楚如何在可访问性与设计哲学的色彩之间寻找一个平衡，建议你看看 Google 的 [material design library](https://material.google.com/usability/accessibility.html#accessibility-color-contrast)。

### 选择完美的色盘：固化你的设计哲学

即使确实有一些颜色选择时必须要遵守的规则，它也不是必要的。色彩通常是抽象的东西，像一种感觉。即使你的 app 不是为了在用户身上表明情绪，也不代表它不会。当发现黑白色并不是完美色盘的时候，我们建议使用不同深度的灰色。

用灰色渐变色构建 app 的平面原型并且作为基本准则。记住它的展示和给你的感受：传达给 QA 团队，关注他们的说法。你的新手培训是否灰暗无色？你是否错误关注到了应用的其他部分？带着这些反馈，再设计更多的原型，这次加上颜色。别依赖单色色盘。并且，从 Google 的 [material design](https://material.google.com/style/color.html) 网站获得提示，考虑它提供的色盘。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/0*ceW-J0USVj3tW0MF.jpg">

这个人的图形设计哲学是添加一个醒目的红色元素。

把修订版本也发送给 QA。不要担心对两个版本进行 A/B 测试（然后推翻原始灰度版本）。确保在讨论阶段提出了关于色彩值得探讨的问题。你是否在 app 中使用颜色引导用户注意？你是否为了添加闪光就向屏幕随便扔了个颜色？色彩是否分散了用户的注意力？

别忘了用户哲学和可访问性。如果你在开发一款旅游应用，你真的希望所有内容都是亮红色的吗？如果你在开发一款健康应用，你的背景色必须是绿色吗？文字的色彩对比是否足够了？

好的 UX 设计会把这些问题一并考虑在内 - 毕竟，色彩对用户行为和使用舒适度都有绝对影响。如果你的设计哲学还没把这些问题考虑在内，设计出来的 app 并没有你认为的好用和无障碍。确保按步骤设计你的原型，别拘泥于一个或两个颜色。通过实验选择其他颜色，并重复实验，直到完善你的色盘。

**Proto.io 使得构建手机应用原型变得真实。无需编程或者设计技巧基础。得以快速实现想法!** 今天 [注册 Proto.io 获得 15 天试用](http://proto.io/) 并开始你的下一个手机应用设计。
