> * 原文地址：[Everything You Need to Know about UX Sketching](https://www.toptal.com/designers/ux/guide-to-ux-sketching)
* 原文作者：[NICK VYHOUSKI](https://www.toptal.com/designers/resume/nick-vyhouski)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[特伦](https://twitter.com/SyncTrip)
* 校对者：[jiaowoyongqi](https://github.com/jiaowoyongqi)、[jamweak](https://github.com/jamweak)





如果你曾经做过一些非常需要创造性的工作，那你应该很清楚在创作中遇到阻碍的感觉。这种感觉就像撞上南墙: __你想不到一个足够好的点子，或是你想到的点子根本无法在实际中应用。__

对于设计师们来说，这种感觉再熟悉不过了。然而，任何复杂的问题都没有那么容易解决，但一个聪明的工作流程就可以让这一切都变得不同。这就是为什么我们需要为用户体验设计绘制草图。

绘制草图是一个关键点，但它却常常在用户体验设计中被忽视。草图是一种表达设计的非常有效率的方式，设计师们可以通过草图来尝试许多不同的点子，而避免沉沦于其中的某一个。

在这篇文章中，我想要介绍为用户体验设计绘制草图时你所需要知道的一切，包括了下面这几点：

*   介绍用户体验设计中的草图与线框图
*   绘制草图的基本要点、工具以及技巧
*   用笔记、注释和数字来阐明你的草图
*   为用户体验设计绘制草图时的小提示
*   用简单的设计方法来提高质量和效率
*   关于线框流程图你所需要知道的一切
*   为用户体验流程绘制草图的快速指南

## 绘制草图是一个需要两步走的过程

在设计中你必须考虑许多不同的方案，确保最终选择和确定的结果是__最好的那一个。__ 设计师们在设计时应该先思考他们的不同方案，之后再着手于细节，因此用户体验设计应该是一个两步走的过程：

![Ux sketching](https://assets.toptal.io/uploads/blog/image/121222/toptal-blog-image-1474991007791-230ca06cc9fe1490e78fb46953ffbcb0.jpg)

在最初的设计过程中，你会产生许多不同的想法，但这些想法都很难成形，甚至有一些元素的残缺或丢失也不奇怪。最重要的事是你应该用不同的方法去思考，并判断哪一种在你的任务环境中最有效率，以及你的项目会遇到的各种限制。

*   **细节与精炼**

一步一步来。选定一些看上去不错的想法并且开始着手于优化他们的细节，以此来填补这些点子中不合适的部分。

## 用户体验设计中的草图和线框图：介绍与分类

你绘制的线框图很可能依据你的产品而有所不同，比如所需要的细节程度，颜色或风格的不同，或是你是否需要展示给某人，等等。

![](https://assets.toptal.io/uploads/blog/image/121204/toptal-blog-image-1474890673236-d74ae4998dab921752d271212847a991.png)

好的草图会让你的想法更清晰，找到最佳解决方案，并节省你的时间。

我列出了下面这些不同类型的草图:

* 草稿：提出构思

这些是最初的草图版本，用于指出较低程度的细节，色彩的使用范围也有限。

我会绘制大量简单的手绘图来以不同的角度思考问题和解决方案。同时在画这些手绘图的时候，我也尽可能地去让这些解决方案发散开来。

在这个特别的步骤里，低完成度的要求使我开放了思维，因为要避免在这个阶段陷入一些细枝末节是非常重要的。我的目标是尽可能地想出许多的点子，并选择出最合适的那一个。

* **线框图：规范的细化阶段**

在我选出一个最好的想法并有了大体的细节之后，我通常会挑选出合适的草图来继续细化。

但是，这么做__并不意味着要添加上每一个细节__。很显然，有些事只要标记一下就可以了。此外，有些东西也很难在纸上被详细描述。

在这一步中，我会画出所有__重要的细节__，但我还并不打算在 [Balsamiq](https://balsamiq.com/) 中绘制线框图。等我在纸上把所有事都做好之后，我再开始使用 Sketch 来绘制线框图。

> 数字化的工具相比于传统纸张，为创作提供了更广阔的自由空间。并且，你可以很轻易地把注意力放到微小的细节上。比如说，相比于设计，你可以把注意力集中于「像素级的改进」。

* 视觉设计稿

一般很少会使用这个方法，但许多时候它依然是很有帮助的。在项目初期需要考虑多种视觉设计的方向，但把它们都在电脑上绘制出来也许会耗费你相当多的时间。这也是为什么我首先在纸上绘制手绘稿，在思考了不同的方案之后再选择一个合适的视觉设计方向。

* **部件/元素分解**

当已经有了一个大体的想法，而我需要考虑某一个特定页面的功能或是界面中的必要组成部分时，这个技巧就是非常有用处的了。我会画出不同的页面元素，去深入它们的细节，然后在不同位置画出这些页面元素。

即便是最简单的一个元素，也一定会有它特定的状态；一个按钮可以被按下，一个文字框可以是空的也可以被填满。它的组成越复杂，那么它的状态也越多样。

![](https://assets.toptal.io/uploads/blog/image/121220/toptal-blog-image-1474978796798-825431fd42dbca2c9a78a5046003b9d7.png)

## 从最基础的开始

*   **准备好你的工具** - 尽可能找一个最方便你工作的地方，要有一张空间足够大的大桌子。多带上一些纸，再准备一些水笔和记号笔。
*   **热身** - 为了让你做好准备，我建议你画一些线条，圆形，基本模板和图标。
*   **明确你的目标** - 明确你想要画的是什么。设定好你的目标并决定好你想要讲的故事。告诉自己是否已经做好准备大施拳脚。
*   **明确你的目标群体** - 如果你的草图是画给自己看，那你就不必担心这些草图长什么样子。但是如果你打算把你画的图给客户看，那你应该确保用一些额外的时间为你的草图添加更多细节。
*   **设定一个时间范围** - 决定一个时间段用来分配给绘图，让我们定个 30 分钟吧，这能帮助你专注于工作。

现在，你已经做好了准备，可以开始了：

1.  **绘制边界** - 先画好边框，一个浏览器或是手机窗口，或是界面的一部分等等。

2.  **添加最大的基本元素** - 菜单，页脚，或主要内容。

3.  **添加细节** - 添加重要的细节，但在这个阶段仍然要让它们保持简洁。

4.  **添加注释和说明** - 只有当你准备分享你的草图时你才需要这么做。当然，即使你只为自己做设计，它们一样会很有用。

5.  **绘制替代方案** - 为你的方案快速绘制一些替代方案。

6.  **挑选出最好的解决方案** - 选择一个最优项。

7.  **添加阴影和斜面** - 如果你打算跟人分享你的想法，这是一个非常重要的步骤。增加阴影来使你的草图在视觉上更有吸引力，这对于分享给团队成员或客户们来说是很重要的。

8. **保存好你的草图** - 拍一张照片或者把它们放进文件夹。我桌上有很多文件盒用来保存草图。

9.  **分享** - 我通常用下面这些方法来分享:
    *   通过 [Evernote](https://evernote.com/?var=c) 来扫描，并且提供一个永久性的链接给团队的其他成员或相关人员。
    *   拍一张照片并上传到 [InVision](https://www.invisionapp.com/)。
    *   上传并把图片关联到 [Realtimeboard](https://realtimeboard.com/hello/)。
    *   或者仅仅是用_电子邮件_发送图片。
10.  **回顾草图并添加笔记** - 稍微休息一下然后再回过头来看看你的草图。这些草图对你来说是否仍然是易于理解的？一个好的草图必然是让人易于理解的。

![](https://assets.toptal.io/uploads/blog/image/121216/toptal-blog-image-1474978448447-40701c83cf93e9be6339d4f0af43109c.png)

> 如果连作为设计师的你都不能理解你草图中的某些部分，那这个解决方案必定不是一个成功的方案。同理，如果草图没有很好地用视觉表达出你的想法，或者这个想法过于复杂，那么这些都不是一个好的方案。

## 用附加元素阐明你的草图

找到或者绘制一个合适的草图，然后给它加上下面这些细节：

1.  **标题** - 有时候添加一个标题会是一个好选择。如果有必要的话，在草图顶上写上一个描述和日期。标题会有助于你理解你正在看的东西，以及这个草图是否正是你要找的。如果你有一大堆草图或是你准备把它们展示给别人，这个方法尤其有用。

2.  **注释** - 注释可以在一个界面元素旁命名或者做标记，你可以用它来解释内容或属性。它们用来解释那些通常很难被画出来的细节。举例说，它可能是段落的名字，一些交互上的细节，一张图片的说明，或是一些未来设计上的变化，等等。你可以[看看我的例子](https://www.toptal.com/uploads/blog/image/121195/toptal-blog-image-1474538721087-70346acafa1accafd4332e733179d551.JPG)来理解一个草图中的注释应该是什么样的。

3.  **编号** - 为你的界面元素或是草图编好序号。你可以决定如何来为他们排序（比如，以交互流程排序，以创作顺序排序，等等）。这样做在讨论过程中可能会很有用（尤其是远程的讨论），你的同事和客户们很容易在他们的反馈中指出你草图中的序号，这样你就可以知道他们在评论哪一个草图了。

4.  **箭头** - 你可以用箭头来指出屏幕的转换。他们也可以用来连接草图中的不同部分，或是指出交互的顺序，等等。由于一个箭头可以有多种不同的理解，因此你可以在箭头上加上一个描述或者注释来解释这个箭头的含义。这里有一个[例子](https://www.toptal.com/uploads/blog/image/121197/toptal-blog-image-1474540322164-e4037ec1b56c685056935e3deaaaa8d7.png)展示了一个基本的草图如何展现界面转换和一些不同的状态。

5.  **笔记** - 就像注释一样，笔记也用来解释你的意图。然而，笔记使用的场合不同于注释。它们不是用来附在一个界面元素旁，也不位于元素旁，[就像这个例子中一样](https://www.toptal.com/uploads/blog/image/121198/toptal-blog-image-1474540426961-bb0363f81ef0d15fbffd1fa7f1872e98.png)。笔记可以位于页面中的顶部或底部。笔记甚至可以用来描述你的设计中没有出现的元素，你的问题，全局的说明，没有绘制出来的想法等等。

6.  **手势** - 如果你在做可触摸设备的设计，那么就一定会接触到手势。画一个手势可能需要练习。有很多种不同的手势用来解释不同的操作，所以你最好提前决定你要怎么用手势来解释一个特定的操作 （如果它并不那么容易理解）然后去练习绘制它。

7.  **反馈** - 当你把草图展示给他人，或者等你自己再多看看它们的之后，你可能需要一些建议来修正或改进你的草图。把你的反馈用不同于草图的颜色标注起来，这可以帮助你从原始的草图中辨别出反馈，这会很管用的。

你可以用不同的颜色来对应不同种类的元素。有时我用黑色来绘图，蓝色用来表示链接，深绿色用来做笔记，红色用来作为标题和反馈。尝试在你的草图中使用不同的颜色，但要确保你选择的颜色是固定的。

![](https://assets.toptal.io/uploads/blog/image/121221/toptal-blog-image-1474979173494-5e70fe3f0f0ddbc3749abe0f468ae0bb.png)

## 一些其他的建议和技巧

1.  **别担心质量** - 别老盯着 Dribbble 上那些华丽的草图；它们和你要做的是__完全不一样__的意图。记住你画这些草图最主要的意图是让你的想法更加清晰，找出最好的解决方案，并节省你的时间。

2.  **练习** - 作为一个新手，你可以尝试绘制一些应用。打开一个网站或者手机应用，尝试临摹它们，在笔记中描述界面中的元素。只要当你有空闲的时间，你就可以练习绘制你的设计中的基本元素。通常来说，练习会让你做得更完美。一段时间后，它会变成你的设计生活中的一部分。

3.  **买一个文件夹** - 很多时候我宁愿在咖啡馆或家里工作，也不愿意在办公室工作。纸质的草图很容易被损毁，所以你可以买一个简单的文件夹让它们安全地保持完好。

4.  **不管去哪儿都带上你的工具们** - 这可以帮助确保你可以在任何时间在纸上捕捉到你的灵感，除非你刚好没有任何想法，或者你老是记不得这些小事。我总是带着一个笔记本，一些 A4 纸和笔。

5.  **与他人分享** - 与其他人交流，与你的团队交流是非常重要的。与他人交流并获得他们的反馈，尤其是在早期就这么做，可以帮助你在长期的工作中节省时间和资源。你也可以鼓励其他人画出他们对这个设计的构想。

6.  **文件盒** - 考虑一下放一个文件盒在你的工作台上。像我就有三个文件盒：一个用来放接到的任务，一个用来放草图，另一个盒子里有许多没有用过的干净纸张。

7.  **尝试和习惯** - 我为你推荐的工作流程都基于我自己的经验。在某个适当的时候，你也会发现最适合你的工作流程：用什么样的方法，用什么样的步骤顺序，用什么来正确激发你的创作潜能。要达到这样的底部，你必须不断尝试新的东西，这就是为什么不断实验新的版式，新的风格以及新的模板是非常重要的。

8.  **套用模板** - 套用模板可以节省时间，而且可以让你的版式受到统一，释放更多时间来专注于更重要的部分。

## 为你的草图加分的额外小窍门

这些并不是必要的技巧，但它们是一些方法、工具和建议的合集，这些应该可以推进你的生产力和提高你草图的质量。

![](https://assets.toptal.io/uploads/blog/image/121218/toptal-blog-image-1474978640692-2c88d90d23aeb1b8484677f5fc3d4447.png)

1.  **建立一个草图板** - 使用纸和笔来代替数码工具最大的好处之一就是你可以把他们钉在墙上。你团队里的每一个人都可以看到和分享你的草图（虽然我建议还是要设立一个回顾的环节）。
    *   你可以看到你自己的草图，这会刺激你的思考。而且你可以一眼看到整张图片——不是孤立的部分——而是整个结构。你也可以看到不同部分之间的交互是否相匹配。
    *   建立一个草图版 - 附到你的白板旁。如果你的办公室里没有白板，你可以用一个双倍的胶带或者即时贴来把你的草图贴到墙上。如果你不想把它们贴到墙上，你可以找一个大一点的硬纸板来代替。我非常推荐建立一个草图版，它是一个最棒的设计工具。
2.  **使用白板** - 白板是一个绝佳的绘图工具。它有很多优点：它可以供写作；它在涉及到与团队成员的讨论和绘制中非常有用。即是成员们的想法不那么合适，你也可以弄明白他们的思路并帮助你在同样的位置继续工作。
    *   马克笔没有办法让你注意到细节，你不得不思考整体上的东西。草图则更易于理解。
    *   白板很容易擦除和修正错误。
    *   白板的空间很大，所以你可以轻松地思考整个系统的流程。
    *   你可以附上草图，打印文件和其他相关材料。
3.  **原型** - 制作一个可以点击的原型来看看你的设计的效果。试着获得一些关于界面元素的反馈。这项工作在你使用模板的时候会很好进行——你的草图都是相同尺寸的。很显然，用一个模板来绘制相同尺寸的草图是更容易的。我给你提供了一些可以下载使用的模板，来让这件事更简单。 [Mobile](https://toptal-email-assets.s3.amazonaws.com/71.pdf), [Browser multi-window](https://toptal-email-assets.s3.amazonaws.com/72.pdf), [Browser scroll](https://toptal-email-assets.s3.amazonaws.com/73.pdf), [Personas](https://toptal-email-assets.s3.amazonaws.com/74.pdf).

4.  **用上你的打印机和扫描仪** - 在纸上手绘框架（你可以用尺子来画得更准确），然后用一个扫描仪或者手机应用来扫描，并把它打印出来。你可以在打印之前用图片编辑器编辑你的模板。你也可以移除没有必要的细节或者一些重复的元素。你还可以打印现成的网站，照片或者其他具体的元素。你可以把他们剪贴到你的草图上。

5.  **用 Evernote 来扫描** - Evernote 是做设计的一个绝佳的工具。你可以用它来保存和分享你绘制的草图。你可以创建不同的主题，然后用标签来组织你的草图。它的「扫描」模式尤其让人印象深刻。把你的草图放到面前然后扫描，你就可以得到一份你草图的副本了。然后你可以邀请你的同事并给他们一个你的笔记的链接。因为 Evernote 在平板电脑和手机端都有 App，所以你可以总是保证你的草图随时可用。

6.  **混搭草图** - 把一些生活化的和现实风格的东西加入你的草图中让他们可以和照片结合起来。这表示你需要照一张照片然后画一些故事在界面元素上。这也可以帮助你注意到一些交互问题和细节。

7.  **还原现实世界** - 如果你需要创建一个故事版，在具体的背景中说明一个经历（比如一个人在公交车站使用手机），你的故事需要包含人物的描述，地点的描述，以及其他许多现实生活中的东西。这可能很难去画出来，尤其是你可能并没有非常好的绘画技能，但这里有一个简单的小提示：

> 为物体或场合拍一张照片，然后用图片编辑器取得这些物体的轮廓。之后你可以把处理得到的轮廓图用到你的草图中。

当然，如果你有一个__平板电脑和手绘笔__那将会更容易一些。

## 线框流程图: 系统概要的流程和分支

线框流程图描述的是一个系统流程的次序，一屏接着一屏，有着很多分支和关键点。我们应该思考一个用户怎样去安排他们的任务，他们怎么从一个屏幕到另一个屏幕，他们的总流程在这个产品上的耗时。

![](https://assets.toptal.io/uploads/blog/image/121217/toptal-blog-image-1474978519495-3207145b04526cb6add52ae4214d3726.png)

线框流程图——或者说把你画的东西像这样连接起来——可以根据下面这些不同的方式来整理：

*   **序列** - 一屏接着一屏，一个序列就是一个不一样的旅程。当然它也可以是一个和关键点有关的故事。你展示的不光是这个旅程，也是用户可以选择的关键点和不同的过程。你可以展示你的交互结构。
*   **场景变化** - 描绘一下元素，情景以及交互如何在不同的场之间变化。
*   **屏幕 vs. 屏幕里的元素** - 你可以画出整个场景或者思考交互和微交互。
*   **平台** - 你可以思考一个平台的流程或多个平台的流程。
*   **范围** - 你该描绘一部分用户流程还是整个用户流程？描绘系统中单个用户的交互还是多个用户的交互？

我通常会依据组织和实际的使用流程，去试着定义下面这些流程图的类型：

![](https://assets.toptal.io/uploads/blog/image/121193/toptal-blog-image-1474530411596-b613d988b28bb8a092d6c814c2b22252.png)

1. **反映总体的流程和一个高优先级的流程** - 及时画出这些界面的转换，并画出你的产品的使用流程。在这一步绘制中你可以交代一些背景，也可以有选择地展示一些用户界面。比如说，一个电商购物服务有着一个很长的流程，很可能包含很多步骤：用户怎么找到商品，用户订产品要经过的步骤，他们如何付款等等。

2. **界面流程** - 这更专注于展示一个特定的功能。它可以是一个流程中的小分支的单独步骤。比如说，一个用户要上传一些照片或视频。

3. **界面导航** - 画下你的界面和他们包含的不同选项。这不需要详细规划你的流程。这一步包含的信息展示了一个用户可以选择的不同选项，用户的不同流程线路，以及 App 中的不同部分。我通常在项目开始的时候就创建一个界面导航。这帮助你理解流程应该被如何组织起来（应该包含哪些重点，需要多层级）

4.  **界面状态** - 画下一个界面或者元素的状态（一个例子可能是上传文件的对话框）。既然这样，举个例子，界面会有下面这些状态：

    *   空白
    *   用户在可操作的区域选择了文件
    *   文件正在上传
    *   文件上传好了
    *   出现了一个错误

## 绘制用户体验流程图：一个教会你怎么做的快速指南

线框流程图的处理类似于单个的线框图。许多步骤都是相同或相似的，但是它们也有一些地方很不一样：

**明确什么是你需要画出来的** - 决定究竟你要画哪些东西（比如，你设计中的一个局部或整个流程）。你是否想要安排不同的选项，或者表现你流程中的细节？并且你应该决定你是否需要把你的草图展示给其他人。

**明确你的草图中应该包含哪些关键框架和转换** - 如果你把所有的界面和界面转换都添加到你的流程图中，那它将会非常长而且非常复杂。思考一下你应该用界面中的哪些关键点来展示交互的传达，这将有助于你完成你的任务。关于界面的转换也是一样，你需要选择哪些转换对你的思路表达是有意义的。看一看[这个例子](https://www.toptal.com/uploads/blog/image/121199/toptal-blog-image-1474540975778-abea7a31986dfeacfda2e4e0804a2d1a.png)来做参考吧。

**定义起点** - 你流程里的起点在哪里？你可以从应用的入口作为起点，换句话说，这是用户登陆你的 App 后所看到的。或者，你可以从一个用户流程的结束点开始，然后描述用户怎么样才能到这一步。

![](https://assets.toptal.io/uploads/blog/image/121219/toptal-blog-image-1474978685103-a4d5fcf8c50aa59c80b738780c115757.png)

> 明确你的方法并制作一个全面的草图

**判断下一步是什么** - 在画好起点之后，你可以通过回答下面这些问题来判断下一步应该是什么：

*   这一步中的那条流程可以引导用户？
*   你希望用户走哪一个流程？
*   他们要怎么做才可以到那里？

**画出可选的路径和入口** - 思考一下每一步用户可能到达的不同流程：

*   如果用户的网络连接错误会发生什么？
*   他们有哪些其他的选项？
*   万一用户或 App 出现了错误，会发生什么？
*   如果用户在这一步关掉了 App 会发生什么？
*   用户下一次会从哪里启动这个 App？

**思考一下可选的流程** - 分析整个流程，设计一个可选的流程，然后把它画出来

**加上注释、笔记和细节** - 加上一些说明可以阐述那些不那么明显的细节。

**保存** - 为你的草图做一个电子档的备份

**分享** - 分享你的草图（比如通过 Evernote 或 Invision）。

## 为用户体验绘制流程图的必要小提示：

**先画个线框流程图** - 如果你要思考一个很长的用户流程，你最好快速画一个简单的草图，好弄明白你需要多大的空间，并且不至于遗落一些重要的步骤和细节。如果你之后想再把遗落的部分加到手绘图里可能会比较麻烦。

**不要在一大张图里放太多的细节** - 手绘草图可没有_撤销_的按钮，所以想要在上面做改变是很麻烦的。你可能会因为把细节画得太细致，以至于你的注意力被越来越多的层级而转移了。你可以画出整体的系统来替代一个繁复的方案，试着把注意力放到关键的地方，并且给每个关键点一个独立的篇幅。

**去掉不必要的细节，把不同程度的细节合并起来** - 你没有必要画出所有交互，所以尝试一下只在你的流程里体现关键的元素。当你在绘制一个复杂的交互流程时，你没有必要把每个界面的细节都画出来。有的界面可以用一些形状来代替，至于其他的关键界面你再为他们添加细节。

**尝试一下不同尺寸的纸张** - 尝试一下不同规格的纸张吧，比如 A3 或者 A5 纸。纸张的尺寸会以不同的方式限制和影响你的工作方式。你无法在一张小尺寸的纸上加入太多的细节，但它可以帮助你聚焦于主要思想。用一张大纸可以画下很长的流程，许多的细节，并添加很多笔记。或者，你可以画下许多的小流程。

**便利贴也能帮上忙** - 你也可以试着使用便利贴。你可以在上面画一部分的界面或者一些脚注，或者你也可以为你的草图画一些额外的状态。便利贴的好处是它们可以随意更换，你也可以很简单地把他们移动到别的地方。举个例子，如果你的流程有变化，你可以替换掉你的便利贴的顺序就好了。

**使用模板** - 试着使用模板。它们可以节省你的时间，而且可以让你创建出更多可点击的、高质量的原型。

**试着使用白板** - 白板的好处太多了。它们变得越来越流行，因为你可以在白板上画出一长串流程图和分支。你可以在纸上画出许多应用的原件，然后用磁铁把他们贴到白板上，添加到你的流程图中。

**画上阴影** - 阴影可以帮助你标记一些重要的元素，并且它们让你的草图更有吸引力。我会用[这三种不同的阴影](https://www.toptal.com/uploads/blog/image/121196/toptal-blog-image-1474539075108-6a873f9d5c92296581a899fc3e595e83.JPG)

*   光照方向的线条 - 它看上去并不总是那么漂亮，但你可以把它用来分级，把某个元素提升到不同的「高度」。
*   用深色描绘部分外轮廓。(只能是底面，或者是底面和右面）
*   使用专业的马克笔（或者类似的绘画应用）

**画出部件** - 一个__「我画不好」__的畏难心理可能会扼杀你的创作欲望。那实际上比听起来更容易。就算是一个最复杂的草图也是由一些基本的图形来构成。就像[这个例子](https://www.toptal.com/uploads/blog/image/121200/toptal-blog-image-1474541374928-3041b386060c7e598ac8ed9e07e47ace.JPG)。

> 如果你能画出一个点，一条线，一个三角形，一个方形和一个圆形，那你就可以在你的草图中画出你需要的任何图形。

**把它们都放在一起** - 这些基本的元素，按键，单选按钮还有下拉菜单都是固定的基本部件。在你学会画好这些部件之后，你可以[把它们组合起来](https://www.toptal.com/uploads/blog/image/121201/toptal-blog-image-1474541497592-c88cfa0ae9df1bbd3229b7280cfd05c0.JPG)然后画出更复杂的图形和部件。

## 总结

这篇文章的目的不是教你创作一个最终的，一步到位的草图，或者万能的草图，因为设计师们会有不同的需要和个人的习惯。

就像你看到的那样，这涉及到了__许多东西__。设计师可以用很多的工具，技巧和方法去创作草图，而且最好是主观的。当然每个人的工作不同，这些技巧可能有用，但也可能并不是对每个人都有用。如果你准备好开始这么做，你一定要先做一些试验。

> 经常练习和试验可以帮助你找到适合你的工作方法。

想要怎么选择最适合你工作方法的提示和技巧，取决于你自己。你对 [UXers](https://www.toptal.com/ux) 有任何关于草图的技巧要补充吗？在评论区随意分享吧。

**相关链接：** [The Art Of Meaningful UX Design](https://www.toptal.com/designers/marketing/delight-meaningful-ux-design)



