> * 原文地址：[Getting the login page right](https://blog.prototypr.io/getting-the-login-page-right-d1ce6015235e)
> * 原文作者：[Boluwatife Ben-Adeola](https://blog.prototypr.io/@tife1379)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 译者：[LisaPeng](https://github.com/LisaPeng)
> * 校对者：[changkun](https://github.com/changkun)  [horizon13th](https://github.com/horizon13th)

---

# 使登录页面变得正确

事先声明，这篇文章讨论的是目前登录页上已采用的设计，而不是讨论关于如何设计的新见解。常言道：「普天之下，莫非旧闻」，但如果我们连历史都不曾了解，又如何能知道它会去向何方呢？好啦，这个理由已经足以支撑我写下这篇文章了。 

因此，一般结论是：创建登录/注册页的艺术（没错，它是一门艺术）不是随意的！或者至少不应该只是为了获得最佳结果。App 的整体体验是一个非常重要的因素，应该符合整个 App 的当前目标。

接下来，我将就决定登陆页的布局因素进行讨论。

---

#### 1 ) 访问的平台：网站还是 App ？

访问平台的影响基于一个相当显然的事实：大部分访问桌面端版本的用户是新用户。这些人希望在决定使用他们时间（和带宽）来下载本机 App 之前，先了解一下你是做什么的。App 是一种忠诚工具，这是一条经验法则：当人们欣赏你的服务，并希望享受 App 提供的所有优点，如即时通知和其他功能时，人们会下载它。也就是说，大多数访问 App 的用户都是老用户，而大多数访问网站都是新手，这个假设是有意义的。那么这个经验是如何告诉我们，当这两个群体访问各自的平台时，该怎么构建第一页呢？为了具有深刻的印象，我另起一个段落：

**为本地 App 创造一个以登录为中心的页面，为桌面版本构建一个以注册为中心的页面！**

这样做的目的仅仅是为了分别迎合两种群体中的大多数人。

举几个在工作中运用这个规则的例子，以免你错过它。

![](https://cdn-images-1.medium.com/max/800/1*nn_BIbwZADDqOlArc2CLng.jpeg)

红色框是用于登录的空间，紫色是用于注册的空间。    
正如你能够从图片中看到的那样，就在每个页面上各自分配的空间方面，相对于登录来说，页面对注册有明显的偏好。

![](https://cdn-images-1.medium.com/max/800/1*8K4YHt_wyGNABzjefVF5Rw.jpeg)

与以上的图像相同，相同的颜色约定在这里被运用。
在相同网络下，移动 App 的情况却是恰恰相反的！

---

#### 2 ) 网络规模

有一种情况，通常在网站中，你会有两组访问者，包括老用户和新用户，他们平等地聚集到相同目的地。但是，你应该不会同时拥有两个群体相同程度的涌入。这意味着当你刚刚推出你的服务时，你肯定会（希望）拥有很多新用户，而不是那些现有的用户（ beta 测试人员和开发团队）。那么，你认为谁才会让你的准备更有意义呢？当然是新用户，那么怎么办？下面是另一个教学时间，且听我慢慢道来：

**在你的平台的早期阶段，应该创建一个以注册为中心的页面！**

很明显，很多设计师（大部分是开发人员）只是提供了用于登陆页面的常见模板，即登录页面。但问题是，为什么你看到这个给你灵感，决定你的 App 也应该如此的 App 界面的唯一原因，是因为该 App 已经有一个成熟的社交网络！这就是为什么你首先就想要使用它！所以当我们喜欢的网络刚刚成长和需要数字时，我们大多数时候看不到它们，就像我们现在一样。所以你不是从错误的人那里得到建议，只是在错误的时间运用它。也许如果我们回到这些平台最初的样子，看看他们在你现在所处的位置，那么你会有想法去做什么。

你真幸运，我碰巧拥有一个哆啦A梦（对于那些不幸的没有看过这部电影的人，我正在谈论一台时间机器），并会帮助你及时回到那些最好的网络最初的样子。

![](https://cdn-images-1.medium.com/max/800/1*R9ObciULy-F55BSWXQibcA.jpeg)

1 — 2008, 2 — 2009, 3 — 2012.
是的，它就是 Twitter .

1–2008 — 这是他们第一次的登陆页面，刚刚推出了新的想法，登录形式几乎没有装饰和边框（字面上）。但是，通过一个鲜艳的召唤点击的按钮告诉你注册，另一个红色 CTA 按钮告诉您观看演示视频，你会看到它们正聚焦在告诉你新平台是做什么的，不是太注重登录，是因为他们知道现在的焦点是吸引他们的第一批成员。对于少数已经加入的人呢？他们可以弄清楚登录表单的位置。

2–2009 — 好的，他们得到了一些关注和可观的成员数量，几乎立即（推出一年后）为现有用户进行了更多的考虑，现在已经有合理的数量来关注 UI 功能了。但是注册按钮仍然在中间至高无上的位置，在充满活力的柠檬绿色中。

3–2012 — 从按钮开始，我们在这里！所以他们现在有稳定的新来者和更多的现有用户。这在登陆页面上如何反映？通过对新老用户给予同等的关注。为什么？因为新用户必须始终照顾，而现在的用户群体太多，以至于无法忽视和不能悉心照顾，这样可以确保所有用户都能继续使用并爱上这个平台！

所以你会发现一个问题可能会发生，当一个设计师四处寻找新网络登录页的好概念时，当他发现了 Twitter 并对自己说：“天才！把登录和注册页面放在一起！让我们也这样做把“。但是，呃...不行！由于你不能细致的了解 Twitter 用户的新旧用户比例，因此你不能采用他们的方法。在这个故事得到教训了吗？好吧，又到教学时间了！所以通常的方法是：

**观察学习对比过去和当前的设计，有时会更加明智。**

#### 3) 特殊情况

当然，总是有那些不符合你发现的模式的人，让你看起来像是破解了所有 UI/UX 的代码。不，他们必须冲在前面，打破规则，做自己的事情。这些包括像 Facebook 这样的登录页面，尽管用户数量庞大，但仍然倾向于新的注册用户。就像我们自己的 Medium ，由于处于用户群体增长的早期阶段，甚至他们的本地 App 都是以注册为中心。但是我们可以理解他们的方法思想。所以我猜这是符合用户基数大小的规则 (#2).

![](https://cdn-images-1.medium.com/max/800/1*pWuQJ8ix9kVgENNHt3VKqw.png)

好的，那么最后的消息是，不要像不值得思考的登记页面一样对待登录／注册页面，因为**每个设计决策，无论多么平凡，都值得你去深思熟虑**。最后的话...与团队的其他成员交谈，听整个产品的策略，看看你的设计决策如何帮助他们从一开始实现所有这一切，从我们的第一个但通常被忽视的朋友开始 - 登录页面。或注册页面，作为戏剧性的结尾，我必须只使用它们中的一个。 :-)

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)。
