>* 原文链接 : [From product design to virtual reality](https://medium.com/google-design/from-product-design-to-virtual-reality-be46fa793e9b#.mq9cnov35)
* 原文作者 : [Jean-Marc Denis](https://medium.com/@jmdenis)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : [cdpath](https://github.com/cdpath)
* 校对者: [emmiter](https://github.com/emmiter) && [Dwight](https://github.com/ldhlfzysys)

# 从产品设计到虚拟现实

![](https://cdn-images-1.medium.com/max/2000/1*5NcDgUuWYNH3iBojzPfM3A.jpeg)

### 从产品设计到虚拟现实

#### 个人经历和 VR 简介

#### 背景故事

我曾在法国的初创公司 Sparrow 工作，2012 年 7 月 20 日被谷歌收购后，我进入谷歌担任产品设计师。随后我同 Gmail 团队从零打造了一款旗舰产品，也就是后来在 2014 年 10 月 22 日推出的 [Inbox by Gmail](http://www.google.com/inbox/)。

我设计了数年的生产力软件，觉得好像碰到[临界点](https://zh.wikipedia.org/zh-cn/%E5%80%BE%E8%A6%86%E7%82%B9)了。我想要拓展自己的技术面，每天学习新事物，更多了解自己从未涉及的领域。我需要新的挑战，逃离[舒适区](https://zh.wikipedia.org/zh-cn/%E8%88%92%E9%80%82%E5%8C%BA)来重启人生。

我在 Oculus 还处于 Kickstarter 众筹阶段时就因其沉浸式的体验和随之而来的无限可能性对虚拟现实感兴趣了。没有什么比创造全新的媒介和探索陌生的领域更令人感到兴奋了。

我在 2015 年 4 月 17 日加入谷歌 Cardboard 和虚拟现实团队。感谢 [Clay Bavor](https://twitter.com/claybavor) 和 [Jon Wiley](https://twitter.com/jonwiley) 提供的机会。

#### 另一维度

我在新团队的前几周简直提心吊胆。大家讲着我听不懂的话，问我不知道从何答起的问题。

![](https://cdn-images-1.medium.com/max/1200/1*y-X1O-mZzjNqiOv2pZw3pg.png)

我不想说谎，快速学习专业术语并不容易，这并不意外。虚拟现实是一个有「深度」的领域（双关意，既表示有难度也表示空间上的深度），汇聚了很多具备专业技能的人才。度过了最初几周的紧张之后，我日渐有了更佳的全局观。慢慢地，碎片化的知识变得完整。我发现了我最适合的角色是什么，我想做什么以及如何达到这个目的。无论从事哪个工作，我要学习的都有很多，但是我已做好准备。我的心情每天都在变化，从对创造并学习新事物的极度兴奋到对有待学习的庞大知识的极度恐惧。和周围聪明又知识渊博的人一起工作让我的心情更加复杂。

#### 都会好起来的

我告诉自己并且坚信生命中的点终会连接起来。我是狂热分子，我知道自己乐意花数小时来学习和实验。

在我的产品设计师生涯中，我得以更好地理解、发现并解决用户问题。不管媒介如何，让东西易于使用和取悦用户的差别并不大。

任务的核心是相同的，但是要从A到B，还要了解一些有趣的东西。

- 打草稿依然是一切的核心。在任何清空大脑或设计的阶段，打草稿都非常的快。我在加入这个团队之后打的草稿比我整个职业生涯打的还多。
- 多种多样的设计技能大有裨益。
- 摄影知识也会有用，因为你要和诸如视野、景深、焦散曲面、曝光等概念打交道。能够充分利用光，对我而言非常有价值。
- 对 3D 和相关工具了解的越多，需要学习的就越少。显而易见，但也要在某些时刻留心，可能要处理结构、特征、道具建模、操作、UV 映射、纹理、动力、粒子等等。
- 动作设计十分重要。作为设计师，我们了解如何用有物理边界的设备来工作。VR没有这些边界，所以要用完全不同的思路。*「这个元素如何产生？如何消失？」*就会是个多余的问题。
- Python，C#，C++或任何编程技能会让你进步更快。由于迭代的基础需求，原型制作非常重要。这个领域如此之新，你甚至有机会抢先设计出独一无二的交互方式。现有的游戏引擎，比如Unity或者Unreal，一般都整合了代码。游戏和VR开发拥有庞大的活跃社区，已有大量的培训资料和资源。
- 做好心灵被震撼的准备并拥抱未知吧。这是一个日新月异的全新世界。哪怕是最大的行业领导者也在摸着石头过河。就是这样。

#### 角色

新媒介引入了许多创造的可能性，设计团队因此会与时俱进。想想主机游戏或电影产业这些例子吧。

我想会有两个设计大户。

第一个将会关注核心用户体验、界面以及交互设计。这和当今产品设计团队的结构差不多（视觉设计师、用户界面师、用户体验师、动作设计师、研究员以及原型师）。

每一个角色都必须适应这个新媒介的规则并且和工程师密切配合。目标应保持不变；构建快速迭代周期去探索交互设计的广阔领域。

另一方面，内容团队会复制独立以及游戏设计工作室的结构来构建一切，从独家体验到 [AAA](https://zh.wikipedia.org/wiki/AAA_(%E7%94%B5%E5%AD%90%E6%B8%B8%E6%88%8F%E4%BA%A7%E4%B8%9A)) 游戏。我们所知其他媒介中的娱乐产业将很可能和VR中的很接近。

最后，这两者都和创造优质端对端体验紧密相关。这两个产业都有很好的机会相互学习。

* * *

快速将我的个人经历讲完吧，我觉得要成为 VR 产品设计师并没有那么难，但是需要献出极大的精力去学习理解跨度极广的知识。

### 迈出第一步并介绍 VR 设计基础

#### 第一步

在本文的第二部分，我会讨论关于这一新兴媒体需要知道的基础知识。我会使用面向设计师的视角，而且尽量简单。

#### 稍微来点技术元素

新的维度和沉浸式体验是颠覆性的。你需要了解一些内在规律才能更深入地理解生理学，才能更加慎重地对待用户。我们在下面这个 app 中重新整编了这些原则好让你能够在身临其境般的体验中学习。

![](https://cdn-images-1.medium.com/max/800/1*n3brb9zrABUe8_WjsskFlQ.png)

[下载 Cardboard 设计实验室](https://play.google.com/store/apps/details?id=com.google.vr.cardboard.apps.designlab)

_想要进一步了解，还可以观看_ Alex 在今年（2015 年） I/O 大会上的[_演讲_](https://youtu.be/Qwh1LBzz3AU?t=18m12s) 。下面是简要的总结。_

如果要记的话，就两个要点：

*   避免丢帧
*   维持头部追踪

人会本能地对外界事件作出反应，你甚至都没有意识到这些事件，所以需要做针对性的设计。

**生理舒适度**。这重新组合了诸如运动眩晕的概念。小心使用加速和减速。维护稳定的地平线来避免「晕船」效应。

**环境舒适度**。人处在高空、狭小空间（*幽闭恐惧症*）或空旷空间（*广场恐惧症*）等特定场景下会感到各种不适。小心处理比例尺和物体间的碰撞。举个例子，如果有人朝你扔东西，你会本能的想要抓住它，规避它或者保护好你自己。充分利用这一本能，但不要让用户感到不适。

你还可以利用用户感官创造更具沉浸感的产品和线索。 你还可以在游戏产业中得到灵感。他们利用各种技巧在游戏过程中引导用户。比如这些：

*   声音：用于空间定位
*   光线：指示路径来引导玩家

* * *

不要伤害用户亦不要让他们过度劳累。当你开始为这个新媒介做设计时，常常会犯这个错误。好莱坞的科幻电影尽管看上去很酷，但是充满了违背简单人体工程学规律的相互作用，而且会随着时间的推移造成极大的不适。少数派报告手势并不适合长时间的活动。

<iframe width="560" height="315" src="https://www.youtube.com/embed/PJqbivkm0Ms" frameborder="0" allowfullscreen></iframe>

我做了一个头部在二维平面运动时的安全区的简化图示。绿色为佳，黄色可以接受但要避免红色。有一些已公开的用户研究会进一步深入讨论这一课题「链接在文章底部」。

![](https://cdn-images-1.medium.com/max/800/1*XJwTciYJOXlJMu62D1vDNw.jpeg)

糟糕的设计会导致更加严重的健康问题。

举个例子，你听说过“短信颈”吗？[《神经和脊柱手术》]((https://cbsminnesota.files.wordpress.com/2014/11/spine-study.pdf))的一篇研究报告测量了头部处于不同位置时颈部受到的压力。 头部位置从直视前方到头往下看时颈部压力增加了 440%。肌肉和韧带会有疲惫酸痛感，神经紧绷， 背脊骨间的软骨层受到压迫。所有不规范动作将导致诸如永久性神经损伤等长期严重的问题。

**长话短说: 避免需要长时间向下看的交互动作。**

![](https://cdn-images-1.medium.com/max/800/1*TxrR4g5d6HZVhBN0nyRwcA.jpeg)

#### 自由度

身体在空间中移动方向有六种。可以在 XYZ 坐标中旋转和平移。

**自由度为 3（方向追踪）**

需要绑定手机的头戴设备，比如 Cardboard 和 Gear VR 通过内置的陀螺仪（3DOF）来追踪方向。所有三个轴上的转动都会被记录下来。

![](https://cdn-images-1.medium.com/max/800/1*bJQluIkWyg3HX2XSCS98CA.jpeg)

**自由度为 6（方向和位置追踪）**

要达到 6 个自由度，传感器需要追踪空间位置（+X, -X, +Y, -Y, +Z, -Z）。HTC Vive 和 Oculus Rift 这类高端设备自由度为 6（6DOF）。

![](https://cdn-images-1.medium.com/max/800/1*sNTxX9iMJnE0oWybyTHNBw.jpeg)

**追踪**
**要实现 6 个自由度需要频繁地光学追踪一个或多个传感器发出的红外线。Oculus 的追踪传感器在固定的摄像头上，而 Vive 的传感器在真正的 HMD （头戴显示器）上。

![](https://cdn-images-1.medium.com/max/600/1*v-ClTzahcgH9IMJtZR3BAQ.jpeg)

![](https://cdn-images-1.medium.com/max/600/1*q_mrMtR0g8KGhedW6bzNKw.jpeg)

#### 输入

为不同的系统设计，需要不同的输入方式，并影响你的决定。比如Google Cardboard只有一个按钮，这导致交互模型就是简单的注释和轻点。HTC Vive 有两个自由度为 6 的控制器Oculus会附带 Xbox One 的控制器 ，不过最终会有一个自由度为 6 的二元控制器，Oculus Touch。所有这些都可以让你使用更先进的沉浸式交互模式。

![](https://cdn-images-1.medium.com/max/800/1*QvXJZuU4HRKVzWaEBzNjvQ.jpeg)

![](https://cdn-images-1.medium.com/max/800/1*b5tx1pcxOkKfhEGQjuEqWQ.jpeg)

还有其他的输入方式，比如手部追踪。最著名的莫过于 Leap Motion。可以把它装在头戴显示器（HMD）。

![](https://cdn-images-1.medium.com/max/800/1*j3oXBLEpGpCqmFj_LE6KaA.jpeg)

随着技术进步，这一领域在持续演进，但时至今日，手部追踪还不是特别靠谱，还不能用作主要输入方式。主要问题在于手和指头，碰撞以及细节动作追踪。

尽管大家都熟悉游戏手柄，它在 VR 中的体验却很糟糕。他从物理上限制了 VR 引入的自由度。在第一人称射击游戏中，扫射和移动会因为加速经常带来不适感。

另一方面，HTC Vive 控制器因为有 6 个自由度增强了 VR 的体验，[Tilt Brush](http://www.tiltbrush.com/#video) 就是个绝佳的例子。我在写这段话的时候，还没试过 Oculus touch，但是我看过的所有的演示都相当不错。[这里有几个 Oculus Toybox 演示视频。](https://www.youtube.com/watch?v=dbYP4bhKr2M)

设计用户界面和交互细节时，输入是关键因素，不同的输入方式将会推动不同设计决策。你应该熟悉所有的输入方式，并认识到它们的局限。

#### 工具

这是一个大的话题，可能需要一篇深入的文章才能讲清楚。我会重点介绍这行业中最流行的工具。

**纸笔**

![](https://cdn-images-1.medium.com/max/800/1*lw9mPIe6HtZeafnSaAt2bQ.jpeg)

我们就是离不开纸笔。它们是我们用到的第一个工具，因为它们常伴左右而且不需要太多的技能。它是公认的表达想法的好工具，可以快速经济的迭代。速度和成本是重要的考量因素，因为对 VR 而言，将线框图转化成 hi-fi 的成本比 2D 更高。

**Sketch**

我仍然每天都在用 Sketch。它易于使用，是在创作 VR 原型之前进行探索的完美工具。它的专业工具和插件用起来非常方便，可以省不少时间。如果你不熟悉这个软件，可以读一下我的 [这篇](https://medium.com/sketch-app/discovering-sketch-25545f6cb161#.bnhmmx6ld) 和 [这篇](https://medium.com/sketch-app/what-is-new-in-sketch-3-4b92d8b25f3#.o7ruj49a8)文章。

![](https://cdn-images-1.medium.com/max/1200/1*_qHJY0GowKCu4jejHLvRCw.png)

**Cinema 4D**

我并不把 C4D 当作 Maya 的竞争者。他们都很出色，各有千秋。如果没有 3D 背景，学习曲线会非常陡峭。我喜欢 C4D ，是因为我可以搞懂它的界面以及参数式无损方法。它可以帮助我快速的创建更多的迭代。我喜欢 MoGragh 模块，还有很多插件可以使用。社区活跃，可以找到很多高质量的学习材料。

![](https://cdn-images-1.medium.com/max/1200/1*plFuA2zJQ4bO2xfE5B1N6w.png)

![](http://ww4.sinaimg.cn/large/005SiNxyjw1f51jnwfayyg30b408c4qq.gif)

![](http://ww3.sinaimg.cn/large/005SiNxyjw1f51jos4kovg30b408cqv6.gif)

![](http://ww4.sinaimg.cn/large/005SiNxyjw1f51jpfq5ppg30b408chdt.gif) 

**Maya**

Maya 的优点和缺点都很突出。一个 3D 艺术家要做的所有东西它都可以完成。大多数游戏和电影都是用它设计的。它稳定性出色，可以胜任海量仿真和复杂场景的构建。不管是渲染、建模、动画、纹理还是绑定，它就是最好的工具。Maya 可以高度定制，这也是它成为工业标准的一个原因。工作室需要创建自己的工具集，而 Maya 则是整合工作流程的完美工具。

另外一方面，学习所有这些工具需要全心无保留地献身其中，花费大量时间。我的意思是数周的尝试，数月的学习和数年的日复一日的基础练习。

<iframe width="420" height="315" src="https://www.youtube.com/embed/BT2W4z_KZzc" frameborder="0" allowfullscreen></iframe>

**Unity**

Unity 基本上就是个什么事情都会发生的原型工具。借助项目的直接 VR 预览可以轻松创建并移动东西。他还是一个强大的游戏引擎，有出色的社区，在线商店中有海量的资源（资源作者来定价）。在资源库中可以找到简单的 3D 模型，完整项目，音频，分析工具，着色器，脚本，材料，纹理等等资源。

Unity 的文档和学习平台非常出色，有着各种各样的高质量教程。

Unity3d 主要使用 C# 或者 JavaScript，有微软 Visual Studio 支持，但是没有内置的视觉编辑器，不过可以在资源库中找到相当不错的视觉编辑器。

Unity 支持所有主流的头戴显示器，是跨平台支持最好的，支持的平台有：_Windows PC, Mac OS X, Linux, Web Player, WebGL, VR(包括 Hololens), SteamOS, iOS, Android, Windows Phone 8, Tizen, Android TV 和 Samsung SMART TV, 以及 Xbox One 和 Xbox 360, PS4, Playstation Vita 和 Wii U_。

Unity 支持所有主流的 3D 格式而且支持创作 2D 游戏需要的最好的格式。内置的 3D 编辑器并不强大，但是有很棒的插件可以进行增强。软件本身需要授权，但是在某种程度上可以使用免费版本制作一些东西的。具体细节可以看 Unity 的[价格说明](http://unity3d.com/get-unity)。Unity 是最流行的游戏引擎，市场占有率高达 47%。

![](https://cdn-images-1.medium.com/max/1200/1*-wg4HHoxsiwY_qJQyJg8xw.png)

**Unreal Engine**

Unreal 是 Unity3D 的直接竞争者。Unreal 同样有着出色的[文档](https://docs.unrealengine.com/latest/INT/)和[视频教程](https://wiki.unrealengine.com/Videos)。不过在线商店规模较小，毕竟是一个新兴引擎。

Unreal 之于其他竞争对手的一大优势是图形能力；Unreal 在几乎每个领域都更进一步：地形，粒子，后期处理效果，光影和着色器。所有这一切看上去都非常出色。

Unreal 引擎 4 使用 C++ 并内置视觉脚本编辑器 [Blueprint](https://www.unrealengine.com/blog/animation-blueprints)。

我没有怎么用过 Unreal，所以不能做更细节的介绍。

Unreal 的跨平台支持不如 Unity，支持的平台有：_Windows PC, Mac OS X, iOS, Android, VR, Linux, SteamOS, HTML5, Xbox One 和 PS4._

![](https://cdn-images-1.medium.com/max/1200/1*5Ny7-MsDrtL83zdsvE5QGQ.png)

* * *

#### 结语

虚拟现实是新兴的媒介。作为先驱者，我们要学习探索的东西仍有很多。这正是我对此感到激动并加入谷歌虚拟现实团队的原因。我们有机会去探索并应该去探索并竭尽所能。理解，认同，构建然后迭代。一遍又一遍。

不断重复这个循环。

![](https://cdn-images-1.medium.com/max/800/1*VJbKu4_pDXrTONwLA4JpPg.png)

* * *

![](https://cdn-images-1.medium.com/max/800/1*yIMdhFHxaoLOBcNLoovrRg.png)

#### 资源

视频

*   [Google I/O 2015 — Designing for Virtual Reality](https://youtu.be/Qwh1LBzz3AU)
*   [Oculus Connect keynotes](http://www.twitch.tv/oculus)
*   [VR Design: Transitioning from a 2D to 3D Design Paradigm](https://youtu.be/XjnHr_6WSqo)
*   [VR Interface Design Pre-Visualisation Methods](https://youtu.be/id86HeV-Vb8)
*   [2014 Oculus Connect — Introduction to Audio in VR](https://youtu.be/X6wSEMh8nR8)

教程

*   [Cinema 4D tutorials](http://greyscalegorilla.com/tutorials/)
*   [Unity 3D tutorials](https://unity3d.com/learn/tutorials/modules)
*   [Maya and 3D tools tutorials](http://www.digitaltutors.com/)

文章

*   [LeapMotion — VR Best Practices Guidelines](https://developer.leapmotion.com/assets/Leap%20Motion%20VR%20Best%20Practices%20Guidelines.pdf)
*   [The fundamentals of user experience in virtual reality](http://www.blockinterval.com/project-updates/2015/10/15/user-experience-in-virtual-reality)
*   [Ready for UX in 3D?](http://www.blockinterval.com/project-updates/2015/10/27/ux-moves-to-3d)

* * *

_感谢所有阅读全文并提出改进意见的人。_

