> * 原文地址：[From Form to Function, Our Thoughts On Design Are Changing](https://medium.com/thinking-design/from-form-to-function-our-thoughts-on-design-are-changing-ed556d8f2b58)
> * 原文作者：[Adobe Creative Cloud](https://medium.com/@creativecloud)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 译者：[Ruixi](https://github.com/ruixi)
> * 校对者：[cfanlife](https://github.com/cfanlife)，[hudson6666](https://github.com/hudson6666)

# 从形式到功能，设计思维的改变

![](https://cdn-images-1.medium.com/max/1600/1*bImmCpF6MPs9JslB21eAVQ.jpeg)

设计作为用户参与的基本驱动力，对商业而言比以往任何时候都更加重要。留意一下最近的用户界面设计趋势，这可能让你感受到用户的期望是如何发生改变的，以及未来的趋势。但在我们深入讨论之前，有个重要的问题需要回答—— **设计是什么？**

### 设计是什么？

大多数人（甚至包括一些设计师）都将设计视作在产品完成之后所添加的视觉点缀、在产品开发结束之后的工艺流程，就像是设计师们强加在工程师的真实工作之上的。设计的确是视觉美学，但不仅如此。就像史蒂夫·乔布斯曾经说过的：“设计不只关乎视觉和感官。**设计关乎（产品）如何运作**。（Design is not just what it looks like and feels like. Design is how it works.）” 设计既包括产品的**视觉体验**，也包括产品的**运作原理**。

### 图形用户界面（GUI）设计的演化

计算机和人类说着不同的语言。设计师们依靠**图形**用户界面使交互成为可能。最近的 GUI 设计演化清晰地表明：**设计趋势就是用户（需求）的不断变化。** 为了证明这一点，我们来看看最近十年的 GUI 设计变化。

#### 从复杂到简单

由于移动设备的普及，2000 年底的 GUI 设计开始产生了明显的变化。设备配置的极大变化迫使设计师们不得不界面进行重新思考，而这又反过来引起了全球的 GUI 设计的变化。

看看 Web 的历史，我们就会发现十年前的网站设计是不成熟的。但对于这种设计来说，视觉展示并不是唯一的问题。网站试图提供**尽可能多的选择**：一个站点所包含的所有信息似乎都是可用的，页面上的每个元素都“同等”重要。（那时的）设计师们觉得这样会让网站对用户来说更有价值。不幸的是，这往往导致页面的杂乱无章。在下方的案例中，你可以看出，从可用性的角度去观察，你可以看到一个乱糟糟的界面能够让人分心到何种程度。

![](https://cdn-images-1.medium.com/max/1600/1*MgAzj4RVV2zFTQKQCmfSRw.jpeg)

随着移动设备的兴起，设计师们开始意识到，用户的注意力是一种需要被合理利用的珍贵资源。这就促使了**高度集中**和**层次化界面**的出现。这样的界面能在用户最需要的时候提供最恰当数量的可用信息。

![](https://cdn-images-1.medium.com/max/1600/1*IMwAqnMVH2peTtdNtwPPhQ.jpeg)

#### 从拟物化到扁平化

你还记得触屏上的所有应用程序看起来都像真的一样的时候吗？那个时候，几乎所有应用程序都在使用拟物化设计风格，而这种风格又是对现实世界中符号的借用。

![](https://cdn-images-1.medium.com/max/1600/1*Mrt--PeX7t5qPmnmwzDUAg.png)

拟物化并不是一种纯粹的设计趋势，它在可用性方面也扮演了重要的角色。当很多用户都对触屏设备知之甚少的时候，设计师们必须确保用户能够明白这些应用程序是做什么的。拟物化设计通过让设计更加贴近(现实生活)来帮助人们理解新页面的运作方式。这就是上方的 iOS 报刊亭应用看上去就像是一个真实的书架（的原因）。随着用户渐渐的熟悉了触屏，这种设计隐喻显得鸡肋，而这种设计风格也逐渐退出了历史舞台。

![](https://cdn-images-1.medium.com/max/1600/1*TxE-vVFUv_61nYtdml78Kw.jpeg)

随着新技术的使用，一种纯粹的数字化外观出现了：扁平化。这种新的设计风格主要依靠平面质感、图标、排版、间距和色彩来营造数字界面的秩序。

#### 从单一终端到跨终端

十年前，一个主要的设计挑战就是保证设计能够在每一个浏览器下正常运行。今天，主要的设计挑战是**保证你的设计在用户所使用的设备上正常运行**。不再有移动用户和桌面端用户这种说法了。只有无论在什么设备上都可能想要照常使用你的产品的用户。这就是为什么**跨终端体验**（在移动端、桌面端、平板和可穿戴设备上的无缝体验）如此重要。目标就是将用户放在你的设计（包括多种终端）之中，[提供一个全方位的解决方案](https://uxmag.com/articles/5-elements-of-omni-channel-user-experiences) ，能够让用户无论在何种设备上都能够高效地使用产品。

![](https://cdn-images-1.medium.com/max/1600/1*j5kqBjTpLFS5e1J3wkmvgw.jpeg)

### 从像素到人

现代应用程序和网站不只是解决方案的视觉表现，更是专注于解决用户问题并提供有价值结果的复杂系统。尽管这些系统有种种优点，但它还是有一个严重的天然障碍——图形用户界面。无论 GUI 如何优秀，人们都不得不去学习如何使用它。为了解决这个问题，现代 UX 已经不再局限于屏幕上的设计，走到了一个没有用户界面的交互世界之中。

#### 节省时间的设计

今天，用户期望他们在与科技交互中获得更忠实于用户习惯、更畅快的体验。他们想要使用被设计来节省他们的时间的产品。节约时间的设计完全是对用户时间的慎重对待，这也清楚地解释了它们崛起的原因。当代应用程序设计力求追随如下趋势：

- **预见用户需求。** 这里用 Dark Sky weather 举个例子。一些用户可能仍然喜欢打开天气应用来查看天气预报，但天气应用最有用的功能是提醒用户突然变化的天气状况：比如通知用户很快就要下雪了。

![](https://cdn-images-1.medium.com/max/1600/1*79Wbi92BeDyVaDPEEQjMLQ.jpeg)

- **理解用户行为和目标。** 当你打开 Apple Watch 的优步应用时，它会直接在屏幕上显示车辆能够到达的时间——不需要拿出手机选择定位。

![](https://cdn-images-1.medium.com/max/1600/0*0ouzEuTHaORKAryP.jpg)

#### 自我学习系统（Self-learning systems，SLS）

自我学习系统控制软件预见一些简单的、需要被自动代替用户完成的任务，或者至少能让用户距离完成任务更近若干步。功能更为自主的软件对用户来说有个很重大的益处——减少了**需要的注意力**。 自我学习软件的基本构件是基于经验学习、对传入数据分析，以及对新的事件作出反应的能力。自我学习系统面临的挑战是如何在关注用户行为的同时，以尽可能少的交互来设计行为。为什么这是个挑战？因为你需要在节约用户时间和为用户提供足够多的选项（让用户感受到自己对系统的控制）找到一个平衡点。

![](https://cdn-images-1.medium.com/max/1600/1*_yiHy0NAU1xANCf6HYxMDA.jpeg)

[Nest](https://nest.com/) 就是个很好的自我学习系统的例子。它是一个可以围绕用户的生活来制定计划的半智能恒温器。每当用户更改系统设置的时候，Nest 都会记下温度调整，并且在几天之后用户对 Nest 的调整会减少，因为它把它学到的一切都变成家庭的时间表。是的，Nest 有很多缺点(最严重的是[系统总是采用自己的方式](https://www.nngroup.com/articles/emotional-design-fail/))，但它依然是下一代产品的绝好示例。展望未来，自我学习软件将会是区别传统应用和现代应用的一个重要因素。

#### 会话式交互界面

随着 iPhone 消息、Slack 以及 WhatsApp 的出现，我们交换信息的方式被完全改变。 短信已经成为一种极其自然的交流方式。

![](https://cdn-images-1.medium.com/max/1600/1*ZMmEYOSW_mZttqHXIEqDpw.png)

这一趋势导致了会话界面的普及。从本质上讲，会话界面就是模仿真实人类聊天的用户界面。“聊天机器人（Chatbot）”是目前我们行业最热门的术语之一。越来越多的应用程序倾向于使用个人聊天而不是 GUI（的形式来和用户交互）。为什么？因为交谈对我们来说感觉很自然，这种特性使聊天机器人的使用比在传统用户界面中点击一堆按钮更加直观。另一个会话界面的优势在于细节程度（这个词我不太确定——译者注）：GUI 在实际中只有有限的选项，但和聊天机器人交谈在理论上（如果设计得好）允许开放式的发现和交互。

![](https://cdn-images-1.medium.com/max/1600/1*odt0dGAYbEau2LXZo8EF3A.gif)

最后但同样重要，青少年和千禧一代——未来市场的主要代表——在短信应用程序中花的时间比任何其他应用程序或网站都要多，为想要接触到这个群体的（人／企业）创造了一个巨大的商业机会。

但聊天机器人不是会话界面进化的最终形态。语音界面将会是聊天机器人的下一步。在不远的将来，语音交互将会在我们与技术的互动中占据很大部分。使用语音命令来控制计算机已经由新一代语音交互软件，比如 Siri、Google Now 和 Amazon Echo 实现了。它们不使用传统的 GUI 作为交互手段。但最大的挑战是了解人们将如何与语音界面进行交互。这需要更好地了解人类——不仅是他们感兴趣的话题，还包括他们将**如何**谈论这些话题。

![](https://cdn-images-1.medium.com/max/1600/1*coZE_xgldZTEQyI7SCdkvg.jpeg)

### 结语

随着技术的不断发展，我们正在使互动与数字服务更直观、更便捷、更高效的道路上不断前行。下一代平台继续发展得更接近人与人之间的对话，未来的界面不一定是由像素组成的。

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)。
