> * 原文链接 : [Faster Photos in Facebook for iOS](https://code.facebook.com/posts/857662304298232/faster-photos-in-facebook-for-ios/)
* 原文作者 : [Tomer Bar](https://www.facebook.com/bar)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : [bobmayuze](https://github.com/bobmayuze)
* 校对者: [SatanWoo](https://github.com/SatanWoo), [Nathanwhy](https://github.com/nathanwhy), [Tuccuay](https://github.com/Tuccuay)

# Facebook iOS 应用是如何加速图片显示的？

你的Facebook的动态消息中充满着一些关于你朋友、家人以及你所爱的人的照片，也许你会想要在手机上也能重温那些场景。我们一直在寻找提升用户体验的方式，包括更优秀和更快的移动端体验。为了达到这个目标，我们团队仔细研究了如何在 iOS 设备上更好更快得显示照片并最终找到了一种方法，能够让 Facebook for iOS 的数据开销降低10%，同时将照片加载显示的速度提升了15%。接下来的内容是讲述我们如何做到这一点的。

## 过去图片是如何被处理的

到目前为止， Facebook for iOS 是根据如下步骤加载你动态消息中照片：

*   我们先拿到这个图片的所有链接，然后根据这个链接来下载格式为JPEG的照片数据。
*   至少两个版本的图片被同时请求，这包括一张缩略图和一张全尺寸的图片。一旦小的缩略图下载好之后，我们会先显示小的缩略图直到更高精度的图片能被用于展示。
*   有时候，我们会根据不同的尺寸将同一张图片下载多次。具体的尺寸是根据设备的型号以及图片在 app 中出现的场景来定义（比如在动态消息当中或者是全屏的 photo viewer ）
*   因为我们对于同一个图片下载了多个尺寸的版本，所以这些不同尺寸的图片都会被储存在设备的闪存中

## 渐进式图片

渐进式图片 Progressive JEPG（简称为 PJEPG ）是一种储存多个独立“扫描”的图片格式。并且图片的精度会随着扫描的次数增加，变的越来越清晰。当所有的扫描版本叠加之后，一张最高精度的图片就会被显示出来。第一次的扫描能给予用户第一个低质量的缩略图。之后的每一层扫描都会使得这张图片的精度上升一个等级。当图片以PJPEG的格式被下载的时候，一旦第一层扫描结束我们可以马上在手机上为用户显示缩略图。当之后的扫描被下载后，我们会更新图片到一个更好的质量。

浏览器对于PJEPG格式图片的支持在2010的时候就已经非常流行了。并且我们采用PJEPG作为图片格式已经有一段时间了。然而，手机端的应用们似乎还没赶上这个潮流。举个例子， iOS 端上还没有渐进式处理图片的支持，所以我们不得不为在 iOS 上的 Facebook 开发新的方式来做到这一点。

## 在 Facebook 的 iOS 客户端上用渐进式图片

在 Facebook for iOS 中采用渐进式的图片渲染有如下一些好处：

1.  数据消耗：PJPEG使得我们可以避免下载小尺寸的图片。
2.  网络连接：因为我们不再需要下载缩略图，我们现在每张图片只需要用到一个数据连接来代替过去使用多个数据连接来下载同一张图片。
3.  硬盘储存：使用PJPEG来储存图片减少了应用对于硬盘的占用。
4.  一个URL：因为我们不再需要根据不同的尺寸来多次下载图片，所以我们可以用相同的URL标识资源。

然而使用 PJPEG 的图片有一个缺点：下载并渲染多个扫描层会占用更多 CPU 的资源。即使解码这些图片可以在后台处理，但是这个进程对于 CPU 来说还是非常繁重。对于我们来说，问题在于在数据占用，网络延迟和CPU的利用率上找到一个平衡点。比如说我们曾经考虑使用[WebP](http://en.wikipedia.org/wiki/WebP) 从文件大小的角度来说，WebP和JPEG相比，在某些情况下是更优的。但这种格式不支持渐进式的渲染。

## 等待图片加载

下面这张图片很好的解释了我们在 iOS 端的 Facebook 上是如何下载图片的。下面的两张图片都表示下载一张图片的情况。 “Wait Time” 表示了从显示一张图片的占位符到加载出清晰能让人表示满意的图片所需要的时间。即使当缩略图片已经显示了，许多用户还是不愿再等待全图的加载。
![](https://fbcdn-dragon-a.akamaihd.net/hphotos-ak-xaf1/t39.2365-6/10540969_770021873088131_38326442_n.jpeg)

当我们使用PJPEG的图片的时候：
![](https://fbcdn-dragon-a.akamaihd.net/hphotos-ak-xap1/t39.2365-6/10935998_1623200524568459_2147345899_n.jpeg)

对于每一张图片，我们在三个不同的扫描层次上进行渲染。

1.  首先，我们渲染一张能够满足预览效果的图片，这一步是像素化的过程。
2.  然后，我们渲染出一张肉眼看上去还不错的图片。事实上，它看上去几乎就是完美的。
3.  最后我们渲染出一张最高质量的图片：达到最高分辨率的一张图。

结果就是用户们可以更快的看到一张棒棒的图片！

![](https://fbcdn-dragon-a.akamaihd.net/hphotos-ak-xft1/t39.2365-6/10935975_819617794775832_888993011_n.png)

## 如何找到正确的扫描分层程度

为了知道什么叫做一张令人满意的图片，我们尝试了不同的扫描层级，并最终找到了人们操作图片时涉及最多的那几个层级。我们同时也研究了不同扫描层级的图片与最终完整图片之间的相似度。我们的对比功能会获取两张图片并返还一个0到1之间的数字来表示他们的相似度。0是完全不像，1是完全一样。下面是一些测试的结果：

![](https://fbcdn-dragon-a.akamaihd.net/hphotos-ak-xpf1/t39.2365-6/10956903_771333189588155_1044601403_n.png)

为了对比选择不同扫描分层深度所带来的影响，我们还做了个[A/B 测试](https://code.facebook.com/posts/520580318041111/airlock-facebook-s-mobile-a-b-testing-framework/) 然后对数据进行了核实。

## 取得的成果

1.  在 iOS 端上的 Facebook 采用PJPEG后数据占用减少了10%。
2.  在用了用PJPEG之后，我们将加载一张令用户满意的图片的速度提高了15%左右。新的图片和原来的全精度图片相比几乎没有区别。
3.  采用PJEPG帮助我们提高了预览图的加载速度。通过这种方式，虽然 CPU 比以前多用了一点资源，但是我们大大减少了需要下载一张图片的时间。

在 Facebook ，我们仍然继续致力于减少用户等待的时间，并且这只是我们很多努力中的一小部分。即使采用PJPEG后，照片的加载速度已经变得很快了，但是我们知道还是有很多提升的空间来更好的提升用户体验。

很多人都在这个项目上花费了相当的时间；我们应当感谢Linji Yang, Miguel Cohnen, Kun Chen, Kirill Pugin, Edward Kandrot, Marty Greenia, Brian Cabral 和 Tomer Bar.
