> * 原文链接 : [ Empty State: Mobile App “Nice-to-Have” Essential ](https://uxplanet.org/empty-state-mobile-app-nice-to-have-essential-f11c29f01f3)
* 原文作者 : [ Nick Babich ](http://babich.biz/)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 :[ MAYDAY1993 ](https://github.com/MAYDAY1993)
* 校对者: [jiaowoyongqi](https://github.com/jiaowoyongqi) [shixinzhang](https://github.com/shixinzhang)

# 在开发移动应用时你应该考虑的 「Empty State」

普通应用在安装后的前三天会失去 77% 的日活跃用户。更为严重的是：三十天内，大约[ 80% 的日活跃用户会流失](https://www.linkedin.com/pulse/losing-80-mobile-users-normal-why-best-apps-do-better-andrew-chen).

这些低留存率是因为应用做的很烂么？并不总是这个原因。

用户试用了很多应用并且在最初的几天决定要删掉哪些。应用成功的关键是在关键时期吸引住用户。

你的任务是确保用户停留足够长的时间并有很多交互操作来享受应用。 但在这些好情况发生之前他们应该享受第一次使用。

通常我们设计一个很受欢迎的界面，布局里的每个元素看上去都安排的很好。空白状态界面通常是你最后设计的。事实上 empty state 对于吸引用户操作充满潜力。即使 empty state 只是一个临时的阶段，我们必须认真对待它带来的与用户交流的价值。

什么时候用户遇到 empty state？

* 第一次使用：应用第一次启动

* 错误：遇到一些问题

* 用户删除内容：当用户删掉所有的应用内容

 empty state 的作用不仅仅是装饰的作用。除了通知用户页面上期待展示的内容， empty state 也具有优化首次使用体验的作用－－他们告诉用户需要哪些明确的操作，所以应用才会有预期的功能。当用户遇到一个问题， empty state 也是极好（或坏）的。

一个成功 empty state 的完成下面三个目标：

* 教育和帮助

* 让用户愉悦

* 提示用户进行操作

 empty state 的第一个目标是教人们怎么用你的应用。如果他们不理解功能，他们会离开。所以你应该通过建立起对未知的期待，让用户体验更好。

![](https://cdn-images-1.medium.com/max/800/1*Ssdl9aLaPp00aSyXk_9dfw.gif)


[ Invoice app ](https://dribbble.com/shots/2264802-Empty-states) —双色插图的空白状态页，清晰地展示了如何快速地管理数据、查看销售业绩以及掌握客户动态的所有功能。


 empty state 应该在出错的时候起作用。你需要在 empty state  的友好和有用间找到平衡。当显示错误的时候，向用户解释为什么他看不到任何东西以及如何解决这一问题：

**不好的例子:** Spotify 的 empty state 只有 ‘An error occurred’ 信息


![](https://cdn-images-1.medium.com/max/800/1*flCJh0D4pHW_MvN4WRwRxw.png)


**[Spotify’s](https://itunes.apple.com/us/app/spotify-music/id324684580?mt=8)** 的错误提示并不像它本该的那样有用。

**好的例子:** Azendoo .感到迷茫和失连啦，像你在一个废弃的小岛上？听从建议，保持冷静，点把火，持续刷新就好啦。

![](https://cdn-images-1.medium.com/max/800/1*ydkY2tT5WIKUUH6KE6Te3w.png)

[ Azendoo’s ](https://itunes.apple.com/us/app/azendoo-tasks-conversations/id581907820?mt=8)的错误页面好玩又有用。

一个首次使用的好的 empty state 强调如下的时刻：

一个好的印象不仅仅是关于可用性，还关于个性化。如果你的第一个 empty state 页面看上去和相似的产品有一点不同，你已经向用户表明整个产品的体验也可能不同。对于 empty state 你的目标是给用户一个愉快的惊喜。

![](https://cdn-images-1.medium.com/max/800/1*lds5Wy3tr9ZfczCvBDQcfA.png)

苹果上 **Dubizzle** 的没有喜欢的广告。

你能设计一些新鲜或惊喜的么？像是一个动态的 empty state ：

![](https://cdn-images-1.medium.com/max/800/1*8rPDEnwRzQnReRL0CKdLzA.gif)

**Workmates**  —动物在单独页面用可爱的hi和hello和你打招呼呢。

或者你可能编个笑话？

![](https://cdn-images-1.medium.com/max/800/1*JBp1Gfz0tEyjkMsnncv-WA.png)


**[Cognito Brain Training](https://itunes.apple.com/us/app/cognito-brain-training-games/id872808619?mt=8)** —你会吃惊于看到一只鲨鱼，不管内容。

[ Aaron Walter ](https://twitter.com/aarron?lang=en)用人类需求的等级作为一个应用有成功的用户体验的一个[解释](https://speakerdeck.com/aarron/learning-to-love-humans-emotional-interface-design)；应用除了应该是有用的，可靠的、能用的，也应该是使人欢快的。所以设计下面的页面同理：

![](https://cdn-images-1.medium.com/max/800/1*YkkBujuWgkAgfHzF2LhGIA.jpeg)

在 **Line Play** 里没有新闻结果。不管怎样，这体验很不好。

看你的手机里的首次使用页和其他应用的 empty state 体验。通过以下方法来取悦用户：

将一个 empty state 视为一个微型的登录页面。设计上保持微型的同时，一个成功的页面将会解释一个明确的特性并让用户有下一笔操作。

![](https://cdn-images-1.medium.com/max/800/1*8uoH4mJgXckTrXI00ENcsA.png)


为了在一个 empty state 促使用户下一步操作，你应该这样：

* 刺激用户：用适合用户的刺激性的语言和设计例如： “Learn more” 或 “Let’s get started.”

![](https://cdn-images-1.medium.com/max/800/1*vPq7xB-7dPR0lbm0yrXokg.png)

**[Dropbox](https://itunes.apple.com/us/app/dropbox/id327630330?mt=8)** iOS 应用

* 说服用户：提醒他们当他们使用产品后将会获取的好处

![](https://cdn-images-1.medium.com/max/800/0*NJntJk_zESA2Wh9r.)


**[Flipboard](https://flipboard.com/)** 移动端应用

* 引导用户：向他们推荐并展示开始使用应用最好的方法。提供一个提示（或箭头）的按钮来引导用户采取必要的操作来关闭 empty state ，然后得到一个更有意义的页面“

![](https://cdn-images-1.medium.com/max/800/0*x9PMwcO5DYUoRmeP.png)

箭头在第二张图提示操作。来源：[ Dribbble ](https://dribbble.com/shots/2096264-Empty-states)

* 深入研究 empty state 因为它不是用户体验中一个暂时的或很小的部分。让用户在使用你的应用的时候很欢快并且能将个人感觉和产品特性联系起来。向用户介绍应用的好处，用户才能知道他们为什么要在意这个产品。

* 视觉上保持简单的设计：通常来讲，简洁的页面，清晰的图标或插图和一个 [ CTA ](https://en.wikipedia.org/wiki/CTA) 按钮足够了。

* 如果 empty state 是被用户的良好行为触发的，用一个愉快的信息来奖励用户。

* 如果 empty state 是出错后出现的，解释清楚怎样解决这个问题和返回到之前的页面

 empty state 和其他设计组件一样重要，因为用户体验是所有能和谐地起作用的部分的总和。用户界面需要信息和操作之间精细的平衡。 empty state 将用户和设计完善的UI界面相连接起来，以此来保留用户的注意力。

_Follow UX Planet:_ [_Twitter_](https://twitter.com/101babich) _|_ [_Facebook_](https://www.facebook.com/uxplanet/)
