> * 原文地址：[Why Empathy Matters as a UX Designer](https://careerfoundry.com/en/blog/ux-design/empathy-and-ux-design)
> * 原文作者：[CLAIRE RACKSTRAW](https://careerfoundry.com/en/blog/)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 译者：
> * 校对者：

![](https://careerfoundry.com/en/blog/ux-skills-1-copy-04ce154a70fbb2a38b6931bfb17913551e6f6379d78a3cb88ab8156782934cd6.jpg)

# Why Empathy Matters as a UX Designer #

If you’d have seen me being guided around my university campus blindfolded, you might have thought we were playing a game. In actual fact,it was part of my training to become a nurse.

In order to empathize with patients and their families, a nurse should understand how their patient feels. For example,  someone may have a visual impairment or difficulty hearing, they might be worried, they might be in pain or feeling nauseous. To be in a good position to address their needs and help to solve their problems, empathy is important.

Fast forward 10 years, and I’ve changed careers - from nursing to [UX design](https://careerfoundry.com/en/courses/become-a-ux-designer), and I have found that **a lot of what I learnt during my nursing career is still valuable.** Regardless of your product, digital or otherwise, you should be aware that those using your services are not operating in a **perfect testing environment.** You need to find ways to familiarize yourself with and empathize with situations different to your own, and design with these situations in mind.

Read on to learn:

- How my nursing career has informed my role as a UX designer
- The difference between sympathy and empathy (and why you shouldn’t confuse the two!)
- How to use empathy to be a better UX designer
- A successful example of empathy in design: Danone
- Tips for introducing an empathic mindset in your company

So, let’s begin by looking at **what nursing taught me about empathy…**

![](https://careerfoundry.com/en/blog/uploads/versions/UX_Skills_4---x----1260-650x---.jpg)

## How my nursing career has informed my role as a UX designer ##

When I started training as a student nurse, I realized that **in order to successfully build a rapport with patients and their families I needed to be able to empathize with them**, to understand what this experience might be like for them and all of the factors that were influencing their experience of accessing healthcare.

I also came to realize that when a person accesses healthcare services, or any other service, their experience does not exist in isolation from the rest of their life. When someone is admitted to hospital for example, what factors are shaping their experience? Is this the person’s first admission to hospital? Is there someone available to offer them support? Have they previously had good or bad experiences of accessing healthcare services? Thinking empathically allows you to see the bigger picture and consider the person and their circumstances as a whole.

By practising empathy as a UX professional you can apply this holistic approach to assessing user needs by thinking about the user’s experience in it’s entirety, and not just when they are interacting with a particular feature on a screen.

[Curious about Human Behavior? Take our Free 7-Day UX Design Course > > > Learn More Here...](http://info.careerfoundry.com/ux-design/free-ux-course-think-emails) 

In the field of UX you often hear the phrase “you are not the user” which reminds us that as designers we can’t make any assumptions about the people that we’re designing for. To really empathize with users we must be prepared to learn about all of the factors that influence how they interact with and perceive the product or service we are creating for them.

![](https://careerfoundry.com/en/blog/uploads/versions/UX_Skills_6---x----1260-650x---.jpg)

## The difference between sympathy and empathy (and why you shouldn’t confuse the two!) ##

Before we go any further, let’s take a look at exactly what empathy is, how it differs from sympathy, and why having sympathy for those you are designing for might not be helpful for finding the right solutions.

The word sympathy is most commonly used to mean “feelings of pity and sorrow for someone else’s misfortune.” Sympathy is associated with caring and a desire to see the situation of others improve, but it doesn’t enable us to create meaningful connections with others.

Empathy is defined by Dictionary.com as “…the capacity or ability to imagine oneself in the situation of another, thereby vicariously experiencing the emotions, ideas, or opinions of that person.” Empathy is not just about imagining how someone is feeling, but also having some knowledge of their situation and what they are trying to achieve. Unlike sympathy, empathy allows us to make meaningful connections with others.

Without empathy, we cannot fully understand the problems users might be facing in relation to our product. Sympathy alone will likely result in a solution we think is a great idea but which actually doesn’t provide any benefit to the user. Empathy enables us to understand the user and their experience as a whole, facilitating solutions that fix the right problems.

![](https://careerfoundry.com/en/blog/uploads/versions/UX_Skills_3---x----1260-650x---.jpg)

## How to use empathy to be a better UX designer ##

In my experience, the most effective way to practice empathy as a designer is to observe users interacting with your product or service in their own environment, be that home, work, or out and about. Observing users in the field allows us to glean insights that cannot be captured through other research methods. However, the reality is that observational field work rarely happens because it is time and resource intensive. How else can we build empathy for users?

Firstly, try to utilize a diverse set of research methods to gather insights about your existing or potential customers. This way you can capture a range of insights from participants and gain a well-rounded picture of how they perceive and experience your product. Understanding how your product fits into and impacts the lives of your customers will help you to develop empathy for them, so create a variety of opportunities to learn as much about them as you can.

Next, make use of customer service conversations and feedback. Discussions generated in customer service conversations can reveal a lot about how your product or service impacts customers in their day-to-day lives in ways that surveys or usability testing can’t. Take the time to talk with your customer service team, they are likely to have valuable insights to share.

Finally, experience your product from the perspective of a customer; this can be an incredibly effective way to build empathy. For example, as a student nurse, walking around my university campus blindfolded helped me to think about how I would design healthcare services to better serve blind patients.

![](https://careerfoundry.com/en/blog/uploads/versions/UX_Skills_5---x----1260-650x---.jpg)

## A successful example of empathy in design: Danone ##

In 1996 food company Danone partnered with a non-profit organisation called the Grameen Foundation with the aim of tackling malnutrition and boosting local employment in a district of Bangladesh.

Danone brought its expert knowledge of food production and combined it with the Grameen Foundation’s extensive experience of distributing products to rural communities in Bangladesh.

They set up a factory producing a special, nutrient-dense yogurt which would provide a child with 30% of their daily vitamin and mineral requirements. The goal of this project was to create positive social impact, and they managed to do this effectively by empathizing with the unique needs of the local population:

- Traditional marketing methods weren’t suitable because many rural, Bangladeshi residents aren’t literate, can’t travel far, and aren’t well educated about nutrition. Therefore, local women were recruited to do door-to-door sales to educate people about the product and encourage details of the product to spread by word of mouth.
- The factory used local milk supplies and based the price of the yogurt on the cost of the local milk. This kept the price of the yogurt at a level that was affordable for even the poorest families.
- Constraints in certain aspects of food production led to innovative ideas that could be applied to other markets, such as the use of enzymes to keep unrefrigerated milk fresh for longer.

Although this is ‘design’ on a very large scale and of a non-digital nature, this example is an excellent demonstration of using empathy to understand the needs of your target customers, how best to meet their needs, and create opportunities for innovation in the process.

![](https://careerfoundry.com/en/blog/uploads/versions/UX_Skills_2---x----1260-650x---.jpg)

## Tips for introducing an empathic mindset in your company ##

Without a mutual understanding of the benefits that an empathic design approach can bring, it can be difficult to stand up to business-driven product requirements or unvalidated assumptions about the right solutions to implement.

One of the easiest ways to help others in your team or company to start thinking more empathically is to invite them to sit in on user research or user testing. Ask them to be your note taker, or simply have them observe. When a non-design team member can actually see and hear first hand a user experiencing and interacting with a product, it gives them an opportunity to develop empathy for that user and create a meaningful connection with them.

Another way to help others develop more empathy for users is to share insights from user research with the whole company. Present insights in a way that allows others to see how they might translate into opportunities for innovation or priority areas of the product that need improvement.

Visual representations of research findings catch people’s attention and convey insights more effectively than a page of bullet points. Clearly presented user research insights can be a powerful weapon against business-driven product requirements and assumptions held by those in roles far detached from customers.

In summary, by adopting an empathic approach to the design process as designers we can make a holistic assessment of user’s needs to uncover meaningful solutions to problems and opportunities for innovation that are not always immediately apparent.

Persuading colleagues outside of the design team to see user needs from an empathic viewpoint can be challenging, but by including others in user research and actively sharing research insights, you can encourage everyone to have empathy for users and achieve a greater balance between user and business needs.

**Want to learn more about the research I discussed here? Check them out:**

- [Empathy on the Edge: Scaling and sustaining a human-centered approach in the evolving practice of design](http://5a5f89b8e10a225a44ac-ccbed124c38c4f7a3066210c073e7d55.r9.cf1.rackcdn.com/files/pdfs/news/Empathy_on_the_Edge.pdf)  by Battarbee K, Fulton Suri J, Gibbs Howard S & IDEO, 2014
- [A Social Business Success Story: Grameen Danone in Bangladesh](http://knowledge.essec.edu/en/sustainability/a-social-business-success-story.html)  by Renouard C, 2012

>> Finally, if you want to learn more about UX, take our free 7-day [UX Design Short Course](http://info.careerfoundry.com/ux-design/free-ux-course-think-emails).


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)。
