  > * 原文地址：[Do’s and Don’ts of Web Design](https://uxplanet.org/dos-and-don-ts-of-web-design-8c9d6a5de7c6)
  > * 原文作者：[Nick Babich](https://uxplanet.org/@101)
  > * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
  > * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/dos-and-don-ts-of-web-design.md](https://github.com/xitu/gold-miner/blob/master/TODO/dos-and-don-ts-of-web-design.md)
  > * 译者：[吃土小2叉](https://github.com/xunge0613)
  > * 校对者：[michaelia](https://github.com/michaelia)、[Hyde Song](https://github.com/HydeSong)

  ![](https://cdn-images-1.medium.com/max/1600/1*w32GqveebJfDRnxcScB7lw.png)

# Web 设计准则

## 作者： [Nick Babich](http://babich.biz/)

Web 设计是一个棘手的主题。在创建一个网站的过程中需要考虑许多事项。为了简化这个任务，我准备了一份每个设计师都需要考虑的 Web 设计准则清单。好消息是这些准则都很简单。

让我们开始吧！

### 应该考虑的事项

#### 1. 为不同设备提供类似的用户体验

用户会通过不同类型的设备访问您的网站：例如台式机、笔记本、平板、手机、音乐播放器，甚至是手表。用户体验设计很重要的一部分是确保无论用户通过何种设备浏览您的网站，网站都应该提供类似的体验。

![](https://cdn-images-1.medium.com/max/1600/0*-VCHnwp7spMwG4Hp.png)

如果用户在手机上浏览您的网站，要确保他们够轻松找到所有需要的东西，就好像他们在家里的台式机上浏览您的网站一样。

#### 2. 设计简明易用的导航

导航是网站可用性的基础。请记住，**如果用户在你的网站里迷路了，那么无论网站多么酷炫都只是徒劳。**因此，你的网站导航应该是这样的：

- **简单**（网站结构应该尽可能简单）
- **明确**（导航项对用户来说都应该是不言而喻的）
- **一致**（首页的导航应该与网站每个页面上的导航保持一致）

在设计导航时，应该考虑让用户以最少的点击次数来抵达目标页面。与此同时，要让用户能够轻松地找到接下来要访问的页面。


#### 3. 改变已访问链接的颜色

链接是导航的关键要素。如果已访问的链接颜色没有变化，那么用户可能会无意中重复访问相同的页面。

> 了解过去和现在的位置让决定下一步去哪里变得更容易。

![](https://cdn-images-1.medium.com/max/1600/0*45U7rev6kF8Zlltn.)

了解访问过了哪些页面可以避免无意中重复访问相同的页面。


#### 4. 让网页易于浏览

在访问网站时，比起仔细阅读所有内容，用户更喜欢快速浏览屏幕。如果用户想要找到某些内容或完成某项任务，用户会浏览网页直到找到他们所需要的。而你，作为一枚设计师，可以通过设计**良好的视觉层次**来方便用户。视觉层次是指按照元素的重要性来排列元素或呈现元素。（举个例子：用户应该首先聚焦元素 A，其次聚焦元素 B，以此类推……）

> 将页面标题、登录表单、导航项目或者其他重要的元素设为焦点，使其一目了然。

![](https://cdn-images-1.medium.com/max/1600/1*gSXy2vu8lzDbUvcrEScY9g.png)

Basecamp 使用的 [Z 字引导模式](https://uxplanet.org/z-shaped-pattern-for-reading-web-content-ce1135f92f1c) 

#### 5. 仔细检查所有超链接

当用户点击站点上的链接然后进入 404 错误页时，这很容易让用户感到沮丧。当用户正在搜索内容时，他们希望每个链接都指向正确的地方，而不是 404 错误页或其他地方。

![](https://cdn-images-1.medium.com/max/1600/1*Im329ptFcbuPl5zlmRzOiQ.png)

#### 6. 确保可点击元素看起来能点击

外观决定用途。视觉元素看起来像链接或按钮但是不能点击，这样很容易让用户迷惑（举个例子：带下划线的文字却不是超链接，具有号召性用语的元素却不是超链接）。用户需要知道网页上哪些部分是纯静态内容，哪些部分可以点击（或者触摸）。

> 让可点击元素更醒目

![](https://cdn-images-1.medium.com/max/1600/1*rhNztD3TBTgfPrnNQpwCiA.png)

**Menagerie Climb：这个橘黄色的盒子是一个按钮吗？答案是否定的。它的形状和标签让它看起来像是一个按钮，然而实际并非如此。**

### 不应该做的

#### 1. 让你的用户等待太久

根据 [NNGroup 的调查](https://www.nngroup.com/articles/powers-of-10-time-scales-in-ux/)。Web 用户非常没有耐心，只能维持很短暂的注意力。

> 用户的注意力最多维持 10 秒

当用户必须等待网站加载时，他们会变得沮丧，而且只要网站加载速度不够快，用户可能会离开您的网站。即使有最精美的加载指示器，如果加载时间过长，也避免不了用户离开网站。

![](https://cdn-images-1.medium.com/max/1600/1*bOnmY_q5LdzMbPXykFO-ZA.gif)

图片来源：[Ramotion](https://dribbble.com/shots/1816425-Loading-Animation-Intro)

#### 2. 在新标签页打开新页面

这种不恰当的行为会使**返回**键不起作用，而用户通常都会使用**返回**键来回到上一个页面。

![](https://cdn-images-1.medium.com/max/1600/0*dM8vZQw5HVJX7CJN.)

#### 3. 广告满天飞

促销广告会遮盖它们旁边的内容，使得用户更难完成任务。更不用说任何看起来像广告的东西通常都会被用户忽略（这种现象被称为**横幅盲点**）。

![](https://cdn-images-1.medium.com/max/1600/1*5xumyiV2XNYBvj5m1sXQDg.png)

通常，用户会忽略任何看起来像广告的东西（这种现象被称为横幅盲点）

#### 4. 滚动劫持

滚动劫持指的是设计师或者开发者在网站上控制并自定义了滚动条的行为。包括：动画效果、固定滚动点、甚至重新设计滚动条本身的样式。滚动劫持是许多用户最讨厌的事情之一，因为用户失去了对滚动条的控制。设计网站或者用户界面时，要让用户在浏览网站或者应用时能够自主浏览和移动。

![](https://cdn-images-1.medium.com/max/1600/1*eVt_9-Id2vH393Pon7vyWw.png)

[Mac Pro 页面](http://www.apple.com/mac-pro/)使用了一些可恶的滚动效果。它使用单页视差布局，其中每一个小圆点代表页面的一部分。

#### 5. 自动播放有声音的视频

在后台自动播放的视频、音频会惹恼用户。这些务必谨慎使用，并且只在合适的情况下，用户期望如此时才使用。

![](https://cdn-images-1.medium.com/max/1600/1*sxsQBUFoorO3mM5mCyeM3A.png)

Facebook 的视频虽然会自动播放，但是默认是静音播放的，除非用户以某种方式暗示他们正在观看视频才会有声音（例如通过与视频进行交互）。

#### 6. 为了美观而牺牲可用性

网站设计或者用户界面设计绝不应该妨碍用户交互。重要的是，要避免给内容配上杂乱的背景，避免使用妨碍阅读、色彩对比不足等糟糕的配色方案（例如下面的示例）。

![](https://cdn-images-1.medium.com/max/1600/1*Za4Spqvh0ImTuRcKg-0lVQ.png)

**避免文字颜色和背景色的对比度过低。**

#### 7. 使用闪烁的文字和广告

闪烁的内容不但可能引起敏感人群的癫痫发作，而且可能使普通用户心烦意乱。

![](https://cdn-images-1.medium.com/max/1600/1*PIXIsMOrHGP8YnOQ3UsNug.gif)

别用闪烁的文字！

---

**欢迎留言分享您的建议！**

**欢迎关注 UX Planet:** [*Twitter*](https://twitter.com/101babich) | [*Facebook*](https://www.facebook.com/uxplanet/)

**原文地址：** [*babich.biz*](http://babich.biz/do-and-donts-webdesign/)


  ---

  > [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
