> * 原文地址：[Designing Anticipated User Experiences](https://uxdesign.cc/designing-anticipated-user-experiences-c419b574a417#.k46dd8myv)
* 原文作者：[Joël van Bodegraven](https://uxdesign.cc/@jvb_nl?source=post_header_lockup)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[jifaxu](https://github.com/jifaxu)
* 校对者：[marcmoore](https://github.com/marcmoore), [ZhangFe](https://github.com/ZhangFe)

# 设计满足预期的用户体验 #


## 如何做出不需要选择的设计 ##

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/2000/1*nJbVyR1EpTAATNqVkn3xeA.png">

[预期设计](https://www.anticipatorydesign.com/)可能是在体验设计领域里的下一个重大飞跃。就像 Shapiro 说的那样：“[超前一步的设计](https://www.fastcodesign.com/3045039/the-next-big-thing-in-design-fewer-choices)”。这听上去有些疯狂，这又能将我们引向何处？又会对我们和技术的关系造成怎样的影响？

我已经将我的硕士论文贡献给这个话题，在论文里鉴别两种原则，即随可预测 UX 到来的设计挑战和符合预期设计应用的设计模式。而最主要的论点是“预期设计会对我们与技术的关系造成怎样的挑战”。

### 一个不需要进行选择的未来 ###

预期设计是可预测 UX 领域里正在到来的设计理念，这种模式的前提是通过代表用户做出决定来减少他们的认知冲突。

除了它承诺的这些可能的优点，很少有人研究预期设计可能带来的影响。它可能带来一些原则上的挑战，比如数据、隐私和经验泡沫，这将可能会阻碍可预测 UX 的发展。

环境技术、智能操作系统和预期体验都是未来的发展方向。Google Home，Alexa，Siri 和 Cortana 都是智能个人助理，从您的行为，模式和数据中学习，并可能在不久的将来积极主动地预测您的需求。


预期 UX 肯定是一个有前途的发展方向，它能够将我们从[每天要做的 20000 个决定](http://www.nytimes.com/2011/08/21/magazine/do-you-suffer-from-decision-fatigue.html?_r=1)中解放出来。

### 少做选择，尽可能自动完成 ###

预期设计是一种涉及了学习（物联网）、预测（机器学习）和预期（UX 设计）的设计理念。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*7L5dA1Cqb8Jz5aU1X900BA.png">

预期设计的构成

物联网中的智能技术通过观察来学习，而我们的数据通过机器学习算法来解释。UX 设计对于提供无缝的预期体验，使用户远离技术至关重要。预期设计仅在所有三个参与者都可以有效协调工作时才起作用。

作为一种设计原则，预测设计已经在很多产品中使用，而我们并没有积极地意识到这一点。诸如Nest、Netflix 和 Amazon 的 Echo 都是产品通过用户给定数据进行学习，调整和预测的良好示例。

### 5 点在设计时需要考虑的因素 ###

在过去几个月，我采访了 UX 和 AI 领域的几位专家。调查面临的挑战和需要考虑的因素。总结归纳出以下五点思考：

#### 1. 针对经验泡沫进行设计 ####

我们已经知道了在川普身上发生了什么，言论滤泡是真实存在的，我们大多数人被我们自己的“现实”环绕。Eli Pariser 在 2011 年描述了“言论滤泡”，新的个性化网络如何改变人们阅读的内容和人们的想法。当我们周围的设备预测我们的需求并采取行动时同样的风险也存在。一个经验泡沫会让你陷入一个循环的返回事件、行动和活动。是算法造成了这些回归事件。算法是二进制的，无法理解其背后的意义。令人担忧的是算法是不可交流的。应该有一种方法来教导算法分辨正确、错误和意外的行为。

#### **2. 专注于扩展智能而不是人工智能** ####

麻省理工学院媒体实验室的负责人 Joi Ito 提出了一个非常有趣的观点，让我关于设计原则的信念更加多彩。Ito 先生说，人类不应该追求机器人和广义 AI，而应该专注于扩展智能。因为人类的本性是使用技术作为自己的延伸。用机器代替我们的日常活动不符合人类的真正习惯。

#### 3. **响应式算法使数据可理解** ####

当前使用的算法是二进制的并且受限于用户的操作和输入。从概念上讲，他们假设对我们的行为是“个人的”和“可理解的”，但在现实生活中它许多 0 和 1 的问题。算法没有准备好用于预测系统，需要变得更灵敏以适应人们的动机和需求。重新访问反馈回路是实现响应的一种方式。这样，人们可以教算法，最重要的是**为什么**他们喜欢或不喜欢这样东西。

#### **4. 个性化让交互更人性化** ####

物联网是一个快速增长的市场，并且由移动优先转变为人工智能优先。首先，这意味着用户与他们的设备将有着更私人化和更独特的联系。

当我采访受访者并询问问他们对于智能操作系统和人工智能的看法时，大多数人了提到电影《她》。这个角度是有趣的。然而，从 Siri、Cortana 和 Google Home 等智能助手的最新发展来看，缺少一个基本功能：**个性化**。

个性为我们与设备的互动增加了巨大的价值，因为它给人以真实感。如果它富有个性，我们一定会更多的使用它。看看像 Siri 这样的服务，我相信在未来个性化将比大量的数据更重要。

#### 5. 通过提供控制和透明度建立信任 ####

今天，人们为了被推荐正确的内容需要注意自己的网上行为。当你为别人买了一件礼物后，很快就会被同样商品的广告所轰炸（同样的商品，对，就是你刚买完），这让人很恼火。

算法常常误解我的行为，这里有很多改进的余地。数据交互已成为未来提升体验的关键因素。受访者们表达了他们对互联网缺乏透明度和控制力的担忧。很多个人数据最终都进入了“黑盒子”。没有人知道我们的数据如何被大型科技公司使用和处理。为自动化提供选择应该建立信任并促进增长。

### UX 设计正在发生变化 ###

UX 设计正在进化。更多的责任，互动和形式正在影响设计的方法。

比如，用户界面有着越来越多的形式（例如，声控界面），这要求有不同的设计思维。由于构建预测性用户体验涉及到大量的用户隐私， UX 设计师的工作越来越与原则相关。

随着完全自动化的面向消费者的系统的出现，对于减灾设计和引导原则渐渐有了一个清晰的观点，因为未来的设计师承担着着更多关于隐私的责任。

目前基于 Rams, Nielsen(1998), Norman(2013)  和 Schneiderman(2009) 的设计原则不足以实现自动化，因为他们缺少关于透明度，控制，循环和隐私的原则。

在自动化的背景下，经验设计的演变需要通过讨论和设计实践来减轻预测设计带来的挑战。

#### 让我们继续讨论 ####

可预测 UX 是一个日益增长的专业领域。UX 设计的工作随之正在改变。我们正在步入一个由 AI 驱动时代，重要的是分享设计故事，见解和实践，以继续将预测设计发展为一种模式并让可预测 UX 成为一种服务。

[投身于这趟浪潮之中并分享你关于**预测 UX**和**预期设计**的见解](http://www.anticipatorydesign.com)

[www.anticipatorydesign.com](http://www.anticipatorydesign.com)

### 感谢阅读！###