* 原文地址：[WRITE OR FADE AWAY AS A DESIGNER](http://blog.invisionapp.com/designers-should-write/)
* 原文作者：[Michael Abehsera](http://blog.invisionapp.com/author/michael-abehsera/)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：
* 校对者：

# WRITE OR FADE AWAY AS A DESIGNER

Every week a new article comes out preaching to designers the necessity of [learning to code](http://blog.invisionapp.com/becoming-a-designer-who-codes/), sales, or [insert new skill here]. If you don’t learn one of these indispensable skills, your career is bound to crash and burn. Why? Because of the looming AI insurgence or some other wacky theory.

While these articles may be accurate (in a very far future), the main reason we spill these warnings and encourage the learning of new skills is either to earn extra cash, feel more secure in our own job, or to avoid a sense of [imposter syndrome](http://blog.invisionapp.com/overcoming-imposter-syndrome/).

![des-write-1](http://s3.amazonaws.com/blog.invisionapp.com/uploads/2016/11/des-write-1.png?ver=1)

The real question should be: What skill provides the biggest gains for the least amount of effort? And the answer is: Writing.

Don’t believe me? Just read [what 5 top designers had to say about the importance of writing](https://twitter.com/intent/tweet?text=%22what+5+top+designers+had+to+say+about+the+importance+of+writing%22+http%3A%2F%2Fblog.invisionapp.com%2Fdesigners-should-write%2F+via+%40InVisionApp) (.inv-tweet .no-redirect target=inv-tweet no-redirect) and the effects it’s had on their careers.

## Eyal Zuri: Writing doesn’t have to be serious ##

![des-write-2](http://s3.amazonaws.com/blog.invisionapp.com/uploads/2016/11/des-write-2.png?ver=1)

[Eyal Zuri](https://dribbble.com/eyalz) is best known for [Muzli](https://muz.li/?__hstc=186349814.a0054baee1450d7b41d267e3c24b470f.1480689839481.1480689839481.1480689839481.1&amp;__hssc=186349814.1.1480689839482&amp;__hsfp=3354096619), which recently [joined InVision LABS](http://blog.invisionapp.com/invision-muzli/), partially due to Zuri’s consistent blogging. He publishes around 16 articles a month after looking for new ways to grow Muzli. Zuri quickly realized that creating great content is an easy way to generate more traffic.

[This article](https://medium.muz.li/funniest-animated-gifs-from-2015-39a81ea278f1?__hstc=186349814.a0054baee1450d7b41d267e3c24b470f.1480689839481.1480689839481.1480689839481.1&amp;__hssc=186349814.1.1480689839482&amp;__hsfp=3354096619#.zcbfi8tzz) generated a lot of buzz, causing significant growth in all of our channels. It’s funny, lighthearted, and not binding, which are keys to a good article.

“I don’t really write. My articles are based on inspiration only,” Zuri said. “It allows me to create a relatively large amount of content that people love to consume.”

**Related: [Why writing should be part of your design portfolio](http://blog.invisionapp.com/writing-design-portfolio/)**

## Paul Jarvis: Write to boost doing what you love ##

![des-write-3](http://s3.amazonaws.com/blog.invisionapp.com/uploads/2016/11/des-write-3.png?ver=1)

After 20 years of designing, veteran designer [Paul Jarvis](https://pjrvs.com/) spends most of his time writing and teaching today. This isn’t surprising, since writing has made him [$400,000 in just 18 months](https://pjrvs.com/a/300k/). In fact, his most recent course sold out in minutes after writing just 1 newsletter.

Jarvis made excuses for years before deciding to blog.

“To be honest, I made every excuse in the book to not write for years. I kept telling myself I wasn’t a writer, so I had no business writing,” Jarvis said. “Then I realized that was a total BS excuse. [All it takes to be a writer is to start writing.](https://twitter.com/intent/tweet?text=%22All+it+takes+to+be+a+writer+is+to+start+writing.%22+http%3A%2F%2Fblog.invisionapp.com%2Fdesigners-should-write%2F+via+%40InVisionApp) (.inv-tweet .no-redirect target=inv-tweet no-redirect) That’s it. So that’s what I did—starting my first book and a regular writing practice for articles. It snowballed from there, and now I spend as much or more time writing as I do designing.”

So how does a designer, who isn’t a writer, become such a damn good one? Jarvis, who still doesn’t consider himself a good writer today, says “Just write for the audience you want to have.”

[“All it takes to be a writer is to start writing.”](https://twitter.com/intent/tweet?text=%22All+it+takes+to+be+a+writer+is+to+start+writing.%22+http%3A%2F%2Fblog.invisionapp.com%2Fdesigners-should-write%2F+via+%40InVisionApp) (.inv-tweet-sa .no-redirect target=inv-tweet-sa no-redirect)

“Help them with the things they struggle with, worry about, or wish they knew more about. Don’t write for other designers unless they’re your target audience, and they probably aren’t,” Jarvis advises.

According to Jarvis, his posts work because they aren’t specifically selling something.

“My articles are entertaining and educational about a specific point, for a specific audience, so that I could paint a picture of what they were struggling with, help them in some small way, and then mention that if they needed further help, my paid courses were available.”

Before Jarvis the teacher, Jarvis the designer wrote posts for potential design clients, [like this one](https://pjrvs.com/a/ask/).

“As my job changed to more of a teacher, articles that spoke directly to the pain I was trying to solve with the courses I teach help me sell those courses—[like this one](https://pjrvs.com/a/personal/) (used for [Chimp Essentials](https://chimpessentials.com/)) or [this one](https://pjrvs.com/a/master/) (used for [Creative Class](https://creativeclass.io/)).”

## Nick Babich: Writing brings opportunities ##

![des-write-4](http://s3.amazonaws.com/blog.invisionapp.com/uploads/2016/11/des-write-4.png?ver=1)

Nick Babich, developer/designer hybrid, usually writes research-packed posts, based on his work experience.

Babich tries to publish 6 articles, between 5 and 7 minutes long, every month. Why between 5 and 7 minutes? Because this way you only need to write the most important details, and also, because you don’t want readers to get bored.

Like Jarvis, Babich’s writing has provided him with a multitude of opportunities, such as a speaking gig at [Push Conference](http://push-conference.com/2016/program/).

“It was such an amazing event! I had a lot of inspiration and new ideas from this experience, and most of them will be in my future posts,” he said.

## Matt West: Write about passions that outweigh the fear of writing ##

![des-write-5](http://s3.amazonaws.com/blog.invisionapp.com/uploads/2016/11/des-write-5.png?ver=1)

Matt West, author of *[HTML5 Foundations](https://html5foundations.com/)*, tries to publish between 2 and 3 articles a month, but sometimes he goes for long periods of time without writing anything, when there just isn’t anything to share.

While there are loads of books on how to improve your writing, West simply focuses on reading a lot.

“Read the work of writers you admire, and pay attention to their use of language, how they structure sentences and how they present their ideas. [You can learn a lot by simply surrounding yourself with great work.](https://twitter.com/intent/tweet?text=%22You+can+learn+a+lot+by+simply+surrounding+yourself+with+great+work.%22+http%3A%2F%2Fblog.invisionapp.com%2Fdesigners-should-write%2F+via+%40InVisionApp) (.inv-tweet .no-redirect target=inv-tweet no-redirect)”

For a while, West lost his passion to write, when writing became more of a chore. It wasn’t until he was presented with the opportunity to author a book on HTML5 that his desire to share his knowledge outweighed his dislike of writing.

West recommends writing about topics you’re passionate about; not only will you do your best work, but you’ll also feel like you aren’t doing work at all.

“Don’t try to please everyone, be opinionated, and stay focused on your core idea. If you put something out into the world, and nobody disagrees with you, then you’re probably not saying anything worthwhile.”

## Andrew Graunke, Director of Design at Toptal ##

![des-write-6](http://s3.amazonaws.com/blog.invisionapp.com/uploads/2016/11/des-write-6.png?ver=1)

Toptal’s Design Director Andrew Graunke connects the world’s top designers with businesses looking to hire. Graunke’s favorite part of writing is how it allows you to connect with new people.

“By [proposing a new design for Crunchbase](https://www.toptal.com/designers/web/crunchbase-design-review), I was able to open a public dialogue with Crunchbase CEO Jager McConnell, who commented ‘…loved your blog post! Lots of good ideas in there—many of which depended on us building the search/list functionality we just launched with Pro. Exciting times ahead!’”

While this may not seem like a huge deal to outsiders, it certainly does to Graunke.

“The work I do takes buy-in from all parties, and even the smallest opportunities look like the biggest opportunities to me,” he said. “Will Jager McConnell leverage our Toptal network to build out design and dev teams? This one’s yet to be seen, and the hashtag’s on me.”

These are just some of the examples of designers getting great results by writing. I couldn’t interview myself but I got my current job as the Lead Editor of the design blog at Toptal by one of the founders of Toptal reading one of [my articles on Medium](https://medium.com/@michaelabehsera) and reaching out to me.

## Challenge yourself to write ##

These are just a few examples of designers reaping great results from writing. Now, it’s your turn.

Perhaps you can begin by leaving a thoughtful comment on someone else’s article.

From there, challenge yourself to write an article of your own. Then write one more and another and another. You get the picture.

The most difficult part is starting, so don’t wait until you find the perfect idea. And don’t edit while you write, or you’ll drive yourself crazy.

[The more you write, the easier it gets](https://twitter.com/intent/tweet?text=%22The+more+you+write%2C+the+easier+it+gets%22+http%3A%2F%2Fblog.invisionapp.com%2Fdesigners-should-write%2F+via+%40InVisionApp) (.inv-tweet .no-redirect target=inv-tweet no-redirect).

To get started, ask yourself: What point do I want to make? And just go from there.

*This was originally posted on [Toptal](https://www.toptal.com/designers/freelance/write-or-fade-away-as-a-designer).*
