> * 原文地址：[Design Thinking, Not Just Another Buzzword](https://blog.prototypr.io/design-thinking-not-just-another-buzzword-3075722b51c8#.g6z3e5oz7)
* 原文作者：[Marco Lopes](https://blog.prototypr.io/@marcolopes?source=post_header_lockup)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[bobmayuze](https://bobmayuze.github.io/)
* 校对者：[FrankXiong](https://github.com/FrankXiong), [Tina92](https://github.com/Tina92)

![](https://cdn-images-1.medium.com/max/2000/1*0BVz9TeT1HG-6ejPvInoQw.jpeg) 

# 设计思考，不只是流行词而已#

&rlm;设计思考是常常被人们提到的概念之一，但大家对于它的精确定义却是众说纷纭。

#### 定义 ####

这个思维方式不是一个被孤立，独立的学科。设计思考更像是一个综合性的，多方法论的，用来解决工程学方面问题的交叉领域思维方式。设计思考主要由多领域的协作和产品不断迭代更新构成。社会上关于这个思维方式的归属有很大的争议：有的人认为这只是一种方法论，还有人认为这种思维方式应当被认为是哲学。然而，大家都同意的是：设计思考是一个 **系统化的解决问题的方式** 并且能 **带来许多新的机遇**

### 设计思考的起源 ###

" 设计思考之所以被创造出来是因为大公司往往缺少创新能力。甚至在极端的情况下，不能为用户们的未满足的需求提供新的产品与服务。这个锅应该由 20 世纪的教育系统来背，因为他们只注重主流逻辑思想而摒弃创造力。 "


[**设计思考的起源**](https://www.wired.com/insights/2014/04/origins-design-thinking/)


> 设计思考是一个一揽子解决方案，可用性和复用性都非常高的方式。一个思考方式适合所有遇到的问题。事实上，这是一个在传授问题解决能力的时候非常有教育意义的一个思考方式。

**正确的打开方式**


我通常会把这个思考方式分成 2 部分。第一部分：发散性思考，尽可能的想出多的、有创造力的解决方案。在这一阶段方案的可行性不是最重要的，而是新的思路。同时，还需要承认方案的不稳定性，在实践中不断获取反馈并且修正自己的方案。在早期失败没什么大不了的，代价也很小。（译者加：中国有句古话：早死早超生。）

— — — 

第二部分，也就是过程设计，相对第一部分来说就更加理性，更关注在系统层面上如何解决这个问题：把解决方法分割成一步一步的方式来帮助我们解决问题。

这一整个过程的目的就是创造一个新的产品，或者获取一段人们想要的并且有可能变得非常有帮助的经历。并且可以通过技术简单、方便地构建出来然后解决问题。

![](https://cdn-images-1.medium.com/max/800/1*6TsQXpS16jzWku1CR2CBog.jpeg)

一次只关注着一个阶段就好，不要吃着碗里的盯着锅里的。

我接下来会把整个过程分为 6 部分让我们可以一起过一下。由于设计思考的高复用性，我们可以根据实际情况中遇到事件的大小做出相应的更改。

下面这张图可以用来当设计思考的附加说明。你可以几乎不需要估计先后，直接做某一个步骤，然后通常会在一个步骤来回很多次。它是一个十分惊艳的教学工具，并且能深入浅出的解释设计思考的理念

![](https://cdn-images-1.medium.com/max/2000/1*PDTWHDUVUGq5AvZLLlYa7Q.jpeg)

### 第一步：同理心（站在用户的角度想问题）###

同理心是一种能让我们站在他人的角度来观察问题的能力，并以此来理解你的用户。

![](https://cdn-images-1.medium.com/max/1000/1*ldIauRBquhAgvFTMno9hfw.png)

和用户进行高效的交流，知道他们是怎么想的非常重要。设计思考的重点通常在于质而不是在量。这意味着在交流中需要尽可能的选择少数的，具有代表性的用户，这是非常重要的。

> 面谈不只是同感的唯一方式

在第一阶段时，你可以用很多非常高大上的工具，比如说可以列出人们怎么说、做、想和感觉的同理图（Empathy Map）。

画同理图帮助我们理解其他人是怎么思考和感受的。一般来说，调查笔记会按照受访者使用你的产品时的想到了什么，看到了什么，感受到了什么和听到了什么来分类。

![](https://cdn-images-1.medium.com/max/800/1*hbqEtm83r4qf7KLu1g7ljg.jpeg)

**关于同理图的资源:**

[**如何使用同理图 | UX Magazine**](https://uxmag.com/articles/how-to-use-persona-empathy-mapping)

[**论同理心的正确打开方式**](https://uxmag.com/articles/how-to-use-persona-empathy-mapping)

[**10分钟用户解析大法**](https://www.uxpin.com/studio/blog/the-practical-guide-to-empathy-maps-creating-a-10-minute-persona/)



### 第二步：定义问题 ###

现在是时候回过头看看我们遇到的问题并且重新定义它了。**用户 + 需求 + 洞察力**

结合你的调研并且观察你的用户们的真实问题到底在哪里。指出问题的根源，并且开始关注创新的可行性，找准用户的需求。

![](https://cdn-images-1.medium.com/max/1000/1*yNLmbbgoERUpBto5ELx-Cg.jpeg)

基于你的换位思考来重新定义你需要解决的问题。

### 第三步：头脑风暴 ###

尽可能地提出疯狂的，有创造力想法。

**在我看来，头脑风暴是这个思维方式里最有趣也是最激动人心的环节**

![](https://cdn-images-1.medium.com/max/1000/1*lPIWX8-cw9AEb-VOwlR8BA.png)

头脑风暴 = 被释放的想法 + 没有约束（译者：unleash通常用来被释放恶魔）
 
一旦当一个问题/机会被清楚的定义之后，我们便开始寻找解决它的办法。**尽可能的想出多的解决方案。** 在这一阶段，我们不应当因为解决方式太简单或者太基础就抛弃他们。任何一个想法都可能是另外一个想法的种子，所以认真的对待这些种子吧！

此时我们应该把提出解决方案和评估方案可行性这两个步骤分开来。我们之后在**原型测试**的阶段再做方案可行性评估。

头脑风暴就是让"桌面"上的东西变多，摒弃原有的思路和框架。**头脑风暴就是拥抱多选择，多解决方案，拓展性高的方案**

设计思考同时也会让整个团队脑洞大增，成长为一个多选择方案的团队。这样的团队在解决问题时往往能提出站在不同视角的想法，也往往能给出一个更好的答案

#### 花时间用心聆听你的队友们的反馈 ####

在这个阶段的最后，细分筛选所有的想法并留下最好的来为下一步做准备。

**参考资源:**

[**思考方法**](http://www.ideou.com/pages/ideation-method-mash-up)

[**"从想法到行动"**](http://www.ideou.com/pages/ideation-method-mash-up)




### 第四步：原型测试 ###

“一个原型测试比的上开 1000 场会”，来自 [**IDEO**](https://www.ideo.com/post/design-thinking-for-educators)*.*

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/1000/1*MWmT7HaDVgebvbqXqAmGgQ.png">


*原型测试最重要的一点就是“模拟或者一个最终产品的简易模型”来测试，这样就能避免在我们找到适合的方案前花大量的时间和金钱在不适合的产品上*

在原型制作时，我们失败的很快，但是学习起来也很快。早期失败的代价比后期失败的代价要小的多的多。

这一步有很多实现的方法比如"草图","快速原型制作"之类的。不论你选择哪一种方法，他们的本质都是一样的：我们通过建立模拟模型来确认我们的解决方案是否真的契合我们的问题。在这一阶段，我们应当制作快速，简单，低成本的原型。

基于这些内容，一个原型便可以慢慢的成长成为一个内测的产品或者是最小可行性模型（MVP）。

**原型制作相关资源:**

[**什么是原型，什么不是原型 | UX Magazine**](https://uxmag.com/articles/what-a-prototype-is-and-is-not)

[**原型制作指南**](https://www.uxpin.com/studio/blog/what-is-a-prototype-a-guide-to-functional-ux/)


### 第五步：测试 ###

这一步的名字基本上就说明了这一步要做什么。在这一步，我们需要测试我们的原型并且收集用户的反馈，同时更加了解我们的用户。此外，我们还能知道我们的方案到底能不能解决问题。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/1000/1*J6wm2lOAwODVntKi4ADWEw.png">

在测试的阶段，让用户们随意蹂躏你的原型吧！如果有小的调整可以做，那就修改并且重新测试吧。接近用户，**更重要的是，不要对自己的想法过分偏执，要多听听用户的想法**

**测试阶段的相关资源:**

[**13种面对初创公司的测试原型方法**](http://thenextweb.com/dd/2013/08/10/13-ways-to-master-ux-testing-for-your-startup/)


[**UX必须掌握的测试工具**](https://uxdesign.cc/ux-tools-for-user-research-and-user-testing-a720131552e1)


#### 最后说点什么 ####

设计思考是一个从设计挑战开始，站在他人角度看待问题（采访、观察、经历），（重新）定义问题，拥抱新的想法然后用原型测试和迭代原型的一个方法/过程。

它可以被看做是一个问题解决的方法。某种意义上来说，是解决问题的思维方式。

作为一个以解决方案为向导的问题解决方法，设计思考在面对很多棘手的问题时非常有效。

**相关资源:**

[**Design Thinking**](https://designthinking.ideo.com/)


### [设计思考指南](https://dschool.stanford.edu/groups/dresources/wiki/welcome/attachments/8e447/d.school%27s%20Design%20Thinking%20Process%20Mode%20Guide.pdf)###

[**设计思考101**](https://www.nngroup.com/articles/design-thinking/)


[**设计思考正确的打开方式**](https://medium.com/design-thinking-in-motion/design-thinking-unboxed-1476f7c88641)


**感谢阅读，如果你有任何的建议和意见，请给我留言！**

