> * 原文地址：[Design Principles Behind Great Products](https://medium.muz.li/design-principles-behind-great-products-6ef13cd74ccf#.uo9ssig6q)
* 原文作者：[Anton Badashov](https://medium.muz.li/@badashov?source=post_header_lockup)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[jifaxu](https://github.com/jifaxu)
* 校对者：[llp0547](https://github.com/llp0574), [skyar2009](https://github.com/skyar2009)

# 优秀产品背后的设计原则

![progressiveMedia-noscript js-progressiveMedia-inner](https://cdn-images-1.medium.com/max/2000/1*Cd14Zx0mHo_rfTt_bDqSsg.gif)

最近，我需要为我正在做的产品提一些高级原则。我在寻找一些简单而有效的原则，可以用它们来引导设计决策，并解决讨论时的一些分歧。第一步，我决定看看周围的人是怎么做的。经过一段时间的整理，我写了这篇文章，希望能对那些面临这同样问题的朋友有所帮助。

但我发现对于设计原则本身是什么这个概念存在一些误解，所以我们先来快速深入一下这个话题。


### 原则包括什么 ###

如果你去尝试用 google 搜索 “设计原则”，你可能找到的是一些关于图形设计的基础：接近度、平衡、对比度、空间等等。都是些优秀的设计师早已熟知的东西。

下个大部分是合理设计过程的一些原则。掌握这些概念集合可以使你成为一个真正专业的设计师，以极高的效率产出一份优秀的设计。将这些原则用于整个团队，确立了新员工在短期内应达到的标准。让我们看一下 [GOV.UK Design Principles](https://www.gov.uk/design-principles)。

![progressiveMedia-noscript js-progressiveMedia-inner](https://cdn-images-1.medium.com/max/600/1*Sx_CxnMtQynYgg-0vMv5FA.png)

这个列表似乎是合理的，但我认为这样的事情现在是一个基础标准。每个设计师都在和数据打交道，并且试图理解上下文。我相信，如果你为你的团队选择设计原则，应该挑选那些具有开创性，而且可以挑战团队的原则，这样才能进步。


一些团队把他们的原则放在网上，我经常看到一些像“用户友好”这样的原则。我坚信，这样的狗屎是不值得放上来的，除非你的团队里都是一些不懂人际关系的怪人，而你想改变这一事实。既然这样那你为什么要雇用他们？

![progressiveMedia-noscript js-progressiveMedia-inner](https://cdn-images-1.medium.com/max/800/1*lyf7k6VSbGBGm8Gl-oLn6A.gif)

所以，我正在寻找的是**产品设计原则**。而 Gov.UK 至少提供了一个：

>  为了每一个人设计
>
>  易用的设计才是好的设计。我们设计的一切都应该尽可能具有包容性，清晰和可读，哪怕为此牺牲一些美观。我们是为需求而不是为观众设计。我们的设计应该面向所有人，而不仅仅是那些习惯于使用网络的人。最需要我们服务的人通常是最不会使用的人。我们需要从一开始就想想那些人。

产品设计原则应该告诉你、你的团队和利益相关者，你应该在艰难的选择中走哪条路。它们应该专注于和其他竞品之间的区别、产品给人的感觉、以及对商业和客户来说重点是什么。

您可能知道苹果的人机界面指南或 Google 的 Material 设计指南。这些系统背后的设计原则都试图在同一平台下统一不同产品的风格，带来一致的体验。

如果你的产品是多平台的，那么就应该考虑一套设计系统和背后的一些原则，和产品设计原则一样。你想做到的其实是和其他竞品有所区别，并在不同的系统平台设备上统一体验。

这里就有一个相同的问题：一些团队为他们的产品提出了一些显而易见的设计原则：清晰、简单、可用 ── 你不可能在脱离这些原则的情况下创造出一个好产品，实际上今天的专业设计师已经默认这些原则了。

#### 综述 ####

- **优秀的设计原则**
  一些优秀设计的规则。
- **设计流程原则**
  通过什么样的方式设计优秀的产品。
- **产品设计原则**
  产品给人的感觉是怎么样，它应该给用户带来什么样的情绪，又如何与竞品区分开来。
- **系统设计原则**
  在不同的场景下统一产品的用户体验。


### 你的产品需要设计原则吗？###

强大的原则和强大的产品并没有一个必然的联系。但是显然，伟大产品产生的过程需要各个方面的配合，设计原则只是其中一方面，它是用来指导你做出决定和减少争议。它们的目标都是节省时间。

#### 优秀的原则是什么？####

- 简单
- 有实际的例子
- 指导设计决策
- 反映品牌价值

#### 收集 ####

我收集了所有我感觉合适的原则。不包括基本设计规则或过程原则，但我添加了系统设计原则，因为它们与产品设计原则有共同之处。

打起精神来！

### 让我们开始吧：###

![progressiveMedia-noscript js-progressiveMedia-inner](https://cdn-images-1.medium.com/max/800/1*R9nTDNPwWChKAZRIo77yeA.gif)

### [Airbnb](http://airbnb.design/building-a-visual-language/) ###

**统一**

应用的每个部分都是一个更大的整体的一部分，它们都应该对于整体有提升效果。而不应该存在独立特征或异常。

**普遍**

Airbnb 在世界各地被广泛使用。我们的产品和视觉语言应该是友好的。

**标志**

我们专注于设计和功能。我们的工作就是让这一点突出出来。

**沟通**

我们使用动效吸引用户，这也使得我们以用户更容易理解的方式进行沟通。

**像”用户的共同朋友”那样设计**

在产品中将线上的不确定性降至最低，这会让线下的活动变得更加有效。我们的产品让用户彼此认识; 我们也会去了解您正在寻找什么，并凭借这些知识，为用户提供新的体验。。我们提供平台，帮助用户交朋友。当你需要我们的时候，我们就在这儿。

**为了第一印象而设计**

虽然 Aribnb 需要用户提供一些信息来订房，但是我们绝不会泄露用户信息。也就是说，我们需要用户告诉我们他们是谁，但是否告诉我们关于他们自己的信息取决于用户本身。

**信任需要努力**

就像生活中的大部分事情一样，你会从 Airbnb 中获得回报。对于 Airbnb 的信任是双向的。我们发现客人越信任房东，房东就越愿意信任用户。


![progressiveMedia-noscript js-progressiveMedia-inner](https://cdn-images-1.medium.com/max/800/1*Nkd9uYfm5uc5nOB8X7a6kw.gif)

### [Facebook](https://www.facebook.com/notes/facebook-design/facebook-design-principles/118951047792/) ###

**普遍**

我们的使命是使整个世界更加开放，连接每个角落与每个人。所以我们的设计需要考虑到每个人，每一个文化，每一种语言，每一台设备，以及以及每一个人生阶段。这就是为什么我们构建的产品适用于90％的用户，并且去掉了只对少数人有用的功能，即使这样的代价是短期内的退步。

**以人为本**

只要用户来到我们的网站就会被朋友们围绕着，也能认识更多的人。我们产品的核心承诺就是你关心的人都在这儿。这也是为什么我们的声音和视觉风格是用户的声音、面孔以及言论之后的背景。

**简洁**

我们的视觉风格是简洁和低调，目的是为用户创建出一个干净的使用环境。一个小型且留白充足的空间可以增进用户的参与度，加强诚实透明的沟通。简洁可不是视觉风格中最容易实现的效果。正好相反的是，由于我们减少了依赖样式的数量，间距比例和颜色搭配变得更加重要了。

**实用性**

通过时间的检验，我们发现当相同的部分以相同的方法表达时，产品的易用性大大的提高了。我们通过一致的体验与用户互动以建立起信任，所以，重用，不要重复设计。

**有用**

我们的产品比娱乐更实用，会在日常中被重复使用，提供有效的价值。这就是为什么我们的核心内容（用户每天都参与的行为）是精简的，而且避免了不必要的点击和空间的浪费。

**快捷**

我们重视用户的时间胜过我们自己的。我们认识到更快的体验会带给用户高效，轻松的感觉。因此，不应该让用户去担心网站的性能问题。我们的网站要尽可能的快。

**透明**

用户信任我们，他们的身份、照片、想法、谈话记录都给了我们。我们以最大的诚实和透明度回报他们。我们很清楚发生了什么及其发生的原因。


![progressiveMedia-noscript js-progressiveMedia-inner](https://cdn-images-1.medium.com/max/800/1*9TH9yRReIvtYwcxMaoTJ4Q.gif)

### [Apple](https://developer.apple.com/ios/human-interface-guidelines/overview/design-principles/)  ###

**美学完整性**

美学完整性代表了应用程序的外观和行为与其功能相合的程度。例如，帮助人们执行严肃任务的应用程序可以通过使用微妙，不显眼的图形，标准控件和可预测的行为来保持他们的注意力。另一方面，沉浸式的应用程序，如游戏，可以提供一个迷人的外观，带来乐趣和兴奋感，同时鼓励用户主动探索。

**一致性**

具有一致性的应用程序通过使用系统提供的界面元素、众所周知的图标、标准文本样式和统一术语来实现熟悉的标准和范例。该应用程序包含的功能和行为都在人们预期之内。

**直观的操作**

直接操纵屏幕上的内容可以吸引人的注意力并有助于理解。当旋转设备或使用手势影响屏幕上的内容时用户会觉得这很直观。通过直观的操作，他们可以马上看到动作的直接效果。

**反馈**

反馈就是接受操作并显示结果，让人们知道。内置的 iOS 应用程序提供可感知的反馈，以响应用户的每个操作。比如交互元素在轻敲时突出显示，进度指示器显示耗时操作的状态，动画和声音有助于突出操作的结果。

**隐喻**

如果人们发现应用的虚拟对象和动作和平时的体验相似，那就能更快地学习 ── 无论是现实世界还是数字世界。隐喻在 iOS 中表现良好，因为人们与屏幕进行物理交互。他们移动视图以露出下面的内容。他们拖曳内容， 他们切换开关，移动滑块和滚动选择器。他们甚至可以像在现实世界中那样浏览书和杂志的页面。

**用户控制**

在 iOS 中，是用户在控制而非应用程序。应用程序可以建议一个行动方案或警告危险后果，通常由不应该完全让应用程序去进行决策。最好的应用程序在给用户的选择权和避免不必要的结果之间能找到正确的平衡。一个应用程序可以通过保持交互式元素的熟悉性和可预测性，让用户确认破坏性的操作，同时让它易于取消（即使这些操作已经在运行了）来让用户感觉一切都在控制之中，。

![progressiveMedia-noscript js-progressiveMedia-inner](https://cdn-images-1.medium.com/max/800/1*nYyUvTFwwQAsjj2S58ac1A.gif)

### [Google Material Design](https://material.io/guidelines/#introduction-principles)  ###

**Material 是一种隐喻**

原型化隐喻是空间和动作系统的统一理论。原型化的基础是触觉，灵感来自纸张和墨水的。现在它是一种先进而充满魅力的技术。

原型化的设计接近现实中的视觉体验。使用熟悉的触觉属性有助于用户快速理解。现在，原型化的灵活性创造了新的能力，超越了物理世界，而不破坏物理学的规则。

光，表面和运动的基本原理是传达物体如何在空间中移动，相互作用和存在的关键。逼真的光照显示接缝，划分空间，并指示移动的部件

**大胆，图像，刻意**

基于打印的设计元素 ── 排版，网格，空间，尺度，颜色和图像的使用的基本要素 ── 指导视觉处理。这些元素不只是为了取悦眼睛。他们创造层次结构、意义和焦点。大胆的颜色选择，边缘到边缘的图像，大规模的排版和有意的留白创建了一个大胆和图形界面，这些能让用户沉浸于体验。

强调用户的操作使可以让核心功能立即显现，并为用户提供引导。

**动效应具有意义**

动效以尊重并加强用户作为主要目的。用户操作是最初引入运动系统的原因，这改变了整个设计。
所有操作都在单个环境中进行。就算对象经过了变换或重组，最后呈现给用户的时候也不应破坏掉体验的连续性。

动效是有意义的，有助于集中注意力和保持连续性。在尚未清晰展现的时候有微妙的反馈，连贯动画也是高效的。

![](https://cdn-images-1.medium.com/max/800/1*2isg1rY5gimcFb5r4mgLMg.gif)

### [Microsoft](https://www.google.ru/url?sa=t&amp;rct=j&amp;q=&amp;esrc=s&amp;source=web&amp;cd=1&amp;ved=0ahUKEwiH4qL2h_7RAhXEF5oKHTUODrAQFggcMAA&amp;url=https%3A%2F%2Fwww.microsoft.com%2Fen-us%2Fdesign%2Fprinciples&amp;usg=AFQjCNH_3g0Ib4u3izhV6NVodNohr9nA4g&amp;sig2=YOGn3O0svJx5bcsXbhql4w&amp;cad=rja) ###

**保持简单**

简单是我们从一而终的追求。我们知道设计应该是直观的。这让用户对我们的产品始终熟悉。

**私人化**

接下来，我们的挑战是与个人建立起情感上的联系。我们依据现实中人们生活、思考的方式来进行设计。这样做的结果就是我们的设计让用户觉得这是为他私人订制的。

**广泛思考**

我们试图拥抱那些符合人类习惯的设计。这不仅是一种工作态度  ── 还是在创建一个更加美好的世界。

**创造快乐**

我们最后的原则是关于系统的活力。这是关于如何让用户感觉到产品是由人创造的。这会给用户带来惊喜的体验。

![](https://cdn-images-1.medium.com/max/800/1*_ww9DxBI9JeWuDIqf9j4_Q.gif)

### [Medium](https://medium.com/@dustin/thanks-for-writing-the-article-julie-8362fd235ae0#.h5e9d8xws)  ###

**引导高于选择**

当我们设计 Medium 的编辑器时经常提到这个原则。我们为了有效的引导用户而有意改变布局，类型和颜色选择。因为我们希望人们专注于写作，而不需要去被选择打断，所以引导是更合适的。

**可用性高于一致性**

这可能看起来是存在争议的，但是当应用于不同的设备，它的目的是明确的。如果它更适合于某种操作系统，我们宁愿破坏一致性。

**不断完善**

以 Medium 中分享草稿、写评论和记笔记为例。Medium 上的内容应该是随着时间不断的改进。我们的目的可不是为互联网设计印刷书。

![](https://cdn-images-1.medium.com/max/800/1*6EIxwoYI7Y7VoH7M2L8Jbg.gif)

### [Firefox Design Values](https://people-mozilla.org/~madhava/FDV/) ###

**照顾你自己**

Firefox 支持您 ── 您的安全，隐私和网络生活的质量。它帮助您为您的时间，数据和关注做出明智决定。

- 用户主权
- 默认为隐私
- 没有意外
- 可行性建议

**你在帮助改善它**

Firefox 为最好的用户体验而设计，但它只有在你的手中才能完美的发挥作用。

- 调研以了解我们的非核心社区的需求
- 让用户从默认配置开始
- 隐式与显式自定义
- 邀请用户来帮助改进我们的产品

**对用户友好**

Firefox 是您选择的产品社区的一部分，因为它们是优秀的，而不是因为它们是默认的。所以，Firefox 从来没有强迫你使用特定的服务或程序。相反，它让你选择（也会有一些很好的建议），所以你可以有最好的体验。

- 用户控制与选择
- 您选的服务是易于使用的
- 帮助您从互联网中获取更多的信息

**旺盛**

虽然其他浏览器可能或朴素简单，或时尚，而 Firefox 是人类，它有趣，异想天开和快乐。我们都喜欢网络，Firefox也是如此。

- 让人们在使用 Firefox 的时候感觉是在于人交互
- 有趣的工具也要易于使用
- 幽默和奇想
- 有自己的观点

**精心制作**

Firefox 是由关心细节的人制作的。一个美好的产品应当易于使用，并让用户感到轻松和明白。这只有通过注意细节和精心制作才能实现。

- 另见我们的视觉设计指南
- 跨平台的外观体验的一致性
- 可感知的质量至关重要

**全球化**

Firefox 由世界各地的人们制作并使用。它不只是简单地翻译 ── 它是为整个世界不同的地区而设计。虽然某些行为是普遍的，但是在全球各地是存在使用和需求的差异性，Firefox 关心这些差异。

- 全球化意味着本地化，本地化和本地化

**平衡权力和简单性**

Firefox 简单且易用，在它的设计中融入了干净，直接的力量。但是简单是方法不是最终目的 ──  最终目的是易于理解和用户至上。

- 80/20/2：外观极简主义并易于访问。
- 用户至上与易于理解，而不只是简单。

**让网络变得有意义**

网络是巨大的，很难理解。Firefox 通过专注于你真正的目标和活动来帮助理解它，并为你提供实现目标所需的工具

- 专注于真正的人类行为
- 许多实际任务涉及浏览器和其他工具
- 快速访问你东西和网络
- 不要说术语

**高用户性能**

速度仍然是良好的浏览器体验的最重要的部分，但是除了基准的技术性能之外，浏览器必须感觉到内部响应。

- 性能是客观的，但响应性是主观的
- 最好有令用户愉悦的表现

![](https://cdn-images-1.medium.com/max/800/1*jV-stFJ91XQfBzvaYBCKJw.gif)

### [Salesforce](https://medium.com/salesforce-ux/defining-principles-to-drive-design-decisions-b647b68fb057#.i7e3yox8p) ###

**明晰**

消除歧义。使人们对自己看到的，理解的和行动有信心

**效率**

简化和优化工作流程。智能地预测以帮助人们更好、更聪明、更快地工作。

**一致性**

通过对同样的问题应用相同的解决方案来培养熟悉感和加强直觉。

**优雅**

通过周到和优雅的工艺展示对人们的时间和精力的尊重

![](https://cdn-images-1.medium.com/max/800/1*J1uRg2nxhzNQenObcVk0rA.gif)

### [IBM UX](http://www.ibm.com/design/language/experience/) ###

**发现、尝试和购买**

与用户保持联系。展示，不要说服。创造从“尝试”到“购买”的无缝转换。

- 发现
  一个理想的发现体验发生在人们觉得答案是自己找到的时候。
- 尝试
  尝试一个产品应该像第一次试驾一样。
- 购买
  购买基于软件的产品或数字服务应该像购买咖啡一样简单和直接。步骤和细节应该是显而易见的。一旦他们的购买完成，给用户一种兴奋的感觉

**入门**

邀请用户，并向他们展示他们可以做什么。初步体验会创造持久的印象

- 人们在接触新事物时会很快形成意见，特别是那些可以改善他们生活的事情。
- 让用户快速完成工作，并向他们展示与您的产品相关的个性化方法。用一些意想不到的东西去吸引他们，以显示你能为他们考虑一切。不要低估小东西; 如果用户发现产品可以节省他们的时间，注意力，甚至他们的办公桌上的空间，他们马上就会感到满意。
- 直到真正提供了个人或商业价值，试用才算结束。

**每天都在使用**

用户每次与您的产品互动时都应该获得个人价值的提升。

无论是每天还是一年一次，用户应该总是感觉一切都在控制之下，能够在他们离开的地方继续。用户应立即了解产品的有用性。系统应该传达其概念模型，以便您的用户知道能期望什么，并且可以执行必要的操作或知道该怎么做。

- 遵循内容，帮助用户了解达到目标的途径。
- 允许他们为了更好的适应自己的需求定制个性化产品。
- 提供一个容错率高的环境。
- 通过确保正确的操作和工具是始终可用的来保持用户的积极性。
- 当用户完成工作时，给他们以满足感，让他们为自己的工作成果骄傲。

**管理和升级**

不断地改进应该像每天使用产品一样优雅和可预测。

- 管理
  易于管理的产品会被经常使用。不必深思熟虑如何管理产品工作情况的用户是一个快乐的用户。无论是负责整个组织的管理员还是最终完成工作的用户，设计明显的管理任务都会带来积极的体验。记住，无论是个人还是团队，期望都是“不要因为管理上的事麻烦我”。

- 升级
  在升级过程中最小化用户的参与度并尽量不去打扰用户。
  在引入重大的用户体验更改时，请不要让您的用户猜测新功能或已删除的内容是什么。通知他们更改正在发生或已发生，发生了什么以及会对他们造成什么影响。

**获得支持**

以用户期望的方式提供支持。提高他们的知识，并鼓励他们分享。

所有五种经验都存在着标志性的“支持”体验。支持是主动，参与和多种形式：

- 在用户所需的论坛（例如，Web 搜索结果和网站，如 TechCrunch）
- 作为发现，尝试和购买或入门的手段
- 在每天的使用中都能快速获得帮助
- 作为 Leverage 和 Extend 的命令行界面帮助

当用户寻求支持时，帮助他们轻松找到他们所需要的。了解用户的习惯，并为他们配备灵活并随时可用的工具

用周到的互动和内容引导他们，以便他们可以学习如何进步并获得必要的技能。在可能的情况下，帮助用户避免错误，而不是等待错误发生

当您的产品或服务中断或不可用时，为用户提供实际状态，以帮助他们了解如何以及何时才能重新使用。确定在当前环境下发出的通知对用户是有意义的。

提供支持应该有助于提高用户对产品的认知。启蒙用户成为专家。使用适合您的目标受众的简明语言。给他们提供反馈和分享他们学到的东西的机会。用户经常信任来自同行的建议，因此尽可能地促进社区学习。

![](https://cdn-images-1.medium.com/max/800/1*oY3kiz236H2rqvT3_gN4cA.gif)

### [Bing](http://www.ibm.com/design/language/experience/) ###

- 为探索者设计
- 愉悦用户并创造惊喜
- 赢得信任
- 品牌效应
- 获得收益
- 展示最好的一面
- 按相关性排布页面
- 注重对于速度的需求
- 提供更多的内容
- 提供无缝衔接的体验

![](https://cdn-images-1.medium.com/max/800/1*aBG9zDQnL3Rsy2Dlb8PIRg.gif)

### [BBC GEL](http://www.bbc.co.uk/gel/philosophy/design-philosophy) ###

**普遍**

我们的信息是清晰的，通过简单，有用和直观的界面进行交流。我们的服务本质上是开放和易于访问。

**引人注目**

我们的声音从严肃，权威，到风趣和娱乐。我们听起来真实并及时，也温暖和人性化。我们通过引人入胜的故事吸引观众。

**真实**

我们重视用户对我们的熟悉和信任。我们继承了 BBC 的标志性设计和广播历史。

**开拓**

我们进行了令人惊喜和高兴的创新设计。我们总是会给观众带来一些意想不到的东西。


**及时**

我们整理了英国的事件时间表：既快速及时反映当下实事，也会加上旧闻相关链接。

**特色**

我们通过展望未来，而不是简单地参考今天的设计趋势脱颖而出。我们在千篇一律的和随意而为之间取得设计的平衡。

**参与**

我们的所有服务和平台是一个连接整体，根据上下文提供连贯的使用体验。我们将具有共同兴趣和经验的受众联系起来。

**本地化/国际化**

我们需要和所有人对话，但我们也能识别每一个个体。我们的消息是可扩展和本地化的。

**现代英国**

我们的服务是英国日常生活的一部分。符合现代英国设计审美并延伸到国界之外。我们的性格充满活力，有时也古怪。

**完美**

最后的是我们把质量放在第一位。

![](https://cdn-images-1.medium.com/max/800/1*qgitfkONhVX5Vhbe4mENKQ.gif)

### [**Pinterest**](https://medium.com/@suprb/redesigning-pinterest-block-by-block-6040a00d80a3#.v2xgv1fl2) ###

**通俗易懂**

- **直观，不需要学习成本**
  即使没有任何的解释你也知道它是怎么工作的。
- **让用户感觉自己很强大**
  没什么会让你感到不舒服或者让你不信任这个系统。系统为您提供正确的组件，并询问您接下来该做什么。
- **让内容变得更好**
  该框架是完全无缝和隐藏的。在你需要它之前你甚至没有注意到它。想要什么是你自己决定的，而不是我们强迫你这么做的。

**动画**

- **多彩**
  个性是大胆和突出。
- **视觉反馈**
  以现实世界的方式交互。
- **出乎意料**
  使用体验是有趣的，绝不会让你觉得压抑。

**牢不可破**

- **为探索而生**
  就像一个孩子的玩具，你想试试看看会发生什么。你用的越多，你学习越快，得到的回报越多。
- **不可错过**
   一切都是为了帮助您轻松使用，完全符合您的想法。
- **可逆**
  如果你不小心做了一些不能产生你想要的结果的东西，很轻松就可以纠正它。

![](https://cdn-images-1.medium.com/max/800/1*xnF6U3zhuOF9qH6gu_2HpQ.gif)

### [Lyft **Design Principles**](http://www.fueltravel.com/blog/tips-from-lyft-let-your-brand-drive-your-ux-decisions/) ###

**明确**
明确的选择和上下文
**建立信心**
一致性和透明度
**独一无二**
自主和愉快

![](https://cdn-images-1.medium.com/max/800/1*VHnY-ykaxPUfAEqrci-n6g.gif)

### [Foursquare](https://medium.com/@sambrown/designing-the-new-foursquare-8f8788d366f0#.fh81og5d1) ###

**因人而异的推荐和体验**

我们为什么应该在寻找一个吃饭，喝酒或购物的地方时得到相同的建议。获得一个适合所有地方的名单在 2006 年可能是创新的，但现在彻头彻尾过时了。我们的口味都不同，那为什么我们都会看到相同的结果？

**持续收集数据和依据情境使用**

我们的手机应该了解我们 ── 我们的口味，我们的社会关系和我们的喜好。并且，使用它们所知道的帮助我们更好地探索我们周围的世界。如果你喜欢老式服装，它应该告诉你附近有一个很好的店。如果你在一个新的城市，它应该告诉你，你的朋友凯蒂强烈推荐这个市中心的小餐馆。如果你渴望辛辣的食物，它应该在你坐下来吃饭时建议你点什么菜。

**有趣的视觉语言**

通过简单、有趣的视觉体验参与城市的探索：将大胆的图标，或明或暗的颜色，标志作为超级英雄会徽和地图标记的组合。

![](https://cdn-images-1.medium.com/max/800/1*Sp8eDx85hFUytKZPBuTumg.gif)

### [**Asana’s Design Principles**](https://blog.asana.com/2013/10/design-principles/) ###

**允许用户专注工作不被干扰**

用户的注意力应在他们的控制之下，只有个人相关事情变化才需要用户转移注意力.。

**通过清晰的表达提高信心**

通过这个程序你能明确地知道在团队中发生了什么及其发生原因。

**培养有创造力和充满感情的人际动态**

用户觉得他们是一个团队的一部分，在这里他们可以相互依赖，感觉正在朝着一个共同的目标前进。

**更快速，轻松，有目的的互动设计**

简单和普通的任务应该是无分歧和明显的; 复杂的任务应该高效和令人愉快。但是，速度不应导致差错。


**在逐步探索中让每个用户感到满意**

每一个使用 Asana 的人都应该感觉他们知道如何使用该产品，无论他们使用多少功能。

**持续标准化，同时在需要的时候创新**

用户应该觉得 Asana 熟悉而现代。


> **如果你的产品有一些很好的设计原则，或者你觉得我错过了其他一些优秀原则的话，请[联系我](mailto:anton@badashov.com)，我会将它加到列表里去。**
