> * 原文地址：[Design principle: Consistency](https://uxplanet.org/design-principle-consistency-6b0cf7e7339f)
> * 原文作者：[Anton Nikolov](https://uxplanet.org/@antonnikolov?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 译者：
> * 校对者：

# Design principle: Consistency #

## The most known and the most fragile design principle. ##

![](https://cdn-images-1.medium.com/max/1000/1*B0pKth3Pzk8Cn0np_gg3uA.jpeg)

Consistency is a key principle in life and in design. Without it we can’t get far. Even the mightiest of problems will fall if you keep hacking it everyday!

Consistency is one of the design principles that we like to violate frequently. I am also guilty of doing that and I am not proud of it. Going all creative and [artzy](http://www.urbandictionary.com/define.php?term=artzy) can easily break this design principle.

The topic about consistency in design is huge. I will try my best to boil it down to the most important points. This way we can learn how to use consistency and how to keep it in our designs without breaking it.

### What is consistency in design ###

Consistency is one of the molecules of the Design DNA. Consistent design is intuitive design. It is highly useful and makes the world a better place.

In short, usability and learnability improve when similar elements have consistent look and function in similar way. When consistency is present in your design, people can transfer knowledge to new contexts and learn new things quickly without pain. This way they can focus on executing the task and not learning how the product UI works every time they switch the context.

We humans like consistency by default! Our physical bodies constantly strive for consistent balance, so we can be healthy. We need to feel that things are consistent to feel secure and safe.

### Benefits of consistency ###

**Users will learn faster how to use your design**. Imagine, that the consistent elements in your design are the letters of the alphabet. Once, the user has learned the alphabet, he can go anywhere in your product and still be able to communicate with the interface without friction.

Having inconsistent interface is like trying to communicate with the user in several languages. Only the advanced users will be able to finish their tasks. [Keep it simple](https://uxplanet.org/design-principles-kiss-the-feature-creep-7eb84b09603f) and consistent.

**Consistency eliminates confusion!** When the user feels confused the next step is to feel frustration. We don’t want our dear user to feel that, do we?

**Consistency saves money and time!** Consistent design is frequently built by predefined components. This allows designers and stakeholders to make decisions quickly without spending precious time to argue. This saves time that can be used to build the product and make incremental improvements.

### Four types of consistency ###

Let's look at four type of consistency that are important to be aware of when designing.

#### **Visual consistency** ####

Similar elements that are perceived the same way make up the visual consistency. **It increases learnability of the product.** Fonts, sizes, buttons, labeling and similar need to be consistent across the product to keep visual consistency.

#### Functional consistency ####

Similar controls that are functioning the same way make up the functional consistency. **It increases the predictability of the product.** Predictability leads to users feeling safe and secure. For example, the way to go a step back in the flow should function the same way across the product.

#### Internal consistency ####

This is the combination of both visual and functional consistency in your product design. **It improves the usability and learnability of the product.** Even when you introduce new features/pages users will have easy way using them as long as you keep the internal consistency.

#### External consistency ####

This type of consistency is achieved when there is design consistency across multiple systems/products. This way the user’s knowledge for one product can be reused in another. Yes, this helps eliminate a lot of the friction and provides great user experience.

Good example of external consistency is the user interface of Adobe products. Once you know Photoshop it is much easier to reuse the same knowledge to start using Illustrator and so on.

Achieving these four types of consistency will help your design gain better usability and more happy users.

### How to be consistent ###

The essence of being consistent is to be able to replicate the same action or element multiple times, and still be able to support the user with achieving the task.

#### Visuals ####

Typography, colors, space, grid, size and positions. These elements need to be defined in one central place and then used across the system you’re designing.

Define strong visual hierarchy, the most important things are bigger than the less important ones. Use the same color palette across the product. Padding and margins need to be consistent in all similar elements (*buttons, cards and etc.*). Everything should be ordered in a grid of your choice that allows arrangement of all components in a nice and aesthetic way.

Having consistent visuals will allow the user to learn the system quickly and have a smooth experience. Your design will gain nice [Feng Shui](https://en.wikipedia.org/wiki/Feng_shui) when you use consistent visuals. :)

Here is a nice source with examples of style guidelines:

[![Markdown](http://i2.muimg.com/1949/2513ad15794cb4bc.png)](http://styleguides.io/examples.html) 

#### Voice and tone ####

The language and tone you use throughout the user flow influences how your user perceives the product. Keep the voice and tone consistent so it feels as one voice speaking to the user. We don't want them to hear many voices, do we? :)

If you want to keep funny and friendly voice in your product design keep it all the way up til the error and fail messages. [MailChimp](https://mailchimp.com) is a nice example of consistent voice and tone.

![](https://cdn-images-1.medium.com/max/800/1*FoyYzFbv7N85ot68ZTbDkQ.png)

[http://styleguide.mailchimp.com/voice-and-tone/](http://styleguide.mailchimp.com/voice-and-tone/)

#### Use familiar patterns ####

People who will be using our designs be it digital or not, have been around for some time. This means they have experienced and learned other designs, and know the patterns used in them.

![](https://cdn-images-1.medium.com/max/800/1*Rgnuo5cD1ArXf6G-JNEflA.png)

[http://www.mobile-patterns.com/](http://www.mobile-patterns.com/) 

We should take advantage of that and incorporate familiar patterns into our designs. The user journey will be much smoother and people won’t even stop to think “Hmm, how do I use this?”, they will directly use it.

Here are two nice sources to look into patterns out of many:

[![Markdown](http://i2.muimg.com/1949/738d30cf07aca807.png)](http://www.mobile-patterns.com/) 

[![Markdown](http://i2.muimg.com/1949/dfb6e38bc4c887ba.png)](http://ui-patterns.com/patterns)

### Bend consistency, don’t break it ###

You might argue that consistency could bore the heck out of the user. If we keep things always consistent there will be almost no innovation.

![](https://cdn-images-1.medium.com/max/800/1*cwiC9HGtMDGC2JKf1HnCNg.gif)

We first need to learn the rules before we bend them. **Yes, bend not break them!** Broken consistency equals broken design and user experience.

It is a pain for both the user and the organization. Design process gets slowed down. Tons of money get burned to pay people to argue in meeting rooms over what color is best for that button. Everybody loses precious time to make decisions that should have been made already and just be reused now.

**Designers should preserve and build the consistency as much as possible.**

Keeping things consistent means change will be slowed down. Still, we need our product to be enjoyable and delightful. We need them to evolve to a better version.

So, how do we keep consistent and still get to where we want to be and drive change?

The “secret” is in understanding your users. All your design decisions should come from that understanding. Make adjustments to the already established and consistent design system only when they are informed by your user’s needs. Making these small changes will evolve the product into a better version and will keep the consistency.

### Final thoughts ###

Align your design with your user expectations. Know your users as you know your partner. Be capable of looking through their eyes and feel through their hearts. Become one with them.

Combine that with great understanding of the design fundamentals like visual hierarchy, typography, usability patterns and etc. **Remember, little change is good, more change is not necessarily better!**

Create consistency to improve usability and to create delight by reducing unwanted surprises.

#### Call to action ####

*If you found this article useful* ***tap the*** *so others can enjoy it, too.*

*Thanks for your time! Connect with me on* [*LinkedIn*](https://www.linkedin.com/in/antonnikolov/)  and [*Twitter*](https://twitter.com/ainikolov).

*Previous design principles*

[![Markdown](http://i2.muimg.com/1949/2237ed46c68ef3e2.png)](https://uxplanet.org/design-principle-cognitive-dissonance-a01dffe81f58) 

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)。
