> * 原文链接: [Design Is Mainly About Empathy](https://trackchanges.postlight.com/design-is-mainly-about-empathy-c9d51ccb208a)
* 原文作者: [Neil Renicker](https://trackchanges.postlight.com/@tinystride)
* 译文出自: [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者: [Rottenpen](https://github.com/Rottenpen)
* 校对者:[geeeeeeeeek](https://github.com/geeeeeeeeek)，[wild-flame](https://github.com/wild-flame) 

# 设计，其实是一种产生共鸣的过程

![](https://cdn-images-1.medium.com/max/1200/1*pwlSr2Qq5rcVVTU7SxEAqQ.png)

当一个老司机试图解释他们复杂的工作给外行人听是非常有意思的。举一个不错的栗子————看理论物理学家 理查德·费曼(Richard Feynman 美国物理学家，加州理工学院物理学教授，1965 年诺贝尔物理奖得主)讨论磁铁。

[![video](https://i.ytimg.com/vi/wMFPe-DwULM/hqdefault.jpg)](https://trackchanges.postlight.com/media/d812c608ece9992d49752bfeafece892?maxWidth=640)

[看看视频FUN TO IMAGINE 4里，费曼是怎么解释磁体是如何工作的](https://www.youtube.com/watch?v=wMFPe-DwULM)

这个记者问到费曼，能不能解释一下两块磁铁之间无形的吸引力。我猜想他会用知识分子风格的愤怒来回应：
  
> “这取决于你是一个物理系的学生还是一个什么都不懂的普通人。[...]我不能依据你所熟悉的其他东西来解释那种吸引力。

> 如果我说磁铁像橡皮带一样相互吸引，那我一定是在骗你，因为它们当中并没有橡皮带相连。那我就将陷入麻烦中 因为你们马上会来问我这个带的本质是什么。还有就是，如果你们很好奇，你们就会问我为什么橡皮带会一次又一次地吸引。这样我会以电子学的原理作为解释来结束这个问题。你瞧，这么一来我没办法用橡皮带来忽悠你们了。

> 所以我只能告诉你们，磁铁是相互吸引的，没办法给你解释它们吸引的原因。

现在，我们全部都好像白痴呢。费曼成功地用简单的栗子回答了记者的问题，但他讲不用围绕着深层的知识来把电磁学解释给外行人。他是一个实践的物理学家，而不是一个教育家。

当一个教育家处理同样的问题，他会怎么做呢？

[![video](https://i.ytimg.com/vi/hFAOXdXZ5TM/sddefault.jpg)](https://www.youtube.com/embed/hFAOXdXZ5TM?wmode=opaque&widget_referrer=https%3A%2F%2Ftrackchanges.postlight.com%2Fmedia%2Fb94633e7912577c9c43a7a0535435925%3FmaxWidth%3D700&enablejsapi=1&origin=https%3A%2F%2Fcdn.embedly.com&widgetid=1)

磁体是如何工作的呢？[https://www.youtube.com/watch?v=hFAOXdXZ5TM](https://www.youtube.com/watch?v=hFAOXdXZ5TM)

> 即使在磁性材料中，原子的磁场排列在一起，也有可能会出现有些磁性材料的所有原子排列在一起指向一个方向，有些磁性材料的所有原子指向另一个方向，等等。

> [这时响起了不祥的中世纪 BGM] 如果所有的磁场大小相近，那可能没有一个原子的磁场能够大到迫使其它原子与之对齐。举个栗子，一块金属可能完全没有磁场，因为它内部的所有磁性都相互交织在了一起。

> 甚至，如果你从材料外面提供一个足够强的磁场，你就能让这条磁感线对它的邻居的作用力扩大，等等。直到所有的磁感线都统一指向同一个地方，同一个方向。这时，你终于可以得出一个关于金属的结论！我想，就是磁体。

> [...]最了不起的地方是，磁场可以从量子属性引申到日常物体的大小，每一个永久磁体都在提醒着人们量子力学是我们宇宙的基础。

> [阅读原文](https://gist.github.com/tinystride/eab1d627fdc568922ed8461d5b7861a4)

这篇文章回答了很多问题，现在我们都会因为这领域的思想而起鸡皮疙瘩。它不是琐碎的技术文章，但成功讲明白了复杂的信息。它没有表现出高傲或是不屑。

![](https://cdn-images-1.medium.com/max/800/1*0AtAl5KKHf37g8gcC1Acsg.gif)

在这样的剑斗场面也不会有人受伤。

这是教育者在制造共鸣。磁体视频的作者想让他们的观众能够了解到磁体的信息。

* * *

软件产品设计师可以从伟大的教育者身上学到很多，因为他们都是和信息打交道的。我们可以想象一下，一个用户寻找关于 "jousting"（马上枪术）的信息。我知道了三件事：

 1.  **这个用户已经想到了什么信息是他想要的。**例如，我听说有 jousting 这样东西，听起来怪怪的，那么我就想看一些关于 jousting 的视频。
 2.  **我们用户需要的信息实际上是通过某种方式存在于世界上。**例如：一个装有视频信息和一些元数据的数据库是被放在北卡罗来纳州的一个服务器的硬盘里。
 3.  **一个产品设计师会通过某种程度的抽象来为用户提供信息**例如，一个在特定URL的页面可以提供用户一个输入搜索查询的地方，一个加载图标，一些商标，一张根据你浏览结果得到的分类清单，一面你突然心血来潮想找点东西来打发时间。它还会有许多引诱你去点击的按钮。

![](https://cdn-images-1.medium.com/max/800/1*HvaeY2L1mF_NPbviSwdq7g.png)

顺便说一下 "jousting" 是很有趣的。

磁化合金和在沙发上看 "jousting" 视频的用户是一堆抽象的东西。因此，将三种模型的信息记在脑海里，并建立它们之间的桥梁，是一个很好的产品设计师的工作。她填补了用户使用机器时的鸿沟，这样用户就不必费事自己去了解。 [Alan Cooper](https://medium.com/u/b1fa02015e7f)是这么说:

> 计算机素养是一种能迫使人类延伸思维，用以了解应用程序逻辑的内部运作，而不是以满足人们通常思维的软件功能产品的延伸。

 让我们更深入去看看三种模式。阿兰·库珀( Alan Cooper 交互设计的提倡者)[_About Face: The Essentials of Interaction Design_](https://www.amazon.com/dp/1118766571/ref=pd_lpo_sbs_dp_ss_1?pf_rd_p=1944687702&pf_rd_s=lpo-top-stripe-1&pf_rd_t=201&pf_rd_i=0470084111&pf_rd_m=ATVPDKIKX0DER&pf_rd_r=04TSA54WA44Z7YC4QTSX).

第一点是用户的_心智模型_。 库珀写到，很多人在他们给电器或计算机插电的时候会认为“电像水一样从墙上黑色小管的电绳里流入电器。”

当然，电力根本不会像水一样流动。在现实世界中，电力的 _抽象模型—_会复杂得多。不过从简单的角度来看，电力工程对我们大多数人来说，已经有足够的信息，以帮助我们了解，例如，我们知道，我们需要把插头塞进插座来给我们的电脑充电。

最后，_表现模型_就是最终由它寻找到用户。这是设计师的时间所花到的地方，是人们实际会接触的部分。

这是设计师的秘密所在，让我们再来看看库珀怎么说：

>“越接近用户心智模型的表现模型，越容易找出应用程序的使用方法和理解。”

说的好极了！对于一个设计师来说，这可能意味着要花更多的时间与用户交单，用更少的时间去挖掘API。这可能意味着早期设计讲花更多的时间来研究用户心理而不是摆弄文字。

<span class="markup--quote markup--p-quote is-other" name="anon_54be6b8e1ff8" data-creator-ids="anon"> 用户的心智模型是我们的指路明灯，虽然它可能是错误的。如果我们不努力去了解这个模型，我们就很难知道我们的工作是否成功了。设计主要是一种换位思考。</span>

举栗子时间：动画是一个练习用户共鸣的好工具。它是一个用户界面模式，用于调整用户的心理模型和产品的表现模型。大家都知道IOS9 顶部的通知菜单不是卷起下面的卷帘式装置。但用户会有有从顶部显示一个新临时状态的心理模型。

![](https://cdn-images-1.medium.com/max/800/1*YybkuqDoXWgLTn8fjp2G4Q.gif)
![](https://cdn-images-1.medium.com/max/400/1*wP7Nzgk19-A7Ez6DUjXsLQ.gif)

 图片借用于[IKEA](http://www.ikea.com/gb/en/catalog/categories/departments/living_room/10701/)

库珀帮助我看到关于表现模型的特殊部分，这一部分也是设计师唯一能够控制的部分。我们不能控制它的实现模型，因为一个好的工程师讲在代码库中使用抽象模型，使其易于维护和安全。我们不能控制我们用户的心智模型，因为它是由他们的文化和其他不可知的很多因素形成的。

作为设计师，我们掌控着整个表现层的生杀大权。而设计，就是将软件按照用户所想把它呈现给他们，然后让用户为之惊叹的过程。
