>* 原文链接 : [Dark Side of UI. Benefits of Dark Background](https://medium.com/@tubikstudio/dark-side-of-ui-benefits-of-dark-background-12f560bf7165#.k0d00u47a)
* 原文作者 : [Tubik Studio](https://medium.com/@tubikstudio)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : [yangzj1992](http://qcyoung.com)
* 校对者: [David Lin](https://github.com/wild-flame), [Ruixi](https://github.com/Ruixi)

# UI 的黑暗面！暗色背景的优势

![](http://ac-Myg6wSTV.clouddn.com/18dcdce02f167c38bd04.jpeg)

在用户界面的背景中选择是否使用暗色调仍然是一个具有高度争议的问题。毋庸置疑，这个问题是很实际的：选择一个合适的背景在所有的产品功效上都起着至关重要的作用，因为它可能会是改善或是反而毁掉设计方案中布局和功能的关键因素。在今天，我们的文章将致力于讨论在 UI 设计中使用暗色背景的好处和缺陷，所以让我们前往 UI 的黑暗面吧。

在我们[之前的文章](http://tubikstudio.com/light-and-darkness-in-ui-design-matter-of-choice/)中我们已经分析了一些可以影响选择通常的配色方案和基本的背景颜色的因素，也提到了一些在这个过程中要考虑的重点。这一次我们将更多的关注暗色设计的网站和移动应用的优缺点。我们在 [Tubik Studio](http://tubikstudio.com/) 中创建并测试了不同的用户界面，这些实际的工作经验证实了暗色背景会是强大而有吸引力的、能提供积极用户体验的解决方案。所以，理所当然的，让我们来开始讨论应该在何时何地怎样让它最大程度的发挥效果吧。

### 对于暗色的视觉感知

很久之前，在 2009 年曾有过一个公开的投票调查结果，[ProBlogger](http://www.problogger.net/archives/2009/05/19/light-or-dark-blog-backgrounds-poll-results/) 基于此已经公布了一些有趣的观点。读者被问及他们更喜欢哪种颜色的博客背景。几乎一半的读者回答更喜欢亮色背景 - 这对于传统的文本驱动型博客来说是十分合理的，在可读性方面如此可以胜过其他方案。然而，有 10% 的受访者回答他们更喜欢暗色背景，并且有超过三分之一的人提到选择的依据应该取决于博客的性质和内容。设计师在寻找设计方案时是不能忽略占有如此大比例的用户的。此外，在具有更少的文本型驱动内容的数字产品情况时，如网站或应用程序中，持上述观点的人数比例应该还会增加。这个例子很好的说明了用户研究和调查应该是设计过程中的重要组成部分。了解用户想要什么或是至少了解他们所能够接受的是什么，这能够将传统视觉的限度推向一个极致。

Richard H. Hall 和 Patrick Hanna 对于这个问题提供的[科学研究](http://lite.mst.edu/media/research/ctel/documents/LITE-2003-04.pdf)中强调了视觉感知的背景颜色和效果的关键点。在分析了不同研究者之前对网络页面效果和可读性方面的实际试验后。作者们总结了：「_他们发现正向对比(即白底黑字)会有更好的效果，并与之前提到的研究结合，说明颜色组合之间的对比度越大效果越好。_」因此在合适的设计和测试下，在其他方面深色背景也可以像浅色背景一样具有好的效果，尤其是在对比性以及布局元素的易读性上。在用户测试角度上这项研究基于不同颜色组合和效果下包含了很多有趣及有用的信息。所以在此强烈推荐给设计师们。

![](http://ac-Myg6wSTV.clouddn.com/f5f8b33e3c4fb542fef3.jpg)

<figcaption>[Ribbet 的用户界面](http://tubikstudio.com/works-ribbet/) 来自 Tubik Studio</figcaption>

### 可读性方面

用户体验设计的著名大师之一 Jacob Nielsen 曾提到过：「_在使用高对比度颜色的文本和背景时。最优的易读性方案是要求使用黑色文字和白色背景(所谓的正向文本)。而白色文字和黑色背景(反向文本)几乎也是一样好的。尽管这在对比度上与正向文本是一样的，但倒配色方案会让人们略微有些迷惑并会稍微降低他们的阅读速度。易读性相当受配色方案的影响，像文本比纯黑稍亮的颜色，尤其是背景色比纯白稍暗的配色，易读性会变得很差_。」

的确，可读性是产品效果表现上的重要指标并且它不仅只针对文本。它超越了文本的限制并且意味着所有有意义的象征，包括字母，数字，象形符号和图片都应该被留意到并轻易的在界面中识别出。因此，设计师在选择深色的背景时应该准备更额外深入的选择并测试不同设备上的字体、图标和图像。

![](http://ac-Myg6wSTV.clouddn.com/30476ea6fc9c5178170f.png)

<figcaption>[SwiftyBeaver 的着陆页](https://dribbble.com/shots/2632600-SwiftyBeaver-Landing-Page) 来自 [Ludmila Shevchenko](https://dribbble.com/LudmilaShevchenko)</figcaption>

最好的网页和应用程序的设计实践，例如 [Awwwards 上最好的黑色网站](http://www.awwwards.com/websites/black/)合集上的例子，这里展现了大量使用深色背景作为基础配色的优秀设计方案，这些方案都没有以牺牲可读性为代价。为了避免低可读性这个问题，在设计过程中重要的是要记住：

*   深色背景会吸收一部分其他元素的光线，所以应该在元素之间留有足够的空间或"气";
*   行的长度可以让文本区块对用户更具可读性并易于理解;
*   行间距的空间设计，以及文本行的长度问题都会对可读性具有很大的影响，在深色背景下尤甚，所以段落的大小，字距和行间距都需要仔细考虑。
*   深色并不总是意味着黑色，所以在每一个特定情况的设计中，去花费一些时间测试不同种类的深色背景和颜色所呈现的内容是十分合理的，在试验中尽情的尝试吧;
*   阴影，渐变和光晕都会影响可读性;
*   无衬线字体通常比较清晰，而衬线字体看起来更加优雅，在实践中应用这个因素可以增强内容的可读性。

### 对比度方面

[webdesign.about.com](http://webdesign.about.com/od/color/l/bl_contrast_table.htm) 用表格展现了一个有趣的视觉感知方面需要考虑的展现效果。该表展示了不同的颜色组合之间的对比和效果水平并提供了一个有趣的事实：表中的黑色部分是唯一一个可以为几乎所有颜色提供良好对比度效果的颜色。因此在设计界面的每一个特定情况下去仔细试验，这一因素可以作为尝试使用深色背景的理由之一。

![](http://ac-Myg6wSTV.clouddn.com/962624f37bb9c9a8b839.jpg)

在可读性方面，对比度能是使内容更容易识别和清晰的因素之一。

关于对比度和可读性的这种提示信息在之前的一个[早期的调查](http://www.writer2001.com/colwebcontrast.htm)中有说过：「_在深色背景下，确保你没有包含相当明亮的字体：使用柔和的白色到浅灰色字体，或使用单调的色彩来最小程度的减少巨大的反差和眩光；这个原则在做幻灯片时也同样适用：用至少 5% 的灰度来减少眩光的亮白。有趣的是，这样仍然在「阅览」时会被认为是白色的。同样的，将字体加粗，可以让字体有足够的大小让人不觉得文字被深色背景所「吞噬」_」这个试验以及其他试验能够提供不同类型的调色法，而这些调色法能够为网页和应用页面提供高效、自然的内容。

还有一件事就是深色背景在某种程度上通常显得更沉重以及能更深入的呈现图形的内容如图片，相片，插图，海报和广告。良好的构图并遵守视觉层级原则可以显著的增强这种布局元素的视觉感知。这个因素在当界面基于更多图形材料而非文本时会使深色背景更高效并且具有吸引力。

![](http://ac-Myg6wSTV.clouddn.com/ffb8689a5486125bdc5b.png)

<figcaption>[一款分析应用](https://dribbble.com/shots/2062865-Analytics-App)来自 [Ludmila Shevchenko](https://dribbble.com/LudmilaShevchenko)</figcaption>

### 情感感知方面

色彩心理学也是在选择背景颜色时需要考虑到的，这不仅只是包含在所展现的有效范围中，还包含内容自身所承担的信息载体。黑暗的颜色通常与优雅和神秘感有关。此外，黑色往往与优雅，礼节，声望和权利有关。这或许是为什么许多强大的品牌都会使用黑白色调的主题，用深色来主导、用亮色来展示承载的信息，使用这样的方案来构建视觉展现效果。界面设计在这方面可以为其他设计解决方案和一般的产品展示提供额外的支持。

![](http://ac-Myg6wSTV.clouddn.com/dd0719f001ef35d5600e.gif)

<figcaption>[Tubik Studio | 博物馆](https://dribbble.com/shots/2620649-Tubik-Studio-Museu) 来自 [Ernest Asanov](https://dribbble.com/ErnestAsanov)</figcaption>

### 深色背景的优势

根据上述各点，我们可以总结得到在用户界面应用深色背景可以提供以下实际好处，包括：

* 格调及优雅
* 神秘感
* 奢华显赫的外观
* 可以广范围的运用对比
* 支持视觉层次的展示
* 反映内容的深度
* 视觉吸引力。

![](http://ac-Myg6wSTV.clouddn.com/7947c9ab8ad7a9dd9128.png)

<figcaption>[Tubik Studio | Vinny 的面包店](https://dribbble.com/shots/2749617-Tubik-Studio-Vinny-s-Bakery) 来自 [Ernest Asanov](https://dribbble.com/ErnestAsanov)</figcaption>

### 考虑要点

在另一方面，深色背景需要彻底的关注和分析最微小的细节，如果它们没有以合适的方式呈现，那么这些细节则可能会在布局中变得模糊。因此我们应该考虑：

*   **用户研究** 实际调查，理论研究和试验数据是针对目标用户十分重要的数据资源，他们的需求是选择有效和有吸引力的设计方案的基础。
*   **竞争研究** 对关系密切的竞争对手进行市场研究，可以理解已经被市场上其他对手使用的设计方案，并且这一因素会影响到原始设计的选择从而使产品更加明显。
*   **用户测试** 深色背景在可读性和易读性方面是十分脆弱的，所以应当在各种类型的设备和分辨率下严格的去测试。
*   **环境因素** 去分析典型条件下将被用于目标用户的产品，可以为选择或反对深色背景提供其他的理由。
*   **大量的内容** 元素和块的数量需要在屏幕或网页上达到能影响周围背景的决策：深色的背景如果在元素间留下了太少的空间会为视觉造成极大的困难。
*   **内容的性质** 相比于大量的文本区块，深色背景可以为基于图形元素的界面提供更好的展示效果。

![](http://ac-Myg6wSTV.clouddn.com/695e0a55cb834721ce2b.gif)

<figcaption>[关于食谱和烹饪的 GIF 动画](https://dribbble.com/shots/2736160-GIF-Animation-for-Recipes-and-Cooking) 来自 [Sergey Valiukh](https://dribbble.com/SergeyValiukh)</figcaption>

### 推荐阅读

*   [**The Impact of Web Page Text-Background Color Combinations on Readability, Retention, Aesthetics, and Behavioral Intention**](http://lite.mst.edu/media/research/ctel/documents/LITE-2003-04.pdf)
*   [**Visual Perception: An Introduction**](https://books.google.com.ua/books?id=rvt4a_AmKFQC&pg=PA11&lpg=PA11&dq=visual+perception+readability&source=bl&ots=6_rkYdGkj9&sig=_UYthMOEgDSLJEFftDA895epms8&hl=ru&sa=X&ved=0ahUKEwjiwPjRmsPMAhVOKywKHf1FCSM4FBDoAQgtMAM#v=onepage&q=visual%20perception%20readability&f=false)
*   [**Art and Visual Perception: A Psychology of the Creative Eye**](https://books.google.com.ua/books?id=9RktoatXGQ0C&pg=PA350&lpg=PA350&dq=visual+perception+readability&source=bl&ots=NTLfJ_Akj6&sig=bpw4URR8U-QwWZwOndhoYs-wJWE&hl=ru&sa=X&ved=0ahUKEwjiwPjRmsPMAhVOKywKHf1FCSM4FBDoAQgZMAA#v=onepage&q=visual%20perception%20readability&f=false)
*   [**Colour Choices on Web Pages: Contrast vs Readability**](http://www.writer2001.com/colwebcontrast.htm)
*   [**The Dos and Don’ts of Dark Web Design**](http://www.webdesignerdepot.com/2009/08/the-dos-and-donts-of-dark-web-design/)
