> * 原文地址：[Create your first Ethereum dAPP with Web3 and Vue.JS (Part 1)](https://itnext.io/create-your-first-ethereum-dapp-with-web3-and-vue-js-c7221af1ed82)
> * 原文作者：[Alt Street](https://itnext.io/@Alt_Street?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/create-your-first-ethereum-dapp-with-web3-and-vue-js.md](https://github.com/xitu/gold-miner/blob/master/TODO/create-your-first-ethereum-dapp-with-web3-and-vue-js.md)
> * 译者：[foxxnuaa](https://github.com/foxxnuaa)
> * 校对者：[yankwan](https://github.com/yankwan),[FateZeros](https://github.com/FateZeros)

# 使用 Web3 和 Vue.js 来创建你的第一个以太坊 dAPP（第一部分）

欢迎来到另一个教程！在本教程中，我们将讨论如何使用 Ethereum、Web3js、VueJS 和 Vuex 创建一个简单的、响应式的去中心化应用程序。您可能需要对 javascript 和 web 应用程序有一些了解才能真正享受本教程。如果您不了解 Vue，不用担心，我们将在实现应用程序时简要地介绍一下基础知识。

我们的应用将会很简单。用户可以在 1 到 10 之间下注以太币。当用户猜对时，他得到了他的奖励 x10（略低于庄家切牌）。

第一部分，我们将讨论项目设置和智能合约的创建。第二部分，我们将介绍 web3js API 和 VueJS/Vuex，第三部分，我们将融会贯通并将应用程序连接到合约中。跟着一起，享受旅程，会很棒的。

我们的应用程序最终看起来像这样：

![](https://cdn-images-1.medium.com/max/800/1*sELED_FHGWla_S1QJQxzhA.png)

我们的最终应用程序。

* * *

### 前提条件

由于项目比较简单，我们不会使用 truffle。我们将在测试网络上使用 MetaMask 和 Remix([https://remix.ethereum.org](https://remix.ethereum.org))编写和部署智能合约。

我们需要做的第一件事是安装 nodeJS 和 NPM，在您的操作系统上按照步骤进行安装：[https://nodejs.org/en/](https://nodejs.org/en/)。在终端窗口运行如下命令检查 node 是否正确安装：

```
node -v
npm -v
```

接下来，如果您还没安装 metamask，则安装 metamask：[https://metamask.io/](https://metamask.io/)

我们最后一个条件是 vue-cli，它将帮助我们轻松设置 VueJS 项目：

```
npm i vue-cli -g
```

* * *

### 项目设置

我们将使用 remix 编写和部署智能合约，并通过 metamask 插件部署到 Ropsten 测试网络。在前端应用程序中，需要与合约交互的是合同地址和 _ABI_ （ _ABI_ 定义了如何在机器代码中访问数据结构或计算程序）。

我们的前端将是一个 vue-cli 生成的 vueJS 应用程序。我们也将使用 _web3_ 来与合约通信。遵循以下简单步骤，为客户端应用程序创建 backbone ：

1. 打开一个终端，并将目录更改为您想要创建应用程序的地方。
2. 在终端窗口输入以下命令来创建我们的项目，并输入“回车”来完成向导：

```
vue init webpack betting-dapp
```

3. 现在我们将进入我们的项目文件夹并安装 web3，vuex 和 font-awesome：

```
cd betting-dapp
npm i web3@^0.20.0 vuex font-awesome -s
//To start the dummy project generated by the vue-cli use 'npm start'
```

_*我们没有使用 web3 1.0.0 测试版，因为它在写入时与 MetaMask 不兼容。*_

* * *

### 编写智能合约

在我们毫无头绪地编码之前，我们必须首先分析我们需要的组件：

1. 我们需要知道合约的所有者并拥有访问权限（为简单起见，我们将不再修改所有者）
2. 合约的所有者可以销毁合约并提取余额
3. 用户可以在 1 - 10 之间下注
4. 在合约创建时，所有者能够设置最低下注金额和庄家上风（为简单起见，创建后不可更改）

**第一步和第二步**非常简单，我们已经添加了注释，这样就没问题了。 打开 [Remix]（http://remix.ethereum.org）开始工作（文章结尾处的要点链接）：

```
pragma solidity ^0.4.10;
contract Ownable {
 address owner;
 function Ownable() public {
//Set owner to who creates the contract
 owner = msg.sender;
 }
//Access modifier 
modifier Owned {
 require(msg.sender == owner);
 _;
 }
}
contract Mortal is Ownable {
//Our access modifier is present, only the contract creator can      use this function
  function kill() public Owned { 
 selfdestruct(owner);
 }
}
```

首先我们创建合约 Ownable，构造函数 _Ownable（）_将在创建时被调用，并将状态变量 'owner' 设置为创建者的地址。 我们还定义了一个访问控制，当我们附加的函数的调用者不是合约所有者时，它将抛出异常。

我们将此功能传递到 Mortal 合约中（Mortal 继承自 Ownabe ）。 它有一个函数，允许合约所有者（访问控制）销毁合约并将剩余资金发回给他。

你已经走到这一步了？你做的很好！我们的合约差不多准备好了。

现在我们在**步骤3和步骤4**将创建 Casino 合约:

首先我们需要 minBet 和 houseEdge，可以在创建合约时设置。通过将参数传递给构造函数 _Casino() 实现。我们将会使构造函数为 payable，这样我们就可以在部署时使用 Ether 预先加载合约。我们也会实现回退过程：

```
contract Casino is Mortal{
 uint minBet;
 uint houseEdge; //in %
//true+amount or false+0
event Won(bool _status, uint _amount);
function Casino(uint _minBet, uint _houseEdge) payable public {
 require(_minBet > 0);
 require(_houseEdge <= 100);
 minBet = _minBet;
 houseEdge = _houseEdge;
 }
 
function() public { //fallback
 revert();
 }
}
```

这还不够，所以接下来我们将添加函数用于下注一个数字。此函数将生成一个随机数（此方式不安全！），然后计算并发送赢得的奖励。在你的回退函数下面加上如下部分:

```
function bet(uint _number) payable public {
 require(_number > 0 && _number <= 10);
 require(msg.value >= minBet);
 uint winningNumber = block.number % 10 + 1;
 if (_number == winningNumber) {
   uint amountWon = msg.value * (100 — houseEdge)/10;
   if(!msg.sender.send(amountWon)) revert();
   Won(true, amountWon);
 } else {
   Won(false, 0);
 }
}
```

为了在 1 - 10 之间生成一个随机数，我们取当前区块编号，并取当前区块号的模量（除数余数）。这总是会产生 0-9 之间的一个数，所以我们加1，从而得到一个 1 - 10 之间的“随机”数字。

例如:如果我们在新的匿名窗口中使用 javascript VM 在 remix 上部署合约，并在部署后调用 bet 函数，我们将总是得到 2 作为中奖号码。这是因为第一个块是 #1。1 的模是 1，加 1 等于 2。

_** 请注意，这并不是真正随机的，因为很容易预测下一个区块号。更多地了解 solidity 的随机性，请查看_[_https:/ /www.youtube.com/watch?v=3wY5PRliphE_]_._(https://www.youtube.com/watch?v=3wY5PRliphE)

为了计算赢取的奖金，我们只需计算一个乘数：

```
bet * (100 — houseEdge)/10 
```

如果庄家上风为 0，我们的乘数是 10；如果庄家上风是 10%，则乘数是 9。

最后，我们将为所有者添加一个函数，以检查合约的余额，理想情况下，我们还希望为所有者添加一个提取函数，但我们现在就不做了。在你的 bet 函数下面添加以下几行:

```
function checkContractBalance() Owned public view returns(uint) {
 return this.balance;
 }
```

**伟大的工作!**合约现在已经准备好进行测试了!

* * *

### 在 remix 上测试我们的合约

在 remix 的右上角单击 run 选项卡。确保将环境设置为 _Javascript VM_。在 value 字段中输入 _20_ 并从下拉列表中选择 _Ether_ 而不是 _Wei_ 。这将在部署时使用 20 Eth 预加载合约。下面，在 create 按钮旁边输入我们的构造器参数 _minBet_ 和 _houseEdge_  (比如，10000 wei 和 10% 的庄家上风)。

做完它应该是这样的：

![](https://cdn-images-1.medium.com/max/800/1*yMcvHe8mAc6q15LRI18I9A.png)

在点击“创建”之前，它应该是这样的。

现在单击 create 按钮，合约实例应该出现在屏幕的右下角。将会有四个函数可见，点击 _getContractBalance()_ 检查一切是否正常，应该返回 _20000000000000000000_，这是我们发送的 20 ether 转换成 wei 得到的。你也会在右上角的账户旁边看到你的余额，现在将略低于80 ether。

![](https://cdn-images-1.medium.com/max/800/1*CGrKr3a02opXs6NUpj_JMg.png)

点击“创建”合约后，余额应该是 20*1e18 wei。

好了!一切运行正常。就像前面提到的，当使用 javascript VM 时，第一个块总是 1，所以第一个中奖号码总是 2。我们可以通过在 value 字段中输入 1 ether 来测试，并将 2 作为参数传递给 bet。

当点击 bet 时，我们应该看到余额再次增加，在控制台点击详情，并滚动到“日志”。我们应该看到一个我们已经赢了的事件:

![](https://cdn-images-1.medium.com/max/800/1*KKOA1FXEbTwYqxYUIosMqQ.png)

我们赢了 9 以太币！

好吧!我们的合约运行正常。在下一节中，我们将在 Ropsten 测试网络上部署我们的合约，并获取合约地址和 ABI ，以便在我们的客户端应用程序中使用。在那之前!

**阅读** [**PART 2**](https://medium.com/@Alt_Street/create-your-first-ethereum-dapp-with-web3-and-vue-js-part-2-52248a74d58a) **!**

如果您喜欢我们的教程，欢迎打赏，感谢您的阅读，如果您已经读到这里，请坚持下去！

ETH: 0x6d31cb338b5590adafec46462a1b095ebdc37d50

完整的合约代码: [https://gist.github.com/anonymous/6b06bef626928589e3a53a70c021ec02](https://gist.github.com/anonymous/6b06bef626928589e3a53a70c021ec02)


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
