> * 原文地址：[Buttons in Design Systems](https://medium.com/eightshapes-llc/buttons-in-design-systems-eac3acf7e23#.u8m3qun1i)
* 原文作者：[Nathan Curtis](https://medium.com/@nathanacurtis?source=post_header_lockup)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[Funtrip](https://www.behance.net/Funtrip)
* 校对者：[yifili09](https://github.com/yifili09)、[skyar2009](https://github.com/skyar2009)

# 视觉系统中的按钮 #

## 建立一个长远的视觉系统的12点建议 ##

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/2000/1*CzIsMRDmO6EadfN0cb85GA.png">

我爱按钮们。我可以用按钮**做**很多事：进行下一步，做出决定，或者完成事务。有了按钮，交互变得焕发生机。

这就是为什么**按钮**们是一个设计系统里最重要的组成部分。非常简单，它们在指定的区域提供可以点击的简单标签。因此，按钮是你应用一种设计语言的基本特征的重要方式，之后你可以把特征扩展到其他更复杂的部分上。

这篇文章讲的是我在一个新生系统中着手设计主要按钮、次要按钮、以及一大堆其他类型按钮的时候所学习到的 **12** 条经验。

### 主要按钮 ###

#### #1. 设定一个系统的风格基调 ####

一个按钮就像是系统视觉风格中最纯粹的原子表达（译者注：原子是化学反应中不可分割的最小微粒）。它结合了三大属性——**颜色**、**字体**以及**图像**——这些成为了一个原子中不可分割的部分。按钮也引发了对**空间**的讨论：内部填充（特别是标签的左、右）和边距（与其他元素相邻）。最后，按钮甚至可以表达更深层次的东西，比如圆角（通过**边缘半径**），比如提升效果（通过**边框阴影**）。

**要点**：你应该赞同按钮是一个系统风格的首要展现。如果你把按钮的定义与颜色、大小、空间或其他细节等[新的变量](https://medium.com/salesforce-ux/living-design-system-3ab1f2280ef7)联系起来，那将会是很好的加分项。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*PyWEYZhKikVzaC8KwAbN-A.png">

按钮这样一个简单的元素包含了范围广泛的属性。

#### #2. 设定一个语言基调 ####

幸运的是，「点击这里」的讲法已经是过去式了。但我们仍然需要回答：一个按钮上的标签可以有多长？标签是用祈使句写的吗（比如「保存」或「关闭」）？我应该用一个对象（「文档」）来匹配一个动词（「保存」）吗？这些常用的标签有一些默认的用处么？ 我们是否需要引入品牌声音？

**要点**：我发现按钮的价值是通过标签的引导来推动一个一致性的声音。当然，单词表和深层次的文案标准可以在具体的文档中找到，比如说语言和语调的指南。但无论如何，要把各种指引桥接在一起，按钮是一个绝佳的元素。

![](https://cdn-images-1.medium.com/max/800/1*hqrRbtUd5v_HPeGqf_Ke3Q.png) 

#### #3. 在背景变得复杂时使用反转色 ####

大部分按钮在白色的背景上都可以正常工作。但是当你把按钮放到一张照片上又会发生什么呢？或者深色的背景上呢？诶，它甚至可能被放到一个浅色的中性颜色上？你的按钮可以被用到任何地方吗？你可以**更改**主要按钮的颜色吗？

**要点**：请在一个清晰可见的背景上展示你的按钮，并且设定一个反转色备用——白色？一个完全不同的颜色？或是半透明？——在背景灰暗时使用。当在编排文档时，在一系列有普遍性的背景上展示备用的亮色或暗色来把标准搞清楚。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*FeIWlJu-OZ8qUEsM-FsMUg.png">

在不同的背景上展示按钮，看看它们看起来是不是都好

#### #4. 限制每页只有一个按钮，除非要重复主要操作 ####

按钮可以引起动作。我们经常用一个主要的按钮，把用户的注意力吸引到页面里高优先级的操作上。但是，如果有一大堆按钮散落在页面上，我们就无法区分出它们的优先级的先后了。（[除非它们都是一样的](http://bradfrost.com/blog/post/conducting-an-interface-inventory/)，对吧？）

在某些情况下，使用一个主按钮是恰当的，比如当你必须从一大堆平行的对象中做选择，或是一个设置页面有相似的模块化的区域，布满了指向不同类别的选项。

**要点**：明确什么时候使用，和什么时候应该避免——在一个页面上使用超过一个的主要按钮。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*o2H9eO-00poReXitGm-hAQ.png">


#### #5. 设计并建立一个按钮的交互特征 ####

按钮是最原始的交互，并随着交互变化。只展示按钮在页面加载时的样子，并告诉开发者「这就是按钮的设计！」显然是不够好的。相反，应该由设计师来展示一个按钮在许多不同的状态下应该出现的样式：默认、悬停、焦点状态（「一圈光环」），按下/活动中，甚至一个旋转的加载动画。

**要点**：在资料中附上一个动画展示（把按钮放到页面里！），它可以展示按钮的各种状态而不需要阅读者亲自来互动。阅读文档不是一个寻宝游戏。像 Material Design 的指南那样做一个演示视频将会很加分。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*t9OuRA0hVzMw7uItFsqEAQ.png">


#### #6. 让多元素更具有灵动性 ####

将按钮上的文字与 icon 配对可以让用户更快地识别和更易理解。

但是等等！我认为按钮应该处于可被预见的可点击区域内。当你添加了一个新元素，即使是一个简单的 icon，按钮的布局都不应该被破坏。要应对不可预见的元素揭示了间距和内部对齐等讨厌的问题。你会想要让他们的布局更加平缓，特别是按钮包括了标签、icon **和**其他部件的时候。

**要点**：让你的按钮对代码或设计工具可响应。用户们将要添加东西的——icon、标签、或者其他任何东西——但别担心间距和排列会被破坏。做好了前面的工作你就可以让它们正确地显示了。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*5dXoAkQukuKhKVL87pTJlw.png">

### 次要按钮 ###

#### #7. 次要 ≠ 不可用 ####

没有谁希望看到灰色的按钮

但你可能发现你需要为那个吸引人的、高饱和度的主要按钮匹配一个次要按钮。你避免了使用第二个高饱和度的颜色，因为这会导致两个高饱和度的按钮彼此相邻，就像绿色表示**保存**，蓝色表示**提交**。不说用户，就连你自己也不知道哪个按钮更重要。

所以，你可能会选择使用中性颜色。中性颜色看起来接近或完全是灰色。并且它看上去像是表达不可用。更糟糕的是，当主要按钮不可用的时候它也会变成灰色。并且就在你灰色的次要按钮旁边。哎。:-(

**要点**：同时处理次级按钮的颜色和不可用按钮的颜色。确保所有选项在一起时都可以正常工作并且都容易可见。

![](https://cdn-images-1.medium.com/max/800/1*E101zYa4_NxchGVfpKgypg.png) 

哪一个才是不可用的？

#### #8. 当心机器里的「幽灵」 ####

「幽灵按钮」通常只依赖于相同颜色的边框和标签，而缺乏填充背景色。这样的标签背后的区域是不确定的。有时候标签在白色上（是的，那很容易被看清！）。然而，在其他时候一个纯色或者细节丰富的照片都可以让标签变得很难阅读。

「幽灵」让设计师在设计高对比度的主要按钮时想要偷懒。然而，把他们称为「**幽灵**」是有原因的。因为很多时候它们会无法被看见。我观察了「幽灵按钮」被难以查看的图片覆盖的情况下的可见性测试。参与者看不清它们或很难阅读它们。这将会削弱或破坏我们原本打算让这个按钮实现的交互的价值。

**要点**：在一个系统中使用「幽灵按钮」是将你自己的设计置于为危险中。我观察到的情况表明「幽灵按钮」的表现比填充色还要差。此外，你可能只是想避免花费几个小时来倾听关于这个问题的极端设计师辩论。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*bKSO70RdMp2OUoVrrLXs2Q.png">

幽灵按钮——即使在简单的情况下——表现也是有问题的。你想要在不可预测的背景上使用它？忘掉这回事吧。

### 其他按钮类型 ###

很快，系统的用户们就需要你提供**那些**其他的按钮。大一点或者小一点的按钮。带有菜单或工具栏可切换的按钮。这取决于你的系统是否足够完整。

#### #9. 可变尺寸，大（或者超大/巨大/扩展）&小（或者微小/极小） ####

交互可以在重要的地方比如**卡片**元素或侧边栏模块中找到。有时，你需要在一个全屏的图片上放上一个巨大的按钮来引起用户关注。

**要点**：在有必要的时候调整按钮的尺寸大小，尽可能像其他的 CSS 类或者设计软件的风格一样简洁。此外，考虑一个更难忘的名字——比如「扩展」或「微小」——而不是一个平淡的「大」或「小」

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*xxExyXQ3M1TXwwK__d4fMw.png">

#### #10. 区分按钮与链接 ####

在扁平化设计的时代，像 [Material Design 这样的视觉系统](https://www.google.com/design/spec/components/buttons.html#buttons-flat-buttons)使用了多种「扁平」按钮，来用在工具栏、对话框操作和行内文本渣。在默认状态下，按钮和链接几乎没有视觉差异。然而，一个按钮的状态和行为，与简单的锚标签相比，会带来完全不同的效果。

**要点**：如果你的系统使用了扁平化的版本，应该确保它的常规使用——在设计和代码中——都有别于链接。此外，这条准则应该涵盖所有复杂交互。例如**焦点**和**被按下**的状态，**间距**和**对齐方式**。

![](https://cdn-images-1.medium.com/max/800/1*0MCgCs3CpqhuQ9S_pQIalA.png) 

#### #11. 使用菜单和区块丰富按钮的多样性 ####

可变的按钮可以触发相关的菜单选项来进行选择。许多系统在 UI 位置紧张时提供了复合式的选项，就像**菜单**（或**下拉菜单**）和**分割**（或**分段式**）按钮。

一个菜单按钮可以指示当前的选项（例如已经选择了 Arial 作为字体）或者打开一个独立选项（例如分享或打印）。在右侧添加一个小箭头的图标，你还可以得到一个额外的独立区域来布局一个菜单，同时左侧的区域可以触发一个独立的主要操作。

**要点**：你可以用菜单式的按钮来丰富你的 App 的选项，但需要谨慎。这样的按钮和它们的区域分割（左侧主要操作，右侧菜单）可以支持许多种情况，但这也带来了更高的开发成本和学习成本。对设计更简洁的网站来说，不要用这些不常用的替代方案来破坏了原有的架构。

<img class="progressiveMedia-noscript js-progressiveMedia-inner" src="https://cdn-images-1.medium.com/max/800/1*QvaEyZSTLHnBMqx4E89n9g.png">


#### #12. 从开关到工具栏，让按钮们工作地更和谐 ####

按钮可以成组使用。一个**按钮组**常常搭配一个主要选项和一个或多个次要选项。一个**开关按钮**常常用来表示开关（比如粗体）或者显示一个设置菜单的选项（就像文本对齐选项的左对齐、右对齐、居中或两端对齐）。在它们最广泛的用法中，一个工具栏可以把许多不同类型的按钮搭配在一起：主要的、次要的、开关、菜单、部件。

**要点**：当你在拓展按钮的种类时，你应该试着让按钮们在一个紧张的空间内做一个压力测试，并且尝试多种不同的组合。视觉系统的设计师们不是算命先生，没有办法预测未来。但是探索一个不同情形下的合理状态，可以帮助你避免厌恶情绪或一条道走到黑。


### 对于按钮，就使用 <button> ###

有一个很好的关于学习按钮代码的宝库。这篇 CSS 技巧的文章[什么时候使用按钮元素](https://css-tricks.com/use-button-element/)（和关于它的活跃的讨论）是一个很好的开始。

![Markdown](http://p1.bqimg.com/1949/40f4997a20dea3f2.png)

 **要点**：学习代码原型来了解常规的按钮和可行性。你可以认真阅读 Alex Lande 的 [Anchors, Buttons, and Accessibility](http://formidable.com/blog/2014/05/08/anchors-buttons-and-accessibility/) 和 CSSKarma 的 [Meet the Polybutton, An Accessibility Polyfill](http://csskarma.com/blog/polybutton/)  ，通过这样的文章，你将可以慢慢得到进步。

想要开始着手视觉系统的设计，或者需要深入讨论产品和用户？ EightShapes 会进行系统的[专题研讨会](http://eightshapes.com/workshop-planning-parts-products-people.html)并且在[视觉系统设计](http://eightshapes.com/design-systems.html)上指导客户。[让我们聊一聊吧？](https://twitter.com/nathanacurtis)
