> * 原文地址：[Bootstrap considered harmful](https://hiddedevries.nl/en/blog/2016-08-09-bootstrap-considered-harmful)
* 原文作者：[Hidde de Vries](https://hiddedevries.nl/en/about-me/)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者： [MAYDAY1993](https://github.com/MAYDAY1993)
* 校对者： [Kulbear](https://github.com/Kulbear)  [hpoenixf](https://github.com/hpoenixf) 

# 你考虑清楚了吗就决定用 Bootstrap ？

近年来，在前端项目中， Bootstrap 已经成为了一个非常受欢迎的工具。 Bootstrap 的确有很多优点，然而，如果你的团队中恰好有一个专职的前端工程师。那我推荐你们不要使用 Bootstrap ，因为在某些情况下， Bootstrap 弊大于利。

## Bootstrap 对什么有好处

 Bootstrap 带有栅格系统，也有针对很多组件的样式和脚本，包括表格，导航栏，进度条，分页，表单样式，模态框和提示框。在这篇文章中，谈论 ‘Bootstrap’，我的意思是包含所有组件的实践（与只选择包括一部分相反，例如， _只是_栅格）。
对于需要把项目输出成标记语言，并且不想操心将结果样式化的后端开发工程师来讲， Bootstrap 是一个好的工具。如果因为某些原因，比如预算或其他因素，在一个团队里没有前端开发者或设计师， Bootstrap 适合用来填坑。

对于设计师来讲， Bootstrap 也有一席之地：它是一个很有价值的工具，用来从设计软件快速移动到浏览器，而不需要过度担心前端代码策略。
甚至对于主要和数据打交道很少关注 UI 和布局的前端开发者，让一个开发者关注于搭建应用本身， Bootstrap 在这一方面也很好。

## 什么时候你最好别用它

然而，如果你的团队里有一个前端开发工程师，使用 Bootstrap 会潜在地浪费他们宝贵的时间，并且将他们的注意力从解决实际的问题转移。 Bootstrap 恰恰做的是前端开发者擅长的，但是它以一种很普遍的方式来实现。你的网站或应用是很具体的，所以如果你用一个普遍的系统，它有可能不会起作用。这意味着你的代码将包含全部的可能性才有可能实现具体的需求。
### 当你需要很多代码来覆盖 Bootstrap 的样式
 Bootstrap 是由 Twitter 的开发者开发来系统化他们网站应用的样式。当你的网站应用的样式和他们不一样，这意味着你不得不覆盖掉他们的样式来。
大多数网站的样式并不像 Twitter 那样。因此，如果他们安装 Bootstrap ，他们会覆盖掉很多样式。
在一些我参与的网站中，我发现多达十分之九的 Bootstrap 样式会被网站自己的样式覆盖掉。很坦率的讲，这是荒谬的。
### 当它让简单的事情复杂化
 CSS 用来为网页增加一系列简单的在某些条件下会被代码覆盖的样式规则。当你的网站中有 Bootstrap 的样式，几乎网站内所有的东西都已经被一系列复杂的代码规则设置好了。任何例外都会超出这个框架所设置好的规则。而大多数网站所面临的问题正是它们的样式对于 Bootstrap 来说往往是例外。
 Bootstrap 的样式是复杂的：你会有一个带有 12 列的栅格系统，这 12 列能以你想要的任何方式组合使用，有特殊的类来基于用户的视图尺寸设置不同的偏移量和列结构。很多网站是简单的：在小屏幕上没有列，在更大的屏幕会有一到两列。
### 当它产生了技术债务
一个前端代码库依赖 Bootstrap 的时间越长，纠缠的越多，并且它包含了更多只是用来覆盖掉 Bootstrap 代码的规则。这常常导致代码库陷于巨大的技术债务，尤其当前端代码以经常需要手动更新的方式整合在后端的时候。
### 当它引入可能不是你的应用的命名习惯
命名很难，而且想出有意义的属于你的团队和应用的命名习惯很花时间。对于组件名使用合适的名词，不要和一些名词的缩写像 ’btn’ 的类名混淆。
## 结论
在开发网站的过程中 Bootstrap 和朋友在各种各样的阶段是有好处的。然而它们不是一个能使任何事都简单的魔法：相反，会有很多能够通过让前端开发者关注于亲自开发 UI 来避免的缺点。
