>* 原文链接 : [How To Attract Millions of Developers to Your Product](http://www.techstars.com/content/accelerators/boulder/attract-millions-developers-product/)
* 原文作者 : [Mitch Wainer](http://www.techstars.com/content/author/mitch-wainer/)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : 
* 校对者:


<span>According to Evans Data, there will be</span> [**over 25 million software developers by 2020**](http://www.evansdata.com/reports/viewRelease.php?reportID=9)<span>. It’s become one of the hottest markets in tech as well as</span> [**the fastest growing professional segment in the world**](http://www.economicmodeling.com/2012/12/06/careerbuilder-and-emsi-release-top-jobs-for-2013/)<span>. Leading B2D companies such as GitHub, Stripe, Twilio and DigitalOcean have been able to attract millions of developers to their platforms through organic efforts.</span>

<span>Why organic? Developers are savvy consumers and they’re typically turned off by traditional online advertising efforts. As an example, we ran a test in Google Analytics and discovered that</span> **over 30% of our website visitors had ad-blockers turned on.** <span>This piece of data tells us that a large percentage of our audience blocks display and retargeting ads when they browse the internet. Holistically, the world of modern marketing has evolved and</span> **relationship marketing** <span>has become the best way to drive long-term sustainable growth. Instead of focusing on short-term metrics and targets, build long-term relationship marketing programs that enhance the entire customer lifecycle experience and provide value to the end user at the top, middle, and bottom of the funnel. Here are a few key strategies to attract developers to your product:</span>

**Be honest, clear and concise with your messaging.** <span>Honesty and authenticity go a long way with the developer community. Keep your website informative and truthful and the developers who read them will have a far better impression of your business. Simplify overly-technical descriptions into clear and absorbable messaging, that becomes the winning formula to drive engagement.</span>

<span>When writing copy and messaging, try to stick to these guidelines:</span>

– Be clear, concise, and direct

<span>– Do not try to oversell developers</span>

<span>– Avoid hyperbole to describe your business</span>

<span>– Avoid boasting (e.g. we’re #1 or we’re better than XYZ company)</span>

<span>– Speak the same language, developers want to talk to developers</span>

<span>– Don’t over-message and bombard customers with emails</span>

**Give it away for free.** <span>This is a great strategy to feed your top of the funnel.</span> <span>Developers aren’t willing to pay up front because migrating, integrating, or customizing a product to fit their code is a time commitment. You have to show it’s worth their time.</span> <span>Incentivizing them with promotional credits via meetups, events, social, paid channels, or email can be effective way to get them to try your product.</span>

**Accelerate word of mouth growth through an internal referral program**<span>. Focus on the customers that love your brand and give them tools and rewards for spreading that love. You can identify customer advocates by tracking your</span> [**Net Promoter Score (NPS)**](http://tomtunguz.com/nps-benchmarks/) <span>across all cohorts. Based on our above-average NPS rating (69) and understanding that the large majority of new signups were coming through direct and word of mouth channels, we knew that there was a tremendous opportunity to harness and complement our organic momentum with an internal referral program. When we were creating the program, we’d jumped on the phone with the growth teams from the best of breed companies, Dropbox and Airbnb, to ask what worked best for their referral programs. Our teams spent a lot of time on iterating to create a desirable incentive for our customers and we landed on a</span> [**double-sided program**](https://www.digitalocean.com/referral-program/) <span>that grants account credits to both the referrer ($25) and the referral ($10). So for us, it’s been very successful and it has become one of our largest channels for driving growth.</span>

**Earned media can spark viral awareness.** <span>We leveraged relationship marketing tactics early on to acquire our first 2,000 customers. But it wasn’t until January 15th, 2013, when we released our all-SSD cloud server plans that catapulted our business. Fortunately, on launch day we were able to secure</span> [**our first TechCrunch exclusive**](http://techcrunch.com/2013/01/15/techstars-graduate-digitalocean-switches-to-ssd-for-its-5-per-month-vps-to-take-on-linode-and-rackspace/) <span>that catapulted our daily signups overnight (see graph below). Within a month we went viral again on Hacker News when one of our customers</span> [**benchmarked our performance**](http://jasonormand.com/2013/02/08/linode-vs-digitalocean-performance-benchmarks/) <span>and wrote about it on his blog. Each earned media event created a new level of sustainable growth for our business and “The Hacker News Effect” was by far the most impactful.</span>

![](http://ww2.sinaimg.cn/large/a490147fgw1f2sr134jt5j20k005emxv.jpg)

**Create authentic conversations on Twitter, Q&A sites, forums, and blogs.** <span>We used the</span> [**search.twitter.com**](https://twitter.com/search-home) <span>tool to find and join conversations to help developers with their server problems and/or give credits to try our product. This was an effective relationship building strategy that built brand trust and credibility which sparked early momentum from a small group of users. Additionally, we were able to successfully build new relationships and partnerships with a few key influencers early on and through their personal brand and communities, they were able to recommend us and drive several hundred users to our platform.</span>

**Invest in creating content that solves a problem**<span>. Developers at various skill levels defer to Google to help solve their problems when they’re building their stack. A key component to building an effective inbound growth engine to develop high-quality content that educates your target audience. We have an amazing team of technical writers and editors that have published over 1,300 server config tutorials to date. These tutorials drive over</span> **3.7M unique monthly visitors** <span>to our website and we’re able to leverage this awareness to drive engagement to our product.</span>

**Get to know your early adopters on a personal level.** <span>Go above and beyond for your customers, grant them large credits, surprise them with swag/personal thank you letters, talk to them on the phone, take them out for coffee or lunch. Ask them about their challenges, why they signed up for your product, what events do they attend and which websites do they visits. This will help craft your go to market strategy to attract your next thousand users or customers. Your early adopters will become your brand’s voice. Without our loyal early adopters, DigitalOcean wouldn’t have a brand voice when our product went viral in the Hacker News community. There would have been no one to vet and represent us in those conversations and we wouldn’t be where we are today without the voice of our early adopters.</span>

<span>But before you ask the question, “How do I acquire more developers as customers?,” you need to understand if developers love using your product. Because once they do, your product can go viral almost instantaneously through the socially active online developer communities (e.g. Hacker News, Reddit, Stackoverflow, etc).</span> **Bottom line: marketing is the fuel to the product’s fire and is very rarely the fire.** <span>Once you’ve built a product that developers love, you can harness that momentum to drive growth by building an organic flywheel effect using these strategies.</span>

