
  > * 原文地址：[Can AI Solve Your UX Design Problems?](https://www.sitepoint.com/artificial-intelligence-in-ux-design/)
  > * 原文作者：[Mukund Krishna](https://www.sitepoint.com/author/mukund-krishna/)
  > * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
  > * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/artificial-intelligence-in-ux-design.md](https://github.com/xitu/gold-miner/blob/master/TODO/artificial-intelligence-in-ux-design.md)
  > * 译者：[Changkun Ou](https://github.com/changkun/)
  > * 校对者：[Tina92](https://github.com/Tina92)、[shawnchenxmu](https://github.com/shawnchenxmu)

# AI 能解决你的 UX 设计问题吗？

  ![AI Powered UX](https://dab1nmslvvntp.cloudfront.net/wp-content/uploads/2017/07/1501567920icDqSo2.jpg)

马克·扎克伯格在 2016 年的重要新年决定之一就是建立属于自己的「[简单 AI 机器人](http://www.vanityfair.com/news/2016/12/mark-zuckerberg-spent-100-hours-building-his-own-robot-butler)」，来帮助他解决家务。还记得钢铁侠的管家 Jarvis 吗？这就是一个关于AI如何发挥作用的好莱坞经典范例。

那么，人工智能（artificial intelligence, AI）究竟是什么？它又如何能解决当今最常见的UX问题呢

![Tony Stark using Jarvis](https://dab1nmslvvntp.cloudfront.net/wp-content/uploads/2017/07/150156788652646.jpg)
Tony Stark 在使用 Jarvis。

人工智能（或者说 AI）是一种先进的类人计算机系统，能够聪明的管理通常需要人类手动执行的活动和系统。当苹果的 Siri 和亚马逊的 Echo 这样的机器人还在处理我们最平凡的任务时，像 Google 的 **Deep Dream** 这样的机器人天生就具有创造性，并能帮助用户解决问题，从而改善他们的体验。

AI 正在多个实时场景中得到应用：

- **处理数据爆炸**：随着智能手机和移动设备的出现，数据正爆炸式增长。随着数据量的增长，有一个 AI 系统来分析、处理、组织和解释数据。
- **辨别我们的意图**：Netflix 可以从你的行为中预测什么样的电视节目或电影将让你待在沙发上。想象一下，你的 AI 系统可以调整汽车的温度，在你从车库出来时自动把灯关掉。
- **改善客户体验**：AI 可深入挖掘人眼可能错过的细节，从而帮助你专注于正确的数据。 比如，[RightClick.io](https://rightclick.io/#/) 是一个聊天机器人，可以让你通过与其对话来创建网站。即使你试着对其用不相关的问题转移话题，这个 AI 设备还是会引导你返回网站创建的实际工作中去。

![RightClick.io](https://dab1nmslvvntp.cloudfront.net/wp-content/uploads/2017/07/15015679069ApLLkv.jpg)
RightClick.io

人工智能正在改变我们创造用户体验的方式。 虽然**终结者**的电影给了我们一个 AI 的反乌托邦的想法，但现实是完全不同的。AI 是一种强大的技术，可以积极地影响消费者行为，并使企业能够提供出色的用户体验。

## 理解 AI 在 UX 中的作用

首先，让我们来看看如今现实生活中一些 AI 如何影响 UX 的场景。 能够感知上下文的聊天机器人可以通过提供一些及时的建议或解决方法从而取悦你的客户。导航应用程序可以毫不费力地将你引导到目的地。简单点几下，你就可以在家门口收到你最喜爱的餐点。

### 这是怎么工作的？

开发 AI 的想法来自科幻小说，这些小说描述了可以说话、思考或感受的机器。AI 是多种新兴技术的组合，比如：机器学习、深度学习、聊天机器人、增强现实、虚拟现实和机器人等等。

AI 涵盖了将智能注入到机器或设备的任何事情，使它们能模仿人类独特的推理能力。 所有这些，都可以通过使用能够发现人类行为模式、并从设备接收和存储的数据产生见解的算法来实现。应该细心的编写启用人工智能的设备或者机器，以便它们能在将来的决策中起到帮助。

这一切可能听起来很简单，但这些交互都是由快速增长的 AI 技术提供的。事实上，当涉及人性化客户体验时，AI 将成为 UX 设计师套件中不可或缺的工具。然而，除了构建类似人类的对话和行动之外，AI 还能在数字领域中大显身手，创造出优秀的 UX。

## 1. 一个面向协助的平台

AI 正在伴随着机器人走向主流，而机器人则通过认知智能的力量培育出了像人一样的互动。然而，机器人不能完全取代人类。相反，AI 在 UX 的领域起到了卓有成效的协助作用。

例如，[TheGrid.io](https://thegrid.io/) 是一个算法驱动的设计平台，可让您构建高度令人印象深刻和优化的网站。该平台是围绕连续 A/B 测试和细化布局的概念构建的。设计师可以筛选由这些 AI 驱动的工具提供的多个选项，并选择适合它们的功能。

![TheGrid.io](https://dab1nmslvvntp.cloudfront.net/wp-content/uploads/2017/07/1501567868cAk9mgD-e1501568470475.jpg)

像任何好的助手一样，它通常在提供的新选项中做出最好的决定，而不是作出关键的决定。当设计师有一个智能平台帮助他们选择一个模板并通过应用算法来验证模板时，它可以帮助他们做出更多的创造性决策。

## 2. 用 AI 制定旅程

像 [ReFUEL4](https://www.refuel4.com/) 这样的公司利用预测分析的力量来了解用户的线上行为，并根据他们的行为对其进行进一步的细化。最强大的 UX 是一个了解甚至能预测用户兴趣和行动的 UX。

![Refuel4](https://dab1nmslvvntp.cloudfront.net/wp-content/uploads/2017/07/1501567882ezgif.com-optimize-34.gif)

一旦设计师能够制定用户的行程，那么他就可以理解用户在交互过程中所期望路径。AI 驱动的行程制定可让你创建简单、有吸引力和有利可图的用户界面。

## 3. 接管重复、低价值的创造性任务

在多设备世界里，设计师经常必须提出许多图形和各种各样的内容，以满足各种形式的活动。 这可能很麻烦，要花很多时间。

![Netflix layout generation.](https://dab1nmslvvntp.cloudfront.net/wp-content/uploads/2017/07/150156789352650.jpg)
Netflix 的布局生成。

这就是像 Netflix 这样的平台将这些繁琐的任务交给算法的原因。人类设计师可以绘制布局应如何工作的「规则」，然后为系统提供一个原始图形元素库来处理它们。Netflix 的系统能够将规则与图像素材相结合，以创建原始电影海报和横幅单元。

当 AI 处理这些任务时，设计人员可以更多地关注理解用户之旅并完善这些规则。 这与高级设计师正在指导一支初级设计师团队没什么不同的，双赢。

像机器学习这样的 AI 技术可以使数字营销人员进行细粒度定位。例如，IBM 的 Watson 促进心理用户细分，使营销人员能够在正确的时间向正确的受众提供正确的内容。

### Watson AI 的工作原理：

为了发现统计学上相关的短语，Watson 将问题分解成不同的关键字或「句子片段」。它不仅为此操作创建了一种新算法，而且同时执行了数百种分析算法。

如果越多的算法独立出现相同的答案，那么 Watson 就越有可能是正确的。一旦 Watson 获得了多个解决方案，它将验证数据库的潜在解决方法，从而确定其中的任何一个是否有意义。

## 你会怎样塑造 AI 来获得更好的 UX ？

AI 系统能够快速分析大量数据，并实时学习和调整其行为。 AI 系统可以从上下文中推断，你则需要给它们提供额外的关于业务规则、问题、元数据和类似的类似的其他条件的信息。

当你通过每个设计阶段建立良好的用户体验时，你可以不断完善您询问 AI 系统的问题。这将改变分析数据的方式。

例如，如果您正在管理健康保险网站，可以问如下问题：

- 40 至 60岁之间有多少人使用你的应用程序？
- 有多少准妈妈访问系统？

系统会收到你的问题，分析数据并学习给出最佳答案。每当你提供新的数据或标准时，系统会使用人工智能来改善自身的用户体验。

## 塑造 AI 的艺术：

- 你可以向你的 AI 系统询问从一般到特殊问题。系统则处理问题、拿到数据再自我学习。
- AI 可以分析搜索引擎上的所有查询，收集更多的用户分析结果、识别趋势，并生成更丰富的结果。
- 使用数据优化搜索结果的质量：AI 可以预测搜索条件、提供建议、跨主题推荐（类似于 Amazon 提供的），从而给出更多相关的内容。
- 最重要的是，AI 能学习到目前为止所有访问过你应用的用户，并为你的用户提供了所需的内容。这产生了更丰富的用户体验。
- 具有 AI 的信息架构：AI 分析你的内部和外部数据，并帮助你构建内容管理系统的信息结构和最终用户的导航结构。

用户体验不一定是利用对数据的见解，它也是关于智能的。人工智能通过向不同数据源注入智能，从而连接了各类独立的节点。

虽然像机器学习、聊天机器人、VR、机器人、AR 等系统的 AI 技术正呈增长势头，但增长似乎是渐进的。 AI 与 UX 结合成为未来技术的标志。将 AI 与 UX 合并是一个公式，一个将引领我们增强内容的可查找性和可获取性的公式。

---

  > [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
