
  > * 原文地址：[Are Notifications A Dark Pattern?](https://blog.prototypr.io/are-notifications-a-dark-pattern-2c1a177b26e0)
  > * 原文作者：[Designlab](https://blog.prototypr.io/@trydesignlab)
  > * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
  > * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/are-notifications-a-dark-pattern.md](https://github.com/xitu/gold-miner/blob/master/TODO/are-notifications-a-dark-pattern.md)
  > * 译者：[Changkun Ou](https://github.com/changkun)
  > * 校对者：[lsvih](https://github.com/lsvih), [Yuuoniy](https://github.com/Yuuoniy)

# 通知是一种「暗模式」吗？

  ![](https://cdn-images-1.medium.com/max/2000/0*_tmPbpsam2ERhTWd.png)

文字 & 插图: Andrew Wilshere

 **你有没有做过这种噩梦：在梦中你被通知标记的小红点给淹没了？** 我就做过一次，它让我想到：通知究竟是什么？他们只是一种暗模式（dark pattern）吗？一种强制的、在线欺骗的形式吗？在这篇文章中，我将探讨「伪通知」的现象，并就未来对通知作为设计模式发表一些想法。

---

### 通知是什么？

**通知屡见不鲜。**门铃是能让我们知道有人在家门外的通知系统。电话铃声则是有人正在等待和你对话的讯号；而短信铃声通知我收到了新的消息。

然而，随着智能手机的到来，通知的作用已经发生了不易察觉的改变。首先，最重要的是，现在我们每天使用的 App 和网站都喜欢通知我们一切他们能通知的。我们的手机不仅仅只提醒我们打电话和发短信；它们还提醒我们和游戏有关的活动，告诉我们关注的人什么时候发了 Twitter，并且「叮嘱」我们的 10,000 个待办事项。与门铃不同，今天的 App 和网站认为值得通知的东西通常不需要我们立即处理。

其次，现在通知的方式越来越多，不论手段，不管情景，通知总能够传达到我们手中。无论是一个未读消息的统计数、手机屏幕顶部的文字滚动条、特殊的铃声，还是无声的语音助手，通知都在逐渐渗透我们的感官，打断我们正在做的事情。分心不是通知的不利副作用，相反，正是它核心功能之一。通知旨在让我们远离我们当前的活动，并将注意力集中在通知从何处来。

通知是 UX 设计师和开发人员的强大工具，因为它们巧妙的利用的人们的心理防线。通知引诱着人类内心深处渴望融入社会、被社会接受的本能，一个个小红点中的数字巧妙地告诉我们，在这个 App 中正有着一些社会事务在等待我们的关注，而选择忽略它，我们就错过了一些事情。现在，估计所有人都有过这样的体验：仅仅是看到一个未读数字，即使我们已经知道自己对它其中的内容并不感兴趣，但就是抑制不住去点开它的冲动。

**曾今的通知提醒我们需要知道的事情。**但是，现在公司的铤而走险是否让他们把产品变成了一种令人烦恼的、一种受操控的、具有破坏性的「暗模式」了呢?

---

### 通知即暗模式

**「暗模式」是指任何意图欺骗、操纵甚至欺诈用户采取他们不希望或打算的动作而设计的功能。** 这些最早出现在互联网萌芽时期，当一些神奇的网站在你的浏览器中弹窗时，在许多情况下会通过邀请他们点击来「诱导并转换」用户，然后重定向到一些无关的东西上去。

[这个关于暗模式的网站](http://darkpatterns.org/)罗列了相当全面的暗模式类别，它们保留了一个「耻辱柱」，用来指出那些故意欺骗用户的公司和产品。

如今，暗模式变得更广泛和更复杂。许多网站使用基本无害的暗模式来收集电子邮件订阅者，并通过在向下滚动时，在网页上展示覆盖整个页面的「订阅」框。

正是因为这些东西的外观无关痛痒，所以对用户来说非常讨厌和恼人。但是很多公司都认为，这种偶然的低级趣味正是构建客户群的价值，而且实际上大多数客户都很理解并接受它们。 尽管如此，就像广告一样，如果采取一些富有创造力的手段稍加处理，用户会变得更加容易接受它们。

即使是那些为人熟悉「订阅」框，也有不同程度的处理技巧。 举个例子，它可以以可选的方式弹出。不过有些网站会故意让弹窗看起来像一个需要用户强制性的执行的步骤，但实际上通常会有一种方法来关闭消息并继续阅读网站。

操作系统级通知管理器已经成为 Android 和 iOS 构建的一个功能，它们可以强制禁止来自应用的通知。同样，App 通常也有内置的通知控件，但通常它们是可调整的。 比方说，在 Facebook Messenger 里，用户可以暂时禁用通知，几个小时后通知则可以自动重新开启。此外，App 的通知默认情况下是自动打开，而不是自动关闭的。

---

### 暗模式通知的例子

**我们每天使用的许多网站都利用了我们担心错过通知消息的心理缺陷。**它们使用「伪通知」来提供营销信息、或者简单地让我们返回使用他们的产品，但其实并没有什么有价值的内容可以通知我们。

#### LinkedIn

在 LinkedIn 主页上，你可以看到一个导航栏，如下所示：

![](https://cdn-images-1.medium.com/max/2000/0*RWfwBOfuTqEjfHw8.png)

「我的天，我竟然有 7 个通知！」（...重新激活会员是什么？但我从来没有开启过会员呀？这就是另一种暗模式：玩弄用户对损失的恐惧）。

但是当我点击查看这些通知时，它们给出的仅仅只是一些伪通知：（1）参与改进别人的个人资料（2）告诉我注册他们的高级服务可以查看谁看了我的主页（3）招聘广告。

![](https://cdn-images-1.medium.com/max/1600/0*A1mzOvIHjPRaVsbA.png)

**LinkedIn 的伪通知**
作为 LinkedIn 用户，当我们没有任何新消息或联系请求时，我们的通知 Feed 中仍然会显示一些无关痛痒的广告。这样的处理，让我们能够在他们的网站上花更多的时间、点击更多的页面，并完成更多地交互。

#### Facebook

Facebook 是我们以前看到的那种通知 Feed 的原始工程师之一。这家公司在过去几年中也转而使用伪通知来让人们以更协调的新的方式与他们的服务进行交互。比如，当我到达巴黎时，我会收到通知邀请我查看我的朋友曾今在这座城市的哪些地方玩过。首先，Facebook，有点令人后背发凉，因为像是在跟踪我。其次，这不是我想要在我的通知 Feed  中被提醒的东西。

![](https://cdn-images-1.medium.com/max/1600/0*PA-akOGFo-OhkkPZ.png)

**Facebook 的通知面板：这些都不是真正的通知**
同样，Facebook 会根据你如何使用他们的服务创建通知。如果你在刷新时缺少「真实」通知（评论、喜欢等），则会使用这种延迟来提出其他形式的参与。例如，通过鼓励你查看并回顾 Facebook 的「回忆」功能、向你提供有关你分享内容的动态、或者通过告诉你你的网页有多少访问量等等。

#### Twitter

![](https://cdn-images-1.medium.com/max/1600/0*DTweu2kIIb03vorO.png)

**当你没什么推文时，Twitter 会有效地向你显示其他人互动的通知**
Twitter 使用了类似的策略，通过补充你的通知 Feed，以确保总是有新的东西与你进行交互。

当服务没有任何直接的交互来通知你时，它会开始尝试告诉你**其他用户**的行为。在上面的截图中，它告诉我有关我在关注的人在网站上做了什么，这是元通知（meta-notification）的一种。

Twitter 也会将此类通知推送到你的手机中，从而邀请再次与他们的应用进行互动。

---

### 参与的代价

我选择了 LinkedIn，Facebook 和 Twitter 作为例子，这是通知设计中这个趋势的三大突出例子，但当然这种做法在一系列网站和行业中越来越普遍（令人不安的是，我的葡萄酒俱乐部的网站告诉我，我还有 117 瓶葡萄酒等着我去品尝）。

在以这种方式通知的公司中要平衡的问题必须是：你究竟是以用户的利益行事还是以你自己的方式行事？如果你是以自己的利益行事，你是否权衡了用户的利益？许多网站依靠点击来获得广告收入，并在通知中发现了一种相当粗暴的方式来获得「双赢」。

公平地讲，公司正面临着这些方法相当有用的问题。 即使作为用户的我们知道到我们正在被操控，我们依然会进行点击。而在商业环境中，当你所有的竞争对手都在这样做并收获回报时，原则上拒绝使用一种有效的营销手段，这将是一场灾难。

---

### 通知的峰值？

然而，这种通知设计方法是否仍然有效，将完全取决于我们作为用户的态度演变。在某些时候，我们可能都经历过通知疲劳。就个人而言，像 Twitter 这样的平台侵入式的通知的做法，会让我想减少使用这些服务（但我仍然会沉迷于 Facebook）。

当用户学习识别和避免伪通知时，正如我们学会识别和避免广告一样，通知可能变得不那么有说服力，因此哪怕是作为利用用户行为的方式，效果也很差。更重要的是，如果人们对通知的态度变得强硬，他们部署的暗模式，将系统性地降低人们对这个品牌的看法。相反，在这种情况下，采用更简单、诚实、透明的通知形式的公司和服务可能会受益于这一卖点而变得更加受欢迎。

---

### 通知与科技、生活的平衡

**如果昨天的问题是工作/生活平衡，那么这个故事就是关于科技/生活的平衡。** 使用通知作为暗模式很重要，因为它引发了关于我们如何在世界范围内管理和控制我们对智能技术的个人使用的问题。不仅在于它是普遍的存在的，而且那些运行关键服务的人也不会对我们进行信息轰炸。

技术有潜力通过保持我们的联系来增强我们的社会和个人生活。但是通知显示，技术也有权力通过与商业经纪人、媒介和处理方式的真实联系来削减我们的生活品质。

这牵涉到了 21 世纪发达世界的人类是什么样子的问题。我们正在一起学习如何在享受我们新发现的连接带来的好处的同时，又不失去我们真正珍视这些连接以及我们想要的技术帮助我们在社会关系中取得的成就。

---

###  通知的未来

**科技公司对技术/生活平衡问题并不了解。** 随着未来几年变得越来越紧迫，我们可以期待像 Facebook 这样的服务：在部署伪通知的时间、方式以及频率方面更加智能化。

我相信，很久以后，Facebook 会自动学习我倾向于点开什么样的通知、忽略什么样的通知。这些数据将使服务能够根据对用户喜好的了解，自动发送个性化的通知。例如，如果它的算法注意到我总是无视或忽略关于在新城市的通知，Facebook 可能会学会简单地停止向我显示该信息，或者向我显示其他信息。

但是这会产生道德危机。 目前，伪通知暗模式是相当粗暴的，不过好在它很容易识别。但是，随着服务不断改进他们的信息如何选择和交付，当信息在基于机器学习关于我们的个人在线行为和潜在偏好的基础上被定制时，它可能变得越来越不明显。

这开启了一扇关于操控的大门，它不仅仅是由于人类自身，还得益于那些能够学会只向我们展示我们已经想要看到的信息（哪怕那些与我们当前的世界观一致的新闻故事）的算法。

作为用户，我们应该时刻保持警惕，确保我们保持质疑和被质疑的能力。作为设计师和开发人员，我们必须不断探索而开发体验。这些体验应当尊重用户，即具有能动作用和独立人格尊严的人，而不仅仅是把他们视为点击通知的容器。

---

很享受阅读吗？这里有更多的优质内容来自 Designlab：[伟大的设计思想家：Frank Chimero 的设计形状](http://trydesignlab.com/blog/frank-chimero-design-thinkers-shape-of-design/)

---

### 在 Designlab 学习基础知识

我们提供有导师指导的短期课程，如 Design 101，以及沉浸式的 UX Academy 课程，为你成为专业用户体验设计师而做准备。[访问我们的课程网页以了解更多](http://trydesignlab.com/courses/)，如果有任何问题，请给我们留言 hello@trydesignlab.com。我们的下一期课程从 8 月初开始，所以不要犹豫！

**Designlab 承诺**：我们认为教育应该是既严谨又实惠的 —— 你不应该为了获取你下一步生活需要的技能而把自己搞破产。

---

  > [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
