> * 原文地址：[An introduction to in-app A/B testing: How A/B testing can help you get more out of your app](https://medium.com/googleplaydev/an-introduction-to-in-app-a-b-testing-c5a9a69a3791)
> * 原文作者：[Gavin Kinghall Were](https://medium.com/@gavink?source=post_header_lockup)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 本文永久链接：[https://github.com/xitu/gold-miner/blob/master/TODO/an-introduction-to-in-app-a-b-testing.md](https://github.com/xitu/gold-miner/blob/master/TODO/an-introduction-to-in-app-a-b-testing.md)
> * 译者：[mnikn](https://github.com/mnikn/)
> * 校对者：[swants](https://github.com/swants), [winry01](https://github.com/winry01)

# app 里的 A/B 测试简介

## A/B 测试如何帮助您从 app 中获得更多收益

A/B 测试是一种对照实验方法，用来根据假设比较两个及以上版本之间的差别，其假设可以被证实或推翻。该测试会根据原有版本派生出特定的测试版本，以此来产生可靠的结果。当 A/B 测试在被测人不知情的真实场景中测试，其得出的结果才是最有效的。

![](https://cdn-images-1.medium.com/max/600/1*Yy0xUTqhw0-VX7rxIDNNPw.png)

要构建每个版本的代表性样本群体，A/B 测试平台需要随机地让用户使用版本 A 或版本 B，或者将其排除在测试之外。然后确保用户在整个测试中保持一致的 A/B 体验（总是 A 或总是 B），并向分析平台提供额外的元数据以确定指标的影响。一旦指标分析完成，表现最佳的版本将会被选中，您可以使用 A/B 测试平台逐步向所有用户推出获胜版本。

例如，你可以假设在你的 app 中 [底部导航](https://material.google.com/components/bottom-navigation.html) 的用户参与度将超过 [标签](https://material.google.com/components/tabs.html)。您可以设计一个 A/B 测试比较标签（版本 A）和底部导航（版本 B）。
然后，你的 A/B 测试平台将生成一个样本，该样本基于用户随机分配到版本 A 或版本 B。并且每个用户在测试期间会持续看到相同的版本。当测试结束时，可以将版本 A 用户参与度与版本 B 的用户参与度进行比较，看看版本 B 是否具有 [统计显着性](https://en.wikipedia.org/wiki/Statistical_significance) 的改进。如果版本 B 更好，这就有数据支持你把导航风格改为底部导航，并让所有用户看到这一版本。

![](https://cdn-images-1.medium.com/max/600/1*zQPA1R3det25wJDZ6zdWxw.png)

![](https://cdn-images-1.medium.com/max/600/1*sjA3GNa2KIsqHom-ubhebg.png)

左边 —— 版本 A，标签；右边 —— 版本 B，底部导航

> **_关于 Google Play 控制台中商品详情实验的说明_**

> Google Play 控制台还支持在你的商品详情中进行 A/B 测试，本文不会重点关注这一部分。[商品详情实验](https://developer.android.com/distribute/users/experiments.html)，让你在商品详情中测试不同的图标，功能图，促销视频，简短描述和详细描述，看看这些变化是否可以增加应用的安装。 商品详情实验侧重于提高转化次数，而我的文章的其余部分讨论了应用内的 A/B 测试，旨在改善用户存留率，用户参与度和应用内购买收入等安装后的指标。

在我的文章中，我将介绍 app 里 A/B 测试的五个关键步骤：

1.  建立假设
2.  整合 A/B 测试平台
3.  测试假设
4.  分析并得出结论
5.  采取行动

然后，我还会涉及更多可以探索的高级技巧。

### 第一步，建立假设

假设是根据一种现象提供相应的解释，而 A/B 测试是一种确定假设是否为真的方法。这个假设可能是通过检查现有的数据而产生的，也可能猜测的成分多一点，或者仅仅只是一种“预测”。（对于新功能所涉及到的新指标，假设常常是基于“预测”。）在导航的例子中，可以用这种方式来表达假设：“采用底部导航会较标签增加用户的参与度“。然后，如果你的 app 有对导航风格进行了更改，以及该更改对用户参与度的有影响，你可以根据这个假设来进行相应决策。重要一点的是要记住，测试的唯一目的是证明底部导航对每个用户的平均收入（或者 ARPU）有着直接，积极的影响。

#### 要测试什么（A 是什么？B 又是什么？）

下面的表格列出了大部分的情景，可以帮助你确定要如何选择测试的版本。以我们假设的导航实验为例。

![](https://cdn-images-1.medium.com/max/1000/1*fY2cSb5ZzM0xmWy0J3SbRA.png)

“排除测试”这一列表示不参与测试的用户。他们的行为将不会有助于测试结果。我们看看谁是测试用户。

我们根据假设想要度量什么来选择情景 2 或者情景 3。如果仅与新功能有关（例如，如果新功能是需要 app 内购，则这个功能仅和 app 内购买收入相关），那么选择情景 2。如果假设要实现的新功能（例如，如果新功能是“最爱”机制，并且度量指标是用户参与度）与之前的东西（并且是可测量的）相关，则选择情景 3。

> **注意：** 在接下来的部分中，为了简洁起见，我将使用情景 1。 同样的方法同样适用于情景 2 和情景 3，以“现有”和“新”版本这些称号代替“新 1”和“新 2”版本。

#### 谁来测试

如果已知观察到的行为会因为假设外的某个因素发生变化 —— 例如，当假设仅考虑全球收入的影响时，已知行为会因居住国而异 —— 需要让该因素（单一国家）的值唯一，或者使用全体人口（所有国家）的代表性样本。

受控的代表性样本的大小也可以设定为总人口的百分比。例如，测试样本大小是总人口的 10％，其中 5％ 收到版本 A，5％ 收到版本 B，其余 90％ 排除在测试之外。也就是 90％ 的用户只会看到现有的功能，并不会看到任何新功能，他们的行为被排除在测试指标之外。

#### 要测试多久

**最长时间：** 用户的行为通常会随着时间，这周的第几天，月份，季节等类似因素而变化。为了让版本之间体现出足够的差异，您需要平衡统计显着性和业务的需求。（您的业务可能无法等到你有足够的数据可以完整的统计。）如果知道某个特定指标会在较短的时间段内发生变化，例如一天中的某个时间或一周中的某一天  —— 那么就尝试让测试涵盖这一整个时期。对于需要较长的时间段的指标，只测试几周可能会更好一点，并要根据度量标准随时间的变化进行相应地推测。

**最短时间：** 测试运行的时间要足够长，来获取足够的数据从而能够提供具备统计意义的结果。通常对应的测试人数是 1,000 个用户（至少）。但是，能否得到明显的结果取决于从假设推导出来的指标分布。你可以通过估计有多少用户能够在所需的时间段内进行测试，从而在合理的时间内完成此操作，然后选择估计用户数量的百分比，以便让你的测试在这个时间段内达到统计显著性。一些 A/B 测试平台能自动管理这些操作，同时也可以提高你的测试采样率，让你的测试更快地达到统计显著性。

### 第 2 步，整合 A/B 测试平台

![](https://cdn-images-1.medium.com/max/600/1*8iHKjuY5xYGOaQTM6BEqGg.png)

已经有几种 A/B 测试平台，既可以作为一个独立产品进行测试，也可以作为一个更大分析平台的组件，例如 [Firebase 远程配置分析](https://firebase.google.com/docs/remote-config/config-analytics)。通过客户端库，平台会向 app 发送一组配置指令。app 不知道**为什么**要返回某个参数，因此不知道它在测试哪一部分，甚至不知道是否这是测试的一部分。客户端应该按照配置指令自己进行相应配置，由客户端来解释其中的价值。 在最简单的情况下，返回的参数可以是简单的键值对，用于控制是否启用给定功能，如果是，则激活对应的版本。

在更复杂的情况下，如果需要进行大量的远程 app 配置，app 会将参数发送到 A/B 测试平台，测试平台会跟据这些参数来选出更精细的测试配置。例如，如果假设只涉及具有 xxxhdpi 屏幕密度的设备，那么 app 将需要将其屏幕密度发送到 A/B 测试平台。

#### 不要重复发明轮子

直接从现有平台中选择一个可以满足 A/B 测试需求的。注意：需要养成相应习惯来做到 A/B 测试和数据驱动决策。

> **注意：** 管理许多用户，让其保持一致的测试状态，并公平地分配测试参与者很**难**。没有必要从头开始写。

当然，你要为每个要测试的版本写代码。但是，不应该由 app 或某个定制服务来决定在给定时间内使用哪个版本。这要交给 A/B 测试平台来处理，应用这种标准方法，可以在集中管理同一时间内同一人群的多个测试。当你在平台上只执行一个测试时，亲自实现一个简单的 A/B 测试机制才有意义。 对于硬编码两个测试的成本，您可以集成一个现成的 A/B 测试平台。和写两个硬编码测试的成本相比，不如把这些测试集成进一个现成的 A/B 测试平台。

#### 整合分析功能

选一个可以提供详细的测试状态信息的现有分析平台，可以自动帮你可以把测试人群进行分类。要紧密地把这两个平台集成在一起，取决于每个测试的具体配置，和要直接在 A/B 测试平台和分析平台之间传递的版本。A/B 测试平台会为每个版本分配一个唯一的引用，并将其传递给客户端和分析平台。然后，只允许客户端把该引用而不是整个版本的配置传递给分析平台。

#### 远程配置

一个具有远程配置功能的 app，已经有了实现 A/B 测试时所需的大部分代码。实质上，A/B 测试添加了一些服务器端的规则用来确定什么配置发送到 app。 对于没有远程配置功能的 app，那么引入 A/B 测试平台是让你引入这一功能的其中一个好方法。

### 第 3 步，测试假设

一旦确定好你的假设和设计好测试，而且也集成了 A/B 测试平台，实现你的测试版本就是一个最简单的操作了。下一步，开始你的测试。A/B测试平台将一组样本用户分配在测试群体上，然后给每个测试用户分配版本。然后平台继续在理想时间段内的分配用户。对于更高级的平台，平台会一直执行测试，直至达到统计显著性。

#### 监控测试

我建议在测试过程中监控新版本所造成的影响，包括测试假设中未提及的指标。如果你发现它会造成不良的影响，那么可能要尽早停止测试，尽可能快地让用户恢复到之前的版本 —— 最大限度地减少糟糕的用户体验。一些 A/B 测试平台能够自动监控并会提醒测试可能会有意想不到的负面影响。如果你的平台不能做到这一点，你需要把现有的监控系统中看到的任何影响和目前的测试相互参考，来识别“不良”版本。

> **注意：** 如果测试确实需要提前停止，那么你应该要对收集到的数据谨慎处理，因为它不能保证测试群体样本具有代表性。

### 第 4 步，分析并得出结论

一旦测试正常结束，你就可以用在分析平台中收集到的数据确定测试的结果。如果结果指标和假设相符，那么你可以认为这个假设是正确的。否则，你猜错了。确定观察结果是否具有 [统计显著性](https://en.wikipedia.org/wiki/Statistical_significance) 取决于指标的性质和分布。

如果假设错误 —— 因为相关指标没有正面或者负面影响 —— 那么就没有理由继续保留这一版本了。然而，新的版本可能会对相关但意想不到的指标产生积极的影响。这可能是一个选择新版本的理由，但通常来说执行一个专门针对辅助指标的附加测试来确认其影响会更好一点。实际上，一个实验的结果经常会引起额外的问题和假设。

### 第 5 步，采取行动

如果假设是真的，并且新的版本比旧的好，那么我们可以更新要传递给 app 的“默认”配置参数，指示它使用新的版本。一旦新的版本为成为默认后持续了足够的时间，你就可以把旧版本的代码和资源从下一个版本的 app 中删除。

#### 迭代展示

A/B 测试平台的一个常见用法是将其重新作为迭代展示的机制，其中 A/B 测试的获胜版本会逐渐取代旧版本。这可以视为 A/B 设计测试，而迭代展示是 Vcurr／Vnext 测试，用来确认所选的版本不会对大部分的用户产生不利影响。可以通过提高接收新版本的用户百分比（例如，从 0.01％，0.1％，1％，3％，7.5％，25％，50％，100％ 开始）来迭代展示并确定在进入下一步之前没有不利的结果。同时你还可以用其他方式进行分类，例如国家，设备类型，用户组等。你还可以选择将新的版本展示给特定的用户组（例如内部用户）。

### 更进一步的实验

例如，你可以构建一个简单的 A/B 测试，用于更深入的理解用户行为范围。您还可以同时运行多个测试，并在单个测试中比较多个版本来来让测试更高效。

#### 深度分组和定位

A/B 测试结果可以检测不同组结果的变化，并定位是哪个方法所造成的。在这两种情况下，可能需要提高采样率或测试持续时间来达到每个组的统计显著性。例如，[标签 vs 底部导航假设](https://uxplanet.org/perfect-bottom-navigation-for-mobile-app-effabbb98c0f) 的测试结果可能会根据国家的不同有不同的影响。在某些情况下，一些国家的用户参与度可能会大幅度增长，有些则没有变化，有的略有下降。 在这种情景下，A/B 测试平台可以根据国家设置不同的“默认”版本，以最大限度地提高用户总体参与度。

可以针对特定组使用同一组的数据进行测试。例如，您可以测试居住在美国的用户和之前使用过标签导航风格的用户。

#### A/n 测试

A/n 测试是测试两种以上版本的简写。这可能是多个新的版本要取代现有的版本，如有全新功能的几个版本要取代没有任何新功能的版本。当你进行了深度地分组后，可能会发现不同的版本会在不同的组中表现最好。

#### 多变量测试

一个多变量测试是一个单一的测试，它一次性改变 app 多个部分。然后，在 A/n 测试中，将唯一的一组值作为一个单独变量处理。例如：

![](https://cdn-images-1.medium.com/max/800/1*DbBtyfDwZwCLPbFD2eIMVg.png)

当多个方面可能都会影响整体指标性能时，使用多变量测试是适当的，但是无法区分该效果是由哪一特定方面带来。

#### 扩大测试规模

如果在同一个人群中同时运行多个测试，那么这些测试必须由同一个平台管理。有些平台能够扩展到支持数千个测试同时运行，有些平台则把完全测试孤立起来（所以用户一次只能进行一次测试），而有些平台可以共享一个测试用户（所以用户同时进行多个测试）。前一种情况更容易管理，但会迅速用完测试用户，并导致统计显著性的上限取决于并行测试的数量。而后一种情况，A/B 测试平台难以管理，但是并行测试的数量没有上限。平台通过完全把每个测试视为另一个测试的附加组来实现这一点。

#### 自我选择

自我选择让用户知道自己正在使用特定测试中的特定版本。用户可以自行选择版本，或者让 A/B 测试平台给他们分配。无论是哪种情况，这些用户都应该被排除在指标分析之外，因为他们不是在不知情的状态下参与测试 —— 他们知道这是一个测试，所以他们可能会表现出一个有偏见的回应。

### 结论

app 内的 A/B 测试是一个非常灵活的工具，它可以让你对你的 app 做出由数据驱动的决策，正如我在本文中所强调的，这可以帮助你对新功能做出明智的选择。A/B 测试允许你在真实世界中使用真实用户测试 app 的各个方面的版本。为了简化 app 内的 A/B 测试设计，集成，执行和分析，Google 提供了一套工具，其中包括：

*   [Firebase 远程配置](https://firebase.google.com/docs/remote-config/) （FRC）提供了一个客户端库，允许 app 请求 Firebase 和并接收相应配置，另外还有一个基于规则的云端机制来定义用户配置。远程配置可以在而无需发布新版本的情况下帮你更新（和升级）你的 app。
*   [Firebase 远程配置与分析](https://firebase.google.com/docs/remote-config/config-analytics) 支持根据 A/B 测试来决定和跟踪版本部署。
*   [Firebase 分析](https://firebase.google.com/docs/analytics/) 根据版本给出一个指标分类，并直接连接到 FRC。

* * *

#### 你怎么看？

对使用 A/B 测试还有任何疑问或想法吗？可以在下面的评论中发布讨论，或者使用标签 #AskPlayDev，我们将会在 [@GooglePlayDev](http://twitter.com/googleplaydev) 里回复，我们会定期分享有关如何在 Google 上做得更好的新闻和提示。

* * *

**记住：** 分析对于 A/B 测试至关重要。 A/B 测试和分析结合在一起，可以开拓你的视野，推动你的 app 之后的设计和开发，最大限度地让其做到最好。


---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[区块链](https://github.com/xitu/gold-miner#区块链)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计)、[人工智能](https://github.com/xitu/gold-miner#人工智能)等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)、[官方微博](http://weibo.com/juejinfanyi)、[知乎专栏](https://zhuanlan.zhihu.com/juejinfanyi)。
