* 原文地址：[ In the age of the algorithm, the human gatekeeper is back ](https://www.theguardian.com/technology/2016/sep/30/age-of-algorithm-human-gatekeeper)
* 原文作者：[Michael Bhaskar](https://www.theguardian.com/profile/michael-bhaskar)
* 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者：[Jiang Haichao](https://github.com/AceLeeWinnie)
* 校对者：[根号三](https://github.com/sqrthree),[Mark](https://github.com/marcmoore)

# 在算法横行的时代，仍需要人类把关

Greg Linden 或许不是一个家喻户晓的名字，但他改变了我们与文化的相互影响并且永久变革了零售业。作为[九十年代晚期 Amazon 的一名工程师](https://www.theguardian.com/technology/2006/mar/09/newmedia.guardianweeklytechnologysection)，Linden 要解决一个奇怪的问题：如何在没有人工干预的情况下向顾客推荐书籍。那时 Amazon 还要依靠编辑们每年写上上百篇评论。这不仅费钱还费时。

自动化推荐在当时是难以想象的棘手。 Linden 成功破解了这个难题。他把目光放在 "个性化" 上，矛盾的是，这关注的是产品之间的相关性而不是个人购买历史。忽略过去的购买记录后， Amazon 发现如果 A 产品一般和 B 产品一起售出，也就是说几乎所有人买 A 时也会想买 B。 Amazon 通过不同的售书方法的销量测试了这一发现。不消说：编辑们要卷铺盖走人了。人类退出，机器当道。一些估算显示因为这些推荐算法， Amazon 的营业额上升了 1/3。从此，算法被大量使用。现在书籍、文章、音乐、电影，还有不消说的度假和服装，都是通过机器推荐的。

去年，英文书籍新出版了一百万册。至少从古希腊开始，人们已经觉得要读的东西太多了。当然，这还没算上那些有作者自己出版的图书，大量新闻或者是浩瀚无边的互联网。不管怎么说，我们都处在令人惊讶的阅读过剩之中。

我们拥有的越多，我们就越依赖算法和自动化推荐系统。因此，推荐算法、机器学习、人工智能和大数据不可抵挡地侵入了文化领域。

然而故事并没有结束。例如搜索引擎，能告诉我们想知道的内容，但有一些内容是我们需要的，但是我们暂时还没有想到，对于这些内容，搜索引擎就帮不上忙了。人类的挑选和识别力在算法时代有了新的意义，远不能消失。是的，随着拥有的越多，我们越来越需要算法了。但是我们也更加希望见多识广和特殊选择。人类又回来了。

这是为什么尽管有全世界最强大的图书推荐引擎，Amazon 还是买下了 [Goodreads](https://www.theguardian.com/books/2013/apr/02/amazon-purchase-goodreads-stuns-book-industry) —— 一个主营个人书籍评论的网站。这也是为什么像 Canopy.co 这类的网站活跃程度在 Amazon 之上。Canopy 知道 Amazon 最棒的商品隐藏在一堆乱七八糟的东西里。Canopy 的创始人全都是设计师，每天筛选数千条记录以重点标注高质量商品。

这是为什么尽管在网上能找到任何想要的书，但出版商仍印刷新的书籍满足多样化与个人书单，书店也再次兴起的原因。我们能够漫不经心的查看桌子上的书籍。在日本，人们谈论  **tsundoku**，即太多书可读的不安感受。他们自有解决办法：[东京银座书店](https://www.theguardian.com/books/2015/dec/23/japanese-bookshop-stocks-only-one-book-at-a-time)一次就只售卖一本书。

这个在内容挑选上重焕生机的趣味不仅出现在出版业。在 Spotify（某在线音乐播放器）上，你可以听 30m 的音乐，其中20%一次都没播放过。为了帮助管理庞大的音乐目录，Spotify 花了 1 个亿收购了 [the Echo Nest](https://www.theguardian.com/technology/2014/mar/06/spotify-echo-nest-streaming-music-deal) 公司，后者拥有一项先进技术，用于识别音乐，自动分类曲目。同时，[Spotify](https://www.theguardian.com/business/2016/may/24/spotify-revenues-surge-80-to-more-than-13bn) 扩充了自己的歌单推荐人和快速成为新 DJ 的音乐专家。

![Spotify 办公室](https://i.guim.co.uk/img/media/b1817d17c3857559c8c5bb3ebdd852627eefa181/0_192_5760_3456/master/5760.jpg?w=620&q=55&auto=format&usm=12&fit=max&s=aa4b8651de389bfc8cff727a2bb8c24d)

[Netflix](https://www.theguardian.com/tv-and-radio/tvandradioblog/2013/aug/15/netflix-subscribe-breaking-bad-justified) 有远超观众需要的影视剧集。它是一个用数据科学管理文化的先驱者，它甚至为了研究团队们来升级它的算法而发起一个奖金 100 万美元的比赛，最后钱花出去了，却没有实现他们想要的效果。然而 Netflix 还培养观众为它的内容打一些详细的标签。他们做到了评论系统做不到的是：结局是想要的吗？胡子在电影里重要吗？

Facebook 陷入一系列信息流内容管理的争议中，从直播杀戮，到删除越战的象征图片，再到政治偏见的指控。它最近试图通过开除人工编辑消除审核流程... 仅仅为了发现信息流退化成大量虚假和有争议的新闻故事。

[苹果新闻和音乐](https://www.theguardian.com/technology/2016/may/04/apple-music-wwdc-taylor-swift) 应用有大量人工内容管理，甚至找了新闻编辑部和广播的名人们。Twitter 在它的 [Moments](https://www.theguardian.com/technology/2015/oct/06/twitter-launches-news-moments-curation) 产品中下了重金。虽然普遍不看好，但 Twitter 确实希望在内容上做的更好。Samsung 的新闻应用分成你想知道的和你需要知道的；前者通过算法挑选，后者通过编辑。大型科技公司对老牌专家求贤若渴。

我们也有多余的东西。西欧家庭平均拥有 1 万件东西，美国家庭更多。但是处理这个情况不需要应用，只需要 [Kondo](https://www.theguardian.com/lifeandstyle/2016/jan/21/tidying-up-marie-kondo-spark-joy-new-york-book-singing) 方法，这是一种依靠我们个人历史信息来整理家庭的技术，深受欢迎。在零售业的上游，成功商店的背后有一再强调的专家精选，和时尚精品 [Opening Ceremony](https://www.theguardian.com/fashion/fashion-blog/2012/jul/23/opening-ceremony-london) 和 ”未来超市“ Eataly 一样多样化。随着媒体发展，我们从大量工业选择时代过渡到精选时代。

精选可以是不得当的，有时还是贬义的词语，但是他的词根 curare（表示照顾的意思）却可以击中人们心中无法替代的感觉。我们想要惊喜，我们想要专业知识，独特的审美评论，无须花费时间和精力。我们体会到这混乱世界的另一种味道，体会人与人之间的信任。我们不仅想要相关性，我们还想知道为什么，想要故事，这是机器无法提供的。即使我们将精选定义为选择和排列，这也不完全是算法的工作。与许多行业经历技术破坏不同，从自动驾驶汽车到自动化会计，文化领域将一直重视人类选择和独特的感受。

这是艺术和人文对机器学习世界的反击。这会创造新的就业。信息过载和技术驱动响应是我们的时代最好的转变。但在今天这种饱和状态（和那些成堆的摇摇欲坠的书）中，知识和主观判断比以往更有价值。用一名硅谷投资人的话说，“软件吃掉了世界“。当然，软件吃不掉人类选择。与神话相反，传统守门人角色仍健在。

接下来我们将看到的是一种混合状态：充分混合了人类和机器选择来处理庞大数据集，在狭窄范围之上越走越远。我们现在有许多我们不能独自处理的东西，例如书籍、音乐、电影和艺术作品。我们需要一个 “算法文化”。但是我们比以往更需要：人类品味。

