> * 原文地址：[A Mindful Design Process](https://headspace.design/a-mindful-design-process-f4a4641ee88f)
> * 原文作者：[François Chartrand](https://headspace.design/@frankchartrand)
> * 译文出自：[掘金翻译计划](https://github.com/xitu/gold-miner)
> * 译者：
> * 校对者：

# A Mindful Design Process #

How integrating mindfulness techniques will help you become a stronger designer and a more engaged team member.

![](https://cdn-images-1.medium.com/max/1000/1*zvpIsZO5ZGUBZPBD-2tdKA.jpeg)

We all have a process we follow to get us from concept to execution. Sometimes we’ll have access to a great brief, data, insights, and an inspirational mood board but still, we get stuck: we procrastinate, get hung up, or struggle with artist’s block. Sound familiar? Read on…

I’ve outlined some easy-to-implement mindfulness techniques that you can start building into your process today. It’s about creating your best work in a meaningful and intentional way, and having fun while you’re at it.

> “Mindfulness is awareness that arises through paying attention, on purpose, in the present moment, non-judgmentally.”

> — Jon Kabat-Zinn

### **Before you begin** ###

**Just listen**
This one is so easy: just listen and pay attention. Put your phone away, close your laptop, and open your ears.

Whether you’re meeting with clients, stakeholders, or having a 1-on-1 with a colleague, practice the art of listening. Ask more questions. Talk it through. Projects get much more interesting when you feel like you have skin in the game and actually care about the outcome. Here’s a short TED Talk by [Julian Treasure](https://medium.com/@juliantreasure) on ["5 ways to listen better.”](https://www.ted.com/talks/julian_treasure_5_ways_to_listen_better)

*Pro tip:* Using simple [body language techniques](https://blog.udemy.com/positive-body-language/) can be an invaluable tool in your life and career. I know it sounds lame, but it actually works—and others will feel more comfortable around you. [Mitch Joel](https://medium.com/@mitchjoel) discusses some winning body language tips on his podcast—[ check it out](https://overcast.fm/+JjXi7iC4).

![](https://cdn-images-1.medium.com/max/600/1*_YryF85J5Yju7KeanuhXgA.png)

**Set realistic timelines and expectations**

Ensure you have enough time to get the task completed.

Rushing the process leads to uninspired work, so make sure you ask for enough time (or budget) to be successful. Even if you can’t get it, it’s always worth asking for what you truly believe the project requires.

Many designers accept deadlines without asking why and burn out. You’ll leave a more positive impression on your peers when you set expectations early.

**Design with intent**

Is there something about this project that excites you? Is this your specialization, or are you up for a new challenge?

Try asking yourself, is this a step in the right direction to improve my design skills? Will this help with my ideal career path? Your career is the sum of all of your work, and knowing you’re growing in the right direction can be motivating.

### Do your research ###

**Get context and re-frame the project**

Before you start, do some research. Without context, you won’t be able to do your best work. Even seemingly boring projects can be exciting if you re-frame them. Check out what the best-in-class are doing—there’s a lot you can learn from their successes and slip-ups.

[Paul Woods](https://medium.com/@paulthedesigner) wrote a great article on [turning an uninspiring brief into an awesome portfolio piece](https://medium.com/@paulthedesigner/turning-an-uninspiring-brief-into-an-awesome-portfolio-project-31b2aa871bb7#.7dclqp3w) that may be helpful for you.

Time spent researching is never time wasted. Research will help guide you toward the next step of the process with some key insights. Plus, with solid research, it’s easier to sell your ideas internally or to clients.

![](https://cdn-images-1.medium.com/max/1000/1*B--DG0OODgsuNTprMK8vgA.png)

**Visualize with a mood board**

Use [InVision Boards](https://support.invisionapp.com/hc/en-us/articles/205249269-Introduction-to-Boards) or [Pinterest](http://www.pinterest.com) and share early on with your team. Mood boards can act as visualizations of the success you want the project to achieve. They can also help align others on the project and help, or serve as a reflection when your creative juices are running low.

**Get the tools for the task**

Look into what tools and licenses you’ll need and set yourself up with the proper stack of tools and software.

- Stickies/markers
- Whiteboard
- [Paper](https://www.google.com/url?sa=t&amp;rct=j&amp;q=&amp;esrc=s&amp;source=web&amp;cd=1&amp;cad=rja&amp;uact=8&amp;ved=0ahUKEwjI-sT67ffSAhXFvLwKHQOtDtUQFggcMAA&amp;url=https%3A%2F%2Fwww.fiftythree.com%2F&amp;usg=AFQjCNGyxIjM39EcNUzww6FXtJw96xwKfA&amp;sig2=ik8RiXeUi5YCI-7Ydyrx2Q) (flows, wireframes)
- [Sketch](https://www.sketchapp.com/) (app/web design)
- [Zeplin](http://www.zeplin.io) (spec’ing)
- [InVision](https://www.invisionapp.com/) (lofi prototyping)
- [Framer](https://framer.com/) (hifi prototyping)
- [Skitch](https://evernote.com/skitch/)(QA annotation)

![](https://cdn-images-1.medium.com/max/1000/1*0fwiF6oe8FJ0VkEcY5KMsg.jpeg)

### Set yourself up for success ###

The biggest hurdle in any creative process is *beginning*. If you’re having trouble getting started, sit quietly and take few deep breaths. If that isn’t helping, go for a walk, stretch, meditate, make yourself coffee, put on an album you enjoy—whatever you need to clear your mind.

> “Begin anywhere.”

> — John Cage

**Check your posture**

I’m no scientist, but I know that posture makes a big difference in my focus and concentration. Settle in, feel the weight of your body and ensure you’re comfortable, not slouching. Standing desks are also a great option that allow you to stretch your legs and feel weight on your toes, giving you extra mobility.

**Keep your focus**

Try [Focus](https://heyfocus.com/)  (app) to block websites you find yourself visiting often—or fully disconnect from WiFi. Set your phone on Airplane mode and put it in another room.

**Stop multitasking**

Successful people know that being [fully present and committed to one task](http://www.zerotoskill.com/proven-steps-to-the-most-productive-day-youll-ever-have/) is indispensable.

![](https://cdn-images-1.medium.com/max/800/1*4MyOs2PvfYDOQ5iXPhy1zw.jpeg)

### Unlocking creativity ###

**Sketch. Iterate. Simplify.**

Great designers know that your best ideas are often your last. When sketching, try not to dwell on a concept or idea for too long. Sketch out the idea or allow the thought to float away. Consider different scenarios in which people might observe this design in, whether on a mobile phone or piece of branding. Embrace and consider each thought or sensation without judging it as good or bad. Ideas will come in abundance… If your mind wanders elsewhere, notice where it has gone and gently redirect it to the present.

**Reduce, simplify, observe,** and you’ll eventually get to an iteration you can move forward with confidently.

![](https://cdn-images-1.medium.com/max/600/1*K6gRA8kRrQvn6CCYoz4oDA.jpeg)

![](https://cdn-images-1.medium.com/max/600/1*z98ajqpYLq3zvhlbHpwP7A.jpeg)

Photos by Ian Whittlesea

*Want more? Try some breathing exercises…*

If you’re looking for more of a creative boost, you might want to consider the breathing exercises found in *Hazdaznan Health & Breath Culture*, a book exploring the relationship between Mazdaznan, Johannes Itten and the Vorkurs (Preliminary or Foundation Course) at the Bauhaus.

**Remember that design is for people**

No matter what, design is for an end-user or consumer and we should do our best to understand their needs and desires—whether that’s a subscriber, a client, or a client’s client. Be respectful and considerate of everything they’re going through when engaging with your design.

### Communication matters ###

**Share often and communicate clearly**

Keep your team in the loop often and set expectations early. Meet your deadlines, and if you’re about to miss a deadline, give your manager or client a heads up and let them know how you’ll avoid this in the future.

**Communicating with your team**

When it comes to communicating with your team, be aware of communication styles. Some people appreciate a note on Slack before you swing by their desk. Others prefer to meet in private. Everyone’s different and [increasing your self-awareness](http://www.tanveernaseer.com/increasing-self-awareness-to-improve-how-we-communicate-scott-schwertly/) will improve the way others react to your feedback.

### **Take notes** ###

**You can never take too many notes**

It’s better to take too many notes than not enough. If it helps, you can even record meetings on your phone to listen to later when you’re working on the project. This way you can be totally sure you’re checking all the boxes your manager or client shared. [Helen Tran](https://medium.com/@tranhelen) of Shopify wrote about her [bullet-journal system](http://helentran.com/two-habits)and how a system like this is a habit that changed her career.

Before completing a project, take time to jot down what went well and what didn’t so you can learn from any successes or shortcomings and be better prepared in the future. If you’re not being mindful of the process and how you felt under certain pressures, you’re bound to keep repeating the same mistakes. [Journaling](http://stronginsideout.com/journaling-techniques/)is handy as a general life practice and helps you track the progress you’re making in your life.

**Don’t take revisions or feedback personally**

Even if you think you’ve found the best solution it’s not a solution if it doesn’t work for your user or clients. Reach a good balance between your knowledge, expertise, and your client’s.

While criticism isn’t personal, you should always stand up for your decisions if you think it’ll help the end-user. You should be proud of your work, but design is, in the end, for users and customers. Sometimes people give ego-driven feedback because they feel like they have to prove their own worth (even you!), and being aware of this is helpful. Practicing deep breathing or a short meditation before meetings can help keep the ego in check.

[Julie Zhuo](https://medium.com/@joulee)  wrote a post on [taking feedback impersonally](https://medium.com/the-year-of-the-looking-glass/taking-feedback-impersonally-7c0f3a8199d9) that I highly recommend.

*Pro tip:* People fear feedback because it’s usually negative. If you’re able to, try and mix it up and give more positive feedback too.

### Other thoughts ###

![](https://cdn-images-1.medium.com/max/800/1*2MdbVkVcG59XyYG5AihtJQ.png)

**Remember *why* you design**

Are you designing to build up your portfolio? To empower users? To put a roof over your head? Try keeping a memento around that reminds you why you’re doing this—whether that’s a photo on your desk or a note in your wallet. Something small that will motivate you when you’re losing steam.

**Get some rest**

Don’t forget to take a break once in a while. We often celebrate the tireless designers who hustle 24/7, and I’m not saying you shouldn’t — that’s up to you — but if you’re burning the midnight oil often, you might consider using apps like [f.lux](https://justgetflux.com/) to help with your sleep. (makes your computer screen look like the room you’re in based on time of day).

**Be humble. Give credit where it’s due.**

It takes teamwork to make the dream work. Give credit to your teammates and share that big launch or award with others—even Buzz Aldrin had hundreds of people behind him when he first stepped onto the surface of the moon.

**Keep your desk clean**

NASA astronauts clean up their stations after every use; more designers should do this, especially when it comes to meeting rooms and communal spaces. Keep your desk clean, keep your mind clean (and ready for those bursts of creativity).

**Be thankful**

We’re lucky to do what we do for a living. Design is still in its infancy, and there’s so much exciting work to do. Happy designing! 🌞


Thanks to [Alex Pompliano](https://twitter.com/alexpompliano) for editing. 🙏

*Frank is a Product Designer at [*Headspace*](http://www.headspace.com). He was previously at [*Edenspiekermann*](http://www.edenspiekermann.com) and co-founded [*Bureau*](http://www.bureau.ca).*

*You can follow him on [*Twitter*](http://www.twitter.com/frankchartrand).*

---

> [掘金翻译计划](https://github.com/xitu/gold-miner) 是一个翻译优质互联网技术文章的社区，文章来源为 [掘金](https://juejin.im) 上的英文分享文章。内容覆盖 [Android](https://github.com/xitu/gold-miner#android)、[iOS](https://github.com/xitu/gold-miner#ios)、[React](https://github.com/xitu/gold-miner#react)、[前端](https://github.com/xitu/gold-miner#前端)、[后端](https://github.com/xitu/gold-miner#后端)、[产品](https://github.com/xitu/gold-miner#产品)、[设计](https://github.com/xitu/gold-miner#设计) 等领域，想要查看更多优质译文请持续关注 [掘金翻译计划](https://github.com/xitu/gold-miner)。
