
>* 原文链接 : [A Guide to Interviewing for Product Design Internships](https://medium.com/facebook-design/a-guide-to-interviewing-for-product-design-internships-d719dd4c146c#.jhgjr12c)
* 原文作者 : [Andrew Hwang](https://medium.com/@ahwng)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : 
* 校对者: 





> “We reviewed your portfolio, and we’d love to interview you for our product design internship. What times will you be available in the upcoming week?”

Upon seeing this email, your pulse quickens. Your eyes widen. You drool a little. You sent out so many cover letters, submitted so many applications, and — finally! A small but meaningful step on the journey to becoming a full-fledged product designer.

But what will they ask you? And how could you possibly prepare?


Breaking into the product design field as a student is hard. Some product designers stumble into the field with a graphic design or art degree. Others are self-taught. Either way the field of digital product design is so new that there are very few resources for curious students.

In high school I hadn’t yet heard of the product design industry. I dabbled in web design but quite frankly, I was terrible at it. I couldn’t imagine it going anywhere.

But over time I accumulated enough design work to find myself with a design internship at a mobile app startup. There I first got a taste of product design. And I fell in love with the problem-solving, the complexity, the collaboration with product managers and engineers and illustrators to build something from nothing. So I pursued it ruthlessly.

The following summer I ramped up my internship application game, submitting resumes to over 50 companies. Five of them responded positively. Of those five, three small tech companies interviewed me immediately. But I went into those interviews not having the faintest idea what they’d ask, so those doors shut as quickly as they had opened.

Evernote was the fourth company to respond positively. And though I had botched the previous three interviews, I had a better idea of what to expect when I hopped on the phone with the Evernote designers.

I landed the Evernote product design internship that summer. And with a bit more experience under my belt, the following summer I received an offer for Facebook’s product design internship. Now I’m a full-time product designer at Facebook.

As a student I interviewed for product design internships at many of the Silicon Valley behemoths: Google; Facebook; Mozilla; Quora; Groupon; Dropbox. And if one thing stuck with me, it was that product design interviews are quite similar across tech companies. They usually include all or some combination of the following:

1.  Phone screen
2.  Portfolio review
3.  Design exercise
4.  App critique

Let’s dig a little deeper into each step

The phone screen allows the recruiter to get to know you better, to go past the words on your resume. You might be asked:

*   What’s your background like?
*   How did you get into design?
*   Why are you interested in working here?
*   What was your favorite past project, and why?

During the phone screen, sound excited. And come prepared with questions for the recruiter. Try to ask questions specific to the company, questions that are not easily answerable with a Google search. Recruiters can tell generic questions from authentic ones, and asking canned questions may damage the strength of your candidacy.

While preparing for my first phone screen with Facebook, for instance, I [discovered](http://www.quora.com/What-do-Facebook-interns-do) the company regularly hosts intern hack-a-thons. So during the phone screen I probed further about the hack-a-thons: How do they work, exactly? Is it okay for interns to completely ignore their summer projects during the hack-a-thons? Who reviews the final projects? Questions like these show genuine interest. They tell the recruiter you’ve done your homework and care deeply about the internship opportunity.

If the recruiter thinks your background and interests might be a good fit for the internship, the next step is usually a showcase of your past work.

Here you’ll speak with a designer. Typically, the review will include a deep dive into three or four of your portfolio projects. The point of the portfolio review is for the designer to tease out your design process, to understand what types of questions you ask and what kinds of solutions you consider. In short, the interviewer wants to know how you approach design. You might be asked questions such as:

*   What were the problems you were trying to solve?
*   Who did you partner with?
*   What kind of research did you perform, if any?
*   Why did you choose that design solution over this one?
*   What were the tradeoffs?
*   What challenges did you face in designing X?
*   If you had more time to work on Y, what would you change?
*   If you got stuck on a certain design problem, how did you overcome it?

One of your main tasks in the portfolio review is to show **intentionality** in your design process, to demonstrate that you thought through each design decision carefully, from the high-level product features to the visual styling of a button.

Describe your rationale clearly. Arbitrary design decisions won’t hold up to the scrutiny of a portfolio review.

<figure score="-12.5">

<div score="6.25">![](/images/loading.png)</div>

<figcaption>Make sure you can articulate your design decisions. Comic credit: Andrew Hwang</figcaption>

</figure>

During the portfolio review, you should also be able to **thoughtfully critique** your own designs. No design solution is perfect. Reflect on your projects and come up with suggestions for how to improve them.

Many companies think of product design as having three pillars:

1.  Visual design: How polished are your designs? Do they feel well-crafted and refined? Are they aesthetically pleasing?
2.  Interaction design: Can you design intuitive end-to-end user flows? Do you consider edge cases appropriately? How easy is it to get from point A to point B in an app you designed?
3.  Product thinking: What problems are you trying to solve? Who are you designing for? What features should be included in your product, and why?

The portfolio review helps the interviewer gauge your strengths and weaknesses in these areas. Maybe you’re more comfortable with visual design and less so with interaction design. Maybe you’re a fantastic product thinker but can’t build a prototype to save your life. But that’s okay! You’re a student. Interviewers don’t expect you to be a rockstar in every facet of product design. Being honest about your weaknesses shows humility, a vital quality for any designer.

**Preparing for the portfolio review is key**. While interviewing I often found myself nervously rushing through each project in my portfolio. Having a list of talking points prevented me from skipping over any important items and forced me to slow down.

Your list of talking points should shed more light on the specific design process for each project, elaborating on what went wrong and what went right. Reflect deeply on each piece you plan to present. Write down everything you can remember about the design process. Ask a friend to mock interview you. Prepare, prepare, prepare!

If the portfolio review goes well, it’s on to the design exercise.

The typical design exercise follows this pattern:

_Please design an interface/object/product that does X or solves Y._

Its on-the-spot nature can make the design exercise intimidating. Where the portfolio review fleshed out your past design processes, the design exercise asks that you flex your design chops right here, right now.

Some exercises I’ve encountered:

*   Design a web form that collects only high-quality phone numbers. That is, if you called the phone numbers, someone would receive the call.
*   Design the homepage for a search engine.
*   Brainstorm products you could design using the Kindle’s e-reader screen material.

Every designer has their own design process, so I can’t exactly tell you how to go about the design exercise. But I’d suggest thinking about who you’re designing for, quickly sketching out many different options, and analyzing the tradeoffs of each option as you go. Don’t dive too deeply into the interaction or visual details of any one option before completing a thorough high-level exploration.

I was once asked to design a mobile app that made it easy for restaurant customers to split the bill. The exercise started well. I quickly sketched one design option where the waiter enters the items on the receipt. Then another option where the customer enters the data by hand. But before finishing the high-level exploration, I became married to this option, diving too far into the details (what would the layout be? how would the typography work?)

I wasted my time on the visual details and as a result, I didn’t have enough time to explore other types of solutions (e.g. using the customer’s smartphone to take a picture of the receipt). The week after that interview I received a rejection from the recruiter. But looking back, it taught me a valuable lesson about the design exercise: the interviewer cares much more about your high-level idea explorations than your pixel-level ambitions.

<figure score="-12.5">

<div score="6.25">![](/images/loading.png)</div>

<figcaption>Don’t get caught up in the visual design details before thinking deeply about the bigger picture. Comic credit: Andrew Hwang</figcaption>

</figure>

In the design exercise it’s crucial to **demonstrate your idea generation skills.** So don’t be afraid to come up with some crazy blue-sky ideas. Ask your interviewer questions. Don’t assume anything. And remember, brainstorming and analyzing high-level feature ideas is much more meaningful than exploring a bunch of different button styles.

Thankfully, the high-pressure design exercise is not part of every interview loop. You might be tasked with the app critique instead.

Pick an app. Any app. Make sure it’s an app you know well.

The app critique is intended to analyze your product thinking skills. You’ll walk the interviewer through an app of your choice. Along the way, the interviewer will stop you and ask questions such as:

*   What audience do you think this app was intended for?
*   What problem is the app supposed to solve?
*   How well does it solve the problem?
*   What are your favorite features on the app, and why?
*   What are your least favorite features on the app? Why?
*   Why do you think the designers made decision X?
*   What is the point of feature Y? What value does it add?
*   How would you improve the app?
*   Who are the app’s competitors?
*   What does the app do better than its competitors? What does it do worse?

Strategizing for the app critique is hard because it relies so heavily on your product intuition. The best advice I can give is to practice analyzing apps at a high level. Forget about the colors, the typography, the buttons. Instead, think about **what value the app provides**. And **how features in the app align with the app’s overall value proposition**. Snapchat, for example, strives to be _the_ app for live sharing with friends. So they built awesome features like Live Snapchat stories for major events and Live Video in direct message threads.

Product design interviews are hard. They’re stressful, and open-ended, and you can receive rejection after rejection with no idea what you’re doing wrong.

But interviewing for product design internships is like any other skill. With time and practice, you improve. It never hurts to interview for a few companies you have no intention of working at, just to practice your interviewing skills.

Have notes prepared before you start each interview. Especially the portfolio review. I found it extremely helpful to write down a list of talking points for each project. This list prevents you from nervously skipping over any important items.

Last but not least, the design community is small and tight-knit and people are more than willing to help if you can just find the courage to ask.

</div>

</div>

</section>

</div>

</div>
