>* 原文链接 : [101 Ways to Make Your Website More Awesome](https://medium.freecodecamp.com/101-ways-to-make-your-website-more-awesome-79c934dd2a11#.enfq945da)
* 原文作者 : [Nicholas Tart](https://medium.freecodecamp.com/@wntart)
* 译文出自 : [掘金翻译计划](https://github.com/xitu/gold-miner)
* 译者 : [达仔](https://github.com/zhangjd)
* 校对者: [jamweak](https://github.com/jamweak)、[cyseria](https://github.com/cyseria)

# 让你的网站更炫酷的一些小 tips

上周，我和一位老客户聊天，她说：“尼克，我觉得我的网站需要改进，但我不能确定我具体需要做什么。”

然后我就去问了一圈，包括朋友、家人和其他非互联网行业的商务人士，他们都提到了相同的观点：


> “我需要一个检查清单，因为我不知道怎样建站，这也是我要雇人来做这件事情的原因。但是我依然需要知道这个过程涉及到哪些方面。”

因此，我列了一个我们在 [AwesomeWeb](https://awesomeweb.com/) 上完成的优化清单（以及一些我们还没完成的）。

我敢保证:

如果你能把列表的每一项问题都改好，你将会拥有业界里最好的网站之一。

_你是怎么知道的？_

在 AwesomeWeb 里，我已经评估过 1,000 多个自由职业者。据我所了解的情况，我从没见过一个网站可以把所有选框都打上勾的。

对于企业老板，根据这个列表，你可以了解到接下来可以做哪些改进工作，然后把它发给你的设计或者开发去修改。你甚至还可以自己去修复其中的一部分问题。

对于自由职业者，使用这个列表可以让你做出更加酷炫的内容，然后回去找你的老客户们，对他们说：

“我重新回顾了之前的项目，我们可以修复这里、这里和这里，给我 $500, $1000, $5000 然后你可以期待得到以下的改进结果……”

重点是…

…我希望可以帮你构造出更加酷炫的网站。事不宜迟，现在进入正题，开始介绍这个列表：


### 酷炫的品牌

1. 挑选一个 `专业的 logo`，现在很难找到一个带有很棒的 logo 的网站或者博客，因此这是一个瞬间获取信任感的好方法。
2. 上传一个 `支持 retina 屏幕的 favicon` (在浏览器标签上显示的正方形小图标)。大部分网站的 favicon 都是 16x16 像素的，在 retina 屏幕会显得模糊。使用 [X-Icon Editor](http://www.xiconeditor.com/) 生成 64x64 像素大小的 favicon。
3. 使用 `支持 retina 屏幕的图片`。这很简单，只需要确保图片宽高是容器的两倍，然后显示时缩放就可以了。
4. `最多使用 2-3 种颜色`。包括背景色、文字-动作颜色和强调色。
5. 选择调色板时，从 `互补色或者三色组`（complementary or triad colors）开始选择，然后再进行调整。好的颜色组合会给你带来充满故事感的设计。
6. `不要使用纯黑色` (#000000)。纯黑色是不存在的，所以在网上使用纯黑色看起来不合适。实际上，黑色应该总是作为其它颜色的深色阴影。
7. `不要使用浅灰色` (比如 #cccccc)。如果你希望设计更显个性化，可以试着添加一点黄色显得温暖，添加红色给予能量，而蓝色产生信任。

### 酷炫的排版

1. 挑选一种 `优质的字体`。使用 [Typekit](https://typekit.com/) 之类的服务吧。据说多达 95% 的网站都是有排版的，想要产生良好的第一印象，使用优质字体是最简单、成本最低的方法。
2. `最多使用 2-3 种字体`。使用更多字体会显得杂乱，并且减慢加载时间。挑选一种字体用在头部，一种用在段落中，如果有需要的话，还可以挑选一种用在其它特殊情况里。
3. 设置 body 的字体大小为 `最小 16px`，更小的字体在大屏幕中不方便阅读，如果是移动端页面可以考虑的最小值为 12px。
4. 设置 `排版缩放比例`，就像（乐理中有）增四度，纯五度音程或者（在绘画使用）黄金比例。根据比例来设置段落文本大小，以及 H4, H3, H2 和 H1 标签。当然，文本的行高和间距也要基于这个比例。
5. 设计其它的 `排版元素`，包括引用、符号列表、数字编号列表、表格标题、帮助文本、警告框、高亮文本、代码示例、缩写甚至地址。
6. 选择一种 `自定义图标字体`，比如 [Font Awesome](https://fortawesome.github.io/Font-Awesome/)，来代替图片和其它一些元素，比如社交媒体 logo、导航按钮、交互图形等。图标字体的加载速度更快，可以任意缩放，并且可以随意更改图标颜色。

### 酷炫的布局

1. 使用 `三分法` 来设计基本布局。水平垂直把布局划成三等分，然后当线段横穿时，设法对齐关键的焦点。
2. 使用一个网格系统来维护 `垂直方向的网格`。把你的布局分隔成 8 列、12 列或者 16 列的布局，列与列之间带有足够空白。
3. 使用 `基线网格` 保持垂直方向的调和感。文本行之间的空间，和内容块之间的空间都同样重要。每行文本应该都拥有一定的底部外边距，也就是位于基线的地方。
4. `空白` 是奢侈的。空格的存在是为了创造呼吸空间和平衡，你应该把读者的眼球吸引到重要的地方去。
5. `均衡摆放视觉元素`，比如按钮、输入框、表单和大标题等。你应该把眼睛眯起来，试着跟踪那些你想让用户关注到的路径点。

### 酷炫的用户界面

1. 使用大大的加粗的 `行为按钮`。每个页面应该只有一个目标，而且几乎都是点击一个按钮而已。所以确保这个按钮不会被用户忽略。
2. 添加 `鼠标悬停 (hover) 和鼠标点击 (active) 状态` 的样式给链接、按钮、输入框和文字区域。如果你选择在鼠标悬停时让按钮颜色变亮，那你也应该对于链接和输入框边框给出同样的样式。
3. 保持 `表单样式` 的一致性。所有的文本区域和输入框都应该有相同的样式。包括相同的边框颜色、背景颜色、悬停状态、点击状态、占位符文字、点击状态文字等。确保 tabindex 属性的正确设置，以便用户可以使用 tab 键在表单项之间用正确的顺序切换。
4. 改变 `已经点击过的链接` 的颜色，让用户知道他们已经去过那个页面了。
5. 一旦你拥有了自己的 logo、颜色、排版、布局和图像大小，你要建立一个 `风格指南`。好的用户界面应该使用风格一致的组件，其样式应该总是相同的。

### 酷炫的用户体验

1. 在按钮和其它表单域元素使用 `微交互（microinteractions）`。比如，点击上传按钮之后，提示文字可以变为 “正在上传” 或者 “处理中”。
2. `不要使用 scroll jacking` （译注：通过重新定义鼠标滚动速度、幅度达到控制可视区域视觉效果的方式）！不要打乱浏览器的默认行为，虽然你可能会觉得让滚动速度变成原来的两倍很不错，但事实并非如此。
3. `放弃使用首页轮播`。轮播会减少转化率，可以考虑使用更佳的方法来在有限空间显示更多信息。
4. `不要使用欢迎界面`。当用户第一次打开首页时，用户希望能直接看到首页内容。
5. 使用 `标题、副标题、头段落、列表、表格标题` 让你的内容更容易被检索。大部分人在浏览网页前，都会先检索一遍全文，再决定是否阅读。
6. 添加 `描述性的占位符文字` 到你的表单、输入框和下拉菜单。如果你想要让浏览者用某种特定方式来填写表单，你应该指引他怎么做。对于下拉菜单和选择框来说，可以让第一个选项变成描述，比如 “选择年份” 就比 “2016” 更合适。
7. 往表单添加 `HTML5 验证`，让用户在提交表单时可以清楚地知道哪些部分出现填写错误。
8. 通过避免含糊链接名字、减少杂乱排版、使用标点符号、保持简洁布局、添加图片提示（alt text）、使用大字号、保持文本和背景色的高对比度，可以让你的网站 `适用于视觉障碍人群`。
9. 通过 [BrokenLinkCheck.com](http://brokenlinkcheck.com/) 检查你的网站是否有 `损坏的链接`。修复这些坏链，避免让用户因为点击到它们而抓狂。

### 酷炫的开发

1. 确保你的站点是经过 `移动端优化` 的，也就是在任何设备上都可以响应式地显示。合理优化移动端的站点，加载速度更快，排行更高，并且可以提供更佳的用户体验。
2. 生成并 `显示经过优化的图像`。假设你上传了一张大图片，比如博文的特征图像，如果你想在站点的其他地方显示（比如侧边栏），应确保你在侧边栏显示的是图像的缩略图而非原图。
3. `所有图片和超链接都要添加 alt 和 title 属性`。当遇到某种异常情况，图片没有正常加载出来的时候，网站应该在图片位置显示替换文字（alt text）。并且，当鼠标悬停在链接时，浏览器应该显示该链接的 title 属性的值。
4. 使用 `<strong>` 和 `<em>` 标签代替 `<b>` and `<i>`，以输出加粗和斜体字符。虽然他们的作用相同，但是有着根本区别。`<b>` 标签对应着一种样式，而 `<strong>` 标签则是一种语义化的表示，指明了应该如何理解这个标签的含义。
5. `去除多余的 HTML`。当你复制粘贴内容到 WYSIWYG 编辑器（类似于 WordPress 的编辑器）的时候，它会添加许多不必要的 span 标签与内联样式。时间长了，你的网站代码就会变得不可读了。
6. 说到这里，需要给你的 HTML `移除内联样式`。99% 的样式规则都应该写进 CSS 文件，以便你可以在同一时间更新一个组件在所有页面的样式。
7. 使用 `Sass 变量` 代替原生 CSS，以保持颜色和其他组件可以在整个网站之间共用。这样，当你想要改变这个颜色时，只需改变一行代码而不是上百行。
8. `链接使用永久链接（permalinks）代替完整 URL`。当你打算切换域名时，你的链接最好使用 <a href=“/slug-goes-here”> 代替完整路径 <a href=“http://domain.com/slug-goes-here”>。对于一些图片资源和 CSS 背景，如果你不这么做，当域名变化的时候，你的所有资源都将会失效。
9. 开发一个 `自定义插件` 或者工具，为你的网站提供独特的功能。虽然自定义软件难以维护，但是这样做可以让你的网站在众多类似网站中脱颖而出。
10. 测试 `跨浏览器兼容性`，确保你的网站可以在 Chrome, Firefox, Safari, Internet Explorer 和其它浏览器正常显示。虽然旧版 IE 在兼容性方面臭名昭著，但是可以通过 [BrowserStack](https://www.browserstack.com/screenshots) 进行人工检查。
11. 使用 [W3C 的](https://validator.w3.org/) `Markup Validation Service（标记语言验证服务）` 来检查 HTML 的明显错误。要记住，大部分网站的 HTML 都不是十分完善的。虽然这项检查并非最高优先级，但是如果你的 HTML 没有错误，你会感到更开心。
12. 设定一个 `模拟环境` 用来改变你的当前网站。理想情况下，你应该有一个生产环境，是用户能看见的；以及一个模拟环境，供开发者作出更改。一旦更改已经准备好发布，就可以把模拟环境的代码部署到生产环境。
13. `在页面显示当前年份`。当你看见一个站点的 copyright 年份不是最新的时候，你就会觉得这个网站应该很久没维护了。可以使用 PHP 或者类似的脚本语言，动态地显示当前年份，而不仅仅是显示静态文本。（比如 © <established year> — <current year>）。

### 酷炫的搜索引擎优化

1. `为每个页面选择一个关键词`，这个关键词关系到你的页面排名。围绕这个关键词，优化这个页面的方方面面。当然，并不是让你在每句话都提到这个词，可以动脑筋想想你想让它排到第几位去。
2. 给每个页面设定一个充满关键词的 `title 标签`。标题会显示在谷歌搜索结果的蓝色链接文字上，有 55 个字符的长度限制。
3. 每个页面`有且仅有一个 H1 标签`。在大多数情况下，这个标签的文字应该和 title 标签相同。
4. 在页面内容中包含很多 `H2、H3 和 H4 标签` ，以创建小标题和显出视觉层次感。
5. 用一个 `特定的关键词` 优化页面，可以通过把它包含在标题、H1、副标题和内容的前 1/3 部分。
6. 你的 `meta 标签的描述（description）` 会显示在搜索引擎的链接下方。所以确保你的每个页面都包含 meta description，并确保在描述里包含关键词。
7. 你的 `永久链接（permalink）`，也就是 URL 里紧随域名的部分（比如 domain.com/permalink-here/），应该包含破折号分隔开的关键词内容。
8. Google 把 `域名的注册时长` 考虑到算法中，他们认为，注册时间长的域名更有可能提供高质量的资源。提前注册你的域名吧，如果你的域名注册时间超过 10 年，相信你对你的事业是认真的。
9. 平均起来，SERP (搜索引擎结果页面) 的第一个结果，不管是任何关键词，打开的页面都不少于 `2000 字/页`。当你写文章或者创建页面时，如果你希望页面的排名更高，试着至少写 2000 字吧。
10. 总是 `创建站点地图` 并命名为 sitemap.xml 文件，然后把它放进根目录，并让文件可以通过 domain.com/sitemap.xml 访问。这个文件可以告诉谷歌，你的所有页面的位置，并应该在添加新内容时更新地图。可以通过 [Webmaster Tools](https://www.google.com/webmasters/tools/home?hl=en) 提交给谷歌。
11. 添加你的网站的 `Google Webmaster Tools`，然后你可以知道 Google 如何索引你的站点，并在遇到关键问题时保持更新。
12. 为了提高图片的排行，上传之前应该总是 `重命名你的图片` 和其它文件。（比如：rank_for_this_keyword_phrase.png）
13. 在站点中包含 `robots.txt` 文件，告诉爬虫哪些页面应该/不应该被索引。
14. 添加 `canonical 重定向` 把不带 www 的页面访问指向网站的 www 版本，或者反过来也可以。
15. 研究并整合每个页面的 `LSI 关键词`（LSI: 潜在语义索引），以帮助提高页面在主关键词的排行。通过 Google 搜索一些关键词短语并寻找 “相关搜索” 链接，可以帮你找出 LSI 关键词。
16. 经常确保 `你的内容之间可以互相连接`。你的站点的每个页面，都应该可以通过从首页开始的不多于三次点击访问到。
17. 添加 `结构化的数据` 到相关页面，以帮助 Google 合理索引你的内容。以下这些页面类型需要结构化的数据，包括：人物、产品、事件、公司、电影、书本、报刊评论等。使用 [Schema Creator](http://schema-creator.org/) 可以帮你生成结构化的数据。
18. 使用 [Google 的](https://developers.google.com/speed/pagespeed/insights/) `PageSpeed Insights` 工具，以确保你修复了所有可能降低页面速度的普遍问题。页面加载速度越快，排名越高。

### 酷炫的网页速度

1. 保持 `页面流量低于 2MB`。使用 [tools.pingdom.com](http://tools.pingdom.com/) 检查主页面的加载流量，如果多于 2MB 说明内容太多了。
2. 保持 `页面请求低于 50 个`。页面中的每个文件和图片都是一个 HTTP 请求，请求数越少，加载速度越快。平均每个网页的请求数是 70 个。使用 [GTmetrix](https://gtmetrix.com/) 可以检查你的网页请求数。
3. 设计页面元素时，使用 `CSS 代替背景图片`。不要使用图片来显示按钮、表单或者其它通用的元素。CSS 的加载速度更快，并且在响应式布局中更加灵活。
4. 在图片上传之前 `优化图像`。比如 [TinyPNG](https://tinypng.com/) 这样的工具，可以帮助你在不降低分辨率或者图像质量的情况下，减少图片文件大小。
5. 使用 `内容分发网络（Content Delivery Network）` 来存储你的图片和其它大文件，并放在世界上的不同区域中。CDN 通过策略定位好的服务器，存储分发你的文件，可以最大化加速页面速度，当然加载速度也根据访客的所在地区而有所差别。
6. 在上传你的代码文件到服务器之前，通过编译和压缩工具，`最小化 JavaScript, HTML 和 CSS`。对于 JavaScript，可以使用 [Closure Compiler](https://developers.google.com/closure/compiler/)。对于 HTML，可以使用 [HTML Minifier](http://www.willpeavy.com/minifier/)。对于 CSS，可以使用 [YUI Compressor](http://yui.github.io/yuicompressor/)。
7. 把 `阻塞渲染的 JavaScript 移动到底部`。唯一应该放在头部的脚本是那些会立刻影响页面设计的内容（比如：自定义字体）。
8. `避免目标网页重定向`。重定向触发额外的 HTTP 请求，会延迟页面渲染。
9. 借助 `浏览器缓存`，可以通过为页面和不经常更新的资源设置过期时间来实现。浏览器缓存会通知浏览器，从本地磁盘加载之前下载过的页面，以减少不必要的网络请求。
10. 在服务器配置中启用 `gzip 压缩`。压缩可以减少多达 90% 的传输响应时间，大大减少了首次渲染页面的时间。
11. 在服务器配置中启用 `Keep-Alive`，以允许同一个 TCP 链接可以发送和接收多个 HTTP 请求，因而可以减少后来请求的延迟。
12. 升级为 `专用服务器` 或者更优质的主机服务，以降低服务器响应时间。当你使用共享的服务器环境时，你的站点通常放在一台需要同时响应至少上百个网站的服务器里，如果其它网站的流量很大，你的网站速度自然就会降低。

### 酷炫的平面设计

1. 作为可选的加分项，使用 `自定义 ebook 封面`。它不难创建，但是可以让你的转化率大大提高。
2. 为你的主页和销售页面设计一个 `自定义的平面图形或者插图`。一个专门为站点设计的好插图，可以让你的站点更加容易让人记住。
3. 创建一个或者一系列的自定义 `博客特征图像设计`。也就是你在 Facebook, Twitter, Pinterest 等社交网站传播时使用的图片。当用户看到和博客有所关联的某类型的图片时，他们会联想到文章可能是你写的。
4. 给你自己和你的团队的每个成员显示一张自定义的 `头像插图或者漫画`。相比于聘请专业的摄影师，自定义的漫画成本较低，特别是当你的团队增加新成员的时候。此外，对于新成员来说这也是一份不错的礼物。
5. `自定义图表` 以可视化的方式显示数据和其他内容，相比于同类的博客文章，更容易获取更多流量。人们更喜欢在 Pinterest 这样的网站上分享图表，或者是带着你的站点的反向链接并转发到他们自己的网站上。
6. 如果你创作了一个甚至一系列的视频，你应该拥有一个 `定制的视频开场部分和/或结尾部分`，让大家感受到视频是专业的。不要提及其它的视频画面或者动画，可以帮助你的品牌更加突出。

### 酷炫的 Web 安全性

1. 安装 `SSL 证书`，以允许服务器端和浏览器之间建立安全连接。如果网站用到银行卡支付功能，大部分的检测软件都要求使用 SSL 证书。Google 称，用上 SSL 证书可以帮助提高网站的搜索排行。
2. 你用到的软件和插件要 `保持最新版本`。Wordpress 和其它 CMS 软件都会释放更新，通常是为了修复漏洞。如果你没有及时更新，你的网站被攻击也就是迟早的事情了。
3. 为管理员页面设置 `双认证登录`。大部分的黑客入侵都是从登录页开始的。
4. 检查并 `删除恶意软件`。如果你的网站曾经被入侵，黑客很可能会留下一些不容易发现的后门。如果你没有及时删除，你的网站可能会被谷歌列入黑名单，大大降低你的网站排行，并在用户打开网站时，警告用户离开。
5. 不要把 `管理员账号` 称为 “admin”。删除默认的管理员账号，并创建一个使用其他名字的新账号。
6. 定期 `备份数据库和网站文件`。大部分备份软件和插件都只备份你的数据库，里面包括了数据和内容。但如果你把整个网站都丢了，你还需要文件内容的备份来还原网站。

### 酷炫的内容

1. 创建一个自定义 `错误 404` 页面，当用户尝试访问不存在的地址时，这个页面就会显示出来。可以使用 404 页面把他们引导到首页，并帮助他们寻找他们想要的页面。
2. 除了主页之外，`关于页面` 可能是用户最常访问的页面了。要确保这个页面能够很好地代表你和你的公司。
3. `联系方式页` 帮助用户找到你，而且还能够建立你和访客甚至 Google 之间的信赖。当决定站点排名时，机器会寻找你的联系方式，然后找到邮箱地址、电话号码和地址。联系信息告诉 Google，这个站点更加值得信赖一点。
4. 在战略上，站点里拥有选填的表单是正确的，然而建立一个 `准顾客收集页面` 的想法也不错，除了一个高转化率的选填表格什么也不用放。当你希望用户提交信息时，链接到该页面就行了。
5. 当用户订阅你的列表时，确保你可以给他们一个 `确认页面`，让他们可以确认邮箱地址。假如用户不能确认邮箱是否正确，他们可能就会把事情给忘了，然后再也不会回来你的站点了。
6. 在点击邮箱里的确认链接后，给用户发送一个 `感谢页面` 让他们知道下一步可以做什么。这个页面是每个订阅者都能看见而且只能看见一次的，因此这是一个绝佳机会鼓励用户去掏腰包购买内容。
7. 你的网站或者主题应该有一个 `着陆页` 模板，当你需要用户进行特定操作时，可以用上。
8. 如果你在网站上买东西，确保你有一个漂亮的 `销售页面`。从大字标题开始；为你的卖场留出足够空间；有可能的话做一个介绍视频；在页面底部指引用户如何购买。

### 酷炫的社交媒体

1. 在你的文章和页面上，限制 `社交媒体按钮的数量`，因为每个按钮都会运行相关的脚本，额外增加页面加载时间。通常包含 1-5 个按钮比较合适，比如 Facebook、Twitter、LinkedIn、Pinterest、Google+ 等，这些网站是你的内容最容易被分享的地方。
2. 在你的 Facebook 页面、Twitter 账号、YouTube 频道上创建 `社交媒体的图片`。对于第一次访问的用户，自定义的图片可以给予他们良好的第一印象，并鼓励他们点赞、关注、订阅你的页面、个人档和频道。
3. 设置 `Facebook Open Graph META 标签` 以确保你的内容被分享到 Facebook 时可以正常显示内容。可以使用 [Facebook Debugger](https://developers.facebook.com/tools/debug/) 检查你的主页、文章和其它页面，并看到当别人把 URL 分享出去的时候是什么样子的。
4. 设置 `Twitter Cards`，目的是当你的站点 URL 被分享到 Twitter 时，丰富的图片和视频资源可以显示到卡片上。要开始使用 `Twitter Cards` 可以 [点击这里](https://dev.twitter.com/cards/getting-started)
5. 设置 `Google+ Snippets`，以自定义用户分享站点到 Google+ 时看见的内容。你可以使用 [Snippet 指南](https://developers.google.com/+/web/snippet/) 生成相关代码。即使你的网站在 Google+ 没那么受欢迎，Google 也可以知道你正确地添加了 meta 信息，从而带来一定的权重加成。
6. `弱化那些链接到个人档的社交媒体图标`，可以让图标变小或者放在页面底部。其实社交媒体营销的目的就是把用户导流到你的网站来，而不是反过来作用。


好了，我还有什么遗漏的吗？作为自由职业者或者老板，你有没有尝试过使用上述方法让网站变得酷炫呢？

期待你的回复，可以在原文留言或者在推特上联系 [@wntart](https://twitter.com/wntart)。

如果你希望更多人看见这个列表，不妨推荐这篇文章给大家。让我们一起把网站变得更加酷炫！

加油！尼克

  P.S. 如果你需要有人帮忙完成列表上的事情，可以在这里寻找[设计师](https://www.awesomeweb.com/skill/web-design)、[开发者](https://www.awesomeweb.com/skill/web-development)，或者[发布你的招聘广告](https://www.awesomeweb.com/why-post-a-job)。我们拥有世界上最好的自由职业者，他们非常乐意帮助你！

如果你也希望加入 AwesomeWeb 成为一名自由职业者，并认识更多客户，可以[点击这里注册](https://www.awesomeweb.com/signup)。

