-- MySQL Script generated by MySQL Workbench
-- Sat May 11 09:03:36 2024
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema text_mining
-- -----------------------------------------------------
DROP SCHEMA IF EXISTS `text_mining` ;

-- -----------------------------------------------------
-- Schema text_mining
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `text_mining` DEFAULT CHARACTER SET utf8 ;
SHOW WARNINGS;
USE `text_mining` ;

-- -----------------------------------------------------
-- Table `matches`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `matches` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `matches` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `token_id` INT UNSIGNED NOT NULL,
  `source_id` INT UNSIGNED NOT NULL,
  `scan_time` DATETIME NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB
COMMENT = 'table data of word token matched in given text source';

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `matches` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE UNIQUE INDEX `unique_index` ON `matches` (`token_id` ASC, `source_id` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `source_index` ON `matches` (`source_id` ASC) VISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `text_data`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `text_data` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `text_data` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `source_id` INT UNSIGNED NOT NULL,
  `paragraph_id` INT UNSIGNED NOT NULL,
  `sentence_id` INT UNSIGNED NOT NULL,
  `text` MEDIUMTEXT NOT NULL COMMENT 'a sentence text',
  `add_time` DATETIME NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `text_data` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `text_source` ON `text_data` (`source_id` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `paragraph_index` ON `text_data` (`paragraph_id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `sentence_index` ON `text_data` (`sentence_id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE UNIQUE INDEX `unique_reference` ON `text_data` (`source_id` ASC, `paragraph_id` ASC, `sentence_id` ASC) VISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `text_graph`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `text_graph` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `text_graph` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `from` INT UNSIGNED NOT NULL,
  `to` INT UNSIGNED NOT NULL,
  `weight` DOUBLE UNSIGNED NOT NULL DEFAULT 0,
  `count` INT UNSIGNED NOT NULL DEFAULT 0,
  `add_time` DATETIME NOT NULL DEFAULT now(),
  PRIMARY KEY (`id`))
ENGINE = InnoDB;

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `text_graph` (`id` ASC) VISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `text_source`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `text_source` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `text_source` (
  `id` INT UNSIGNED NOT NULL COMMENT 'the text source id',
  `reference` MEDIUMTEXT NOT NULL COMMENT 'the url reference or doi reference',
  `title` VARCHAR(2048) NOT NULL,
  `publish_date` DATETIME NOT NULL,
  `add_time` DATETIME NOT NULL DEFAULT now(),
  `note` MEDIUMTEXT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `token_class`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `token_class` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `token_class` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'the class vocabulary id',
  `class` VARCHAR(255) NOT NULL COMMENT 'the token class vocabulary',
  `add_time` DATETIME NOT NULL DEFAULT now(),
  `note` MEDIUMTEXT NULL COMMENT 'description note about the current token class',
  PRIMARY KEY (`id`))
ENGINE = InnoDB
COMMENT = 'the token class vocabulary table';

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `token_class` (`id` ASC) VISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `word_token`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `word_token` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `word_token` (
  `id` INT UNSIGNED NOT NULL,
  `token` VARCHAR(1024) NOT NULL,
  `count` INT NOT NULL,
  `class` INT UNSIGNED NOT NULL DEFAULT 1,
  `add_time` DATETIME NOT NULL DEFAULT now(),
  PRIMARY KEY (`id`))
ENGINE = InnoDB
COMMENT = 'A word token in a given text segment';

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `word_token` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE UNIQUE INDEX `token_UNIQUE` ON `word_token` (`token` ASC) VISIBLE;

SHOW WARNINGS;

SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
