-- MySQL Script generated by MySQL Workbench
-- Mon Sep 23 08:31:33 2024
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema pubmed
-- -----------------------------------------------------
DROP SCHEMA IF EXISTS `pubmed` ;

-- -----------------------------------------------------
-- Schema pubmed
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `pubmed` DEFAULT CHARACTER SET utf8 ;
SHOW WARNINGS;
USE `pubmed` ;

-- -----------------------------------------------------
-- Table `articles`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `articles` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `articles` (
  `id` INT UNSIGNED NOT NULL COMMENT 'the pubmed id',
  `authors` MEDIUMTEXT NULL,
  `title` VARCHAR(512) NOT NULL,
  `journal` VARCHAR(255) NOT NULL,
  `doi` VARCHAR(64) NULL COMMENT 'the doi reference of this article',
  `year` INT UNSIGNED NOT NULL COMMENT 'published year',
  PRIMARY KEY (`id`))
ENGINE = InnoDB;

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `articles` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `search_doi` ON `articles` (`doi` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `filter_year` ON `articles` (`year` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `search_journal` ON `articles` (`journal` ASC) VISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `fulltext`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `fulltext` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `fulltext` (
  `id` INT UNSIGNED NOT NULL COMMENT 'the pubmed id',
  `abstract` MEDIUMTEXT NULL,
  `fulltext` LONGTEXT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `fulltext` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE FULLTEXT INDEX `full_text1` ON `fulltext` (`abstract`) INVISIBLE;

SHOW WARNINGS;
CREATE FULLTEXT INDEX `full_text2` ON `fulltext` (`fulltext`) VISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `mesh`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `mesh` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `mesh` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `mesh_id` VARCHAR(45) NOT NULL,
  `term` VARCHAR(255) NOT NULL COMMENT 'the pubmed mesh term',
  `category` VARCHAR(128) NULL,
  `db_xref` VARCHAR(64) NULL COMMENT 'the external database reference id of current mesh term',
  `db_name` VARCHAR(45) NULL COMMENT 'the  name of the external database',
  `add_time` DATETIME NOT NULL DEFAULT now(),
  `description` LONGTEXT NULL COMMENT 'the description text of current mesh term',
  PRIMARY KEY (`id`))
ENGINE = InnoDB;

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `mesh` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `search_term` ON `mesh` (`term` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `search_external` ON `mesh` (`db_name` ASC, `db_xref` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `sort_time` ON `mesh` (`add_time` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `find_term_by_id` ON `mesh` (`mesh_id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `filter_class` ON `mesh` (`category` ASC) INVISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `metadata`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `metadata` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `metadata` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `pubmed_id` INT UNSIGNED NOT NULL,
  `mesh_id` INT UNSIGNED NOT NULL,
  `add_time` DATETIME NOT NULL DEFAULT now(),
  PRIMARY KEY (`id`))
ENGINE = InnoDB
COMMENT = 'metadata of an article that related to';

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `metadata` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `article_metadata_idx` ON `metadata` (`pubmed_id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `mesh_term_data_idx` ON `metadata` (`mesh_id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `check_graph` ON `metadata` (`pubmed_id` ASC, `mesh_id` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `sort_time` ON `metadata` (`add_time` ASC) VISIBLE;

SHOW WARNINGS;

SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
