-- MySQL Script generated by MySQL Workbench
-- Mon Dec  4 09:24:43 2023
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema graphQL
-- -----------------------------------------------------
DROP SCHEMA IF EXISTS `graphQL` ;

-- -----------------------------------------------------
-- Schema graphQL
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `graphQL` DEFAULT CHARACTER SET utf8 ;
SHOW WARNINGS;
USE `graphQL` ;

-- -----------------------------------------------------
-- Table `graph`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `graph` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `graph` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `from_node` INT UNSIGNED NOT NULL COMMENT 'the unique id of the knowledge data',
  `to_node` INT UNSIGNED NOT NULL COMMENT 'the unique id of the knowledge data',
  `link_type` INT UNSIGNED NOT NULL COMMENT 'the connection type between the two knowdge node, the enumeration text string value could be found in the knowledge vocabulary table',
  `weight` DOUBLE UNSIGNED NOT NULL DEFAULT 0 COMMENT 'weight value of current connection link',
  `add_time` DATETIME NOT NULL DEFAULT now() COMMENT 'the create time of the current knowledge link',
  `note` TEXT NULL COMMENT 'description text about current knowledge link',
  PRIMARY KEY (`id`))
ENGINE = InnoDB
COMMENT = 'the connection links between the knowledge nodes data';

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `graph` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `source_index` ON `graph` (`from_node` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `target_index` ON `graph` (`to_node` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `term_index` ON `graph` (`link_type` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `node_data_idx2` ON `graph` (`to_node` ASC, `from_node` ASC) VISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `hash_index`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `hash_index` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `hash_index` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `synonym` TEXT NOT NULL,
  `hashcode` CHAR(32) NOT NULL COMMENT 'tolower(md5(tolower(synonym)))',
  `map` INT UNSIGNED NOT NULL COMMENT 'the synonym id mapping to the knowledge data term',
  `add_time` DATETIME NOT NULL DEFAULT now(),
  PRIMARY KEY (`id`))
ENGINE = InnoDB
COMMENT = 'the synonym list of the knowledge data';

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `hash_index` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `hash_map` ON `hash_index` (`hashcode` ASC) VISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `knowledge`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `knowledge` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `knowledge` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'usually be the FN-1a hashcode of the \'key + node_type\' term',
  `key` CHAR(32) NOT NULL COMMENT 'the unique key of current knowledge node data, md5 value of the lcase(key)',
  `display_title` VARCHAR(4096) NOT NULL COMMENT 'the raw text of current knowledge node data',
  `node_type` INT UNSIGNED NOT NULL COMMENT 'the node type enumeration number value, string value could be found in the knowledge vocabulary table',
  `graph_size` INT UNSIGNED NOT NULL DEFAULT 0 COMMENT 'the number of connected links to current knowledge node',
  `add_time` DATETIME NOT NULL DEFAULT now() COMMENT 'add time of current knowledge node data',
  `knowledge_term` INT UNSIGNED NOT NULL DEFAULT 0 COMMENT 'default zero means not assigned, and any positive integer means this property data has been assigned to a specific knowledge',
  `description` LONGTEXT NOT NULL COMMENT 'the description text about current knowledge data',
  PRIMARY KEY (`id`))
ENGINE = InnoDB
COMMENT = 'knowlege data pool';

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `knowledge` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `key_index` ON `knowledge` (`key` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `type_index` ON `knowledge` (`node_type` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `find_key` ON `knowledge` (`key` ASC, `node_type` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `sort_count` ON `knowledge` (`graph_size` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `sort_time` ON `knowledge` (`add_time` ASC) VISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `knowledge_cache`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `knowledge_cache` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `knowledge_cache` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `seed_id` INT UNSIGNED NOT NULL,
  `term` VARCHAR(4096) NOT NULL,
  `hashcode` CHAR(32) NOT NULL,
  `knowledge` LONGTEXT NOT NULL,
  `add_time` DATETIME NOT NULL DEFAULT now(),
  PRIMARY KEY (`id`))
ENGINE = InnoDB;

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `knowledge_cache` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE UNIQUE INDEX `seed_id_UNIQUE` ON `knowledge_cache` (`seed_id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `term_index` ON `knowledge_cache` (`hashcode` ASC) INVISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Table `knowledge_vocabulary`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `knowledge_vocabulary` ;

SHOW WARNINGS;
CREATE TABLE IF NOT EXISTS `knowledge_vocabulary` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `vocabulary` VARCHAR(1024) NOT NULL COMMENT 'the short knowledge term type',
  `hashcode` VARCHAR(32) NOT NULL,
  `ancestor` INT UNSIGNED NOT NULL DEFAULT 0 COMMENT 'the parent node of current ontology term',
  `level` INT UNSIGNED NOT NULL DEFAULT 0 COMMENT 'the level of current ontology tern node on the family tree',
  `add_time` DATETIME NOT NULL DEFAULT now(),
  `color` CHAR(7) NOT NULL DEFAULT '#123456' COMMENT 'html color code of current knowledge ontology term',
  `count` INT UNSIGNED NOT NULL DEFAULT 0 COMMENT 'hit counts in the knowledge table',
  `description` MEDIUMTEXT NULL COMMENT 'the description text value about current type of the knowledge term',
  PRIMARY KEY (`id`))
ENGINE = InnoDB
COMMENT = 'the knowledge term type, category or class data label. the word ontology class data table';

SHOW WARNINGS;
CREATE UNIQUE INDEX `id_UNIQUE` ON `knowledge_vocabulary` (`id` ASC) VISIBLE;

SHOW WARNINGS;
CREATE UNIQUE INDEX `vocabulary_UNIQUE` ON `knowledge_vocabulary` (`vocabulary` ASC) VISIBLE;

SHOW WARNINGS;
CREATE INDEX `term_index` ON `knowledge_vocabulary` (`vocabulary` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `color_index` ON `knowledge_vocabulary` (`color` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `sort_count` ON `knowledge_vocabulary` (`count` ASC) INVISIBLE;

SHOW WARNINGS;
CREATE INDEX `sort_time` ON `knowledge_vocabulary` (`add_time` ASC) VISIBLE;

SHOW WARNINGS;

-- -----------------------------------------------------
-- Data for table `knowledge_vocabulary`
-- -----------------------------------------------------
START TRANSACTION;
USE `graphQL`;
INSERT INTO `knowledge_vocabulary` (`id`, `vocabulary`, `hashcode`, `ancestor`, `level`, `add_time`, `color`, `count`, `description`) VALUES (1, 'graphQL', '1', 0, 1, DEFAULT, '#000000', 1, 'root node of the ontology tree');

COMMIT;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
