#ifndef _NTDLL_H
#define _NTDLL_H

#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NOMINMAX
#define NOMINMAX
#endif
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef WIN32_NO_STATUS
#define WIN32_NO_STATUS
#endif
#include <Windows.h>
#undef WIN32_NO_STATUS
#include <ntstatus.h>
#include <intrin.h>

#define NT_SUCCESS(Status)				((NTSTATUS)(Status) >= 0)
#define NT_ERROR(Status)				((((ULONG)(Status)) >> 30) == 3)

#define FASTCALL __fastcall

#ifndef _Reserved_
#define _Reserved_
#endif

#if defined(__clang__)
#undef FIELD_OFFSET
#undef UFIELD_OFFSET
#define FIELD_OFFSET(type, field)	((LONG)__builtin_offsetof(type, field))
#define UFIELD_OFFSET(type, field)	((ULONG)__builtin_offsetof(type, field))
#endif

#define ALIGN_DOWN(length, type) \
	((ULONG_PTR)(length) & ~(sizeof(type) - 1))

#define ALIGN_UP(length, type) \
	(ALIGN_DOWN(((ULONG_PTR)(length) + sizeof(type) - 1), type))

#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define MAX(a,b)	(((a) > (b)) ? (a) : (b))

#if !defined (_countof)
#define _countof(_Array) (sizeof(_Array) / sizeof(_Array[0]))
#endif

typedef _Return_type_success_(return >= 0) LONG NTSTATUS, *PNTSTATUS;
typedef LONG KPRIORITY, *PKPRIORITY;
typedef ULONG LOGICAL, *PLOGICAL;

typedef enum _NT_PRODUCT_TYPE
{
	NtProductWinNt = 1,
	NtProductLanManNt,
	NtProductServer
} NT_PRODUCT_TYPE, *PNT_PRODUCT_TYPE;

typedef enum _SUITE_TYPE
{
	SmallBusiness,
	Enterprise,
	BackOffice,
	CommunicationServer,
	TerminalServer,
	SmallBusinessRestricted,
	EmbeddedNT,
	DataCenter,
	SingleUserTS,
	Personal,
	Blade,
	EmbeddedRestricted,
	SecurityAppliance,
	StorageServer,
	ComputeServer,
	WHServer,
	PhoneNT,
	MaxSuiteType
} SUITE_TYPE;

typedef struct _CLIENT_ID
{
	HANDLE UniqueProcess;
	HANDLE UniqueThread;
} CLIENT_ID, *PCLIENT_ID;

enum KPROCESSOR_MODE
{
	KernelMode,
	UserMode
};

typedef enum _KTHREAD_STATE
{
	Initialized,
	Ready,
	Running,
	Standby,
	Terminated,
	Waiting,
	Transition,
	DeferredReady,
	GateWaitObsolete,
	WaitingForProcessInSwap,
	MaximumThreadState
} KTHREAD_STATE, *PKTHREAD_STATE;

typedef enum _KWAIT_REASON
{
	Executive,
	FreePage,
	PageIn,
	PoolAllocation,
	DelayExecution,
	Suspended,
	UserRequest,
	WrExecutive,
	WrFreePage,
	WrPageIn,
	WrPoolAllocation,
	WrDelayExecution,
	WrSuspended,
	WrUserRequest,
	WrEventPair,
	WrQueue,
	WrLpcReceive,
	WrLpcReply,
	WrVirtualMemory,
	WrPageOut,
	WrRendezvous,
	WrKeyedEvent,
	WrTerminated,
	WrProcessInSwap,
	WrCpuRateControl,
	WrCalloutStack,
	WrKernel,
	WrResource,
	WrPushLock,
	WrMutex,
	WrQuantumEnd,
	WrDispatchInt,
	WrPreempted,
	WrYieldExecution,
	WrFastMutex,
	WrGuardedMutex,
	WrRundown,
	WrAlertByThreadId,
	WrDeferredPreempt,
	WrPhysicalFault,
	MaximumWaitReason
} KWAIT_REASON;

typedef enum _EVENT_TYPE
{
	NotificationEvent,
	SynchronizationEvent
} EVENT_TYPE;

typedef enum _TIMER_TYPE
{
	NotificationTimer,
	SynchronizationTimer
} TIMER_TYPE;

typedef enum _WAIT_TYPE
{
	WaitAll,
	WaitAny,
	WaitNotification,
	WaitDequeue
} WAIT_TYPE;

typedef enum _SECTION_INHERIT {
	ViewShare = 1,
	ViewUnmap = 2
} SECTION_INHERIT;

#define HARDERROR_OVERRIDE_ERRORMODE		0x10000000

typedef enum _HARDERROR_RESPONSE_OPTION
{
	OptionAbortRetryIgnore,
	OptionOk,
	OptionOkCancel,
	OptionRetryCancel,
	OptionYesNo,
	OptionYesNoCancel,
	OptionShutdownSystem,
	OptionOkNoWait,
	OptionCancelTryContinue
} HARDERROR_RESPONSE_OPTION, *PHARDERROR_RESPONSE_OPTION;

typedef enum _HARDERROR_RESPONSE
{
	ResponseReturnToCaller,
	ResponseNotHandled,
	ResponseAbort,
	ResponseCancel,
	ResponseIgnore,
	ResponseNo,
	ResponseOk,
	ResponseRetry,
	ResponseYes,
	ResponseTryAgain,
	ResponseContinue
} HARDERROR_RESPONSE, *PHARDERROR_RESPONSE;

typedef struct _UNICODE_STRING
{
	USHORT Length;
	USHORT MaximumLength;
	PWSTR Buffer;
} UNICODE_STRING, *PUNICODE_STRING;
typedef const UNICODE_STRING *PCUNICODE_STRING;

#define DECLARE_UNICODE_STRING_SIZE(_var, _size) \
WCHAR _var ## _buffer[_size]; \
__pragma(warning(push)) \
__pragma(warning(disable:4221)) __pragma(warning(disable:4204)) \
UNICODE_STRING _var = { 0, (_size) * sizeof(WCHAR) , _var ## _buffer } \
__pragma(warning(pop))

#define DECLARE_STATIC_UNICODE_STRING_SIZE(_var, _size) \
WCHAR _var ## _buffer[_size]; \
__pragma(warning(push)) \
__pragma(warning(disable:4221)) __pragma(warning(disable:4204)) \
static UNICODE_STRING _var = { 0, (_size) * sizeof(WCHAR) , _var ## _buffer } \
__pragma(warning(pop))

#if defined(__clang__)
#define RTL_CONSTANT_STRING(s) \
__pragma(clang diagnostic push) \
__pragma(clang diagnostic ignored "-Wwritable-strings") \
{ sizeof(s) - sizeof((s)[0]), sizeof(s), s } \
__pragma(clang diagnostic pop)
#else
#define RTL_CONSTANT_STRING(s) { sizeof(s) - sizeof((s)[0]), sizeof(s), (PWSTR)s }
#define RTL_CONSTANT_ANSI_STRING(s) { sizeof(s) - sizeof((s)[0]), sizeof(s), (PSTR)s }
#endif

FORCEINLINE
VOID
RtlInitEmptyUnicodeString(
	_Out_ PUNICODE_STRING UnicodeString,
	_In_ PWCHAR Buffer,
	_In_ USHORT BufferSize)
{
	UnicodeString->Length = 0;
	UnicodeString->MaximumLength = BufferSize;
	UnicodeString->Buffer = Buffer;
}

typedef struct _STRING
{
	USHORT Length;
	USHORT MaximumLength;
	PCHAR Buffer;
} STRING, *PSTRING, ANSI_STRING, *PANSI_STRING, OEM_STRING, *POEM_STRING;

typedef struct _SYSTEM_SESSION_PROCESS_INFORMATION
{
	ULONG SessionId;
	ULONG SizeOfBuf;
	PVOID Buffer;
} SYSTEM_SESSION_PROCESS_INFORMATION, *PSYSTEM_SESSION_PROCESS_INFORMATION;

typedef struct _SYSTEM_KERNEL_DEBUGGER_INFORMATION
{
	BOOLEAN KernelDebuggerEnabled;
	BOOLEAN KernelDebuggerNotPresent;
} SYSTEM_KERNEL_DEBUGGER_INFORMATION, *PSYSTEM_KERNEL_DEBUGGER_INFORMATION;

typedef struct _SYSTEM_KERNEL_DEBUGGER_INFORMATION_EX
{
	BOOLEAN DebuggerAllowed;
	BOOLEAN DebuggerEnabled;
	BOOLEAN DebuggerPresent;
} SYSTEM_KERNEL_DEBUGGER_INFORMATION_EX, *PSYSTEM_KERNEL_DEBUGGER_INFORMATION_EX;

typedef struct _LDT_INFORMATION
{
	ULONG Start;
	ULONG Length;
	LDT_ENTRY LdtEntries[1];
} PROCESS_LDT_INFORMATION, *PPROCESS_LDT_INFORMATION;

typedef struct _KERNEL_USER_TIMES
{
	LARGE_INTEGER CreateTime;
	LARGE_INTEGER ExitTime;
	LARGE_INTEGER KernelTime;
	LARGE_INTEGER UserTime;
} KERNEL_USER_TIMES, *PKERNEL_USER_TIMES;

typedef struct _SYSTEM_THREAD_INFORMATION
{
	LARGE_INTEGER KernelTime;
	LARGE_INTEGER UserTime;
	LARGE_INTEGER CreateTime;
	ULONG WaitTime;
	PVOID StartAddress;
	CLIENT_ID ClientId;
	KPRIORITY Priority;
	LONG BasePriority;
	ULONG ContextSwitches;
	ULONG ThreadState;
	KWAIT_REASON WaitReason;
} SYSTEM_THREAD_INFORMATION, *PSYSTEM_THREAD_INFORMATION;

typedef struct _SYSTEM_PROCESS_INFORMATION
{
	ULONG NextEntryOffset;
	ULONG NumberOfThreads;
	LARGE_INTEGER WorkingSetPrivateSize; // Since Vista
	ULONG HardFaultCount; // Since Windows 7
	ULONG NumberOfThreadsHighWatermark; // Since Windows 7
	ULONGLONG CycleTime; // Since Windows 7
	LARGE_INTEGER CreateTime;
	LARGE_INTEGER UserTime;
	LARGE_INTEGER KernelTime;
	UNICODE_STRING ImageName;
	KPRIORITY BasePriority;
	HANDLE UniqueProcessId;
	HANDLE InheritedFromUniqueProcessId;
	ULONG HandleCount;
	ULONG SessionId;
	ULONG_PTR UniqueProcessKey; // Since Vista (requires SystemExtendedProcessInformation)
	SIZE_T PeakVirtualSize;
	SIZE_T VirtualSize;
	ULONG PageFaultCount;
	SIZE_T PeakWorkingSetSize;
	SIZE_T WorkingSetSize;
	SIZE_T QuotaPeakPagedPoolUsage;
	SIZE_T QuotaPagedPoolUsage;
	SIZE_T QuotaPeakNonPagedPoolUsage;
	SIZE_T QuotaNonPagedPoolUsage;
	SIZE_T PagefileUsage;
	SIZE_T PeakPagefileUsage;
	SIZE_T PrivatePageCount;
	LARGE_INTEGER ReadOperationCount;
	LARGE_INTEGER WriteOperationCount;
	LARGE_INTEGER OtherOperationCount;
	LARGE_INTEGER ReadTransferCount;
	LARGE_INTEGER WriteTransferCount;
	LARGE_INTEGER OtherTransferCount;
	SYSTEM_THREAD_INFORMATION Threads[1]; // SystemProcessInformation
	// SYSTEM_EXTENDED_THREAD_INFORMATION Threads[1]; // SystemExtendedProcessinformation
	// SYSTEM_EXTENDED_THREAD_INFORMATION + SYSTEM_PROCESS_INFORMATION_EXTENSION // SystemFullProcessInformation
} SYSTEM_PROCESS_INFORMATION, *PSYSTEM_PROCESS_INFORMATION;

typedef struct _PROCESS_SESSION_INFORMATION
{
	ULONG SessionId;
} PROCESS_SESSION_INFORMATION, *PPROCESS_SESSION_INFORMATION;

// File attribute values
#define FILE_ATTRIBUTE_READONLY					0x00000001
#define FILE_ATTRIBUTE_HIDDEN					0x00000002
#define FILE_ATTRIBUTE_SYSTEM					0x00000004

#define FILE_ATTRIBUTE_DIRECTORY				0x00000010
#define FILE_ATTRIBUTE_ARCHIVE					0x00000020
#define FILE_ATTRIBUTE_DEVICE					0x00000040
#define FILE_ATTRIBUTE_NORMAL					0x00000080

#define FILE_ATTRIBUTE_TEMPORARY				0x00000100
#define FILE_ATTRIBUTE_SPARSE_FILE				0x00000200
#define FILE_ATTRIBUTE_REPARSE_POINT			0x00000400
#define FILE_ATTRIBUTE_COMPRESSED				0x00000800

#define FILE_ATTRIBUTE_OFFLINE					0x00001000
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED		0x00002000
#define FILE_ATTRIBUTE_ENCRYPTED				0x00004000

#define FILE_ATTRIBUTE_INTEGRITY_STREAM			0x00008000
#define FILE_ATTRIBUTE_VIRTUAL					0x00010000
#define FILE_ATTRIBUTE_NO_SCRUB_DATA			0x00020000

#define FILE_ATTRIBUTE_EA						0x00040000
#define FILE_ATTRIBUTE_PINNED					0x00080000
#define FILE_ATTRIBUTE_UNPINNED					0x00100000
#define FILE_ATTRIBUTE_RECALL_ON_OPEN			0x00040000
#define FILE_ATTRIBUTE_RECALL_ON_DATA_ACCESS	0x00400000

#if NTDDI_VERSION < NTDDI_WIN8
#define FILE_ATTRIBUTE_VALID_FLAGS				0x00007fb7
#define FILE_ATTRIBUTE_VALID_SET_FLAGS			0x000031a7
#elif NTDDI_VERSION < NTDDI_WIN10_RS2
#define FILE_ATTRIBUTE_VALID_FLAGS				0x0002ffb7
#define FILE_ATTRIBUTE_VALID_SET_FLAGS			0x000231a7
#else
#define FILE_ATTRIBUTE_VALID_FLAGS				0x005affb7
#define FILE_ATTRIBUTE_VALID_SET_FLAGS			0x001a31a7
#endif

// File create disposition values
#define FILE_SUPERSEDE							0x00000000
#define FILE_OPEN								0x00000001
#define FILE_CREATE								0x00000002
#define FILE_OPEN_IF							0x00000003
#define FILE_OVERWRITE							0x00000004
#define FILE_OVERWRITE_IF						0x00000005
#define FILE_MAXIMUM_DISPOSITION				0x00000005

// File create/open option flags
#define FILE_DIRECTORY_FILE						0x00000001
#define FILE_WRITE_THROUGH						0x00000002
#define FILE_SEQUENTIAL_ONLY					0x00000004
#define FILE_NO_INTERMEDIATE_BUFFERING			0x00000008

#define FILE_SYNCHRONOUS_IO_ALERT				0x00000010
#define FILE_SYNCHRONOUS_IO_NONALERT			0x00000020
#define FILE_NON_DIRECTORY_FILE					0x00000040
#define FILE_CREATE_TREE_CONNECTION				0x00000080

#define FILE_COMPLETE_IF_OPLOCKED				0x00000100
#define FILE_NO_EA_KNOWLEDGE					0x00000200
#define FILE_OPEN_FOR_RECOVERY					0x00000400
#define FILE_RANDOM_ACCESS						0x00000800

#define FILE_DELETE_ON_CLOSE					0x00001000
#define FILE_OPEN_BY_FILE_ID					0x00002000
#define FILE_OPEN_FOR_BACKUP_INTENT				0x00004000
#define FILE_NO_COMPRESSION						0x00008000

#if NTDDI_VERSION >= NTDDI_WIN7
#define FILE_OPEN_REQUIRING_OPLOCK				0x00010000
#define FILE_DISALLOW_EXCLUSIVE					0x00020000
#endif
#if NTDDI_VERSION >= NTDDI_WIN8
#define FILE_SESSION_AWARE						0x00040000
#endif

#define FILE_RESERVE_OPFILTER					0x00100000
#define FILE_OPEN_REPARSE_POINT					0x00200000
#define FILE_OPEN_NO_RECALL						0x00400000
#define FILE_OPEN_FOR_FREE_SPACE_QUERY			0x00800000

#define FILE_VALID_OPTION_FLAGS					0x00ffffff
#define FILE_VALID_PIPE_OPTION_FLAGS			0x00000032
#define FILE_VALID_MAILSLOT_OPTION_FLAGS		0x00000032
#define FILE_VALID_SET_FLAGS					0x00000036

// Named pipe type flags
#define FILE_PIPE_BYTE_STREAM_TYPE				0x00000000
#define FILE_PIPE_MESSAGE_TYPE					0x00000001
#define FILE_PIPE_ACCEPT_REMOTE_CLIENTS			0x00000000
#define FILE_PIPE_REJECT_REMOTE_CLIENTS			0x00000002
#define FILE_PIPE_TYPE_VALID_MASK				0x00000003

// Named pipe completion mode flags
#define FILE_PIPE_QUEUE_OPERATION				0x00000000
#define FILE_PIPE_COMPLETE_OPERATION			0x00000001

// Named pipe read mode flags
#define FILE_PIPE_BYTE_STREAM_MODE				0x00000000
#define FILE_PIPE_MESSAGE_MODE					0x00000001

// NamedPipeConfiguration flags
#define FILE_PIPE_INBOUND						0x00000000
#define FILE_PIPE_OUTBOUND						0x00000001
#define FILE_PIPE_FULL_DUPLEX					0x00000002

// NamedPipeState flags
#define FILE_PIPE_DISCONNECTED_STATE			0x00000001
#define FILE_PIPE_LISTENING_STATE				0x00000002
#define FILE_PIPE_CONNECTED_STATE				0x00000003
#define FILE_PIPE_CLOSING_STATE					0x00000004

// NamedPipeEnd flags
#define FILE_PIPE_CLIENT_END					0x00000000
#define FILE_PIPE_SERVER_END					0x00000001

typedef struct _FILE_BASIC_INFORMATION {
	LARGE_INTEGER CreationTime;
	LARGE_INTEGER LastAccessTime;
	LARGE_INTEGER LastWriteTime;
	LARGE_INTEGER ChangeTime;
	ULONG FileAttributes;
} FILE_BASIC_INFORMATION, *PFILE_BASIC_INFORMATION;

typedef struct _FILE_STANDARD_INFORMATION {
	LARGE_INTEGER AllocationSize;
	LARGE_INTEGER EndOfFile;
	ULONG NumberOfLinks;
	BOOLEAN DeletePending;
	BOOLEAN Directory;
} FILE_STANDARD_INFORMATION, *PFILE_STANDARD_INFORMATION;

typedef struct _FILE_POSITION_INFORMATION
{
	LARGE_INTEGER CurrentByteOffset;
} FILE_POSITION_INFORMATION, *PFILE_POSITION_INFORMATION;

// Privileges
#define SE_MIN_WELL_KNOWN_PRIVILEGE (2L)
#define SE_CREATE_TOKEN_PRIVILEGE (2L)
#define SE_ASSIGNPRIMARYTOKEN_PRIVILEGE (3L)
#define SE_LOCK_MEMORY_PRIVILEGE (4L)
#define SE_INCREASE_QUOTA_PRIVILEGE (5L)
#define SE_MACHINE_ACCOUNT_PRIVILEGE (6L)
#define SE_TCB_PRIVILEGE (7L)
#define SE_SECURITY_PRIVILEGE (8L)
#define SE_TAKE_OWNERSHIP_PRIVILEGE (9L)
#define SE_LOAD_DRIVER_PRIVILEGE (10L)
#define SE_SYSTEM_PROFILE_PRIVILEGE (11L)
#define SE_SYSTEMTIME_PRIVILEGE (12L)
#define SE_PROF_SINGLE_PROCESS_PRIVILEGE (13L)
#define SE_INC_BASE_PRIORITY_PRIVILEGE (14L)
#define SE_CREATE_PAGEFILE_PRIVILEGE (15L)
#define SE_CREATE_PERMANENT_PRIVILEGE (16L)
#define SE_BACKUP_PRIVILEGE (17L)
#define SE_RESTORE_PRIVILEGE (18L)
#define SE_SHUTDOWN_PRIVILEGE (19L)
#define SE_DEBUG_PRIVILEGE (20L)
#define SE_AUDIT_PRIVILEGE (21L)
#define SE_SYSTEM_ENVIRONMENT_PRIVILEGE (22L)
#define SE_CHANGE_NOTIFY_PRIVILEGE (23L)
#define SE_REMOTE_SHUTDOWN_PRIVILEGE (24L)
#define SE_UNDOCK_PRIVILEGE (25L)
#define SE_SYNC_AGENT_PRIVILEGE (26L)
#define SE_ENABLE_DELEGATION_PRIVILEGE (27L)
#define SE_MANAGE_VOLUME_PRIVILEGE (28L)
#define SE_IMPERSONATE_PRIVILEGE (29L)
#define SE_CREATE_GLOBAL_PRIVILEGE (30L)
#define SE_TRUSTED_CREDMAN_ACCESS_PRIVILEGE (31L)
#define SE_RELABEL_PRIVILEGE (32L)
#define SE_INC_WORKING_SET_PRIVILEGE (33L)
#define SE_TIME_ZONE_PRIVILEGE (34L)
#define SE_CREATE_SYMBOLIC_LINK_PRIVILEGE (35L)
#define SE_MAX_WELL_KNOWN_PRIVILEGE SE_CREATE_SYMBOLIC_LINK_PRIVILEGE

typedef struct _THREAD_BASIC_INFORMATION
{
	NTSTATUS ExitStatus;
	PVOID TebBaseAddress;
	CLIENT_ID ClientId;
	ULONG_PTR AffinityMask;
	KPRIORITY Priority;
	LONG BasePriority;
} THREAD_BASIC_INFORMATION, *PTHREAD_BASIC_INFORMATION;

typedef struct _MEMORY_REGION_INFORMATION
{
	PVOID AllocationBase;
	ULONG AllocationProtect;
	union
	{
		ULONG RegionType;
		struct
		{
			ULONG Private : 1;
			ULONG MappedDataFile : 1;
			ULONG MappedImage : 1;
			ULONG MappedPageFile : 1;
			ULONG MappedPhysical : 1;
			ULONG DirectMapped : 1;
			ULONG SoftwareEnclave : 1; //REDSTONE3
			ULONG PageSize64K : 1;
			ULONG Reserved : 24;
		} s;
	} u;
	SIZE_T RegionSize;
	SIZE_T CommitSize;
} MEMORY_REGION_INFORMATION, *PMEMORY_REGION_INFORMATION;

typedef struct _MEMORY_IMAGE_INFORMATION
{
	PVOID ImageBase;
	SIZE_T SizeOfImage;
	union
	{
		ULONG ImageFlags;
		struct
		{
			ULONG ImagePartialMap : 1;
			ULONG ImageNotExecutable : 1;
			ULONG ImageSigningLevel : 1; // REDSTONE3
			ULONG Reserved : 30;
		};
	};
} MEMORY_IMAGE_INFORMATION, *PMEMORY_IMAGE_INFORMATION;

typedef struct _SECTION_BASIC_INFORMATION
{
	PVOID BaseAddress;
	ULONG AllocationAttributes;
	LARGE_INTEGER MaximumSize;
} SECTION_BASIC_INFORMATION, *PSECTION_BASIC_INFORMATION;

typedef struct _SECTION_IMAGE_INFORMATION
{
	PVOID TransferAddress; // Entry point
	ULONG ZeroBits;
	SIZE_T MaximumStackSize;
	SIZE_T CommittedStackSize;
	ULONG SubSystemType;
	union
	{
		struct
		{
			USHORT SubSystemMinorVersion;
			USHORT SubSystemMajorVersion;
		} s1;
		ULONG SubSystemVersion;
	} u1;
	union
	{
		struct
		{
			USHORT MajorOperatingSystemVersion;
			USHORT MinorOperatingSystemVersion;
		} s2;
		ULONG OperatingSystemVersion;
	} u2;
	USHORT ImageCharacteristics;
	USHORT DllCharacteristics;
	USHORT Machine;
	BOOLEAN ImageContainsCode;
	union
	{
		UCHAR ImageFlags;
		struct
		{
			UCHAR ComPlusNativeReady : 1;
			UCHAR ComPlusILOnly : 1;
			UCHAR ImageDynamicallyRelocated : 1;
			UCHAR ImageMappedFlat : 1;
			UCHAR BaseBelow4gb : 1;
			UCHAR ComPlusPrefer32bit : 1;
			UCHAR Reserved : 2;
		} s3;
	} u3;
	ULONG LoaderFlags;
	ULONG ImageFileSize;
	ULONG CheckSum;
} SECTION_IMAGE_INFORMATION, *PSECTION_IMAGE_INFORMATION;

typedef struct _SECTION_INTERNAL_IMAGE_INFORMATION
{
	SECTION_IMAGE_INFORMATION SectionInformation;
	union
	{
		ULONG ExtendedFlags;
		struct
		{
			ULONG ImageExportSuppressionEnabled : 1;
			ULONG Reserved : 31;
		} s;
	} u;
} SECTION_INTERNAL_IMAGE_INFORMATION, *PSECTION_INTERNAL_IMAGE_INFORMATION;

typedef struct _IMAGE_INFO
{
	union
	{
		ULONG Properties;
		struct
		{
			ULONG ImageAddressingMode	: 8;  // Code addressing mode
			ULONG SystemModeImage		: 1;  // System mode image
			ULONG ImageMappedToAllPids	: 1;  // Image mapped into all processes
			ULONG ExtendedInfoPresent	: 1;  // IMAGE_INFO_EX available
			ULONG MachineTypeMismatch	: 1;  // Architecture type mismatch
			ULONG ImageSignatureLevel	: 4;  // Signature level
			ULONG ImageSignatureType	: 3;  // Signature type
			ULONG ImagePartialMap		: 1;  // Nonzero if entire image is not mapped
			ULONG Reserved				: 12;
		};
	};
	PVOID	ImageBase;
	ULONG	ImageSelector;
	SIZE_T	ImageSize;
	ULONG	ImageSectionNumber;
} IMAGE_INFO, *PIMAGE_INFO;

typedef struct _PROCESS_INSTRUMENTATION_CALLBACK_INFORMATION
{
	ULONG Version; // Set to 0 for x64, 1 for native x86, and use as PVOID Callback on WOW64
	ULONG Reserved;
	PVOID Callback;
} PROCESS_INSTRUMENTATION_CALLBACK_INFORMATION, *PPROCESS_INSTRUMENTATION_CALLBACK_INFORMATION;

typedef struct _OBJECT_ATTRIBUTES {
	ULONG Length;
	HANDLE RootDirectory;
	PUNICODE_STRING ObjectName;
	ULONG Attributes;
	PVOID SecurityDescriptor;
	PVOID SecurityQualityOfService;
} OBJECT_ATTRIBUTES, *POBJECT_ATTRIBUTES;

#define LDR_GET_DLL_HANDLE_EX_UNCHANGED_REFCOUNT			0x00000001
#define LDR_GET_DLL_HANDLE_EX_PIN							0x00000002

#define LDR_GET_PROCEDURE_ADDRESS_EX_DONT_RECORD_FORWARDER	0x00000001

#define LDR_LOCK_LOADER_LOCK_FLAG_RAISE_ON_ERRORS			0x00000001
#define LDR_LOCK_LOADER_LOCK_FLAG_TRY_ONLY					0x00000002

#define LDR_LOCK_LOADER_LOCK_DISPOSITION_INVALID			0
#define LDR_LOCK_LOADER_LOCK_DISPOSITION_LOCK_ACQUIRED		1
#define LDR_LOCK_LOADER_LOCK_DISPOSITION_LOCK_NOT_ACQUIRED	2

#define LDR_UNLOCK_LOADER_LOCK_FLAG_RAISE_ON_ERRORS			0x00000001

typedef struct _LDR_RESOURCE_INFO
{
	ULONG_PTR Type;
	ULONG_PTR Name;
	ULONG_PTR Language;
} LDR_RESOURCE_INFO, *PLDR_RESOURCE_INFO;

typedef struct _LDR_ENUM_RESOURCE_INFO
{
	ULONG_PTR Type;
	ULONG_PTR Name;
	ULONG_PTR Language;
	PVOID Data;
	SIZE_T Size;
	ULONG_PTR Reserved;
} LDR_ENUM_RESOURCE_INFO, *PLDR_ENUM_RESOURCE_INFO;

#define LDR_FIND_RESOURCE_LANGUAGE_CAN_FALLBACK				0x00000000
#define LDR_FIND_RESOURCE_LANGUAGE_EXACT					0x00000004
#define LDR_FIND_RESOURCE_LANGUAGE_REDIRECT_VERSION			0x00000008

typedef struct _RTL_PROCESS_MODULE_INFORMATION
{
	HANDLE Section;
	PVOID MappedBase;
	PVOID ImageBase;
	ULONG ImageSize;
	ULONG Flags;
	USHORT LoadOrderIndex;
	USHORT InitOrderIndex;
	USHORT LoadCount;
	USHORT OffsetToFileName;
	UCHAR FullPathName[256];
} RTL_PROCESS_MODULE_INFORMATION, *PRTL_PROCESS_MODULE_INFORMATION;

typedef struct _RTL_PROCESS_MODULES
{
	ULONG NumberOfModules;
	RTL_PROCESS_MODULE_INFORMATION Modules[1];
} RTL_PROCESS_MODULES, *PRTL_PROCESS_MODULES;

typedef struct _RTL_PROCESS_MODULE_INFORMATION_EX
{
	USHORT NextOffset;
	RTL_PROCESS_MODULE_INFORMATION BaseInfo;
	ULONG ImageChecksum;
	ULONG TimeDateStamp;
	PVOID DefaultBase;
} RTL_PROCESS_MODULE_INFORMATION_EX, *PRTL_PROCESS_MODULE_INFORMATION_EX;

typedef struct _SYSTEM_CODEINTEGRITY_INFORMATION
{
	ULONG Length;
	ULONG CodeIntegrityOptions;
} SYSTEM_CODEINTEGRITY_INFORMATION, *PSYSTEM_CODEINTEGRITY_INFORMATION;

#define CODEINTEGRITY_OPTION_ENABLED						0x1
#define CODEINTEGRITY_OPTION_TESTSIGN						0x2
#define CODEINTEGRITY_OPTION_UMCI_ENABLED					0x4
#define CODEINTEGRITY_OPTION_UMCI_AUDITMODE_ENABLED			0x8
#define CODEINTEGRITY_OPTION_UMCI_EXCLUSIONPATHS_ENABLED	0x10
#define CODEINTEGRITY_OPTION_TEST_BUILD						0x20
#define CODEINTEGRITY_OPTION_PREPRODUCTION_BUILD			0x40
#define CODEINTEGRITY_OPTION_DEBUGMODE_ENABLED				0x80
#define CODEINTEGRITY_OPTION_FLIGHT_BUILD					0x100
#define CODEINTEGRITY_OPTION_FLIGHTING_ENABLED				0x200
#define CODEINTEGRITY_OPTION_HVCI_KMCI_ENABLED				0x400
#define CODEINTEGRITY_OPTION_HVCI_KMCI_AUDITMODE_ENABLED	0x800
#define CODEINTEGRITY_OPTION_HVCI_KMCI_STRICTMODE_ENABLED	0x1000
#define CODEINTEGRITY_OPTION_HVCI_IUM_ENABLED				0x2000

#if NTDDI_VERSION >= NTDDI_VISTA
typedef struct _SYSTEM_BOOT_ENVIRONMENT_INFORMATION
{
	GUID BootIdentifier;
	FIRMWARE_TYPE FirmwareType;
	ULONGLONG BootFlags;
} SYSTEM_BOOT_ENVIRONMENT_INFORMATION, *PSYSTEM_BOOT_ENVIRONMENT_INFORMATION;
#endif

typedef struct _SYSTEM_CODEINTEGRITYPOLICY_INFORMATION
{
	ULONG Options;
	ULONG HVCIOptions;
	ULONGLONG Version;
	GUID PolicyGuid;
} SYSTEM_CODEINTEGRITYPOLICY_INFORMATION, *PSYSTEM_CODEINTEGRITYPOLICY_INFORMATION;

typedef struct _SYSTEM_CODEINTEGRITY_CERTIFICATE_INFORMATION
{
	HANDLE ImageFile;
} SYSTEM_CODEINTEGRITY_CERTIFICATE_INFORMATION, *PSYSTEM_CODEINTEGRITY_CERTIFICATE_INFORMATION;

typedef struct _SYSTEM_CODEINTEGRITY_UNLOCK_INFORMATION
{
	union
	{
		ULONG Flags;
		struct
		{
			ULONG Locked : 1;
			ULONG Unlockable : 1;
			ULONG UnlockApplied : 1;
			ULONG Reserved : 29;
		};
	};
} SYSTEM_CODEINTEGRITY_UNLOCK_INFORMATION, *PSYSTEM_CODEINTEGRITY_UNLOCK_INFORMATION;

typedef
NTSTATUS
NTAPI
RTL_QUERY_REGISTRY_ROUTINE(
	_In_z_ PWSTR ValueName,
	_In_ ULONG ValueType,
	_In_opt_ PVOID ValueData,
	_In_ ULONG ValueLength,
	_In_opt_ PVOID Context,
	_In_opt_ PVOID EntryContext
	);
typedef RTL_QUERY_REGISTRY_ROUTINE *PRTL_QUERY_REGISTRY_ROUTINE;

typedef struct _RTL_QUERY_REGISTRY_TABLE
{
	PRTL_QUERY_REGISTRY_ROUTINE QueryRoutine;
	ULONG Flags;
	PWSTR Name;
	PVOID EntryContext;
	ULONG DefaultType;
	PVOID DefaultData;
	ULONG DefaultLength;
} RTL_QUERY_REGISTRY_TABLE, *PRTL_QUERY_REGISTRY_TABLE;

// RtlQueryRegistryValues flags
#define RTL_QUERY_REGISTRY_SUBKEY			0x00000001
#define RTL_QUERY_REGISTRY_TOPKEY			0x00000002
#define RTL_QUERY_REGISTRY_REQUIRED			0x00000004
#define RTL_QUERY_REGISTRY_NOVALUE			0x00000008
#define RTL_QUERY_REGISTRY_NOEXPAND			0x00000010
#define RTL_QUERY_REGISTRY_DIRECT			0x00000020
#define RTL_QUERY_REGISTRY_DELETE			0x00000040
#define RTL_QUERY_REGISTRY_NOSTRING			0x00000080
#define RTL_QUERY_REGISTRY_TYPECHECK		0x00000100

#define RTL_QUERY_REGISTRY_TYPECHECK_SHIFT	24
#define RTL_QUERY_REGISTRY_TYPECHECK_MASK	(0xff << RTL_QUERY_REGISTRY_TYPECHECK_SHIFT)

// RtlWriteRegistryValue RelativeTo values
#define RTL_REGISTRY_ABSOLUTE				0			// Path is a full path
#define RTL_REGISTRY_SERVICES				1			// \Registry\Machine\System\CurrentControlSet\Services
#define RTL_REGISTRY_CONTROL				2			// \Registry\Machine\System\CurrentControlSet\Control
#define RTL_REGISTRY_WINDOWS_NT				3			// \Registry\Machine\Software\Microsoft\Windows NT\CurrentVersion
#define RTL_REGISTRY_DEVICEMAP				4			// \Registry\Machine\Hardware\DeviceMap
#define RTL_REGISTRY_USER					5			// \Registry\User\CurrentUser
#define RTL_REGISTRY_MAXIMUM				6
#define RTL_REGISTRY_HANDLE					0x40000000	// Low order bits are registry handle
#define RTL_REGISTRY_OPTIONAL				0x80000000	// Indicates the key node is optional

typedef struct _PROCESS_HANDLE_INFORMATION
{
	ULONG HandleCount;
	ULONG HandleCountHighWatermark;
} PROCESS_HANDLE_INFORMATION, *PPROCESS_HANDLE_INFORMATION;

#if NTDDI_VERSION >= NTDDI_VISTA
typedef struct _PROCESS_MITIGATION_POLICY_INFORMATION
{
	PROCESS_MITIGATION_POLICY Policy;
	union
	{
		PROCESS_MITIGATION_ASLR_POLICY ASLRPolicy;
		PROCESS_MITIGATION_STRICT_HANDLE_CHECK_POLICY StrictHandleCheckPolicy;
		PROCESS_MITIGATION_SYSTEM_CALL_DISABLE_POLICY SystemCallDisablePolicy;
		PROCESS_MITIGATION_EXTENSION_POINT_DISABLE_POLICY ExtensionPointDisablePolicy;
		PROCESS_MITIGATION_DYNAMIC_CODE_POLICY DynamicCodePolicy;
		PROCESS_MITIGATION_CONTROL_FLOW_GUARD_POLICY ControlFlowGuardPolicy;
		PROCESS_MITIGATION_BINARY_SIGNATURE_POLICY SignaturePolicy;
		PROCESS_MITIGATION_FONT_DISABLE_POLICY FontDisablePolicy;
		PROCESS_MITIGATION_IMAGE_LOAD_POLICY ImageLoadPolicy;
		PROCESS_MITIGATION_SYSTEM_CALL_FILTER_POLICY SystemCallFilterPolicy;
		PROCESS_MITIGATION_PAYLOAD_RESTRICTION_POLICY PayloadRestrictionPolicy;
		PROCESS_MITIGATION_CHILD_PROCESS_POLICY ChildProcessPolicy;
	};
} PROCESS_MITIGATION_POLICY_INFORMATION, *PPROCESS_MITIGATION_POLICY_INFORMATION;
#endif

typedef struct _SYSTEM_HANDLE_TABLE_ENTRY_INFO
{
	USHORT UniqueProcessId;
	USHORT CreatorBackTraceIndex;
	UCHAR ObjectTypeIndex;
	UCHAR HandleAttributes;
	USHORT HandleValue;
	PVOID Object;
	ULONG GrantedAccess;
} SYSTEM_HANDLE_TABLE_ENTRY_INFO, *PSYSTEM_HANDLE_TABLE_ENTRY_INFO;

typedef struct _SYSTEM_HANDLE_INFORMATION
{
	ULONG NumberOfHandles;
	SYSTEM_HANDLE_TABLE_ENTRY_INFO Handles[1];
} SYSTEM_HANDLE_INFORMATION, *PSYSTEM_HANDLE_INFORMATION;

typedef struct _SYSTEM_HANDLE_TABLE_ENTRY_INFO_EX
{
	PVOID Object;
	ULONG_PTR UniqueProcessId;
	ULONG_PTR HandleValue;
	ULONG GrantedAccess;
	USHORT CreatorBackTraceIndex;
	USHORT ObjectTypeIndex;
	ULONG HandleAttributes;
	ULONG Reserved;
} SYSTEM_HANDLE_TABLE_ENTRY_INFO_EX, *PSYSTEM_HANDLE_TABLE_ENTRY_INFO_EX;

typedef struct _SYSTEM_HANDLE_INFORMATION_EX
{
	ULONG_PTR NumberOfHandles;
	ULONG_PTR Reserved;
	SYSTEM_HANDLE_TABLE_ENTRY_INFO_EX Handles[1];
} SYSTEM_HANDLE_INFORMATION_EX, *PSYSTEM_HANDLE_INFORMATION_EX;

typedef struct _OBJECT_BASIC_INFORMATION
{
	ULONG Attributes;
	ACCESS_MASK GrantedAccess;
	ULONG HandleCount;
	ULONG PointerCount;
	ULONG PagedPoolCharge;
	ULONG NonPagedPoolCharge;
	ULONG Reserved[ 3 ];
	ULONG NameInfoSize;
	ULONG TypeInfoSize;
	ULONG SecurityDescriptorSize;
	LARGE_INTEGER CreationTime;
} OBJECT_BASIC_INFORMATION, *POBJECT_BASIC_INFORMATION;

typedef struct _OBJECT_NAME_INFORMATION
{
	UNICODE_STRING Name;
} OBJECT_NAME_INFORMATION, *POBJECT_NAME_INFORMATION;

typedef struct _OBJECT_TYPE_INFORMATION
{
	UNICODE_STRING TypeName;
	ULONG TotalNumberOfObjects;
	ULONG TotalNumberOfHandles;
	ULONG TotalPagedPoolUsage;
	ULONG TotalNonPagedPoolUsage;
	ULONG TotalNamePoolUsage;
	ULONG TotalHandleTableUsage;
	ULONG HighWaterNumberOfObjects;
	ULONG HighWaterNumberOfHandles;
	ULONG HighWaterPagedPoolUsage;
	ULONG HighWaterNonPagedPoolUsage;
	ULONG HighWaterNamePoolUsage;
	ULONG HighWaterHandleTableUsage;
	ULONG InvalidAttributes;
	GENERIC_MAPPING GenericMapping;
	ULONG ValidAccessMask;
	BOOLEAN SecurityRequired;
	BOOLEAN MaintainHandleCount;
	UCHAR TypeIndex; // Since Windows 8.1
	CHAR ReservedByte;
	ULONG PoolType;
	ULONG DefaultPagedPoolCharge;
	ULONG DefaultNonPagedPoolCharge;
} OBJECT_TYPE_INFORMATION, *POBJECT_TYPE_INFORMATION;

typedef struct _OBJECT_TYPES_INFORMATION
{
	ULONG NumberOfTypes;
	OBJECT_TYPE_INFORMATION TypeInformation[1];
} OBJECT_TYPES_INFORMATION, *POBJECT_TYPES_INFORMATION;

typedef struct _OBJECT_HANDLE_FLAG_INFORMATION
{
	BOOLEAN Inherit;
	BOOLEAN ProtectFromClose;
} OBJECT_HANDLE_FLAG_INFORMATION, *POBJECT_HANDLE_FLAG_INFORMATION;

typedef struct _DBGKM_EXCEPTION
{
	EXCEPTION_RECORD ExceptionRecord;
	ULONG FirstChance;
} DBGKM_EXCEPTION, *PDBGKM_EXCEPTION;

typedef struct _DBGKM_CREATE_THREAD
{
	ULONG SubSystemKey;
	PVOID StartAddress;
} DBGKM_CREATE_THREAD, *PDBGKM_CREATE_THREAD;

typedef struct _DBGKM_CREATE_PROCESS
{
	ULONG SubSystemKey;
	HANDLE FileHandle;
	PVOID BaseOfImage;
	ULONG DebugInfoFileOffset;
	ULONG DebugInfoSize;
	DBGKM_CREATE_THREAD InitialThread;
} DBGKM_CREATE_PROCESS, *PDBGKM_CREATE_PROCESS;

typedef struct _DBGKM_EXIT_THREAD
{
	NTSTATUS ExitStatus;
} DBGKM_EXIT_THREAD, *PDBGKM_EXIT_THREAD;

typedef struct _DBGKM_EXIT_PROCESS
{
	NTSTATUS ExitStatus;
} DBGKM_EXIT_PROCESS, *PDBGKM_EXIT_PROCESS;

typedef struct _DBGKM_LOAD_DLL
{
	HANDLE FileHandle;
	PVOID BaseOfDll;
	ULONG DebugInfoFileOffset;
	ULONG DebugInfoSize;
	PVOID NamePointer;
} DBGKM_LOAD_DLL, *PDBGKM_LOAD_DLL;

typedef struct _DBGKM_UNLOAD_DLL
{
	PVOID BaseAddress;
} DBGKM_UNLOAD_DLL, *PDBGKM_UNLOAD_DLL;

typedef enum _DBG_STATE
{
	DbgIdle,
	DbgReplyPending,
	DbgCreateThreadStateChange,
	DbgCreateProcessStateChange,
	DbgExitThreadStateChange,
	DbgExitProcessStateChange,
	DbgExceptionStateChange,
	DbgBreakpointStateChange,
	DbgSingleStepStateChange,
	DbgLoadDllStateChange,
	DbgUnloadDllStateChange
} DBG_STATE, *PDBG_STATE;

typedef struct _DBGUI_CREATE_THREAD
{
	HANDLE HandleToThread;
	DBGKM_CREATE_THREAD NewThread;
} DBGUI_CREATE_THREAD, *PDBGUI_CREATE_THREAD;

typedef struct _DBGUI_CREATE_PROCESS
{
	HANDLE HandleToProcess;
	HANDLE HandleToThread;
	DBGKM_CREATE_PROCESS NewProcess;
} DBGUI_CREATE_PROCESS, *PDBGUI_CREATE_PROCESS;

typedef struct _DBGUI_WAIT_STATE_CHANGE
{
	DBG_STATE NewState;
	CLIENT_ID AppClientId;
	union
	{
		DBGKM_EXCEPTION Exception;
		DBGUI_CREATE_THREAD CreateThread;
		DBGUI_CREATE_PROCESS CreateProcessInfo;
		DBGKM_EXIT_THREAD ExitThread;
		DBGKM_EXIT_PROCESS ExitProcess;
		DBGKM_LOAD_DLL LoadDll;
		DBGKM_UNLOAD_DLL UnloadDll;
	} StateInfo;
} DBGUI_WAIT_STATE_CHANGE, *PDBGUI_WAIT_STATE_CHANGE;

typedef struct _DBGSS_THREAD_DATA
{
	struct _DBGSS_THREAD_DATA *Next;
	HANDLE ThreadHandle;
	HANDLE ProcessHandle;
	ULONG ProcessId;
	ULONG ThreadId;
	BOOLEAN HandleMarked;
} DBGSS_THREAD_DATA, *PDBGSS_THREAD_DATA;

#define DbgSsSetThreadData(d) \
	NtCurrentTeb()->DbgSsReserved[0] = d

#define DbgSsGetThreadData() \
	((PDBGSS_THREAD_DATA)NtCurrentTeb()->DbgSsReserved[0])

typedef USHORT RTL_ATOM, *PRTL_ATOM;
typedef long SECURITY_STATUS;

typedef struct _RTL_SPLAY_LINKS
{
	struct _RTL_SPLAY_LINKS *Parent;
	struct _RTL_SPLAY_LINKS *LeftChild;
	struct _RTL_SPLAY_LINKS *RightChild;
} RTL_SPLAY_LINKS, *PRTL_SPLAY_LINKS;

#define RtlInitializeSplayLinks(Links) \
{ \
	PRTL_SPLAY_LINKS _SplayLinks; \
	_SplayLinks = (PRTL_SPLAY_LINKS)(Links); \
	_SplayLinks->Parent = _SplayLinks; \
	_SplayLinks->LeftChild = NULL; \
	_SplayLinks->RightChild = NULL; \
}

typedef struct _PREFIX_TABLE_ENTRY
{
	SHORT NodeTypeCode;
	SHORT NameLength;
	struct _PREFIX_TABLE_ENTRY *NextPrefixTree;
	RTL_SPLAY_LINKS Links;
	PANSI_STRING Prefix;
} PREFIX_TABLE_ENTRY, *PPREFIX_TABLE_ENTRY;

typedef struct _PREFIX_TABLE
{
	SHORT NodeTypeCode;
	SHORT NameLength;
	PPREFIX_TABLE_ENTRY NextPrefixTree;
} PREFIX_TABLE, *PPREFIX_TABLE;

typedef struct _RTL_BITMAP
{
	ULONG SizeOfBitMap;
	PULONG Buffer;
} RTL_BITMAP, *PRTL_BITMAP;

typedef struct _RTL_BITMAP_RUN
{
	ULONG StartingIndex;
	ULONG NumberOfBits;
} RTL_BITMAP_RUN, *PRTL_BITMAP_RUN;

typedef enum
{
	RtlBsdItemVersionNumber = 0x00,
	RtlBsdItemProductType,
	RtlBsdItemAabEnabled,
	RtlBsdItemAabTimeout,
	RtlBsdItemBootGood,
	RtlBsdItemBootShutdown,
	RtlBsdItemMax
} RTL_BSD_ITEM_TYPE, *PRTL_BSD_ITEM_TYPE;

#define DUPLICATE_CLOSE_SOURCE		0x00000001
#define DUPLICATE_SAME_ACCESS		0x00000002
#define DUPLICATE_SAME_ATTRIBUTES	0x00000004

#define RTL_WALK_MAX_STACK_DEPTH	128

// These cannot be ORed together
#define RTL_WALK_KERNEL_MODE_STACK	0x00000000 // Kernel mode callers only
#define RTL_WALK_USER_MODE_STACK	0x00000001
#define RTL_WALK_TRACE_HANDLES		0x00000300

typedef struct _RTL_PROCESS_VERIFIER_OPTIONS
{
	ULONG SizeStruct;
	ULONG Option;
	UCHAR OptionData[1];
} RTL_PROCESS_VERIFIER_OPTIONS, *PRTL_PROCESS_VERIFIER_OPTIONS;

typedef struct _RTL_DEBUG_INFORMATION
{
	HANDLE SectionHandleClient;
	PVOID ViewBaseClient;
	PVOID ViewBaseTarget;
	ULONG_PTR ViewBaseDelta;
	HANDLE EventPairClient;
	HANDLE EventPairTarget;
	HANDLE TargetProcessId;
	HANDLE TargetThreadHandle;
	ULONG Flags;
	SIZE_T OffsetFree;
	SIZE_T CommitSize;
	SIZE_T ViewSize;
	union
	{
		PRTL_PROCESS_MODULES Modules;
		PRTL_PROCESS_MODULE_INFORMATION_EX ModulesEx;
	};
	struct _RTL_PROCESS_BACKTRACES *BackTraces;
	struct _RTL_PROCESS_HEAPS *Heaps;
	struct _RTL_PROCESS_LOCKS *Locks;
	PVOID SpecificHeap;
	HANDLE TargetProcessHandle;
	PRTL_PROCESS_VERIFIER_OPTIONS VerifierOptions;
	PVOID ProcessHeap;
	HANDLE CriticalSectionHandle;
	HANDLE CriticalSectionOwnerThread;
	PVOID Reserved[4];
} RTL_DEBUG_INFORMATION, *PRTL_DEBUG_INFORMATION;

typedef
VOID
(*PPS_APC_ROUTINE)(
	_In_opt_ PVOID ApcArgument1,
	_In_opt_ PVOID ApcArgument2,
	_In_opt_ PVOID ApcArgument3
	);

typedef struct _RTLP_CURDIR_REF *PRTLP_CURDIR_REF;

typedef struct _RTL_RELATIVE_NAME_U
{
	UNICODE_STRING RelativeName;
	HANDLE ContainingDirectory;
	PRTLP_CURDIR_REF CurDirRef;
} RTL_RELATIVE_NAME_U, *PRTL_RELATIVE_NAME_U;

typedef enum _RTL_PATH_TYPE
{
	RtlPathTypeUnknown,
	RtlPathTypeUncAbsolute,
	RtlPathTypeDriveAbsolute,
	RtlPathTypeDriveRelative,
	RtlPathTypeRooted,
	RtlPathTypeRelative,
	RtlPathTypeLocalDevice,
	RtlPathTypeRootLocalDevice,
} RTL_PATH_TYPE;

#define DOS_MAX_COMPONENT_LENGTH	255
#define DOS_MAX_PATH_LENGTH			(DOS_MAX_COMPONENT_LENGTH + 5)
#define NT_MAX_PATH_LENGTH			( (sizeof("\\??\\UNC\\") - sizeof(CHAR) ) + DOS_MAX_PATH_LENGTH + 1)

typedef struct _CURDIR
{
	UNICODE_STRING DosPath;
	HANDLE Handle;
} CURDIR, *PCURDIR;

#define RTL_USER_PROC_CURDIR_CLOSE 0x00000002
#define RTL_USER_PROC_CURDIR_INHERIT 0x00000003

typedef struct _RTL_DRIVE_LETTER_CURDIR
{
	USHORT Flags;
	USHORT Length;
	ULONG TimeStamp;
	UNICODE_STRING DosPath;
} RTL_DRIVE_LETTER_CURDIR, *PRTL_DRIVE_LETTER_CURDIR;

#define RTL_MAX_DRIVE_LETTERS 32
#define RTL_DRIVE_LETTER_VALID (USHORT)0x0001

typedef struct _LDR_SERVICE_TAG_RECORD
{
	struct _LDR_SERVICE_TAG_RECORD *Next;
	ULONG ServiceTag;
} LDR_SERVICE_TAG_RECORD, *PLDR_SERVICE_TAG_RECORD;

typedef struct _LDRP_CSLIST
{
	PSINGLE_LIST_ENTRY Tail;
} LDRP_CSLIST, *PLDRP_CSLIST;

typedef enum _LDR_DDAG_STATE
{
	LdrModulesMerged = -5,
	LdrModulesInitError = -4,
	LdrModulesSnapError = -3,
	LdrModulesUnloaded = -2,
	LdrModulesUnloading = -1,
	LdrModulesPlaceHolder = 0,
	LdrModulesMapping = 1,
	LdrModulesMapped = 2,
	LdrModulesWaitingForDependencies = 3,
	LdrModulesSnapping = 4,
	LdrModulesSnapped = 5,
	LdrModulesCondensed = 6,
	LdrModulesReadyToInit = 7,
	LdrModulesInitializing = 8,
	LdrModulesReadyToRun = 9
} LDR_DDAG_STATE;

typedef struct _LDR_DDAG_NODE
{
	LIST_ENTRY Modules;
	PLDR_SERVICE_TAG_RECORD ServiceTagList;
	ULONG LoadCount;
	ULONG LoadWhileUnloadingCount;
	ULONG LowestLink;
	union
	{
		LDRP_CSLIST Dependencies;
		SINGLE_LIST_ENTRY RemovalLink;
	};
	LDRP_CSLIST IncomingDependencies;
	LDR_DDAG_STATE State;
	SINGLE_LIST_ENTRY CondenseLink;
	ULONG PreorderNumber;
} LDR_DDAG_NODE, *PLDR_DDAG_NODE;

typedef struct _LDR_DEPENDENCY_RECORD
{
	SINGLE_LIST_ENTRY DependencyLink;
	PLDR_DDAG_NODE DependencyNode;
	SINGLE_LIST_ENTRY IncomingDependencyLink;
	PLDR_DDAG_NODE IncomingDependencyNode;
} LDR_DEPENDENCY_RECORD, *PLDR_DEPENDENCY_RECORD;

typedef enum _LDR_DLL_LOAD_REASON
{
	LoadReasonStaticDependency,
	LoadReasonStaticForwarderDependency,
	LoadReasonDynamicForwarderDependency,
	LoadReasonDelayloadDependency,
	LoadReasonDynamicLoad,
	LoadReasonAsImageLoad,
	LoadReasonAsDataLoad,
	LoadReasonEnclavePrimary, // REDSTONE3
	LoadReasonEnclaveDependency,
	LoadReasonUnknown = -1
} LDR_DLL_LOAD_REASON, *PLDR_DLL_LOAD_REASON;

#define LDRP_PACKAGED_BINARY			0x00000001
#define LDRP_IMAGE_DLL					0x00000004
#define LDRP_LOAD_IN_PROGRESS			0x00001000
#define LDRP_ENTRY_PROCESSED			0x00004000
#define LDRP_DONT_CALL_FOR_THREADS		0x00040000
#define LDRP_PROCESS_ATTACH_CALLED		0x00080000
#define LDRP_PROCESS_ATTACH_FAILED		0x00100000
#define LDRP_IMAGE_NOT_AT_BASE			0x00200000 // Vista and below
#define LDRP_COR_IMAGE					0x00400000
#define LDRP_DONT_RELOCATE				0x00800000
#define LDRP_REDIRECTED					0x10000000
#define LDRP_COMPAT_DATABASE_PROCESSED	0x80000000

#define LDR_DATA_TABLE_ENTRY_SIZE_WINXP FIELD_OFFSET(LDR_DATA_TABLE_ENTRY, DdagNode)
#define LDR_DATA_TABLE_ENTRY_SIZE_WIN7 FIELD_OFFSET(LDR_DATA_TABLE_ENTRY, BaseNameHashValue)
#define LDR_DATA_TABLE_ENTRY_SIZE_WIN8 FIELD_OFFSET(LDR_DATA_TABLE_ENTRY, ImplicitPathOptions)

#define RTL_BALANCED_NODE_RESERVED_PARENT_MASK 3

typedef struct _RTL_BALANCED_NODE
{
	union
	{
		struct _RTL_BALANCED_NODE *Children[2];
		struct
		{
			struct _RTL_BALANCED_NODE *Left;
			struct _RTL_BALANCED_NODE *Right;
		} s;
	};
	union
	{
		UCHAR Red : 1;
		UCHAR Balance : 2;
		ULONG_PTR ParentValue;
	} u;
} RTL_BALANCED_NODE, *PRTL_BALANCED_NODE;

typedef struct _LDR_DATA_TABLE_ENTRY
{
	LIST_ENTRY InLoadOrderLinks;
	LIST_ENTRY InMemoryOrderLinks;
	union
	{
		LIST_ENTRY InInitializationOrderLinks;
		LIST_ENTRY InProgressLinks;
	};
	PVOID DllBase;
	PVOID EntryPoint;
	ULONG SizeOfImage;
	UNICODE_STRING FullDllName;
	UNICODE_STRING BaseDllName;
	union
	{
		UCHAR FlagGroup[4];
		ULONG Flags;
		struct
		{
			ULONG PackagedBinary : 1;
			ULONG MarkedForRemoval : 1;
			ULONG ImageDll : 1;
			ULONG LoadNotificationsSent : 1;
			ULONG TelemetryEntryProcessed : 1;
			ULONG ProcessStaticImport : 1;
			ULONG InLegacyLists : 1;
			ULONG InIndexes : 1;
			ULONG ShimDll : 1;
			ULONG InExceptionTable : 1;
			ULONG ReservedFlags1 : 2;
			ULONG LoadInProgress : 1;
			ULONG LoadConfigProcessed : 1;
			ULONG EntryProcessed : 1;
			ULONG ProtectDelayLoad : 1;
			ULONG ReservedFlags3 : 2;
			ULONG DontCallForThreads : 1;
			ULONG ProcessAttachCalled : 1;
			ULONG ProcessAttachFailed : 1;
			ULONG CorDeferredValidate : 1;
			ULONG CorImage : 1;
			ULONG DontRelocate : 1;
			ULONG CorILOnly : 1;
			ULONG ReservedFlags5 : 3;
			ULONG Redirected : 1;
			ULONG ReservedFlags6 : 2;
			ULONG CompatDatabaseProcessed : 1;
		} s;
	} u;
	USHORT ObsoleteLoadCount;
	USHORT TlsIndex;
	LIST_ENTRY HashLinks;
	ULONG TimeDateStamp;
	struct _ACTIVATION_CONTEXT *EntryPointActivationContext;
	PVOID Lock;
	PLDR_DDAG_NODE DdagNode;
	LIST_ENTRY NodeModuleLink;
	struct _LDRP_LOAD_CONTEXT *LoadContext;
	PVOID ParentDllBase;
	PVOID SwitchBackContext;
	RTL_BALANCED_NODE BaseAddressIndexNode;
	RTL_BALANCED_NODE MappingInfoIndexNode;
	ULONG_PTR OriginalBase;
	LARGE_INTEGER LoadTime;
	ULONG BaseNameHashValue;
	LDR_DLL_LOAD_REASON LoadReason;
	ULONG ImplicitPathOptions;
	ULONG ReferenceCount;
	ULONG DependentLoadFlags;
	UCHAR SigningLevel; // Since Windows 10 RS2
} LDR_DATA_TABLE_ENTRY, *PLDR_DATA_TABLE_ENTRY;

typedef struct _INITIAL_TEB
{
	struct
	{
		PVOID OldStackBase;
		PVOID OldStackLimit;
	} OldInitialTeb;
	PVOID StackBase;
	PVOID StackLimit;
	PVOID StackAllocationBase;
} INITIAL_TEB, *PINITIAL_TEB;

typedef struct _IO_STATUS_BLOCK
{
	union
	{
		NTSTATUS Status;
		PVOID Pointer;
	};
	ULONG_PTR Information;
} IO_STATUS_BLOCK, *PIO_STATUS_BLOCK;

typedef
VOID
(NTAPI*
PIO_APC_ROUTINE)(
	_In_ PVOID ApcContext,
	_In_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ ULONG Reserved
	);

typedef struct _FILE_IO_COMPLETION_INFORMATION
{
	PVOID KeyContext;
	PVOID ApcContext;
	IO_STATUS_BLOCK IoStatusBlock;
} FILE_IO_COMPLETION_INFORMATION, *PFILE_IO_COMPLETION_INFORMATION;

typedef struct _FILE_COMPLETION_INFORMATION
{
	HANDLE Port;
	PVOID Key;
} FILE_COMPLETION_INFORMATION, *PFILE_COMPLETION_INFORMATION;

#ifdef __cplusplus
typedef enum _PRIORITY_CLASS : UCHAR
{
	Undefined,
	Idle,
	Normal,
	High,
	Realtime,
	BelowNormal,
	AboveNormal
} PRIORITY_CLASS;
#else
typedef UCHAR PRIORITY_CLASS;
#endif

typedef struct _PROCESS_PRIORITY_CLASS
{
	BOOLEAN Foreground;
	PRIORITY_CLASS PriorityClass;
} PROCESS_PRIORITY_CLASS, *PPROCESS_PRIORITY_CLASS;

typedef struct _PS_ATTRIBUTE {
	ULONG_PTR Attribute;				// PROC_THREAD_ATTRIBUTE_XXX | PROC_THREAD_ATTRIBUTE_XXX modifiers, see ProcThreadAttributeValue macro and Windows Internals 6 (372)
	SIZE_T Size;						// Size of Value or *ValuePtr
	union {
		ULONG_PTR Value;				// Reserve 8 bytes for data (such as a Handle or a data pointer)
		PVOID ValuePtr;					// data pointer
	};
	PSIZE_T ReturnLength;				// Either 0 or specifies size of data returned to caller via "ValuePtr"
} PS_ATTRIBUTE, *PPS_ATTRIBUTE;

typedef struct _PS_ATTRIBUTE_LIST {
	SIZE_T TotalLength;					// sizeof(PS_ATTRIBUTE_LIST) + <attribute count> * sizeof(PS_ATTRIBUTE)
	PS_ATTRIBUTE Attributes[1];			// Depends on how many attribute entries should be supplied to NtCreateUserProcess
} PS_ATTRIBUTE_LIST, *PPS_ATTRIBUTE_LIST;

typedef struct _PS_MEMORY_RESERVE {
	PVOID ReserveAddress;
	SIZE_T ReserveSize;
} PS_MEMORY_RESERVE, *PPS_MEMORY_RESERVE;

#define PS_ATTRIBUTE_NUMBER_MASK	0x0000ffff
#define PS_ATTRIBUTE_THREAD			0x00010000 // Attribute may be used with thread creation
#define PS_ATTRIBUTE_INPUT			0x00020000 // Attribute is input only
#define PS_ATTRIBUTE_ADDITIVE		0x00040000 // Attribute may be "accumulated", e.g. bitmasks, counters, etc.

typedef enum _PS_ATTRIBUTE_NUM
{
	PsAttributeParentProcess,					// in HANDLE
	PsAttributeDebugPort,						// in HANDLE
	PsAttributeToken,							// in HANDLE
	PsAttributeClientId,						// out PCLIENT_ID
	PsAttributeTebAddress,						// out PTEB
	PsAttributeImageName,						// in PWSTR
	PsAttributeImageInfo,						// out PSECTION_IMAGE_INFORMATION
	PsAttributeMemoryReserve,					// in PPS_MEMORY_RESERVE
	PsAttributePriorityClass,					// in UCHAR
	PsAttributeErrorMode,						// in ULONG
	PsAttributeStdHandleInfo,					// in PPS_STD_HANDLE_INFO
	PsAttributeHandleList,						// in PHANDLE
	PsAttributeGroupAffinity,					// in PGROUP_AFFINITY
	PsAttributePreferredNode,					// in PUSHORT
	PsAttributeIdealProcessor,					// in PPROCESSOR_NUMBER
	PsAttributeUmsThread,						// see MSDN UpdateProceThreadAttributeList (CreateProcessW) - in PUMS_CREATE_THREAD_ATTRIBUTES
	PsAttributeMitigationOptions,				// in UCHAR
	PsAttributeProtectionLevel,					// in ULONG
	PsAttributeSecureProcess,					// since THRESHOLD (Virtual Secure Mode, Device Guard)
	PsAttributeJobList,
	PsAttributeChildProcessPolicy,				// since THRESHOLD2
	PsAttributeAllApplicationPackagesPolicy,	// since REDSTONE
	PsAttributeWin32kFilter,
	PsAttributeSafeOpenPromptOriginClaim,
	PsAttributeBnoIsolation,
	PsAttributeDesktopAppPolicy,
	PsAttributeChpe,							// since REDSTONE3
	PsAttributeMax
} PS_ATTRIBUTE_NUM;

#define PsAttributeValue(Number, Thread, Input, Additive) \
	(((Number) & PS_ATTRIBUTE_NUMBER_MASK) | \
	((Thread) ? PS_ATTRIBUTE_THREAD : 0) | \
	((Input) ? PS_ATTRIBUTE_INPUT : 0) | \
	((Additive) ? PS_ATTRIBUTE_ADDITIVE : 0))

#define PS_ATTRIBUTE_PARENT_PROCESS \
	PsAttributeValue(PsAttributeParentProcess, FALSE, TRUE, TRUE) // 0x60000
#define PS_ATTRIBUTE_DEBUG_PORT \
	PsAttributeValue(PsAttributeDebugPort, FALSE, TRUE, TRUE) // 0x60001
#define PS_ATTRIBUTE_TOKEN \
	PsAttributeValue(PsAttributeToken, FALSE, TRUE, TRUE) // 0x60002
#define PS_ATTRIBUTE_CLIENT_ID \
	PsAttributeValue(PsAttributeClientId, TRUE, FALSE, FALSE) // 0x10003
#define PS_ATTRIBUTE_TEB_ADDRESS \
	PsAttributeValue(PsAttributeTebAddress, TRUE, FALSE, FALSE) // 0x10004
#define PS_ATTRIBUTE_IMAGE_NAME \
	PsAttributeValue(PsAttributeImageName, FALSE, TRUE, FALSE) // 0x20005
#define PS_ATTRIBUTE_IMAGE_INFO \
	PsAttributeValue(PsAttributeImageInfo, FALSE, FALSE, FALSE) // 0x6
#define PS_ATTRIBUTE_MEMORY_RESERVE \
	PsAttributeValue(PsAttributeMemoryReserve, FALSE, TRUE, FALSE) // 0x20007
#define PS_ATTRIBUTE_PRIORITY_CLASS \
	PsAttributeValue(PsAttributePriorityClass, FALSE, TRUE, FALSE) // 0x20008
#define PS_ATTRIBUTE_ERROR_MODE \
	PsAttributeValue(PsAttributeErrorMode, FALSE, TRUE, FALSE) // 0x20009
#define PS_ATTRIBUTE_STD_HANDLE_INFO \
	PsAttributeValue(PsAttributeStdHandleInfo, FALSE, TRUE, FALSE) // 0x2000A
#define PS_ATTRIBUTE_HANDLE_LIST \
	PsAttributeValue(PsAttributeHandleList, FALSE, TRUE, FALSE) // 0x2000B
#define PS_ATTRIBUTE_GROUP_AFFINITY \
	PsAttributeValue(PsAttributeGroupAffinity, TRUE, TRUE, FALSE) // 0x2000C
#define PS_ATTRIBUTE_PREFERRED_NODE \
	PsAttributeValue(PsAttributePreferredNode, FALSE, TRUE, FALSE) // 0x2000D
#define PS_ATTRIBUTE_IDEAL_PROCESSOR \
	PsAttributeValue(PsAttributeIdealProcessor, TRUE, TRUE, FALSE) // 0x2000E
#define PS_ATTRIBUTE_MITIGATION_OPTIONS \
	PsAttributeValue(PsAttributeMitigationOptions, FALSE, TRUE, TRUE) // 0x60010
#define PS_ATTRIBUTE_PROTECTION_LEVEL \
	PsAttributeValue(PsAttributeProtectionLevel, FALSE, TRUE, FALSE) // 0x20011
#define PS_ATTRIBUTE_SECURE_PROCESS \
	PsAttributeValue(PsAttributeSecureProcess, FALSE, TRUE, FALSE) // 0x20012
#define PS_ATTRIBUTE_JOB_LIST \
	PsAttributeValue(PsAttributeJobList, FALSE, TRUE, FALSE) // 0x20013
#define PS_ATTRIBUTE_CHILD_PROCESS_POLICY \
	PsAttributeValue(PsAttributeChildProcessPolicy, FALSE, TRUE, FALSE) // 0x20014
#define PS_ATTRIBUTE_ALL_APPLICATION_PACKAGES_POLICY \
	PsAttributeValue(PsAttributeAllApplicationPackagesPolicy, FALSE, TRUE, FALSE) // 0x20015
#define PS_ATTRIBUTE_WIN32K_FILTER \
	PsAttributeValue(PsAttributeWin32kFilter, FALSE, TRUE, FALSE) // 0x20016
#define PS_ATTRIBUTE_SAFE_OPEN_PROMPT_ORIGIN_CLAIM \
	PsAttributeValue(PsAttributeSafeOpenPromptOriginClaim, FALSE, TRUE, FALSE) // 0x20017
#define PS_ATTRIBUTE_BNO_ISOLATION \
	PsAttributeValue(PsAttributeBnoIsolation, FALSE, TRUE, FALSE) // 0x20018
#define PS_ATTRIBUTE_DESKTOP_APP_POLICY \
	PsAttributeValue(PsAttributeDesktopAppPolicy, FALSE, TRUE, FALSE) // 0x20019

typedef enum _PS_STD_HANDLE_STATE {
	PsNeverDuplicate,
	PsRequestDuplicate, // Duplicate standard handles specified by PseudoHandleMask, and only if StdHandleSubsystemType matches the image subsystem
	PsAlwaysDuplicate, // Always duplicate standard handles
	PsMaxStdHandleStates
} PS_STD_HANDLE_STATE;

#define HANDLE_DETACHED_PROCESS		((HANDLE)-1)
#define HANDLE_CREATE_NEW_CONSOLE	((HANDLE)-2)
#define HANDLE_CREATE_NO_WINDOW		((HANDLE)-3)

#define PS_STD_INPUT_HANDLE			0x1
#define PS_STD_OUTPUT_HANDLE		0x2
#define PS_STD_ERROR_HANDLE			0x4

typedef struct _PS_STD_HANDLE_INFO
{
	union
	{
		ULONG Flags;
		struct
		{
			ULONG StdHandleState : 2; // PS_STD_HANDLE_STATE
			ULONG PseudoHandleMask : 3; // PS_STD_*
		} s;
	};
	ULONG StdHandleSubsystemType;
} PS_STD_HANDLE_INFO, *PPS_STD_HANDLE_INFO;

typedef struct _PS_BNO_ISOLATION_PARAMETERS
{
	UNICODE_STRING IsolationPrefix;
	ULONG HandleCount;
	PVOID *Handles;
	BOOLEAN IsolationEnabled;
} PS_BNO_ISOLATION_PARAMETERS, *PPS_BNO_ISOLATION_PARAMETERS;

typedef enum _PS_MITIGATION_OPTION
{
	PS_MITIGATION_OPTION_NX,
	PS_MITIGATION_OPTION_SEHOP,
	PS_MITIGATION_OPTION_FORCE_RELOCATE_IMAGES,
	PS_MITIGATION_OPTION_HEAP_TERMINATE,
	PS_MITIGATION_OPTION_BOTTOM_UP_ASLR,
	PS_MITIGATION_OPTION_HIGH_ENTROPY_ASLR,
	PS_MITIGATION_OPTION_STRICT_HANDLE_CHECKS,
	PS_MITIGATION_OPTION_WIN32K_SYSTEM_CALL_DISABLE,
	PS_MITIGATION_OPTION_EXTENSION_POINT_DISABLE,
	PS_MITIGATION_OPTION_PROHIBIT_DYNAMIC_CODE,
	PS_MITIGATION_OPTION_CONTROL_FLOW_GUARD,
	PS_MITIGATION_OPTION_BLOCK_NON_MICROSOFT_BINARIES,
	PS_MITIGATION_OPTION_FONT_DISABLE,
	PS_MITIGATION_OPTION_IMAGE_LOAD_NO_REMOTE,
	PS_MITIGATION_OPTION_IMAGE_LOAD_NO_LOW_LABEL,
	PS_MITIGATION_OPTION_IMAGE_LOAD_PREFER_SYSTEM32,
	PS_MITIGATION_OPTION_RETURN_FLOW_GUARD,
	PS_MITIGATION_OPTION_LOADER_INTEGRITY_CONTINUITY,
	PS_MITIGATION_OPTION_STRICT_CONTROL_FLOW_GUARD,
	PS_MITIGATION_OPTION_RESTRICT_SET_THREAD_CONTEXT,
	PS_MITIGATION_OPTION_ROP_STACKPIVOT, // since REDSTONE3
	PS_MITIGATION_OPTION_ROP_CALLER_CHECK,
	PS_MITIGATION_OPTION_ROP_SIMEXEC,
	PS_MITIGATION_OPTION_EXPORT_ADDRESS_FILTER,
	PS_MITIGATION_OPTION_EXPORT_ADDRESS_FILTER_PLUS,
	PS_MITIGATION_OPTION_RESTRICT_CHILD_PROCESS_CREATION,
	PS_MITIGATION_OPTION_IMPORT_ADDRESS_FILTER,
	PS_MITIGATION_OPTION_MODULE_TAMPERING_PROTECTION
} PS_MITIGATION_OPTION;

typedef enum _PS_CREATE_STATE
{
	PsCreateInitialState,
	PsCreateFailOnFileOpen,
	PsCreateFailOnSectionCreate,
	PsCreateFailExeFormat,
	PsCreateFailMachineMismatch,
	PsCreateFailExeName, // Debugger specified
	PsCreateSuccess,
	PsCreateMaximumStates
} PS_CREATE_STATE;

typedef struct _PS_CREATE_INFO
{
	SIZE_T Size;
	PS_CREATE_STATE State;
	union
	{
		// PsCreateInitialState
		struct
		{
			union
			{
				ULONG InitFlags;
				struct
				{
					UCHAR WriteOutputOnExit : 1;
					UCHAR DetectManifest : 1;
					UCHAR IFEOSkipDebugger : 1;
					UCHAR IFEODoNotPropagateKeyState : 1;
					UCHAR SpareBits1 : 4;
					UCHAR SpareBits2 : 8;
					USHORT ProhibitedImageCharacteristics : 16;
				} s1;
			} u1;
			ACCESS_MASK AdditionalFileAccess;
		} InitState;

		// PsCreateFailOnSectionCreate
		struct
		{
			HANDLE FileHandle;
		} FailSection;

		// PsCreateFailExeFormat
		struct
		{
			USHORT DllCharacteristics;
		} ExeFormat;

		// PsCreateFailExeName
		struct
		{
			HANDLE IFEOKey;
		} ExeName;

		// PsCreateSuccess
		struct
		{
			union
			{
				ULONG OutputFlags;
				struct
				{
					UCHAR ProtectedProcess : 1;
					UCHAR AddressSpaceOverride : 1;
					UCHAR DevOverrideEnabled : 1; // From Image File Execution Options
					UCHAR ManifestDetected : 1;
					UCHAR ProtectedProcessLight : 1;
					UCHAR SpareBits1 : 3;
					UCHAR SpareBits2 : 8;
					USHORT SpareBits3 : 16;
				} s2;
			} u2;
			HANDLE FileHandle;
			HANDLE SectionHandle;
			ULONGLONG UserProcessParametersNative;
			ULONG UserProcessParametersWow64;
			ULONG CurrentParameterFlags;
			ULONGLONG PebAddressNative;
			ULONG PebAddressWow64;
			ULONGLONG ManifestAddress;
			ULONG ManifestSize;
		} SuccessState;
	};
} PS_CREATE_INFO, *PPS_CREATE_INFO;

#define PROCESS_CREATE_FLAGS_BREAKAWAY				0x00000001
#define PROCESS_CREATE_FLAGS_NO_DEBUG_INHERIT		0x00000002
#define PROCESS_CREATE_FLAGS_INHERIT_HANDLES		0x00000004
#define PROCESS_CREATE_FLAGS_OVERRIDE_ADDRESS_SPACE 0x00000008
#define PROCESS_CREATE_FLAGS_LARGE_PAGES			0x00000010

// Only usable with NtCreateUserProcess (Vista+):
#define PROCESS_CREATE_FLAGS_LARGE_PAGE_SYSTEM_DLL	0x00000020
#define PROCESS_CREATE_FLAGS_PROTECTED_PROCESS		0x00000040 // Only allowed if the calling process is itself protected
#define PROCESS_CREATE_FLAGS_CREATE_SESSION			0x00000080
#define PROCESS_CREATE_FLAGS_INHERIT_FROM_PARENT	0x00000100
#define PROCESS_CREATE_FLAGS_SUSPENDED				0x00000200
#define PROCESS_CREATE_FLAGS_EXTENDED_UNKNOWN		0x00000400

typedef enum _MEMORY_RESERVE_TYPE
{
	MemoryReserveUserApc,
	MemoryReserveIoCompletion,
	MemoryReserveTypeMax
} MEMORY_RESERVE_TYPE;

typedef struct _PROCESS_HANDLE_TRACING_ENABLE
{
	ULONG Flags;
} PROCESS_HANDLE_TRACING_ENABLE, *PPROCESS_HANDLE_TRACING_ENABLE;

#define PROCESS_HANDLE_TRACING_MAX_SLOTS 0x20000

typedef struct _PROCESS_HANDLE_TRACING_ENABLE_EX
{
	ULONG Flags;
	ULONG TotalSlots;
} PROCESS_HANDLE_TRACING_ENABLE_EX, *PPROCESS_HANDLE_TRACING_ENABLE_EX;

// Source: http://processhacker.sourceforge.net
typedef enum _PROCESSINFOCLASS
{
	ProcessBasicInformation, // q: PROCESS_BASIC_INFORMATION, PROCESS_EXTENDED_BASIC_INFORMATION
	ProcessQuotaLimits, // qs: QUOTA_LIMITS, QUOTA_LIMITS_EX
	ProcessIoCounters, // q: IO_COUNTERS
	ProcessVmCounters, // q: VM_COUNTERS, VM_COUNTERS_EX, VM_COUNTERS_EX2
	ProcessTimes, // q: KERNEL_USER_TIMES
	ProcessBasePriority, // s: KPRIORITY
	ProcessRaisePriority, // s: ULONG
	ProcessDebugPort, // q: HANDLE
	ProcessExceptionPort, // s: HANDLE
	ProcessAccessToken, // s: PROCESS_ACCESS_TOKEN
	ProcessLdtInformation, // qs: PROCESS_LDT_INFORMATION // 10
	ProcessLdtSize, // s: PROCESS_LDT_SIZE
	ProcessDefaultHardErrorMode, // qs: ULONG
	ProcessIoPortHandlers, // (kernel-mode only)
	ProcessPooledUsageAndLimits, // q: POOLED_USAGE_AND_LIMITS
	ProcessWorkingSetWatch, // q: PROCESS_WS_WATCH_INFORMATION[]; s: void
	ProcessUserModeIOPL,
	ProcessEnableAlignmentFaultFixup, // s: BOOLEAN
	ProcessPriorityClass, // qs: PROCESS_PRIORITY_CLASS
	ProcessWx86Information,
	ProcessHandleCount, // q: ULONG, PROCESS_HANDLE_INFORMATION // 20
	ProcessAffinityMask, // s: KAFFINITY
	ProcessPriorityBoost, // qs: ULONG
	ProcessDeviceMap, // qs: PROCESS_DEVICEMAP_INFORMATION, PROCESS_DEVICEMAP_INFORMATION_EX
	ProcessSessionInformation, // q: PROCESS_SESSION_INFORMATION
	ProcessForegroundInformation, // s: PROCESS_FOREGROUND_BACKGROUND
	ProcessWow64Information, // q: ULONG_PTR
	ProcessImageFileName, // q: UNICODE_STRING
	ProcessLUIDDeviceMapsEnabled, // q: ULONG
	ProcessBreakOnTermination, // qs: ULONG
	ProcessDebugObjectHandle, // q: HANDLE // 30
	ProcessDebugFlags, // qs: ULONG
	ProcessHandleTracing, // q: PROCESS_HANDLE_TRACING_QUERY; s: size 0 disables, otherwise enables
	ProcessIoPriority, // qs: IO_PRIORITY_HINT
	ProcessExecuteFlags, // qs: ULONG
	ProcessResourceManagement,
	ProcessCookie, // q: ULONG
	ProcessImageInformation, // q: SECTION_IMAGE_INFORMATION
	ProcessCycleTime, // q: PROCESS_CYCLE_TIME_INFORMATION // since VISTA
	ProcessPagePriority, // q: ULONG
	ProcessInstrumentationCallback, // 40
	ProcessThreadStackAllocation, // s: PROCESS_STACK_ALLOCATION_INFORMATION, PROCESS_STACK_ALLOCATION_INFORMATION_EX
	ProcessWorkingSetWatchEx, // q: PROCESS_WS_WATCH_INFORMATION_EX[]
	ProcessImageFileNameWin32, // q: UNICODE_STRING
	ProcessImageFileMapping, // q: HANDLE (input)
	ProcessAffinityUpdateMode, // qs: PROCESS_AFFINITY_UPDATE_MODE
	ProcessMemoryAllocationMode, // qs: PROCESS_MEMORY_ALLOCATION_MODE
	ProcessGroupInformation, // q: USHORT[]
	ProcessTokenVirtualizationEnabled, // s: ULONG
	ProcessConsoleHostProcess, // q: ULONG_PTR
	ProcessWindowInformation, // q: PROCESS_WINDOW_INFORMATION // 50
	ProcessHandleInformation, // q: PROCESS_HANDLE_SNAPSHOT_INFORMATION // since WIN8
	ProcessMitigationPolicy, // s: PROCESS_MITIGATION_POLICY_INFORMATION
	ProcessDynamicFunctionTableInformation,
	ProcessHandleCheckingMode,
	ProcessKeepAliveCount, // q: PROCESS_KEEPALIVE_COUNT_INFORMATION
	ProcessRevokeFileHandles, // s: PROCESS_REVOKE_FILE_HANDLES_INFORMATION
	ProcessWorkingSetControl, // s: PROCESS_WORKING_SET_CONTROL
	ProcessHandleTable, // since WINBLUE
	ProcessCheckStackExtentsMode,
	ProcessCommandLineInformation, // q: UNICODE_STRING // 60
	ProcessProtectionInformation, // q: PS_PROTECTION
	ProcessMemoryExhaustion, // PROCESS_MEMORY_EXHAUSTION_INFO // since THRESHOLD
	ProcessFaultInformation, // PROCESS_FAULT_INFORMATION
	ProcessTelemetryIdInformation, // PROCESS_TELEMETRY_ID_INFORMATION
	ProcessCommitReleaseInformation, // PROCESS_COMMIT_RELEASE_INFORMATION
	ProcessDefaultCpuSetsInformation,
	ProcessAllowedCpuSetsInformation,
	ProcessSubsystemProcess,
	ProcessJobMemoryInformation, // PROCESS_JOB_MEMORY_INFO
	ProcessInPrivate, // since THRESHOLD2 // 70
	ProcessRaiseUMExceptionOnInvalidHandleClose,
	ProcessIumChallengeResponse,
	ProcessChildProcessInformation, // PROCESS_CHILD_PROCESS_INFORMATION
	ProcessHighGraphicsPriorityInformation,
	ProcessSubsystemInformation, // q: SUBSYSTEM_INFORMATION_TYPE // since REDSTONE2
	ProcessEnergyValues, // PROCESS_ENERGY_VALUES, PROCESS_EXTENDED_ENERGY_VALUES
	ProcessActivityThrottleState, // PROCESS_ACTIVITY_THROTTLE_STATE
	ProcessActivityThrottlePolicy, // PROCESS_ACTIVITY_THROTTLE_POLICY
	ProcessWin32kSyscallFilterInformation,
	ProcessDisableSystemAllowedCpuSets,
	ProcessWakeInformation, // PROCESS_WAKE_INFORMATION
	ProcessEnergyTrackingState, // PROCESS_ENERGY_TRACKING_STATE
	ProcessManageWritesToExecutableMemory, // MANAGE_WRITES_TO_EXECUTABLE_MEMORY // since REDSTONE3
	ProcessCaptureTrustletLiveDump,
	ProcessTelemetryCoverage,
	ProcessEnclaveInformation,
	ProcessEnableReadWriteVmLogging, // PROCESS_READWRITEVM_LOGGING_INFORMATION
	ProcessUptimeInformation, // PROCESS_UPTIME_INFORMATION
	ProcessImageSection,
	MaxProcessInfoClass
} PROCESSINFOCLASS;

// Source: http://processhacker.sourceforge.net
typedef enum _SYSTEM_INFORMATION_CLASS
{
	SystemBasicInformation, // q: SYSTEM_BASIC_INFORMATION
	SystemProcessorInformation, // q: SYSTEM_PROCESSOR_INFORMATION
	SystemPerformanceInformation, // q: SYSTEM_PERFORMANCE_INFORMATION
	SystemTimeOfDayInformation, // q: SYSTEM_TIMEOFDAY_INFORMATION
	SystemPathInformation, // not implemented
	SystemProcessInformation, // q: SYSTEM_PROCESS_INFORMATION
	SystemCallCountInformation, // q: SYSTEM_CALL_COUNT_INFORMATION
	SystemDeviceInformation, // q: SYSTEM_DEVICE_INFORMATION
	SystemProcessorPerformanceInformation, // q: SYSTEM_PROCESSOR_PERFORMANCE_INFORMATION
	SystemFlagsInformation, // q: SYSTEM_FLAGS_INFORMATION
	SystemCallTimeInformation, // not implemented // SYSTEM_CALL_TIME_INFORMATION // 10
	SystemModuleInformation, // q: RTL_PROCESS_MODULES
	SystemLocksInformation, // q: RTL_PROCESS_LOCKS
	SystemStackTraceInformation, // q: RTL_PROCESS_BACKTRACES
	SystemPagedPoolInformation, // not implemented
	SystemNonPagedPoolInformation, // not implemented
	SystemHandleInformation, // q: SYSTEM_HANDLE_INFORMATION
	SystemObjectInformation, // q: SYSTEM_OBJECTTYPE_INFORMATION mixed with SYSTEM_OBJECT_INFORMATION
	SystemPageFileInformation, // q: SYSTEM_PAGEFILE_INFORMATION
	SystemVdmInstemulInformation, // q
	SystemVdmBopInformation, // not implemented // 20
	SystemFileCacheInformation, // q: SYSTEM_FILECACHE_INFORMATION; s (requires SeIncreaseQuotaPrivilege) (info for WorkingSetTypeSystemCache)
	SystemPoolTagInformation, // q: SYSTEM_POOLTAG_INFORMATION
	SystemInterruptInformation, // q: SYSTEM_INTERRUPT_INFORMATION
	SystemDpcBehaviorInformation, // q: SYSTEM_DPC_BEHAVIOR_INFORMATION; s: SYSTEM_DPC_BEHAVIOR_INFORMATION (requires SeLoadDriverPrivilege)
	SystemFullMemoryInformation, // not implemented
	SystemLoadGdiDriverInformation, // s (kernel-mode only)
	SystemUnloadGdiDriverInformation, // s (kernel-mode only)
	SystemTimeAdjustmentInformation, // q: SYSTEM_QUERY_TIME_ADJUST_INFORMATION; s: SYSTEM_SET_TIME_ADJUST_INFORMATION (requires SeSystemtimePrivilege)
	SystemSummaryMemoryInformation, // not implemented
	SystemMirrorMemoryInformation, // s (requires license value "Kernel-MemoryMirroringSupported") (requires SeShutdownPrivilege) // 30
	SystemPerformanceTraceInformation, // q; s: (type depends on EVENT_TRACE_INFORMATION_CLASS)
	SystemObsolete0, // not implemented
	SystemExceptionInformation, // q: SYSTEM_EXCEPTION_INFORMATION
	SystemCrashDumpStateInformation, // s (requires SeDebugPrivilege)
	SystemKernelDebuggerInformation, // q: SYSTEM_KERNEL_DEBUGGER_INFORMATION
	SystemContextSwitchInformation, // q: SYSTEM_CONTEXT_SWITCH_INFORMATION
	SystemRegistryQuotaInformation, // q: SYSTEM_REGISTRY_QUOTA_INFORMATION; s (requires SeIncreaseQuotaPrivilege)
	SystemExtendServiceTableInformation, // s (requires SeLoadDriverPrivilege) // loads win32k only
	SystemPrioritySeperation, // s (requires SeTcbPrivilege)
	SystemVerifierAddDriverInformation, // s (requires SeDebugPrivilege) // 40
	SystemVerifierRemoveDriverInformation, // s (requires SeDebugPrivilege)
	SystemProcessorIdleInformation, // q: SYSTEM_PROCESSOR_IDLE_INFORMATION
	SystemLegacyDriverInformation, // q: SYSTEM_LEGACY_DRIVER_INFORMATION
	SystemCurrentTimeZoneInformation, // q; s: RTL_TIME_ZONE_INFORMATION
	SystemLookasideInformation, // q: SYSTEM_LOOKASIDE_INFORMATION
	SystemTimeSlipNotification, // s (requires SeSystemtimePrivilege)
	SystemSessionCreate, // not implemented
	SystemSessionDetach, // not implemented
	SystemSessionInformation, // not implemented (SYSTEM_SESSION_INFORMATION)
	SystemRangeStartInformation, // q: SYSTEM_RANGE_START_INFORMATION // 50
	SystemVerifierInformation, // q: SYSTEM_VERIFIER_INFORMATION; s (requires SeDebugPrivilege)
	SystemVerifierThunkExtend, // s (kernel-mode only)
	SystemSessionProcessInformation, // q: SYSTEM_SESSION_PROCESS_INFORMATION
	SystemLoadGdiDriverInSystemSpace, // s (kernel-mode only) (same as SystemLoadGdiDriverInformation)
	SystemNumaProcessorMap, // q
	SystemPrefetcherInformation, // q: PREFETCHER_INFORMATION; s: PREFETCHER_INFORMATION // PfSnQueryPrefetcherInformation
	SystemExtendedProcessInformation, // q: SYSTEM_PROCESS_INFORMATION
	SystemRecommendedSharedDataAlignment, // q
	SystemComPlusPackage, // q; s
	SystemNumaAvailableMemory, // 60
	SystemProcessorPowerInformation, // q: SYSTEM_PROCESSOR_POWER_INFORMATION
	SystemEmulationBasicInformation, // q
	SystemEmulationProcessorInformation,
	SystemExtendedHandleInformation, // q: SYSTEM_HANDLE_INFORMATION_EX
	SystemLostDelayedWriteInformation, // q: ULONG
	SystemBigPoolInformation, // q: SYSTEM_BIGPOOL_INFORMATION
	SystemSessionPoolTagInformation, // q: SYSTEM_SESSION_POOLTAG_INFORMATION
	SystemSessionMappedViewInformation, // q: SYSTEM_SESSION_MAPPED_VIEW_INFORMATION
	SystemHotpatchInformation, // q; s: SYSTEM_HOTPATCH_CODE_INFORMATION
	SystemObjectSecurityMode, // q: ULONG // 70
	SystemWatchdogTimerHandler, // s (kernel-mode only)
	SystemWatchdogTimerInformation, // q (kernel-mode only); s (kernel-mode only)
	SystemLogicalProcessorInformation, // q: SYSTEM_LOGICAL_PROCESSOR_INFORMATION
	SystemWow64SharedInformationObsolete, // not implemented
	SystemRegisterFirmwareTableInformationHandler, // s (kernel-mode only)
	SystemFirmwareTableInformation, // SYSTEM_FIRMWARE_TABLE_INFORMATION
	SystemModuleInformationEx, // q: RTL_PROCESS_MODULE_INFORMATION_EX
	SystemVerifierTriageInformation, // not implemented
	SystemSuperfetchInformation, // q; s: SUPERFETCH_INFORMATION // PfQuerySuperfetchInformation
	SystemMemoryListInformation, // q: SYSTEM_MEMORY_LIST_INFORMATION; s: SYSTEM_MEMORY_LIST_COMMAND (requires SeProfileSingleProcessPrivilege) // 80
	SystemFileCacheInformationEx, // q: SYSTEM_FILECACHE_INFORMATION; s (requires SeIncreaseQuotaPrivilege) (same as SystemFileCacheInformation)
	SystemThreadPriorityClientIdInformation, // s: SYSTEM_THREAD_CID_PRIORITY_INFORMATION (requires SeIncreaseBasePriorityPrivilege)
	SystemProcessorIdleCycleTimeInformation, // q: SYSTEM_PROCESSOR_IDLE_CYCLE_TIME_INFORMATION[]
	SystemVerifierCancellationInformation, // not implemented // name:wow64:whNT32QuerySystemVerifierCancellationInformation
	SystemProcessorPowerInformationEx, // not implemented
	SystemRefTraceInformation, // q; s: SYSTEM_REF_TRACE_INFORMATION // ObQueryRefTraceInformation
	SystemSpecialPoolInformation, // q; s (requires SeDebugPrivilege) // MmSpecialPoolTag, then MmSpecialPoolCatchOverruns != 0
	SystemProcessIdInformation, // q: SYSTEM_PROCESS_ID_INFORMATION
	SystemErrorPortInformation, // s (requires SeTcbPrivilege)
	SystemBootEnvironmentInformation, // q: SYSTEM_BOOT_ENVIRONMENT_INFORMATION // 90
	SystemHypervisorInformation, // q; s (kernel-mode only)
	SystemVerifierInformationEx, // q; s: SYSTEM_VERIFIER_INFORMATION_EX
	SystemTimeZoneInformation, // s (requires SeTimeZonePrivilege)
	SystemImageFileExecutionOptionsInformation, // s: SYSTEM_IMAGE_FILE_EXECUTION_OPTIONS_INFORMATION (requires SeTcbPrivilege)
	SystemCoverageInformation, // q; s // name:wow64:whNT32QuerySystemCoverageInformation; ExpCovQueryInformation
	SystemPrefetchPatchInformation, // not implemented
	SystemVerifierFaultsInformation, // s (requires SeDebugPrivilege)
	SystemSystemPartitionInformation, // q: SYSTEM_SYSTEM_PARTITION_INFORMATION
	SystemSystemDiskInformation, // q: SYSTEM_SYSTEM_DISK_INFORMATION
	SystemProcessorPerformanceDistribution, // q: SYSTEM_PROCESSOR_PERFORMANCE_DISTRIBUTION // 100
	SystemNumaProximityNodeInformation, // q
	SystemDynamicTimeZoneInformation, // q; s (requires SeTimeZonePrivilege)
	SystemCodeIntegrityInformation, // q: SYSTEM_CODEINTEGRITY_INFORMATION // SeCodeIntegrityQueryInformation
	SystemProcessorMicrocodeUpdateInformation, // s
	SystemProcessorBrandString, // q // HaliQuerySystemInformation -> HalpGetProcessorBrandString, info class 23
	SystemVirtualAddressInformation, // q: SYSTEM_VA_LIST_INFORMATION[]; s: SYSTEM_VA_LIST_INFORMATION[] (requires SeIncreaseQuotaPrivilege) // MmQuerySystemVaInformation
	SystemLogicalProcessorAndGroupInformation, // q: SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX // since WIN7 // KeQueryLogicalProcessorRelationship
	SystemProcessorCycleTimeInformation, // q: SYSTEM_PROCESSOR_CYCLE_TIME_INFORMATION[]
	SystemStoreInformation, // q; s // SmQueryStoreInformation
	SystemRegistryAppendString, // s: SYSTEM_REGISTRY_APPEND_STRING_PARAMETERS // 110
	SystemAitSamplingValue, // s: ULONG (requires SeProfileSingleProcessPrivilege)
	SystemVhdBootInformation, // q: SYSTEM_VHD_BOOT_INFORMATION
	SystemCpuQuotaInformation, // q; s // PsQueryCpuQuotaInformation
	SystemNativeBasicInformation, // not implemented
	SystemSpare1, // not implemented
	SystemLowPriorityIoInformation, // q: SYSTEM_LOW_PRIORITY_IO_INFORMATION
	SystemTpmBootEntropyInformation, // q: TPM_BOOT_ENTROPY_NT_RESULT // ExQueryTpmBootEntropyInformation
	SystemVerifierCountersInformation, // q: SYSTEM_VERIFIER_COUNTERS_INFORMATION
	SystemPagedPoolInformationEx, // q: SYSTEM_FILECACHE_INFORMATION; s (requires SeIncreaseQuotaPrivilege) (info for WorkingSetTypePagedPool)
	SystemSystemPtesInformationEx, // q: SYSTEM_FILECACHE_INFORMATION; s (requires SeIncreaseQuotaPrivilege) (info for WorkingSetTypeSystemPtes) // 120
	SystemNodeDistanceInformation, // q
	SystemAcpiAuditInformation, // q: SYSTEM_ACPI_AUDIT_INFORMATION // HaliQuerySystemInformation -> HalpAuditQueryResults, info class 26
	SystemBasicPerformanceInformation, // q: SYSTEM_BASIC_PERFORMANCE_INFORMATION // name:wow64:whNtQuerySystemInformation_SystemBasicPerformanceInformation
	SystemQueryPerformanceCounterInformation, // q: SYSTEM_QUERY_PERFORMANCE_COUNTER_INFORMATION // since WIN7 SP1
	SystemSessionBigPoolInformation, // q: SYSTEM_SESSION_POOLTAG_INFORMATION // since WIN8
	SystemBootGraphicsInformation, // q; s: SYSTEM_BOOT_GRAPHICS_INFORMATION (kernel-mode only)
	SystemScrubPhysicalMemoryInformation, // q; s: MEMORY_SCRUB_INFORMATION
	SystemBadPageInformation,
	SystemProcessorProfileControlArea, // q; s: SYSTEM_PROCESSOR_PROFILE_CONTROL_AREA
	SystemCombinePhysicalMemoryInformation, // s: MEMORY_COMBINE_INFORMATION, MEMORY_COMBINE_INFORMATION_EX, MEMORY_COMBINE_INFORMATION_EX2 // 130
	SystemEntropyInterruptTimingCallback,
	SystemConsoleInformation, // q: SYSTEM_CONSOLE_INFORMATION
	SystemPlatformBinaryInformation, // q: SYSTEM_PLATFORM_BINARY_INFORMATION
	SystemThrottleNotificationInformation,
	SystemHypervisorProcessorCountInformation, // q: SYSTEM_HYPERVISOR_PROCESSOR_COUNT_INFORMATION
	SystemDeviceDataInformation, // q: SYSTEM_DEVICE_DATA_INFORMATION
	SystemDeviceDataEnumerationInformation,
	SystemMemoryTopologyInformation, // q: SYSTEM_MEMORY_TOPOLOGY_INFORMATION
	SystemMemoryChannelInformation, // q: SYSTEM_MEMORY_CHANNEL_INFORMATION
	SystemBootLogoInformation, // q: SYSTEM_BOOT_LOGO_INFORMATION // 140
	SystemProcessorPerformanceInformationEx, // q: SYSTEM_PROCESSOR_PERFORMANCE_INFORMATION_EX // since WINBLUE
	SystemSpare0,
	SystemSecureBootPolicyInformation, // q: SYSTEM_SECUREBOOT_POLICY_INFORMATION
	SystemPageFileInformationEx, // q: SYSTEM_PAGEFILE_INFORMATION_EX
	SystemSecureBootInformation, // q: SYSTEM_SECUREBOOT_INFORMATION
	SystemEntropyInterruptTimingRawInformation,
	SystemPortableWorkspaceEfiLauncherInformation, // q: SYSTEM_PORTABLE_WORKSPACE_EFI_LAUNCHER_INFORMATION
	SystemFullProcessInformation, // q: SYSTEM_PROCESS_INFORMATION with SYSTEM_PROCESS_INFORMATION_EXTENSION (requires admin)
	SystemKernelDebuggerInformationEx, // q: SYSTEM_KERNEL_DEBUGGER_INFORMATION_EX
	SystemBootMetadataInformation, // 150
	SystemSoftRebootInformation,
	SystemElamCertificateInformation, // s: SYSTEM_ELAM_CERTIFICATE_INFORMATION
	SystemOfflineDumpConfigInformation,
	SystemProcessorFeaturesInformation, // q: SYSTEM_PROCESSOR_FEATURES_INFORMATION
	SystemRegistryReconciliationInformation,
	SystemEdidInformation,
	SystemManufacturingInformation, // q: SYSTEM_MANUFACTURING_INFORMATION // since THRESHOLD
	SystemEnergyEstimationConfigInformation, // q: SYSTEM_ENERGY_ESTIMATION_CONFIG_INFORMATION
	SystemHypervisorDetailInformation, // q: SYSTEM_HYPERVISOR_DETAIL_INFORMATION
	SystemProcessorCycleStatsInformation, // q: SYSTEM_PROCESSOR_CYCLE_STATS_INFORMATION // 160
	SystemVmGenerationCountInformation,
	SystemTrustedPlatformModuleInformation, // q: SYSTEM_TPM_INFORMATION
	SystemKernelDebuggerFlags,
	SystemCodeIntegrityPolicyInformation, // q: SYSTEM_CODEINTEGRITYPOLICY_INFORMATION
	SystemIsolatedUserModeInformation, // q: SYSTEM_ISOLATED_USER_MODE_INFORMATION
	SystemHardwareSecurityTestInterfaceResultsInformation,
	SystemSingleModuleInformation, // q: SYSTEM_SINGLE_MODULE_INFORMATION
	SystemAllowedCpuSetsInformation,
	SystemVsmProtectionInformation, // q: SYSTEM_VSM_PROTECTION_INFORMATION (previously SystemDmaProtectionInformation)
	SystemInterruptCpuSetsInformation, // q: SYSTEM_INTERRUPT_CPU_SET_INFORMATION // 170
	SystemSecureBootPolicyFullInformation, // q: SYSTEM_SECUREBOOT_POLICY_FULL_INFORMATION
	SystemCodeIntegrityPolicyFullInformation,
	SystemAffinitizedInterruptProcessorInformation,
	SystemRootSiloInformation, // q: SYSTEM_ROOT_SILO_INFORMATION
	SystemCpuSetInformation, // q: SYSTEM_CPU_SET_INFORMATION // since THRESHOLD2
	SystemCpuSetTagInformation, // q: SYSTEM_CPU_SET_TAG_INFORMATION
	SystemWin32WerStartCallout,
	SystemSecureKernelProfileInformation, // q: SYSTEM_SECURE_KERNEL_HYPERGUARD_PROFILE_INFORMATION
	SystemCodeIntegrityPlatformManifestInformation, // q: SYSTEM_SECUREBOOT_PLATFORM_MANIFEST_INFORMATION // since REDSTONE
	SystemInterruptSteeringInformation, // 180
	SystemSupportedProcessorArchitectures,
	SystemMemoryUsageInformation, // q: SYSTEM_MEMORY_USAGE_INFORMATION
	SystemCodeIntegrityCertificateInformation, // q: SYSTEM_CODEINTEGRITY_CERTIFICATE_INFORMATION
	SystemPhysicalMemoryInformation, // q: SYSTEM_PHYSICAL_MEMORY_INFORMATION // since REDSTONE2
	SystemControlFlowTransition,
	SystemKernelDebuggingAllowed,
	SystemActivityModerationExeState, // SYSTEM_ACTIVITY_MODERATION_EXE_STATE
	SystemActivityModerationUserSettings, // SYSTEM_ACTIVITY_MODERATION_USER_SETTINGS
	SystemCodeIntegrityPoliciesFullInformation,
	SystemCodeIntegrityUnlockInformation, // SYSTEM_CODEINTEGRITY_UNLOCK_INFORMATION // 190
	SystemIntegrityQuotaInformation,
	SystemFlushInformation, // q: SYSTEM_FLUSH_INFORMATION
	SystemProcessorIdleMaskInformation, // since REDSTONE3
	SystemSecureDumpEncryptionInformation,
	SystemWriteConstraintInformation, // SYSTEM_WRITE_CONSTRAINT_INFORMATION
	SystemKernelVaShadowInformation, // SYSTEM_KERNEL_VA_SHADOW_INFORMATION
	SystemHypervisorSharedPageInformation, // SYSTEM_HYPERVISOR_SHARED_PAGE_INFORMATION // since REDSTONE4
	SystemFirmwareBootPerformanceInformation,
	SystemCodeIntegrityVerificationInformation, // SYSTEM_CODEINTEGRITYVERIFICATION_INFORMATION
	SystemFirmwarePartitionInformation, // 200
	SystemSpeculationControlInformation, // SYSTEM_SPECULATION_CONTROL_INFORMATION // (CVE-2017-5715) REDSTONE3 and above.
	SystemDmaGuardPolicyInformation, // SYSTEM_DMA_GUARD_POLICY_INFORMATION
	SystemEnclaveLaunchControlInformation, // SYSTEM_ENCLAVE_LAUNCH_CONTROL_INFORMATION
	SystemWorkloadAllowedCpuSetsInformation, // SYSTEM_WORKLOAD_ALLOWED_CPU_SET_INFORMATION // since REDSTONE5
	SystemCodeIntegrityUnlockModeInformation,
	SystemLeapSecondInformation, // SYSTEM_LEAP_SECOND_INFORMATION
	SystemFlags2Information,
	MaxSystemInfoClass
} SYSTEM_INFORMATION_CLASS;

typedef enum _OBJECT_INFORMATION_CLASS
{
	ObjectBasicInformation, // OBJECT_BASIC_INFORMATION
	ObjectNameInformation, // OBJECT_NAME_INFORMATION
	ObjectTypeInformation, // OBJECT_TYPE_INFORMATION
	ObjectTypesInformation, // OBJECT_TYPES_INFORMATION
	ObjectHandleFlagInformation, // OBJECT_HANDLE_FLAG_INFORMATION
	ObjectSessionInformation,
	ObjectSessionObjectInformation,
	MaxObjectInfoClass
} OBJECT_INFORMATION_CLASS;

// Source: http://processhacker.sourceforge.net
typedef enum _THREADINFOCLASS
{
	ThreadBasicInformation, // q: THREAD_BASIC_INFORMATION
	ThreadTimes, // q: KERNEL_USER_TIMES
	ThreadPriority, // s: KPRIORITY
	ThreadBasePriority, // s: LONG
	ThreadAffinityMask, // s: KAFFINITY
	ThreadImpersonationToken, // s: HANDLE
	ThreadDescriptorTableEntry, // q: DESCRIPTOR_TABLE_ENTRY (or WOW64_DESCRIPTOR_TABLE_ENTRY)
	ThreadEnableAlignmentFaultFixup, // s: BOOLEAN
	ThreadEventPair,
	ThreadQuerySetWin32StartAddress, // q: PVOID
	ThreadZeroTlsCell, // 10
	ThreadPerformanceCount, // q: LARGE_INTEGER
	ThreadAmILastThread, // q: ULONG
	ThreadIdealProcessor, // s: ULONG
	ThreadPriorityBoost, // qs: ULONG
	ThreadSetTlsArrayAddress,
	ThreadIsIoPending, // q: ULONG
	ThreadHideFromDebugger, // s: void
	ThreadBreakOnTermination, // qs: ULONG
	ThreadSwitchLegacyState,
	ThreadIsTerminated, // q: ULONG // 20
	ThreadLastSystemCall, // q: THREAD_LAST_SYSCALL_INFORMATION
	ThreadIoPriority, // qs: IO_PRIORITY_HINT
	ThreadCycleTime, // q: THREAD_CYCLE_TIME_INFORMATION
	ThreadPagePriority, // q: ULONG
	ThreadActualBasePriority,
	ThreadTebInformation, // q: THREAD_TEB_INFORMATION (requires THREAD_GET_CONTEXT + THREAD_SET_CONTEXT)
	ThreadCSwitchMon,
	ThreadCSwitchPmu,
	ThreadWow64Context, // q: WOW64_CONTEXT
	ThreadGroupInformation, // q: GROUP_AFFINITY // 30
	ThreadUmsInformation, // q: THREAD_UMS_INFORMATION
	ThreadCounterProfiling,
	ThreadIdealProcessorEx, // q: PROCESSOR_NUMBER
	ThreadCpuAccountingInformation, // since WIN8
	ThreadSuspendCount, // since WINBLUE
	ThreadHeterogeneousCpuPolicy, // q: KHETERO_CPU_POLICY // since THRESHOLD
	ThreadContainerId, // q: GUID
	ThreadNameInformation, // qs: THREAD_NAME_INFORMATION
	ThreadSelectedCpuSets,
	ThreadSystemThreadInformation, // q: SYSTEM_THREAD_INFORMATION // 40
	ThreadActualGroupAffinity, // since THRESHOLD2
	ThreadDynamicCodePolicyInfo,
	ThreadExplicitCaseSensitivity,
	ThreadWorkOnBehalfTicket,
	ThreadSubsystemInformation, // q: SUBSYSTEM_INFORMATION_TYPE // since REDSTONE2
	ThreadDbgkWerReportActive,
	ThreadAttachContainer,
	ThreadManageWritesToExecutableMemory, // MANAGE_WRITES_TO_EXECUTABLE_MEMORY // since REDSTONE3
	ThreadPowerThrottlingState, // THREAD_POWER_THROTTLING_STATE
	MaxThreadInfoClass
} THREADINFOCLASS;

typedef enum _FSINFOCLASS
{
	FileFsVolumeInformation			= 1,	// FILE_FS_VOLUME_INFORMATION
	FileFsLabelInformation			= 2,	// FILE_FS_LABEL_INFORMATION
	FileFsSizeInformation			= 3,	// FILE_FS_SIZE_INFORMATION
	FileFsDeviceInformation			= 4,	// FILE_FS_DEVICE_INFORMATION
	FileFsAttributeInformation		= 5,	// FILE_FS_ATTRIBUTE_INFORMATION
	FileFsControlInformation		= 6,	// FILE_FS_CONTROL_INFORMATION
	FileFsFullSizeInformation		= 7,	// FILE_FS_FULL_SIZE_INFORMATION
	FileFsObjectIdInformation		= 8,	// FILE_FS_OBJECTID_INFORMATION
	FileFsDriverPathInformation		= 9,	// FILE_FS_DRIVER_PATH_INFORMATION
	FileFsVolumeFlagsInformation	= 10,	// FILE_FS_VOLUME_FLAGS_INFORMATION
	FileFsSectorSizeInformation		= 11,	// FILE_FS_SECTOR_SIZE_INFORMATION // since WIN8
	FileFsDataCopyInformation		= 12,	// FILE_FS_DATA_COPY_INFORMATION
	FileFsMetadataSizeInformation	= 13,	// FILE_FS_METADATA_SIZE_INFORMATION // since THRESHOLD
	FileFsMaximumInformation
} FS_INFORMATION_CLASS, *PFS_INFORMATION_CLASS;

typedef enum _MEMORY_INFORMATION_CLASS
{
	MemoryBasicInformation, // MEMORY_BASIC_INFORMATION
	MemoryWorkingSetInformation, // MEMORY_WORKING_SET_INFORMATION
	MemoryMappedFilenameInformation, // UNICODE_STRING
	MemoryRegionInformation, // MEMORY_REGION_INFORMATION
	MemoryWorkingSetExInformation, // MEMORY_WORKING_SET_EX_INFORMATION
	MemorySharedCommitInformation, // MEMORY_SHARED_COMMIT_INFORMATION
	MemoryImageInformation, // MEMORY_IMAGE_INFORMATION
	MemoryRegionInformationEx,
	MemoryPrivilegedBasicInformation
} MEMORY_INFORMATION_CLASS;

typedef enum _SECTION_INFORMATION_CLASS
{
	SectionBasicInformation, // q; SECTION_BASIC_INFORMATION
	SectionImageInformation, // q; SECTION_IMAGE_INFORMATION
	SectionRelocationInformation, // name:wow64:whNtQuerySection_SectionRelocationInformation
	SectionOriginalBaseInformation, // PVOID BaseAddress
	SectionInternalImageInformation, // SECTION_INTERNAL_IMAGE_INFORMATION // since REDSTONE2
	MaxSectionInfoClass
} SECTION_INFORMATION_CLASS;

// Boot condition flags (NtInitializeRegistry)
#define REG_INIT_BOOT_SM				0x0000
#define REG_INIT_BOOT_SETUP				0x0001
#define REG_INIT_BOOT_ACCEPTED_BASE		0x0002
#define REG_INIT_BOOT_ACCEPTED_MAX		(REG_INIT_BOOT_ACCEPTED_BASE + 999)

#define REG_MAX_KEY_VALUE_NAME_LENGTH	32767
#define REG_MAX_KEY_NAME_LENGTH			512

typedef enum _KEY_INFORMATION_CLASS
{
	KeyBasicInformation, // KEY_BASIC_INFORMATION
	KeyNodeInformation, // KEY_NODE_INFORMATION
	KeyFullInformation, // KEY_FULL_INFORMATION
	KeyNameInformation, // KEY_NAME_INFORMATION
	KeyCachedInformation, // KEY_CACHED_INFORMATION
	KeyFlagsInformation, // KEY_FLAGS_INFORMATION
	KeyVirtualizationInformation, // KEY_VIRTUALIZATION_INFORMATION
	KeyHandleTagsInformation, // KEY_HANDLE_TAGS_INFORMATION
	KeyTrustInformation, // KEY_TRUST_INFORMATION
	KeyLayerInformation, // KEY_LAYER_INFORMATION
	MaxKeyInfoClass
} KEY_INFORMATION_CLASS;

typedef struct _KEY_BASIC_INFORMATION
{
	LARGE_INTEGER LastWriteTime;
	ULONG TitleIndex;
	ULONG NameLength;
	WCHAR Name[1];
} KEY_BASIC_INFORMATION, *PKEY_BASIC_INFORMATION;

typedef struct _KEY_NODE_INFORMATION
{
	LARGE_INTEGER LastWriteTime;
	ULONG TitleIndex;
	ULONG ClassOffset;
	ULONG ClassLength;
	ULONG NameLength;
	WCHAR Name[1];
	// ...
	// WCHAR Class[1];
} KEY_NODE_INFORMATION, *PKEY_NODE_INFORMATION;

typedef struct _KEY_FULL_INFORMATION
{
	LARGE_INTEGER LastWriteTime;
	ULONG TitleIndex;
	ULONG ClassOffset;
	ULONG ClassLength;
	ULONG SubKeys;
	ULONG MaxNameLen;
	ULONG MaxClassLen;
	ULONG Values;
	ULONG MaxValueNameLen;
	ULONG MaxValueDataLen;
	WCHAR Class[1];
} KEY_FULL_INFORMATION, *PKEY_FULL_INFORMATION;

typedef struct _KEY_NAME_INFORMATION
{
	ULONG NameLength;
	WCHAR Name[1];
} KEY_NAME_INFORMATION, *PKEY_NAME_INFORMATION;

typedef struct _KEY_CACHED_INFORMATION
{
	LARGE_INTEGER LastWriteTime;
	ULONG TitleIndex;
	ULONG SubKeys;
	ULONG MaxNameLen;
	ULONG Values;
	ULONG MaxValueNameLen;
	ULONG MaxValueDataLen;
	ULONG NameLength;
	WCHAR Name[1];
} KEY_CACHED_INFORMATION, *PKEY_CACHED_INFORMATION;

typedef struct _KEY_FLAGS_INFORMATION
{
	ULONG UserFlags;
} KEY_FLAGS_INFORMATION, *PKEY_FLAGS_INFORMATION;

typedef struct _KEY_VIRTUALIZATION_INFORMATION
{
	ULONG VirtualizationCandidate : 1; // Tells whether the key is part of the virtualization namespace scope (only HKLM\Software for now).
	ULONG VirtualizationEnabled : 1; // Tells whether virtualization is enabled on this key. Can be 1 only if above flag is 1.
	ULONG VirtualTarget : 1; // Tells if the key is a virtual key. Can be 1 only if above 2 are 0. Valid only on the virtual store key handles.
	ULONG VirtualStore : 1; // Tells if the key is a part of the virtual store path. Valid only on the virtual store key handles.
	ULONG VirtualSource : 1; // Tells if the key has ever been virtualized, can be 1 only if VirtualizationCandidate is 1.
	ULONG Reserved : 27;
} KEY_VIRTUALIZATION_INFORMATION, *PKEY_VIRTUALIZATION_INFORMATION;

// private
typedef struct _KEY_TRUST_INFORMATION
{
	ULONG TrustedKey : 1;
	ULONG Reserved : 31;
} KEY_TRUST_INFORMATION, *PKEY_TRUST_INFORMATION;

// private
typedef struct _KEY_LAYER_INFORMATION
{
	ULONG IsTombstone;
	ULONG IsSupersedeLocal;
	ULONG IsSupersedeTree;
	ULONG ClassIsInherited;
	ULONG Reserved;
} KEY_LAYER_INFORMATION, *PKEY_LAYER_INFORMATION;

typedef enum _KEY_SET_INFORMATION_CLASS
{
	KeyWriteTimeInformation, // KEY_WRITE_TIME_INFORMATION
	KeyWow64FlagsInformation, // KEY_WOW64_FLAGS_INFORMATION
	KeyControlFlagsInformation, // KEY_CONTROL_FLAGS_INFORMATION
	KeySetVirtualizationInformation, // KEY_SET_VIRTUALIZATION_INFORMATION
	KeySetDebugInformation,
	KeySetHandleTagsInformation, // KEY_HANDLE_TAGS_INFORMATION
	KeySetLayerInformation, // KEY_SET_LAYER_INFORMATION
	MaxKeySetInfoClass
} KEY_SET_INFORMATION_CLASS;

typedef struct _KEY_WRITE_TIME_INFORMATION
{
	LARGE_INTEGER LastWriteTime;
} KEY_WRITE_TIME_INFORMATION, *PKEY_WRITE_TIME_INFORMATION;

typedef struct _KEY_WOW64_FLAGS_INFORMATION
{
	ULONG UserFlags;
} KEY_WOW64_FLAGS_INFORMATION, *PKEY_WOW64_FLAGS_INFORMATION;

typedef struct _KEY_HANDLE_TAGS_INFORMATION
{
	ULONG HandleTags;
} KEY_HANDLE_TAGS_INFORMATION, *PKEY_HANDLE_TAGS_INFORMATION;

typedef struct _KEY_SET_LAYER_INFORMATION
{
	ULONG IsTombstone : 1;
	ULONG IsSupersedeLocal : 1;
	ULONG IsSupersedeTree : 1;
	ULONG ClassIsInherited : 1;
	ULONG Reserved : 28;
} KEY_SET_LAYER_INFORMATION, *PKEY_SET_LAYER_INFORMATION;

typedef struct _KEY_CONTROL_FLAGS_INFORMATION
{
	ULONG ControlFlags;
} KEY_CONTROL_FLAGS_INFORMATION, *PKEY_CONTROL_FLAGS_INFORMATION;

typedef struct _KEY_SET_VIRTUALIZATION_INFORMATION
{
	ULONG VirtualTarget : 1;
	ULONG VirtualStore : 1;
	ULONG VirtualSource : 1; // true if key has been virtualized at least once
	ULONG Reserved : 29;
} KEY_SET_VIRTUALIZATION_INFORMATION, *PKEY_SET_VIRTUALIZATION_INFORMATION;

typedef enum _KEY_VALUE_INFORMATION_CLASS
{
	KeyValueBasicInformation, // KEY_VALUE_BASIC_INFORMATION
	KeyValueFullInformation, // KEY_VALUE_FULL_INFORMATION
	KeyValuePartialInformation, // KEY_VALUE_PARTIAL_INFORMATION
	KeyValueFullInformationAlign64,
	KeyValuePartialInformationAlign64, // KEY_VALUE_PARTIAL_INFORMATION_ALIGN64
	KeyValueLayerInformation, // KEY_VALUE_LAYER_INFORMATION
	MaxKeyValueInfoClass
} KEY_VALUE_INFORMATION_CLASS;

typedef struct _KEY_VALUE_BASIC_INFORMATION
{
	ULONG TitleIndex;
	ULONG Type;
	ULONG NameLength;
	WCHAR Name[1];
} KEY_VALUE_BASIC_INFORMATION, *PKEY_VALUE_BASIC_INFORMATION;

typedef struct _KEY_VALUE_FULL_INFORMATION
{
	ULONG TitleIndex;
	ULONG Type;
	ULONG DataOffset;
	ULONG DataLength;
	ULONG NameLength;
	WCHAR Name[1];
	// ...
	// UCHAR Data[1];
} KEY_VALUE_FULL_INFORMATION, *PKEY_VALUE_FULL_INFORMATION;

typedef struct _KEY_VALUE_PARTIAL_INFORMATION
{
	ULONG TitleIndex;
	ULONG Type;
	ULONG DataLength;
	UCHAR Data[1];
} KEY_VALUE_PARTIAL_INFORMATION, *PKEY_VALUE_PARTIAL_INFORMATION;

typedef struct _KEY_VALUE_PARTIAL_INFORMATION_ALIGN64
{
	ULONG Type;
	ULONG DataLength;
	UCHAR Data[1];
} KEY_VALUE_PARTIAL_INFORMATION_ALIGN64, *PKEY_VALUE_PARTIAL_INFORMATION_ALIGN64;

// private
typedef struct _KEY_VALUE_LAYER_INFORMATION
{
	ULONG IsTombstone;
	ULONG Reserved;
} KEY_VALUE_LAYER_INFORMATION, *PKEY_VALUE_LAYER_INFORMATION;

typedef struct _KEY_VALUE_ENTRY
{
	PUNICODE_STRING ValueName;
	ULONG DataLength;
	ULONG DataOffset;
	ULONG Type;
} KEY_VALUE_ENTRY, *PKEY_VALUE_ENTRY;

typedef enum _REG_ACTION
{
	KeyAdded,
	KeyRemoved,
	KeyModified
} REG_ACTION;

typedef struct _REG_NOTIFY_INFORMATION
{
	ULONG NextEntryOffset;
	REG_ACTION Action;
	ULONG KeyLength;
	WCHAR Key[1];
} REG_NOTIFY_INFORMATION, *PREG_NOTIFY_INFORMATION;

typedef struct _KEY_PID_ARRAY
{
	HANDLE PID;
	UNICODE_STRING KeyName;
} KEY_PID_ARRAY, *PKEY_PID_ARRAY;

typedef struct _KEY_OPEN_SUBKEYS_INFORMATION
{
	ULONG Count;
	KEY_PID_ARRAY KeyArray[1];
} KEY_OPEN_SUBKEYS_INFORMATION, *PKEY_OPEN_SUBKEYS_INFORMATION;

typedef enum _SYSDBG_COMMAND
{
	SysDbgQueryModuleInformation,
	SysDbgQueryTraceInformation,
	SysDbgSetTracepoint,
	SysDbgSetSpecialCall,
	SysDbgClearSpecialCalls,
	SysDbgQuerySpecialCalls,
	SysDbgBreakPoint,
	SysDbgQueryVersion,
	SysDbgReadVirtual,
	SysDbgWriteVirtual,
	SysDbgReadPhysical,
	SysDbgWritePhysical,
	SysDbgReadControlSpace,
	SysDbgWriteControlSpace,
	SysDbgReadIoSpace,
	SysDbgWriteIoSpace,
	SysDbgReadMsr,
	SysDbgWriteMsr,
	SysDbgReadBusData,
	SysDbgWriteBusData,
	SysDbgCheckLowMemory,
	SysDbgEnableKernelDebugger,
	SysDbgDisableKernelDebugger,
	SysDbgGetAutoKdEnable,
	SysDbgSetAutoKdEnable,
	SysDbgGetPrintBufferSize,
	SysDbgSetPrintBufferSize,
	SysDbgGetKdUmExceptionEnable,
	SysDbgSetKdUmExceptionEnable,
	SysDbgGetTriageDump,
	SysDbgGetKdBlockEnable,
	SysDbgSetKdBlockEnable,
	SysDbgRegisterForUmBreakInfo,
	SysDbgGetUmBreakPid,
	SysDbgClearUmBreakPid,
	SysDbgGetUmAttachPid,
	SysDbgClearUmAttachPid,
	SysDbgGetLiveKernelDump
} SYSDBG_COMMAND, *PSYSDBG_COMMAND;

typedef enum _DEBUGOBJECTINFOCLASS
{
	DebugObjectFlags = 1,
	MaxDebugObjectInfoClass
} DEBUGOBJECTINFOCLASS, *PDEBUGOBJECTINFOCLASS;

// Source: http://processhacker.sourceforge.net
typedef enum _FILE_INFORMATION_CLASS
{
	FileDirectoryInformation = 1, // FILE_DIRECTORY_INFORMATION
	FileFullDirectoryInformation, // FILE_FULL_DIR_INFORMATION
	FileBothDirectoryInformation, // FILE_BOTH_DIR_INFORMATION
	FileBasicInformation, // FILE_BASIC_INFORMATION
	FileStandardInformation, // FILE_STANDARD_INFORMATION
	FileInternalInformation, // FILE_INTERNAL_INFORMATION
	FileEaInformation, // FILE_EA_INFORMATION
	FileAccessInformation, // FILE_ACCESS_INFORMATION
	FileNameInformation, // FILE_NAME_INFORMATION
	FileRenameInformation, // FILE_RENAME_INFORMATION // 10
	FileLinkInformation, // FILE_LINK_INFORMATION
	FileNamesInformation, // FILE_NAMES_INFORMATION
	FileDispositionInformation, // FILE_DISPOSITION_INFORMATION
	FilePositionInformation, // FILE_POSITION_INFORMATION
	FileFullEaInformation, // FILE_FULL_EA_INFORMATION
	FileModeInformation, // FILE_MODE_INFORMATION
	FileAlignmentInformation, // FILE_ALIGNMENT_INFORMATION
	FileAllInformation, // FILE_ALL_INFORMATION
	FileAllocationInformation, // FILE_ALLOCATION_INFORMATION
	FileEndOfFileInformation, // FILE_END_OF_FILE_INFORMATION // 20
	FileAlternateNameInformation, // FILE_NAME_INFORMATION
	FileStreamInformation, // FILE_STREAM_INFORMATION
	FilePipeInformation, // FILE_PIPE_INFORMATION
	FilePipeLocalInformation, // FILE_PIPE_LOCAL_INFORMATION
	FilePipeRemoteInformation, // FILE_PIPE_REMOTE_INFORMATION
	FileMailslotQueryInformation, // FILE_MAILSLOT_QUERY_INFORMATION
	FileMailslotSetInformation, // FILE_MAILSLOT_SET_INFORMATION
	FileCompressionInformation, // FILE_COMPRESSION_INFORMATION
	FileObjectIdInformation, // FILE_OBJECTID_INFORMATION
	FileCompletionInformation, // FILE_COMPLETION_INFORMATION // 30
	FileMoveClusterInformation, // FILE_MOVE_CLUSTER_INFORMATION
	FileQuotaInformation, // FILE_QUOTA_INFORMATION
	FileReparsePointInformation, // FILE_REPARSE_POINT_INFORMATION
	FileNetworkOpenInformation, // FILE_NETWORK_OPEN_INFORMATION
	FileAttributeTagInformation, // FILE_ATTRIBUTE_TAG_INFORMATION
	FileTrackingInformation, // FILE_TRACKING_INFORMATION
	FileIdBothDirectoryInformation, // FILE_ID_BOTH_DIR_INFORMATION
	FileIdFullDirectoryInformation, // FILE_ID_FULL_DIR_INFORMATION
	FileValidDataLengthInformation, // FILE_VALID_DATA_LENGTH_INFORMATION
	FileShortNameInformation, // FILE_NAME_INFORMATION // 40
	FileIoCompletionNotificationInformation, // FILE_IO_COMPLETION_NOTIFICATION_INFORMATION // since VISTA
	FileIoStatusBlockRangeInformation, // FILE_IOSTATUSBLOCK_RANGE_INFORMATION
	FileIoPriorityHintInformation, // FILE_IO_PRIORITY_HINT_INFORMATION
	FileSfioReserveInformation, // FILE_SFIO_RESERVE_INFORMATION
	FileSfioVolumeInformation, // FILE_SFIO_VOLUME_INFORMATION
	FileHardLinkInformation, // FILE_LINKS_INFORMATION
	FileProcessIdsUsingFileInformation, // FILE_PROCESS_IDS_USING_FILE_INFORMATION
	FileNormalizedNameInformation, // FILE_NAME_INFORMATION
	FileNetworkPhysicalNameInformation, // FILE_NETWORK_PHYSICAL_NAME_INFORMATION
	FileIdGlobalTxDirectoryInformation, // FILE_ID_GLOBAL_TX_DIR_INFORMATION // since WIN7 // 50
	FileIsRemoteDeviceInformation, // FILE_IS_REMOTE_DEVICE_INFORMATION
	FileUnusedInformation,
	FileNumaNodeInformation, // FILE_NUMA_NODE_INFORMATION
	FileStandardLinkInformation, // FILE_STANDARD_LINK_INFORMATION
	FileRemoteProtocolInformation, // FILE_REMOTE_PROTOCOL_INFORMATION
	FileRenameInformationBypassAccessCheck, // (kernel-mode only); FILE_RENAME_INFORMATION // since WIN8
	FileLinkInformationBypassAccessCheck, // (kernel-mode only); FILE_LINK_INFORMATION
	FileVolumeNameInformation, // FILE_VOLUME_NAME_INFORMATION
	FileIdInformation, // FILE_ID_INFORMATION
	FileIdExtdDirectoryInformation, // FILE_ID_EXTD_DIR_INFORMATION
	FileReplaceCompletionInformation, // FILE_COMPLETION_INFORMATION // since WINBLUE
	FileHardLinkFullIdInformation, // FILE_LINK_ENTRY_FULL_ID_INFORMATION
	FileIdExtdBothDirectoryInformation, // FILE_ID_EXTD_BOTH_DIR_INFORMATION // since THRESHOLD
	FileDispositionInformationEx, // FILE_DISPOSITION_INFO_EX // since REDSTONE
	FileRenameInformationEx,
	FileRenameInformationExBypassAccessCheck,
	FileDesiredStorageClassInformation, // FILE_DESIRED_STORAGE_CLASS_INFORMATION // since REDSTONE2
	FileStatInformation, // FILE_STAT_INFORMATION
	FileMemoryPartitionInformation, // FILE_MEMORY_PARTITION_INFORMATION // since REDSTONE3
	FileMaximumInformation
} FILE_INFORMATION_CLASS, *PFILE_INFORMATION_CLASS;

typedef struct _SYSTEM_BASIC_INFORMATION
{
	ULONG Reserved;
	ULONG TimerResolution;
	ULONG PageSize;
	ULONG NumberOfPhysicalPages;
	ULONG LowestPhysicalPageNumber;
	ULONG HighestPhysicalPageNumber;
	ULONG AllocationGranularity;
	ULONG_PTR MinimumUserModeAddress;
	ULONG_PTR MaximumUserModeAddress;
	ULONG_PTR ActiveProcessorsAffinityMask;
	CCHAR NumberOfProcessors;
} SYSTEM_BASIC_INFORMATION, *PSYSTEM_BASIC_INFORMATION;

typedef struct _FILE_PIPE_PEEK_BUFFER
{
	ULONG NamedPipeState;
	ULONG ReadDataAvailable;
	ULONG NumberOfMessages;
	ULONG MessageLength;
	CHAR Data[1];
} FILE_PIPE_PEEK_BUFFER, *PFILE_PIPE_PEEK_BUFFER;

typedef struct _NAMED_PIPE_CREATE_PARAMETERS
{
	ULONG NamedPipeType;
	ULONG ReadMode;
	ULONG CompletionMode;
	ULONG MaximumInstances;
	ULONG InboundQuota;
	ULONG OutboundQuota;
	LARGE_INTEGER DefaultTimeout;
	BOOLEAN TimeoutSpecified;
} NAMED_PIPE_CREATE_PARAMETERS, *PNAMED_PIPE_CREATE_PARAMETERS;

typedef struct _FILE_NETWORK_OPEN_INFORMATION
{
	LARGE_INTEGER CreationTime;
	LARGE_INTEGER LastAccessTime;
	LARGE_INTEGER LastWriteTime;
	LARGE_INTEGER ChangeTime;
	LARGE_INTEGER AllocationSize;
	LARGE_INTEGER EndOfFile;
	ULONG FileAttributes;
} FILE_NETWORK_OPEN_INFORMATION, *PFILE_NETWORK_OPEN_INFORMATION;

typedef struct _SYSTEM_TIMEOFDAY_INFORMATION
{
	LARGE_INTEGER BootTime;
	LARGE_INTEGER CurrentTime;
	LARGE_INTEGER TimeZoneBias;
	ULONG TimeZoneId;
	ULONG Reserved;
	ULONGLONG BootTimeBias;
	ULONGLONG SleepTimeBias;
} SYSTEM_TIMEOFDAY_INFORMATION, *PSYSTEM_TIMEOFDAY_INFORMATION;

typedef struct _TIME_FIELDS
{
	SHORT Year;			// range [1601...]
	SHORT Month;		// range [1..12]
	SHORT Day;			// range [1..31]
	SHORT Hour;			// range [0..23]
	SHORT Minute;		// range [0..59]
	SHORT Second;		// range [0..59]
	SHORT Milliseconds;	// range [0..999]
	SHORT Weekday;		// range [0..6] == [Sunday..Saturday]
} TIME_FIELDS, *PTIME_FIELDS;

typedef struct _SYSTEM_CONSOLE_INFORMATION
{
	ULONG DriverLoaded : 1;
	ULONG Spare : 31;
} SYSTEM_CONSOLE_INFORMATION, *PSYSTEM_CONSOLE_INFORMATION;

typedef struct _COMPRESSED_DATA_INFO
{
	USHORT CompressionFormatAndEngine; // COMPRESSION_FORMAT_* and COMPRESSION_ENGINE_*

	UCHAR CompressionUnitShift;
	UCHAR ChunkShift;
	UCHAR ClusterShift;
	UCHAR Reserved;

	USHORT NumberOfChunks;

	ULONG CompressedChunkSizes[1];
} COMPRESSED_DATA_INFO, *PCOMPRESSED_DATA_INFO;

typedef struct _KSYSTEM_TIME
{
	ULONG LowPart;
	LONG High1Time;
	LONG High2Time;
} KSYSTEM_TIME, *PKSYSTEM_TIME;

typedef struct _PROCESS_ACCESS_TOKEN
{
	HANDLE Token; // Needs TOKEN_ASSIGN_PRIMARY access
	HANDLE Thread; // Handle to initial/only thread; needs THREAD_QUERY_INFORMATION access
} PROCESS_ACCESS_TOKEN, *PPROCESS_ACCESS_TOKEN;

#ifdef __cplusplus
typedef enum _PS_PROTECTED_TYPE : UCHAR
{
	PsProtectedTypeNone,
	PsProtectedTypeProtectedLight,
	PsProtectedTypeProtected,
	PsProtectedTypeMax
} PS_PROTECTED_TYPE;
#else
typedef UCHAR PS_PROTECTED_TYPE;
#endif

#ifdef __cplusplus
typedef enum _PS_PROTECTED_SIGNER : UCHAR
{
	PsProtectedSignerNone,
	PsProtectedSignerAuthenticode,
	PsProtectedSignerCodeGen,
	PsProtectedSignerAntimalware,
	PsProtectedSignerLsa,
	PsProtectedSignerWindows,
	PsProtectedSignerWinTcb,
	PsProtectedSignerWinSystem,
	PsProtectedSignerApp,
	PsProtectedSignerMax
} PS_PROTECTED_SIGNER;
#else
typedef UCHAR PS_PROTECTED_SIGNER;
#endif

typedef struct _PS_PROTECTION
{
	union
	{
		struct
		{
			PS_PROTECTED_TYPE Type : 3;
			BOOLEAN Audit : 1;
			PS_PROTECTED_SIGNER Signer : 4;
		} s;
		UCHAR Level;
	};
} PS_PROTECTION, *PPS_PROTECTION;

#define RTL_CREATE_ENVIRONMENT_TRANSLATE			0x1 // Translate from multi-byte to Unicode
#define RTL_CREATE_ENVIRONMENT_TRANSLATE_FROM_OEM	0x2 // Translate from OEM to Unicode (Translate flag must also be set)
#define RTL_CREATE_ENVIRONMENT_EMPTY				0x4 // Create empty environment block

typedef struct _RTL_BUFFER {
	PUCHAR Buffer;
	PUCHAR StaticBuffer;
	SIZE_T Size;
	SIZE_T StaticSize;
	SIZE_T ReservedForAllocatedSize; // for future doubling
	PVOID ReservedForIMalloc; // for future pluggable growth
} RTL_BUFFER, *PRTL_BUFFER;

typedef struct _RTL_UNICODE_STRING_BUFFER {
	UNICODE_STRING String;
	RTL_BUFFER ByteBuffer;
	UCHAR MinimumStaticBufferForTerminalNul[sizeof(WCHAR)];
} RTL_UNICODE_STRING_BUFFER, *PRTL_UNICODE_STRING_BUFFER;

typedef struct _RTL_USER_PROCESS_PARAMETERS
{
	ULONG MaximumLength;
	ULONG Length;

	ULONG Flags;
	ULONG DebugFlags;

	HANDLE ConsoleHandle;
	ULONG ConsoleFlags;
	HANDLE StandardInput;
	HANDLE StandardOutput;
	HANDLE StandardError;

	CURDIR CurrentDirectory;
	UNICODE_STRING DllPath;
	UNICODE_STRING ImagePathName;
	UNICODE_STRING CommandLine;
	PWCHAR Environment;

	ULONG StartingX;
	ULONG StartingY;
	ULONG CountX;
	ULONG CountY;
	ULONG CountCharsX;
	ULONG CountCharsY;
	ULONG FillAttribute;

	ULONG WindowFlags;
	ULONG ShowWindowFlags;
	UNICODE_STRING WindowTitle;
	UNICODE_STRING DesktopInfo;
	UNICODE_STRING ShellInfo;
	UNICODE_STRING RuntimeData;
	RTL_DRIVE_LETTER_CURDIR CurrentDirectories[RTL_MAX_DRIVE_LETTERS];

	ULONG_PTR EnvironmentSize;
	ULONG_PTR EnvironmentVersion;
	PVOID PackageDependencyData;
	ULONG ProcessGroupId;
	ULONG LoaderThreads;
} RTL_USER_PROCESS_PARAMETERS, *PRTL_USER_PROCESS_PARAMETERS;

#define RTL_USER_PROCESS_PARAMETERS_NORMALIZED				0x01
#define RTL_USER_PROCESS_PARAMETERS_PROFILE_USER			0x02
#define RTL_USER_PROCESS_PARAMETERS_PROFILE_KERNEL			0x04
#define RTL_USER_PROCESS_PARAMETERS_PROFILE_SERVER			0x08
#define RTL_USER_PROCESS_PARAMETERS_RESERVE_1MB				0x20
#define RTL_USER_PROCESS_PARAMETERS_RESERVE_16MB			0x40
#define RTL_USER_PROCESS_PARAMETERS_CASE_SENSITIVE			0x80
#define RTL_USER_PROCESS_PARAMETERS_DISABLE_HEAP_DECOMMIT	0x100
#define RTL_USER_PROCESS_PARAMETERS_DLL_REDIRECTION_LOCAL	0x1000
#define RTL_USER_PROCESS_PARAMETERS_APP_MANIFEST_PRESENT	0x2000
#define RTL_USER_PROCESS_PARAMETERS_IMAGE_KEY_MISSING	 	0x4000
#define RTL_USER_PROCESS_PARAMETERS_NX_OPTIN				0x20000

typedef struct _RTL_USER_PROCESS_INFORMATION
{
	ULONG Length;
	HANDLE Process;
	HANDLE Thread;
	CLIENT_ID ClientId;
	SECTION_IMAGE_INFORMATION ImageInformation;
} RTL_USER_PROCESS_INFORMATION, *PRTL_USER_PROCESS_INFORMATION;

// Handle tag bits for PEB stdio file handles
#define PEB_STDIO_HANDLE_NATIVE		0
#define PEB_STDIO_HANDLE_SUBSYS		1
#define PEB_STDIO_HANDLE_PM			2
#define PEB_STDIO_HANDLE_RESERVED	3

#define GDI_HANDLE_BUFFER_SIZE32	34
#define GDI_HANDLE_BUFFER_SIZE64	60

#ifndef _WIN64
#define GDI_HANDLE_BUFFER_SIZE GDI_HANDLE_BUFFER_SIZE32
#else
#define GDI_HANDLE_BUFFER_SIZE GDI_HANDLE_BUFFER_SIZE64
#endif

typedef ULONG GDI_HANDLE_BUFFER32[GDI_HANDLE_BUFFER_SIZE32];
typedef ULONG GDI_HANDLE_BUFFER64[GDI_HANDLE_BUFFER_SIZE64];
typedef ULONG GDI_HANDLE_BUFFER[GDI_HANDLE_BUFFER_SIZE];

#define TLS_EXPANSION_SLOTS 1024

typedef struct _PEB_LDR_DATA
{
	ULONG Length;
	BOOLEAN Initialized;
	HANDLE SsHandle;
	LIST_ENTRY InLoadOrderModuleList;
	LIST_ENTRY InMemoryOrderModuleList;
	LIST_ENTRY InInitializationOrderModuleList;
	PVOID EntryInProgress;
	BOOLEAN ShutdownInProgress;
	HANDLE ShutdownThreadId;
} PEB_LDR_DATA, *PPEB_LDR_DATA;

typedef struct _ACTIVATION_CONTEXT_STACK
{
	struct _RTL_ACTIVATION_CONTEXT_STACK_FRAME* ActiveFrame;
	LIST_ENTRY FrameListCache;
	ULONG Flags;
	ULONG NextCookieSequenceNumber;
	ULONG StackId;
} ACTIVATION_CONTEXT_STACK, *PACTIVATION_CONTEXT_STACK;

typedef struct _PEB
{
	BOOLEAN InheritedAddressSpace;
	BOOLEAN ReadImageFileExecOptions;
	BOOLEAN BeingDebugged;
	union
	{
		BOOLEAN BitField;
		struct
		{
			BOOLEAN ImageUsesLargePages : 1;
			BOOLEAN IsProtectedProcess : 1;
			BOOLEAN IsImageDynamicallyRelocated : 1;
			BOOLEAN SkipPatchingUser32Forwarders : 1;
			BOOLEAN IsPackagedProcess : 1;
			BOOLEAN IsAppContainer : 1;
			BOOLEAN IsProtectedProcessLight : 1;
			BOOLEAN IsLongPathAwareProcess : 1;
		} s1;
	} u1;

	HANDLE Mutant;

	PVOID ImageBaseAddress;
	PPEB_LDR_DATA Ldr;
	PRTL_USER_PROCESS_PARAMETERS ProcessParameters;
	PVOID SubSystemData;
	PVOID ProcessHeap;
	PRTL_CRITICAL_SECTION FastPebLock;
	PVOID AtlThunkSListPtr;
	PVOID IFEOKey;
	union
	{
		ULONG CrossProcessFlags;
		struct
		{
			ULONG ProcessInJob : 1;
			ULONG ProcessInitializing : 1;
			ULONG ProcessUsingVEH : 1;
			ULONG ProcessUsingVCH : 1;
			ULONG ProcessUsingFTH : 1;
			ULONG ProcessPreviouslyThrottled : 1;
			ULONG ProcessCurrentlyThrottled : 1;
			ULONG ReservedBits0 : 25;
		} s2;
	} u2;
	union
	{
		PVOID KernelCallbackTable;
		PVOID UserSharedInfoPtr;
	} u3;
	ULONG SystemReserved[1];
	ULONG AtlThunkSListPtr32;
	PVOID ApiSetMap;
	ULONG TlsExpansionCounter;
	PVOID TlsBitmap;
	ULONG TlsBitmapBits[2];

	PVOID ReadOnlySharedMemoryBase;
	PVOID SharedData; // HotpatchInformation
	PVOID *ReadOnlyStaticServerData;

	PVOID AnsiCodePageData; // PCPTABLEINFO
	PVOID OemCodePageData; // PCPTABLEINFO
	PVOID UnicodeCaseTableData; // PNLSTABLEINFO

	ULONG NumberOfProcessors;
	ULONG NtGlobalFlag;

	LARGE_INTEGER CriticalSectionTimeout;
	SIZE_T HeapSegmentReserve;
	SIZE_T HeapSegmentCommit;
	SIZE_T HeapDeCommitTotalFreeThreshold;
	SIZE_T HeapDeCommitFreeBlockThreshold;

	ULONG NumberOfHeaps;
	ULONG MaximumNumberOfHeaps;
	PVOID *ProcessHeaps; // PHEAP

	PVOID GdiSharedHandleTable;
	PVOID ProcessStarterHelper;
	ULONG GdiDCAttributeList;

	PRTL_CRITICAL_SECTION LoaderLock;

	ULONG OSMajorVersion;
	ULONG OSMinorVersion;
	USHORT OSBuildNumber;
	USHORT OSCSDVersion;
	ULONG OSPlatformId;
	ULONG ImageSubsystem;
	ULONG ImageSubsystemMajorVersion;
	ULONG ImageSubsystemMinorVersion;
	ULONG_PTR ActiveProcessAffinityMask;
	GDI_HANDLE_BUFFER GdiHandleBuffer;
	PVOID PostProcessInitRoutine;

	PVOID TlsExpansionBitmap;
	ULONG TlsExpansionBitmapBits[32];

	ULONG SessionId;

	ULARGE_INTEGER AppCompatFlags;
	ULARGE_INTEGER AppCompatFlagsUser;
	PVOID pShimData;
	PVOID AppCompatInfo; // APPCOMPAT_EXE_DATA

	UNICODE_STRING CSDVersion;

	PVOID ActivationContextData; // ACTIVATION_CONTEXT_DATA
	PVOID ProcessAssemblyStorageMap; // ASSEMBLY_STORAGE_MAP
	PVOID SystemDefaultActivationContextData; // ACTIVATION_CONTEXT_DATA
	PVOID SystemAssemblyStorageMap; // ASSEMBLY_STORAGE_MAP

	SIZE_T MinimumStackCommit;

	PVOID *FlsCallback;
	LIST_ENTRY FlsListHead;
	PVOID FlsBitmap;
	ULONG FlsBitmapBits[FLS_MAXIMUM_AVAILABLE / (sizeof(ULONG) * 8)];
	ULONG FlsHighIndex;

	PVOID WerRegistrationData;
	PVOID WerShipAssertPtr;
	PVOID pUnused; // pContextData
	PVOID pImageHeaderHash;
	union
	{
		ULONG TracingFlags;
		struct
		{
			ULONG HeapTracingEnabled : 1;
			ULONG CritSecTracingEnabled : 1;
			ULONG LibLoaderTracingEnabled : 1;
			ULONG SpareTracingBits : 29;
		} s3;
	} u4;
	ULONGLONG CsrServerReadOnlySharedMemoryBase;
	PVOID TppWorkerpListLock;
	LIST_ENTRY TppWorkerpList;
	PVOID WaitOnAddressHashTable[128];
	PVOID TelemetryCoverageHeader; // REDSTONE3
	ULONG CloudFileFlags;
} PEB, *PPEB;

#define GDI_BATCH_BUFFER_SIZE 310

typedef struct _GDI_TEB_BATCH
{
	ULONG Offset;
	ULONG_PTR HDC;
	ULONG Buffer[GDI_BATCH_BUFFER_SIZE];
} GDI_TEB_BATCH, *PGDI_TEB_BATCH;

typedef struct _TEB_ACTIVE_FRAME_CONTEXT
{
	ULONG Flags;
	PSTR FrameName;
} TEB_ACTIVE_FRAME_CONTEXT, *PTEB_ACTIVE_FRAME_CONTEXT;

typedef struct _TEB_ACTIVE_FRAME
{
	ULONG Flags;
	struct _TEB_ACTIVE_FRAME *Previous;
	PTEB_ACTIVE_FRAME_CONTEXT Context;
} TEB_ACTIVE_FRAME, *PTEB_ACTIVE_FRAME;

typedef struct _TEB
{
	NT_TIB NtTib;

	PVOID EnvironmentPointer;
	CLIENT_ID ClientId;
	PVOID ActiveRpcHandle;
	PVOID ThreadLocalStoragePointer;
	PPEB ProcessEnvironmentBlock;

	ULONG LastErrorValue;
	ULONG CountOfOwnedCriticalSections;
	PVOID CsrClientThread;
	PVOID Win32ThreadInfo;
	ULONG User32Reserved[26];
	ULONG UserReserved[5];
	PVOID WOW32Reserved;
	LCID CurrentLocale;
	ULONG FpSoftwareStatusRegister;
	PVOID ReservedForDebuggerInstrumentation[16];
#ifdef _WIN64
	PVOID SystemReserved1[30];
#else
	PVOID SystemReserved1[26];
#endif
	CHAR PlaceholderCompatibilityMode;
	CHAR PlaceholderReserved[11];
	ULONG ProxiedProcessId;
	ACTIVATION_CONTEXT_STACK ActivationStack;

	UCHAR WorkingOnBehalfTicket[8];
	NTSTATUS ExceptionCode;

	PACTIVATION_CONTEXT_STACK ActivationContextStackPointer;
	ULONG_PTR InstrumentationCallbackSp;
	ULONG_PTR InstrumentationCallbackPreviousPc;
	ULONG_PTR InstrumentationCallbackPreviousSp;
#ifdef _WIN64
	ULONG TxFsContext;
#endif
	BOOLEAN InstrumentationCallbackDisabled;
#ifndef _WIN64
	UCHAR SpareBytes[23];
	ULONG TxFsContext;
#endif
	GDI_TEB_BATCH GdiTebBatch;
	CLIENT_ID RealClientId;
	HANDLE GdiCachedProcessHandle;
	ULONG GdiClientPID;
	ULONG GdiClientTID;
	PVOID GdiThreadLocalInfo;
	ULONG_PTR Win32ClientInfo[62];
	PVOID glDispatchTable[233];
	ULONG_PTR glReserved1[29];
	PVOID glReserved2;
	PVOID glSectionInfo;
	PVOID glSection;
	PVOID glTable;
	PVOID glCurrentRC;
	PVOID glContext;

	NTSTATUS LastStatusValue;
	UNICODE_STRING StaticUnicodeString;
	WCHAR StaticUnicodeBuffer[261];

	PVOID DeallocationStack;
	PVOID TlsSlots[64];
	LIST_ENTRY TlsLinks;

	PVOID Vdm;
	PVOID ReservedForNtRpc;
	PVOID DbgSsReserved[2];

	ULONG HardErrorMode;
#ifdef _WIN64
	PVOID Instrumentation[11];
#else
	PVOID Instrumentation[9];
#endif
	GUID ActivityId;

	PVOID SubProcessTag;
	PVOID PerflibData;
	PVOID EtwTraceData;
	PVOID WinSockData;
	ULONG GdiBatchCount;

	union
	{
		PROCESSOR_NUMBER CurrentIdealProcessor;
		ULONG IdealProcessorValue;
		struct
		{
			UCHAR ReservedPad0;
			UCHAR ReservedPad1;
			UCHAR ReservedPad2;
			UCHAR IdealProcessor;
		} s1;
	} u1;

	ULONG GuaranteedStackBytes;
	PVOID ReservedForPerf;
	PVOID ReservedForOle;
	ULONG WaitingOnLoaderLock;
	PVOID SavedPriorityState;
	ULONG_PTR ReservedForCodeCoverage;
	PVOID ThreadPoolData;
	PVOID *TlsExpansionSlots;
#ifdef _WIN64
	PVOID DeallocationBStore;
	PVOID BStoreLimit;
#endif
	ULONG MuiGeneration;
	ULONG IsImpersonating;
	PVOID NlsCache;
	PVOID pShimData;
	USHORT HeapVirtualAffinity;
	USHORT LowFragHeapDataSlot;
	HANDLE CurrentTransactionHandle;
	PTEB_ACTIVE_FRAME ActiveFrame;
	PVOID FlsData;

	PVOID PreferredLanguages;
	PVOID UserPrefLanguages;
	PVOID MergedPrefLanguages;
	ULONG MuiImpersonation;

	union
	{
		USHORT CrossTebFlags;
		USHORT SpareCrossTebBits : 16;
	} u2;
	union
	{
		USHORT SameTebFlags;
		struct
		{
			USHORT SafeThunkCall : 1;
			USHORT InDebugPrint : 1;
			USHORT HasFiberData : 1;
			USHORT SkipThreadAttach : 1;
			USHORT WerInShipAssertCode : 1;
			USHORT RanProcessInit : 1;
			USHORT ClonedThread : 1;
			USHORT SuppressDebugMsg : 1;
			USHORT DisableUserStackWalk : 1;
			USHORT RtlExceptionAttached : 1;
			USHORT InitialThread : 1;
			USHORT SessionAware : 1;
			USHORT LoadOwner : 1;
			USHORT LoaderWorker : 1;
			USHORT SkipLoaderInit : 1;
			USHORT SpareSameTebBits : 1;
		} s2;
	} u3;

	PVOID TxnScopeEnterCallback;
	PVOID TxnScopeExitCallback;
	PVOID TxnScopeContext;
	ULONG LockCount;
	LONG WowTebOffset;
	PVOID ResourceRetValue;
	PVOID ReservedForWdf;
	ULONGLONG ReservedForCrt;
	GUID EffectiveContainerId;
} TEB, *PTEB;

typedef enum _ALTERNATIVE_ARCHITECTURE_TYPE
{
	StandardDesign,
	NEC98x86,
	EndAlternatives
} ALTERNATIVE_ARCHITECTURE_TYPE;

#define PROCESSOR_FEATURE_MAX		64

#define MAX_WOW64_SHARED_ENTRIES	16

#define NX_SUPPORT_POLICY_ALWAYSOFF	0
#define NX_SUPPORT_POLICY_ALWAYSON	1
#define NX_SUPPORT_POLICY_OPTIN		2
#define NX_SUPPORT_POLICY_OPTOUT	3

#pragma pack(push, 4)
typedef struct _KUSER_SHARED_DATA
{
	ULONG TickCountLowDeprecated;
	ULONG TickCountMultiplier;

	volatile KSYSTEM_TIME InterruptTime;
	volatile KSYSTEM_TIME SystemTime;
	volatile KSYSTEM_TIME TimeZoneBias;

	USHORT ImageNumberLow;
	USHORT ImageNumberHigh;

	WCHAR NtSystemRoot[260];

	ULONG MaxStackTraceDepth;

	ULONG CryptoExponent;

	ULONG TimeZoneId;
	ULONG LargePageMinimum;
	ULONG AitSamplingValue;
	ULONG AppCompatFlag;
	ULONGLONG RNGSeedVersion;
	ULONG GlobalValidationRunlevel;
	LONG TimeZoneBiasStamp;

	ULONG NtBuildNumber;
	NT_PRODUCT_TYPE NtProductType;
	BOOLEAN ProductTypeIsValid;
	UCHAR Reserved0[1];
	USHORT NativeProcessorArchitecture;

	ULONG NtMajorVersion;
	ULONG NtMinorVersion;

	BOOLEAN ProcessorFeatures[PROCESSOR_FEATURE_MAX];

	ULONG Reserved1;
	ULONG Reserved3;

	volatile ULONG TimeSlip;

	ALTERNATIVE_ARCHITECTURE_TYPE AlternativeArchitecture;
	ULONG BootId;

	LARGE_INTEGER SystemExpirationDate;

	ULONG SuiteMask;

	BOOLEAN KdDebuggerEnabled;
	union
	{
		UCHAR MitigationPolicies;
		struct
		{
			UCHAR NXSupportPolicy : 2;
			UCHAR SEHValidationPolicy : 2;
			UCHAR CurDirDevicesSkippedForDlls : 2;
			UCHAR Reserved : 2;
		} s1;
	} u1;
	UCHAR Reserved6[2];

	volatile ULONG ActiveConsoleId;

	volatile ULONG DismountCount;

	ULONG ComPlusPackage;

	ULONG LastSystemRITEventTickCount;

	ULONG NumberOfPhysicalPages;

	BOOLEAN SafeBootMode;
	UCHAR VirtualizationFlags;
	UCHAR Reserved12[2];

	union
	{
		ULONG SharedDataFlags;
		struct
		{
			ULONG DbgErrorPortPresent : 1;
			ULONG DbgElevationEnabled : 1;
			ULONG DbgVirtEnabled : 1;
			ULONG DbgInstallerDetectEnabled : 1;
			ULONG DbgLkgEnabled : 1;
			ULONG DbgDynProcessorEnabled : 1;
			ULONG DbgConsoleBrokerEnabled : 1;
			ULONG DbgSecureBootEnabled : 1;
			ULONG DbgMultiSessionSku : 1;
			ULONG DbgMultiUsersInSessionSku : 1;
			ULONG DbgStateSeparationEnabled : 1;
			ULONG SpareBits : 21;
		} s2;
	} u2;
	ULONG DataFlagsPad[1];

	ULONGLONG TestRetInstruction;
	LONGLONG QpcFrequency;
	ULONG SystemCall;
	ULONG SystemCallPad0;
	ULONGLONG SystemCallPad[2];

	union
	{
		volatile KSYSTEM_TIME TickCount;
		volatile ULONG64 TickCountQuad;
		ULONG ReservedTickCountOverlay[3];
	};
	ULONG TickCountPad[1];

	ULONG Cookie;
	ULONG CookiePad[1];

	LONGLONG ConsoleSessionForegroundProcessId;
	ULONGLONG TimeUpdateLock;
	ULONGLONG BaselineSystemTimeQpc;
	ULONGLONG BaselineInterruptTimeQpc;
	ULONGLONG QpcSystemTimeIncrement;
	ULONGLONG QpcInterruptTimeIncrement;
	UCHAR QpcSystemTimeIncrementShift;
	UCHAR QpcInterruptTimeIncrementShift;

	USHORT UnparkedProcessorCount;
	ULONG EnclaveFeatureMask[4];

	ULONG TelemetryCoverageRound;

	USHORT UserModeGlobalLogger[16];
	ULONG ImageFileExecutionOptions;

	ULONG LangGenerationCount;
	ULONGLONG Reserved4;
	volatile ULONG64 InterruptTimeBias;
	volatile ULONG64 QpcBias;

	ULONG ActiveProcessorCount;
	volatile UCHAR ActiveGroupCount;
	UCHAR Reserved9;
	union
	{
		USHORT QpcData;
		struct
		{
			UCHAR QpcBypassEnabled : 1;
			UCHAR QpcShift : 1;
		} s3;
	} u3;

	LARGE_INTEGER TimeZoneBiasEffectiveStart;
	LARGE_INTEGER TimeZoneBiasEffectiveEnd;
	XSTATE_CONFIGURATION XState;
} KUSER_SHARED_DATA, *PKUSER_SHARED_DATA;
#pragma pack(pop)

#ifdef __cplusplus
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, TickCountMultiplier) == 0x4, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, InterruptTime) == 0x8, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, SystemTime) == 0x14, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, TimeZoneBias) == 0x20, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, ImageNumberLow) == 0x2c, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, ImageNumberHigh) == 0x2e, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, NtSystemRoot) == 0x30, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, MaxStackTraceDepth) == 0x238, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, CryptoExponent) == 0x23c, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, TimeZoneId) == 0x240, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, LargePageMinimum) == 0x244, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, NtProductType) == 0x264, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, ProductTypeIsValid) == 0x268, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, NtMajorVersion) == 0x26c, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, NtMinorVersion) == 0x270, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, ProcessorFeatures) == 0x274, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, Reserved1) == 0x2b4, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, Reserved3) == 0x2b8, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, TimeSlip) == 0x2bc, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, AlternativeArchitecture) == 0x2c0, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, SystemExpirationDate) == 0x2c8, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, SuiteMask) == 0x2d0, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, KdDebuggerEnabled) == 0x2d4, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, ActiveConsoleId) == 0x2d8, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, DismountCount) == 0x2dc, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, ComPlusPackage) == 0x2e0, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, LastSystemRITEventTickCount) == 0x2e4, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, NumberOfPhysicalPages) == 0x2e8, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, SafeBootMode) == 0x2ec, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, TestRetInstruction) == 0x2f8, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, SystemCallPad) == 0x310, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, TickCount) == 0x320, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, TickCountQuad) == 0x320, "Offset check");
static_assert(FIELD_OFFSET(KUSER_SHARED_DATA, XState) == 0x3d8, "Offset check");
#endif

#if !defined(_KERNEL_MODE) && !defined(KERNELMODE)
	#define USER_SHARED_DATA			0x7FFE0000
	#define SharedUserData				((KUSER_SHARED_DATA * const)USER_SHARED_DATA)
#else
	#if defined(_M_IX86)
		#define KI_USER_SHARED_DATA		0xFFDF0000
	#elif defined (_M_AMD64)
		#define KI_USER_SHARED_DATA		0xFFFFF78000000000Ui64
	#elif defined (_M_ARM)
		#define KI_USER_SHARED_DATA		0xFFFF9000
	#elif defined(M_ARM64)
		#define KI_USER_SHARED_DATA		0xFFFFF78000000000Ui64
	#endif
	#define SharedUserData				((KUSER_SHARED_DATA * const)KI_USER_SHARED_DATA)
#endif

typedef struct _PROCESS_BASIC_INFORMATION
{
	NTSTATUS ExitStatus;
	PPEB PebBaseAddress;
	ULONG_PTR AffinityMask;
	KPRIORITY BasePriority;
	HANDLE UniqueProcessId;
	HANDLE InheritedFromUniqueProcessId;
} PROCESS_BASIC_INFORMATION, *PPROCESS_BASIC_INFORMATION;

typedef struct _PROCESS_EXTENDED_BASIC_INFORMATION
{
	SIZE_T Size; // Set to sizeof structure on input
	PROCESS_BASIC_INFORMATION BasicInfo;
	union
	{
		ULONG Flags;
		struct
		{
			ULONG IsProtectedProcess : 1;
			ULONG IsWow64Process : 1;
			ULONG IsProcessDeleting : 1;
			ULONG IsCrossSessionCreate : 1;
			ULONG IsFrozen : 1;
			ULONG IsBackground : 1;
			ULONG IsStronglyNamed : 1;
			ULONG IsSecureProcess : 1;
			ULONG IsSubsystemProcess : 1;
			ULONG SpareBits : 23;
		} s;
	} u;
} PROCESS_EXTENDED_BASIC_INFORMATION, *PPROCESS_EXTENDED_BASIC_INFORMATION;

typedef struct _VM_COUNTERS
{
	SIZE_T PeakVirtualSize;
	SIZE_T VirtualSize;
	ULONG PageFaultCount;
	SIZE_T PeakWorkingSetSize;
	SIZE_T WorkingSetSize;
	SIZE_T QuotaPeakPagedPoolUsage;
	SIZE_T QuotaPagedPoolUsage;
	SIZE_T QuotaPeakNonPagedPoolUsage;
	SIZE_T QuotaNonPagedPoolUsage;
	SIZE_T PagefileUsage;
	SIZE_T PeakPagefileUsage;
} VM_COUNTERS, *PVM_COUNTERS;

typedef struct _VM_COUNTERS_EX
{
	SIZE_T PeakVirtualSize;
	SIZE_T VirtualSize;
	ULONG PageFaultCount;
	SIZE_T PeakWorkingSetSize;
	SIZE_T WorkingSetSize;
	SIZE_T QuotaPeakPagedPoolUsage;
	SIZE_T QuotaPagedPoolUsage;
	SIZE_T QuotaPeakNonPagedPoolUsage;
	SIZE_T QuotaNonPagedPoolUsage;
	SIZE_T PagefileUsage;
	SIZE_T PeakPagefileUsage;
	SIZE_T PrivateUsage;
} VM_COUNTERS_EX, *PVM_COUNTERS_EX;

typedef struct _SYSTEM_EXTENDED_THREAD_INFORMATION
{
	SYSTEM_THREAD_INFORMATION ThreadInfo;
	PVOID StackBase;
	PVOID StackLimit;
	PVOID Win32StartAddress;
	PTEB TebBase; // Since Vista
	ULONG_PTR Reserved2;
	ULONG_PTR Reserved3;
	ULONG_PTR Reserved4;
} SYSTEM_EXTENDED_THREAD_INFORMATION, *PSYSTEM_EXTENDED_THREAD_INFORMATION;

#define PTR_ADD_OFFSET(Pointer, Offset) ((PVOID)((ULONG_PTR)(Pointer) + (ULONG_PTR)(Offset)))
#define PTR_SUB_OFFSET(Pointer, Offset) ((PVOID)((ULONG_PTR)(Pointer) - (ULONG_PTR)(Offset)))
#define ALIGN_DOWN_BY(Address, Align) ((ULONG_PTR)(Address) & ~((Align) - 1))
#define ALIGN_DOWN_POINTER_BY(Pointer, Align) ((PVOID)ALIGN_DOWN_BY(Pointer, Align))
#define ALIGN_DOWN_POINTER(Pointer, Type) ((PVOID)ALIGN_DOWN(Pointer, Type))
#define ALIGN_UP_BY(Address, Align) (((ULONG_PTR)(Address) + (Align) - 1) & ~((Align) - 1))
#define ALIGN_UP_POINTER_BY(Pointer, Align) ((PVOID)ALIGN_UP_BY(Pointer, Align))
#define ALIGN_UP_POINTER(Pointer, Type) ((PVOID)ALIGN_UP(Pointer, Type))

#define InitializeObjectAttributes( p, n, a, r, s ) {	\
	(p)->Length = sizeof( OBJECT_ATTRIBUTES );			\
	(p)->RootDirectory = r;								\
	(p)->Attributes = a;								\
	(p)->ObjectName = n;								\
	(p)->SecurityDescriptor = s;						\
	(p)->SecurityQualityOfService = NULL;				\
	}

#if defined(__cplusplus)
#define RTL_CONST_CAST(type) const_cast<type>
#else
#define RTL_CONST_CAST(type) (type)
#endif

#define RTL_CONSTANT_OBJECT_ATTRIBUTES(n, a) \
	{ sizeof(OBJECT_ATTRIBUTES), NULL, RTL_CONST_CAST(PUNICODE_STRING)(n), a, NULL, NULL }

#define OBJ_INHERIT									0x00000002L
#define OBJ_PERMANENT								0x00000010L
#define OBJ_EXCLUSIVE								0x00000020L
#define OBJ_CASE_INSENSITIVE						0x00000040L
#define OBJ_OPENIF									0x00000080L
#define OBJ_OPENLINK								0x00000100L
#define OBJ_KERNEL_HANDLE							0x00000200L
#define OBJ_FORCE_ACCESS_CHECK						0x00000400L
#define OBJ_IGNORE_IMPERSONATED_DEVICEMAP			0x00000800
#define OBJ_DONT_REPARSE							0x00001000
#define OBJ_VALID_ATTRIBUTES						0x00001FF2

#if NTDDI_VERSION >= NTDDI_VISTA
#define THREAD_ALL_ACCESS							(STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | \
													0xFFFF)
#else
#define THREAD_ALL_ACCESS							(STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | \
													0x3FF)
#endif

#define THREAD_CREATE_FLAGS_CREATE_SUSPENDED		0x00000001
#define THREAD_CREATE_FLAGS_SUPPRESS_DLLMAINS		0x00000002
#define THREAD_CREATE_FLAGS_HIDE_FROM_DEBUGGER		0x00000004
#define THREAD_CREATE_FLAGS_HAS_SECURITY_DESCRIPTOR	0x00000010 // ?
#define THREAD_CREATE_FLAGS_ACCESS_CHECK_IN_TARGET	0x00000020 // ?
#define THREAD_CREATE_FLAGS_INITIAL_THREAD			0x00000080

#define DEBUG_READ_EVENT							0x0001
#define DEBUG_PROCESS_ASSIGN						0x0002
#define DEBUG_SET_INFORMATION						0x0004
#define DEBUG_QUERY_INFORMATION						0x0008

#define DEBUG_ALL_ACCESS							(STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | \
													DEBUG_READ_EVENT | DEBUG_PROCESS_ASSIGN | DEBUG_SET_INFORMATION | \
													DEBUG_QUERY_INFORMATION)

#define DEBUG_KILL_ON_CLOSE							0x1

#ifndef IO_COMPLETION_QUERY_STATE
#define IO_COMPLETION_QUERY_STATE					0x0001
#endif
#ifndef IO_COMPLETION_MODIFY_STATE
#define IO_COMPLETION_MODIFY_STATE					0x0002
#endif
#ifndef IO_COMPLETION_ALL_ACCESS
#define IO_COMPLETION_ALL_ACCESS					(STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | \
													IO_COMPLETION_QUERY_STATE | IO_COMPLETION_MODIFY_STATE)
#endif

#ifndef SEMAPHORE_ALL_ACCESS
#define SEMAPHORE_QUERY_STATE						0x0001
#define SEMAPHORE_MODIFY_STATE						0x0002

#define SEMAPHORE_ALL_ACCESS						(STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | \
													SEMAPHORE_QUERY_STATE | SEMAPHORE_MODIFY_STATE)
#endif

#ifndef MUTANT_ALL_ACCESS
#define MUTANT_QUERY_STATE							0x0001

#define MUTANT_ALL_ACCESS							(STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | \
						 							MUTANT_QUERY_STATE)
#endif

#ifndef EVENT_ALL_ACCESS
#define EVENT_QUERY_STATE							0x0001
#define EVENT_MODIFY_STATE							0x0002

#define EVENT_ALL_ACCESS							(STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | \
													EVENT_QUERY_STATE | EVENT_MODIFY_STATE)
#endif

#define KEYEDEVENT_WAIT								0x0001
#define KEYEDEVENT_WAKE								0x0002
#define KEYEDEVENT_ALL_ACCESS						(STANDARD_RIGHTS_REQUIRED | \
													KEYEDEVENT_WAIT | KEYEDEVENT_WAKE)

#define DIRECTORY_QUERY								0x0001
#define DIRECTORY_TRAVERSE							0x0002
#define DIRECTORY_CREATE_OBJECT						0x0004
#define DIRECTORY_CREATE_SUBDIRECTORY				0x0008

#define DIRECTORY_ALL_ACCESS						(STANDARD_RIGHTS_REQUIRED | \
													DIRECTORY_QUERY | DIRECTORY_TRAVERSE | \
													DIRECTORY_CREATE_OBJECT | DIRECTORY_CREATE_SUBDIRECTORY)

#define SYMBOLIC_LINK_QUERY							0x0001

#define SYMBOLIC_LINK_ALL_ACCESS					(STANDARD_RIGHTS_REQUIRED | \
													SYMBOLIC_LINK_QUERY)

#ifndef TOKEN_ALL_ACCESS
#define TOKEN_ASSIGN_PRIMARY						0x0001
#define TOKEN_DUPLICATE								0x0002
#define TOKEN_IMPERSONATE							0x0004
#define TOKEN_QUERY									0x0008
#define TOKEN_QUERY_SOURCE							0x0010
#define TOKEN_ADJUST_PRIVILEGES						0x0020
#define TOKEN_ADJUST_GROUPS							0x0040
#define TOKEN_ADJUST_DEFAULT						0x0080
#define TOKEN_ADJUST_SESSIONID						0x0100

#define TOKEN_ALL_ACCESS_P							(STANDARD_RIGHTS_REQUIRED | \
													TOKEN_ASSIGN_PRIMARY | \
													TOKEN_DUPLICATE | \
													TOKEN_IMPERSONATE | \
													TOKEN_QUERY | \
													TOKEN_QUERY_SOURCE | \
													TOKEN_ADJUST_PRIVILEGES | \
													TOKEN_ADJUST_GROUPS | \
													TOKEN_ADJUST_DEFAULT)

#define TOKEN_ALL_ACCESS 							(TOKEN_ALL_ACCESS_P | \
													TOKEN_ADJUST_SESSIONID)
#endif

#define WORKER_FACTORY_RELEASE_WORKER				0x0001
#define WORKER_FACTORY_WAIT							0x0002
#define WORKER_FACTORY_SET_INFORMATION				0x0004
#define WORKER_FACTORY_QUERY_INFORMATION			0x0008
#define WORKER_FACTORY_READY_WORKER					0x0010
#define WORKER_FACTORY_SHUTDOWN						0x0020

#define WORKER_FACTORY_ALL_ACCESS 					(STANDARD_RIGHTS_REQUIRED | \
													WORKER_FACTORY_RELEASE_WORKER | \
													WORKER_FACTORY_WAIT | \
													WORKER_FACTORY_SET_INFORMATION | \
													WORKER_FACTORY_QUERY_INFORMATION | \
													WORKER_FACTORY_READY_WORKER | \
													WORKER_FACTORY_SHUTDOWN)

typedef struct _WORKER_FACTORY_DEFERRED_WORK
{
	struct _PORT_MESSAGE* AlpcSendMessage;
	HANDLE AlpcSendMessagePort;
	ULONG AlpcSendMessageFlags;
	ULONG Flags;
} WORKER_FACTORY_DEFERRED_WORK, *PWORKER_FACTORY_DEFERRED_WORK;

#define NtCurrentProcess		((HANDLE)(LONG_PTR)-1)
#define NtCurrentThread			((HANDLE)(LONG_PTR)-2)
#define NtCurrentPeb()			(NtCurrentTeb()->ProcessEnvironmentBlock)
#define NtCurrentProcessId()	(NtCurrentTeb()->ClientId.UniqueProcess)
#define NtCurrentThreadId()		(NtCurrentTeb()->ClientId.UniqueThread)
#define RtlProcessHeap()		(NtCurrentPeb()->ProcessHeap)

typedef struct _RTL_HEAP_ENTRY
{
	SIZE_T Size;
	USHORT Flags;
	USHORT AllocatorBackTraceIndex;
	union
	{
		struct
		{
			SIZE_T Settable;
			ULONG Tag;
		} s1;
		struct
		{
			SIZE_T CommittedSize;
			PVOID FirstBlock;
		} s2;
	} u;
} RTL_HEAP_ENTRY, *PRTL_HEAP_ENTRY;

#define RTL_HEAP_BUSY				(USHORT)0x0001
#define RTL_HEAP_SEGMENT			(USHORT)0x0002
#define RTL_HEAP_SETTABLE_VALUE		(USHORT)0x0010
#define RTL_HEAP_SETTABLE_FLAG1		(USHORT)0x0020
#define RTL_HEAP_SETTABLE_FLAG2		(USHORT)0x0040
#define RTL_HEAP_SETTABLE_FLAG3		(USHORT)0x0080
#define RTL_HEAP_SETTABLE_FLAGS		(USHORT)0x00e0
#define RTL_HEAP_UNCOMMITTED_RANGE	(USHORT)0x0100
#define RTL_HEAP_PROTECTED_ENTRY	(USHORT)0x0200

typedef struct _RTL_HEAP_TAG
{
	ULONG NumberOfAllocations;
	ULONG NumberOfFrees;
	SIZE_T BytesAllocated;
	USHORT TagIndex;
	USHORT CreatorBackTraceIndex;
	WCHAR TagName[24];
} RTL_HEAP_TAG, *PRTL_HEAP_TAG;

typedef struct _RTL_HEAP_INFORMATION
{
	PVOID BaseAddress;
	ULONG Flags;
	USHORT EntryOverhead;
	USHORT CreatorBackTraceIndex;
	SIZE_T BytesAllocated;
	SIZE_T BytesCommitted;
	ULONG NumberOfTags;
	ULONG NumberOfEntries;
	ULONG NumberOfPseudoTags;
	ULONG PseudoTagGranularity;
	ULONG Reserved[5];
	PRTL_HEAP_TAG Tags;
	PRTL_HEAP_ENTRY Entries;
} RTL_HEAP_INFORMATION, *PRTL_HEAP_INFORMATION;

typedef struct _RTL_PROCESS_HEAPS
{
	ULONG NumberOfHeaps;
	RTL_HEAP_INFORMATION Heaps[1];
} RTL_PROCESS_HEAPS, *PRTL_PROCESS_HEAPS;

typedef
NTSTATUS
(NTAPI*
PRTL_HEAP_COMMIT_ROUTINE)(
	_In_ PVOID Base,
	_Inout_ PVOID *CommitAddress,
	_Inout_ PSIZE_T CommitSize
	);

typedef struct _RTL_HEAP_PARAMETERS
{
	ULONG Length;
	SIZE_T SegmentReserve;
	SIZE_T SegmentCommit;
	SIZE_T DeCommitFreeBlockThreshold;
	SIZE_T DeCommitTotalFreeThreshold;
	SIZE_T MaximumAllocationSize;
	SIZE_T VirtualMemoryThreshold;
	SIZE_T InitialCommit;
	SIZE_T InitialReserve;
	PRTL_HEAP_COMMIT_ROUTINE CommitRoutine;
	SIZE_T Reserved[2];
} RTL_HEAP_PARAMETERS, *PRTL_HEAP_PARAMETERS;

#define HEAP_SETTABLE_USER_VALUE 0x00000100
#define HEAP_SETTABLE_USER_FLAG1 0x00000200
#define HEAP_SETTABLE_USER_FLAG2 0x00000400
#define HEAP_SETTABLE_USER_FLAG3 0x00000800
#define HEAP_SETTABLE_USER_FLAGS 0x00000e00

#define HEAP_CLASS_0 0x00000000 // Process heap
#define HEAP_CLASS_1 0x00001000 // Private heap
#define HEAP_CLASS_2 0x00002000 // Kernel heap
#define HEAP_CLASS_3 0x00003000 // GDI heap
#define HEAP_CLASS_4 0x00004000 // User heap
#define HEAP_CLASS_5 0x00005000 // Console heap
#define HEAP_CLASS_6 0x00006000 // User desktop heap
#define HEAP_CLASS_7 0x00007000 // CSR shared heap
#define HEAP_CLASS_8 0x00008000 // CSR port heap
#define HEAP_CLASS_MASK 0x0000f000

typedef struct _RTL_HEAP_TAG_INFO
{
	ULONG NumberOfAllocations;
	ULONG NumberOfFrees;
	SIZE_T BytesAllocated;
} RTL_HEAP_TAG_INFO, *PRTL_HEAP_TAG_INFO;

#define RTL_HEAP_MAKE_TAG HEAP_MAKE_TAG_FLAGS

typedef struct _RTL_HEAP_WALK_ENTRY
{
	PVOID DataAddress;
	SIZE_T DataSize;
	UCHAR OverheadBytes;
	UCHAR SegmentIndex;
	USHORT Flags;
	union
	{
		struct
		{
			SIZE_T Settable;
			USHORT TagIndex;
			USHORT AllocatorBackTraceIndex;
			ULONG Reserved[2];
		} Block;
		struct
		{
			ULONG CommittedSize;
			ULONG UnCommittedSize;
			PVOID FirstEntry;
			PVOID LastEntry;
		} Segment;
	};
} RTL_HEAP_WALK_ENTRY, *PRTL_HEAP_WALK_ENTRY;

// HEAP_INFORMATION_CLASS. winnt.h is incomplete
#define HeapCompatibilityInformation 0x0 // q; s: ULONG
#define HeapEnableTerminationOnCorruption 0x1 // q; s: NULL
#define HeapExtendedInformation 0x2 // q; s: HEAP_EXTENDED_INFORMATION
#define HeapOptimizeResources 0x3 // q; s: HEAP_OPTIMIZE_RESOURCES_INFORMATION
#define HeapTaggingInformation 0x4
#define HeapStackDatabase 0x5
#define HeapDetailedFailureInformation 0x80000001
#define HeapSetDebuggingInformation 0x80000002 // q; s: HEAP_DEBUGGING_INFORMATION

typedef struct _PROCESS_HEAP_INFORMATION
{
	ULONG_PTR ReserveSize;
	ULONG_PTR CommitSize;
	ULONG NumberOfHeaps;
	ULONG_PTR FirstHeapInformationOffset;
} PROCESS_HEAP_INFORMATION, *PPROCESS_HEAP_INFORMATION;

typedef struct _HEAP_INFORMATION
{
	ULONG_PTR Address;
	ULONG Mode;
	ULONG_PTR ReserveSize;
	ULONG_PTR CommitSize;
	ULONG_PTR FirstRegionInformationOffset;
	ULONG_PTR NextHeapInformationOffset;
} HEAP_INFORMATION, *PHEAP_INFORMATION;

typedef struct _HEAP_EXTENDED_INFORMATION
{
	HANDLE Process;
	ULONG_PTR Heap;
	ULONG Level;
	PVOID CallbackRoutine;
	PVOID CallbackContext;
	PROCESS_HEAP_INFORMATION ProcessHeapInformation;
	HEAP_INFORMATION HeapInformation;
} HEAP_EXTENDED_INFORMATION, *PHEAP_EXTENDED_INFORMATION;

typedef
NTSTATUS
(NTAPI*
PRTL_HEAP_LEAK_ENUMERATION_ROUTINE)(
	_In_ LONG Reserved,
	_In_ PVOID HeapHandle,
	_In_ PVOID BaseAddress,
	_In_ SIZE_T BlockSize,
	_In_ ULONG StackTraceDepth,
	_In_ PVOID *StackTrace
	);

typedef struct _HEAP_DEBUGGING_INFORMATION
{
	PVOID InterceptorFunction;
	USHORT InterceptorValue;
	ULONG ExtendedOptions;
	ULONG StackTraceDepth;
	SIZE_T MinTotalBlockSize;
	SIZE_T MaxTotalBlockSize;
	PRTL_HEAP_LEAK_ENUMERATION_ROUTINE HeapLeakEnumerationRoutine;
} HEAP_DEBUGGING_INFORMATION, *PHEAP_DEBUGGING_INFORMATION;

typedef
NTSTATUS
(NTAPI*
PRTL_ENUM_HEAPS_ROUTINE)(
	_In_ PVOID HeapHandle,
	_In_ PVOID Parameter
	);

typedef
NTSTATUS
(NTAPI*
PUSER_THREAD_START_ROUTINE)(
	_In_ PVOID ThreadParameter
	);

#define LDR_FORMAT_MESSAGE_FROM_SYSTEM_MESSAGE_TABLE	11

#define RTL_ERRORMODE_NOGPFAULTERRORBOX					0x0020
#define RTL_ERRORMODE_NOOPENFILEERRORBOX				0x0040

#define RTL_ACQUIRE_PRIVILEGE_REVERT					0x00000001
#define RTL_ACQUIRE_PRIVILEGE_PROCESS					0x00000002

typedef
VOID
(NTAPI*
PLDR_IMPORT_MODULE_CALLBACK)(
	_In_ PVOID Parameter,
	_In_ PSTR ModuleName
	);

typedef struct _LDR_IMPORT_CALLBACK_INFO
{
	PLDR_IMPORT_MODULE_CALLBACK ImportCallbackRoutine;
	PVOID ImportCallbackParameter;
} LDR_IMPORT_CALLBACK_INFO, *PLDR_IMPORT_CALLBACK_INFO;

typedef struct _LDR_SECTION_INFO
{
	HANDLE SectionHandle;
	ACCESS_MASK DesiredAccess;
	POBJECT_ATTRIBUTES ObjectAttributes;
	ULONG SectionPageProtection;
	ULONG AllocationAttributes;
} LDR_SECTION_INFO, *PLDR_SECTION_INFO;

typedef struct _LDR_VERIFY_IMAGE_INFO
{
	ULONG Size;
	ULONG Flags;
	LDR_IMPORT_CALLBACK_INFO CallbackInfo;
	LDR_SECTION_INFO SectionInfo;
	USHORT ImageCharacteristics;
} LDR_VERIFY_IMAGE_INFO, *PLDR_VERIFY_IMAGE_INFO;

typedef enum _SEMAPHORE_INFORMATION_CLASS
{
	SemaphoreBasicInformation
} SEMAPHORE_INFORMATION_CLASS;

typedef struct _SEMAPHORE_BASIC_INFORMATION
{
	LONG CurrentCount;
	LONG MaximumCount;
} SEMAPHORE_BASIC_INFORMATION, *PSEMAPHORE_BASIC_INFORMATION;

typedef enum _TIMER_INFORMATION_CLASS
{
	TimerBasicInformation
} TIMER_INFORMATION_CLASS;

typedef struct _TIMER_BASIC_INFORMATION
{
	LARGE_INTEGER RemainingTime;
	BOOLEAN TimerState;
} TIMER_BASIC_INFORMATION, *PTIMER_BASIC_INFORMATION;

typedef
VOID
(NTAPI*
PTIMER_APC_ROUTINE)(
	_In_ PVOID TimerContext,
	_In_ ULONG TimerLowValue,
	_In_ LONG TimerHighValue
	);

typedef enum _TIMER_SET_INFORMATION_CLASS
{
	TimerSetCoalescableTimer,
	MaxTimerInfoClass
} TIMER_SET_INFORMATION_CLASS;

typedef struct _TIMER_SET_COALESCABLE_TIMER_INFO
{
	_In_ LARGE_INTEGER DueTime;
	_In_opt_ PTIMER_APC_ROUTINE TimerApcRoutine;
	_In_opt_ PVOID TimerContext;
	_In_opt_ struct _COUNTED_REASON_CONTEXT *WakeContext;
	_In_opt_ ULONG Period;
	_In_ ULONG TolerableDelay;
	_Out_opt_ PBOOLEAN PreviousState;
} TIMER_SET_COALESCABLE_TIMER_INFO, *PTIMER_SET_COALESCABLE_TIMER_INFO;

typedef struct _TOKEN_SECURITY_ATTRIBUTE_FQBN_VALUE
{
	ULONG64 Version;
	UNICODE_STRING Name;
} TOKEN_SECURITY_ATTRIBUTE_FQBN_VALUE, *PTOKEN_SECURITY_ATTRIBUTE_FQBN_VALUE;

typedef struct _TOKEN_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE
{
	PVOID pValue;
	ULONG ValueLength;
} TOKEN_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE, *PTOKEN_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE;

typedef struct _TOKEN_SECURITY_ATTRIBUTE_V1
{
	UNICODE_STRING Name;
	USHORT ValueType;
	USHORT Reserved;
	ULONG Flags;
	ULONG ValueCount;
	union
	{
		PLONG64 pInt64;
		PULONG64 pUint64;
		PUNICODE_STRING pString;
		PTOKEN_SECURITY_ATTRIBUTE_FQBN_VALUE pFqbn;
		PTOKEN_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE pOctetString;
	} Values;
} TOKEN_SECURITY_ATTRIBUTE_V1, *PTOKEN_SECURITY_ATTRIBUTE_V1;

#define TOKEN_SECURITY_ATTRIBUTES_INFORMATION_VERSION_V1	1
#define TOKEN_SECURITY_ATTRIBUTES_INFORMATION_VERSION		TOKEN_SECURITY_ATTRIBUTES_INFORMATION_VERSION_V1

typedef struct _TOKEN_SECURITY_ATTRIBUTES_INFORMATION
{
	USHORT Version;
	USHORT Reserved;
	ULONG AttributeCount;
	union
	{
		PTOKEN_SECURITY_ATTRIBUTE_V1 pAttributeV1;
	} Attribute;
} TOKEN_SECURITY_ATTRIBUTES_INFORMATION, *PTOKEN_SECURITY_ATTRIBUTES_INFORMATION;

typedef enum _FILTER_BOOT_OPTION_OPERATION
{
	FilterBootOptionOperationOpenSystemStore,
	FilterBootOptionOperationSetElement,
	FilterBootOptionOperationDeleteElement,
	FilterBootOptionOperationMax
} FILTER_BOOT_OPTION_OPERATION;

typedef enum _IO_SESSION_EVENT
{
	IoSessionEventIgnore,
	IoSessionEventCreated,
	IoSessionEventTerminated,
	IoSessionEventConnected,
	IoSessionEventDisconnected,
	IoSessionEventLogon,
	IoSessionEventLogoff,
	IoSessionEventMax
} IO_SESSION_EVENT;

typedef enum _IO_SESSION_STATE
{
	IoSessionStateCreated,
	IoSessionStateInitialized,
	IoSessionStateConnected,
	IoSessionStateDisconnected,
	IoSessionStateDisconnectedLoggedOn,
	IoSessionStateLoggedOn,
	IoSessionStateLoggedOff,
	IoSessionStateTerminated,
	IoSessionStateMax
} IO_SESSION_STATE;

typedef struct _PORT_MESSAGE PORT_MESSAGE, *PPORT_MESSAGE;
typedef struct _TP_ALPC TP_ALPC, *PTP_ALPC;

typedef
VOID
(NTAPI*
PTP_ALPC_CALLBACK)(
	_Inout_ PTP_CALLBACK_INSTANCE Instance,
	_Inout_opt_ PVOID Context,
	_In_ PTP_ALPC Alpc
	);

typedef
VOID
(NTAPI*
PTP_ALPC_CALLBACK_EX)(
	_Inout_ PTP_CALLBACK_INSTANCE Instance,
	_Inout_opt_ PVOID Context,
	_In_ PTP_ALPC Alpc,
	_In_ PVOID ApcContext
	);

typedef
VOID
(NTAPI*
PTP_IO_CALLBACK)(
	_Inout_ PTP_CALLBACK_INSTANCE Instance,
	_Inout_opt_ PVOID Context,
	_In_ PVOID ApcContext,
	_In_ PIO_STATUS_BLOCK IoSB,
	_In_ PTP_IO Io
	);

typedef enum _IO_COMPLETION_INFORMATION_CLASS
{
	IoCompletionBasicInformation
} IO_COMPLETION_INFORMATION_CLASS;

typedef struct _IO_COMPLETION_BASIC_INFORMATION
{
	LONG Depth;
} IO_COMPLETION_BASIC_INFORMATION, *PIO_COMPLETION_BASIC_INFORMATION;

typedef enum _WORKERFACTORYINFOCLASS
{
	WorkerFactoryTimeout,
	WorkerFactoryRetryTimeout,
	WorkerFactoryIdleTimeout,
	WorkerFactoryBindingCount,
	WorkerFactoryThreadMinimum,
	WorkerFactoryThreadMaximum,
	WorkerFactoryPaused,
	WorkerFactoryBasicInformation,
	WorkerFactoryAdjustThreadGoal,
	WorkerFactoryCallbackType,
	WorkerFactoryStackInformation, // 10
	WorkerFactoryThreadBasePriority,
	WorkerFactoryTimeoutWaiters, // since THRESHOLD
	WorkerFactoryFlags,
	WorkerFactoryThreadSoftMaximum,
	MaxWorkerFactoryInfoClass
} WORKERFACTORYINFOCLASS, *PWORKERFACTORYINFOCLASS;

typedef struct _WORKER_FACTORY_BASIC_INFORMATION
{
	LARGE_INTEGER Timeout;
	LARGE_INTEGER RetryTimeout;
	LARGE_INTEGER IdleTimeout;
	BOOLEAN Paused;
	BOOLEAN TimerSet;
	BOOLEAN QueuedToExWorker;
	BOOLEAN MayCreate;
	BOOLEAN CreateInProgress;
	BOOLEAN InsertedIntoQueue;
	BOOLEAN Shutdown;
	ULONG BindingCount;
	ULONG ThreadMinimum;
	ULONG ThreadMaximum;
	ULONG PendingWorkerCount;
	ULONG WaitingWorkerCount;
	ULONG TotalWorkerCount;
	ULONG ReleaseCount;
	LONGLONG InfiniteWaitGoal;
	PVOID StartRoutine;
	PVOID StartParameter;
	HANDLE ProcessId;
	SIZE_T StackReserve;
	SIZE_T StackCommit;
	NTSTATUS LastThreadCreationStatus;
} WORKER_FACTORY_BASIC_INFORMATION, *PWORKER_FACTORY_BASIC_INFORMATION;

typedef struct _BOOT_ENTRY
{
	ULONG Version;
	ULONG Length;
	ULONG Id;
	ULONG Attributes;
	ULONG FriendlyNameOffset;
	ULONG BootFilePathOffset;
	ULONG OsOptionsLength;
	UCHAR OsOptions[1];
} BOOT_ENTRY, *PBOOT_ENTRY;

typedef struct _BOOT_ENTRY_LIST
{
	ULONG NextEntryOffset;
	BOOT_ENTRY BootEntry;
} BOOT_ENTRY_LIST, *PBOOT_ENTRY_LIST;

typedef struct _BOOT_OPTIONS
{
	ULONG Version;
	ULONG Length;
	ULONG Timeout;
	ULONG CurrentBootEntryId;
	ULONG NextBootEntryId;
	WCHAR HeadlessRedirection[1];
} BOOT_OPTIONS, *PBOOT_OPTIONS;

typedef struct _FILE_PATH
{
	ULONG Version;
	ULONG Length;
	ULONG Type;
	UCHAR FilePath[1];
} FILE_PATH, *PFILE_PATH;

typedef struct _EFI_DRIVER_ENTRY
{
	ULONG Version;
	ULONG Length;
	ULONG Id;
	ULONG FriendlyNameOffset;
	ULONG DriverFilePathOffset;
} EFI_DRIVER_ENTRY, *PEFI_DRIVER_ENTRY;

typedef struct _EFI_DRIVER_ENTRY_LIST
{
	ULONG NextEntryOffset;
	EFI_DRIVER_ENTRY DriverEntry;
} EFI_DRIVER_ENTRY_LIST, *PEFI_DRIVER_ENTRY_LIST;

typedef
NTSTATUS
(NTAPI
*t_NtClose)(
	_In_ HANDLE Handle
	);

typedef
NTSTATUS
(NTAPI
*t_NtDuplicateObject)(
	_In_ HANDLE SourceProcessHandle,
	_In_ HANDLE SourceHandle,
	_In_opt_ HANDLE TargetProcessHandle,
	_Out_opt_ PHANDLE TargetHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ ULONG HandleAttributes,
	_In_ ULONG Options
	);

typedef
NTSTATUS
(NTAPI
*t_NtContinue)(
	_In_ PCONTEXT ContextRecord,
	_In_ BOOLEAN TestAlert
	);

typedef
NTSTATUS
(NTAPI
*t_NtCreateThread)(
	_Out_ PHANDLE ThreadHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ HANDLE ProcessHandle,
	_Out_ PCLIENT_ID ClientId,
	_In_ PCONTEXT ThreadContext,
	_In_ PINITIAL_TEB InitialTeb,
	_In_ BOOLEAN CreateSuspended
	);

typedef
NTSTATUS
(NTAPI
*t_NtCreateThreadEx)(
	_Out_ PHANDLE ThreadHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ HANDLE ProcessHandle,
	_In_ PUSER_THREAD_START_ROUTINE StartRoutine,
	_In_opt_ PVOID Argument,
	_In_ ULONG CreateFlags,
	_In_opt_ ULONG_PTR ZeroBits,
	_In_opt_ SIZE_T StackSize,
	_In_opt_ SIZE_T MaximumStackSize,
	_In_opt_ PPS_ATTRIBUTE_LIST AttributeList
	);

typedef
NTSTATUS
(NTAPI
*t_NtGetContextThread)(
	_In_ HANDLE ThreadHandle,
	_Inout_ PCONTEXT ThreadContext
	);

typedef
NTSTATUS
(NTAPI
*t_NtOpenProcess)(
	_Out_ PHANDLE ProcessHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_opt_ PCLIENT_ID ClientId
	);

typedef
NTSTATUS
(NTAPI
*t_NtProtectVirtualMemory)(
	_In_ HANDLE ProcessHandle,
	_Inout_ PVOID *BaseAddress,
	_Inout_ PSIZE_T RegionSize,
	_In_ ULONG NewProtect,
	_Out_ PULONG OldProtect
	);

typedef
NTSTATUS
(NTAPI
*t_NtQueryDebugFilterState)(
	_In_ ULONG ComponentId,
	_In_ ULONG Level
	);

typedef
NTSTATUS
(NTAPI
*t_NtQueryInformationProcess)(
	_In_ HANDLE ProcessHandle,
	_In_ PROCESSINFOCLASS ProcessInformationClass,
	_Out_ PVOID ProcessInformation,
	_In_ ULONG ProcessInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

typedef
NTSTATUS
(NTAPI
*t_NtQueryInformationThread)(
	_In_ HANDLE ThreadHandle,
	_In_ THREADINFOCLASS ThreadInformationClass,
	_Out_ PVOID ThreadInformation,
	_In_ ULONG ThreadInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

typedef
NTSTATUS
(NTAPI
*t_NtQueryObject)(
	_In_ HANDLE Handle,
	_In_ OBJECT_INFORMATION_CLASS ObjectInformationClass,
	_Out_opt_ PVOID ObjectInformation,
	_In_ ULONG ObjectInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

typedef
NTSTATUS
(NTAPI
*t_NtQueryPerformanceCounter)(
	_Out_ PLARGE_INTEGER PerformanceCounter,
	_Out_opt_ PLARGE_INTEGER PerformanceFrequency
	);

typedef
NTSTATUS
(NTAPI
*t_NtQuerySystemInformation)(
	_In_ SYSTEM_INFORMATION_CLASS SystemInformationClass,
	_Out_opt_ PVOID SystemInformation,
	_In_ ULONG SystemInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

typedef
NTSTATUS
(NTAPI
*t_NtQuerySystemTime)(
	_Out_ PLARGE_INTEGER SystemTime
	);

typedef
NTSTATUS
(NTAPI
*t_NtQueryVirtualMemory)(
	_In_ HANDLE ProcessHandle,
	_In_ PVOID BaseAddress,
	_In_ MEMORY_INFORMATION_CLASS MemoryInformationClass,
	_Out_ PVOID MemoryInformation,
	_In_ SIZE_T MemoryInformationLength,
	_Out_opt_ PSIZE_T ReturnLength
	);

typedef
NTSTATUS
(NTAPI
*t_NtResumeProcess)(
	_In_ HANDLE ProcessHandle
	);

typedef
NTSTATUS
(NTAPI
*t_NtResumeThread)(
	_In_ HANDLE ThreadHandle,
	_Out_opt_ PULONG PreviousSuspendCount
	);

typedef
NTSTATUS
(NTAPI
*t_NtSetContextThread)(
	_In_ HANDLE ThreadHandle,
	_In_ PCONTEXT ThreadContext
	);

typedef
NTSTATUS
(NTAPI
*t_NtSetDebugFilterState)(
	_In_ ULONG ComponentId,
	_In_ ULONG Level,
	_In_ BOOLEAN State
	);

typedef
NTSTATUS
(NTAPI
*t_NtSetInformationProcess)(
	_In_ HANDLE ProcessHandle,
	_In_ PROCESSINFOCLASS ProcessInformationClass,
	_In_ PVOID ProcessInformation,
	_In_ ULONG ProcessInformationLength
	);

typedef
NTSTATUS
(NTAPI
*t_NtSetInformationThread)(
	_In_ HANDLE ThreadHandle,
	_In_ THREADINFOCLASS ThreadInformationClass,
	_In_ PVOID ThreadInformation,
	_In_ ULONG ThreadInformationLength
	);

typedef
NTSTATUS
(NTAPI
*t_NtSetSystemInformation)(
	_In_ SYSTEM_INFORMATION_CLASS SystemInformationClass,
	_In_opt_ PVOID SystemInformation,
	_In_ ULONG SystemInformationLength
	);

typedef
NTSTATUS
(NTAPI
*t_NtSetSystemTime)(
	_In_opt_ PLARGE_INTEGER SystemTime,
	_Out_opt_ PLARGE_INTEGER PreviousTime
	);

typedef
NTSTATUS
(NTAPI
*t_NtSuspendProcess)(
	_In_ HANDLE ProcessHandle
	);

typedef
NTSTATUS
(NTAPI
*t_NtSuspendThread)(
	_In_ HANDLE ThreadHandle,
	_Out_opt_ PULONG PreviousSuspendCount
	);

typedef
NTSTATUS
(NTAPI
*t_NtSystemDebugControl)(
	_In_ SYSDBG_COMMAND Command,
	_Inout_opt_ PVOID InputBuffer,
	_In_ ULONG InputBufferLength,
	_Out_opt_ PVOID OutputBuffer,
	_In_ ULONG OutputBufferLength,
	_Out_opt_ PULONG ReturnLength
	);

typedef
NTSTATUS
(NTAPI
*t_NtTerminateProcess)(
	_In_opt_ HANDLE ProcessHandle,
	_In_ NTSTATUS ExitStatus
	);

typedef
NTSTATUS
(NTAPI
*t_NtYieldExecution)(
	);

typedef
VOID
(NTAPI
*t_KiUserExceptionDispatcher)(
	_In_ PEXCEPTION_RECORD ExceptionRecord,
	_In_ PCONTEXT ContextFrame
	);

#ifdef _WIN64
typedef
VOID
(NTAPI
*t_RtlRestoreContext)(
	_In_ PCONTEXT ContextRecord,
	_In_opt_ PEXCEPTION_RECORD ExceptionRecord
	);
#endif

typedef
NTSTATUS
(NTAPI
*t_NtReadVirtualMemory)(
	_In_ HANDLE ProcessHandle,
	_In_opt_ PVOID BaseAddress,
	_Out_ PVOID Buffer,
	_In_ SIZE_T BufferSize,
	_Out_opt_ PSIZE_T NumberOfBytesRead
	);

typedef
NTSTATUS
(NTAPI
*t_NtWriteVirtualMemory)(
	HANDLE ProcessHandle,
	PVOID BaseAddress,
	CONST VOID *Buffer,
	SIZE_T BufferSize,
	PSIZE_T NumberOfBytesWritten
	);

// win32k system calls
// BlockInput
typedef
NTSTATUS
(NTAPI
*t_NtUserBlockInput)(
	_In_ BOOL BlockIt
	);

#define NtUserFindWindowEx_FW_BOTH 0
#define NtUserFindWindowEx_FW_16BIT 1
#define NtUserFindWindowEx_FW_32BIT 2

// FindWindow
typedef
HWND
(NTAPI
*t_NtUserFindWindowEx)(
	_In_ HWND hWndParent,
	_In_opt_ HWND hWndChildAfter,
	_In_ PUNICODE_STRING lpszClass,
	_In_opt_ PUNICODE_STRING lpszWindow,
	_In_ DWORD dwType
	);

// EnumWindows
typedef
NTSTATUS
(NTAPI
*t_NtUserBuildHwndList)(
	_In_ HDESK hdesk,
	_In_opt_ HWND hwndNext,
	_In_ BOOL fEnumChildren,
	_In_opt_ DWORD idThread,
	_In_opt_ UINT cHwndMax,
	_Out_ HWND *phwndFirst,
	_In_ PUINT pcHwndNeeded
	);

typedef enum _WINDOWINFOCLASS
{
	WindowProcess			= 0,	// HANDLE
	WindowRealWindowOwner	= 1,
	WindowThread			= 2,	// HANDLE
	WindowIsHung			= 5		// BOOL
} WINDOWINFOCLASS;

// GetWindowThreadProcessId
typedef
HANDLE
(NTAPI
*t_NtUserQueryWindow)(
	_In_ HWND hwnd,
	_In_ WINDOWINFOCLASS WindowInfo
	);

typedef
int
(NTAPI
*t_NtUserGetClassName)(
	_In_ HWND hWnd,
	_In_ BOOL Real,
	_Out_ PUNICODE_STRING ClassName
	);

typedef
int
(NTAPI
*t_NtUserInternalGetWindowText)(
	_In_ HWND hwnd,
	_Out_ LPWSTR lpString,
	_In_ int nMaxCount
	);

FORCEINLINE
VOID
InitializeListHead(
	_Out_ PLIST_ENTRY ListHead
	)
{
	ListHead->Flink = ListHead->Blink = ListHead;
}

FORCEINLINE
BOOLEAN
IsListEmpty(
	_In_ PLIST_ENTRY ListHead
	)
{
	return ListHead->Flink == ListHead;
}

FORCEINLINE
BOOLEAN
RemoveEntryList(
	_In_ PLIST_ENTRY Entry
	)
{
	PLIST_ENTRY Flink = Entry->Flink;
	PLIST_ENTRY Blink = Entry->Blink;
	Blink->Flink = Flink;
	Flink->Blink = Blink;

	return Flink == Blink;
}

FORCEINLINE
PLIST_ENTRY
RemoveHeadList(
	_Inout_ PLIST_ENTRY ListHead
	)
{
	PLIST_ENTRY Entry = ListHead->Flink;
	PLIST_ENTRY Flink = Entry->Flink;
	ListHead->Flink = Flink;
	Flink->Blink = ListHead;

	return Entry;
}

FORCEINLINE
PLIST_ENTRY
RemoveTailList(
	_Inout_ PLIST_ENTRY ListHead
	)
{
	PLIST_ENTRY Entry = ListHead->Blink;
	PLIST_ENTRY Blink = Entry->Blink;
	ListHead->Blink = Blink;
	Blink->Flink = ListHead;

	return Entry;
}

FORCEINLINE
VOID
InsertTailList(
	_Inout_ PLIST_ENTRY ListHead,
	_Inout_ PLIST_ENTRY Entry
	)
{
	PLIST_ENTRY Blink = ListHead->Blink;
	Entry->Flink = ListHead;
	Entry->Blink = Blink;
	Blink->Flink = Entry;
	ListHead->Blink = Entry;
}

FORCEINLINE
VOID
InsertHeadList(
	_Inout_ PLIST_ENTRY ListHead,
	_Inout_ PLIST_ENTRY Entry
	)
{
	PLIST_ENTRY Flink = ListHead->Flink;
	Entry->Flink = Flink;
	Entry->Blink = ListHead;
	Flink->Blink = Entry;
	ListHead->Flink = Entry;
}

FORCEINLINE
VOID
AppendTailList(
	_Inout_ PLIST_ENTRY ListHead,
	_Inout_ PLIST_ENTRY ListToAppend
	)
{
	PLIST_ENTRY ListEnd = ListHead->Blink;

	ListHead->Blink->Flink = ListToAppend;
	ListHead->Blink = ListToAppend->Blink;
	ListToAppend->Blink->Flink = ListHead;
	ListToAppend->Blink = ListEnd;
}

FORCEINLINE
PSINGLE_LIST_ENTRY
PopEntryList(
	_Inout_ PSINGLE_LIST_ENTRY ListHead
	)
{
	PSINGLE_LIST_ENTRY FirstEntry = ListHead->Next;

	if (FirstEntry)
		ListHead->Next = FirstEntry->Next;

	return FirstEntry;
}

FORCEINLINE
VOID
PushEntryList(
	_Inout_ PSINGLE_LIST_ENTRY ListHead,
	_Inout_ PSINGLE_LIST_ENTRY Entry
	)
{
	Entry->Next = ListHead->Next;
	ListHead->Next = Entry;
}

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateProcess(
	_Out_ PHANDLE ProcessHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ HANDLE ParentProcess,
	_In_ BOOLEAN InheritObjectTable,
	_In_opt_ HANDLE SectionHandle,
	_In_opt_ HANDLE DebugPort,
	_In_opt_ HANDLE TokenHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateProcessEx(
	_Out_ PHANDLE ProcessHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ HANDLE ParentProcess,
	_In_ ULONG Flags,
	_In_opt_ HANDLE SectionHandle,
	_In_opt_ HANDLE DebugPort,
	_In_opt_ HANDLE TokenHandle,
	_In_ ULONG JobMemberLevel
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateUserProcess(
	_Out_ PHANDLE ProcessHandle,
	_Out_ PHANDLE ThreadHandle,
	_In_ ACCESS_MASK ProcessDesiredAccess,
	_In_ ACCESS_MASK ThreadDesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ProcessObjectAttributes,
	_In_opt_ POBJECT_ATTRIBUTES ThreadObjectAttributes,
	_In_ ULONG ProcessFlags,
	_In_ ULONG ThreadFlags,
	_In_ PRTL_USER_PROCESS_PARAMETERS ProcessParameters,
	_Inout_ PPS_CREATE_INFO CreateInfo,
	_In_ PPS_ATTRIBUTE_LIST AttributeList
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationProcess(
	_In_ HANDLE ProcessHandle,
	_In_ PROCESSINFOCLASS ProcessInformationClass,
	_In_ PVOID ProcessInformation,
	_In_ ULONG ProcessInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryInformationProcess(
	_In_ HANDLE ProcessHandle,
	_In_ PROCESSINFOCLASS ProcessInformationClass,
	_Out_ PVOID ProcessInformation,
	_In_ ULONG ProcessInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryObject(
	_In_ HANDLE Handle,
	_In_ OBJECT_INFORMATION_CLASS ObjectInformationClass,
	_Out_opt_ PVOID ObjectInformation,
	_In_ ULONG ObjectInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQuerySystemInformation(
	_In_ SYSTEM_INFORMATION_CLASS SystemInformationClass,
	_Out_writes_bytes_to_opt_(SystemInformationLength, *ReturnLength) PVOID SystemInformation,
	_In_ ULONG SystemInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSCALLAPI
NTSTATUS
NTAPI
NtQuerySystemInformationEx(
	_In_ SYSTEM_INFORMATION_CLASS SystemInformationClass,
	_In_reads_bytes_(InputBufferLength) PVOID InputBuffer,
	_In_ ULONG InputBufferLength,
	_Out_writes_bytes_opt_(SystemInformationLength) PVOID SystemInformation,
	_In_ ULONG SystemInformationLength,
	_Out_opt_ PULONG ReturnLength
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetSystemInformation(
	_In_ SYSTEM_INFORMATION_CLASS SystemInformationClass,
	_In_reads_bytes_opt_(SystemInformationLength) PVOID SystemInformation,
	_In_ ULONG SystemInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationThread(
	_In_ HANDLE ThreadHandle,
	_In_ THREADINFOCLASS ThreadInformationClass,
	_In_ PVOID ThreadInformation,
	_In_ ULONG ThreadInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryInformationThread(
	_In_ HANDLE ThreadHandle,
	_In_ THREADINFOCLASS ThreadInformationClass,
	_Out_ PVOID ThreadInformation,
	_In_ ULONG ThreadInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtUnmapViewOfSection(
	_In_ HANDLE ProcessHandle,
	_In_opt_ PVOID BaseAddress
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtExtendSection(
	_In_ HANDLE SectionHandle,
	_Inout_ PLARGE_INTEGER NewSectionSize
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSuspendThread(
	_In_ HANDLE ThreadHandle,
	_Out_opt_ PULONG PreviousSuspendCount
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtResumeThread(
	_In_ HANDLE ThreadHandle,
	_Out_opt_ PULONG PreviousSuspendCount
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSuspendProcess(
	_In_ HANDLE ProcessHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtResumeProcess(
	_In_ HANDLE ProcessHandle
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSCALLAPI
ULONG
NTAPI
NtGetCurrentProcessorNumber(
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSignalAndWaitForSingleObject(
	_In_ HANDLE SignalHandle,
	_In_ HANDLE WaitHandle,
	_In_ BOOLEAN Alertable,
	_In_opt_ PLARGE_INTEGER Timeout
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtWaitForSingleObject(
	_In_ HANDLE Handle,
	_In_ BOOLEAN Alertable,
	_In_opt_ PLARGE_INTEGER Timeout
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtWaitForMultipleObjects(
	_In_ ULONG Count,
	_In_reads_(Count) HANDLE Handles[],
	_In_ WAIT_TYPE WaitType,
	_In_ BOOLEAN Alertable,
	_In_opt_ PLARGE_INTEGER Timeout
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSCALLAPI
NTSTATUS
NTAPI
NtWaitForMultipleObjects32(
	_In_ ULONG Count,
	_In_reads_(Count) HANDLE Handles[],
	_In_ WAIT_TYPE WaitType,
	_In_ BOOLEAN Alertable,
	_In_opt_ PLARGE_INTEGER Timeout
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetSecurityObject(
	_In_ HANDLE Handle,
	_In_ SECURITY_INFORMATION SecurityInformation,
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQuerySecurityObject(
	_In_ HANDLE Handle,
	_In_ SECURITY_INFORMATION SecurityInformation,
	_Out_writes_bytes_to_(Length,*LengthNeeded) PSECURITY_DESCRIPTOR SecurityDescriptor,
	_In_ ULONG Length,
	_Out_ PULONG LengthNeeded
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueueApcThread(
	_In_ HANDLE ThreadHandle,
	_In_ PPS_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcArgument1,
	_In_opt_ PVOID ApcArgument2,
	_In_opt_ PVOID ApcArgument3
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueueApcThreadEx(
	_In_ HANDLE ThreadHandle,
	_In_opt_ HANDLE UserApcReserveHandle,
	_In_ PPS_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcArgument1,
	_In_opt_ PVOID ApcArgument2,
	_In_opt_ PVOID ApcArgument3
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtProtectVirtualMemory(
	_In_ HANDLE ProcessHandle,
	_Inout_ PVOID *BaseAddress,
	_Inout_ PSIZE_T RegionSize,
	_In_ ULONG NewProtect,
	_Out_ PULONG OldProtect
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtFlushBuffersFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtFlushInstructionCache(
	_In_ HANDLE ProcessHandle,
	_In_opt_ PVOID BaseAddress,
	_In_ SIZE_T Length
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtFlushWriteBuffer(
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtFsControlFile(
	_In_ HANDLE FileHandle,
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ ULONG FsControlCode,
	_In_reads_bytes_opt_(InputBufferLength) PVOID InputBuffer,
	_In_ ULONG InputBufferLength,
	_Out_writes_bytes_opt_(OutputBufferLength) PVOID OutputBuffer,
	_In_ ULONG OutputBufferLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtLockFile(
	_In_ HANDLE FileHandle,
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ PLARGE_INTEGER ByteOffset,
	_In_ PLARGE_INTEGER Length,
	_In_ ULONG Key,
	_In_ BOOLEAN FailImmediately,
	_In_ BOOLEAN ExclusiveLock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtUnlockFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ PLARGE_INTEGER ByteOffset,
	_In_ PLARGE_INTEGER Length,
	_In_ ULONG Key
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtFlushVirtualMemory(
	_In_ HANDLE ProcessHandle,
	_Inout_ PVOID *BaseAddress,
	_Inout_ PSIZE_T RegionSize,
	_Out_ PIO_STATUS_BLOCK IoStatus
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryVirtualMemory(
	_In_ HANDLE ProcessHandle,
	_In_ PVOID BaseAddress,
	_In_ MEMORY_INFORMATION_CLASS MemoryInformationClass,
	_Out_ PVOID MemoryInformation,
	_In_ SIZE_T MemoryInformationLength,
	_Out_opt_ PSIZE_T ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtLockVirtualMemory(
	_In_ HANDLE ProcessHandle,
	_Inout_ PVOID *BaseAddress,
	_Inout_ PSIZE_T RegionSize,
	_In_ ULONG MapType
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtUnlockVirtualMemory(
	_In_ HANDLE ProcessHandle,
	_Inout_ PVOID *BaseAddress,
	_Inout_ PSIZE_T RegionSize,
	_In_ ULONG MapType
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSystemDebugControl(
	_In_ SYSDBG_COMMAND Command,
	_Inout_updates_bytes_opt_(InputBufferLength) PVOID InputBuffer,
	_In_ ULONG InputBufferLength,
	_Out_writes_bytes_opt_(OutputBufferLength) PVOID OutputBuffer,
	_In_ ULONG OutputBufferLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtYieldExecution(
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtClose(
	_In_ HANDLE Handle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryAttributesFile(
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_Out_ PFILE_BASIC_INFORMATION FileInformation
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryFullAttributesFile(
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_Out_ PFILE_NETWORK_OPEN_INFORMATION FileInformation
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryInformationFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_Out_writes_bytes_(Length) PVOID FileInformation,
	_In_ ULONG Length,
	_In_ FILE_INFORMATION_CLASS FileInformationClass
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_reads_bytes_(Length) PVOID FileInformation,
	_In_ ULONG Length,
	_In_ FILE_INFORMATION_CLASS FileInformationClass
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetQuotaInformationFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_reads_bytes_(Length) PVOID Buffer,
	_In_ ULONG Length
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetVolumeInformationFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_reads_bytes_(Length) PVOID FsInformation,
	_In_ ULONG Length,
	_In_ FS_INFORMATION_CLASS FsInformationClass
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateFile(
	_Out_ PHANDLE FileHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_opt_ PLARGE_INTEGER AllocationSize,
	_In_ ULONG FileAttributes,
	_In_ ULONG ShareAccess,
	_In_ ULONG CreateDisposition,
	_In_ ULONG CreateOptions,
	_In_reads_bytes_opt_(EaLength) PVOID EaBuffer,
	_In_ ULONG EaLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateNamedPipeFile(
	_Out_ PHANDLE FileHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ ULONG ShareAccess,
	_In_ ULONG CreateDisposition,
	_In_ ULONG CreateOptions,
	_In_ ULONG NamedPipeType,
	_In_ ULONG ReadMode,
	_In_ ULONG CompletionMode,
	_In_ ULONG MaximumInstances,
	_In_ ULONG InboundQuota,
	_In_ ULONG OutboundQuota,
	_In_opt_ PLARGE_INTEGER DefaultTimeout
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateMailslotFile(
	_Out_ PHANDLE FileHandle,
	_In_ ULONG DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ ULONG CreateOptions,
	_In_ ULONG MailslotQuota,
	_In_ ULONG MaximumMessageSize,
	_In_ PLARGE_INTEGER ReadTimeout
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCancelIoFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtCancelIoFileEx(
	_In_ HANDLE FileHandle,
	_In_opt_ PIO_STATUS_BLOCK IoRequestToCancel,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCancelSynchronousIoFile(
	_In_ HANDLE ThreadHandle,
	_In_opt_ PIO_STATUS_BLOCK IoRequestToCancel,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateSymbolicLinkObject(
	_Out_ PHANDLE LinkHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ PUNICODE_STRING LinkTarget
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenSymbolicLinkObject(
	_Out_ PHANDLE LinkHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQuerySymbolicLinkObject(
	_In_ HANDLE LinkHandle,
	_Inout_ PUNICODE_STRING LinkTarget,
	_Out_opt_ PULONG ReturnedLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtGetContextThread(
	_In_ HANDLE ThreadHandle,
	_Inout_ PCONTEXT ThreadContext
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetContextThread(
	_In_ HANDLE ThreadHandle,
	_In_ PCONTEXT ThreadContext
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenProcess(
	_Out_ PHANDLE ProcessHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_opt_ PCLIENT_ID ClientId
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtTerminateProcess(
	_In_opt_ HANDLE ProcessHandle,
	_In_ NTSTATUS ExitStatus
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSCALLAPI
NTSTATUS
NTAPI
NtGetNextProcess(
	_In_ HANDLE ProcessHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ ULONG HandleAttributes,
	_In_ ULONG Flags,
	_Out_ PHANDLE NewProcessHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtGetNextThread(
	_In_ HANDLE ProcessHandle,
	_In_ HANDLE ThreadHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ ULONG HandleAttributes,
	_In_ ULONG Flags,
	_Out_ PHANDLE NewThreadHandle
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateDebugObject(
	_Out_ PHANDLE DebugObjectHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ ULONG Flags
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDebugActiveProcess(
	_In_ HANDLE ProcessHandle,
	_In_ HANDLE DebugObjectHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtContinue(
	_In_ PCONTEXT ContextRecord,
	_In_ BOOLEAN TestAlert
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRaiseException(
	_In_ PEXCEPTION_RECORD ExceptionRecord,
	_In_ PCONTEXT ContextRecord,
	_In_ BOOLEAN FirstChance
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateThread(
	_Out_ PHANDLE ThreadHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ HANDLE ProcessHandle,
	_Out_ PCLIENT_ID ClientId,
	_In_ PCONTEXT ThreadContext,
	_In_ PINITIAL_TEB InitialTeb,
	_In_ BOOLEAN CreateSuspended
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateThreadEx(
	_Out_ PHANDLE ThreadHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ HANDLE ProcessHandle,
	_In_ PUSER_THREAD_START_ROUTINE StartRoutine,
	_In_opt_ PVOID Argument,
	_In_ ULONG CreateFlags,
	_In_opt_ SIZE_T ZeroBits,
	_In_opt_ SIZE_T StackSize,
	_In_opt_ SIZE_T MaximumStackSize,
	_In_opt_ PPS_ATTRIBUTE_LIST AttributeList
	);
#endif

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSCALLAPI
NTSTATUS
NTAPI
NtAllocateReserveObject(
	_Out_ PHANDLE MemoryReserveHandle,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ MEMORY_RESERVE_TYPE Type
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRegisterThreadTerminatePort(
	_In_ HANDLE PortHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRaiseHardError(
	_In_ NTSTATUS ErrorStatus,
	_In_ ULONG NumberOfParameters,
	_In_ ULONG UnicodeStringParameterMask,
	_In_reads_(NumberOfParameters) PULONG_PTR Parameters,
	_In_ HARDERROR_RESPONSE_OPTION ResponseOption,
	_Out_ PHARDERROR_RESPONSE Response
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAllocateVirtualMemory(
	_In_ HANDLE ProcessHandle,
	_Inout_ _At_(*BaseAddress, _Readable_bytes_(*RegionSize) _Writable_bytes_(*RegionSize) _Post_readable_byte_size_(*RegionSize)) PVOID *BaseAddress,
	_In_ ULONG_PTR ZeroBits,
	_Inout_ PSIZE_T RegionSize,
	_In_ ULONG AllocationType,
	_In_ ULONG Protect
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtFreeVirtualMemory(
	_In_ HANDLE ProcessHandle,
	_Inout_ PVOID *BaseAddress,
	_Inout_ PSIZE_T RegionSize,
	_In_ ULONG FreeType
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtReadVirtualMemory(
	_In_ HANDLE ProcessHandle,
	_In_opt_ PVOID BaseAddress,
	_Out_writes_bytes_(BufferSize) PVOID Buffer,
	_In_ SIZE_T BufferSize,
	_Out_opt_ PSIZE_T NumberOfBytesRead
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtWriteVirtualMemory(
	_In_ HANDLE ProcessHandle,
	_In_opt_ PVOID BaseAddress,
	_In_reads_bytes_(BufferSize) CONST VOID *Buffer,
	_In_ SIZE_T BufferSize,
	_Out_opt_ PSIZE_T NumberOfBytesWritten
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAllocateUserPhysicalPages(
	_In_ HANDLE ProcessHandle,
	_Inout_ PULONG_PTR NumberOfPages,
	_Out_writes_(*NumberOfPages) PULONG_PTR UserPfnArray
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtMapUserPhysicalPages(
	_In_ PVOID VirtualAddress,
	_In_ ULONG_PTR NumberOfPages,
	_In_reads_opt_(NumberOfPages) PULONG_PTR UserPfnArray
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtMapUserPhysicalPagesScatter(
	_In_reads_(NumberOfPages) PVOID *VirtualAddresses,
	_In_ ULONG_PTR NumberOfPages,
	_In_reads_opt_(NumberOfPages) PULONG_PTR UserPfnArray
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtFreeUserPhysicalPages(
	_In_ HANDLE ProcessHandle,
	_Inout_ PULONG_PTR NumberOfPages,
	_In_reads_(*NumberOfPages) PULONG_PTR UserPfnArray
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQuerySection(
	_In_ HANDLE SectionHandle,
	_In_ SECTION_INFORMATION_CLASS SectionInformationClass,
	_Out_writes_bytes_(SectionInformationLength) PVOID SectionInformation,
	_In_ SIZE_T SectionInformationLength,
	_Out_opt_ PSIZE_T ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAreMappedFilesTheSame(
	_In_ PVOID File1MappedAsAnImage,
	_In_ PVOID File2MappedAsFile
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateSection(
	_Out_ PHANDLE SectionHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_opt_ PLARGE_INTEGER MaximumSize,
	_In_ ULONG SectionPageProtection,
	_In_ ULONG AllocationAttributes,
	_In_opt_ HANDLE FileHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenSection(
	_Out_ PHANDLE SectionHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtMapViewOfSection(
	_In_ HANDLE SectionHandle,
	_In_ HANDLE ProcessHandle,
	_Inout_ _At_(*BaseAddress, _Readable_bytes_(*ViewSize) _Writable_bytes_(*ViewSize) _Post_readable_byte_size_(*ViewSize)) PVOID *BaseAddress,
	_In_ ULONG_PTR ZeroBits,
	_In_ SIZE_T CommitSize,
	_Inout_opt_ PLARGE_INTEGER SectionOffset,
	_Inout_ PSIZE_T ViewSize,
	_In_ SECTION_INHERIT InheritDisposition,
	_In_ ULONG AllocationType,
	_In_ ULONG Win32Protect
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenSession(
	_Out_ PHANDLE SessionHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtNotifyChangeDirectoryFile(
	_In_ HANDLE FileHandle,
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_Out_ FILE_NOTIFY_INFORMATION Buffer,
	_In_ ULONG Length,
	_In_ ULONG CompletionFilter,
	_In_ BOOLEAN WatchTree
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenFile(
	_Out_ PHANDLE FileHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ ULONG ShareAccess,
	_In_ ULONG OpenOptions
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryDirectoryFile(
	_In_ HANDLE FileHandle,
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_Out_writes_bytes_(Length) PVOID FileInformation,
	_In_ ULONG Length,
	_In_ FILE_INFORMATION_CLASS FileInformationClass,
	_In_ BOOLEAN ReturnSingleEntry,
	_In_opt_ PUNICODE_STRING FileName,
	_In_ BOOLEAN RestartScan
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryEaFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_Out_writes_bytes_(Length) PVOID Buffer,
	_In_ ULONG Length,
	_In_ BOOLEAN ReturnSingleEntry,
	_In_reads_bytes_opt_(EaListLength) PVOID EaList,
	_In_ ULONG EaListLength,
	_In_opt_ PULONG EaIndex,
	_In_ BOOLEAN RestartScan
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetEaFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_reads_bytes_(Length) PVOID Buffer,
	_In_ ULONG Length
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtLoadDriver(
	_In_ PUNICODE_STRING DriverServiceName
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtUnloadDriver(
	_In_ PUNICODE_STRING DriverServiceName
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtReadFile(
	_In_ HANDLE FileHandle,
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_Out_writes_bytes_(Length) PVOID Buffer,
	_In_ ULONG Length,
	_In_opt_ PLARGE_INTEGER ByteOffset,
	_In_opt_ PULONG Key
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtReadFileScatter(
	_In_ HANDLE FileHandle,
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ PFILE_SEGMENT_ELEMENT SegmentArray,
	_In_ ULONG Length,
	_In_opt_ PLARGE_INTEGER ByteOffset,
	_In_opt_ PULONG Key
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtWriteFileGather(
	_In_ HANDLE FileHandle,
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ PFILE_SEGMENT_ELEMENT SegmentArray,
	_In_ ULONG Length,
	_In_opt_ PLARGE_INTEGER ByteOffset,
	_In_opt_ PULONG Key
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDeleteFile(
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtWriteFile(
	_In_ HANDLE FileHandle,
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_reads_bytes_(Length) PVOID Buffer,
	_In_ ULONG Length,
	_In_opt_ PLARGE_INTEGER ByteOffset,
	_In_opt_ PULONG Key
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDeviceIoControlFile(
	_In_ HANDLE FileHandle,
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ ULONG IoControlCode,
	_In_reads_bytes_opt_(InputBufferLength) PVOID InputBuffer,
	_In_ ULONG InputBufferLength,
	_Out_writes_bytes_opt_(OutputBufferLength) PVOID OutputBuffer,
	_In_ ULONG OutputBufferLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationObject(
	_In_ HANDLE Handle,
	_In_ OBJECT_INFORMATION_CLASS ObjectInformationClass,
	_In_reads_bytes_(ObjectInformationLength) PVOID ObjectInformation,
	_In_ ULONG ObjectInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDuplicateObject(
	_In_ HANDLE SourceProcessHandle,
	_In_ HANDLE SourceHandle,
	_In_opt_ HANDLE TargetProcessHandle,
	_Out_opt_ PHANDLE TargetHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ ULONG HandleAttributes,
	_In_ ULONG Options
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtMakePermanentObject(
	_In_ HANDLE Object
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtMakeTemporaryObject(
	_In_ HANDLE Handle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateDirectoryObject(
	_Out_ PHANDLE DirectoryHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenDirectoryObject(
	_Out_ PHANDLE DirectoryHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryDirectoryObject(
	_In_ HANDLE DirectoryHandle,
	_Out_writes_bytes_opt_(Length) PVOID Buffer,
	_In_ ULONG Length,
	_In_ BOOLEAN ReturnSingleEntry,
	_In_ BOOLEAN RestartScan,
	_Inout_ PULONG Context,
	_Out_opt_ PULONG ReturnLength
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreatePrivateNamespace(
	_Out_ PHANDLE NamespaceHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ PVOID BoundaryDescriptor
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenPrivateNamespace(
	_Out_ PHANDLE NamespaceHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ PVOID BoundaryDescriptor
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDeletePrivateNamespace(
	_In_ HANDLE NamespaceHandle
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenThread(
	_Out_ PHANDLE ThreadHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_opt_ PCLIENT_ID ClientId
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtTerminateThread(
	_In_opt_ HANDLE ThreadHandle,
	_In_ NTSTATUS ExitStatus
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQuerySystemTime(
	_Out_ PLARGE_INTEGER SystemTime
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetSystemTime(
	_In_opt_ PLARGE_INTEGER SystemTime,
	_Out_opt_ PLARGE_INTEGER PreviousTime
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryTimerResolution(
	_Out_ PULONG MaximumTime,
	_Out_ PULONG MinimumTime,
	_Out_ PULONG CurrentTime
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetTimerResolution(
	_In_ ULONG DesiredTime,
	_In_ BOOLEAN SetResolution,
	_Out_ PULONG ActualTime
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryPerformanceCounter(
	_Out_ PLARGE_INTEGER PerformanceCounter,
	_Out_opt_ PLARGE_INTEGER PerformanceFrequency
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAllocateLocallyUniqueId(
	_Out_ PLUID Luid
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetUuidSeed(
	_In_ PCHAR Seed
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAllocateUuids(
	_Out_ PULARGE_INTEGER Time,
	_Out_ PULONG Range,
	_Out_ PULONG Sequence,
	_Out_ PCHAR Seed
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateEvent(
	_Out_ PHANDLE EventHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ EVENT_TYPE EventType,
	_In_ BOOLEAN InitialState
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenEvent(
	_Out_ PHANDLE EventHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetEvent(
	_In_ HANDLE EventHandle,
	_Out_opt_ PLONG PreviousState
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtResetEvent(
	_In_ HANDLE EventHandle,
	_Out_opt_ PLONG PreviousState
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtClearEvent(
	_In_ HANDLE EventHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryQuotaInformationFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_Out_ PVOID Buffer,
	_In_ ULONG Length,
	_In_ BOOLEAN ReturnSingleEntry,
	_In_opt_ PVOID SidList,
	_In_ ULONG SidListLength,
	_In_opt_ PSID StartSid,
	_In_ BOOLEAN RestartScan
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryVolumeInformationFile(
	_In_ HANDLE FileHandle,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_Out_writes_bytes_(Length) PVOID FsInformation,
	_In_ ULONG Length,
	_In_ FS_INFORMATION_CLASS FsInformationClass
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateKey(
	_Out_ PHANDLE KeyHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_Reserved_ ULONG TitleIndex,
	_In_opt_ PUNICODE_STRING Class,
	_In_ ULONG CreateOptions,
	_Out_opt_ PULONG Disposition
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateKeyTransacted(
	_Out_ PHANDLE KeyHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_Reserved_ ULONG TitleIndex,
	_In_opt_ PUNICODE_STRING Class,
	_In_ ULONG CreateOptions,
	_In_ HANDLE TransactionHandle,
	_Out_opt_ PULONG Disposition
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenKey(
	_Out_ PHANDLE KeyHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenKeyTransacted(
	_Out_ PHANDLE KeyHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ HANDLE TransactionHandle
	);
#endif

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenKeyEx(
	_Out_ PHANDLE KeyHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ ULONG OpenOptions
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenKeyTransactedEx(
	_Out_ PHANDLE KeyHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ ULONG OpenOptions,
	_In_ HANDLE TransactionHandle
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDeleteKey(
	_In_ HANDLE KeyHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRenameKey(
	_In_ HANDLE KeyHandle,
	_In_ PUNICODE_STRING NewName
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDeleteValueKey(
	_In_ HANDLE KeyHandle,
	_In_ PUNICODE_STRING ValueName
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryKey(
	_In_ HANDLE KeyHandle,
	_In_ KEY_INFORMATION_CLASS KeyInformationClass,
	_Out_writes_bytes_to_opt_(Length, *ResultLength) PVOID KeyInformation,
	_In_ ULONG Length,
	_Out_ PULONG ResultLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationKey(
	_In_ HANDLE KeyHandle,
	_In_ KEY_SET_INFORMATION_CLASS KeySetInformationClass,
	_In_reads_bytes_(KeySetInformationLength) PVOID KeySetInformation,
	_In_ ULONG KeySetInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryValueKey(
	_In_ HANDLE KeyHandle,
	_In_ PUNICODE_STRING ValueName,
	_In_ KEY_VALUE_INFORMATION_CLASS KeyValueInformationClass,
	_Out_writes_bytes_to_opt_(Length, *ResultLength) PVOID KeyValueInformation,
	_In_ ULONG Length,
	_Out_ PULONG ResultLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetValueKey(
	_In_ HANDLE KeyHandle,
	_In_ PUNICODE_STRING ValueName,
	_In_opt_ ULONG TitleIndex,
	_In_ ULONG Type,
	_In_reads_bytes_opt_(DataSize) PVOID Data,
	_In_ ULONG DataSize
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryMultipleValueKey(
	_In_ HANDLE KeyHandle,
	_Inout_updates_(EntryCount) PKEY_VALUE_ENTRY ValueEntries,
	_In_ ULONG EntryCount,
	_Out_writes_bytes_(*BufferLength) PVOID ValueBuffer,
	_Inout_ PULONG BufferLength,
	_Out_opt_ PULONG RequiredBufferLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtEnumerateKey(
	_In_ HANDLE KeyHandle,
	_In_ ULONG Index,
	_In_ KEY_INFORMATION_CLASS KeyInformationClass,
	_Out_writes_bytes_to_opt_(Length, *ResultLength) PVOID KeyInformation,
	_In_ ULONG Length,
	_Out_ PULONG ResultLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtEnumerateValueKey(
	_In_ HANDLE KeyHandle,
	_In_ ULONG Index,
	_In_ KEY_VALUE_INFORMATION_CLASS KeyValueInformationClass,
	_Out_writes_bytes_to_opt_(Length, *ResultLength) PVOID KeyValueInformation,
	_In_ ULONG Length,
	_Out_ PULONG ResultLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtFlushKey(
	_In_ HANDLE KeyHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCompactKeys(
	_In_ ULONG Count,
	_In_ PHANDLE KeyArray
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCompressKey(
	_In_ HANDLE Key
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtLoadKey(
	_In_ POBJECT_ATTRIBUTES TargetKey,
	_In_ POBJECT_ATTRIBUTES SourceFile
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtLoadKey2(
	_In_ POBJECT_ATTRIBUTES TargetKey,
	_In_ POBJECT_ATTRIBUTES SourceFile,
	_In_ ULONG Flags
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSCALLAPI
NTSTATUS
NTAPI
NtLoadKeyEx(
	_In_ POBJECT_ATTRIBUTES TargetKey,
	_In_ POBJECT_ATTRIBUTES SourceFile,
	_In_ ULONG Flags,
	_In_opt_ HANDLE TrustClassKey,
	_In_opt_ HANDLE Event,
	_In_opt_ ACCESS_MASK DesiredAccess,
	_Out_opt_ PHANDLE RootHandle,
	_Out_opt_ PIO_STATUS_BLOCK IoStatus
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtReplaceKey(
	_In_ POBJECT_ATTRIBUTES NewFile,
	_In_ HANDLE TargetHandle,
	_In_ POBJECT_ATTRIBUTES OldFile
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSaveKey(
	_In_ HANDLE KeyHandle,
	_In_ HANDLE FileHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSaveKeyEx(
	_In_ HANDLE KeyHandle,
	_In_ HANDLE FileHandle,
	_In_ ULONG Format
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSaveMergedKeys(
	_In_ HANDLE HighPrecedenceKeyHandle,
	_In_ HANDLE LowPrecedenceKeyHandle,
	_In_ HANDLE FileHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRestoreKey(
	_In_ HANDLE KeyHandle,
	_In_opt_ HANDLE FileHandle,
	_In_ ULONG Flags
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtUnloadKey(
	_In_ POBJECT_ATTRIBUTES TargetKey
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSCALLAPI
NTSTATUS
NTAPI
NtUnloadKey2(
	_In_ POBJECT_ATTRIBUTES TargetKey,
	_In_ ULONG Flags
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtUnloadKeyEx(
	_In_ POBJECT_ATTRIBUTES TargetKey,
	_In_opt_ HANDLE Event
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtNotifyChangeKey(
	_In_ HANDLE KeyHandle,
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ ULONG CompletionFilter,
	_In_ BOOLEAN WatchTree,
	_Out_writes_bytes_opt_(BufferSize) PVOID Buffer,
	_In_ ULONG BufferSize,
	_In_ BOOLEAN Asynchronous
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtNotifyChangeMultipleKeys(
	_In_ HANDLE MasterKeyHandle,
	_In_opt_ ULONG Count,
	_In_reads_opt_(Count) OBJECT_ATTRIBUTES SubordinateObjects[],
	_In_opt_ HANDLE Event,
	_In_opt_ PIO_APC_ROUTINE ApcRoutine,
	_In_opt_ PVOID ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_ ULONG CompletionFilter,
	_In_ BOOLEAN WatchTree,
	_Out_writes_bytes_opt_(BufferSize) PVOID Buffer,
	_In_ ULONG BufferSize,
	_In_ BOOLEAN Asynchronous
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryOpenSubKeys(
	_In_ POBJECT_ATTRIBUTES TargetKey,
	_Out_ PULONG HandleCount
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryOpenSubKeysEx(
	_In_ POBJECT_ATTRIBUTES TargetKey,
	_In_ ULONG BufferLength,
	_Out_writes_bytes_(BufferLength) PVOID Buffer,
	_Out_ PULONG RequiredSize
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtInitializeRegistry(
	_In_ USHORT BootCondition
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtLockRegistryKey(
	_In_ HANDLE KeyHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtLockProductActivationKeys(
	_Inout_opt_ ULONG *pPrivateVer,
	_Out_opt_ ULONG *pSafeMode
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtFreezeRegistry(
	_In_ ULONG TimeOutInSeconds
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtThawRegistry(
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDelayExecution(
	_In_ BOOLEAN Alertable,
	_In_ PLARGE_INTEGER DelayInterval
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCallbackReturn(
	_In_reads_bytes_opt_(OutputLength) PVOID OutputBuffer,
	_In_ ULONG OutputLength,
	_In_ NTSTATUS Status
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
VOID
NTAPI
NtFlushProcessWriteBuffers(
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryDebugFilterState(
	_In_ ULONG ComponentId,
	_In_ ULONG Level
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetDebugFilterState(
	_In_ ULONG ComponentId,
	_In_ ULONG Level,
	_In_ BOOLEAN State
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRemoveProcessDebug(
	_In_ HANDLE ProcessHandle,
	_In_ HANDLE DebugObjectHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtWaitForDebugEvent(
	_In_ HANDLE DebugObjectHandle,
	_In_ BOOLEAN Alertable,
	_In_opt_ PLARGE_INTEGER Timeout,
	_Out_ PDBGUI_WAIT_STATE_CHANGE WaitStateChange
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDebugContinue(
	_In_ HANDLE DebugObjectHandle,
	_In_ PCLIENT_ID ClientId,
	_In_ NTSTATUS ContinueStatus
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationDebugObject(
	_In_ HANDLE DebugObjectHandle,
	_In_ DEBUGOBJECTINFOCLASS DebugObjectInformationClass,
	_In_ PVOID DebugInformation,
	_In_ ULONG DebugInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenProcessToken(
	_In_ HANDLE ProcessHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_Out_ PHANDLE TokenHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenProcessTokenEx(
	_In_ HANDLE ProcessHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ ULONG HandleAttributes,
	_Out_ PHANDLE TokenHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenThreadToken(
	_In_ HANDLE ThreadHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ BOOLEAN OpenAsSelf,
	_Out_ PHANDLE TokenHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenThreadTokenEx(
	_In_ HANDLE ThreadHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ BOOLEAN OpenAsSelf,
	_In_ ULONG HandleAttributes,
	_Out_ PHANDLE TokenHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateToken(
	_Out_ PHANDLE TokenHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ TOKEN_TYPE TokenType,
	_In_ PLUID AuthenticationId,
	_In_ PLARGE_INTEGER ExpirationTime,
	_In_ PTOKEN_USER User,
	_In_ PTOKEN_GROUPS Groups,
	_In_ PTOKEN_PRIVILEGES Privileges,
	_In_opt_ PTOKEN_OWNER Owner,
	_In_ PTOKEN_PRIMARY_GROUP PrimaryGroup,
	_In_opt_ PTOKEN_DEFAULT_DACL DefaultDacl,
	_In_ PTOKEN_SOURCE TokenSource
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDuplicateToken(
	_In_ HANDLE ExistingTokenHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ BOOLEAN EffectiveOnly,
	_In_ TOKEN_TYPE TokenType,
	_Out_ PHANDLE NewTokenHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAdjustPrivilegesToken(
	_In_ HANDLE TokenHandle,
	_In_ BOOLEAN DisableAllPrivileges,
	_In_opt_ PTOKEN_PRIVILEGES NewState,
	_In_ ULONG BufferLength,
	_Out_opt_ PTOKEN_PRIVILEGES PreviousState,
	_Out_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAdjustGroupsToken(
	_In_ HANDLE TokenHandle,
	_In_ BOOLEAN ResetToDefault,
	_In_opt_ PTOKEN_GROUPS NewState,
	_In_opt_ ULONG BufferLength,
	_Out_ PTOKEN_GROUPS PreviousState,
	_Out_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtFilterToken(
	_In_ HANDLE ExistingTokenHandle,
	_In_ ULONG Flags,
	_In_opt_ PTOKEN_GROUPS SidsToDisable,
	_In_opt_ PTOKEN_PRIVILEGES PrivilegesToDelete,
	_In_opt_ PTOKEN_GROUPS RestrictedSids,
	_Out_ PHANDLE NewTokenHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationToken(
	_In_ HANDLE TokenHandle,
	_In_ TOKEN_INFORMATION_CLASS TokenInformationClass,
	_In_ PVOID TokenInformation,
	_In_ ULONG TokenInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCompareTokens(
	_In_ HANDLE FirstTokenHandle,
	_In_ HANDLE SecondTokenHandle,
	_Out_ PBOOLEAN Equal
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtPrivilegeCheck(
	_In_ HANDLE ClientToken,
	_Inout_ PPRIVILEGE_SET RequiredPrivileges,
	_Out_ PBOOLEAN Result
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtImpersonateAnonymousToken(
	_In_ HANDLE ThreadHandle
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSCALLAPI
NTSTATUS
NTAPI
NtQuerySecurityAttributesToken(
	_In_ HANDLE TokenHandle,
	_In_reads_opt_(NumberOfAttributes) PUNICODE_STRING Attributes,
	_In_ ULONG NumberOfAttributes,
	_Out_ PTOKEN_SECURITY_ATTRIBUTES_INFORMATION Buffer,
	_In_ ULONG Length,
	_Out_ PULONG ReturnLength
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAccessCheck(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_In_ HANDLE ClientToken,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ PGENERIC_MAPPING GenericMapping,
	_Out_ PPRIVILEGE_SET PrivilegeSet,
	_Inout_ PULONG PrivilegeSetLength,
	_Out_ PACCESS_MASK GrantedAccess,
	_Out_ PNTSTATUS AccessStatus
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAccessCheckByType(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_In_opt_ PSID PrincipalSelfSid,
	_In_ HANDLE ClientToken,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_TYPE_LIST ObjectTypeList,
	_In_ ULONG ObjectTypeListLength,
	_In_ PGENERIC_MAPPING GenericMapping,
	_Out_ PPRIVILEGE_SET PrivilegeSet,
	_Inout_ PULONG PrivilegeSetLength,
	_Out_ PACCESS_MASK GrantedAccess,
	_Out_ PNTSTATUS AccessStatus
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAccessCheckByTypeResultList(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_In_opt_ PSID PrincipalSelfSid,
	_In_ HANDLE ClientToken,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_TYPE_LIST ObjectTypeList,
	_In_ ULONG ObjectTypeListLength,
	_In_ PGENERIC_MAPPING GenericMapping,
	_Out_ PPRIVILEGE_SET PrivilegeSet,
	_Inout_ PULONG PrivilegeSetLength,
	_Out_ PACCESS_MASK GrantedAccess,
	_Out_ PNTSTATUS AccessStatus
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateIoCompletion(
	_Out_ PHANDLE IoCompletionHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_opt_ ULONG Count
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenIoCompletion(
	_Out_ PHANDLE IoCompletionHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryIoCompletion(
	_In_ HANDLE IoCompletionHandle,
	_In_ IO_COMPLETION_INFORMATION_CLASS IoCompletionInformationClass,
	_Out_writes_bytes_(IoCompletionInformationLength) PVOID IoCompletionInformation,
	_In_ ULONG IoCompletionInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetIoCompletion(
	_In_ HANDLE IoCompletionHandle,
	_In_opt_ PVOID KeyContext,
	_In_opt_ PVOID ApcContext,
	_In_ NTSTATUS IoStatus,
	_In_ ULONG_PTR IoStatusInformation
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetIoCompletionEx(
	_In_ HANDLE IoCompletionHandle,
	_In_ HANDLE IoCompletionPacketHandle,
	_In_opt_ PVOID KeyContext,
	_In_opt_ PVOID ApcContext,
	_In_ NTSTATUS IoStatus,
	_In_ ULONG_PTR IoStatusInformation
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRemoveIoCompletion(
	_In_ HANDLE IoCompletionHandle,
	_Out_ PVOID *KeyContext,
	_Out_ PVOID *ApcContext,
	_Out_ PIO_STATUS_BLOCK IoStatusBlock,
	_In_opt_ PLARGE_INTEGER Timeout
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtRemoveIoCompletionEx(
	_In_ HANDLE IoCompletionHandle,
	_Out_writes_to_(Count, *NumEntriesRemoved) PFILE_IO_COMPLETION_INFORMATION IoCompletionInformation,
	_In_ ULONG Count,
	_Out_ PULONG NumEntriesRemoved,
	_In_opt_ PLARGE_INTEGER Timeout,
	_In_ BOOLEAN Alertable
	);
#endif

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSCALLAPI
NTSTATUS
NTAPI
NtNotifyChangeSession(
	_In_ HANDLE SessionHandle,
	_In_ ULONG ChangeSequenceNumber,
	_In_ PLARGE_INTEGER ChangeTimeStamp,
	_In_ IO_SESSION_EVENT Event,
	_In_ IO_SESSION_STATE NewState,
	_In_ IO_SESSION_STATE PreviousState,
	_In_reads_bytes_opt_(PayloadSize) PVOID Payload,
	_In_ ULONG PayloadSize
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateMutant(
	_Out_ PHANDLE MutantHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ BOOLEAN InitialOwner
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenMutant(
	_Out_ PHANDLE MutantHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtReleaseMutant(
	_In_ HANDLE MutantHandle,
	_Out_opt_ PLONG PreviousCount
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAlertThread(
	_In_ HANDLE ThreadHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAlertResumeThread(
	_In_ HANDLE ThreadHandle,
	_Out_opt_ PULONG PreviousSuspendCount
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtTestAlert(
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtImpersonateThread(
	_In_ HANDLE ServerThreadHandle,
	_In_ HANDLE ClientThreadHandle,
	_In_ PSECURITY_QUALITY_OF_SERVICE SecurityQos
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateSemaphore(
	_Out_ PHANDLE SemaphoreHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ LONG InitialCount,
	_In_ LONG MaximumCount
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenSemaphore(
	_Out_ PHANDLE SemaphoreHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtReleaseSemaphore(
	_In_ HANDLE SemaphoreHandle,
	_In_ LONG ReleaseCount,
	_Out_opt_ PLONG PreviousCount
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQuerySemaphore(
	_In_ HANDLE SemaphoreHandle,
	_In_ SEMAPHORE_INFORMATION_CLASS SemaphoreInformationClass,
	_Out_writes_bytes_(SemaphoreInformationLength) PVOID SemaphoreInformation,
	_In_ ULONG SemaphoreInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateTimer(
	_Out_ PHANDLE TimerHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ TIMER_TYPE TimerType
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenTimer(
	_Out_ PHANDLE TimerHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetTimer(
	_In_ HANDLE TimerHandle,
	_In_ PLARGE_INTEGER DueTime,
	_In_opt_ PTIMER_APC_ROUTINE TimerApcRoutine,
	_In_opt_ PVOID TimerContext,
	_In_ BOOLEAN ResumeTimer,
	_In_opt_ LONG Period,
	_Out_opt_ PBOOLEAN PreviousState
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetTimerEx(
	_In_ HANDLE TimerHandle,
	_In_ TIMER_SET_INFORMATION_CLASS TimerSetInformationClass,
	_Inout_updates_bytes_opt_(TimerSetInformationLength) PVOID TimerSetInformation,
	_In_ ULONG TimerSetInformationLength
	);
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCancelTimer(
	_In_ HANDLE TimerHandle,
	_Out_opt_ PBOOLEAN CurrentState
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryTimer(
	_In_ HANDLE TimerHandle,
	_In_ TIMER_INFORMATION_CLASS TimerInformationClass,
	_Out_ PVOID TimerInformation,
	_In_ ULONG TimerInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateKeyedEvent(
	_Out_ PHANDLE KeyedEventHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ ULONG Flags
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenKeyedEvent(
	_Out_ PHANDLE KeyedEventHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtReleaseKeyedEvent(
	_In_ HANDLE KeyedEventHandle,
	_In_ PVOID KeyValue,
	_In_ BOOLEAN Alertable,
	_In_opt_ PLARGE_INTEGER Timeout
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtWaitForKeyedEvent(
	_In_ HANDLE KeyedEventHandle,
	_In_ PVOID KeyValue,
	_In_ BOOLEAN Alertable,
	_In_opt_ PLARGE_INTEGER Timeout
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSCALLAPI
NTSTATUS
NTAPI
NtUmsThreadYield(
	_In_ PVOID SchedulerParam
	);
#endif

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateTransactionManager(
	_Out_ PHANDLE TmHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_opt_ PUNICODE_STRING LogFileName,
	_In_opt_ ULONG CreateOptions,
	_In_opt_ ULONG CommitStrength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenTransactionManager(
	_Out_ PHANDLE TmHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_opt_ PUNICODE_STRING LogFileName,
	_In_opt_ LPGUID TmIdentity,
	_In_opt_ ULONG OpenOptions
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRenameTransactionManager(
	_In_ PUNICODE_STRING LogFileName,
	_In_ LPGUID ExistingTransactionManagerGuid
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRollforwardTransactionManager(
	_In_ HANDLE TransactionManagerHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRecoverTransactionManager(
	_In_ HANDLE TransactionManagerHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryInformationTransactionManager(
	_In_ HANDLE TransactionManagerHandle,
	_In_ TRANSACTIONMANAGER_INFORMATION_CLASS TransactionManagerInformationClass,
	_Out_writes_bytes_(TransactionManagerInformationLength) PVOID TransactionManagerInformation,
	_In_ ULONG TransactionManagerInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationTransactionManager(
	_In_ HANDLE TmHandle,
	_In_ TRANSACTIONMANAGER_INFORMATION_CLASS TransactionManagerInformationClass,
	_In_ PVOID TransactionManagerInformation,
	_In_ ULONG TransactionManagerInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtEnumerateTransactionObject(
	_In_opt_ HANDLE RootObjectHandle,
	_In_ KTMOBJECT_TYPE QueryType,
	_Inout_updates_bytes_(ObjectCursorLength) PKTMOBJECT_CURSOR ObjectCursor,
	_In_ ULONG ObjectCursorLength,
	_Out_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateTransaction(
	_Out_ PHANDLE TransactionHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_opt_ LPGUID Uow,
	_In_opt_ HANDLE TmHandle,
	_In_opt_ ULONG CreateOptions,
	_In_opt_ ULONG IsolationLevel,
	_In_opt_ ULONG IsolationFlags,
	_In_opt_ PLARGE_INTEGER Timeout,
	_In_opt_ PUNICODE_STRING Description
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenTransaction(
	_Out_ PHANDLE TransactionHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ LPGUID Uow,
	_In_opt_ HANDLE TmHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryInformationTransaction(
	_In_ HANDLE TransactionHandle,
	_In_ TRANSACTION_INFORMATION_CLASS TransactionInformationClass,
	_Out_writes_bytes_(TransactionInformationLength) PVOID TransactionInformation,
	_In_ ULONG TransactionInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationTransaction(
	_In_ HANDLE TransactionHandle,
	_In_ TRANSACTION_INFORMATION_CLASS TransactionInformationClass,
	_In_ PVOID TransactionInformation,
	_In_ ULONG TransactionInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCommitTransaction(
	_In_ HANDLE TransactionHandle,
	_In_ BOOLEAN Wait
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRollbackTransaction(
	_In_ HANDLE TransactionHandle,
	_In_ BOOLEAN Wait
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateEnlistment(
	_Out_ PHANDLE EnlistmentHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ HANDLE ResourceManagerHandle,
	_In_ HANDLE TransactionHandle,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_opt_ ULONG CreateOptions,
	_In_ NOTIFICATION_MASK NotificationMask,
	_In_opt_ PVOID EnlistmentKey
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenEnlistment(
	_Out_ PHANDLE EnlistmentHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ HANDLE ResourceManagerHandle,
	_In_ LPGUID EnlistmentGuid,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryInformationEnlistment(
	_In_ HANDLE EnlistmentHandle,
	_In_ ENLISTMENT_INFORMATION_CLASS EnlistmentInformationClass,
	_Out_writes_bytes_(EnlistmentInformationLength) PVOID EnlistmentInformation,
	_In_ ULONG EnlistmentInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationEnlistment(
	_In_opt_ HANDLE EnlistmentHandle,
	_In_ ENLISTMENT_INFORMATION_CLASS EnlistmentInformationClass,
	_In_reads_bytes_(EnlistmentInformationLength) PVOID EnlistmentInformation,
	_In_ ULONG EnlistmentInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRecoverEnlistment(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PVOID EnlistmentKey
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtPrePrepareEnlistment(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtPrepareEnlistment(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCommitEnlistment(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRollbackEnlistment(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtPrePrepareComplete(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtPrepareComplete(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCommitComplete(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtReadOnlyEnlistment(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRollbackComplete(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSinglePhaseReject(
	_In_ HANDLE EnlistmentHandle,
	_In_opt_ PLARGE_INTEGER TmVirtualClock
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateResourceManager(
	_Out_ PHANDLE ResourceManagerHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ HANDLE TmHandle,
	_In_opt_ LPGUID ResourceManagerGuid,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_opt_ ULONG CreateOptions,
	_In_opt_ PUNICODE_STRING Description
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtOpenResourceManager(
	_Out_ PHANDLE ResourceManagerHandle,
	_In_ ACCESS_MASK DesiredAccess,
	_In_ HANDLE TmHandle,
	_In_ LPGUID ResourceManagerGuid,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRecoverResourceManager(
	_In_ HANDLE ResourceManagerHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtGetNotificationResourceManager(
	_In_ HANDLE ResourceManagerHandle,
	_Out_ PTRANSACTION_NOTIFICATION TransactionNotification,
	_In_ ULONG NotificationLength,
	_In_ PLARGE_INTEGER Timeout,
	_Out_opt_ PULONG ReturnLength,
	_In_ ULONG Asynchronous,
	_In_opt_ ULONG_PTR AsynchronousContext
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryInformationResourceManager(
	_In_ HANDLE ResourceManagerHandle,
	_In_ RESOURCEMANAGER_INFORMATION_CLASS ResourceManagerInformationClass,
	_Out_writes_bytes_(ResourceManagerInformationLength) PVOID ResourceManagerInformation,
	_In_ ULONG ResourceManagerInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationResourceManager(
	_In_ HANDLE ResourceManagerHandle,
	_In_ RESOURCEMANAGER_INFORMATION_CLASS ResourceManagerInformationClass,
	_In_ PVOID ResourceManagerInformation,
	_In_ ULONG ResourceManagerInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtRegisterProtocolAddressInformation(
	_In_ HANDLE ResourceManager,
	_In_ PCRM_PROTOCOL_ID ProtocolId,
	_In_ ULONG ProtocolInformationSize,
	_In_ PVOID ProtocolInformation,
	_In_opt_ ULONG CreateOptions
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtPropagationComplete(
	_In_ HANDLE ResourceManagerHandle,
	_In_ ULONG RequestCookie,
	_In_ ULONG BufferLength,
	_In_ PVOID Buffer
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtPropagationFailed(
	_In_ HANDLE ResourceManagerHandle,
	_In_ ULONG RequestCookie,
	_In_ NTSTATUS PropStatus
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtFreezeTransactions(
	_In_ PLARGE_INTEGER FreezeTimeout,
	_In_ PLARGE_INTEGER ThawTimeout
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtThawTransactions(
	);
#endif

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSCALLAPI
NTSTATUS
NTAPI
NtCreateWorkerFactory(
	_Out_ PHANDLE WorkerFactoryHandleReturn,
	_In_ ACCESS_MASK DesiredAccess,
	_In_opt_ POBJECT_ATTRIBUTES ObjectAttributes,
	_In_ HANDLE CompletionPortHandle,
	_In_ HANDLE WorkerProcessHandle,
	_In_ PUSER_THREAD_START_ROUTINE StartRoutine,
	_In_opt_ PVOID StartParameter,
	_In_opt_ ULONG MaxThreadCount,
	_In_opt_ SIZE_T StackReserve,
	_In_opt_ SIZE_T StackCommit
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryInformationWorkerFactory(
	_In_ HANDLE WorkerFactoryHandle,
	_In_ WORKERFACTORYINFOCLASS WorkerFactoryInformationClass,
	_Out_ PVOID WorkerFactoryInformation,
	_In_ ULONG WorkerFactoryInformationLength,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetInformationWorkerFactory(
	_In_ HANDLE WorkerFactoryHandle,
	_In_ WORKERFACTORYINFOCLASS WorkerFactoryInformationClass,
	_In_ PVOID WorkerFactoryInformation,
	_In_ ULONG WorkerFactoryInformationLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtShutdownWorkerFactory(
	_In_ HANDLE WorkerFactoryHandle,
	_Inout_ volatile LONG *PendingWorkerCount
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtReleaseWorkerFactoryWorker(
	_In_ HANDLE WorkerFactoryHandle
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtWorkerFactoryWorkerReady(
	_In_ HANDLE WorkerFactoryHandle
	);

#if NTDDI_VERSION >= NTDDI_WIN8 || defined(_WIN64)
// Windows 8+ declaration, but can be used on any x64 Windows Vista+
NTSYSCALLAPI
NTSTATUS
NTAPI
NtWaitForWorkViaWorkerFactory(
	_In_ HANDLE WorkerFactoryHandle,
	_Out_writes_to_(Count, *PacketsReturned) PFILE_IO_COMPLETION_INFORMATION MiniPackets,
	_In_ ULONG Count,
	_Out_ PULONG PacketsReturned,
	_In_ PWORKER_FACTORY_DEFERRED_WORK DeferredWork
	);
#else
// Windows Vista/7 x86
NTSYSCALLAPI
NTSTATUS
NTAPI
NtWaitForWorkViaWorkerFactory(
	_In_ HANDLE WorkerFactoryHandle,
	_Out_ PFILE_IO_COMPLETION_INFORMATION MiniPacket
	);
#endif
#endif

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQuerySystemEnvironmentValue(
	_In_ PUNICODE_STRING VariableName,
	_Out_writes_bytes_(ValueLength) PWSTR VariableValue,
	_In_ USHORT ValueLength,
	_Out_opt_ PUSHORT ReturnLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetSystemEnvironmentValue(
	_In_ PUNICODE_STRING VariableName,
	_In_ PUNICODE_STRING VariableValue
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQuerySystemEnvironmentValueEx(
	_In_ PUNICODE_STRING VariableName,
	_In_ LPGUID VendorGuid,
	_Out_writes_bytes_opt_(*ValueLength) PVOID Value,
	_Inout_ PULONG ValueLength,
	_Out_opt_ PULONG Attributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetSystemEnvironmentValueEx(
	_In_ PUNICODE_STRING VariableName,
	_In_ LPGUID VendorGuid,
	_In_reads_bytes_opt_(ValueLength) PVOID Value,
	_In_ ULONG ValueLength,
	_In_ ULONG Attributes
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtEnumerateSystemEnvironmentValuesEx(
	_In_ ULONG InformationClass,
	_Out_ PVOID Buffer,
	_Inout_ PULONG BufferLength
	);

#if NTDDI_VERSION >= NTDDI_VISTA

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAddBootEntry(
	_In_ PBOOT_ENTRY BootEntry,
	_Out_opt_ PULONG Id
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDeleteBootEntry(
	_In_ ULONG Id
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtModifyBootEntry(
	_In_ PBOOT_ENTRY BootEntry
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtEnumerateBootEntries(
	_Out_writes_bytes_opt_(*BufferLength) PVOID Buffer,
	_Inout_ PULONG BufferLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryBootEntryOrder(
	_Out_writes_opt_(*Count) PULONG Ids,
	_Inout_ PULONG Count
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetBootEntryOrder(
	_In_reads_(Count) PULONG Ids,
	_In_ ULONG Count
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryBootOptions(
	_Out_writes_bytes_opt_(*BootOptionsLength) PBOOT_OPTIONS BootOptions,
	_Inout_ PULONG BootOptionsLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetBootOptions(
	_In_ PBOOT_OPTIONS BootOptions,
	_In_ ULONG FieldsToChange
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtTranslateFilePath(
	_In_ PFILE_PATH InputFilePath,
	_In_ ULONG OutputType,
	_Out_writes_bytes_opt_(*OutputFilePathLength) PFILE_PATH OutputFilePath,
	_Inout_opt_ PULONG OutputFilePathLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtAddDriverEntry(
	_In_ PEFI_DRIVER_ENTRY DriverEntry,
	_Out_opt_ PULONG Id
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDeleteDriverEntry(
	_In_ ULONG Id
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtModifyDriverEntry(
	_In_ PEFI_DRIVER_ENTRY DriverEntry
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtEnumerateDriverEntries(
	_Out_writes_bytes_opt_(*BufferLength) PVOID Buffer,
	_Inout_ PULONG BufferLength
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtQueryDriverEntryOrder(
	_Out_writes_opt_(*Count) PULONG Ids,
	_Inout_ PULONG Count
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSetDriverEntryOrder(
	_In_reads_(Count) PULONG Ids,
	_In_ ULONG Count
	);

#endif

#if NTDDI_VERSION >= NTDDI_WIN7

NTSYSCALLAPI
NTSTATUS
NTAPI
NtSerializeBoot(
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtEnableLastKnownGood(
	);

NTSYSCALLAPI
NTSTATUS
NTAPI
NtDisableLastKnownGood(
	);

#endif

NTSYSAPI
ULONG
__cdecl
DbgPrint(
	_In_ PCH Format,
	...
	);

NTSYSAPI
ULONG
__cdecl
DbgPrintEx(
	_In_ ULONG ComponentId,
	_In_ ULONG Level,
	_In_ PCSTR Format,
	...
	);

NTSYSAPI
VOID
NTAPI
DbgBreakPoint(
	);

NTSYSAPI
NTSTATUS
NTAPI
DbgUiConnectToDbg(
	);

NTSYSAPI
HANDLE
NTAPI
DbgUiGetThreadDebugObject(
	);

NTSYSAPI
VOID
NTAPI
DbgUiSetThreadDebugObject(
	_In_ HANDLE DebugObject
	);

NTSYSAPI
NTSTATUS
NTAPI
DbgUiWaitStateChange(
	_Out_ PDBGUI_WAIT_STATE_CHANGE StateChange,
	_In_opt_ PLARGE_INTEGER Timeout
	);

NTSYSAPI
NTSTATUS
NTAPI
DbgUiContinue(
	_In_ PCLIENT_ID AppClientId,
	_In_ NTSTATUS ContinueStatus
	);

NTSYSAPI
NTSTATUS
NTAPI
DbgUiStopDebugging(
	_In_ HANDLE Process
	);

NTSYSAPI
NTSTATUS
NTAPI
DbgUiDebugActiveProcess(
	_In_ HANDLE Process
	);

NTSYSAPI
VOID
NTAPI
DbgUiRemoteBreakin(
	_In_ PVOID Context
	);

NTSYSAPI
NTSTATUS
NTAPI
DbgUiIssueRemoteBreakin(
	_In_ HANDLE Process
	);

NTSYSAPI
NTSTATUS
NTAPI
DbgUiConvertStateChangeStructure(
	_In_ PDBGUI_WAIT_STATE_CHANGE StateChange,
	_Out_ DEBUG_EVENT *DebugEvent
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrLoadDll(
	_In_opt_ PCWSTR DllPath,
	_In_opt_ PULONG DllCharacteristics,
	_In_ PUNICODE_STRING DllName,
	_Out_ PVOID *DllHandle
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrGetDllHandle(
	_In_opt_ PCWSTR DllPath,
	_In_opt_ PULONG DllCharacteristics,
	_In_ PUNICODE_STRING DllName,
	_Out_ PVOID *DllHandle
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrGetDllHandleEx(
	_In_ ULONG Flags,
	_In_opt_ PCWSTR DllPath,
	_In_opt_ PULONG DllCharacteristics,
	_In_ PUNICODE_STRING DllName,
	_Out_opt_ PVOID *DllHandle
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSAPI
NTSTATUS
NTAPI
LdrGetDllHandleByMapping(
	_In_ PVOID Base,
	_Out_ PVOID *DllHandle
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrGetDllHandleByName(
	_In_opt_ PUNICODE_STRING BaseDllName,
	_In_opt_ PUNICODE_STRING FullDllName,
	_Out_ PVOID *DllHandle
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
LdrGetProcedureAddress(
	_In_ PVOID DllHandle,
	_In_opt_ CONST PANSI_STRING ProcedureName,
	_In_opt_ ULONG ProcedureNumber,
	_Out_ PVOID *ProcedureAddress
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
NTSTATUS
NTAPI
LdrGetProcedureAddressEx(
	_In_ PVOID DllHandle,
	_In_opt_ PANSI_STRING ProcedureName,
	_In_opt_ ULONG ProcedureNumber,
	_Out_ PVOID *ProcedureAddress,
	_In_ ULONG Flags
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
LdrLockLoaderLock(
	_In_ ULONG Flags,
	_Out_opt_ ULONG *Disposition,
	_Out_ PVOID *Cookie
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrUnlockLoaderLock(
	_In_ ULONG Flags,
	_Inout_ PVOID Cookie
	);

NTSYSAPI
PIMAGE_BASE_RELOCATION
NTAPI
LdrProcessRelocationBlock(
	_In_ ULONG_PTR VA,
	_In_ ULONG SizeOfBlock,
	_In_ PUSHORT NextOffset,
	_In_ LONG_PTR Diff
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrUnloadDll(
	_In_ PVOID DllHandle
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrDisableThreadCalloutsForDll(
	_In_ PVOID DllHandle
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSAPI
NTSTATUS
NTAPI
LdrOpenImageFileOptionsKey(
	_In_ PUNICODE_STRING SubKey,
	_In_ BOOLEAN Wow64,
	_Out_ PHANDLE NewKeyHandle
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrQueryImageFileKeyOption(
	_In_ HANDLE KeyHandle,
	_In_ PCWSTR ValueName,
	_In_ ULONG Type,
	_Out_ PVOID Buffer,
	_In_ ULONG BufferSize,
	_Out_opt_ PULONG ReturnedLength
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
LdrVerifyImageMatchesChecksum(
	_In_ HANDLE ImageFileHandle,
	_In_opt_ PLDR_IMPORT_MODULE_CALLBACK ImportCallbackRoutine,
	_In_ PVOID ImportCallbackParameter,
	_Out_opt_ PUSHORT ImageCharacteristics
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
NTSTATUS
NTAPI
LdrVerifyImageMatchesChecksumEx(
	_In_ HANDLE ImageFileHandle,
	_Inout_ PLDR_VERIFY_IMAGE_INFO VerifyInfo
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
LdrAccessResource(
	_In_ PVOID DllHandle,
	_In_ CONST PIMAGE_RESOURCE_DATA_ENTRY ResourceDataEntry,
	_Out_opt_ PVOID *Address,
	_Out_ PULONG Size
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrFindResourceDirectory_U(
	_In_ PVOID DllHandle,
	_In_ CONST LDR_RESOURCE_INFO* ResourceIdPath,
	_In_ ULONG ResourceIdPathLength,
	_Out_ PIMAGE_RESOURCE_DIRECTORY *ResourceDirectory
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrFindResource_U(
	_In_ PVOID DllHandle,
	_In_ CONST LDR_RESOURCE_INFO* ResourceIdPath,
	_In_ ULONG ResourceIdPathLength,
	_Out_ PIMAGE_RESOURCE_DATA_ENTRY *ResourceDataEntry
	);

NTSYSAPI
NTSTATUS
NTAPI
LdrFindResourceEx_U(
	_In_opt_ ULONG Flags,
	_In_ PVOID DllHandle,
	_In_ CONST LDR_RESOURCE_INFO* ResourceIdPath,
	_In_ ULONG ResourceIdPathLength,
	_Out_ PIMAGE_RESOURCE_DATA_ENTRY *ResourceDataEntry
	);

NTSYSAPI
VOID
NTAPI
RtlAssert(
	_In_ PVOID VoidFailedAssertion,
	_In_ PVOID VoidFileName,
	_In_ ULONG LineNumber,
	_In_opt_ PSTR MutableMessage
	);

NTSYSAPI
DECLSPEC_NORETURN
VOID
NTAPI
RtlRaiseStatus(
	_In_ NTSTATUS Status
	);

NTSYSAPI
VOID
NTAPI
RtlRaiseException(
	_In_ PEXCEPTION_RECORD ExceptionRecord
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
NTSTATUS
NTAPI
RtlConnectToSm(
	_In_ PUNICODE_STRING ApiPortName,
	_In_ HANDLE ApiPortHandle,
	_In_ DWORD ProcessImageType,
	_Out_ PHANDLE SmssConnection
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSendMsgToSm(
	_In_ HANDLE ApiPortHandle,
	_In_ PPORT_MESSAGE MessageData
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlRegisterThreadWithCsrss(
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlEnterCriticalSection(
	_Inout_ PRTL_CRITICAL_SECTION CriticalSection
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlLeaveCriticalSection(
	_Inout_ PRTL_CRITICAL_SECTION CriticalSection
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSAPI
LOGICAL
NTAPI
RtlIsCriticalSectionLocked(
	_In_ PRTL_CRITICAL_SECTION CriticalSection
	);

NTSYSAPI
LOGICAL
NTAPI
RtlIsCriticalSectionLockedByThread(
	_In_ PRTL_CRITICAL_SECTION CriticalSection
	);

NTSYSAPI
ULONG
NTAPI
RtlGetCriticalSectionRecursionCount(
	_In_ PRTL_CRITICAL_SECTION CriticalSection
	);
#endif

NTSYSAPI
LOGICAL
NTAPI
RtlTryEnterCriticalSection(
	_Inout_ PRTL_CRITICAL_SECTION CriticalSection
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlInitializeCriticalSection(
	_Out_ PRTL_CRITICAL_SECTION CriticalSection
	);

NTSYSAPI
VOID
NTAPI
RtlEnableEarlyCriticalSectionEventCreation(
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlInitializeCriticalSectionAndSpinCount(
	_Out_ PRTL_CRITICAL_SECTION CriticalSection,
	_In_ ULONG SpinCount
	);

NTSYSAPI
ULONG
NTAPI
RtlSetCriticalSectionSpinCount(
	_Inout_ PRTL_CRITICAL_SECTION CriticalSection,
	_In_ ULONG SpinCount
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlDeleteCriticalSection(
	_Inout_ PRTL_CRITICAL_SECTION CriticalSection
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSAPI
BOOL
NTAPI
RtlQueryPerformanceFrequency(
	_Out_ PLARGE_INTEGER Frequency
	);
#else
FORCEINLINE
BOOL
NTAPI
RtlQueryPerformanceFrequency(
	_Out_ PLARGE_INTEGER Frequency
	)
{
	LARGE_INTEGER _;
	return NT_SUCCESS(NtQueryPerformanceCounter(&_,
												Frequency));
}
#endif

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSAPI
BOOL
NTAPI
RtlQueryPerformanceCounter(
	_Out_ PLARGE_INTEGER PerformanceCount
	);
#else
FORCEINLINE
BOOL
NTAPI
RtlQueryPerformanceCounter(
	_Out_ PLARGE_INTEGER PerformanceCount
	)
{
	return NT_SUCCESS(NtQueryPerformanceCounter(PerformanceCount,
												NULL));
}
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlGetCompressionWorkSpaceSize(
	_In_ USHORT CompressionFormatAndEngine,
	_Out_ PULONG CompressBufferWorkSpaceSize,
	_Out_ PULONG CompressFragmentWorkSpaceSize
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCompressBuffer(
	_In_ USHORT CompressionFormatAndEngine,
	_In_ PUCHAR UncompressedBuffer,
	_In_ ULONG UncompressedBufferSize,
	_Out_ PUCHAR CompressedBuffer,
	_In_ ULONG CompressedBufferSize,
	_In_ ULONG UncompressedChunkSize,
	_Out_ PULONG FinalCompressedSize,
	_In_ PVOID WorkSpace
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlDecompressBuffer(
	_In_ USHORT CompressionFormat,
	_Out_ PUCHAR UncompressedBuffer,
	_In_ ULONG UncompressedBufferSize,
	_In_ PUCHAR CompressedBuffer,
	_In_ ULONG CompressedBufferSize,
	_Out_ PULONG FinalUncompressedSize
	);

NTSYSAPI
PVOID
NTAPI
RtlCreateHeap(
	_In_ ULONG Flags,
	_In_opt_ PVOID HeapBase,
	_In_opt_ SIZE_T ReserveSize,
	_In_opt_ SIZE_T CommitSize,
	_In_opt_ PVOID Lock,
	_In_opt_ PRTL_HEAP_PARAMETERS Parameters
	);

NTSYSAPI
PVOID
NTAPI
RtlDestroyHeap(
	_Inout_ PVOID HeapHandle
	);

NTSYSAPI
PVOID
NTAPI
RtlAllocateHeap(
	_In_ PVOID HeapHandle,
	_In_opt_ ULONG Flags,
	_In_ SIZE_T Size
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlFreeHeap(
	_In_ PVOID HeapHandle,
	_In_opt_ ULONG Flags,
	_Inout_opt_ PVOID BaseAddress
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlWalkHeap(
	_In_ PVOID HeapHandle,
	_Inout_ PRTL_HEAP_WALK_ENTRY Entry
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlQueryHeapInformation(
	_In_ PVOID HeapHandle,
	_In_ HEAP_INFORMATION_CLASS HeapInformationClass,
	_Out_opt_ PVOID HeapInformation,
	_In_opt_ SIZE_T HeapInformationLength,
	_Out_opt_ PSIZE_T ReturnLength
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSetHeapInformation(
	_In_ PVOID HeapHandle,
	_In_ HEAP_INFORMATION_CLASS HeapInformationClass,
	_In_opt_ PVOID HeapInformation,
	_In_opt_ SIZE_T HeapInformationLength
	);

NTSYSAPI
SIZE_T
NTAPI
RtlSizeHeap(
	_In_ PVOID HeapHandle,
	_In_ ULONG Flags,
	_In_ PVOID BaseAddress
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlZeroHeap(
	_In_ PVOID HeapHandle,
	_In_ ULONG Flags
	);

NTSYSAPI
VOID
NTAPI
RtlProtectHeap(
	_In_ PVOID HeapHandle,
	_In_ BOOLEAN MakeReadOnly
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlLockHeap(
	_In_ PVOID HeapHandle
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlUnlockHeap(
	_In_ PVOID HeapHandle
	);

NTSYSAPI
PVOID
NTAPI
RtlReAllocateHeap(
	_In_ PVOID HeapHandle,
	_In_ ULONG Flags,
	_Inout_opt_ PVOID BaseAddress,
	_In_ SIZE_T Size
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlGetUserInfoHeap(
	_In_ PVOID HeapHandle,
	_In_ ULONG Flags,
	_In_ PVOID BaseAddress,
	_Out_opt_ PVOID *UserValue,
	_Out_opt_ PULONG UserFlags
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlSetUserValueHeap(
	_In_ PVOID HeapHandle,
	_In_ ULONG Flags,
	_In_ PVOID BaseAddress,
	_In_ PVOID UserValue
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlSetUserFlagsHeap(
	_In_ PVOID HeapHandle,
	_In_ ULONG Flags,
	_In_ PVOID BaseAddress,
	_In_ ULONG UserFlagsReset,
	_In_ ULONG UserFlagsSet
	);

NTSYSAPI
ULONG
NTAPI
RtlCreateTagHeap(
	_In_ PVOID HeapHandle,
	_In_ ULONG Flags,
	_In_opt_ PWSTR TagPrefix,
	_In_ PWSTR TagNames
	);

NTSYSAPI
PWSTR
NTAPI
RtlQueryTagHeap(
	_In_ PVOID HeapHandle,
	_In_ ULONG Flags,
	_In_ USHORT TagIndex,
	_In_ BOOLEAN ResetCounters,
	_Out_opt_ PRTL_HEAP_TAG_INFO TagInfo
	);

NTSYSAPI
SIZE_T
NTAPI
RtlCompactHeap(
	_In_ PVOID HeapHandle,
	_In_ ULONG Flags
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlValidateHeap(
	_In_ PVOID HeapHandle,
	_In_ ULONG Flags,
	_In_ PVOID BaseAddress
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlValidateProcessHeaps(
	);

NTSYSAPI
ULONG
NTAPI
RtlGetProcessHeaps(
	_In_ ULONG NumberOfHeaps,
	_Out_ PVOID *ProcessHeaps
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlEnumProcessHeaps(
	_In_ PRTL_ENUM_HEAPS_ROUTINE EnumRoutine,
	_In_ PVOID Parameter
	);

NTSYSAPI
VOID
NTAPI
RtlTimeToTimeFields(
	_In_ PLARGE_INTEGER Time,
	_Out_ PTIME_FIELDS TimeFields
	);

NTSYSAPI
ULONG
NTAPI
RtlUniform(
	_Inout_ PULONG Seed
	);

NTSYSAPI
ULONG
NTAPI
RtlRandom(
	_Inout_ PULONG Seed
	);

NTSYSAPI
ULONG
NTAPI
RtlRandomEx(
	_Inout_ PULONG Seed
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlFindMessage(
	_In_ PVOID DllHandle,
	_In_ ULONG MessageTableId,
	_In_ ULONG MessageLanguageId,
	_In_ ULONG MessageId,
	_Out_ PMESSAGE_RESOURCE_ENTRY *MessageEntry
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlFormatMessage(
	_In_ PCWSTR MessageFormat,
	_In_ ULONG MaximumWidth,
	_In_ BOOLEAN IgnoreInserts,
	_In_ BOOLEAN ArgumentsAreAnsi,
	_In_ BOOLEAN ArgumentsAreAnArray,
	_In_ va_list *Arguments,
	_Out_ PWSTR Buffer,
	_In_ ULONG Length,
	_Out_opt_ PULONG ReturnLength
	);

NTSYSAPI
ULONG
NTAPI
RtlNtStatusToDosError(
	_In_ NTSTATUS Status
	);

NTSYSAPI
ULONG
NTAPI
RtlNtStatusToDosErrorNoTeb(
	_In_ NTSTATUS Status
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlGetLastNtStatus(
	);

NTSYSAPI
LONG
NTAPI
RtlGetLastWin32Error(
	);

NTSYSAPI
VOID
NTAPI
RtlSetLastWin32ErrorAndNtStatusFromNtStatus(
	_In_ NTSTATUS Status
	);

NTSYSAPI
VOID
NTAPI
RtlSetLastWin32Error(
	_In_ LONG Win32Error
	);

NTSYSAPI
VOID
NTAPI
RtlRestoreLastWin32Error(
	_In_ LONG Win32Error
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSAPI
ULONG
NTAPI
RtlGetThreadErrorMode(
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSetThreadErrorMode(
	_In_ ULONG NewMode,
	_Out_opt_ PULONG OldMode
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlUpcaseUnicodeString(
	_Out_ PUNICODE_STRING DestinationString,
	_In_ PCUNICODE_STRING SourceString,
	_In_ BOOLEAN AllocateDestinationString
	);

NTSYSAPI
VOID
NTAPI
RtlInitUnicodeString(
	_Out_ PUNICODE_STRING DestinationString,
	_In_opt_ PWSTR SourceString
	);

NTSYSAPI
VOID
NTAPI
RtlInitAnsiString(
	_Out_ PANSI_STRING DestinationString,
	_In_opt_ PSTR SourceString
	);

NTSYSAPI
VOID
NTAPI
RtlCopyUnicodeString(
	_Out_ PUNICODE_STRING DestinationString,
	_In_ PCUNICODE_STRING SourceString
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlAppendUnicodeToString(
	_In_ PUNICODE_STRING Destination,
	_In_opt_ PCWSTR Source
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlAnsiStringToUnicodeString(
	_Inout_ PUNICODE_STRING DestinationString,
	_In_ PANSI_STRING SourceString,
	_In_ BOOLEAN AllocateDestinationString
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlUnicodeStringToAnsiString(
	_Inout_ PANSI_STRING DestinationString,
	_In_ PUNICODE_STRING SourceString,
	_In_ BOOLEAN AllocateDestinationString
	);

NTSYSAPI
CHAR
NTAPI
RtlUpperChar(
	_In_ CHAR Character
	);

_Must_inspect_result_
NTSYSAPI
BOOLEAN
NTAPI
RtlPrefixString(
	_In_ PSTRING String1,
	_In_ PSTRING String2,
	_In_ BOOLEAN CaseInSensitive
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlAppendStringToString(
	_In_ PSTRING Destination,
	_In_ PSTRING Source
	);

NTSYSAPI
VOID
NTAPI
RtlUpperString(
	_In_ PSTRING DestinationString,
	_In_ PSTRING SourceString
	);

NTSYSAPI
VOID
NTAPI
RtlFreeAnsiString(
	_Inout_ PANSI_STRING AnsiString
	);

NTSYSAPI
VOID
NTAPI
RtlFreeUnicodeString(
	_In_ PUNICODE_STRING UnicodeString
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlUnicodeStringToInteger(
	_In_ PCUNICODE_STRING String,
	_In_opt_ ULONG Base,
	_Out_ PULONG Value
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlDefaultNpAcl(
	_Out_ PACL *Dacl
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCreateRegistryKey(
	_In_ ULONG RelativeTo,
	_In_ PWSTR Path
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlQueryRegistryValues(
	_In_ ULONG RelativeTo,
	_In_ PCWSTR Path,
	_Inout_ PRTL_QUERY_REGISTRY_TABLE QueryTable,
	_In_opt_ PVOID Context,
	_In_opt_ PVOID Environment
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlWriteRegistryValue(
	_In_ ULONG RelativeTo,
	_In_ PCWSTR Path,
	_In_ PCWSTR ValueName,
	_In_ ULONG ValueType,
	_In_opt_ PVOID ValueData,
	_In_ ULONG ValueLength
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCreateEnvironment(
	_In_ BOOLEAN CloneCurrentEnvironment,
	_Out_ PVOID *Environment
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
NTSTATUS
NTAPI
RtlCreateEnvironmentEx(
	_In_ PVOID SourceEnv,
	_Out_ PVOID *Environment,
	_In_ ULONG Flags
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlDestroyEnvironment(
	_In_ PVOID Environment
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSetCurrentEnvironment(
	_In_ PVOID Environment,
	_Out_opt_ PVOID *PreviousEnvironment
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
NTSTATUS
NTAPI
RtlSetEnvironmentVar(
	_In_opt_ PWSTR *Environment,
	_In_ PWSTR Name,
	_In_ SIZE_T NameLength,
	_In_ PWSTR Value,
	_In_ SIZE_T ValueLength
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlSetEnvironmentVariable(
	_In_opt_ PVOID *Environment,
	_In_ PUNICODE_STRING Name,
	_In_ PUNICODE_STRING Value
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
NTSTATUS
NTAPI
RtlQueryEnvironmentVariable(
	_In_opt_ PVOID Environment,
	_In_ PWSTR Name,
	_In_ SIZE_T NameLength,
	_Out_ PWSTR Value,
	_In_ SIZE_T ValueLength,
	_Out_ PSIZE_T ReturnLength
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlQueryEnvironmentVariable_U(
	_In_opt_ PVOID Environment,
	_In_ PUNICODE_STRING Name,
	_Out_ PUNICODE_STRING Value
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
NTSTATUS
NTAPI
RtlExpandEnvironmentStrings(
	_In_opt_ PVOID Environment,
	_In_ PWSTR Src,
	_In_ SIZE_T SrcLength,
	_Out_ PWSTR Dst,
	_In_ SIZE_T DstLength,
	_Out_opt_ PSIZE_T ReturnLength
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlExpandEnvironmentStrings_U(
	_In_opt_ PVOID Environment,
	_In_ PUNICODE_STRING Source,
	_Out_ PUNICODE_STRING Destination,
	_Out_opt_ PULONG ReturnedLength
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSAPI
NTSTATUS
NTAPI
RtlSetEnvironmentStrings(
	_In_ PWCHAR NewEnvironment,
	_In_ SIZE_T NewEnvironmentSize
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlCreateProcessParameters(
	_Out_ PRTL_USER_PROCESS_PARAMETERS *pProcessParameters,
	_In_ PUNICODE_STRING ImagePathName,
	_In_opt_ PUNICODE_STRING DllPath,
	_In_opt_ PUNICODE_STRING CurrentDirectory,
	_In_opt_ PUNICODE_STRING CommandLine,
	_In_opt_ PVOID Environment,
	_In_opt_ PUNICODE_STRING WindowTitle,
	_In_opt_ PUNICODE_STRING DesktopInfo,
	_In_opt_ PUNICODE_STRING ShellInfo,
	_In_opt_ PUNICODE_STRING RuntimeData
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
NTSTATUS
NTAPI
RtlCreateProcessParametersEx(
	_Out_ PRTL_USER_PROCESS_PARAMETERS *pProcessParameters,
	_In_ PUNICODE_STRING ImagePathName,
	_In_opt_ PUNICODE_STRING DllPath,
	_In_opt_ PUNICODE_STRING CurrentDirectory,
	_In_opt_ PUNICODE_STRING CommandLine,
	_In_opt_ PVOID Environment,
	_In_opt_ PUNICODE_STRING WindowTitle,
	_In_opt_ PUNICODE_STRING DesktopInfo,
	_In_opt_ PUNICODE_STRING ShellInfo,
	_In_opt_ PUNICODE_STRING RuntimeData,
	_In_ ULONG Flags // Pass RTL_USER_PROCESS_PARAMETERS_NORMALIZED to keep parameters normalized
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlDestroyProcessParameters(
	_In_ PRTL_USER_PROCESS_PARAMETERS ProcessParameters
	);

NTSYSAPI
PRTL_USER_PROCESS_PARAMETERS
NTAPI
RtlNormalizeProcessParams(
	_Inout_ PRTL_USER_PROCESS_PARAMETERS ProcessParameters
	);

NTSYSAPI
PRTL_USER_PROCESS_PARAMETERS
NTAPI
RtlDeNormalizeProcessParams(
	_Inout_ PRTL_USER_PROCESS_PARAMETERS ProcessParameters
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCreateUserProcess(
	_In_ PUNICODE_STRING NtImagePathName,
	_In_ ULONG AttributesDeprecated,
	_In_ PRTL_USER_PROCESS_PARAMETERS ProcessParameters,
	_In_opt_ PSECURITY_DESCRIPTOR ProcessSecurityDescriptor,
	_In_opt_ PSECURITY_DESCRIPTOR ThreadSecurityDescriptor,
	_In_opt_ HANDLE ParentProcess,
	_In_ BOOLEAN InheritHandles,
	_In_opt_ HANDLE DebugPort,
	_In_opt_ HANDLE TokenHandle, // used to be ExceptionPort
	_Out_ PRTL_USER_PROCESS_INFORMATION ProcessInformation
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCreateUserThread(
	_In_ HANDLE Process,
	_In_opt_ PSECURITY_DESCRIPTOR ThreadSecurityDescriptor,
	_In_ BOOLEAN CreateSuspended,
	_In_opt_ ULONG ZeroBits,
	_In_opt_ SIZE_T MaximumStackSize,
	_In_opt_ SIZE_T CommittedStackSize,
	_In_ PUSER_THREAD_START_ROUTINE StartAddress,
	_In_opt_ PVOID Parameter,
	_Out_opt_ PHANDLE Thread,
	_Out_opt_ PCLIENT_ID ClientId
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlExitUserThread(
	_In_ NTSTATUS ExitStatus
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlDosApplyFileIsolationRedirection_Ustr(
	_In_ ULONG Flags,
	_In_ PUNICODE_STRING OriginalName,
	_In_ PUNICODE_STRING Extension,
	_Inout_ PUNICODE_STRING StaticString,
	_Inout_ PUNICODE_STRING DynamicString,
	_Inout_ PUNICODE_STRING *NewName,
	_In_ PULONG NewFlags,
	_In_ PSIZE_T FileNameSize,
	_In_ PSIZE_T RequiredLength
	);

NTSYSAPI
PIMAGE_NT_HEADERS
NTAPI
RtlImageNtHeader(
	_In_ PVOID ImageBase
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSAPI
NTSTATUS
NTAPI
RtlImageNtHeaderEx(
	_In_opt_ ULONG Flags,
	_In_ PVOID Base,
	_In_ ULONG64 Size,
	_Out_ PIMAGE_NT_HEADERS *OutHeaders
	);
#endif

NTSYSAPI
PVOID
NTAPI
RtlImageDirectoryEntryToData(
	_In_ PVOID ImageBase,
	_In_ BOOLEAN MappedAsImage,
	_In_ USHORT DirectoryEntry,
	_Out_ PULONG Size
	);

NTSYSAPI
PVOID
NTAPI
RtlPcToFileHeader(
	_In_ PVOID PcValue,
	_Out_ PVOID *BaseOfImage
	);

NTSYSAPI
PVOID
NTAPI
RtlAddressInSectionTable(
	_In_ PIMAGE_NT_HEADERS NtHeaders,
	_In_ PVOID BaseOfImage,
	_In_ ULONG VirtualAddress
	);

NTSYSAPI
PIMAGE_SECTION_HEADER
NTAPI
RtlImageRvaToSection(
	_In_ PIMAGE_NT_HEADERS NtHeaders,
	_In_ PVOID Base,
	_In_ ULONG Rva
	);

NTSYSAPI
PVOID
NTAPI
RtlImageRvaToVa(
	_In_ PIMAGE_NT_HEADERS NtHeaders,
	_In_ PVOID Base,
	_In_ ULONG Rva,
	_Inout_opt_ PIMAGE_SECTION_HEADER *LastRvaSection
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlQueryProcessHeapInformation(
	_Inout_ PRTL_DEBUG_INFORMATION Buffer
	);

NTSYSAPI
PRTL_DEBUG_INFORMATION
NTAPI
RtlCreateQueryDebugBuffer(
	_In_opt_ ULONG MaximumCommit,
	_In_ BOOLEAN UseEventPair
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlQueryProcessDebugInformation(
	_In_ HANDLE UniqueProcessId,
	_In_ ULONG Flags,
	_Inout_ PRTL_DEBUG_INFORMATION Buffer
	);

#ifdef _WIN64
NTSYSAPI
VOID
WINAPI
RtlRestoreContext(
	_In_ PCONTEXT ContextRecord,
	_In_opt_ PEXCEPTION_RECORD ExceptionRecord
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlAdjustPrivilege(
	_In_ ULONG Privilege,
	_In_ BOOLEAN Enable,
	_In_ BOOLEAN Client,
	_Out_ PBOOLEAN WasEnabled
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSAPI
NTSTATUS
NTAPI
RtlAcquirePrivilege(
	_In_ PULONG Privilege,
	_In_ ULONG NumPriv,
	_In_ ULONG Flags,
	_Out_ PVOID *ReturnedState
	);

NTSYSAPI
VOID
NTAPI
RtlReleasePrivilege(
	_In_ PVOID StatePointer
	);
#endif

NTSYSAPI
BOOLEAN
NTAPI
RtlDosPathNameToNtPathName_U(
	_In_ PCWSTR DosFileName,
	_Out_ PUNICODE_STRING NtFileName,
	_Out_opt_ PWSTR *FilePart,
	_Reserved_ PVOID Reserved
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSAPI
BOOLEAN
NTAPI
RtlDosPathNameToRelativeNtPathName_U(
	_In_ PCWSTR DosFileName,
	_Out_ PUNICODE_STRING NtFileName,
	_Out_opt_ PWSTR *FilePart,
	_Out_opt_ PRTL_RELATIVE_NAME_U RelativeName
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlDosPathNameToRelativeNtPathName_U_WithStatus(
	_In_ PWSTR DosFileName,
	_Out_ PUNICODE_STRING NtFileName,
	_Out_opt_ PWSTR *FilePart,
	_Out_opt_ PRTL_RELATIVE_NAME_U RelativeName
	);
#endif

NTSYSAPI
RTL_PATH_TYPE
NTAPI
RtlDetermineDosPathNameType_U(
	_In_ PCWSTR Path
	);

NTSYSAPI
ULONG
NTAPI
RtlIsDosDeviceName_U(
	_In_ PWSTR DosFileName
	);

NTSYSAPI
ULONG
NTAPI
RtlGetFullPathName_U(
	_In_ PWSTR FileName,
	_In_ ULONG BufferLength,
	_Out_ PWSTR Buffer,
	_Out_opt_ PWSTR *FilePart
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSAPI
NTSTATUS
NTAPI
RtlGetFullPathName_UEx(
	_In_ PWSTR FileName,
	_In_ ULONG BufferLength,
	_Out_writes_bytes_(BufferLength) PWSTR Buffer,
	_Out_opt_ PWSTR *FilePart,
	_Out_opt_ RTL_PATH_TYPE *InputPathType
	);
#endif

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSAPI
NTSTATUS
NTAPI
RtlGetFullPathName_UstrEx(
	_In_ PUNICODE_STRING FileName,
	_In_opt_ PUNICODE_STRING StaticString,
	_In_opt_ PUNICODE_STRING DynamicString,
	_Out_opt_ PUNICODE_STRING *StringUsed,
	_Out_opt_ PSIZE_T FilePartSize,
	_Out_opt_ PBOOLEAN NameInvalid,
	_Out_ RTL_PATH_TYPE* PathType,
	_Out_opt_ PSIZE_T LengthNeeded
	);
#endif

NTSYSAPI
ULONG
NTAPI
RtlGetCurrentDirectory_U(
	_In_ ULONG BufferLength,
	_Out_writes_bytes_(BufferLength) PWSTR Buffer
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSetCurrentDirectory_U(
	_In_ PUNICODE_STRING PathName
	);

#if NTDDI_VERSION >= NTDDI_WS03
NTSYSAPI
VOID
NTAPI
RtlReleaseRelativeName(
	_In_ PRTL_RELATIVE_NAME_U RelativeName
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
RtlNtPathNameToDosPathName(
	_In_ ULONG Flags,
	_Inout_ PRTL_UNICODE_STRING_BUFFER Path,
	_Out_opt_ PULONG Disposition,
	_Inout_opt_ PWSTR* FilePart
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
VOID
NTAPI
RtlInitializeSRWLock(
	_Out_ PRTL_SRWLOCK SRWLock
	);

NTSYSAPI
VOID
NTAPI
RtlAcquireSRWLockExclusive(
	_Inout_ PRTL_SRWLOCK SRWLock
	);

NTSYSAPI
VOID
NTAPI
RtlAcquireSRWLockShared(
	_Inout_ PRTL_SRWLOCK SRWLock
	);

NTSYSAPI
VOID
NTAPI
RtlReleaseSRWLockExclusive(
	_Inout_ PRTL_SRWLOCK SRWLock
	);

NTSYSAPI
VOID
NTAPI
RtlReleaseSRWLockShared(
	_Inout_ PRTL_SRWLOCK SRWLock
	);
#endif

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSAPI
BOOLEAN
NTAPI
RtlTryAcquireSRWLockExclusive(
	_Inout_ PRTL_SRWLOCK SRWLock
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlTryAcquireSRWLockShared(
	_Inout_ PRTL_SRWLOCK SRWLock
	);

NTSYSAPI
VOID
NTAPI
RtlAcquireReleaseSRWLockExclusive(
	_Inout_ PRTL_SRWLOCK SRWLock
	);
#endif

NTSYSAPI
ULONG
NTAPI
RtlWalkFrameChain(
	_Out_ PVOID *Callers,
	_In_ ULONG Count,
	_In_ ULONG Flags
	);

NTSYSAPI
PPREFIX_TABLE_ENTRY
NTAPI
PfxFindPrefix(
	_In_ PPREFIX_TABLE PrefixTable,
	_In_ PANSI_STRING FullName
	);

NTSYSAPI
VOID
NTAPI
PfxInitialize(
	_Out_ PPREFIX_TABLE PrefixTable
	);

NTSYSAPI
BOOLEAN
NTAPI
PfxInsertPrefix(
	_In_ PPREFIX_TABLE PrefixTable,
	_In_ PANSI_STRING Prefix,
	_Out_ PPREFIX_TABLE_ENTRY PrefixTableEntry
	);

NTSYSAPI
VOID
NTAPI
PfxRemovePrefix(
	_In_ PPREFIX_TABLE PrefixTable,
	_In_ PPREFIX_TABLE_ENTRY PrefixTableEntry
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlAbsoluteToSelfRelativeSD(
	_In_ PSECURITY_DESCRIPTOR AbsoluteSecurityDescriptor,
	_Out_ PSECURITY_DESCRIPTOR SelfRelativeSecurityDescriptor,
	_Inout_ PULONG BufferLength
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlAddAccessAllowedAce(
	_Inout_ PACL Acl,
	_In_ ULONG AceRevision,
	_In_ ACCESS_MASK AccessMask,
	_In_ PSID Sid
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlAddAccessAllowedAceEx(
	_Inout_ PACL Acl,
	_In_ ULONG AceRevision,
	_In_ ULONG AceFlags,
	_In_ ACCESS_MASK AccessMask,
	_In_ PSID Sid
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlAddAce(
	_Inout_ PACL Acl,
	_In_ ULONG AceRevision,
	_In_ ULONG StartingAceIndex,
	_In_ PVOID AceList,
	_In_ ULONG AceListLength
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlAddAtomToAtomTable(
	_In_ PVOID AtomTableHandle,
	_In_ PWSTR AtomName,
	_Inout_opt_ PRTL_ATOM Atom
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlAppendUnicodeStringToString(
	PUNICODE_STRING Destination,
	PCUNICODE_STRING Source
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlAreAllAccessesGranted(
	_In_ ACCESS_MASK GrantedAccess,
	_In_ ACCESS_MASK DesiredAccess
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlAreAnyAccessesGranted(
	_In_ ACCESS_MASK GrantedAccess,
	_In_ ACCESS_MASK DesiredAccess
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlAreBitsClear(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG StartingIndex,
	_In_ ULONG Length
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlAreBitsSet(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG StartingIndex,
	_In_ ULONG Length
	);

NTSYSAPI
VOID
NTAPI
RtlCaptureContext(
	_Out_ PCONTEXT ContextRecord
	);

NTSYSAPI
_Success_(return != 0)
USHORT
NTAPI
RtlCaptureStackBackTrace(
	_In_ ULONG FramesToSkip,
	_In_ ULONG FramesToCapture,
	_Out_writes_to_(FramesToCapture, return) PVOID *BackTrace,
	_Out_opt_ PULONG BackTraceHash
	);

NTSYSAPI
VOID
NTAPI
RtlClearAllBits(
	_In_ PRTL_BITMAP BitMapHeader
	);

NTSYSAPI
VOID
NTAPI
RtlClearBits(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG StartingIndex,
	_In_ ULONG NumberToClear
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCreateSystemVolumeInformationFolder(
	_In_ PCUNICODE_STRING VolumeRootPath
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
LONG
NTAPI
RtlCompareAltitudes(
	_In_ PCUNICODE_STRING Altitude1,
	_In_ PCUNICODE_STRING Altitude2
	);
#endif

NTSYSAPI
LONG
NTAPI
RtlCompareUnicodeString(
	_In_ PCUNICODE_STRING String1,
	_In_ PCUNICODE_STRING String2,
	_In_ BOOLEAN CaseInSensitive
	);

NTSYSAPI
ULONG32
NTAPI
RtlComputeCrc32(
	_In_ ULONG32 PartialCrc,
	_In_ PVOID Buffer,
	_In_ ULONG Length
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlConvertSidToUnicodeString(
	_Inout_ PUNICODE_STRING UnicodeString,
	_In_ PSID Sid,
	_In_ BOOLEAN AllocateDestinationString
	);

NTSYSAPI
VOID
NTAPI
RtlCopyLuid(
	_Out_ PLUID DestinationLuid,
	_In_ PLUID SourceLuid
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlAllocateAndInitializeSid(
	_In_ PSID_IDENTIFIER_AUTHORITY IdentifierAuthority,
	_In_ UCHAR SubAuthorityCount,
	_In_ ULONG SubAuthority0,
	_In_ ULONG SubAuthority1,
	_In_ ULONG SubAuthority2,
	_In_ ULONG SubAuthority3,
	_In_ ULONG SubAuthority4,
	_In_ ULONG SubAuthority5,
	_In_ ULONG SubAuthority6,
	_In_ ULONG SubAuthority7,
	_Outptr_ PSID *Sid
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCopySid(
	_In_ ULONG DestinationSidLength,
	_Out_ PSID DestinationSid,
	_In_ PSID SourceSid
	);

NTSYSAPI
PVOID
NTAPI
RtlFreeSid(
	_Inout_ PSID Sid
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCreateAcl(
	_Out_ PACL Acl,
	_In_ ULONG AclLength,
	_In_ ULONG AclRevision
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCreateAtomTable(
	_In_ ULONG NumberOfBuckets,
	_Out_ PVOID *AtomTableHandle
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlDecompressFragment(
	_In_ USHORT CompressionFormat,
	_Out_ PUCHAR UncompressedFragment,
	_In_ ULONG UncompressedFragmentSize,
	_In_ PUCHAR CompressedBuffer,
	_In_ ULONG CompressedBufferSize,
	_In_ ULONG FragmentOffset,
	_Out_ PULONG FinalUncompressedSize,
	_In_ PVOID WorkSpace
	);

NTSYSAPI
PRTL_SPLAY_LINKS
NTAPI
RtlDelete(
	_In_ PRTL_SPLAY_LINKS Links
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlDeleteAce(
	_Inout_ PACL Acl,
	_In_ ULONG AceIndex
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlDeleteAtomFromAtomTable(
	_In_ PVOID AtomTableHandle,
	_In_ RTL_ATOM Atom
	);

NTSYSAPI
VOID
NTAPI
RtlDeleteNoSplay(
	_In_ PRTL_SPLAY_LINKS Links,
	_Inout_ PRTL_SPLAY_LINKS *Root
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlDowncaseUnicodeString(
	_Out_ PUNICODE_STRING DestinationString,
	_In_ PCUNICODE_STRING SourceString,
	_In_ BOOLEAN AllocateDestinationString
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlDuplicateUnicodeString(
	_In_ ULONG Flags,
	_In_ UNICODE_STRING *StringIn,
	_Out_ UNICODE_STRING *StringOut
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlEmptyAtomTable(
	_In_ PVOID AtomTableHandle,
	_In_ BOOLEAN IncludePinnedAtoms
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlEqualSid(
	_In_ PSID Sid1,
	_In_ PSID Sid2
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlEqualString(
	_In_ PANSI_STRING String1,
	_In_ PANSI_STRING String2,
	_In_ BOOLEAN CaseInSensitive
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlEqualUnicodeString(
	_In_ PCUNICODE_STRING String1,
	_In_ PCUNICODE_STRING String2,
	_In_ BOOLEAN CaseInSensitive
	);

NTSYSAPI
ULONG
NTAPI
RtlFindClearBits(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG NumberToFind,
	_In_ ULONG HintIndex
	);

NTSYSAPI
ULONG
NTAPI
RtlFindClearBitsAndSet(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG NumberToFind,
	_In_ ULONG HintIndex
	);

NTSYSAPI
ULONG
NTAPI
RtlFindClearRuns(
	_In_ PRTL_BITMAP BitMapHeader,
	_Out_ PRTL_BITMAP_RUN RunArray,
	_In_ ULONG SizeOfRunArray,
	_In_ BOOLEAN LocateLongestRuns
	);

NTSYSAPI
ULONG
NTAPI
RtlFindLastBackwardRunClear(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG FromIndex,
	_In_ PULONG StartingRunIndex
	);

NTSYSAPI
CCHAR
NTAPI
RtlFindLeastSignificantBit(
	_In_ ULONGLONG Set
	);

NTSYSAPI
ULONG
NTAPI
RtlFindLongestRunClear(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ PULONG StartingIndex
	);

NTSYSAPI
CCHAR
NTAPI
RtlFindMostSignificantBit(
	_In_ ULONGLONG Set
	);

NTSYSAPI
ULONG
NTAPI
RtlFindNextForwardRunClear(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG FromIndex,
	_In_ PULONG StartingRunIndex
	);

NTSYSAPI
ULONG
NTAPI
RtlFindSetBits(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG NumberToFind,
	_In_ ULONG HintIndex
	);

NTSYSAPI
ULONG
NTAPI
RtlFindSetBitsAndClear(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG NumberToFind,
	_In_ ULONG HintIndex
	);

NTSYSAPI
VOID
NTAPI
RtlGetCallersAddress(
	_Out_ PVOID *CallersAddress,
	_Out_ PVOID *CallersCaller
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlGetDaclSecurityDescriptor(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_Out_ PBOOLEAN DaclPresent,
	_Out_ PACL *Dacl,
	_Out_ PBOOLEAN DaclDefaulted
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlGetGroupSecurityDescriptor(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_Out_ PSID *Group,
	_Out_ PBOOLEAN GroupDefaulted
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlGetOwnerSecurityDescriptor(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_Out_ PSID *Owner,
	_Out_ PBOOLEAN OwnerDefaulted
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlGetSaclSecurityDescriptor(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_Out_ PBOOLEAN SaclPresent,
	_Out_ PACL *Sacl,
	_Out_ PBOOLEAN SaclDefaulted
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlGetSetBootStatusData(
	_In_ HANDLE Handle,
	_In_ BOOLEAN Get,
	_In_ RTL_BSD_ITEM_TYPE DataItem,
	_In_ PVOID DataBuffer,
	_In_ ULONG DataBufferLength,
	_Out_opt_ PULONG ByteRead
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCreateBootStatusDataFile(
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlGetVersion(
	_Out_ PRTL_OSVERSIONINFOW lpVersionInformation
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlGUIDFromString(
	_In_ PUNICODE_STRING GuidString,
	_Out_ GUID* Guid
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlHashUnicodeString(
	_In_ UNICODE_STRING *String,
	_In_ BOOLEAN CaseInSensitive,
	_In_ ULONG HashAlgorithm,
	_Out_ PULONG HashValue
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlInitializeSid(
	_Out_ PSID Sid,
	_In_ PSID_IDENTIFIER_AUTHORITY IdentifierAuthority,
	_In_ UCHAR SubAuthorityCount
	);

NTSYSAPI
ULONG
NTAPI
RtlLengthRequiredSid(
	_In_ ULONG SubAuthorityCount
	);

NTSYSAPI
ULONG
NTAPI
RtlLengthSecurityDescriptor(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor
	);

NTSYSAPI
ULONG
NTAPI
RtlLengthSid(
	_In_ PSID Sid
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlLockBootStatusData(
	_Out_ PHANDLE BootStatusDataHandle
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlLookupAtomInAtomTable(
	_In_ PVOID AtomTableHandle,
	_In_ PWSTR AtomName,
	_Out_opt_ PRTL_ATOM Atom
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlMapSecurityErrorToNtStatus(
	_In_ SECURITY_STATUS Error
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlMultiByteToUnicodeN(
	_Out_ PWCH UnicodeString,
	_In_ ULONG MaxBytesInUnicodeString,
	_Out_opt_ PULONG BytesInUnicodeString,
	_In_ PCSTR MultiByteString,
	_In_ ULONG BytesInMultiByteString
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlMultiByteToUnicodeSize(
	_Out_ PULONG BytesInUnicodeString,
	_In_ PCSTR MultiByteString,
	_In_ ULONG BytesInMultiByteString
	);

NTSYSAPI
ULONG
NTAPI
RtlNumberOfClearBits(
	_In_ PRTL_BITMAP BitMapHeader
	);

NTSYSAPI
ULONG
NTAPI
RtlNumberOfSetBits(
	_In_ PRTL_BITMAP BitMapHeader
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlQueryAtomInAtomTable(
	_In_ PVOID AtomTableHandle,
	_In_ RTL_ATOM Atom,
	_Out_opt_ PULONG AtomUsage,
	_Out_opt_ PULONG AtomFlags,
	_Inout_opt_ PWSTR AtomName,
	_Inout_opt_ PULONG AtomNameLength
	);

NTSYSAPI
PRTL_SPLAY_LINKS
NTAPI
RtlRealPredecessor(
	_In_ PRTL_SPLAY_LINKS Links
	);

NTSYSAPI
PRTL_SPLAY_LINKS
NTAPI
RtlRealSuccessor(
	_In_ PRTL_SPLAY_LINKS Links
	);

NTSYSAPI
VOID
NTAPI
RtlRunDecodeUnicodeString(
	_In_ UCHAR Seed,
	_Inout_ PUNICODE_STRING String
	);

NTSYSAPI
VOID
NTAPI
RtlRunEncodeUnicodeString(
	_In_opt_ PUCHAR Seed,
	_Inout_ PUNICODE_STRING String
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSelfRelativeToAbsoluteSD(
	_In_ PSECURITY_DESCRIPTOR SelfRelativeSecurityDescriptor,
	_Out_ PSECURITY_DESCRIPTOR AbsoluteSecurityDescriptor,
	_Inout_ PULONG AbsoluteSecurityDescriptorSize,
	_Out_ PACL Dacl,
	_Inout_ PULONG DaclSize,
	_Out_ PACL Sacl,
	_Inout_ PULONG SaclSize,
	_Out_opt_ PSID Owner,
	_Inout_ PULONG OwnerSize,
	_Out_opt_ PSID PrimaryGroup,
	_Inout_ PULONG PrimaryGroupSize
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSelfRelativeToAbsoluteSD2(
	_Inout_ PSECURITY_DESCRIPTOR pSelfRelativeSecurityDescriptor,
	_Inout_ PULONG pBufferSize
	);

NTSYSAPI
VOID
NTAPI
RtlSetAllBits(
	_In_ PRTL_BITMAP BitMapHeader
	);

NTSYSAPI
VOID
NTAPI
RtlSetBits(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG StartingIndex,
	_In_ ULONG NumberToSet
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSetDaclSecurityDescriptor(
	_Inout_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_In_ BOOLEAN DaclPresent,
	_In_opt_ PACL Dacl,
	_In_ BOOLEAN DaclDefaulted
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSetGroupSecurityDescriptor(
	_Inout_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_In_opt_ PSID Group,
	_In_opt_ BOOLEAN GroupDefaulted
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSetOwnerSecurityDescriptor(
	_Inout_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_In_opt_ PSID Owner,
	_In_ BOOLEAN OwnerDefaulted
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlSetSaclSecurityDescriptor(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_In_ BOOLEAN SaclPresent,
	_In_opt_ PACL Sacl,
	_In_opt_ BOOLEAN SaclDefaulted
	);

NTSYSAPI
PRTL_SPLAY_LINKS
NTAPI
RtlSplay(
	_Inout_ PRTL_SPLAY_LINKS Links
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlStringFromGUID(
	_In_ REFGUID Guid,
	_Out_ PUNICODE_STRING GuidString
	);

NTSYSAPI
PUCHAR
NTAPI
RtlSubAuthorityCountSid(
	_In_ PSID Sid
	);

NTSYSAPI
PULONG
NTAPI
RtlSubAuthoritySid(
	_In_ PSID Sid,
	_In_ ULONG SubAuthority
	);

NTSYSAPI
PRTL_SPLAY_LINKS
NTAPI
RtlSubtreePredecessor(
	_In_ PRTL_SPLAY_LINKS Links
	);

NTSYSAPI
PRTL_SPLAY_LINKS
NTAPI
RtlSubtreeSuccessor(
	_In_ PRTL_SPLAY_LINKS Links
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
BOOLEAN
NTAPI
RtlTestBit(
	_In_ PRTL_BITMAP BitMapHeader,
	_In_ ULONG BitNumber
	);
#endif

NTSYSAPI
VOID
NTAPI
RtlUnlockBootStatusData(
	_In_ HANDLE BootStatusDataHandle
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlCreateSecurityDescriptor(
	_Out_ PSECURITY_DESCRIPTOR SecurityDescriptor,
	_In_ ULONG Revision
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlValidRelativeSecurityDescriptor(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptorInput,
	_In_ ULONG SecurityDescriptorLength,
	_In_ SECURITY_INFORMATION RequiredInformation
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlValidSecurityDescriptor(
	_In_ PSECURITY_DESCRIPTOR SecurityDescriptor
	);

NTSYSAPI
BOOLEAN
NTAPI
RtlValidSid(
	_In_ PSID Sid
	);

NTSYSAPI
NTSTATUS
NTAPI
RtlVerifyVersionInfo(
	_In_ RTL_OSVERSIONINFOEXW VersionInfo,
	_In_ ULONG TypeMask,
	_In_ ULONGLONG ConditionMask
	);

NTSYSAPI
ULONGLONG
NTAPI
VerSetConditionMask(
	_In_ ULONGLONG ConditionMask,
	_In_ ULONG TypeMask,
	_In_ UCHAR Condition
	);

#if NTDDI_VERSION >= NTDDI_VISTA
NTSYSAPI
NTSTATUS
NTAPI
TpAllocPool(
	_Out_ PTP_POOL *PoolReturn,
	_Reserved_ PVOID Reserved
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSAPI
NTSTATUS
NTAPI
TpDisablePoolCallbackChecks(
	_Inout_ PTP_POOL Pool
	);
#endif

NTSYSAPI
VOID
NTAPI
TpReleasePool(
	_Inout_ PTP_POOL Pool
	);

NTSYSAPI
VOID
NTAPI
TpSetPoolMaxThreads(
	_Inout_ PTP_POOL Pool,
	_In_ LONG MaxThreads
	);

NTSYSAPI
NTSTATUS
NTAPI
TpSetPoolMinThreads(
	_Inout_ PTP_POOL Pool,
	_In_ LONG MinThreads
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSAPI
NTSTATUS
NTAPI
TpQueryPoolStackInformation(
	_In_ PTP_POOL Pool,
	_Out_ PTP_POOL_STACK_INFORMATION PoolStackInformation
	);

NTSYSAPI
NTSTATUS
NTAPI
TpSetPoolStackInformation(
	_Inout_ PTP_POOL Pool,
	_In_ PTP_POOL_STACK_INFORMATION PoolStackInformation
	);
#endif

NTSYSAPI
NTSTATUS
NTAPI
TpAllocCleanupGroup(
	_Out_ PTP_CLEANUP_GROUP *CleanupGroupReturn
	);

NTSYSAPI
VOID
NTAPI
TpReleaseCleanupGroup(
	_Inout_ PTP_CLEANUP_GROUP CleanupGroup
	);

NTSYSAPI
VOID
NTAPI
TpReleaseCleanupGroupMembers(
	_Inout_ PTP_CLEANUP_GROUP CleanupGroup,
	_In_ LOGICAL CancelPendingCallbacks,
	_Inout_opt_ PVOID CleanupParameter
	);

NTSYSAPI
NTSTATUS
NTAPI
TpSimpleTryPost(
	_In_ PTP_SIMPLE_CALLBACK Callback,
	_Inout_opt_ PVOID Context,
	_In_opt_ PTP_CALLBACK_ENVIRON CallbackEnviron
	);

NTSYSAPI
NTSTATUS
NTAPI
TpAllocWork(
	_Out_ PTP_WORK *WorkReturn,
	_In_ PTP_WORK_CALLBACK Callback,
	_Inout_opt_ PVOID Context,
	_In_opt_ PTP_CALLBACK_ENVIRON CallbackEnviron
	);

NTSYSAPI
VOID
NTAPI
TpReleaseWork(
	_Inout_ PTP_WORK Work
	);

NTSYSAPI
VOID
NTAPI
TpPostWork(
	_Inout_ PTP_WORK Work
	);

NTSYSAPI
VOID
NTAPI
TpWaitForWork(
	_Inout_ PTP_WORK Work,
	_In_ LOGICAL CancelPendingCallbacks
	);

NTSYSAPI
NTSTATUS
NTAPI
TpAllocTimer(
	_Out_ PTP_TIMER *Timer,
	_In_ PTP_TIMER_CALLBACK Callback,
	_Inout_opt_ PVOID Context,
	_In_opt_ PTP_CALLBACK_ENVIRON CallbackEnviron
	);

NTSYSAPI
VOID
NTAPI
TpReleaseTimer(
	_Inout_ PTP_TIMER Timer
	);

NTSYSAPI
VOID
NTAPI
TpSetTimer(
	_Inout_ PTP_TIMER Timer,
	_In_opt_ PLARGE_INTEGER DueTime,
	_In_ LONG Period,
	_In_opt_ LONG WindowLength
	);

NTSYSAPI
LOGICAL
NTAPI
TpIsTimerSet(
	_In_ PTP_TIMER Timer
	);

NTSYSAPI
VOID
NTAPI
TpWaitForTimer(
	_Inout_ PTP_TIMER Timer,
	_In_ LOGICAL CancelPendingCallbacks
	);

NTSYSAPI
NTSTATUS
NTAPI
TpAllocWait(
	_Out_ PTP_WAIT *WaitReturn,
	_In_ PTP_WAIT_CALLBACK Callback,
	_Inout_opt_ PVOID Context,
	_In_opt_ PTP_CALLBACK_ENVIRON CallbackEnviron
	);

NTSYSAPI
VOID
NTAPI
TpReleaseWait(
	_Inout_ PTP_WAIT Wait
	);

NTSYSAPI
VOID
NTAPI
TpSetWait(
	_Inout_ PTP_WAIT Wait,
	_In_opt_ HANDLE Handle,
	_In_opt_ PLARGE_INTEGER Timeout
	);

NTSYSAPI
NTSTATUS
NTAPI
TpAllocIoCompletion(
	_Out_ PTP_IO *IoReturn,
	_In_ HANDLE File,
	_In_ PTP_IO_CALLBACK Callback,
	_Inout_opt_ PVOID Context,
	_In_opt_ PTP_CALLBACK_ENVIRON CallbackEnviron
	);

NTSYSAPI
VOID
NTAPI
TpWaitForIoCompletion(
	_Inout_ PTP_IO Io,
	_In_ LOGICAL CancelPendingCallbacks
	);

NTSYSAPI
NTSTATUS
NTAPI
TpAllocAlpcCompletion(
	_Out_ PTP_ALPC *AlpcReturn,
	_In_ HANDLE AlpcPort,
	_In_ PTP_ALPC_CALLBACK Callback,
	_Inout_opt_ PVOID Context,
	_In_opt_ PTP_CALLBACK_ENVIRON CallbackEnviron
	);

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSAPI
NTSTATUS
NTAPI
TpAllocAlpcCompletionEx(
	_Out_ PTP_ALPC *AlpcReturn,
	_In_ HANDLE AlpcPort,
	_In_ PTP_ALPC_CALLBACK_EX Callback,
	_Inout_opt_ PVOID Context,
	_In_opt_ PTP_CALLBACK_ENVIRON CallbackEnviron
	);
#endif

NTSYSAPI
VOID
NTAPI
TpReleaseAlpcCompletion(
	_Inout_ PTP_ALPC Alpc
	);

NTSYSAPI
VOID
NTAPI
TpWaitForAlpcCompletion(
	_Inout_ PTP_ALPC Alpc
	);
#endif

#if NTDDI_VERSION >= NTDDI_WIN7
NTSYSAPI
NTSTATUS
NTAPI
TpAlpcRegisterCompletionList(
	_Inout_ PTP_ALPC Alpc
	);

NTSYSAPI
NTSTATUS
NTAPI
TpAlpcUnregisterCompletionList(
	_Inout_ PTP_ALPC Alpc
	);
#endif

#ifdef __cplusplus
}
#endif

#endif // _NTDLL_H
