/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2024 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

/**
 * @module ui/form
 */

import type { IUIButton, IUIInput, IViewBased } from 'jodit/types';
import { component } from 'jodit/core/decorators/component/component';
import { UIButton } from 'jodit/core/ui/button/button/button';
import { UIInput } from 'jodit/core/ui/form/inputs/input/input';

import './file.less';

@component
export class UIFileInput extends UIInput {
	private button!: IUIButton;

	override state: UIInput['state'] & {
		onlyImages: boolean;
		tooltip?: string;
	} = {
		...UIInput.defaultState,
		type: 'file',
		onlyImages: true
	};

	/** @override */
	override className(): string {
		return 'UIFileInput';
	}

	protected override createContainer(
		options: Partial<this['state']>
	): HTMLElement {
		this.button = new UIButton(this.j, {
			tooltip: options.tooltip,
			icon: {
				name: 'plus'
			}
		});

		const { container } = this.button;

		if (!this.nativeInput) {
			this.nativeInput = this.createNativeInput(options);
		}

		const { nativeInput } = this;

		nativeInput.classList.add(this.getFullElName('input'));
		container.classList.add(this.componentName);
		container.appendChild(nativeInput);

		return container;
	}

	protected override createNativeInput(
		options: Partial<this['state']>
	): IUIInput['nativeInput'] {
		return this.j.create.fromHTML(`<input
			type="file"
			accept="${options.onlyImages ? 'image/*' : '*'}"
			tabindex="-1"
			dir="auto"
			multiple=""
		/>`) as HTMLInputElement;
	}

	constructor(jodit: IViewBased, options: Partial<UIFileInput['state']>) {
		super(jodit, {
			type: 'file',
			...options
		});
	}
}
